/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private char delimiter;
    private char[] inputChars;
    private String inputText;
    private int startPosition;
    private boolean hasMoreTokens;

    public StringTokenizer(String input, char delimiter) {
        this.reset(input, delimiter);
    }

    public void reset(String input, char delim) {
        this.inputText = input;
        this.delimiter = delim;
        this.inputChars = input.toCharArray();
        this.updateTokenStartPosition(input, this.inputChars, delim);
    }

    protected void updateTokenStartPosition(String input, char[] chars, char delim) {
        while (this.startPosition < chars.length) {
            char c2 = chars[this.startPosition];
            if (c2 != delim) {
                this.hasMoreTokens = true;
                return;
            }
            ++this.startPosition;
        }
        this.hasMoreTokens = false;
    }

    public boolean hasMoreTokens() {
        return this.hasMoreTokens;
    }

    public String nextToken() {
        int position;
        if (!this.hasMoreTokens) {
            throw new NoSuchElementException();
        }
        int length = this.inputChars.length;
        for (position = this.startPosition + 1; position < length && this.inputChars[position] != this.delimiter; ++position) {
        }
        if (position >= length) {
            String value = this.inputText.substring(this.startPosition);
            this.startPosition = position++;
            this.updateTokenStartPosition(this.inputText, this.inputChars, this.delimiter);
            return value;
        }
        String value = this.inputText.substring(this.startPosition, position);
        this.startPosition = position++;
        this.updateTokenStartPosition(this.inputText, this.inputChars, this.delimiter);
        return value;
    }

    public int countTokens() {
        int position;
        int length = this.inputChars.length;
        int number = 0;
        int lastPosition = position - 1;
        char c2 = this.delimiter;
        for (position = this.startPosition; position < length; ++position) {
            c2 = this.inputChars[position];
            if (c2 != this.delimiter) continue;
            if (position > lastPosition + 1) {
                ++number;
            }
            lastPosition = position;
        }
        if (c2 != this.delimiter) {
            ++number;
        }
        return number;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }
}

