/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.ApplicationData;
import baltorogames.core.VectorF2;
import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.Graphic2D;
import baltorogames.graphic2d.TextureManager;
import baltorogames.project_gameplay.CGBallShooter;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.CGHit;
import baltorogames.project_gameplay.WorldObject;

public class CGEngineRenderer {
    private static float LENGTH_OF_CAOON_LINE = ApplicationData.screenHeight / 2;
    private static int NUM_CANNON_LINE_SEGMENTS = 5;
    private static float CANON_ANIM_SPEED_DIV = 200.0f;
    public static float m_fBoardStartY = 0.0f;
    public static float m_fScreenOffsetX = 0.0f;
    public static float m_fScreenOffsetY = 0.0f;
    public static CGTexture[] m_Textures = new CGTexture[12];
    public static CGTexture[][] m_boundaries = new CGTexture[3][3];
    public static CGTexture[] m_canonLine = new CGTexture[4];
    public static CGTexture m_SpaceShipTexture;
    public static CGTexture m_SpaceShipSpotTexture;
    public static CGTexture markerForCanonLine;
    public static float middleX;
    static VectorF2 vOut;
    protected static VectorF2 vDir;
    private static float cannonLineTime;

    public static void Init() {
        markerForCanonLine = TextureManager.AddTexture("/gameplay/marker.png");
        CGEngineRenderer.m_Textures[0] = TextureManager.AddTexture("/gameplay/roll_ball1.png");
        CGEngineRenderer.m_Textures[1] = TextureManager.AddTexture("/gameplay/roll_ball2.png");
        CGEngineRenderer.m_Textures[2] = TextureManager.AddTexture("/gameplay/roll_ball3.png");
        CGEngineRenderer.m_Textures[3] = TextureManager.AddTexture("/gameplay/roll_ball4.png");
        CGEngineRenderer.m_Textures[4] = TextureManager.AddTexture("/gameplay/roll_ball5.png");
        CGEngineRenderer.m_Textures[5] = TextureManager.AddTexture("/gameplay/roll_ball6.png");
        CGEngineRenderer.m_Textures[6] = TextureManager.AddTexture("/gameplay/bomb_ball.png");
        CGEngineRenderer.m_Textures[7] = TextureManager.AddTexture("/gameplay/time_ball.png");
        CGEngineRenderer.m_Textures[8] = TextureManager.AddTexture("/gameplay/rainbow_ball.png");
        CGEngineRenderer.m_Textures[9] = TextureManager.AddTexture("/gameplay/fire_ball.png");
        CGEngineRenderer.m_Textures[10] = TextureManager.AddTexture("/gameplay/wall_ball.png");
        CGEngineRenderer.m_Textures[11] = TextureManager.AddTexture("/gameplay/item_ball.png");
        m_SpaceShipTexture = TextureManager.AddTexture("/gameplay/spaceship.png");
        for (int i = 0; i < m_boundaries.length; ++i) {
            CGEngineRenderer.m_boundaries[i][0] = TextureManager.AddTexture("/gameplay/border" + (i + 1) + "_left.png");
            CGEngineRenderer.m_boundaries[i][1] = TextureManager.AddTexture("/gameplay/border" + (i + 1) + "_right.png");
            CGEngineRenderer.m_boundaries[i][2] = TextureManager.AddTexture("/gameplay/border" + (i + 1) + "_top.png");
        }
        CGEngineRenderer.m_canonLine[0] = TextureManager.AddTexture("/gameplay/hud_aim_1.png");
        CGEngineRenderer.m_canonLine[1] = TextureManager.AddTexture("/gameplay/hud_aim_2.png");
        CGEngineRenderer.m_canonLine[2] = TextureManager.AddTexture("/gameplay/hud_aim_3.png");
        CGEngineRenderer.m_canonLine[3] = m_canonLine[1];
    }

    public static void RenderCannon() {
        float fAdd;
        if (CGEngine.m_BallCannon == null) {
            return;
        }
        Graphic2D.DrawCenter(m_SpaceShipTexture, (int)(CGEngine.m_BallCannon.m_fPosX * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)((CGEngine.m_BallCannon.m_fPosY + m_fBoardStartY) * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
        if (ApplicationData.isLeftPressed()) {
            fAdd = 180.0f * (float)ApplicationData.stepDeltaTime / 2000.0f;
            if (!(CGEngine.m_BallCannon.m_fCurrentAngle < -75.0f)) {
                CGEngine.m_BallCannon.m_fCurrentAngle -= fAdd;
            }
        } else if (ApplicationData.isRightPressed()) {
            fAdd = 180.0f * (float)ApplicationData.stepDeltaTime / 2000.0f;
            if (!(CGEngine.m_BallCannon.m_fCurrentAngle > 75.0f)) {
                CGEngine.m_BallCannon.m_fCurrentAngle += fAdd;
            }
        }
        VectorF2.VectorFromAngle(CGEngine.m_BallCannon.m_fCurrentAngle, vDir);
        int x1 = (int)(CGEngine.m_BallCannon.m_fPosX * CGEngine.m_fEngineScale);
        int y1 = (int)((CGEngine.m_BallCannon.m_fPosY + m_fBoardStartY) * CGEngine.m_fEngineScale);
        int x2 = (int)((float)x1 - LENGTH_OF_CAOON_LINE * CGEngineRenderer.vDir.x);
        int y2 = (int)((float)y1 - LENGTH_OF_CAOON_LINE * CGEngineRenderer.vDir.y);
        if (!ApplicationData.isTouchScreen) {
            CGEngineRenderer.DrawCanonBallLine(x1 + (int)m_fScreenOffsetX, y1 + (int)m_fScreenOffsetY, x2 + (int)m_fScreenOffsetX, y2 + (int)m_fScreenOffsetY);
        }
        if (CGEngine.m_MenObject != null && CGEngine.m_MenObject.m_nStartTime < 0) {
            Graphic2D.DrawCenter(m_Textures[CGEngine.m_BallCannon.m_nColor - '\u0001'], (int)(CGEngine.m_BallCannon.m_fPosX * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)((CGEngine.m_BallCannon.m_fPosY + m_fBoardStartY) * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
        }
        for (int i = 0; i < CGEngine.m_BallCannon.m_arrShooters.size(); ++i) {
            CGBallShooter m_BallShooter = (CGBallShooter)CGEngine.m_BallCannon.m_arrShooters.elementAt(i);
            Graphic2D.DrawCenter(m_Textures[m_BallShooter.m_nColor - '\u0001'], (int)(m_BallShooter.m_fBallX * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)((m_BallShooter.m_fBallY + m_fBoardStartY) * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
        }
        if (CGEngine.m_BallObject != null && CGEngine.m_MenObject != null && CGEngine.m_MenObject.m_nStartTime < 0) {
            float xx = CGEngine.m_BallObject.m_fX + CGEngine.m_BallObject.m_fW / 2;
            float yy = CGEngine.m_BallObject.m_fY + CGEngine.m_BallObject.m_fH / 2;
            char nC = CGEngine.m_BallCannon.m_nNextColor;
            Graphic2D.DrawCenter(m_Textures[nC - '\u0001'], (int)(xx * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)(yy * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
        }
    }

    private static void DrawCanonBallLine(int x1, int y1, int x2, int y2) {
        float h;
        float A;
        float H;
        float minA;
        int add = 0;
        int x3 = 0;
        int y3 = 0;
        float deltaX = x2 - x1;
        float deltaY = y2 - y1;
        float l = deltaX * deltaX + deltaY * deltaY;
        l = (float)Math.sqrt(l);
        deltaX /= l;
        deltaY /= l;
        Graphic2D.SetColor(0xFFFFFF);
        cannonLineTime += (float)ApplicationData.stepDeltaTime / CANON_ANIM_SPEED_DIV;
        for (int i = 0; i < NUM_CANNON_LINE_SEGMENTS; ++i) {
            int x = (int)((float)x1 + deltaX * l * (float)i / (float)NUM_CANNON_LINE_SEGMENTS);
            int y = (int)((float)y1 + deltaY * l * (float)i / (float)NUM_CANNON_LINE_SEGMENTS);
            if (x <= m_boundaries[CGEngine.m_nCurrentGalaxy - 1][0].GetWidth() || x >= ApplicationData.screenWidth - m_boundaries[CGEngine.m_nCurrentGalaxy - 1][1].GetWidth()) continue;
            Graphic2D.DrawImage(m_canonLine[(i + (int)cannonLineTime) % 4], x, y, 3);
        }
        if (x2 < 0 + m_boundaries[CGEngine.m_nCurrentGalaxy - 1][0].GetWidth()) {
            minA = x1;
            H = y1 - y2;
            A = Math.abs(x2) + Math.abs(x1);
            h = H * minA / A;
            y3 = (int)((float)ApplicationData.screenHeight - ((float)(ApplicationData.screenHeight - y1) + h));
            x3 = m_boundaries[CGEngine.m_nCurrentGalaxy - 1][0].GetWidth();
            add = y1 - y3;
        } else if (x2 > ApplicationData.screenWidth - m_boundaries[CGEngine.m_nCurrentGalaxy - 1][1].GetWidth()) {
            minA = x1;
            H = y1 - y2;
            A = x2 - x1;
            h = H * minA / A;
            y3 = (int)((float)ApplicationData.screenHeight - ((float)(ApplicationData.screenHeight - y1) + h));
            x3 = ApplicationData.screenWidth - m_boundaries[CGEngine.m_nCurrentGalaxy - 1][1].GetWidth();
            add = y1 - y3;
        } else {
            return;
        }
        float deltaX2 = x1 - x3;
        float deltaY2 = y3 - add - y3;
        float l2 = deltaX2 * deltaX2 + deltaY2 * deltaY2;
        l2 = (float)Math.sqrt(l2);
        deltaX2 /= l2;
        deltaY2 /= l2;
        for (int i = 0; i < NUM_CANNON_LINE_SEGMENTS / 4 * 3; ++i) {
            int x = (int)((float)x3 + deltaX2 * l2 * (float)i / (float)NUM_CANNON_LINE_SEGMENTS / 4.0f * 3.0f);
            int y = (int)((float)y3 + deltaY2 * l2 * (float)i / (float)NUM_CANNON_LINE_SEGMENTS / 4.0f * 3.0f);
            Graphic2D.DrawCenter(m_canonLine[(i + (int)cannonLineTime) % 4], x, y);
        }
    }

    public static void RenderBoundaries() {
        Graphic2D.DrawImage(m_boundaries[CGEngine.m_nCurrentGalaxy - 1][2], ApplicationData.screenWidth / 2, 0, 17);
        Graphic2D.DrawImage(m_boundaries[CGEngine.m_nCurrentGalaxy - 1][0], 0, ApplicationData.screenHeight, 36);
        Graphic2D.DrawImage(m_boundaries[CGEngine.m_nCurrentGalaxy - 1][1], ApplicationData.screenWidth, ApplicationData.screenHeight, 40);
    }

    public static void RenderBall(char nColor, float x, float y) {
        Graphic2D.DrawCenter(m_Textures[nColor - '\u0001'], (int)(0.5f + x * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)(0.5f + (y + m_fBoardStartY) * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
    }

    public static void RenderHit(CGHit hit, float x, float y) {
        CGTexture frame = CGHit.m_HitTextures[hit.m_nType][hit.m_nCurrentFrame];
        if (frame != null) {
            int xx = (int)(0.5f + x * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX;
            int yy = (int)(0.5f + (y + m_fBoardStartY) * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY;
            if (hit.m_nType >= 4 && hit.m_nType <= 7) {
                if (xx < frame.GetWidth() / 2) {
                    xx = frame.GetWidth() / 2;
                } else if (xx > ApplicationData.screenWidth - frame.GetWidth() / 2) {
                    xx = ApplicationData.screenWidth - frame.GetWidth() / 2;
                }
                Graphic2D.DrawCenter(frame, xx, yy);
            } else {
                Graphic2D.DrawCenter(frame, xx, yy);
            }
        }
    }

    public static void RenderWorldObject(WorldObject w) {
        if (!w.m_bVisible) {
            return;
        }
        if (w.m_nAnimSize == 1) {
            if (CGEngine.m_bEngineChangeAxis) {
                float yy;
                float xx = w.m_fX + w.m_fW / 2;
                float fTmp = yy = (float)(w.m_fY + w.m_fH / 2);
                yy = xx;
                xx = 480.0f - fTmp;
                Graphic2D.DrawCenterRotate(w.m_Texture[0], (int)(xx * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)(yy * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
            } else if (w.m_Texture[0] != null) {
                float xx = w.m_fX + w.m_fW / 2;
                float yy = w.m_fY + w.m_fH / 2;
                Graphic2D.DrawCenter(w.m_Texture[0], (int)(xx * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)(yy * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY);
            }
        } else {
            int nSourceX = w.m_nCurrentFrame % w.m_nAnimGridX * w.m_nTextureFrameWidth;
            int nSourceY = w.m_nCurrentFrame / w.m_nAnimGridX * w.m_nTextureFrameHeight;
            if (CGEngine.m_bEngineChangeAxis) {
                float yy;
                float xx = w.m_fX + w.m_fW / 2;
                float fTmp = yy = (float)(w.m_fY + w.m_fH / 2);
                yy = xx;
                xx = 480.0f - fTmp;
                Graphic2D.DrawRegion(w.m_Texture[0], nSourceX, nSourceY, w.m_nTextureFrameWidth, w.m_nTextureFrameHeight, 4, (int)(xx * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)(yy * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY, 3);
            } else {
                float xx = w.m_fX + w.m_fW / 2;
                float yy = w.m_fY + w.m_fH / 2;
                Graphic2D.DrawRegion(w.m_Texture[0], nSourceX, nSourceY, w.m_nTextureFrameWidth, w.m_nTextureFrameHeight, 0, (int)(xx * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetX, (int)(yy * CGEngine.m_fEngineScale) + (int)m_fScreenOffsetY, 3);
            }
        }
    }

    static {
        middleX = -1.0f;
        vOut = new VectorF2();
        vDir = new VectorF2();
        cannonLineTime = 0.0f;
    }
}

