/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.graphic2d;

import baltorogames.graphic2d.CGTexture;
import baltorogames.graphic2d.PackedTextureData;
import baltorogames.graphic2d.TextureManager;
import baltorogames.system.FileManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class PackedTexture {
    public static int m_nHalfSize = 1;
    protected Vector m_vector = null;

    protected boolean loadFile(String fileName) {
        int i;
        StringBuffer sb = new StringBuffer();
        InputStream is = FileManager.OpenFile(fileName);
        if (is == null) {
            return false;
        }
        try {
            int ch;
            while ((ch = is.read()) != -1) {
                sb.append((char)ch);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        Vector<String> vector = new Vector<String>();
        StringBuffer sub = new StringBuffer();
        int nLength = sb.length();
        for (i = 0; i < nLength; ++i) {
            char c = sb.charAt(i);
            if (c == '\r' || c == '\n') {
                String s = sub.toString();
                vector.addElement(s);
                sub.delete(0, sb.length());
                ++i;
                continue;
            }
            sub.append(c);
        }
        if (sub.length() > 0) {
            String s = sub.toString();
            vector.addElement(s);
            sub.delete(0, sb.length());
        }
        if (this.m_vector == null) {
            this.m_vector = new Vector();
        }
        for (i = 0; i < vector.size(); ++i) {
            char cc;
            int nOffset;
            int j;
            String str = (String)vector.elementAt(i);
            int nL = str.length();
            PackedTextureData pid = new PackedTextureData();
            for (j = nOffset = 0; j < nL; ++j) {
                cc = str.charAt(j);
                if (cc == ' ') {
                    pid.szName = new String("/") + sub.toString() + new String(".png");
                    nOffset = j + 3;
                    sub.delete(0, sub.length());
                    break;
                }
                sub.append(cc);
            }
            for (j = nOffset; j < nL; ++j) {
                cc = str.charAt(j);
                if (cc == ' ') {
                    String szX = sub.toString();
                    nOffset = j + 1;
                    pid.x = Integer.parseInt(szX);
                    sub.delete(0, sub.length());
                    break;
                }
                sub.append(cc);
            }
            for (j = nOffset; j < nL; ++j) {
                cc = str.charAt(j);
                if (cc == ' ') {
                    String szY = sub.toString();
                    nOffset = j + 1;
                    pid.y = Integer.parseInt(szY);
                    sub.delete(0, sub.length());
                    break;
                }
                sub.append(cc);
            }
            for (j = nOffset; j < nL; ++j) {
                cc = str.charAt(j);
                if (cc == ' ') {
                    String szW = sub.toString();
                    nOffset = j + 1;
                    pid.w = Integer.parseInt(szW);
                    sub.delete(0, sub.length());
                    break;
                }
                sub.append(cc);
            }
            for (j = nOffset; j < nL; ++j) {
                cc = str.charAt(j);
                sub.append(cc);
            }
            String szH = sub.toString();
            pid.h = Integer.parseInt(szH);
            sub.delete(0, sub.length());
            this.m_vector.addElement(pid);
        }
        return true;
    }

    public void LoadFrom(String szTextFile, String szPngFile) {
        boolean ret;
        int nStartVectorIndex = 0;
        if (this.m_vector != null) {
            nStartVectorIndex = this.m_vector.size();
        }
        if (!(ret = this.loadFile(szTextFile))) {
            return;
        }
        Image image = null;
        try {
            image = Image.createImage((String)szPngFile);
        }
        catch (Exception e) {
            // empty catch block
        }
        int imageBuffW = image.getWidth();
        int imageBuffH = image.getHeight();
        int[] imageBuff = new int[imageBuffW * imageBuffH];
        image.getRGB(imageBuff, 0, imageBuffW, 0, 0, imageBuffW, imageBuffH);
        int nDivScale = m_nHalfSize;
        System.out.println("loading szPngFile... scale=" + nDivScale);
        int nL = this.m_vector.size();
        for (int i = nStartVectorIndex; i < nL; ++i) {
            PackedTextureData pid = (PackedTextureData)this.m_vector.elementAt(i);
            System.out.println("\tcreating + " + pid.szName + "...");
            Image im = this.prepareImage(imageBuff, imageBuffW, imageBuffH, pid.x / nDivScale, pid.y / nDivScale, pid.w / nDivScale, pid.h / nDivScale);
            CGTexture t = new CGTexture();
            t.SetName(pid.szName);
            t.SetImage(im);
            TextureManager.AddTexture(t);
        }
    }

    protected Image prepareImage(int[] buff, int width, int height, int x, int y, int w, int h) {
        int[] newBuff = new int[w * h];
        for (int yy = 0; yy < h; ++yy) {
            for (int xx = 0; xx < w; ++xx) {
                newBuff[yy * w + xx] = buff[(y + yy) * width + (x + xx)];
            }
        }
        return Image.createRGBImage((int[])newBuff, (int)w, (int)h, (boolean)true);
    }

    public void Destroy() {
        if (this.m_vector != null) {
            this.m_vector.removeAllElements();
        }
        this.m_vector = null;
    }
}

