/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.project_gameplay.CGEngineRenderer;
import java.util.Vector;

public class CGFallingBall {
    public static float eStartSpeed = 800.0f;
    public static float eGravitySpeed = 3500.0f;
    public float m_fBallX;
    public float m_fBallY;
    public float m_fCurrentSpeed;
    public char m_nColor;
    public static Vector m_Vector = null;
    public static Vector m_TmpVector = null;

    public static void Init() {
        m_Vector = new Vector();
        m_TmpVector = new Vector();
        for (int i = 0; i < 64; ++i) {
            CGFallingBall fb = new CGFallingBall();
            m_TmpVector.addElement(fb);
        }
    }

    public static void UpdateAll(int nDeltaTimeInMs) {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            CGFallingBall fb = (CGFallingBall)m_Vector.elementAt(i);
            fb.Update(nDeltaTimeInMs);
            if (!(fb.m_fBallY > 1000.0f)) continue;
            m_TmpVector.addElement(fb);
            m_Vector.removeElementAt(i);
        }
    }

    public static void RenderAll() {
        int nS = m_Vector.size();
        for (int i = nS - 1; i >= 0; --i) {
            CGFallingBall fb = (CGFallingBall)m_Vector.elementAt(i);
            fb.Render();
        }
    }

    public static void NewBall(float x, float y, char color) {
        CGFallingBall fb = null;
        int nS = m_TmpVector.size();
        if (nS > 0) {
            fb = (CGFallingBall)m_TmpVector.elementAt(0);
            m_TmpVector.removeElementAt(0);
        } else {
            fb = new CGFallingBall();
        }
        fb.Start(x, y, color);
        m_Vector.addElement(fb);
    }

    public void Destroy() {
    }

    public void Start(float x, float y, char color) {
        this.m_fBallX = x;
        this.m_fBallY = y;
        this.m_nColor = color;
        this.m_fCurrentSpeed = eStartSpeed;
    }

    public void Update(int nDeltaTimeInMs) {
        float t = (float)nDeltaTimeInMs / 1000.0f;
        this.m_fCurrentSpeed += eGravitySpeed * t;
        this.m_fBallY += this.m_fCurrentSpeed * t;
    }

    public void Render() {
        CGEngineRenderer.RenderBall(this.m_nColor, this.m_fBallX, this.m_fBallY);
    }
}

