/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.VectorF2;
import baltorogames.project_gameplay.CGBoard;
import baltorogames.project_gameplay.CGEngine;

public class CGBallShooter {
    public static int eDefaultSpeed = 2000;
    static VectorF2 vv = new VectorF2();
    static VectorF2 vvv = new VectorF2();
    public float m_fTargetX;
    public float m_fTargetY;
    public float m_fBallX;
    public float m_fBallY;
    public int m_nMode;
    public float m_fSpeed;
    public char m_nColor = '\u0001';
    public char m_bDestroyed = '\u0000';
    public int m_nBallGridX = -1;
    public int m_nBallGridY = -1;

    public void Destroy() {
    }

    public char IsDestroyed() {
        return this.m_bDestroyed;
    }

    public void Update(int nDeltaTimeInMs) {
        if (this.m_bDestroyed > '\u0000') {
            this.m_bDestroyed = (char)(this.m_bDestroyed + '\u0001');
            return;
        }
        float fAdd = this.m_fSpeed * (float)nDeltaTimeInMs / 1000.0f;
        float fRet = this.QuickCheckCollisionWithBoard(this.m_fBallX, this.m_fBallY, fAdd * this.m_fTargetX, fAdd * this.m_fTargetY, vvv);
        if (fRet >= 0.0f && fRet < 1000000.0f) {
            this.m_bDestroyed = (char)100;
            this.m_fBallX = CGBallShooter.vvv.x;
            this.m_fBallY = CGBallShooter.vvv.y;
            if (this.m_nBallGridX >= 0 && this.m_nBallGridY >= 0) {
                CGEngine.m_Board.PutNewBallInRealPos(this.m_nColor, this.m_fBallX, this.m_fBallY, this.m_nBallGridX, this.m_nBallGridY);
            }
        } else {
            float fNewX = this.m_fBallX + fAdd * this.m_fTargetX;
            if (this.m_fTargetX < 0.0f && fNewX < CGBoard.eBallRadius + CGBoard.eBoardMargin) {
                float fWsp = (CGBoard.eBallRadius + CGBoard.eBoardMargin - fNewX) / (this.m_fBallX - fNewX);
                fWsp = 1.0f - fWsp;
                this.m_fBallX += fWsp * (fAdd * this.m_fTargetX);
                this.m_fBallY += fWsp * (fAdd * this.m_fTargetY);
                this.m_fTargetX = -this.m_fTargetX;
            } else if (this.m_fTargetX > 0.0f && fNewX > 480.0f - (CGBoard.eBallRadius + CGBoard.eBoardMargin)) {
                float fWsp = (fNewX - (480.0f - (CGBoard.eBallRadius + CGBoard.eBoardMargin))) / (fNewX - this.m_fBallX);
                fWsp = 1.0f - fWsp;
                this.m_fBallX += fWsp * (fAdd * this.m_fTargetX);
                this.m_fBallY += fWsp * (fAdd * this.m_fTargetY);
                this.m_fTargetX = -this.m_fTargetX;
            } else {
                float fNewY = this.m_fBallY + fAdd * this.m_fTargetY;
                if (fNewY < CGBoard.eBoardMarginUp + CGBoard.eBallRadius) {
                    float fWsp = (CGBoard.eBoardMarginUp + CGBoard.eBallRadius - fNewY) / (this.m_fBallY - fNewY);
                    this.m_fBallX += fWsp * (fAdd * this.m_fTargetX);
                    this.m_fBallY += fWsp * (fAdd * this.m_fTargetY);
                    this.m_bDestroyed = (char)100;
                    CGEngine.m_Board.PutNewBallInFirstRow(this.m_nColor, this.m_fBallX, this.m_fBallY);
                } else {
                    this.m_fBallX += fAdd * this.m_fTargetX;
                    this.m_fBallY += fAdd * this.m_fTargetY;
                }
            }
        }
    }

    public void SetTarget(float x, float y) {
        this.m_fTargetX = x - this.m_fBallX;
        this.m_fTargetY = y - this.m_fBallY;
        float fD = this.m_fTargetX * this.m_fTargetX + this.m_fTargetY * this.m_fTargetY;
        fD = (float)Math.sqrt(fD);
        this.m_fTargetX /= fD;
        this.m_fTargetY /= fD;
        this.m_fSpeed = eDefaultSpeed;
    }

    void SetPosition(float x, float y) {
        this.m_fBallX = x;
        this.m_fBallY = y;
    }

    float QuickCheckCollisionWithBoard(float fPrevX, float fPrevY, float fDX, float fDY, VectorF2 vOut) {
        float t1;
        float fD2 = 4.0f * CGBoard.eBallRadius * CGBoard.eBallRadius;
        float fDist = 1000000.0f;
        float fBallX = 0.0f;
        float fBallY = 0.0f;
        int nBallGridX = -1;
        int nBallGridY = -1;
        float fCurrX = fPrevX + fDX;
        float fCurrY = fPrevY + fDY;
        for (int xx = 0; xx < CGEngine.m_Board.m_nGridSizeX; ++xx) {
            for (int yy = 0; yy < CGEngine.m_Board.m_nGridSizeY; ++yy) {
                char color = CGEngine.m_Board.GetColor(xx, yy);
                if (color == '\u0000') continue;
                CGEngine.m_Board.GetRealPosition(xx, yy, vv);
                float fD = (fCurrX - CGBallShooter.vv.x) * (fCurrX - CGBallShooter.vv.x) + (fCurrY - CGBallShooter.vv.y) * (fCurrY - CGBallShooter.vv.y);
                if (!(fD < fD2) || !(fD < fDist)) continue;
                fDist = fD;
                fBallX = CGBallShooter.vv.x;
                fBallY = CGBallShooter.vv.y;
                nBallGridX = xx;
                nBallGridY = yy;
            }
        }
        if (nBallGridX < 0) {
            return 1000000.0f;
        }
        float b = 2.0f * fPrevX * fDX + 2.0f * fPrevY * fDY - 2.0f * fBallX * fDX - 2.0f * fBallY * fDY;
        float a = fDX * fDX + fDY * fDY;
        float c = fPrevX * fPrevX + fPrevY * fPrevY - 2.0f * fBallX * fPrevX - 2.0f * fBallY * fPrevY + fBallX * fBallX + fBallY * fBallY - 4.0f * CGBoard.eBallRadius * CGBoard.eBallRadius;
        float fDelta = b * b - 4.0f * a * c;
        if (fDelta < 0.0f) {
            return 1000000.0f;
        }
        this.m_nBallGridX = nBallGridX;
        this.m_nBallGridY = nBallGridY;
        if (fDelta == 0.0f) {
            float t = -b / (2.0f * a);
            vOut.x = fPrevX + t * fDX;
            vOut.y = fPrevY + t * fDY;
            return t * fDX * (t * fDX) + t * fDY * (t * fDY);
        }
        float t2 = (-b + (fDelta = (float)Math.sqrt(fDelta))) / (2.0f * a);
        if (t2 < (t1 = (-b - fDelta) / (2.0f * a))) {
            t1 = t2;
        }
        vOut.x = fPrevX + t1 * fDX;
        vOut.y = fPrevY + t1 * fDY;
        return t1 * fDX * (t1 * fDX) + t1 * fDY * (t1 * fDY);
    }
}

