/*
 * Decompiled with CFR 0.152.
 */
package baltorogames.project_gameplay;

import baltorogames.core.Log;
import baltorogames.project_gameplay.CGEngine;
import baltorogames.project_gameplay.TmpWorldObjectsDataBase;
import baltorogames.project_gameplay.WorldLayer;
import baltorogames.project_gameplay.WorldObject;
import baltorogames.system.FileManager;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class WorldMap {
    public static int m_nNrOfPiecesToDraw = 100;
    protected WorldLayer[] m_arrLayers = null;

    public int LoadFromFile(String csFileName) {
        try {
            InputStream is = FileManager.OpenFile(csFileName);
            DataInputStream dis = new DataInputStream(is);
            this.Load(dis);
            CGEngine.Load1(dis);
            CGEngine.Load2(dis);
        }
        catch (Exception e) {
            Log.DEBUG_LOG(16, "WorldMap " + csFileName + " loading error!!!");
            return 0;
        }
        return 1;
    }

    public int Load(DataInputStream dis) throws IOException {
        this.Destroy();
        TmpWorldObjectsDataBase.Clear();
        TmpWorldObjectsDataBase.Import(dis);
        this.m_arrLayers = new WorldLayer[10];
        this.m_arrLayers[0] = new WorldLayer();
        for (int i = 0; i < 10; ++i) {
            this.m_arrLayers[i] = new WorldLayer();
            this.m_arrLayers[i].Load(dis);
        }
        TmpWorldObjectsDataBase.Clear();
        return 1;
    }

    public WorldLayer GetLayer(int i) {
        return this.m_arrLayers[i];
    }

    public void Render(int LayerMin, int nLayerMax) {
        for (int i = LayerMin; i <= nLayerMax; ++i) {
            this.m_arrLayers[i].Render(0, m_nNrOfPiecesToDraw);
        }
    }

    public void Render(int LayerMin, int nLayerMax, int nFirstPiece, int nLastPiece) {
        for (int i = LayerMin; i <= nLayerMax; ++i) {
            this.m_arrLayers[i].Render(nFirstPiece, nLastPiece);
        }
    }

    public void Destroy() {
        if (this.m_arrLayers != null) {
            for (int i = 0; i < 10; ++i) {
                if (this.m_arrLayers[i] == null) continue;
                this.m_arrLayers[i].Destroy();
                this.m_arrLayers[i] = null;
            }
            this.m_arrLayers = null;
        }
    }

    public void ActiveAllObjects() {
        for (int i = 1; i <= 4; ++i) {
            if (this.m_arrLayers == null || this.m_arrLayers[i] == null) continue;
            this.m_arrLayers[i].ActiveAllObjects();
        }
    }

    public WorldObject FindByTextureName(String name, int nLayer) {
        if (this.m_arrLayers != null && this.m_arrLayers[nLayer] != null) {
            return this.m_arrLayers[nLayer].FindByTextureName(name);
        }
        return null;
    }

    public WorldObject FindObjectByCollisionID(int nCollisionID) {
        for (int i = 0; i < 10; ++i) {
            WorldObject pO;
            if (this.m_arrLayers == null || this.m_arrLayers[i] == null || (pO = this.m_arrLayers[i].FindByCollisionID(nCollisionID)) == null) continue;
            return pO;
        }
        return null;
    }
}

