/*
 * Decompiled with CFR 0.152.
 */
package root;

import framework.graphics.SimpleSprite;
import framework.math.FP;
import framework.math.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import root.Game;
import root.GoolGlobals;

public class Ball {
    public int fp_x;
    public int fp_lastX;
    public int fp_y;
    public int fp_lastY;
    public int fp_radius = GoolGlobals.BALL_RADIUS;
    public int fp_mass = GoolGlobals.BALL_MASS;
    public int fp_resistance = GoolGlobals.NORMAL_RES;
    public boolean goal = false;
    public Vector2D velocityVector = new Vector2D(0, 1);
    public int fp_scalarVelocity = 0;
    public Vector2D externalForce = new Vector2D(0, 0);
    public int fp_maxExternalForce = GoolGlobals.MAX_EXT_FORCE;
    public int fp_maxScalarVelocity = GoolGlobals.MAX_BALL_VELOCITY;
    public Image ballImage;
    public SimpleSprite pilkaTest;
    public int shadeHeight = 1;
    public boolean collisionFlag = false;
    public int[] collidingCoords = new int[2];
    public int[] collidingBallInSet = new int[2];
    private Vector2D calc = new Vector2D(0, 0);
    public Game game;

    public Ball(Game game) {
        this.game = game;
        try {
            this.ballImage = Image.createImage((String)"/pilka.png");
            this.pilkaTest = new SimpleSprite(this.ballImage, this.ballImage.getWidth() / 4, this.ballImage.getHeight() / 8);
            this.ballImage = Image.createImage((String)"/pilka_cien.png");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void update(int delta) {
    }

    public void draw(Graphics g) {
        g.drawImage(this.ballImage, (this.fp_x >> FP.SHIFT) + 1, (this.fp_y >> FP.SHIFT) + this.shadeHeight, 1 | 2);
        this.pilkaTest.paintWithAnchor(g, this.fp_x >> FP.SHIFT, this.fp_y >> FP.SHIFT, 1 | 2);
    }

    public void checkWallCollision() {
        if (this.checkForGoal()) {
            this.goal = true;
            return;
        }
        if (this.fp_x - this.fp_radius < GoolGlobals.PITCH_X << FP.SHIFT) {
            this.velocityVector.fp_x *= -1;
            this.fp_x = (GoolGlobals.PITCH_X << FP.SHIFT) + this.fp_radius;
        } else if (this.fp_x + this.fp_radius > GoolGlobals.PITCH_X + GoolGlobals.PITCH_WIDTH << FP.SHIFT) {
            this.velocityVector.fp_x *= -1;
            this.fp_x = (GoolGlobals.PITCH_X + GoolGlobals.PITCH_WIDTH << FP.SHIFT) - this.fp_radius;
        }
        if (this.fp_y - this.fp_radius < GoolGlobals.PITCH_Y << FP.SHIFT) {
            this.velocityVector.fp_y *= -1;
            this.fp_y = (GoolGlobals.PITCH_Y << FP.SHIFT) + this.fp_radius;
        } else if (this.fp_y + this.fp_radius > GoolGlobals.PITCH_Y + GoolGlobals.PITCH_HEIGHT << FP.SHIFT) {
            this.velocityVector.fp_y *= -1;
            this.fp_y = (GoolGlobals.PITCH_Y + GoolGlobals.PITCH_HEIGHT << FP.SHIFT) - this.fp_radius;
        }
    }

    public boolean fallBack(int dist) {
        this.calc.fp_x = this.fp_x - this.fp_lastX;
        this.calc.fp_y = this.fp_y - this.fp_lastY;
        if (this.calc.fp_x == 0 && this.calc.fp_y == 0) {
            return true;
        }
        this.calc.normalizeApprox2();
        this.calc.mul(-dist);
        this.fp_x += this.calc.fp_x;
        this.fp_y += this.calc.fp_y;
        this.fp_lastX += this.calc.fp_x;
        this.fp_lastY += this.calc.fp_y;
        return false;
    }

    public byte getZone() {
        return (byte)Math.min((this.fp_y / 256 - GoolGlobals.PITCH_Y) / GoolGlobals.TEAM_SPACING, 2);
    }

    public int getBallOwner() {
        return Math.min((this.fp_y / 256 - GoolGlobals.PITCH_Y) / (GoolGlobals.TEAM_SPACING >> 1), 5) % 2;
    }

    public byte getZoneBetweenPlayers() {
        return (byte)Math.min(4, (this.fp_y / 256 - GoolGlobals.PITCH_Y - GoolGlobals.PITCH_HEIGHT / 12) / (GoolGlobals.PITCH_HEIGHT / 6));
    }

    public void move(int delta) {
        this.velocityVector.normalizeApprox2();
        delta = 1;
        if (this.externalForce.fp_x != 0 || this.externalForce.fp_y != 0) {
            this.velocityVector.fp_x = this.velocityVector.fp_x * this.fp_scalarVelocity >> FP.SHIFT;
            this.velocityVector.fp_y = this.velocityVector.fp_y * this.fp_scalarVelocity >> FP.SHIFT;
            this.velocityVector.add(this.externalForce);
            this.fp_scalarVelocity = this.velocityVector.getLengthApprox2();
            this.velocityVector.normalizeApprox2();
            this.externalForce.fp_x = 0;
            this.externalForce.fp_y = 0;
        }
        if (this.fp_scalarVelocity > this.fp_maxScalarVelocity) {
            this.fp_scalarVelocity = this.fp_maxScalarVelocity;
        } else if (this.fp_scalarVelocity < -this.fp_maxScalarVelocity) {
            this.fp_scalarVelocity = -this.fp_maxScalarVelocity;
        }
        this.fp_lastX = this.fp_x;
        this.fp_lastY = this.fp_y;
        this.fp_x += this.velocityVector.fp_x * this.fp_scalarVelocity * delta / FP.PRECISION_POW;
        this.fp_y += this.velocityVector.fp_y * this.fp_scalarVelocity * delta / FP.PRECISION_POW;
        this.fp_scalarVelocity = this.fp_scalarVelocity * this.fp_resistance >> FP.SHIFT;
        int proc = this.fp_scalarVelocity == this.fp_maxScalarVelocity ? 1 : (this.fp_scalarVelocity >= (this.fp_maxScalarVelocity >> 2) * 3 ? 2 : (this.fp_scalarVelocity >= this.fp_maxScalarVelocity >> 1 ? 3 : (this.fp_scalarVelocity >= this.fp_maxScalarVelocity >> 2 ? 5 : 6)));
        if (this.fp_scalarVelocity != 0 && this.game.mainGameCanvas.framesCount % (long)proc == 0L) {
            this.pilkaTest.nextFrame();
        }
        if (this.shadeHeight > 1 && (this.game.mainGameCanvas.framesCount & 3L) != 0L) {
            --this.shadeHeight;
        }
    }

    public void correctMove() {
        byte i = this.getZoneBetweenPlayers();
        int j = 0;
        this.collidingCoords[0] = -1;
        this.collisionFlag = false;
        if (this.fp_lastX != this.fp_x || this.fp_lastY != this.fp_y) {
            for (j = 0; j < Game.players.length; ++j) {
                int correction = Game.players[j].team[(i + (1 - Game.players[j].playerID)) / 2].checkBallCollision();
                if (correction == 0) continue;
                this.calc.fp_x = this.velocityVector.fp_x * (correction + 1) / FP.PRECISION_POW;
                this.calc.fp_y = this.velocityVector.fp_y * (correction + 1) / FP.PRECISION_POW;
                this.fp_x -= this.calc.fp_x;
                this.fp_y -= this.calc.fp_y;
                this.collisionFlag = true;
                this.collidingCoords[j] = (i + (1 - Game.players[j].playerID)) / 2;
                Game.players[j].collisionFlag = true;
            }
            if (Game.players[1].collisionFlag && Game.players[0].collisionFlag) {
                Game.players[0].team[(i + (1 - Game.players[0].playerID)) / 2].fallBack(GoolGlobals.BALL_RADIUS >> 1);
                Game.players[1].team[(i + (1 - Game.players[1].playerID)) / 2].fallBack(GoolGlobals.BALL_RADIUS >> 1);
            }
        }
        this.checkWallCollision();
    }

    public void reCorrectMove() {
        byte i = this.getZoneBetweenPlayers();
        int j = 0;
        if (this.fp_lastX != this.fp_x || this.fp_lastY != this.fp_y) {
            for (j = 0; j < Game.players.length; ++j) {
                int correction = Game.players[j].team[(i + (1 - Game.players[j].playerID)) / 2].checkBallCollision();
                if (correction == 0) continue;
                this.calc.fp_x = this.velocityVector.fp_x * (correction + 1) / FP.PRECISION_POW;
                this.calc.fp_y = this.velocityVector.fp_y * (correction + 1) / FP.PRECISION_POW;
                this.fp_x -= this.calc.fp_x;
                this.fp_y -= this.calc.fp_y;
            }
        }
        this.checkWallCollision();
    }

    public void resolveCollision() {
        if (Game.players[0].collisionFlag) {
            Game.players[0].team[this.collidingCoords[0]].balls[this.collidingBallInSet[0]].resolveCollision();
        }
        if (Game.players[1].collisionFlag) {
            Game.players[1].team[this.collidingCoords[1]].balls[this.collidingBallInSet[1]].resolveCollision();
        }
        Game.doubleCollision = Game.players[1].collisionFlag && Game.players[0].collisionFlag;
    }

    private boolean checkForGoal() {
        return this.fp_x - this.fp_radius > GoolGlobals.PITCH_X + (GoolGlobals.PITCH_WIDTH >> 1) - GoolGlobals.HALF_GOAL_SIZE << FP.SHIFT && this.fp_x + this.fp_radius < GoolGlobals.PITCH_X + (GoolGlobals.PITCH_WIDTH >> 1) + GoolGlobals.HALF_GOAL_SIZE << FP.SHIFT && (this.fp_y - this.fp_radius < GoolGlobals.PITCH_Y << FP.SHIFT || this.fp_y + this.fp_radius > GoolGlobals.PITCH_Y + GoolGlobals.PITCH_HEIGHT << FP.SHIFT);
    }

    public void deinitialize() {
        this.pilkaTest = null;
        this.ballImage = null;
        System.gc();
    }
}

