/*
 * Decompiled with CFR 0.152.
 */
package root;

import framework.MainGameCanvas;
import framework.graphics.SimpleSprite;
import framework.math.FP;
import framework.math.Vector2D;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import root.Game;
import root.GoolGlobals;
import root.StaticSet;

public class Player {
    public int xMoovingSpeed;
    public int yMoovingSpeed;
    public int fp_acceleration = GoolGlobals.MAX_HUMAN_ACC;
    public boolean ai = false;
    public StaticSet[] team = new StaticSet[3];
    public int teamSpacing = GoolGlobals.TEAM_SPACING;
    public byte playerID = 0;
    public int lastMovingSet = 0;
    public int currentMovingSet = 0;
    public boolean collisionFlag = false;
    public SimpleSprite ballImage;
    public Vector2D tempVec = new Vector2D(0, 0);
    public boolean cornerRun = false;
    public int score = 0;
    private MainGameCanvas game;

    public Player(byte id, int team, MainGameCanvas game) {
        this.game = game;
        this.playerID = id;
        try {
            Image bI = Image.createImage((String)("/" + team + "team.png"));
            this.ballImage = new SimpleSprite(bI, bI.getWidth() >> 1, bI.getHeight());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.resetPosition();
    }

    public void update(int delta) {
        this.move(delta);
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this.team.length; ++i) {
            this.team[i].draw(g);
        }
    }

    public void resetPosition() {
        for (int i = 0; i < this.team.length; ++i) {
            if (this.team[i] == null) {
                this.team[i] = new StaticSet(this);
            }
            this.team[i].fp_y = (i * this.teamSpacing + GoolGlobals.PITCH_Y + 5 + this.playerID * this.teamSpacing / 2 << FP.SHIFT) + GoolGlobals.PLAYER_RADIUS;
            this.team[i].fp_x = (GoolGlobals.PITCH_X + GoolGlobals.SET_SPACING - 4 << FP.SHIFT) + GoolGlobals.PLAYER_RADIUS;
            this.team[i].fp_leftBound = (GoolGlobals.PITCH_X << FP.SHIFT) + GoolGlobals.PLAYER_RADIUS;
            this.team[i].fp_rightBound = (GoolGlobals.PITCH_X + GoolGlobals.PITCH_WIDTH << FP.SHIFT) - GoolGlobals.PLAYER_RADIUS;
            this.team[i].fp_upBound = (GoolGlobals.PITCH_Y + i * this.teamSpacing + this.playerID * this.teamSpacing / 2 << FP.SHIFT) + GoolGlobals.PLAYER_RADIUS + GoolGlobals.BALL_RADIUS / 2;
            this.team[i].fp_downBound = (GoolGlobals.PITCH_Y + this.playerID * this.teamSpacing / 2 + i * this.teamSpacing + this.teamSpacing / 2 << FP.SHIFT) - GoolGlobals.PLAYER_RADIUS - GoolGlobals.BALL_RADIUS / 2;
            this.team[i].move(this.xMoovingSpeed, this.yMoovingSpeed);
        }
        this.team[1].fp_y = this.playerID == 1 ? this.team[1].fp_upBound + (GoolGlobals.PLAYER_RADIUS << FP.SHIFT) : this.team[1].fp_downBound - (GoolGlobals.PLAYER_RADIUS << FP.SHIFT);
        this.team[1].move(this.xMoovingSpeed, this.yMoovingSpeed);
    }

    public void move(int delta) {
        this.lastMovingSet = this.currentMovingSet;
        int i = Game.ball.getZoneBetweenPlayers();
        i = (i + (1 - this.playerID)) / 2;
        boolean forceCollision = false;
        this.collisionFlag = false;
        this.currentMovingSet = i;
        if (i != this.lastMovingSet) {
            this.xMoovingSpeed = 0;
            this.yMoovingSpeed = 0;
        }
        this.currentMovingSet = i;
        this.tempVec.fp_x = this.xMoovingSpeed;
        this.tempVec.fp_y = this.yMoovingSpeed;
        if (this.ai) {
            if (this.tempVec.getLengthApprox2() > GoolGlobals.MAX_AI_VELOCITY) {
                this.tempVec.normalizeApprox2();
                this.tempVec.mul(GoolGlobals.MAX_AI_VELOCITY);
            }
        } else if (this.tempVec.getLengthApprox2() > GoolGlobals.MAX_HUMAN_VELOCITY) {
            this.tempVec.normalizeApprox2();
            this.tempVec.mul(GoolGlobals.MAX_HUMAN_VELOCITY);
        }
        this.team[i].active = true;
        this.team[i].move(this.tempVec.fp_x, this.tempVec.fp_y);
    }

    public void forceCorrection() {
        int i = Game.ball.getZoneBetweenPlayers();
        if (this.team[i = (i + (1 - this.playerID)) / 2].checkBallCollision() != 0) {
            this.team[i].forcedFallBack(GoolGlobals.BALL_RADIUS >> 1);
        }
    }

    public void correctMove() {
        int i = Game.ball.getZoneBetweenPlayers();
        int correction = this.team[i = (i + (1 - this.playerID)) / 2].checkBallCollision();
        if (correction != 0) {
            this.team[i].fallBack(correction);
            this.collisionFlag = true;
            Game.ball.collidingCoords[this.playerID] = i;
        }
    }

    public void reCorrectMove() {
        int i = Game.ball.getZoneBetweenPlayers();
        int correction = this.team[i = (i + (1 - this.playerID)) / 2].checkBallCollision();
        if (correction != 0) {
            this.team[i].fallBack(correction);
        }
    }

    public void deinitialize() {
        this.ballImage = null;
        System.gc();
    }
}

