/*
 * Decompiled with CFR 0.152.
 */
package Game;

import Game.Car;
import Game.CarType;
import Game.Cfg;
import Game.Citizen;
import Game.CitizenType;
import Game.Conversation;
import Game.Dummy;
import Game.Enemy;
import Game.EnemyType;
import Game.Game;
import Game.HotSpot;
import Game.Item;
import Game.ItemMessage;
import Game.Map;
import Game.Player2;
import Game.Polygon;
import Game.Shop;
import Game.Sprite;
import Game.Timer;
import Game.TrafficControlZone;
import Game.TrafficLight;
import Game.Vect;
import SAF_Application.Application;
import SAF_Core.Anim;
import SAF_Core.C;
import SAF_Core.Gfx;
import SAF_Core.Sound;
import SAF_Core.Txt;
import SAF_Engine.Camera;
import SAF_Engine.Trigger;
import SAF_GUI.Edit;
import SAF_GUI.TextBox;
import SAF_Util.Mat;
import SAF_Util.Util;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;

public final class Mafia
implements Game {
    public static final String N = "";
    public static final byte GAME_STATE_INTRO = 0;
    public static final byte GAME_STATE_INGAME = 1;
    public static final byte GAME_STATE_END_GAME = 2;
    private static final byte INGAME_STATE_LEVEL_LOADING = 0;
    private static final byte INGAME_STATE_WALK = 1;
    private static final byte INGAME_STATE_DRIVE = 2;
    private static final byte INGAME_STATE_CONVERSATION = 3;
    private static final byte INGAME_STATE_MESSAGE = 4;
    private static final byte INGAME_STATE_SNIPER = 5;
    private static final byte INGAME_STATE_TRANSITION = 6;
    private static final byte INGAME_STATE_SHOP = 7;
    private static final byte INGAME_STATE_JACKPOT = 8;
    private static final byte INGAME_STATE_LEVEL_ENDING_PRE_SUMMARY = 9;
    private static final byte INGAME_STATE_LEVEL_ENDING_POST_SUMMARY = 10;
    private static final byte INGAME_STATE_LEVEL_FINALIZE = 11;
    private static final byte INGAME_STATE_LEVEL_FAIL = 12;
    private static final byte INGAME_STATE_LEVEL_RESET = 13;
    private static final byte INGAME_STATE_LOCKPICK = 14;
    private static final byte INGAME_STATE_ROLLER = 15;
    private static final byte INGAME_STATE_EPILOG = 16;
    private static final byte INGAME_STATE_CHEAT = 17;
    private static final byte CONVERSATION_STATE_IN = 0;
    private static final byte CONVERSATION_STATE_FLOW = 1;
    private static final byte CONVERSATION_STATE_OUT = 2;
    private static final byte HUD_MESSAGE_TYPE_START = 0;
    private static final byte HUD_MESSAGE_TYPE_END = 1;
    private static final byte JACKPOT_STATE_INIT = 0;
    private static final byte JACKPOT_STATE_NORMAL = 1;
    private static final byte JACKPOT_STATE_GO_AROUND = 2;
    private static final byte JACKPOT_STATE_SHOW_SCORE = 3;
    private static final byte SNIPER_STATE_SEARCH_TARGET = 0;
    private static final byte SNIPER_STATE_IN_TARGET = 1;
    private static final byte SNIPER_STATE_SHOOT_UP = 2;
    private static final byte SNIPER_STATE_SHOOT_DOWN = 3;
    private static final byte INTRO_STATE_MAP_GO_DOWN = 0;
    private static final byte INTRO_STATE_INIT_MAP = 1;
    private static final byte INTRO_STATE_MAP_GO_UP = 2;
    private static final byte INTRO_STATE_INFO_SCREEN = 3;
    private static final byte END_GAME_STATE_MESSAGE = 0;
    private static final byte END_GAME_STATE_TRANSITION = 1;
    private static final byte END_GAME_ENTER_NICKNAME = 2;
    private static final byte EPILOG_STATE_CITIZEN_WALK = 0;
    private static final byte EPILOG_STATE_CITIZEN_READING_START = 1;
    private static final byte EPILOG_STATE_MOVE_CAMERA_TO_CAR = 2;
    private static final byte EPILOG_STATE_CAR_DRIVE = 3;
    private static final byte EPILOG_STATE_ENEMIES_SPAWN = 4;
    private static final byte EPILOG_STATE_ENEMIES_LEAVE_CAR = 5;
    private static final byte EPILOG_STATE_MOVE_CAMERA_TO_PLAYER = 6;
    private static final byte EPILOG_STATE_ENEMIES_GO = 7;
    private static final byte EPILOG_STATE_SHOOTING = 8;
    private static final byte EPILOG_STATE_DEATH = 9;
    private static final byte EPILOG_STATE_FINAL = 10;
    private static final byte CAMERA_MODE_PLAYER_BIND = 0;
    private static final byte CAMERA_MODE_CAR_BIND = 1;
    private static final byte CAMERA_MODE_SNIPER_BIND = 2;
    private static final byte CAMERA_MODE_FREE = 3;
    private static final byte CAMERA_MODE_LOOKING_AT_POINT = 4;
    private static final byte LEVEL_LOADING_STAGE_INTRO_CLEANUP = 0;
    private static final byte LEVEL_LOADING_STAGE_LEVEL_SETTINGS = 1;
    private static final byte LEVEL_LOADING_STAGE_MAP = 2;
    private static final byte LEVEL_LOADING_STAGE_MAP_BACKGROUND = 3;
    private static final byte LEVEL_LOADING_STAGE_MAP_FOREGROUND = 4;
    private static final byte LEVEL_LOADING_STAGE_MAP_PLACEABLES = 5;
    private static final byte LEVEL_LOADING_STAGE_ENEMIES = 6;
    private static final byte LEVEL_LOADING_STAGE_DUMMIES = 7;
    private static final byte LEVEL_LOADING_STAGE_CITIZENS = 8;
    private static final byte LEVEL_LOADING_STAGE_CARS = 9;
    private static final byte LEVEL_LOADING_STAGE_SPRITES_PREPROCESS = 10;
    private static final byte LEVEL_LOADING_STAGE_SPRITES_RESOURCES = 11;
    private static final byte LEVEL_LOADING_STAGE_SPRITES_FINALIZE = 41;
    private static final byte LEVEL_LOADING_STAGE_SHOPS_SETTINGS = 42;
    private static final byte LEVEL_LOADING_STAGE_SHOPS_GRAPHICS = 43;
    private static final byte LEVEL_LOADING_STAGE_CONVERSATION = 44;
    private static final byte LEVEL_LOADING_STAGE_PORTRAITS = 45;
    private static final byte LEVEL_LOADING_STAGE_HUD = 46;
    private static final byte LEVEL_LOADING_STAGE_TXT = 47;
    private static final byte LEVEL_LOADING_STAGE_JACKPOT = 48;
    private static final byte LEVEL_LOADING_STAGE_PARTICLES_SETTINGS = 49;
    private static final byte LEVEL_LOADING_STAGE_PARTICLES_GRAPHICS = 50;
    private static final byte LEVEL_LOADING_STAGE_RESET = 51;
    private static final byte LEVEL_LOADING_STAGE_FINALIZE = 52;
    private static final byte LEVEL_LOADING_STAGE_LOADING_BAR_CLEANUP = 53;
    private static MIDlet midlet;
    private static Player2 player;
    private static Map map;
    private static Anim portraitsAnimation;
    public static Gfx loadingBarGfx;
    public static Image infoScreenGfx;
    public Txt txt;
    private Txt txtConversationsAndQuests;
    public static TextBox textBox;
    public Edit nickEdit;
    private static byte gameState;
    private static byte inGameState;
    private static byte inGameStatePrevious;
    private static long inGameStateTime;
    private static int animationGlobalCounter;
    private static short animationLastFrameTime;
    private static Camera camera;
    private static byte cameraMode;
    private static byte cameraModePrevious;
    private static Vect cameraCarOffset;
    private static int cameraOffsetCurrentXf;
    private static int cameraOffsetCurrentYf;
    private static int cameraOffsetDestXf;
    private static int cameraOffsetDestYf;
    private static int cameraOffsetCenterX;
    private static int cameraOffsetCenterY;
    private static int cameraCurrentPositionXf;
    private static int cameraCurrentPositionYf;
    private static int cameraLookAtTime;
    private static int cameraLookAtOffsetXf;
    private static int cameraLookAtOffsetYf;
    private static byte camerTriggerFinalizeActivateId;
    private static byte cameraTriggerFinalizeReleaseId;
    private boolean cameraIsShaking;
    private int cameraShakingTimeMs;
    private int cameraShakeOffsetX;
    private int cameraShakeOffsetY;
    private CarType[] carTypes;
    private Vector cars;
    private Vector carsWaitingForSpawn;
    int[] cheatCodeBase = new int[]{C.getKey(9), C.getKey(7), C.getKey(11), C.getKey(9), C.getKey(12), C.getKey(13), C.getKey(7)};
    int[] cheatCodeImmo = new int[]{C.getKey(9), C.getKey(11), C.getKey(11), C.getKey(11)};
    int[] cheatCodeAmmo = new int[]{C.getKey(7), C.getKey(11), C.getKey(11), C.getKey(11)};
    int[] cheatCodeCurrent = new int[]{C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0), C.getKey(0)};
    int[][] cheatCodeLevels = new int[][]{{C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(6)}, {C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(7)}, {C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(8)}, {C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(9)}, {C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(10)}, {C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(11)}, {C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(12)}, {C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(13)}, {C.getKey(8), C.getKey(11), C.getKey(15), C.getKey(14)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(15)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(6)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(7)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(8)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(9)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(10)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(11)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(12)}, {C.getKey(8), C.getKey(11), C.getKey(6), C.getKey(13)}};
    private int cheatCodeLastKeyPressed = -1;
    private boolean cheatIsLevelSkip = false;
    private byte cheatLevelNumber;
    private short cheatShowTime;
    private static boolean cheatCodeFlag;
    private static boolean cheatCodeImmortalFlag;
    static boolean cheatCodeAmmoFlag;
    private boolean cheatCodeTextSwitchStatus;
    private Vector citizens;
    private CitizenType[] citizenTypes;
    private Polygon collisionBoundingBox;
    private int collisionTestCarVsMobsCitizensHit;
    private int collisionTestCarVsMobsEnemiesHit;
    private int collisionTestCarVsMobsCopsHit;
    boolean coolisionIsCarPositionClamped;
    private Conversation[] conversation;
    private static byte conversationState;
    private static byte conversationBackInGameState;
    private static int conversationIndex;
    private static boolean crimeLevelIsEnabled;
    private static byte crimeEnemyId;
    private static int crimeLevelF;
    private static int crimeLevelInt;
    private static int crimeLevelTimeLeft;
    private boolean crimeLevelIsBlocked;
    private static int crimeLevelIndicatorBlinkingTime;
    private static int crimeLevelIndicatorFrameCounter;
    private static boolean crimeLevelIndicatorIsBlinking;
    private int crimeLevelTime;
    private byte crimeLevelIncomingCopsAtTriggersNumber;
    private byte crimeLevelIncomingCopsOnRadiusNumber;
    private int crimeLevelIncomingCopsArivvalRadius;
    private int crimeLevelCopsReactionRadious;
    private int crimeLevelCitizenKillPoints;
    private int crimeLevelCopKillPoints;
    private int crimeLevelCarHijackPoints;
    private int crimeLevelShootNearCopPoints;
    private byte[] dummiesSpriteID;
    private Dummy[] dummies;
    private static int effectFlashTimeMs;
    private static int effectFlashColor;
    private static int endGameState;
    private EnemyType[] enemyTypes;
    private Vector enemies;
    private static byte epilogState;
    private Citizen epilogCitizen;
    private Car epilogCar;
    private static int epilogDeathTimeCurrentMs;
    private Vector hotSpots;
    private Trigger hotSpotTriggerActive;
    private static Anim hudAnimation;
    private static byte hudMessagetType;
    private static boolean hudMessageIsVisible;
    private static int hudMessageDissplayTime;
    private static int hudMessageUpperPosX;
    private static int hudMessageLowerPosX;
    private static int hudMessageUpperCenterPosX;
    private static int hudMessageLowerCenterPosX;
    private static char[] hudTxtBuffer;
    private static int hudBloodTimeLeft;
    public static Anim introAnimation;
    private static byte introState;
    public static byte introFrameCurrent;
    public static byte introArrowsFrameCurrent;
    public static int introCurrentHeight;
    private short[] itemsLootTable;
    private Vector itemMessages;
    private static byte jackpotState;
    private static int[] jackpotSpeedf;
    private static int[] jackpotAccelerationf;
    private static int[][] jackpotSlot;
    private static Anim jackpotAnim;
    private static int jackpotTotalHeight;
    private static int jackpotFirstItemHeight;
    private static int[] jackpotItemDifferenceYf;
    private static int jackpotPrizeCurrent;
    private static int jackpotIndexOfPrizeCombinationCurrent;
    private static int jackpotNumberOfWinsItem;
    private static byte levelCurrent;
    private static byte levelLoaded;
    private static byte levelLoadingStage;
    private static byte levelLoadingReset;
    private static int levelLoadingPressFireTimeCurrent;
    private boolean levelLoadingIsPressFireTxtVisible;
    private byte levelEndingInGameState;
    private static long levelTimeCurrent;
    private short lockpickPosX;
    private short lockpickPointerPos;
    private short lockpickPointerSpeed;
    private boolean lockpickPointerMovingDirectionIsLeft;
    private short lockpickActiveAreaSizeCurrent;
    private short lockpickActiveAreaSizeFinal;
    private short lockpickActiveAreaSizeGrowingSpeed;
    private short lockpickActiveAreaSizeGrowingAcceleration;
    private short lockpickActiveAreaPosition;
    private boolean lockpickActiveAreaIsGrowing;
    private short lockpickBouncesNumber;
    private boolean lockpickInitializationFinished;
    private int messageStateTimer;
    private boolean messageResponseResult;
    public static TextBox messageTextBox;
    private static int messageWidth;
    private static int messageHeight;
    private static int messageTilesH;
    private static int messageTilesV;
    private static boolean messageEndAfterTime;
    private static boolean messageRunTriggerFinalize;
    private static boolean messageRunTriggerQestion;
    private static byte messageQuestionNegativeAnswerReleaseId;
    private static byte messageQuestionNegativeAnswerActivateId;
    private static int messageSoftLeft;
    private static int messageSoftRight;
    private int playerDriveIsInColl;
    private static boolean rainVisible;
    private int[] rainPositionX;
    private int[] rainPositionY;
    private int[] rainHeight;
    private static int rainUpLeftCornerCurrentXf;
    private static int rainUpLeftCornerCurrentYf;
    private static int rollerDifferenceCurrent;
    private static boolean rollerDirectionUp;
    private static byte rollerNextState;
    private byte scenarioProgressCounter;
    private Shop[] shops;
    private static int shopActiveId;
    private static int sniperAreaLeftUpCornerPosX;
    private static int sniperAreaLeftUpCornerPosY;
    private static int sniperAreaWidth;
    private static int sniperAreaHeight;
    private static int sniperState;
    private static int sniperCurrentPositionXf;
    private static int sniperCurrentPositionYf;
    private static byte sniperPlayerPreviousWeapon;
    private static int sniperSpeedCurrentXf;
    private static int sniperSpeedCurrentYf;
    private static int sniperOscillationCurrentTimeMS;
    private static int sniperShootMaxHeight;
    private static int sniperShootBeginHeight;
    private static int sniperOscillationSpeedX;
    private static int sniperOscillationSpeedY;
    long[] soundPlayTimes;
    private Vector[][] spatialZonesEnemies;
    private Vector[][] spatialZonesCars;
    private Vector[][] spatialZonesCitizens;
    private Vector[][] spatialZonesStaticNoCollision;
    private Vector[][] spatialZonesStaticCollision;
    private Vector[][] spatialZonesItems;
    private Vector[][] spatialZonesTrafficControlIndices;
    private int spatialZoneNearX1;
    private int spatialZoneNearX2;
    private int spatialZoneNearY1;
    private int spatialZoneNearY2;
    private boolean[] spritesAppearence;
    private Anim[] sprites;
    private static int spriteLastShown;
    Vector spritesVisible = new Vector();
    private static int spritesDisplayBorderLeftF;
    private static int spritesDisplayBorderRightF;
    private static int spritesDisplayBorderTopF;
    private static int spritesDisplayBorderBottomF;
    private static int spritesDisplaySpatialZoneVisibleLeft;
    private static int spritesDisplaySpatialZoneVisibleRight;
    private static int spritesDisplaySpatialZoneVisibleTop;
    private static int spritesDisplaySpatialZoneVisibleBottom;
    Vector timers;
    private boolean trafficLightsEnabled;
    private Vector trafficLights;
    private int trafficLightsTimeCounter;
    private TrafficControlZone[] trafficControlZones;
    private int transitionTimeMs;
    private boolean transitionIsOut;
    private byte transitionStateVisible;
    private static short transitionBarWidth;
    private static short transitionBarHeight;
    private static byte transitionNextInGameState;
    private boolean[] tutorialMessages;
    private int prevX;
    private int prevY;
    private boolean turnRight;
    private boolean turnLeft;
    private int turn = 0;
    public static boolean isInfoScreen;
    private char[] infoTxtLine0;
    private char[] infoTxtLine1;
    private char[] infoTxtLine2;
    private Anim infoLogo;
    Player pl;

    public Mafia(MIDlet mIDlet, int n, int n2) {
        midlet = mIDlet;
    }

    private void animationFrameCountersTick() {
        if (++animationGlobalCounter == 128) {
            animationGlobalCounter ^= animationGlobalCounter;
        }
    }

    private void animationFrameCountersReset() {
        animationGlobalCounter ^= animationGlobalCounter;
    }

    private static int getRangeQ(int n, int n2, int n3, int n4) {
        long l = n - n3;
        l *= l;
        long l2 = n2 - n4;
        l2 *= l2;
        return (int)((l >>= 10) + (l2 >>= 10));
    }

    public void gameTxtSet(Txt txt) {
        this.txt = txt;
    }

    public static boolean isPauseFreeze() {
        if (gameState == 1) {
            return inGameState != 0 && inGameState != 13;
        }
        return false;
    }

    public void newGame() {
        levelCurrent = 0;
        this.soundInit();
        this.tutorialMessages = new boolean[Cfg.TXT_ID_TUTORIAL_MESSAGES.length];
        this.introInit();
        player = new Player2();
        player.init(midlet, "Player.sse");
    }

    public void continueGame() {
        this.soundInit();
        player = new Player2();
        player.init(midlet, "Player.sse");
        this.loadGame();
        this.introInit();
    }

    private void pause() {
        Application.getSingleton().pause();
        if (Application.getSingleton().menu != null && Application.getSingleton().menu.getCurrentPage() != null) {
            Application.getSingleton().menu.getCurrentPage().selectItem(0);
        }
    }

    public void resume() {
    }

    public void dispose() {
        this.soundStopAll();
    }

    private void gameSetState(byte by) {
        gameState = by;
    }

    public byte getGameState() {
        return gameState;
    }

    public void update(int n) {
        if (n > 100) {
            n = 100;
        }
        if ((animationLastFrameTime = (short)(animationLastFrameTime + n)) > 100) {
            animationLastFrameTime = (short)(animationLastFrameTime - 100);
            this.animationFrameCountersTick();
        }
        switch (gameState) {
            case 0: {
                this.introUpdate(n);
                break;
            }
            case 1: {
                this.inGameUpdate(n);
                break;
            }
            case 2: {
                this.endGameUpdate(n);
                break;
            }
        }
    }

    public void paint(Graphics graphics) {
        switch (gameState) {
            case 0: {
                this.introPaint(graphics);
                break;
            }
            case 1: {
                this.inGamePaint(graphics, inGameState);
                break;
            }
            case 2: {
                this.endGamePaint(graphics);
                break;
            }
        }
    }

    private void cameraInit() {
        Trigger trigger;
        camera = new Camera(0, 0);
        camera.setBorders(0, (map.getCameraMaxPosX() << 10) + 1023 - Map.pixux, 0, Map.heightTotalF - (C.getScreenHeight() << 10) / Map.tileHeight - Map.pixuy);
        cameraOffsetCenterX = -((C.getScreenWidth() << 10) / Map.tileWidth >> 1);
        cameraOffsetCenterY = -((C.getScreenHeight() << 10) / Map.tileHeight >> 1);
        int n = 0;
        do {
            trigger = Map.layerTriggersSpawn.getTriggerByType(6, n);
            ++n;
        } while (trigger != null && trigger.params[0] != 0);
        if (trigger != null) {
            cameraOffsetCurrentXf = (trigger.posX << 10) - Mafia.player.positionXf;
            cameraOffsetCurrentYf = (trigger.posY << 10) - Mafia.player.positionYf;
        }
        this.cameraModeSet((byte)0);
        this.spritesCalculateVisibilityArea();
        this.spritesDisplayPrepare();
    }

    private void cameraEventLaunch(int n, int n2, byte by, byte by2) {
        int n3;
        int n4;
        Trigger trigger;
        camerTriggerFinalizeActivateId = by;
        cameraTriggerFinalizeReleaseId = by2;
        int n5 = 0;
        do {
            trigger = Map.layerTriggersSpawn.getTriggerByType(6, n5);
            ++n5;
        } while (trigger != null && trigger.params[0] != n);
        if (trigger != null) {
            n4 = (trigger.posX << 10) + 512;
            n3 = (trigger.posY << 10) + 512;
        } else {
            n4 = Mafia.player.positionXf;
            n3 = Mafia.player.positionYf;
        }
        cameraLookAtTime = n2;
        cameraLookAtOffsetXf = n4 - Mafia.player.positionXf;
        cameraLookAtOffsetYf = n3 - Mafia.player.positionYf;
        this.cameraModeSet((byte)4);
    }

    private void cameraModeSet(byte by) {
        cameraModePrevious = cameraMode;
        cameraMode = by;
    }

    private void cameraShakeInit(int n) {
        this.cameraIsShaking = true;
        this.cameraShakingTimeMs = n;
    }

    private void cameraUpdate(int n) {
        int n2;
        if (effectFlashTimeMs > 0) {
            effectFlashTimeMs -= n;
        }
        switch (cameraMode) {
            case 0: {
                cameraCurrentPositionXf = Mafia.player.positionXf;
                cameraCurrentPositionYf = Mafia.player.positionYf;
                switch (Mafia.player.direction) {
                    case 0: {
                        cameraOffsetDestXf = Mafia.player.speedCurrentXf == 0 ? -2048 : -1024;
                        cameraOffsetDestYf = 0;
                        break;
                    }
                    case 1: {
                        cameraOffsetDestXf = Mafia.player.speedCurrentXf == 0 ? 2048 : 1024;
                        cameraOffsetDestYf = 0;
                        break;
                    }
                    case 2: {
                        cameraOffsetDestXf = 0;
                        cameraOffsetDestYf = Mafia.player.speedCurrentYf == 0 ? -3072 : -1024;
                        break;
                    }
                    case 3: {
                        cameraOffsetDestXf = 0;
                        cameraOffsetDestYf = Mafia.player.speedCurrentYf == 0 ? 3072 : 1024;
                    }
                }
                break;
            }
            case 1: {
                cameraCarOffset.rotate(Car.v1, Mafia.player.car.bodyAngleExactF);
                cameraCarOffset.mulByConstF(Mafia.player.car.driveSpeed);
                cameraOffsetDestXf = Mafia.cameraCarOffset.x * Cfg.CAMERA_ON_CAR_OFFSET_HORIZONTAL_MAX >> 10;
                cameraOffsetDestYf = Mafia.cameraCarOffset.y * Cfg.CAMERA_ON_CAR_OFFSET_VERTICAL_MAX >> 10;
                cameraCurrentPositionXf = Mafia.player.car.positionXf;
                cameraCurrentPositionYf = Mafia.player.car.positionYf;
                break;
            }
            case 2: {
                cameraCurrentPositionXf = sniperCurrentPositionXf;
                cameraCurrentPositionYf = sniperCurrentPositionYf;
                break;
            }
            case 4: {
                cameraOffsetDestXf = cameraLookAtOffsetXf;
                cameraOffsetDestYf = cameraLookAtOffsetYf;
                if (cameraOffsetCurrentXf != cameraOffsetDestXf || cameraOffsetCurrentYf != cameraOffsetDestYf) break;
                if (cameraLookAtTime > 0) {
                    cameraLookAtTime -= n;
                    break;
                }
                cameraOffsetDestXf ^= cameraOffsetDestXf;
                cameraOffsetDestYf ^= cameraOffsetDestYf;
                this.cameraModeSet(cameraModePrevious);
                if (camerTriggerFinalizeActivateId >= 0) {
                    this.hotspotActivate(camerTriggerFinalizeActivateId);
                }
                if (cameraTriggerFinalizeReleaseId < 0) break;
                this.hotspotTriggerRelease(cameraTriggerFinalizeReleaseId);
            }
        }
        if (this.cameraIsShaking) {
            if (this.cameraShakingTimeMs > 0) {
                this.cameraShakeOffsetX = Util.getRandom(-384, 384);
                this.cameraShakeOffsetY = Util.getRandom(-384, 384);
                this.cameraShakingTimeMs -= n;
            } else {
                this.cameraShakeOffsetX = 0;
                this.cameraShakeOffsetY = 0;
                this.cameraIsShaking = false;
            }
        }
        if (cameraOffsetCurrentXf != cameraOffsetDestXf) {
            n2 = 80 * (cameraOffsetDestXf - cameraOffsetCurrentXf) >> 10;
            if (n2 != 0) {
                if (n2 > 0) {
                    if (n2 < Map.pixux) {
                        n2 = Map.pixux;
                    }
                    cameraOffsetCurrentXf = cameraOffsetCurrentXf + n2 > cameraOffsetDestXf ? cameraOffsetDestXf : cameraOffsetCurrentXf + n2;
                } else {
                    if (n2 > -Map.pixux) {
                        n2 = -Map.pixux;
                    }
                    cameraOffsetCurrentXf = cameraOffsetCurrentXf + n2 < cameraOffsetDestXf ? cameraOffsetDestXf : cameraOffsetCurrentXf + n2;
                }
            } else {
                cameraOffsetCurrentXf = cameraOffsetDestXf;
            }
        }
        if (cameraOffsetCurrentYf != cameraOffsetDestYf) {
            n2 = 80 * (cameraOffsetDestYf - cameraOffsetCurrentYf) >> 10;
            if (n2 != 0) {
                if (n2 > 0) {
                    if (n2 < Map.pixuy) {
                        n2 = Map.pixuy;
                    }
                    cameraOffsetCurrentYf = cameraOffsetCurrentYf + n2 > cameraOffsetDestYf ? cameraOffsetDestYf : cameraOffsetCurrentYf + n2;
                } else {
                    if (n2 > -Map.pixuy) {
                        n2 = -Map.pixuy;
                    }
                    cameraOffsetCurrentYf = cameraOffsetCurrentYf + n2 < cameraOffsetDestYf ? cameraOffsetDestYf : cameraOffsetCurrentYf + n2;
                }
            } else {
                cameraOffsetCurrentYf = cameraOffsetDestYf;
            }
        }
        camera.setPos(cameraCurrentPositionXf + cameraOffsetCurrentXf + cameraOffsetCenterX + this.cameraShakeOffsetX, cameraCurrentPositionYf + cameraOffsetCurrentYf + cameraOffsetCenterY + this.cameraShakeOffsetY);
        this.spritesCalculateVisibilityArea();
        this.spritesDisplayPrepare();
    }

    private void carAIMove(Car car, int n) {
        car.aiMove(n);
        if (car.positionXf < 0 || car.positionXf >= Map.widthTotalF || car.positionYf < 0 || car.positionYf >= Map.heightTotalF) {
            car.stateChange((byte)-3);
            return;
        }
        if (!this.carAiMovePermission(car)) {
            car.stateChange((byte)6);
        }
        int n2 = car.mp.x >> 10;
        int n3 = car.mp.y >> 10;
        int n4 = car.mp.x >> 13;
        int n5 = car.mp.y >> 13;
        short s = -1;
        boolean bl = false;
        for (int i = 0; i < this.spatialZonesTrafficControlIndices[n4][n5].size(); ++i) {
            s = (Short)this.spatialZonesTrafficControlIndices[n4][n5].elementAt(i);
            TrafficControlZone trafficControlZone = this.trafficControlZones[s];
            if (n2 < trafficControlZone.positionLeft || n2 > trafficControlZone.positionRight || n3 < trafficControlZone.positionUp || n3 > trafficControlZone.positionDown) continue;
            if (s != car.trafficControlZoneId) {
                if (car.direction == 0 || car.direction == 1) {
                    if (trafficControlZone.state != 1 && trafficControlZone.state != 0) {
                        car.stateChange((byte)7);
                    }
                } else if (trafficControlZone.state != 5 && trafficControlZone.state != 4) {
                    car.stateChange((byte)7);
                }
            }
            bl = true;
            break;
        }
        car.trafficControlZoneId = bl ? (short)s : (short)-1;
        n2 = car.positionXf >> 13;
        n3 = car.positionYf >> 13;
        if (Map.layerTriggersNpcCtrl.triggers[n2][n3] != null) {
            int n6 = Map.layerTriggersNpcCtrl.triggers[n2][n3].length;
            --n6;
            while (n6 >= 0) {
                Trigger trigger = Map.layerTriggersNpcCtrl.triggers[n2][n3][n6];
                if (trigger.type == 2) {
                    n4 = trigger.posX;
                    n4 += n2 << 3;
                    n4 = (n4 << 10) + 512;
                    n5 = trigger.posY;
                    n5 += n3 << 3;
                    int n7 = Mafia.getRangeQ(car.positionXf, car.positionYf, n4, n5 = (n5 << 10) + 512);
                    if (n7 <= 2304) {
                        if (trigger != car.lastTrigger) {
                            car.lastTrigger = trigger;
                            this.carAIMoveStartTurn(car, trigger);
                        }
                        return;
                    }
                }
                --n6;
            }
            car.lastTrigger = null;
        }
    }

    private boolean carAiMovePermission(Car car) {
        if (Mafia.getRangeQ(car.mp.x, car.mp.y, Mafia.player.positionXf, Mafia.player.positionYf) <= car.carType.movingSensorRadiusQf) {
            return false;
        }
        int n = car.carType.movingSensorRadiusQf;
        this.spatialZonesCalcNear(car.mp.x, car.mp.y);
        for (int i = this.spatialZoneNearY1; i <= this.spatialZoneNearY2; ++i) {
            for (int j = this.spatialZoneNearX1; j <= this.spatialZoneNearX2; ++j) {
                int n2 = this.spatialZonesCars[j][i].size();
                --n2;
                while (n2 >= 0) {
                    Car car2 = (Car)this.spatialZonesCars[j][i].elementAt(n2);
                    if (car2 != car && Mafia.getRangeQ(car.mp.x, car.mp.y, car2.positionXf, car2.positionYf) <= car2.carType.boundingCircleRadiusQf) {
                        return false;
                    }
                    --n2;
                }
                n2 = this.spatialZonesCitizens[j][i].size();
                --n2;
                while (n2 >= 0) {
                    Citizen citizen = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n2);
                    if (Mafia.getRangeQ(car.mp.x, car.mp.y, citizen.positionXf, citizen.positionYf) <= n) {
                        return false;
                    }
                    --n2;
                }
                n2 = this.spatialZonesEnemies[j][i].size();
                --n2;
                while (n2 >= 0) {
                    Enemy enemy = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n2);
                    if (Mafia.getRangeQ(car.mp.x, car.mp.y, enemy.positionXf, enemy.positionYf) <= n) {
                        return false;
                    }
                    --n2;
                }
            }
        }
        return true;
    }

    private void carAIMoveStartTurn(Car car, Trigger trigger) {
        byte by;
        byte by2 = 0;
        if (car.directionForbidden != -1) {
            by2 = Sprite.getDirectionMask(car.directionForbidden);
        }
        if ((by = Sprite.directionRandomGenerate((byte)trigger.params[0], by2)) != car.direction) {
            switch (by) {
                case 0: 
                case 1: {
                    if (car.direction == 2) {
                        car.directionForbidden = (byte)3;
                        break;
                    }
                    if (car.direction == 3) {
                        car.directionForbidden = (byte)2;
                        break;
                    }
                    car.directionForbidden = (byte)-1;
                    break;
                }
                case 2: 
                case 3: {
                    car.directionForbidden = car.direction == 0 ? (byte)1 : (car.direction == 1 ? (byte)0 : (byte)-1);
                }
            }
        } else {
            car.directionForbidden = (byte)-1;
        }
        car.directionDest = by;
        switch (car.directionDest) {
            case 3: {
                car.aiMovingDestAngle = 0;
                break;
            }
            case 0: {
                car.aiMovingDestAngle = 92160;
                break;
            }
            case 2: {
                car.aiMovingDestAngle = 184320;
                break;
            }
            case 1: {
                car.aiMovingDestAngle = 276480;
            }
        }
        car.stateChange((byte)4);
        if (car.aiMovingAngle - car.aiMovingDestAngle >= 184320) {
            car.aiMovingAngle -= 368640;
        } else if (car.aiMovingDestAngle - car.aiMovingAngle > 184320) {
            car.aiMovingAngle += 368640;
        }
    }

    private void carAIMoveTurn(Car car, int n) {
        if (!this.carAiMovePermission(car)) {
            car.stateChange((byte)6);
        }
        car.aiMove(n);
        if (car.positionXf < 0 || car.positionXf >= Map.widthTotalF || car.positionYf < 0 || car.positionYf >= Map.heightTotalF) {
            car.stateChange((byte)-3);
            return;
        }
        int n2 = car.mp.x >> 10;
        int n3 = car.mp.y >> 10;
        int n4 = car.mp.x >> 13;
        int n5 = car.mp.y >> 13;
        short s = -1;
        boolean bl = false;
        for (int i = 0; i < this.spatialZonesTrafficControlIndices[n4][n5].size(); ++i) {
            s = (Short)this.spatialZonesTrafficControlIndices[n4][n5].elementAt(i);
            TrafficControlZone trafficControlZone = this.trafficControlZones[s];
            if (n2 < trafficControlZone.positionLeft || n2 > trafficControlZone.positionRight || n3 < trafficControlZone.positionUp || n3 > trafficControlZone.positionDown) continue;
            if (s != car.trafficControlZoneId) {
                if (car.direction == 0 || car.direction == 1) {
                    if (trafficControlZone.state != 1 && trafficControlZone.state != 0) {
                        car.stateChange((byte)7);
                    }
                } else if (trafficControlZone.state != 5 && trafficControlZone.state != 4) {
                    car.stateChange((byte)7);
                }
            }
            bl = true;
            break;
        }
        car.trafficControlZoneId = bl ? (short)s : (short)-1;
        if (car.aiMovingAngle == car.aiMovingDestAngle) {
            car.direction = car.directionDest;
            car.stateChange((byte)1);
        }
    }

    private void carMoveToSpawnWaitingQueue(Car car) {
        car.energyPoints = car.carType.energyPointsMax;
        car.proposedPositionXf = car.positionXf = car.spawnPositionXf;
        car.proposedPositionYf = car.positionYf = car.spawnPositionYf;
        car.particleSystemCarSmokeLeft = null;
        car.particleSystemCarSmokeRight = null;
        car.setAngle(car.spawnBodyAngle16);
        car.aiMovingDestAngle = car.aiMovingAngle = car.getBodyAngle();
        car.setDirectionFromBodyAngle();
        car.geometryUpdate();
        car.accept();
        car.geometryVisibleUpdate();
        car.stateReset();
        car.stateChange(car.spawnState);
        car.lastTrigger = null;
        this.carsWaitingForSpawn.addElement(car);
    }

    private void carCollisionResponse(Car car, Car car2) {
        try {
            if (car2.getState() != 5) {
                car2.stateChange((byte)9);
            }
            Vect vect = new Vect(-Polygon.mtd.x, -Polygon.mtd.y);
            vect.normalize();
            Vect vect2 = new Vect();
            if (Polygon.contactPointsNumber == 2) {
                vect2.x = Polygon.contactPointsB[0].x + Polygon.contactPointsB[1].x >> 1;
                vect2.y = Polygon.contactPointsB[0].y + Polygon.contactPointsB[1].y >> 1;
            } else {
                vect2.x = Polygon.contactPointsB[0].x;
                vect2.y = Polygon.contactPointsB[0].y;
            }
            vect2.x -= car2.positionXf;
            vect2.y -= car2.positionYf;
            car2.mtdx -= Polygon.mtd.x;
            car2.mtdy -= Polygon.mtd.y;
            car2.applyForce(vect2, vect, car.getMovementSummarySpeed() >> 1);
        }
        catch (Exception exception) {
            C.out(N, "car coll response");
        }
    }

    private void carEnviromentCollisionReaction(Car car, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = Mafia.getRangeQ(n, n2, car.proposedBoundingBox.vertices[0].x, car.proposedBoundingBox.vertices[0].y);
        for (n3 = 1; n3 < 4; ++n3) {
            int n6 = Mafia.getRangeQ(n, n2, car.proposedBoundingBox.vertices[n3].x, car.proposedBoundingBox.vertices[n3].y);
            if (n6 >= n5) continue;
            n4 = (byte)n3;
            n5 = n6;
        }
        n3 = Mat.rad2deg10((car.getMovementSummarySpeed() >> 1 << 10) / 1536);
        Vect vect = new Vect();
        if (n4 == 0 || n4 == 3) {
            vect.rotate(Car.v1, car.bodyAngleF + 92160);
            if (n4 == 3) {
                n3 = -n3;
            }
        } else {
            vect.rotate(Car.v1, car.bodyAngleF - 92160);
            if (n4 == 1) {
                n3 = -n3;
            }
        }
        vect.mulByConstF(car.getMovementSummarySpeed() >> 1);
        car.outerMovementNew.x += vect.x;
        car.outerMovementNew.y += vect.y;
        car.outerMovementNew.set(vect);
        car.driveRotationSpeedF = -car.driveRotationSpeedF;
        car.outerRotationSpeed += n3;
    }

    private void carDriveHit() {
        if (Mat.abs(Mafia.player.car.driveSpeed) >= 2000) {
            int n = Mat.abs(Mafia.player.car.driveSpeed) * 30 / Mafia.player.car.carType.vMaxF;
            if (!cheatCodeImmortalFlag) {
                if (player.damageTake(n)) {
                    Mafia.player.car.stopNow();
                    this.effectFlashInit(0xFFFFFF);
                    this.carExplosion((short)(Mafia.player.car.bodyAngleF >> 10));
                    this.cameraShakeInit(500);
                } else {
                    Mafia.player.car.speedClamp();
                }
            }
        }
    }

    private void carDriveUpdate(int n) {
        Mafia.player.positionXf = Mafia.player.car.positionXf;
        Mafia.player.positionYf = Mafia.player.car.positionYf;
        byte by = 0;
        if (C.getAction(4096)) {
            if (!Mafia.player.carExitIsBlocked) {
                by = 16;
                C.keyClear();
            }
        } else {
            if (C.getAction(1)) {
                by = (byte)(by | 4);
            } else if (C.getAction(2)) {
                by = (byte)(by | 8);
            }
            if (C.getAction(4)) {
                by = (byte)(by | 1);
            } else if (C.getAction(8)) {
                by = (byte)(by | 2);
            }
        }
        if (player.getState() == 12) {
            Mafia.player.stateTime += (long)n;
            if (Mafia.player.stateTime > (long)Mafia.player.stateTimeDeathInCar) {
                this.inGameSetState((byte)12);
                return;
            }
            by = 0;
        }
        if (Car.isStopping && Mafia.player.car.driveSpeed == 0) {
            Car.isStopping = false;
            this.playerCarExit();
            return;
        }
        Mafia.player.car.setAction(by);
        Mafia.player.car.driveUpdate(n);
        if (this.collisionTestCarVsEnv(Mafia.player.car)) {
            Mafia.player.car.driveSpeed -= Mafia.player.car.driveSpeed >> 2;
            if (this.playerDriveIsInColl > 0) {
                if (this.playerDriveIsInColl > 10) {
                    Mafia.player.car.rotationSpeedF = 0;
                    Mafia.player.car.outerRotationSpeed = 0;
                    Mafia.player.car.adjustMovementToBodyAngle();
                    Mafia.player.car.stopNow();
                }
                ++this.playerDriveIsInColl;
                return;
            }
            ++this.playerDriveIsInColl;
            int n2 = Polygon.contactPointsA[0].x;
            int n3 = Polygon.contactPointsA[0].y;
            if (Polygon.contactPointsNumber == 2) {
                n2 += Polygon.contactPointsA[1].x;
                n2 >>= 1;
                n3 += Polygon.contactPointsA[1].y;
                n3 >>= 1;
            }
            this.carEnviromentCollisionReaction(Mafia.player.car, n2, n3);
            if (!this.coolisionIsCarPositionClamped) {
                this.carDriveHit();
            }
            return;
        }
        this.playerDriveIsInColl = 0;
        Car car = this.collisionTestCarVsCars(Mafia.player.car);
        if (car != null) {
            this.carCollisionResponse(Mafia.player.car, car);
            Mafia.player.car.driveSpeed -= Mafia.player.car.driveSpeed >> 2;
            int n4 = Polygon.contactPointsA[0].x;
            int n5 = Polygon.contactPointsA[0].y;
            if (Polygon.contactPointsNumber == 2) {
                n4 += Polygon.contactPointsA[1].x;
                n4 >>= 1;
                n5 += Polygon.contactPointsA[1].y;
                n5 >>= 1;
            }
            this.carEnviromentCollisionReaction(Mafia.player.car, n4, n5);
            Mafia.player.car.outerMovementNew.x >>= 1;
            Mafia.player.car.outerMovementNew.y >>= 1;
            Mafia.player.car.outerRotationSpeed >>= 1;
            this.carDriveHit();
        } else {
            this.collisionTestCarVsMobs(Mafia.player.car);
            if (this.collisionTestCarVsMobsCitizensHit > 0) {
                this.crimeLevelIncrease(this.crimeLevelCitizenKillPoints, true);
            }
            if (this.collisionTestCarVsMobsCopsHit > 0) {
                this.crimeLevelIncrease(this.crimeLevelCopKillPoints, true);
            }
            Mafia.player.car.accept();
        }
        this.playerHotSpotTest();
    }

    private void carPushedUpdate(Car car, int n) {
        if (car.stateTime >= 10000L) {
            car.stateChange((byte)10);
            return;
        }
        car.move(n);
        car.rotate(n);
        if (this.collisionTestCarVsEnv(car)) {
            int n2 = Polygon.contactPointsA[0].x;
            int n3 = Polygon.contactPointsA[0].y;
            if (Polygon.contactPointsNumber == 2) {
                n2 += Polygon.contactPointsA[1].x;
                n2 >>= 1;
                n3 += Polygon.contactPointsA[1].y;
                n3 >>= 1;
            }
            this.carEnviromentCollisionReaction(car, n2, n3);
        } else {
            Car car2 = this.collisionTestCarVsCars(car);
            if (car2 != null) {
                this.carCollisionResponse(car, car2);
                car.outerMovementNew.x >>= 1;
                car.outerMovementNew.y >>= 1;
                car.outerRotationSpeed = -car.outerRotationSpeed;
                car.outerRotationSpeed >>= 1;
            } else {
                this.collisionTestCarVsMobs(car);
                car.accept();
            }
        }
    }

    private void carExplosion(short s) {
    }

    private void carWorldAssign(Car car) {
        if (car.getState() < 0) {
            if (car.getState() == -2) {
                this.spatialZonesCars[car.shX][car.shY].removeElement(car);
                this.cars.removeElement(car);
            } else if (car.getState() == -3) {
                this.spatialZonesCars[car.shX][car.shY].removeElement(car);
                this.cars.removeElement(car);
                this.carMoveToSpawnWaitingQueue(car);
            }
        } else {
            int n = car.shX;
            int n2 = car.shY;
            car.spatialIndicesCalculate();
            if (n != car.shX || n2 != car.shY) {
                this.spatialZonesCars[car.shX][car.shY].addElement(car);
                this.spatialZonesCars[n][n2].removeElement(car);
            }
        }
    }

    private void carUpdate(Car car, int n) {
        car.update(n);
        switch (car.getState()) {
            case 0: {
                break;
            }
            case 1: {
                this.carAIMove(car, n);
                break;
            }
            case 4: {
                this.carAIMoveTurn(car, n);
                break;
            }
            case 6: {
                if (car.stateTime < 800L) break;
                if (this.carAiMovePermission(car)) {
                    car.aiWaitingForMoveTrialsCounter = 0;
                    car.statePrevious();
                    break;
                }
                car.stateTime = 0L;
                if (car.aiWaitingForMoveTrialsCounter <= 5) {
                    ++car.aiWaitingForMoveTrialsCounter;
                    break;
                }
                if (car.positionXf >= spritesDisplayBorderLeftF && car.positionXf <= spritesDisplayBorderRightF && car.positionYf >= spritesDisplayBorderTopF && car.positionYf <= spritesDisplayBorderBottomF) break;
                car.stateChange((byte)-3);
                break;
            }
            case 7: {
                if (car.stateTime < (long)car.trafficControlTimeToStart) break;
                if (car.direction == 0 || car.direction == 1) {
                    if (this.trafficControlZones[car.trafficControlZoneId].state != 1) break;
                    car.statePrevious();
                    break;
                }
                if (this.trafficControlZones[car.trafficControlZoneId].state != 5) break;
                car.statePrevious();
                break;
            }
            case 8: {
                if (car.stateTime < 20000L) break;
                car.stateChange((byte)10);
                break;
            }
            case 9: {
                this.carPushedUpdate(car, n);
                break;
            }
            case 10: {
                if (car.positionXf >= spritesDisplayBorderLeftF && car.positionXf <= spritesDisplayBorderRightF && car.positionYf >= spritesDisplayBorderTopF && car.positionYf <= spritesDisplayBorderBottomF) break;
                car.stateChange((byte)-3);
                break;
            }
            case 11: {
                if (car.stateTime < 1300L) break;
                car.stateChange((byte)-2);
            }
        }
    }

    private CarType[] carsDetermineAppearance(int n) {
        Trigger trigger;
        int n2;
        CarType[] carTypeArray = new CarType[n];
        for (n2 = 0; n2 < n; ++n2) {
            carTypeArray[n2] = null;
        }
        n2 = 0;
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(4, n2++)) != null) {
            if (carTypeArray[trigger.params[0]] != null) continue;
            carTypeArray[trigger.params[0]] = new CarType();
        }
        return carTypeArray;
    }

    private void carsSettingsLoad() {
        block11: {
            FilterInputStream filterInputStream = null;
            try {
                int n;
                filterInputStream = new DataInputStream(midlet.getClass().getResourceAsStream("Cars.sse"));
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readShort();
                short s = ((DataInputStream)filterInputStream).readShort();
                int n2 = ((DataInputStream)filterInputStream).readShort();
                this.carTypes = this.carsDetermineAppearance(n2);
                for (n = 0; n < n2; ++n) {
                    if (this.carTypes[n] != null) {
                        this.carTypes[n].init();
                        this.carTypes[n].spriteId = (byte)((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].vMaxF = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].vClamped75 = this.carTypes[n].vMaxF * 75 / 100;
                        this.carTypes[n].vClamped50 = this.carTypes[n].vMaxF * 50 / 100;
                        this.carTypes[n].vClamped25 = this.carTypes[n].vMaxF * 25 / 100;
                        this.carTypes[n].vMaxRearF = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].accelerationF = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].breakRetardationF = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].accelerationRearF = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].turnRetardatiionF = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].turnSpeedMinF = ((DataInputStream)filterInputStream).readShort() << 10;
                        this.carTypes[n].turnSpeedMaxF = ((DataInputStream)filterInputStream).readShort() << 10;
                        this.carTypes[n].turnSpeedRearMinF = ((DataInputStream)filterInputStream).readShort() << 10;
                        this.carTypes[n].turnSpeedRearMaxF = ((DataInputStream)filterInputStream).readShort() << 10;
                        this.carTypes[n].turnSpeedMultiplierF = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].energyPointsMax = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].energyPoints75 = this.carTypes[n].energyPointsMax * 75 / 100;
                        this.carTypes[n].energyPoints50 = this.carTypes[n].energyPointsMax * 50 / 100;
                        this.carTypes[n].energyPoints25 = this.carTypes[n].energyPointsMax * 25 / 100;
                        continue;
                    }
                    ((DataInputStream)filterInputStream).skipBytes(s << 1);
                }
                for (n = 0; n < this.carTypes.length; ++n) {
                    s = ((DataInputStream)filterInputStream).readShort();
                    n2 = ((DataInputStream)filterInputStream).readShort();
                    if (this.carTypes[n] != null) {
                        int n3;
                        for (n3 = 0; n3 < 4; ++n3) {
                            this.carTypes[n].geometryBody[n3] = new Vect(((DataInputStream)filterInputStream).readShort(), ((DataInputStream)filterInputStream).readShort());
                        }
                        for (n3 = 0; n3 < 4; ++n3) {
                            this.carTypes[n].geometryWheels[n3] = new Vect(((DataInputStream)filterInputStream).readShort(), ((DataInputStream)filterInputStream).readShort());
                        }
                        for (n3 = 0; n3 < 4; ++n3) {
                            this.carTypes[n].geometryShadow[n3] = new Vect(((DataInputStream)filterInputStream).readShort(), ((DataInputStream)filterInputStream).readShort());
                        }
                        this.carTypes[n].geometryShadowOffsetXf = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].geometryShadowOffsetYf = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].geometryExitPoint = new Vect(((DataInputStream)filterInputStream).readShort(), ((DataInputStream)filterInputStream).readShort());
                        this.carTypes[n].geometrySmokeEmiterLeft = new Vect(((DataInputStream)filterInputStream).readShort(), ((DataInputStream)filterInputStream).readShort());
                        this.carTypes[n].geometrySmokeEmiterRight = new Vect(((DataInputStream)filterInputStream).readShort(), ((DataInputStream)filterInputStream).readShort());
                        this.carTypes[n].boundingCircleRadiusQf = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].boundingCircleRadiusQf = this.carTypes[n].boundingCircleRadiusQf * this.carTypes[n].boundingCircleRadiusQf >> 10;
                        ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].movingSensor = new Vect(0, ((DataInputStream)filterInputStream).readShort());
                        this.carTypes[n].movingSensorRadiusQf = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].movingSensorRadiusQf = this.carTypes[n].movingSensorRadiusQf * this.carTypes[n].movingSensorRadiusQf >> 10;
                        this.carTypes[n].geometryVerticalMultipier = ((DataInputStream)filterInputStream).readShort();
                        this.carTypes[n].geometryVerticalOffset = ((DataInputStream)filterInputStream).readShort();
                        continue;
                    }
                    ((DataInputStream)filterInputStream).skipBytes(s * n2 << 1);
                }
                filterInputStream.close();
            }
            catch (Exception exception) {
                if (filterInputStream == null) break block11;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void carsSpawn() {
        Trigger trigger;
        int n = 0;
        this.cars = new Vector();
        this.carsWaitingForSpawn = new Vector();
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(4, n)) != null) {
            if (trigger.params[3] != 2) {
                Car car = new Car();
                car.init(this.carTypes[trigger.params[0]], (trigger.posX << 10) + 512, (trigger.posY << 10) + 512, trigger.params[1], (byte)trigger.params[3]);
                this.cars.addElement(car);
            }
            ++n;
        }
    }

    private void carsSpawnWaiting(int n) {
        Trigger trigger;
        int n2 = 0;
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(4, n2)) != null) {
            if (trigger.params[0] == n && trigger.params[3] == 2) {
                Car car = new Car();
                car.init(this.carTypes[trigger.params[0]], (trigger.posX << 10) + 512, (trigger.posY << 10) + 512, trigger.params[1], (byte)0);
                this.cars.addElement(car);
                car.spatialIndicesCalculate();
                this.spatialZonesCars[car.shX][car.shY].addElement(car);
            }
            ++n2;
        }
    }

    private void carsUpdate(int n) {
        int n2 = this.carsWaitingForSpawn.size();
        --n2;
        while (n2 >= 0) {
            Car car = (Car)this.carsWaitingForSpawn.elementAt(n2);
            if (!(this.collisionTestCarVsCars(car) != null || this.collisionTestCarVsMobsAny(car) || car.positionXf >= spritesDisplayBorderLeftF && car.positionXf <= spritesDisplayBorderRightF && car.positionYf >= spritesDisplayBorderTopF && car.positionYf <= spritesDisplayBorderBottomF)) {
                this.carsWaitingForSpawn.removeElementAt(n2);
                this.cars.addElement(car);
                car.spatialIndicesCalculate();
                this.spatialZonesCars[car.shX][car.shY].addElement(car);
            }
            --n2;
        }
        n2 = this.cars.size();
        --n2;
        while (n2 >= 0) {
            this.carUpdate((Car)this.cars.elementAt(n2), n);
            ((Car)this.cars.elementAt((int)n2)).mtdx = 0;
            ((Car)this.cars.elementAt((int)n2)).mtdy = 0;
            this.carWorldAssign((Car)this.cars.elementAt(n2));
            --n2;
        }
    }

    private void carsShadowsPaint(Graphics graphics) {
        int n = 0;
        int n2 = Mafia.camera.posXf;
        int n3 = Mafia.camera.posYf;
        for (int i = spritesDisplaySpatialZoneVisibleTop; i <= spritesDisplaySpatialZoneVisibleBottom; ++i) {
            for (int j = spritesDisplaySpatialZoneVisibleLeft; j <= spritesDisplaySpatialZoneVisibleRight; ++j) {
                n ^= n;
                while (n < this.spatialZonesCars[j][i].size()) {
                    Car car = (Car)this.spatialZonesCars[j][i].elementAt(n);
                    if (car.positionXf <= spritesDisplayBorderRightF && car.positionXf >= spritesDisplayBorderLeftF && car.positionYf <= spritesDisplayBorderBottomF && car.positionYf >= spritesDisplayBorderTopF) {
                        int n4 = (car.geometryCurrentShadow[0].x - n2) * Map.tileWidth + 512 >> 10;
                        int n5 = (car.geometryCurrentShadow[0].y - n3) * Map.tileWidth + 512 >> 10;
                        int n6 = (car.geometryCurrentShadow[1].x - n2) * Map.tileWidth + 512 >> 10;
                        int n7 = (car.geometryCurrentShadow[1].y - n3) * Map.tileWidth + 512 >> 10;
                        int n8 = (car.geometryCurrentShadow[3].x - n2) * Map.tileWidth + 512 >> 10;
                        int n9 = (car.geometryCurrentShadow[3].y - n3) * Map.tileWidth + 512 >> 10;
                        int n10 = (car.geometryCurrentShadow[2].x - n2) * Map.tileWidth + 512 >> 10;
                        int n11 = (car.geometryCurrentShadow[2].y - n3) * Map.tileWidth + 512 >> 10;
                        graphics.setColor(0x2C2C2C);
                        graphics.fillTriangle(n8, n9, n4, n5, n6, n7);
                        graphics.fillTriangle(n6, n7, n10, n11, n8, n9);
                    }
                    ++n;
                }
            }
        }
    }

    private void cheatCheckResult() {
        if (this.cheatIsLevelSkip) {
            this.cheatIsLevelSkip = false;
            levelCurrent = this.cheatLevelNumber;
            this.levelDispose();
            this.introInit();
        }
    }

    private void cheatUpdate(int n) {
        cheatCodeFlag = false;
        if (this.cheatShowTime > 0) {
            this.cheatShowTime = (short)(this.cheatShowTime - n);
        }
        if (C.isKeyChanged()) {
            if (this.cheatCodeLastKeyPressed != C.getLastKeyPressed() && C.getLastKeyPressed() != 0) {
                this.cheatCodeLastKeyPressed = C.getLastKeyPressed();
                cheatCodeFlag = true;
            } else {
                this.cheatCodeLastKeyPressed = -1;
            }
        }
        if (cheatCodeFlag) {
            int n2;
            this.cheatCodeCurrent[this.cheatCodeCurrent.length - 1] = this.cheatCodeLastKeyPressed;
            cheatCodeFlag = false;
            if (this.cheatCodeLastKeyPressed == C.getKey(18)) {
                int n3;
                n2 = this.cheatCodeCurrent.length - 1 - 4 - this.cheatCodeBase.length;
                boolean bl = true;
                int n4 = 0;
                for (n3 = n2; n3 < this.cheatCodeCurrent.length - 1 - 4; ++n3) {
                    if (this.cheatCodeCurrent[n3] != this.cheatCodeBase[n4]) {
                        bl = false;
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    block1: for (n3 = 0; n3 < this.cheatCodeLevels.length; ++n3) {
                        n4 = this.cheatCodeCurrent.length - 5;
                        for (int i = 0; i < this.cheatCodeLevels[n3].length; ++i) {
                            if (this.cheatCodeCurrent[n4] == this.cheatCodeLevels[n3][i] && i == this.cheatCodeLevels[n3].length - 1) {
                                cheatCodeFlag = true;
                                this.cheatIsLevelSkip = true;
                                this.cheatLevelNumber = (byte)n3;
                                this.effectFlashInit(0xFFFFFF);
                                C.keyClear();
                            } else if (this.cheatCodeCurrent[n4] != this.cheatCodeLevels[n3][i]) continue block1;
                            ++n4;
                        }
                    }
                    n4 = this.cheatCodeCurrent.length - 5;
                    for (n3 = 0; n3 < this.cheatCodeImmo.length; ++n3) {
                        if (this.cheatCodeCurrent[n4] == this.cheatCodeImmo[n3] && n3 == this.cheatCodeImmo.length - 1) {
                            this.cheatCodeTextSwitchStatus = !cheatCodeImmortalFlag;
                            cheatCodeImmortalFlag = this.cheatCodeTextSwitchStatus;
                            this.cheatShowTime = (short)1000;
                            this.effectFlashInit(0xFFFFFF);
                            C.keyClear();
                        } else if (this.cheatCodeCurrent[n4] != this.cheatCodeImmo[n3]) break;
                        ++n4;
                    }
                    n4 = this.cheatCodeCurrent.length - 5;
                    for (n3 = 0; n3 < this.cheatCodeAmmo.length; ++n3) {
                        if (this.cheatCodeCurrent[n4] == this.cheatCodeAmmo[n3] && n3 == this.cheatCodeAmmo.length - 1) {
                            this.cheatCodeTextSwitchStatus = !cheatCodeAmmoFlag;
                            cheatCodeAmmoFlag = this.cheatCodeTextSwitchStatus;
                            this.cheatShowTime = (short)1000;
                            this.effectFlashInit(0xFFFFFF);
                            C.keyClear();
                        } else if (this.cheatCodeCurrent[n4] != this.cheatCodeAmmo[n3]) break;
                        ++n4;
                    }
                }
            }
            for (n2 = 0; n2 < this.cheatCodeCurrent.length - 1; ++n2) {
                this.cheatCodeCurrent[n2] = this.cheatCodeCurrent[n2 + 1];
            }
        } else if (C.getAction(0)) {
            cheatCodeFlag = true;
        }
    }

    private void citizensInit() {
        this.citizens = new Vector();
    }

    private CitizenType[] citizensDetermineAppearance(int n) {
        Trigger trigger;
        int n2;
        CitizenType[] citizenTypeArray = new CitizenType[n];
        for (n2 = 0; n2 < n; ++n2) {
            citizenTypeArray[n2] = null;
        }
        n2 = 0;
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(2, n2++)) != null) {
            if (citizenTypeArray[trigger.params[0]] != null) continue;
            citizenTypeArray[trigger.params[0]] = new CitizenType();
        }
        trigger = Map.layerTriggersSpawn.getTriggerByType(3, 0);
        if (trigger != null) {
            for (int i = 0; i < citizenTypeArray.length; ++i) {
                if (citizenTypeArray[i] != null) continue;
                citizenTypeArray[i] = new CitizenType();
            }
        }
        return citizenTypeArray;
    }

    private void citizensSettingsLoad() {
        block6: {
            FilterInputStream filterInputStream = null;
            try {
                filterInputStream = new DataInputStream(midlet.getClass().getResourceAsStream("Citizens.sse"));
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readShort();
                short s = ((DataInputStream)filterInputStream).readShort();
                int n = ((DataInputStream)filterInputStream).readShort();
                this.citizenTypes = this.citizensDetermineAppearance(n);
                for (int i = 0; i < n; ++i) {
                    if (this.citizenTypes[i] != null) {
                        this.citizenTypes[i].spriteId = (byte)((DataInputStream)filterInputStream).readShort();
                        this.citizenTypes[i].movementSpeedMin = ((DataInputStream)filterInputStream).readShort();
                        this.citizenTypes[i].movementSpeedMax = ((DataInputStream)filterInputStream).readShort();
                        this.citizenTypes[i].timeToGoOutFromPanicState = ((DataInputStream)filterInputStream).readShort();
                        this.citizenTypes[i].walkingTimeMin = ((DataInputStream)filterInputStream).readShort() * 1000;
                        this.citizenTypes[i].walkingTimeMax = ((DataInputStream)filterInputStream).readShort() * 1000;
                        this.citizenTypes[i].busyTimeMin = ((DataInputStream)filterInputStream).readShort() * 1000;
                        this.citizenTypes[i].busyTimeMax = ((DataInputStream)filterInputStream).readShort() * 1000;
                        this.citizenTypes[i].panicTimeMin = ((DataInputStream)filterInputStream).readShort() * 1000;
                        this.citizenTypes[i].panicTimeMax = ((DataInputStream)filterInputStream).readShort() * 1000;
                        this.citizenTypes[i].panicRadiusQf = ((DataInputStream)filterInputStream).readShort();
                        this.citizenTypes[i].panicRadiusQf = this.citizenTypes[i].panicRadiusQf * this.citizenTypes[i].panicRadiusQf >> 10;
                        this.citizenTypes[i].panicSpeedMin = ((DataInputStream)filterInputStream).readShort();
                        this.citizenTypes[i].panicSpeedMax = ((DataInputStream)filterInputStream).readShort();
                        continue;
                    }
                    ((DataInputStream)filterInputStream).skipBytes(s << 1);
                }
                filterInputStream.close();
            }
            catch (Exception exception) {
                if (filterInputStream == null) break block6;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void citizenSpawnOnCarHijack(Car car) {
        Object object;
        Vect vect = new Vect();
        vect.rotate(car.carType.geometryExitPoint, Mafia.player.car.getBodyAngle());
        vect.y = car.perspectiveTransform(vect.y);
        vect.x += car.positionXf;
        vect.y += car.positionYf;
        if (vect.x < 256 || vect.x >= Map.widthTotalF - 256 || vect.y < 256 || vect.y >= Map.heightTotalF - 256 || !map.isShootPossible(car.positionXf, car.positionYf, vect.x, vect.y) || this.collisionTestMobVsEnv(vect.x, vect.y) || this.collisionTestMobVsCars(vect.x, vect.y)) {
            object = new Vect(-Mafia.player.car.carType.geometryExitPoint.x, Mafia.player.car.carType.geometryExitPoint.y);
            vect.rotate((Vect)object, Mafia.player.car.getBodyAngle());
            vect.y = car.perspectiveTransform(vect.y);
            vect.x += car.positionXf;
            vect.y += car.positionYf;
            if (vect.x < 256 || vect.x >= Map.widthTotalF - 256 || vect.y < 256 || vect.y >= Map.heightTotalF - 256 || !map.isShootPossible(car.positionXf, car.positionYf, vect.x, vect.y) || this.collisionTestMobVsEnv(vect.x, vect.y) || this.collisionTestMobVsCars(vect.x, vect.y)) {
                return;
            }
        }
        object = this.citizenSpawn(vect.x >> 10, vect.y >> 10, (byte)-1, (byte)8, (byte)3);
        ((Citizen)object).spawnPositionY = (short)-1;
        ((Citizen)object).spawnPositionX = (short)-1;
        ((Sprite)object).spatialIndicesCalculate();
        this.spatialZonesCitizens[((Citizen)object).shX][((Citizen)object).shY].addElement(object);
        ((Citizen)object).stateTimeOverall = Util.getRandom(500, 1000);
    }

    private Citizen citizenSpawn(int n, int n2, byte by, byte by2, byte by3) {
        Citizen citizen = new Citizen();
        citizen.init();
        citizen.citizenType = by >= 0 ? this.citizenTypes[by] : this.citizenTypes[Util.getRandom(0, this.citizenTypes.length - 1)];
        citizen.spawnTypeId = by;
        citizen.positionXf = citizen.proposedPositionXf = (n << 10) + 512;
        citizen.positionYf = citizen.proposedPositionYf = (n2 << 10) + 512;
        citizen.spawnPositionX = (short)n;
        citizen.spawnPositionY = (short)n2;
        citizen.isVisible = true;
        citizen.direction = by3;
        citizen.spawnDirection = by3;
        citizen.stateChange(by2);
        this.citizens.addElement(citizen);
        return citizen;
    }

    private void citizenMoveToSpawnPoint(Citizen citizen) {
        if (citizen.spawnPositionX < 0 || citizen.spawnPositionY < 0) {
            citizen.stateChange((byte)-2);
        } else {
            citizen.positionXf = citizen.proposedPositionXf = (citizen.spawnPositionX << 10) + 512;
            citizen.positionYf = citizen.proposedPositionYf = (citizen.spawnPositionY << 10) + 512;
            citizen.citizenType = citizen.spawnTypeId >= 0 ? this.citizenTypes[citizen.spawnTypeId] : this.citizenTypes[Util.getRandom(0, this.citizenTypes.length - 1)];
            citizen.direction = citizen.spawnDirection;
            citizen.stateReset();
            citizen.stateChange((byte)0);
        }
    }

    private void citizensSpawn() {
        Trigger trigger;
        int n = 0;
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(2, n)) != null) {
            this.citizenSpawn(trigger.posX, trigger.posY, (byte)trigger.params[0], (byte)trigger.params[1], Sprite.directionRandomGenerate((byte)trigger.params[2], (byte)0));
            ++n;
        }
        n ^= n;
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(3, n)) != null) {
            this.citizenSpawn(trigger.posX, trigger.posY, (byte)-1, (byte)0, Sprite.directionRandomGenerate((byte)trigger.params[0], (byte)0));
            ++n;
        }
    }

    private void citizensPanic() {
        int n = 0;
        for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
            for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                for (n = this.spatialZonesCitizens[j][i].size() - 1; n >= 0; --n) {
                    int n2;
                    Citizen citizen = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n);
                    if (!citizen.isVisible || citizen.getState() == 1 || citizen.getState() == -2 || citizen.getState() == 2 || Mafia.getRangeQ(Mafia.player.positionXf, Mafia.player.positionYf, citizen.positionXf, citizen.positionYf) > citizen.citizenType.panicRadiusQf || this.collisionTestMobVsEnv(citizen.proposedPositionXf, citizen.proposedPositionYf)) continue;
                    citizen.stateTimeOverall = Util.getRandom(citizen.citizenType.panicTimeMin, citizen.citizenType.panicTimeMax);
                    Vect vect = new Vect(citizen.positionXf - Mafia.player.positionXf, citizen.positionYf - Mafia.player.positionYf);
                    n2 = Mat.sqrtFixedInt(n2, 0, (n2 = vect.lengthSqr()) > 1024 ? n2 : 1024);
                    vect.x = (vect.x << 10) / n2;
                    vect.y = (vect.y << 10) / n2;
                    int n3 = Util.getRandom(-90, 90);
                    vect.rotate(n3 << 10);
                    int n4 = Util.getRandom(citizen.citizenType.panicSpeedMin, citizen.citizenType.panicSpeedMax);
                    citizen.speedXf = n4 * vect.x >> 10;
                    citizen.speedYf = n4 * vect.y >> 10;
                    citizen.direction = Sprite.getDirectionToTarget(0, 0, citizen.speedXf, citizen.speedYf);
                    citizen.stateChange((byte)2);
                }
            }
        }
    }

    private boolean citizenCheckDamage(int n, int n2) {
        int n3 = 0;
        if (Mafia.player.positionXf == n) {
            for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                    for (n3 = this.spatialZonesCitizens[j][i].size() - 1; n3 >= 0; --n3) {
                        Citizen citizen = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n3);
                        if (citizen.getState() == 1 || (Mafia.player.positionYf < citizen.positionYf - 256 || Mafia.player.positionYf > citizen.positionYf + 256) && (n2 < citizen.positionYf - 256 || n2 > citizen.positionYf + 256) || Mafia.player.positionXf < citizen.positionXf - 256 || Mafia.player.positionXf > citizen.positionXf + 256) continue;
                        if (citizen.damageTake(player.getDamageDeal())) {
                            this.crimeLevelIncrease(this.crimeLevelCitizenKillPoints, true);
                        }
                        return true;
                    }
                }
            }
        } else {
            int n4 = (Mafia.player.positionYf - n2 << 10) / (Mafia.player.positionXf - n);
            if (Mafia.player.positionXf > n) {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        for (n3 = this.spatialZonesCitizens[j][i].size() - 1; n3 >= 0; --n3) {
                            Citizen citizen = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n3);
                            if (citizen.getState() == 1 || citizen.positionXf + 256 < n || citizen.positionXf - 256 > Mafia.player.positionXf) continue;
                            int n5 = n4 * (citizen.positionXf - 256 - n >> 10);
                            int n6 = n4 * (citizen.positionXf + 256 - n >> 10);
                            if (((n5 += n2) < citizen.positionYf - 256 || n5 > citizen.positionYf + 256) && ((n6 += n2) < citizen.positionYf - 256 || n6 > citizen.positionYf + 256)) continue;
                            if (citizen.damageTake(player.getDamageDeal())) {
                                this.crimeLevelIncrease(this.crimeLevelCitizenKillPoints, true);
                            }
                            return true;
                        }
                    }
                }
            } else {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        for (n3 = this.spatialZonesCitizens[j][i].size() - 1; n3 >= 0; --n3) {
                            Citizen citizen = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n3);
                            if (citizen.getState() == 1 || citizen.positionXf + 256 < Mafia.player.positionXf || citizen.positionXf - 256 > n) continue;
                            int n7 = n4 * (citizen.positionXf - 256 - Mafia.player.positionXf >> 10);
                            int n8 = n4 * (citizen.positionXf + 256 - Mafia.player.positionXf >> 10);
                            if (((n7 += Mafia.player.positionYf) < citizen.positionYf - 256 || n7 > citizen.positionYf + 256) && ((n8 += Mafia.player.positionYf) < citizen.positionYf - 256 || n8 > citizen.positionYf + 256)) continue;
                            if (citizen.damageTake(player.getDamageDeal())) {
                                this.crimeLevelIncrease(this.crimeLevelCitizenKillPoints, true);
                            }
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private void citizenWorldAssign(Citizen citizen) {
        if (citizen.getState() != -2) {
            int n = citizen.shX;
            int n2 = citizen.shY;
            citizen.spatialIndicesCalculate();
            if (n != citizen.shX || n2 != citizen.shY) {
                this.spatialZonesCitizens[citizen.shX][citizen.shY].addElement(citizen);
                this.spatialZonesCitizens[n][n2].removeElement(citizen);
            }
        } else {
            this.spatialZonesCitizens[citizen.shX][citizen.shY].removeElement(citizen);
            this.citizens.removeElement(citizen);
        }
    }

    private void citizenTriggerTest(Citizen citizen) {
        switch (citizen.direction) {
            case 0: {
                Trigger trigger;
                if ((citizen.positionXf & 0x3FF) <= 512 || (citizen.proposedPositionXf & 0x3FF) > 512 || (trigger = map.getTriggerNpcCtrl(citizen.positionXf, citizen.positionYf)) == null) break;
                if (trigger.type == 1) {
                    if (Util.getRandom(1, 100) > trigger.params[0]) break;
                    this.citizenMoveToSpawnPoint(citizen);
                    break;
                }
                if (trigger.type != 0) break;
                citizen.directionChangeOnTrigger(trigger);
                break;
            }
            case 1: {
                Trigger trigger;
                if ((citizen.positionXf & 0x3FF) >= 512 || (citizen.proposedPositionXf & 0x3FF) < 512 || (trigger = map.getTriggerNpcCtrl(citizen.positionXf, citizen.positionYf)) == null) break;
                if (trigger.type == 1) {
                    if (Util.getRandom(1, 100) > trigger.params[0]) break;
                    this.citizenMoveToSpawnPoint(citizen);
                    break;
                }
                if (trigger.type != 0) break;
                citizen.directionChangeOnTrigger(trigger);
                break;
            }
            case 2: {
                Trigger trigger;
                if ((citizen.positionYf & 0x3FF) <= 512 || (citizen.proposedPositionYf & 0x3FF) > 512 || (trigger = map.getTriggerNpcCtrl(citizen.positionXf, citizen.positionYf)) == null) break;
                if (trigger.type == 1) {
                    if (Util.getRandom(1, 100) > trigger.params[0]) break;
                    this.citizenMoveToSpawnPoint(citizen);
                    break;
                }
                if (trigger.type != 0) break;
                citizen.directionChangeOnTrigger(trigger);
                break;
            }
            case 3: {
                Trigger trigger;
                if ((citizen.positionYf & 0x3FF) >= 512 || (citizen.proposedPositionYf & 0x3FF) < 512 || (trigger = map.getTriggerNpcCtrl(citizen.positionXf, citizen.positionYf)) == null) break;
                if (trigger.type == 1) {
                    if (Util.getRandom(1, 100) > trigger.params[0]) break;
                    this.citizenMoveToSpawnPoint(citizen);
                    break;
                }
                if (trigger.type != 0) break;
                citizen.directionChangeOnTrigger(trigger);
            }
        }
    }

    private void citizensUpdate(int n) {
        if (this.citizens == null) {
            return;
        }
        for (int i = this.citizens.size() - 1; i >= 0; --i) {
            Citizen citizen = (Citizen)this.citizens.elementAt(i);
            citizen.stateTime += (long)n;
            citizen.animationFrameCounterUpdate(n);
            switch (citizen.getState()) {
                case 0: {
                    if (citizen.stateTime >= (long)citizen.stateTimeOverall) {
                        citizen.stateChange(Util.getRandom(0, 1) == 1 ? (byte)5 : 6);
                        break;
                    }
                    if (citizen.speedXf != 0) {
                        citizen.proposedPositionXf = citizen.positionXf + (citizen.speedXf * n >> 10);
                        if (citizen.proposedPositionXf < 0 || citizen.proposedPositionXf >= Map.widthTotalF) {
                            this.citizenMoveToSpawnPoint(citizen);
                            return;
                        }
                    }
                    if (citizen.speedYf != 0) {
                        citizen.proposedPositionYf = citizen.positionYf + (citizen.speedYf * n >> 10);
                        if (citizen.proposedPositionYf < 0 || citizen.proposedPositionYf >= Map.heightTotalF) {
                            this.citizenMoveToSpawnPoint(citizen);
                            return;
                        }
                    }
                    if (this.collisionTestMobVsCars(citizen.proposedPositionXf, citizen.proposedPositionYf)) {
                        citizen.stateChange((byte)4);
                        return;
                    }
                    this.citizenTriggerTest(citizen);
                    citizen.positionAccept();
                    break;
                }
                case 4: {
                    if (citizen.stateTime < (long)citizen.stateTimeOverall) break;
                    if (this.collisionTestMobVsCars(citizen.proposedPositionXf, citizen.proposedPositionYf)) {
                        if (Util.getRandom(1, 100) > 60) {
                            citizen.setDirection(Sprite.getDirectionOpposite(citizen.direction));
                            citizen.stateChange((byte)0);
                            break;
                        }
                        citizen.stateTime = 0L;
                        break;
                    }
                    citizen.stateChange((byte)0);
                    break;
                }
                case 2: {
                    if (citizen.stateTime >= (long)citizen.stateTimeOverall) {
                        citizen.stateChange((byte)3);
                        break;
                    }
                    citizen.proposedPositionXf = citizen.positionXf + (citizen.speedXf * n >> 10);
                    citizen.proposedPositionYf = citizen.positionYf + (citizen.speedYf * n >> 10);
                    if (citizen.proposedPositionXf < 256 || citizen.proposedPositionXf + 256 >= Map.widthTotalF || citizen.proposedPositionYf < 256 || citizen.proposedPositionYf + 256 >= Map.heightTotalF) {
                        this.citizenMoveToSpawnPoint(citizen);
                        return;
                    }
                    int n2 = citizen.speedXf;
                    int n3 = citizen.speedYf;
                    int n4 = 0;
                    while (this.collisionTestMobVsEnv(citizen.proposedPositionXf, citizen.proposedPositionYf) || this.collisionTestMobVsCars(citizen.proposedPositionXf, citizen.proposedPositionYf)) {
                        if (++n4 > 10) {
                            citizen.stateChange((byte)3);
                            return;
                        }
                        Vect vect = new Vect(n2, n3);
                        vect.rotate(Util.getRandom(90, 270) << 10);
                        citizen.proposedPositionXf = citizen.positionXf + (vect.x * n >> 10);
                        citizen.proposedPositionYf = citizen.positionYf + (vect.y * n >> 10);
                        if (citizen.proposedPositionXf < 256 || citizen.proposedPositionXf + 256 >= Map.widthTotalF || citizen.proposedPositionYf < 256 || citizen.proposedPositionYf + 256 >= Map.heightTotalF) {
                            this.citizenMoveToSpawnPoint(citizen);
                            return;
                        }
                        citizen.speedXf = vect.x;
                        citizen.speedYf = vect.y;
                        citizen.direction = Sprite.getDirectionToTarget(0, 0, citizen.speedXf, citizen.speedYf);
                    }
                    citizen.positionAccept();
                    break;
                }
                case 3: {
                    citizen.proposedPositionXf = citizen.positionXf + (citizen.speedXf * n >> 10);
                    citizen.proposedPositionYf = citizen.positionYf + (citizen.speedYf * n >> 10);
                    if (citizen.proposedPositionXf < 256 || citizen.proposedPositionXf + 256 >= Map.widthTotalF || citizen.proposedPositionYf < 256 || citizen.proposedPositionYf + 256 >= Map.heightTotalF) {
                        this.citizenMoveToSpawnPoint(citizen);
                        return;
                    }
                    int n2 = 0;
                    while ((this.collisionTestMobVsEnv(citizen.proposedPositionXf, citizen.proposedPositionYf) || this.collisionTestMobVsCars(citizen.proposedPositionXf, citizen.proposedPositionYf)) && n2 < 4) {
                        if (++n2 == 4) {
                            this.citizenMoveToSpawnPoint(citizen);
                            return;
                        }
                        if (citizen.direction == 0 || citizen.direction == 1) {
                            citizen.setDirection(Util.getRandom(0, 1) == 0 ? (byte)3 : 2);
                        } else {
                            citizen.setDirection(Util.getRandom(0, 1) == 0 ? (byte)1 : 0);
                        }
                        citizen.proposedPositionXf = citizen.positionXf + (citizen.speedXf * n >> 10);
                        citizen.proposedPositionYf = citizen.positionYf + (citizen.speedYf * n >> 10);
                        if (citizen.proposedPositionXf >= 256 && citizen.proposedPositionXf + 256 < Map.widthTotalF && citizen.proposedPositionYf >= 256 && citizen.proposedPositionYf + 256 < Map.heightTotalF) continue;
                        this.citizenMoveToSpawnPoint(citizen);
                        return;
                    }
                    this.citizenTriggerTest(citizen);
                    citizen.positionAccept();
                    break;
                }
                case 6: {
                    if (citizen.stateTime < (long)citizen.stateTimeOverall) break;
                    citizen.stateChange(Util.getRandom(1, 100) > 33 ? (byte)0 : 5);
                    break;
                }
                case 5: {
                    if (citizen.stateTime < (long)citizen.stateTimeOverall) break;
                    citizen.stateChange((byte)7);
                    break;
                }
                case 7: {
                    if (citizen.stateTime < (long)citizen.stateTimeOverall) break;
                    citizen.stateChange((byte)0);
                    break;
                }
                case 8: {
                    int n4;
                    if (citizen.stateTime < (long)citizen.stateTimeOverall) break;
                    Vect vect = new Vect(citizen.positionXf - Mafia.player.positionXf, citizen.positionYf - Mafia.player.positionYf);
                    n4 = Mat.sqrtFixedInt(n4, 0, (n4 = vect.lengthSqr()) > 1024 ? n4 : 1024);
                    vect.x = (vect.x << 10) / n4;
                    vect.y = (vect.y << 10) / n4;
                    int n5 = Util.getRandom(-90, 90);
                    vect.rotate(n5 << 10);
                    int n6 = Util.getRandom(citizen.citizenType.panicSpeedMin, citizen.citizenType.panicSpeedMax);
                    citizen.speedXf = n6 * vect.x >> 10;
                    citizen.speedYf = n6 * vect.y >> 10;
                    citizen.direction = Sprite.getDirectionToTarget(0, 0, citizen.speedXf, citizen.speedYf);
                    citizen.stateTimeOverall = Util.getRandom(citizen.citizenType.panicTimeMin, citizen.citizenType.panicTimeMax);
                    citizen.stateChange((byte)2);
                    break;
                }
                case 1: {
                    if (citizen.stateTime < (long)citizen.stateTimeOverall) break;
                    player.statisticValueAdd(5, 1);
                    this.citizenMoveToSpawnPoint(citizen);
                }
            }
            this.citizenWorldAssign((Citizen)this.citizens.elementAt(i));
        }
    }

    private Car collisionTestCarVsCars(Car car) {
        for (int i = 0; i < this.cars.size(); ++i) {
            Car car2 = (Car)this.cars.elementAt(i);
            if (car == car2 || Mafia.getRangeQ(car.proposedPositionXf, car.proposedPositionYf, car2.positionXf, car2.positionYf) > car.carType.boundingCircleRadiusQf + car2.carType.boundingCircleRadiusQf || !Polygon.isCollide(car.proposedBoundingBox, car2.boundingBox, car.proposedPositionXf - car2.positionXf, car.proposedPositionYf - car2.positionYf)) continue;
            return car2;
        }
        return null;
    }

    private final boolean collisionTestCarVsEnv(Car car) {
        int n;
        int n2;
        int n3;
        int n4 = car.proposedBoundingBox.vertices[0].x;
        if (n4 > car.proposedBoundingBox.vertices[1].x) {
            n4 = car.proposedBoundingBox.vertices[1].x;
        }
        if (n4 > car.proposedBoundingBox.vertices[2].x) {
            n4 = car.proposedBoundingBox.vertices[2].x;
        }
        if (n4 > car.proposedBoundingBox.vertices[3].x) {
            n4 = car.proposedBoundingBox.vertices[3].x;
        }
        if ((n3 = car.proposedBoundingBox.vertices[0].x) < car.proposedBoundingBox.vertices[1].x) {
            n3 = car.proposedBoundingBox.vertices[1].x;
        }
        if (n3 < car.proposedBoundingBox.vertices[2].x) {
            n3 = car.proposedBoundingBox.vertices[2].x;
        }
        if (n3 < car.proposedBoundingBox.vertices[3].x) {
            n3 = car.proposedBoundingBox.vertices[3].x;
        }
        if ((n2 = car.proposedBoundingBox.vertices[0].y) > car.proposedBoundingBox.vertices[1].y) {
            n2 = car.proposedBoundingBox.vertices[1].y;
        }
        if (n2 > car.proposedBoundingBox.vertices[2].y) {
            n2 = car.proposedBoundingBox.vertices[2].y;
        }
        if (n2 > car.proposedBoundingBox.vertices[3].y) {
            n2 = car.proposedBoundingBox.vertices[3].y;
        }
        if ((n = car.proposedBoundingBox.vertices[0].y) < car.proposedBoundingBox.vertices[1].y) {
            n = car.proposedBoundingBox.vertices[1].y;
        }
        if (n < car.proposedBoundingBox.vertices[2].y) {
            n = car.proposedBoundingBox.vertices[2].y;
        }
        if (n < car.proposedBoundingBox.vertices[3].y) {
            n = car.proposedBoundingBox.vertices[3].y;
        }
        if (n4 < 0) {
            Polygon.contactPointsNumber = 1;
            Polygon.contactPointsA[0].x = n4;
            for (int i = 0; i < 4; ++i) {
                if (car.proposedBoundingBox.vertices[i].x != n4) continue;
                Polygon.contactPointsA[0].y = car.proposedBoundingBox.vertices[i].y;
            }
            this.coolisionIsCarPositionClamped = true;
            return true;
        }
        if (n3 >= Map.widthTotalF) {
            Polygon.contactPointsNumber = 1;
            Polygon.contactPointsA[0].x = n3;
            for (int i = 0; i < 4; ++i) {
                if (car.proposedBoundingBox.vertices[i].x != n3) continue;
                Polygon.contactPointsA[0].y = car.proposedBoundingBox.vertices[i].y;
            }
            this.coolisionIsCarPositionClamped = true;
            return true;
        }
        if (n2 < 0) {
            Polygon.contactPointsNumber = 1;
            Polygon.contactPointsA[0].y = n2;
            for (int i = 0; i < 4; ++i) {
                if (car.proposedBoundingBox.vertices[i].y != n2) continue;
                Polygon.contactPointsA[0].x = car.proposedBoundingBox.vertices[i].x;
            }
            this.coolisionIsCarPositionClamped = true;
            return true;
        }
        if (n >= Map.heightTotalF) {
            Polygon.contactPointsNumber = 1;
            Polygon.contactPointsA[0].y = n;
            for (int i = 0; i < 4; ++i) {
                if (car.proposedBoundingBox.vertices[i].y != n) continue;
                Polygon.contactPointsA[0].x = car.proposedBoundingBox.vertices[i].x;
            }
            this.coolisionIsCarPositionClamped = true;
            return true;
        }
        this.coolisionIsCarPositionClamped = false;
        n4 >>= 9;
        n3 >>= 9;
        n >>= 9;
        for (int i = n2 >>= 9; i <= n; ++i) {
            for (int j = n4; j <= n3; ++j) {
                byte by = Map.templatesPosX[j >> 4][i >> 4];
                byte by2 = Map.templatesPosY[j >> 4][i >> 4];
                if (Map.layerCollisionWalk.coll[by][by2] == null || !Map.layerCollisionWalk.coll[by][by2][j & 0xF][i & 0xF]) continue;
                int n5 = j << 9;
                int n6 = i << 9;
                this.collisionBoundingBox.vertices[0].x = n5 + 512;
                this.collisionBoundingBox.vertices[0].y = n6 + 512;
                this.collisionBoundingBox.vertices[1].x = n5;
                this.collisionBoundingBox.vertices[1].y = n6 + 512;
                this.collisionBoundingBox.vertices[2].x = n5;
                this.collisionBoundingBox.vertices[2].y = n6;
                this.collisionBoundingBox.vertices[3].x = n5 + 512;
                this.collisionBoundingBox.vertices[3].y = n6;
                if (!Polygon.isCollide(car.proposedBoundingBox, this.collisionBoundingBox, car.proposedPositionXf - n5, car.proposedPositionYf - n6)) continue;
                return true;
            }
        }
        return false;
    }

    private final boolean collisionTestCarVsEnvRealPos(Car car) {
        int n;
        int n2;
        int n3;
        int n4 = car.boundingBox.vertices[0].x;
        if (n4 > car.boundingBox.vertices[1].x) {
            n4 = car.boundingBox.vertices[1].x;
        }
        if (n4 > car.boundingBox.vertices[2].x) {
            n4 = car.boundingBox.vertices[2].x;
        }
        if (n4 > car.boundingBox.vertices[3].x) {
            n4 = car.boundingBox.vertices[3].x;
        }
        if ((n3 = car.boundingBox.vertices[0].x) < car.boundingBox.vertices[1].x) {
            n3 = car.boundingBox.vertices[1].x;
        }
        if (n3 < car.boundingBox.vertices[2].x) {
            n3 = car.boundingBox.vertices[2].x;
        }
        if (n3 < car.boundingBox.vertices[3].x) {
            n3 = car.boundingBox.vertices[3].x;
        }
        if ((n2 = car.boundingBox.vertices[0].y) > car.boundingBox.vertices[1].y) {
            n2 = car.boundingBox.vertices[1].y;
        }
        if (n2 > car.boundingBox.vertices[2].y) {
            n2 = car.boundingBox.vertices[2].y;
        }
        if (n2 > car.boundingBox.vertices[3].y) {
            n2 = car.boundingBox.vertices[3].y;
        }
        if ((n = car.boundingBox.vertices[0].y) < car.boundingBox.vertices[1].y) {
            n = car.boundingBox.vertices[1].y;
        }
        if (n < car.boundingBox.vertices[2].y) {
            n = car.boundingBox.vertices[2].y;
        }
        if (n < car.boundingBox.vertices[3].y) {
            n = car.boundingBox.vertices[3].y;
        }
        if (n4 < 0) {
            Polygon.contactPointsNumber = 1;
            Polygon.contactPointsA[0].x = n4;
            for (int i = 0; i < 4; ++i) {
                if (car.boundingBox.vertices[i].x != n4) continue;
                Polygon.contactPointsA[0].y = car.boundingBox.vertices[i].y;
            }
            this.coolisionIsCarPositionClamped = true;
            return true;
        }
        if (n3 >= Map.widthTotalF) {
            Polygon.contactPointsNumber = 1;
            Polygon.contactPointsA[0].x = n3;
            for (int i = 0; i < 4; ++i) {
                if (car.boundingBox.vertices[i].x != n3) continue;
                Polygon.contactPointsA[0].y = car.boundingBox.vertices[i].y;
            }
            this.coolisionIsCarPositionClamped = true;
            return true;
        }
        if (n2 < 0) {
            Polygon.contactPointsNumber = 1;
            Polygon.contactPointsA[0].y = n2;
            for (int i = 0; i < 4; ++i) {
                if (car.boundingBox.vertices[i].y != n2) continue;
                Polygon.contactPointsA[0].x = car.boundingBox.vertices[i].x;
            }
            this.coolisionIsCarPositionClamped = true;
            return true;
        }
        if (n >= Map.heightTotalF) {
            Polygon.contactPointsNumber = 1;
            Polygon.contactPointsA[0].y = n;
            for (int i = 0; i < 4; ++i) {
                if (car.boundingBox.vertices[i].y != n) continue;
                Polygon.contactPointsA[0].x = car.boundingBox.vertices[i].x;
            }
            this.coolisionIsCarPositionClamped = true;
            return true;
        }
        this.coolisionIsCarPositionClamped = false;
        n4 >>= 9;
        n3 >>= 9;
        n >>= 9;
        for (int i = n2 >>= 9; i <= n; ++i) {
            for (int j = n4; j <= n3; ++j) {
                byte by = Map.templatesPosX[j >> 4][i >> 4];
                byte by2 = Map.templatesPosY[j >> 4][i >> 4];
                if (Map.layerCollisionWalk.coll[by][by2] == null || !Map.layerCollisionWalk.coll[by][by2][j & 0xF][i & 0xF]) continue;
                int n5 = j << 9;
                int n6 = i << 9;
                this.collisionBoundingBox.vertices[0].x = n5 + 512;
                this.collisionBoundingBox.vertices[0].y = n6 + 512;
                this.collisionBoundingBox.vertices[1].x = n5;
                this.collisionBoundingBox.vertices[1].y = n6 + 512;
                this.collisionBoundingBox.vertices[2].x = n5;
                this.collisionBoundingBox.vertices[2].y = n6;
                this.collisionBoundingBox.vertices[3].x = n5 + 512;
                this.collisionBoundingBox.vertices[3].y = n6;
                if (!Polygon.isCollide(car.boundingBox, this.collisionBoundingBox, car.proposedPositionXf - n5, car.proposedPositionYf - n6)) continue;
                return true;
            }
        }
        return false;
    }

    private void collisionTestCarVsMobs(Car car) {
        this.collisionTestCarVsMobsCitizensHit ^= this.collisionTestCarVsMobsCitizensHit;
        this.collisionTestCarVsMobsEnemiesHit ^= this.collisionTestCarVsMobsEnemiesHit;
        this.collisionTestCarVsMobsCopsHit ^= this.collisionTestCarVsMobsCopsHit;
        this.spatialZonesCalcNear(car.proposedPositionXf, car.proposedPositionYf);
        for (int i = this.spatialZoneNearY1; i <= this.spatialZoneNearY2; ++i) {
            for (int j = this.spatialZoneNearX1; j <= this.spatialZoneNearX2; ++j) {
                int n;
                for (n = this.spatialZonesEnemies[j][i].size() - 1; n >= 0; --n) {
                    Enemy enemy = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n);
                    if (!enemy.isActive || !enemy.isVisible || enemy.getState() == 11 || Mafia.getRangeQ(car.proposedPositionXf, car.proposedPositionYf, enemy.positionXf, enemy.positionYf) > car.carType.boundingCircleRadiusQf + 1024) continue;
                    this.collisionBoundingBox.vertices[0].x = enemy.positionXf + 256;
                    this.collisionBoundingBox.vertices[0].y = enemy.positionYf + 256;
                    this.collisionBoundingBox.vertices[1].x = enemy.positionXf - 256;
                    this.collisionBoundingBox.vertices[1].y = enemy.positionYf + 256;
                    this.collisionBoundingBox.vertices[2].x = enemy.positionXf - 256;
                    this.collisionBoundingBox.vertices[2].y = enemy.positionYf - 256;
                    this.collisionBoundingBox.vertices[3].x = enemy.positionXf + 256;
                    this.collisionBoundingBox.vertices[3].y = enemy.positionYf - 256;
                    if (!Polygon.isCollide(this.collisionBoundingBox, car.proposedBoundingBox, car.proposedPositionXf - enemy.positionXf, car.proposedPositionYf - enemy.positionYf)) continue;
                    if (enemy.enemyType.aiType == 1) {
                        ++this.collisionTestCarVsMobsCopsHit;
                    } else {
                        ++this.collisionTestCarVsMobsEnemiesHit;
                    }
                    enemy.damageTake(1000);
                }
                for (n = this.spatialZonesCitizens[j][i].size() - 1; n >= 0; --n) {
                    Citizen citizen = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n);
                    if (!citizen.isVisible || citizen.getState() == 1 || Mafia.getRangeQ(car.proposedPositionXf, car.proposedPositionYf, citizen.positionXf, citizen.positionYf) > car.carType.boundingCircleRadiusQf + 1024) continue;
                    this.collisionBoundingBox.vertices[0].x = citizen.positionXf + 256;
                    this.collisionBoundingBox.vertices[0].y = citizen.positionYf + 256;
                    this.collisionBoundingBox.vertices[1].x = citizen.positionXf - 256;
                    this.collisionBoundingBox.vertices[1].y = citizen.positionYf + 256;
                    this.collisionBoundingBox.vertices[2].x = citizen.positionXf - 256;
                    this.collisionBoundingBox.vertices[2].y = citizen.positionYf - 256;
                    this.collisionBoundingBox.vertices[3].x = citizen.positionXf + 256;
                    this.collisionBoundingBox.vertices[3].y = citizen.positionYf - 256;
                    if (!Polygon.isCollide(this.collisionBoundingBox, car.proposedBoundingBox, car.proposedPositionXf - citizen.positionXf, car.proposedPositionYf - citizen.positionYf)) continue;
                    ++this.collisionTestCarVsMobsCitizensHit;
                    citizen.damageTake(1000);
                }
            }
        }
    }

    private boolean collisionTestCarVsMobsAny(Car car) {
        this.collisionTestCarVsMobsCitizensHit ^= this.collisionTestCarVsMobsCitizensHit;
        this.collisionTestCarVsMobsEnemiesHit ^= this.collisionTestCarVsMobsEnemiesHit;
        this.collisionTestCarVsMobsCopsHit ^= this.collisionTestCarVsMobsCopsHit;
        this.spatialZonesCalcNear(car.proposedPositionXf, car.proposedPositionYf);
        for (int i = this.spatialZoneNearY1; i <= this.spatialZoneNearY2; ++i) {
            for (int j = this.spatialZoneNearX1; j <= this.spatialZoneNearX2; ++j) {
                int n;
                for (n = this.spatialZonesEnemies[j][i].size() - 1; n >= 0; --n) {
                    Enemy enemy = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n);
                    if (!enemy.isActive || !enemy.isVisible || enemy.getState() == 11 || Mafia.getRangeQ(car.proposedPositionXf, car.proposedPositionYf, enemy.positionXf, enemy.positionYf) > car.carType.boundingCircleRadiusQf + 1024) continue;
                    this.collisionBoundingBox.vertices[0].x = enemy.positionXf + 256;
                    this.collisionBoundingBox.vertices[0].y = enemy.positionYf + 256;
                    this.collisionBoundingBox.vertices[1].x = enemy.positionXf - 256;
                    this.collisionBoundingBox.vertices[1].y = enemy.positionYf + 256;
                    this.collisionBoundingBox.vertices[2].x = enemy.positionXf - 256;
                    this.collisionBoundingBox.vertices[2].y = enemy.positionYf - 256;
                    this.collisionBoundingBox.vertices[3].x = enemy.positionXf + 256;
                    this.collisionBoundingBox.vertices[3].y = enemy.positionYf - 256;
                    if (!Polygon.isCollide(this.collisionBoundingBox, car.proposedBoundingBox, car.proposedPositionXf - enemy.positionXf, car.proposedPositionYf - enemy.positionYf)) continue;
                    return true;
                }
                for (n = this.spatialZonesCitizens[j][i].size() - 1; n >= 0; --n) {
                    Citizen citizen = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n);
                    if (!citizen.isVisible || citizen.getState() == 1 || Mafia.getRangeQ(car.proposedPositionXf, car.proposedPositionYf, citizen.positionXf, citizen.positionYf) > car.carType.boundingCircleRadiusQf + 1024) continue;
                    this.collisionBoundingBox.vertices[0].x = citizen.positionXf + 256;
                    this.collisionBoundingBox.vertices[0].y = citizen.positionYf + 256;
                    this.collisionBoundingBox.vertices[1].x = citizen.positionXf - 256;
                    this.collisionBoundingBox.vertices[1].y = citizen.positionYf + 256;
                    this.collisionBoundingBox.vertices[2].x = citizen.positionXf - 256;
                    this.collisionBoundingBox.vertices[2].y = citizen.positionYf - 256;
                    this.collisionBoundingBox.vertices[3].x = citizen.positionXf + 256;
                    this.collisionBoundingBox.vertices[3].y = citizen.positionYf - 256;
                    if (!Polygon.isCollide(this.collisionBoundingBox, car.proposedBoundingBox, car.proposedPositionXf - citizen.positionXf, car.proposedPositionYf - citizen.positionYf)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean collisionTestMobVsCars(int n, int n2) {
        this.spatialZonesCalcNear(n, n2);
        for (int i = this.spatialZoneNearY1; i <= this.spatialZoneNearY2; ++i) {
            for (int j = this.spatialZoneNearX1; j <= this.spatialZoneNearX2; ++j) {
                for (int k = 0; k < this.spatialZonesCars[j][i].size(); ++k) {
                    Car car = (Car)this.spatialZonesCars[j][i].elementAt(k);
                    if (Mafia.getRangeQ(n, n2, car.positionXf, car.positionYf) > 1024 + car.carType.boundingCircleRadiusQf) continue;
                    this.collisionBoundingBox.vertices[0].x = n + 256;
                    this.collisionBoundingBox.vertices[0].y = n2 + 256;
                    this.collisionBoundingBox.vertices[1].x = n - 256;
                    this.collisionBoundingBox.vertices[1].y = n2 + 256;
                    this.collisionBoundingBox.vertices[2].x = n - 256;
                    this.collisionBoundingBox.vertices[2].y = n2 - 256;
                    this.collisionBoundingBox.vertices[3].x = n + 256;
                    this.collisionBoundingBox.vertices[3].y = n2 - 256;
                    if (!Polygon.isCollide(this.collisionBoundingBox, car.boundingBox, car.positionXf - n, car.positionYf - n2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean collisionTestMobVsEnv(int n, int n2) {
        return map.isColWalk(n - 256, n2 - 256) || map.isColWalk(n + 256, n2 - 256) || map.isColWalk(n - 256, n2 + 256) || map.isColWalk(n + 256, n2 + 256);
    }

    private void crimeLevelReset() {
        crimeLevelF = 0;
        crimeLevelInt = 0;
        crimeLevelIndicatorIsBlinking = false;
    }

    private void crimeLevelSet(int n) {
        block7: {
            if (!crimeLevelIsEnabled) break block7;
            if (n < 0) {
                n = 0;
            } else if (n > 4) {
                n = 4;
            }
            if (n > crimeLevelInt) {
                while (n > crimeLevelInt) {
                    this.crimeLevelIncrease(1024, false);
                }
            } else {
                while (n < crimeLevelInt) {
                    this.crimeLevelDecrease();
                }
            }
        }
    }

    private void crimeLevelIncrease(int n, boolean bl) {
        if (crimeLevelIsEnabled) {
            if ((crimeLevelF += n) > 4096) {
                crimeLevelF = 4096;
            }
            crimeLevelTimeLeft = this.crimeLevelTime;
            if (crimeLevelInt < crimeLevelF >> 10) {
                this.tutorialLaunch((byte)10);
                if (bl) {
                    // empty if block
                }
                player.statisticValueAdd(7, 1);
                crimeLevelInt = (crimeLevelF &= 0x7FFFFC00) >> 10;
                crimeLevelIndicatorFrameCounter = 0;
                crimeLevelIndicatorBlinkingTime = 0;
                crimeLevelIndicatorIsBlinking = true;
                switch (crimeLevelInt) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        this.enemiesCopsSpawnOnCitizenTriggers(this.crimeLevelIncomingCopsAtTriggersNumber);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.enemiesCopsSpawnByRadius(this.crimeLevelIncomingCopsOnRadiusNumber, this.crimeLevelIncomingCopsArivvalRadius);
                    }
                }
                this.scenarioProcessCrimeLevelIncreased();
            }
        }
    }

    private void crimeLevelDecrease() {
        if (crimeLevelIsEnabled) {
            if (--crimeLevelInt < 0) {
                crimeLevelInt = 0;
            }
            crimeLevelF = crimeLevelInt << 10;
            this.scenarioProcessCrimeLevelDecrased();
        }
    }

    private void crimeLevelUpdate(int n) {
        if (crimeLevelIsEnabled) {
            if (crimeLevelIndicatorIsBlinking) {
                crimeLevelIndicatorFrameCounter = (crimeLevelIndicatorBlinkingTime += n) / 100;
                if (crimeLevelIndicatorBlinkingTime >= 2000) {
                    crimeLevelIndicatorIsBlinking = false;
                }
            }
            if (crimeLevelF > 0) {
                if (!this.crimeLevelIsBlocked && (crimeLevelTimeLeft -= n) <= 0) {
                    crimeLevelTimeLeft = this.crimeLevelTime;
                    this.crimeLevelDecrease();
                }
                this.crimeLevelIsBlocked = false;
            }
        }
    }

    private void conversationInit(int n, byte by) {
        cameraOffsetDestXf ^= cameraOffsetDestXf;
        cameraOffsetDestYf = -1024;
        textBox = null;
        player.stateChange((byte)0);
        conversationIndex = n;
        this.inGameSetState((byte)3);
        conversationState = 0;
        conversationBackInGameState = by;
        Conversation.mainCounter = 0;
        Conversation.textCounter = Cfg.CONVERSATION_TEXT_COUNTER_MAX;
        Conversation.portraitCounter = 46;
        Conversation.idCurrent = 0;
        Conversation.direcionOfTextAndPortrait = (byte)2;
        textBox = new TextBox();
        textBox.init(this.txtConversationsAndQuests);
        textBox.setPositionX(10);
        textBox.setPositionY(Conversation.textCounter + 6);
        textBox.setWidth(C.getScreenWidth() - 20 - 10);
        Application.getSingleton();
        textBox.setHeight(55 - Application.softs.getFrameHeight(2, 0) - 2);
        textBox.setTextAlignment(4);
        textBox.setScrollBarVisibility(true);
        textBox.setScrollBarSize(10, 49 - Application.softs.getFrameHeight(2, 0));
        textBox.setScrollBarParameters(2, 1, 1, 0xFFFFFF, 0);
        if (Conversation.idCurrent < this.conversation[Mafia.conversationIndex].textId.length) {
            textBox.setText(this.txtConversationsAndQuests.getText(this.conversation[Mafia.conversationIndex].textId[Conversation.idCurrent]));
        }
        textBox.calculateSlideSize();
    }

    private void conversationSettingsLoad() {
        block6: {
            FilterInputStream filterInputStream = null;
            try {
                filterInputStream = new DataInputStream(midlet.getClass().getResourceAsStream("Conversation" + Util.numberToString(Conversation.fileConversationId, 2) + ".sse"));
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                int n = ((DataInputStream)filterInputStream).readShort();
                this.conversation = new Conversation[n];
                for (int i = 0; i < n; ++i) {
                    ((DataInputStream)filterInputStream).readShort();
                    int n2 = ((DataInputStream)filterInputStream).readShort();
                    this.conversation[i] = new Conversation();
                    this.conversation[i].textId = new byte[n2];
                    this.conversation[i].portraitId = new byte[n2];
                    this.conversation[i].portraitDirection = new boolean[n2];
                    for (int j = 0; j < n2; ++j) {
                        this.conversation[i].textId[j] = (byte)((DataInputStream)filterInputStream).readShort();
                        this.conversation[i].portraitId[j] = (byte)((DataInputStream)filterInputStream).readShort();
                        this.conversation[i].portraitDirection[j] = ((DataInputStream)filterInputStream).readShort() != 0;
                    }
                }
                filterInputStream.close();
            }
            catch (Exception exception) {
                if (filterInputStream == null) break block6;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void conversationUpdate(int n) {
        if (C.getAction(128)) {
            this.pause();
        }
        if (C.getAction(1)) {
            textBox.scrollUp(51200, n);
        } else if (C.getAction(2)) {
            textBox.scrollDown(51200, n);
        }
        if (C.getAction(64)) {
            conversationState = (byte)2;
            Conversation.direcionOfTextAndPortrait = 0;
            Conversation.textCounter = Cfg.CONVERSATION_TEXT_COUNTER_MAX;
            Conversation.portraitCounter = 46;
            C.keyClear();
        }
        if (C.getAction(16) && conversationState == 1 && Conversation.idCurrent <= this.conversation[Mafia.conversationIndex].textId.length - 1) {
            Conversation.direcionOfTextAndPortrait = 0;
            C.keyClear();
        }
        if (conversationState == 0) {
            if (Conversation.mainCounter < 60 && Conversation.direcionOfTextAndPortrait == 2) {
                Conversation.mainCounter = Conversation.mainCounter + (140 * n + 512 >> 10) > 60 ? 60 : Conversation.mainCounter + (140 * n + 512 >> 10);
            } else if (Conversation.mainCounter == 60 && (Conversation.textCounter != C.getScreenHeight() - 61 || Conversation.portraitCounter != 0)) {
                Conversation.direcionOfTextAndPortrait = 1;
            } else if (Conversation.textCounter == C.getScreenHeight() - 61 && Conversation.portraitCounter == 0) {
                conversationState = 1;
            }
        } else if (conversationState == 1) {
            if (Conversation.direcionOfTextAndPortrait == 0) {
                if (Conversation.idCurrent >= this.conversation[Mafia.conversationIndex].textId.length - 1) {
                    conversationState = (byte)2;
                    Conversation.direcionOfTextAndPortrait = 0;
                } else if (Conversation.textCounter == Cfg.CONVERSATION_TEXT_COUNTER_MAX && Conversation.portraitCounter == 46 || this.conversation[Mafia.conversationIndex].portraitId[Conversation.idCurrent] == this.conversation[Mafia.conversationIndex].portraitId[Conversation.idCurrent + 1] && this.conversation[Mafia.conversationIndex].portraitDirection[Conversation.idCurrent] == this.conversation[Mafia.conversationIndex].portraitDirection[Conversation.idCurrent + 1]) {
                    Conversation.direcionOfTextAndPortrait = 1;
                    if (++Conversation.idCurrent < this.conversation[Mafia.conversationIndex].textId.length) {
                        textBox.setText(this.txtConversationsAndQuests.getText(this.conversation[Mafia.conversationIndex].textId[Conversation.idCurrent]));
                        textBox.calculateSlideSize();
                    }
                }
            }
        } else if (conversationState == 2) {
            if (Conversation.direcionOfTextAndPortrait == 2 && Conversation.mainCounter > 0) {
                Conversation.mainCounter = Conversation.mainCounter - (140 * n >> 10) < 0 ? 0 : Conversation.mainCounter - (140 * n >> 10);
            } else if (Conversation.direcionOfTextAndPortrait == 2 && Conversation.mainCounter == 0) {
                this.inGameSetState(conversationBackInGameState);
                this.hotspotTriggerFinalize();
            } else if (Conversation.textCounter == Cfg.CONVERSATION_TEXT_COUNTER_MAX && Conversation.portraitCounter == 46 && Conversation.mainCounter > 0 && Conversation.direcionOfTextAndPortrait == 0) {
                Conversation.direcionOfTextAndPortrait = (byte)2;
            }
        }
        if (Conversation.direcionOfTextAndPortrait == 1) {
            if (Conversation.textCounter != C.getScreenHeight() - 61 && (Conversation.textCounter -= 300 * n + 512 >> 10) < C.getScreenHeight() - 61) {
                Conversation.textCounter = C.getScreenHeight() - 61;
            }
            if (Conversation.portraitCounter != 0 && (Conversation.portraitCounter -= 226 * n + 512 >> 10) < 0) {
                Conversation.portraitCounter = 0;
            }
        } else if (Conversation.direcionOfTextAndPortrait == 0) {
            if (Conversation.portraitCounter != 46 && (Conversation.portraitCounter += 226 * n + 512 >> 10) > 46) {
                Conversation.portraitCounter = 46;
            }
            if (Conversation.textCounter != Cfg.CONVERSATION_TEXT_COUNTER_MAX && (Conversation.textCounter += 300 * n + 512 >> 10) > Cfg.CONVERSATION_TEXT_COUNTER_MAX) {
                Conversation.textCounter = Cfg.CONVERSATION_TEXT_COUNTER_MAX;
            }
        }
        textBox.setPositionY(Conversation.textCounter + 6);
    }

    private void conversationPaint(Graphics graphics) {
        this.worldPaint(graphics);
        if (Conversation.idCurrent <= this.conversation[Mafia.conversationIndex].textId.length - 1) {
            graphics.setClip(0, 0, C.getScreenWidth(), C.getScreenHeight());
            int n = !this.conversation[Mafia.conversationIndex].portraitDirection[Conversation.idCurrent] ? -Conversation.portraitCounter : Conversation.portraitCounter + C.getScreenWidth() - 46;
            int n2 = C.getScreenHeight() - 60 - 65;
            graphics.setColor(0);
            graphics.drawRect(0, Cfg.CONVERSATION_TEXT_COUNTER_MAX - 61 - Conversation.mainCounter, C.getScreenWidth(), C.getScreenHeight());
            graphics.fillRect(0, Cfg.CONVERSATION_TEXT_COUNTER_MAX - 61 - Conversation.mainCounter, C.getScreenWidth(), C.getScreenHeight());
            graphics.drawRect(0, 0, C.getScreenWidth(), Conversation.mainCounter);
            graphics.fillRect(0, 0, C.getScreenWidth(), Conversation.mainCounter);
            portraitsAnimation.drawFrame(graphics, this.conversation[Mafia.conversationIndex].portraitId[Conversation.idCurrent], 0, n, n2, 0);
            if (textBox != null) {
                textBox.paint(graphics);
            }
        }
        this.txt.drawText(graphics, 100, 5, C.getScreenHeight() - 12, 0);
        this.txt.drawText(graphics, 101, Cfg.CONVERSATION_OK_OFFSET_X, C.getScreenHeight() - 12, 0);
        Application.getSingleton().softs_Paint(graphics, -1, 2);
    }

    private void dummiesSettingsLoad() {
        block7: {
            FilterInputStream filterInputStream = null;
            try {
                filterInputStream = new DataInputStream(midlet.getClass().getResourceAsStream("Dummies.sse"));
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                int n = ((DataInputStream)filterInputStream).readShort();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    if (i == levelCurrent) {
                        n2 = ((DataInputStream)filterInputStream).readShort();
                        ((DataInputStream)filterInputStream).readShort();
                        this.dummiesSpriteID = new byte[n2];
                        for (int j = 0; j < n2; ++j) {
                            this.dummiesSpriteID[j] = (byte)((DataInputStream)filterInputStream).readShort();
                        }
                        break;
                    }
                    n2 = ((DataInputStream)filterInputStream).readShort();
                    short s = ((DataInputStream)filterInputStream).readShort();
                    ((DataInputStream)filterInputStream).skipBytes(s * n2 << 1);
                }
                filterInputStream.close();
            }
            catch (Exception exception) {
                if (filterInputStream == null) break block7;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void dummiesSpawn() {
        Trigger trigger;
        int n = 0;
        while (Map.layerTriggersSpawn.getTriggerByType(1, n++) != null) {
        }
        this.dummies = new Dummy[n - 1];
        n ^= n;
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(1, n)) != null) {
            this.dummies[n] = new Dummy();
            this.dummies[n].init();
            this.dummies[n].positionXf = (trigger.posX << 10) + 512;
            this.dummies[n].positionYf = (trigger.posY << 10) + 512;
            this.dummies[n].dummyID = (byte)trigger.params[0];
            this.dummies[n].isVisible = trigger.params[1] != 0;
            ++n;
        }
    }

    private void dummyVisibilityToggle(byte by, boolean bl) {
        for (int i = 0; i < this.dummies.length; ++i) {
            if (this.dummies[i].dummyID != by) continue;
            this.dummies[i].isVisible = bl;
        }
    }

    private void endGame() {
        Application.getSingleton().game_End(1);
    }

    private void endGameUpdate(int n) {
        switch (endGameState) {
            case 0: {
                this.messageUpdate(n);
                break;
            }
            case 1: {
                this.transitionUpdate(n);
                break;
            }
            case 2: {
                this.nickNameUpdate(n);
                break;
            }
        }
    }

    private void endGamePaint(Graphics graphics) {
        switch (endGameState) {
            case 0: {
                this.worldPaint(graphics);
                this.messagePaint(graphics);
                break;
            }
            case 1: {
                this.inGamePaint(graphics, this.transitionStateVisible);
                this.transitionPaint(graphics);
                break;
            }
            case 2: {
                this.nickNamePaint(graphics);
                break;
            }
        }
    }

    private void effectFlashInit(int n) {
        effectFlashColor = n;
        effectFlashTimeMs = 100;
    }

    private void effectFlashPaint(Graphics graphics) {
        graphics.setColor(effectFlashColor);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
    }

    private void enemiesInit() {
        this.enemies = new Vector();
    }

    private EnemyType[] enemiesDetermineAppearance(int n) {
        Trigger trigger;
        int n2;
        EnemyType[] enemyTypeArray = new EnemyType[n];
        for (n2 = 0; n2 < n; ++n2) {
            enemyTypeArray[n2] = null;
        }
        n2 = 0;
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(0, n2++)) != null) {
            if (enemyTypeArray[trigger.params[0]] != null) continue;
            enemyTypeArray[trigger.params[0]] = new EnemyType();
        }
        if (crimeEnemyId >= 0) {
            enemyTypeArray[Mafia.crimeEnemyId] = new EnemyType();
        }
        return enemyTypeArray;
    }

    private void enemiesSettingsLoad() {
        block6: {
            FilterInputStream filterInputStream = null;
            try {
                filterInputStream = new DataInputStream(midlet.getClass().getResourceAsStream("Enemies.sse"));
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readShort();
                short s = ((DataInputStream)filterInputStream).readShort();
                int n = ((DataInputStream)filterInputStream).readShort();
                this.enemyTypes = this.enemiesDetermineAppearance(n);
                for (int i = 0; i < n; ++i) {
                    if (this.enemyTypes[i] != null) {
                        this.enemyTypes[i].typeId = (byte)i;
                        this.enemyTypes[i].aiType = (byte)((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].spriteId = (byte)((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].dmgMin = (byte)((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].dmgMax = (byte)((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].shootDelayTimeMinMs = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].shootDelayTimeMaxMs = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].aimTimeMinMs = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].aimTimeMaxMs = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].panicChance = (byte)((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].panicTimeMinMs = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].panicTimeMaxMs = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].eyeRangeQf = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].eyeRangeQf *= this.enemyTypes[i].eyeRangeQf;
                        this.enemyTypes[i].eyeRangeQf >>= 10;
                        this.enemyTypes[i].shootRangeQf = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].shootRangeQf *= this.enemyTypes[i].shootRangeQf;
                        this.enemyTypes[i].shootRangeQf >>= 10;
                        this.enemyTypes[i].lostRangeQf = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].lostRangeQf *= this.enemyTypes[i].lostRangeQf;
                        this.enemyTypes[i].lostRangeQf >>= 10;
                        this.enemyTypes[i].aggroRangeQf = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].aggroRangeQf *= this.enemyTypes[i].aggroRangeQf;
                        this.enemyTypes[i].aggroRangeQf >>= 10;
                        this.enemyTypes[i].healthPointsMax = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].movementSpeedMin = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].movementSpeedMax = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].healthBarOffsetVertical = (short)(((DataInputStream)filterInputStream).readShort() * Map.tileWidth >> 10);
                        this.enemyTypes[i].crosshairOffsetVerticalF = ((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].soundShootId = (byte)((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].soundDeathId = (byte)((DataInputStream)filterInputStream).readShort();
                        this.enemyTypes[i].bloodType = (byte)((DataInputStream)filterInputStream).readShort();
                        continue;
                    }
                    ((DataInputStream)filterInputStream).skipBytes(s << 1);
                }
                filterInputStream.close();
            }
            catch (Exception exception) {
                if (filterInputStream == null) break block6;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void enemiesSpawn() {
        Trigger trigger;
        int n = 0;
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(0, n)) != null) {
            Trigger trigger2;
            Enemy enemy = new Enemy();
            enemy.init();
            enemy.enemyType = this.enemyTypes[trigger.params[0]];
            enemy.healthPoints = enemy.enemyType.healthPointsMax;
            enemy.positionXf = enemy.proposedPositionXf = (trigger.posX << 10) + 512;
            enemy.positionYf = enemy.proposedPositionYf = (trigger.posY << 10) + 512;
            enemy.spawnPositionX = trigger.posX;
            enemy.spawnPositionY = trigger.posY;
            enemy.aggroLevel = (byte)trigger.params[1];
            enemy.isVisible = trigger.params[2] != 0;
            enemy.isActive = trigger.params[3] != 0;
            enemy.spawnPatrolDestX = trigger.params[5];
            enemy.spawnPatrolDestY = trigger.params[6];
            enemy.patrolDestXf = (enemy.spawnPatrolDestX << 10) + 512;
            enemy.patrolDestYf = (enemy.spawnPatrolDestY << 10) + 512;
            enemy.speedEstablish();
            if (trigger.params[4] == 2 && (trigger2 = Map.layerTriggersSpawn.getTriggerByType(trigger.posX, trigger.posY, 3)) != null) {
                enemy.direction = Sprite.directionRandomGenerate((byte)trigger2.params[0], (byte)0);
            }
            enemy.spawnState = (byte)trigger.params[4];
            enemy.stateChange(enemy.spawnState);
            this.enemies.addElement(enemy);
            ++n;
        }
    }

    private void enemiesStateChange(byte by, byte by2) {
        for (int i = 0; i < this.enemies.size(); ++i) {
            if (((Enemy)this.enemies.elementAt((int)i)).enemyType.typeId != by) continue;
            ((Enemy)this.enemies.elementAt(i)).stateChange(by2);
        }
    }

    private void enemiesActivate(int n) {
        for (int i = this.enemies.size() - 1; i >= 0; --i) {
            Enemy enemy = (Enemy)this.enemies.elementAt(i);
            if (enemy.enemyType != this.enemyTypes[n]) continue;
            enemy.isActive = true;
            enemy.isVisible = true;
        }
    }

    private int enemiesGetCount(EnemyType enemyType) {
        int n = 0;
        for (int i = this.enemies.size() - 1; i >= 0; --i) {
            if (((Enemy)this.enemies.elementAt((int)i)).enemyType != enemyType) continue;
            ++n;
        }
        return n;
    }

    private void enemiesCopsSpawnByRadius(int n, int n2) {
        for (int i = 0; i < n; ++i) {
            int n3;
            Vect vect = new Vect(0, -n2);
            vect = vect.rotate(Util.getRandom(0, 360) << 10);
            for (n3 = 0; n3 < 50 && (vect.x + Mafia.player.positionXf < 256 || vect.x + Mafia.player.positionXf >= Map.widthTotalF - 256 || vect.y + Mafia.player.positionYf < 256 || vect.y + Mafia.player.positionYf >= Map.heightTotalF - 256 || this.collisionTestMobVsEnv(vect.x + Mafia.player.positionXf, vect.y + Mafia.player.positionYf) || this.collisionTestMobVsCars(vect.x + Mafia.player.positionXf, vect.y + Mafia.player.positionYf)); ++n3) {
                vect = vect.rotate(Util.getRandom(0, 360) << 10);
            }
            if (n3 >= 50) continue;
            this.enemySpawn(this.enemyTypes[crimeEnemyId], vect.x + Mafia.player.positionXf, vect.y + Mafia.player.positionYf, Mafia.player.positionXf, Mafia.player.positionYf, (byte)0).stateChange((byte)5);
        }
    }

    private void enemiesCopsSpawnOnCitizenTriggers(int n) {
        int n2;
        Trigger trigger;
        int n3 = 0;
        int[][] nArray = new int[2][n];
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(3, n3)) != null) {
            int n4 = Mat.abs((trigger.posX << 10) + 512 - Mafia.player.positionXf) >> 10;
            int n5 = Mat.abs((trigger.posY << 10) + 512 - Mafia.player.positionYf) >> 10;
            if (n3 >= n) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (n4 * n4 + n5 * n5 >= nArray[1][n2]) continue;
                    nArray[1][n2] = n4 * n4 + n5 * n5;
                    nArray[0][n2] = n3;
                    break;
                }
            } else {
                nArray[1][n3] = n4 * n4 + n5 * n5;
                nArray[0][n3] = n3;
            }
            ++n3;
        }
        if (n3 > n) {
            n3 = n;
        }
        if (n3 > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                for (int i = 0; i < n3; ++i) {
                    trigger = Map.layerTriggersSpawn.getTriggerByType(3, nArray[0][i]);
                    Enemy enemy = this.enemySpawn(this.enemyTypes[crimeEnemyId], (trigger.posX << 10) + 512, (trigger.posY << 10) + 512, (trigger.posX << 10) + 512, (trigger.posY << 10) + 512, (byte)0);
                    enemy.direction = Sprite.directionRandomGenerate((byte)trigger.params[0], (byte)0);
                    enemy.stateChange((byte)2);
                    if (++n2 >= n) break;
                }
                --n2;
            }
        }
    }

    private void enemiesAggroTest() {
        for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
            for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                int n = this.spatialZonesEnemies[j][i].size();
                --n;
                while (n >= 0) {
                    Enemy enemy = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n);
                    if (Mafia.getRangeQ(Mafia.player.positionXf, Mafia.player.positionYf, enemy.positionXf, enemy.positionYf) <= enemy.enemyType.aggroRangeQf && enemy.isVisible && enemy.isVisible) {
                        enemy.aggroLevel = 1;
                        if (crimeLevelInt == 0 && enemy.enemyType.aiType == 1) {
                            this.crimeLevelIncrease(this.crimeLevelShootNearCopPoints, true);
                        }
                    }
                    --n;
                }
            }
        }
    }

    private void enemiesUpdate(int n) {
        for (int i = this.enemies.size() - 1; i >= 0; --i) {
            Enemy enemy = (Enemy)this.enemies.elementAt(i);
            enemy.stateTime += (long)n;
            enemy.animationFrameCounterUpdate(n);
            if (enemy.getState() == 11) {
                if (enemy.getStateTime() >= 1800L) {
                    enemy.stateChange((byte)-2);
                    this.scenarioProcessKillEnemy(enemy);
                    if (enemy.enemyType.aiType == 1) {
                        player.statisticValueAdd(7, 1);
                    } else {
                        player.statisticValueAdd(4, 1);
                    }
                    this.itemDrop((enemy.positionXf & 0x7FFFFC00) + 512, (enemy.positionYf & 0x7FFFFC00) + 512, this.itemDropRandom());
                }
            } else if (enemy.isActive) {
                switch (enemy.enemyType.aiType) {
                    case 0: {
                        this.enemyAIFightingUpdate(enemy, n);
                        break;
                    }
                    case 1: {
                        this.enemyAICopUpdate(enemy, n);
                        break;
                    }
                    case 3: {
                        this.enemyAIDefensiveUpdate(enemy, n);
                        break;
                    }
                    case 2: {
                        this.enemyAIOffensiveUpdate(enemy, n);
                        break;
                    }
                    case 4: {
                        this.enemyAIStaticUpdate(enemy, n);
                    }
                }
            }
            this.enemyWorldAssign(enemy);
        }
    }

    private Enemy enemySpawn(EnemyType enemyType, int n, int n2, int n3, int n4, byte by) {
        Enemy enemy = new Enemy();
        enemy.init();
        enemy.enemyType = enemyType;
        enemy.healthPoints = enemy.enemyType.healthPointsMax;
        enemy.spawnPositionX = (short)(n >> 10);
        enemy.spawnPositionY = (short)(n2 >> 10);
        enemy.positionXf = enemy.proposedPositionXf = n;
        enemy.positionYf = enemy.proposedPositionYf = n2;
        enemy.patrolDestXf = n3;
        enemy.patrolDestYf = n4;
        enemy.aggroLevel = by;
        enemy.isVisible = true;
        enemy.isActive = true;
        enemy.spawnPositionY = (short)-1;
        enemy.spawnPositionX = (short)-1;
        enemy.speedEstablish();
        this.enemies.addElement(enemy);
        enemy.spatialIndicesCalculate();
        this.spatialZonesEnemies[enemy.shX][enemy.shY].addElement(enemy);
        return enemy;
    }

    private boolean enemyRespawn(Enemy enemy) {
        if (enemy.spawnPositionX >= 0 && enemy.spawnPositionY >= 0) {
            Trigger trigger;
            enemy.proposedPositionXf = enemy.positionXf = (enemy.spawnPositionX << 10) + 512;
            enemy.proposedPositionYf = enemy.positionYf = (enemy.spawnPositionY << 10) + 512;
            enemy.healthPoints = enemy.enemyType.healthPointsMax;
            enemy.patrolDestXf = (enemy.spawnPatrolDestX << 10) + 512;
            enemy.patrolDestYf = (enemy.spawnPatrolDestY << 10) + 512;
            if (enemy.spawnState == 2 && (trigger = Map.layerTriggersSpawn.getTriggerByType(enemy.spawnPositionX, enemy.spawnPositionY, 3)) != null) {
                enemy.direction = Sprite.directionRandomGenerate((byte)trigger.params[0], (byte)0);
            }
            enemy.stateReset();
            enemy.stateChange(enemy.spawnState);
        } else {
            enemy.stateChange((byte)-2);
        }
        return false;
    }

    private void enemyTriggerRelease(Enemy enemy, Trigger trigger) {
        switch (trigger.type) {
            case 1: {
                if (trigger.params[0] != 100) break;
                this.enemyRespawn(enemy);
                break;
            }
            case 0: {
                enemy.directionChangeOnTrigger(trigger);
            }
        }
    }

    private void enemyTriggerTest(Enemy enemy) {
        switch (enemy.direction) {
            case 0: {
                Trigger trigger;
                if ((enemy.positionXf & 0x3FF) <= 512 || (enemy.proposedPositionXf & 0x3FF) > 512 || (trigger = map.getTriggerNpcCtrl(enemy.positionXf, enemy.positionYf)) == null) break;
                this.enemyTriggerRelease(enemy, trigger);
                break;
            }
            case 1: {
                Trigger trigger;
                if ((enemy.positionXf & 0x3FF) >= 512 || (enemy.proposedPositionXf & 0x3FF) < 512 || (trigger = map.getTriggerNpcCtrl(enemy.positionXf, enemy.positionYf)) == null) break;
                this.enemyTriggerRelease(enemy, trigger);
                break;
            }
            case 2: {
                Trigger trigger;
                if ((enemy.positionYf & 0x3FF) <= 512 || (enemy.proposedPositionYf & 0x3FF) > 512 || (trigger = map.getTriggerNpcCtrl(enemy.positionXf, enemy.positionYf)) == null) break;
                this.enemyTriggerRelease(enemy, trigger);
                break;
            }
            case 3: {
                Trigger trigger;
                if ((enemy.positionYf & 0x3FF) >= 512 || (enemy.proposedPositionYf & 0x3FF) < 512 || (trigger = map.getTriggerNpcCtrl(enemy.positionXf, enemy.positionYf)) == null) break;
                this.enemyTriggerRelease(enemy, trigger);
            }
        }
    }

    private void enemyWorldAssign(Enemy enemy) {
        if (enemy.getState() != -2) {
            int n = enemy.shX;
            int n2 = enemy.shY;
            enemy.spatialIndicesCalculate();
            if (n != enemy.shX || n2 != enemy.shY) {
                this.spatialZonesEnemies[enemy.shX][enemy.shY].addElement(enemy);
                this.spatialZonesEnemies[n][n2].removeElement(enemy);
            }
        } else {
            this.spatialZonesEnemies[enemy.shX][enemy.shY].removeElement(enemy);
            this.enemies.removeElement(enemy);
        }
    }

    private void enemyAICopUpdate(Enemy enemy, int n) {
        switch (enemy.getState()) {
            case 2: {
                if (crimeLevelInt > 0 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                }
                if (enemy.getStateTime() >= (long)enemy.stateTimeOverall) {
                    enemy.stateChange((byte)4);
                    break;
                }
                if (enemy.speedAlternativeXf != 0) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (enemy.proposedPositionXf < 256 || enemy.proposedPositionXf >= Map.widthTotalF - 256) {
                        enemy.speedAlternativeXf = -enemy.speedAlternativeXf;
                        enemy.direction = Sprite.getDirectionOpposite(enemy.direction);
                        return;
                    }
                }
                if (enemy.speedAlternativeYf != 0) {
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (enemy.proposedPositionYf < 256 || enemy.proposedPositionYf >= Map.heightTotalF - 256) {
                        enemy.speedAlternativeYf = -enemy.speedAlternativeYf;
                        enemy.direction = Sprite.getDirectionOpposite(enemy.direction);
                        return;
                    }
                }
                if (this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.stateChange((byte)3);
                    return;
                }
                this.enemyTriggerTest(enemy);
                enemy.positionAccept();
                break;
            }
            case 4: {
                if (crimeLevelInt > 0 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                    break;
                }
                if (enemy.getStateTime() < (long)enemy.stateTimeOverall) break;
                enemy.stateChange((byte)2);
                break;
            }
            case 3: {
                if (crimeLevelInt > 0 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                    break;
                }
                if (enemy.getStateTime() < (long)enemy.stateTimeOverall) break;
                if (!this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.stateChange((byte)2);
                    break;
                }
                if (Util.getRandom(1, 100) > 60) {
                    enemy.speedAlternativeXf = -enemy.speedAlternativeXf;
                    enemy.speedAlternativeYf = -enemy.speedAlternativeYf;
                    break;
                }
                enemy.stateTime = 0L;
                break;
            }
            case 1: {
                if (crimeLevelInt > 0 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                    break;
                }
                enemy.moveTo(enemy.patrolDestXf, enemy.patrolDestYf, n);
                if (this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    int n2 = enemy.patrolStartXf;
                    int n3 = enemy.patrolStartYf;
                    enemy.patrolStartXf = enemy.patrolDestXf;
                    enemy.patrolStartYf = enemy.patrolDestYf;
                    enemy.patrolDestXf = n2;
                    enemy.patrolDestYf = n3;
                } else {
                    if ((enemy.proposedPositionXf >= enemy.patrolDestXf && enemy.patrolDestXf >= enemy.positionXf || enemy.proposedPositionXf <= enemy.patrolDestXf && enemy.patrolDestXf <= enemy.positionXf) && (enemy.proposedPositionYf >= enemy.patrolDestYf && enemy.patrolDestYf >= enemy.positionYf || enemy.proposedPositionYf <= enemy.patrolDestYf && enemy.patrolDestYf <= enemy.positionYf)) {
                        int n4 = enemy.patrolStartXf;
                        int n5 = enemy.patrolStartYf;
                        enemy.patrolStartXf = enemy.patrolDestXf;
                        enemy.patrolStartYf = enemy.patrolDestYf;
                        enemy.patrolDestXf = n4;
                        enemy.patrolDestYf = n5;
                    }
                    enemy.positionAccept();
                }
                enemy.direction = enemy.getDirectionToTarget(enemy.patrolDestXf, enemy.patrolDestYf);
                break;
            }
            case 5: {
                this.crimeLevelIsBlocked = true;
                int n6 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n6 > enemy.enemyType.lostRangeQf) {
                    enemy.stateChange((byte)10);
                    break;
                }
                if (n6 <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)6);
                    break;
                }
                enemy.moveTo(Mafia.player.positionXf, Mafia.player.positionYf, n);
                if (enemy.proposedPositionXf >= 131072 || enemy.proposedPositionYf >= 131072 || enemy.proposedPositionXf < 0 || enemy.proposedPositionYf < 0) {
                    enemy.moveTo(Mafia.player.positionXf, Mafia.player.positionYf, n);
                }
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                    enemy.positionAccept();
                    break;
                }
                if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? enemy.speedF : -enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? enemy.speedF : -enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else if (!enemy.isSlideReverse) {
                            enemy.speedAlternativeXf = -enemy.speedAlternativeXf;
                            enemy.speedAlternativeYf = -enemy.speedAlternativeYf;
                            enemy.isSlideReverse = true;
                        } else {
                            enemy.stateChange((byte)0);
                        }
                    }
                }
                enemy.direction = Enemy.getDirectionToTarget(0, 0, enemy.speedAlternativeXf, enemy.speedAlternativeYf);
                break;
            }
            case 6: {
                this.crimeLevelIsBlocked = true;
                if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                        this.playerDamageTake(enemy.enemyType.getDamage());
                        enemy.stateChange((byte)7);
                    }
                } else {
                    enemy.stateChange((byte)5);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 7: {
                this.crimeLevelIsBlocked = true;
                if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                    enemy.stateChange((byte)6);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 0: {
                if (crimeLevelInt > 0 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 10: {
                if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                } else if (!(enemy.getStateTime() <= 5000L || this.spritesIsOnScreen(enemy.positionXf, enemy.positionYf) || this.spritesIsOnScreen((enemy.spawnPositionX << 10) + 512, (enemy.spawnPositionY << 10) + 512) || this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf))) {
                    this.enemyRespawn(enemy);
                    return;
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
            }
        }
    }

    private void enemyAIStaticUpdate(Enemy enemy, int n) {
        enemy.direction = enemy.getDirectionToTarget(enemy.patrolDestXf, enemy.patrolDestYf);
    }

    private void enemyAIFightingUpdate(Enemy enemy, int n) {
        switch (enemy.getState()) {
            case 1: {
                if (enemy.aggroLevel == 1 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                    break;
                }
                enemy.moveTo(enemy.patrolDestXf, enemy.patrolDestYf, n);
                if (this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    int n2 = enemy.patrolStartXf;
                    int n3 = enemy.patrolStartYf;
                    enemy.patrolStartXf = enemy.patrolDestXf;
                    enemy.patrolStartYf = enemy.patrolDestYf;
                    enemy.patrolDestXf = n2;
                    enemy.patrolDestYf = n3;
                } else {
                    if ((enemy.proposedPositionXf >= enemy.patrolDestXf && enemy.patrolDestXf >= enemy.positionXf || enemy.proposedPositionXf <= enemy.patrolDestXf && enemy.patrolDestXf <= enemy.positionXf) && (enemy.proposedPositionYf >= enemy.patrolDestYf && enemy.patrolDestYf >= enemy.positionYf || enemy.proposedPositionYf <= enemy.patrolDestYf && enemy.patrolDestYf <= enemy.positionYf)) {
                        int n4 = enemy.patrolStartXf;
                        int n5 = enemy.patrolStartYf;
                        enemy.patrolStartXf = enemy.patrolDestXf;
                        enemy.patrolStartYf = enemy.patrolDestYf;
                        enemy.patrolDestXf = n4;
                        enemy.patrolDestYf = n5;
                    }
                    enemy.positionAccept();
                }
                enemy.direction = enemy.getDirectionToTarget(enemy.patrolDestXf, enemy.patrolDestYf);
                break;
            }
            case 5: {
                int n6 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n6 > enemy.enemyType.lostRangeQf) {
                    enemy.stateChange((byte)10);
                    break;
                }
                if (n6 <= enemy.enemyType.shootRangeQf) {
                    if (n6 <= enemy.enemyType.shootRangeQf >> 1) {
                        enemy.stateChange((byte)8);
                        break;
                    }
                    if (map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                        enemy.stateChange((byte)6);
                        break;
                    }
                }
                enemy.moveTo(Mafia.player.positionXf, Mafia.player.positionYf, n);
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                    enemy.positionAccept();
                    break;
                }
                if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? enemy.speedF : -enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? enemy.speedF : -enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else if (!enemy.isSlideReverse) {
                            enemy.speedAlternativeXf = -enemy.speedAlternativeXf;
                            enemy.speedAlternativeYf = -enemy.speedAlternativeYf;
                            enemy.isSlideReverse = true;
                        } else {
                            enemy.stateChange((byte)0);
                        }
                    }
                }
                enemy.direction = Enemy.getDirectionToTarget(0, 0, enemy.speedAlternativeXf, enemy.speedAlternativeYf);
                break;
            }
            case 8: {
                int n7 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n7 > enemy.enemyType.shootRangeQf >> 1) {
                    if (n7 <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                        enemy.stateChange((byte)6);
                        break;
                    }
                    enemy.stateChange((byte)5);
                    break;
                }
                if (Mat.abs(Mafia.player.positionXf - enemy.positionXf) > Mat.abs(Mafia.player.positionYf - enemy.positionYf)) {
                    enemy.moveFrom(Mafia.player.positionXf, enemy.positionYf + (enemy.positionYf - Mafia.player.positionYf), n);
                } else {
                    enemy.moveFrom(enemy.positionXf - (enemy.positionXf - Mafia.player.positionXf), Mafia.player.positionYf, n);
                }
                if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                    enemy.proposedPositionXf = Map.widthTotalF - 1024;
                } else if (enemy.proposedPositionXf < 1024) {
                    enemy.proposedPositionXf = 1023;
                }
                if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                    enemy.proposedPositionXf = Map.heightTotalF - 1024;
                } else if (enemy.proposedPositionYf < 1024) {
                    enemy.proposedPositionYf = 1023;
                }
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.positionAccept();
                } else if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1023;
                    }
                    if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                        enemy.proposedPositionXf = Map.heightTotalF - 1024;
                    } else if (enemy.proposedPositionYf < 1024) {
                        enemy.proposedPositionYf = 1023;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? -enemy.speedF : enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1023;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? -enemy.speedF : enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                            enemy.proposedPositionXf = Map.heightTotalF - 1024;
                        } else if (enemy.proposedPositionYf < 1024) {
                            enemy.proposedPositionYf = 1024;
                        }
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                            enemy.stateChange((byte)6);
                        }
                    }
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 6: {
                int n8 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n8 <= enemy.enemyType.shootRangeQf) {
                    if (n8 <= enemy.enemyType.shootRangeQf >> 1) {
                        enemy.stateChange((byte)8);
                    } else if (map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) && enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                        this.playerDamageTake(enemy.enemyType.getDamage());
                        enemy.stateChange((byte)7);
                    }
                } else {
                    enemy.stateChange((byte)5);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 7: {
                if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                    enemy.stateChange((byte)6);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 9: {
                if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                    enemy.stateChange((byte)5);
                    break;
                }
                int n9 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n9 > enemy.enemyType.lostRangeQf) {
                    enemy.stateChange((byte)10);
                    break;
                }
                enemy.moveFrom(Mafia.player.positionXf, Mafia.player.positionYf, n);
                if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                    enemy.proposedPositionXf = Map.widthTotalF - 1024;
                } else if (enemy.proposedPositionXf < 1024) {
                    enemy.proposedPositionXf = 1024;
                }
                if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                    enemy.proposedPositionXf = Map.heightTotalF - 1024;
                } else if (enemy.proposedPositionYf < 1024) {
                    enemy.proposedPositionYf = 1024;
                }
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.direction = Sprite.getDirectionOpposite(enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf));
                    enemy.positionAccept();
                    break;
                }
                if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1024;
                    }
                    if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                        enemy.proposedPositionXf = Map.heightTotalF - 1024;
                    } else if (enemy.proposedPositionYf < 1024) {
                        enemy.proposedPositionYf = 1024;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? -enemy.speedF : enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1024;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? -enemy.speedF : enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                            enemy.proposedPositionXf = Map.heightTotalF - 1024;
                        } else if (enemy.proposedPositionYf < 1024) {
                            enemy.proposedPositionYf = 1024;
                        }
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else {
                            enemy.stateChange((byte)5);
                        }
                    }
                }
                enemy.direction = Enemy.getDirectionToTarget(0, 0, enemy.speedAlternativeXf, enemy.speedAlternativeYf);
                break;
            }
            case 0: {
                if (enemy.aggroLevel == 1 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 10: {
                if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                } else if (!(enemy.getStateTime() <= 5000L || this.spritesIsOnScreen(enemy.positionXf, enemy.positionYf) || this.spritesIsOnScreen((enemy.spawnPositionX << 10) + 512, (enemy.spawnPositionY << 10) + 512) || this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf))) {
                    this.enemyRespawn(enemy);
                    return;
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
            }
        }
    }

    private void enemyAIOffensiveUpdate(Enemy enemy, int n) {
        switch (enemy.getState()) {
            case 1: {
                if (enemy.aggroLevel == 1 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                    break;
                }
                enemy.moveTo(enemy.patrolDestXf, enemy.patrolDestYf, n);
                if (this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    int n2 = enemy.patrolStartXf;
                    int n3 = enemy.patrolStartYf;
                    enemy.patrolStartXf = enemy.patrolDestXf;
                    enemy.patrolStartYf = enemy.patrolDestYf;
                    enemy.patrolDestXf = n2;
                    enemy.patrolDestYf = n3;
                } else {
                    if ((enemy.proposedPositionXf >= enemy.patrolDestXf && enemy.patrolDestXf >= enemy.positionXf || enemy.proposedPositionXf <= enemy.patrolDestXf && enemy.patrolDestXf <= enemy.positionXf) && (enemy.proposedPositionYf >= enemy.patrolDestYf && enemy.patrolDestYf >= enemy.positionYf || enemy.proposedPositionYf <= enemy.patrolDestYf && enemy.patrolDestYf <= enemy.positionYf)) {
                        int n4 = enemy.patrolStartXf;
                        int n5 = enemy.patrolStartYf;
                        enemy.patrolStartXf = enemy.patrolDestXf;
                        enemy.patrolStartYf = enemy.patrolDestYf;
                        enemy.patrolDestXf = n4;
                        enemy.patrolDestYf = n5;
                    }
                    enemy.positionAccept();
                }
                enemy.direction = enemy.getDirectionToTarget(enemy.patrolDestXf, enemy.patrolDestYf);
                break;
            }
            case 5: {
                int n6 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n6 > enemy.enemyType.lostRangeQf) {
                    enemy.stateChange((byte)10);
                    break;
                }
                if (n6 <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)6);
                    break;
                }
                enemy.moveTo(Mafia.player.positionXf, Mafia.player.positionYf, n);
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                    enemy.positionAccept();
                    break;
                }
                if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? enemy.speedF : -enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.positionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? enemy.speedF : -enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.positionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else if (!enemy.isSlideReverse) {
                            enemy.speedAlternativeXf = -enemy.speedAlternativeXf;
                            enemy.speedAlternativeYf = -enemy.speedAlternativeYf;
                            enemy.isSlideReverse = true;
                        } else {
                            enemy.stateChange((byte)0);
                        }
                    }
                }
                enemy.direction = Enemy.getDirectionToTarget(0, 0, enemy.speedAlternativeXf, enemy.speedAlternativeYf);
                break;
            }
            case 6: {
                if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                        this.playerDamageTake(enemy.enemyType.getDamage());
                        enemy.stateChange((byte)7);
                    }
                } else {
                    enemy.stateChange((byte)5);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 7: {
                if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                    enemy.stateChange((byte)6);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 9: {
                if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                    enemy.stateChange((byte)5);
                    break;
                }
                int n7 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n7 > enemy.enemyType.lostRangeQf) {
                    enemy.stateChange((byte)10);
                    break;
                }
                enemy.moveFrom(Mafia.player.positionXf, Mafia.player.positionYf, n);
                if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                    enemy.proposedPositionXf = Map.widthTotalF - 1024;
                } else if (enemy.proposedPositionXf < 1024) {
                    enemy.proposedPositionXf = 1024;
                }
                if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                    enemy.proposedPositionXf = Map.heightTotalF - 1024;
                } else if (enemy.proposedPositionYf < 1024) {
                    enemy.proposedPositionYf = 1024;
                }
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.direction = Sprite.getDirectionOpposite(enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf));
                    enemy.positionAccept();
                    break;
                }
                if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1024;
                    }
                    if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                        enemy.proposedPositionXf = Map.heightTotalF - 1024;
                    } else if (enemy.proposedPositionYf < 1024) {
                        enemy.proposedPositionYf = 1024;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? -enemy.speedF : enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1024;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? -enemy.speedF : enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                            enemy.proposedPositionXf = Map.heightTotalF - 1024;
                        } else if (enemy.proposedPositionYf < 1024) {
                            enemy.proposedPositionYf = 1024;
                        }
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else {
                            enemy.stateChange((byte)5);
                        }
                    }
                }
                enemy.direction = Enemy.getDirectionToTarget(0, 0, enemy.speedAlternativeXf, enemy.speedAlternativeYf);
                break;
            }
            case 0: {
                if (enemy.aggroLevel == 1 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 10: {
                if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                } else if (!(enemy.getStateTime() <= 5000L || this.spritesIsOnScreen(enemy.positionXf, enemy.positionYf) || this.spritesIsOnScreen((enemy.spawnPositionX << 10) + 512, (enemy.spawnPositionY << 10) + 512) || this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf))) {
                    this.enemyRespawn(enemy);
                    return;
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
            }
        }
    }

    private void enemyAIDefensiveUpdate(Enemy enemy, int n) {
        switch (enemy.getState()) {
            case 1: {
                if (enemy.aggroLevel == 1 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                    break;
                }
                enemy.moveTo(enemy.patrolDestXf, enemy.patrolDestYf, n);
                if (this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    int n2 = enemy.patrolStartXf;
                    int n3 = enemy.patrolStartYf;
                    enemy.patrolStartXf = enemy.patrolDestXf;
                    enemy.patrolStartYf = enemy.patrolDestYf;
                    enemy.patrolDestXf = n2;
                    enemy.patrolDestYf = n3;
                } else {
                    if ((enemy.proposedPositionXf >= enemy.patrolDestXf && enemy.patrolDestXf >= enemy.positionXf || enemy.proposedPositionXf <= enemy.patrolDestXf && enemy.patrolDestXf <= enemy.positionXf) && (enemy.proposedPositionYf >= enemy.patrolDestYf && enemy.patrolDestYf >= enemy.positionYf || enemy.proposedPositionYf <= enemy.patrolDestYf && enemy.patrolDestYf <= enemy.positionYf)) {
                        int n4 = enemy.patrolStartXf;
                        int n5 = enemy.patrolStartYf;
                        enemy.patrolStartXf = enemy.patrolDestXf;
                        enemy.patrolStartYf = enemy.patrolDestYf;
                        enemy.patrolDestXf = n4;
                        enemy.patrolDestYf = n5;
                    }
                    enemy.positionAccept();
                }
                enemy.direction = enemy.getDirectionToTarget(enemy.patrolDestXf, enemy.patrolDestYf);
                break;
            }
            case 5: {
                int n6 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n6 > enemy.enemyType.lostRangeQf) {
                    enemy.stateChange((byte)10);
                    break;
                }
                if (n6 <= Mafia.player.weaponInfo[Mafia.player.weapon][5] && Mafia.player.weaponInfo[Mafia.player.weapon][5] < enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)8);
                    break;
                }
                if (n6 <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)6);
                    break;
                }
                enemy.moveTo(Mafia.player.positionXf, Mafia.player.positionYf, n);
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                    enemy.positionAccept();
                    break;
                }
                if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? enemy.speedF : -enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? enemy.speedF : -enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else if (!enemy.isSlideReverse) {
                            enemy.speedAlternativeXf = -enemy.speedAlternativeXf;
                            enemy.speedAlternativeYf = -enemy.speedAlternativeYf;
                            enemy.isSlideReverse = true;
                        } else {
                            enemy.stateChange((byte)0);
                        }
                    }
                }
                enemy.direction = Enemy.getDirectionToTarget(0, 0, enemy.speedAlternativeXf, enemy.speedAlternativeYf);
                break;
            }
            case 6: {
                if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                        this.playerDamageTake(enemy.enemyType.getDamage());
                        enemy.stateChange((byte)7);
                    }
                } else {
                    enemy.stateChange((byte)5);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 7: {
                if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= Mafia.player.weaponInfo[Mafia.player.weapon][5] && Mafia.player.weaponInfo[Mafia.player.weapon][5] < enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)8);
                } else if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                    enemy.stateChange((byte)6);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 8: {
                int n7 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n7 > Mafia.player.weaponInfo[Mafia.player.weapon][5] + 1024 && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) || Mafia.player.weaponInfo[Mafia.player.weapon][5] >= enemy.enemyType.shootRangeQf) {
                    if (n7 <= enemy.enemyType.shootRangeQf) {
                        enemy.stateChange((byte)6);
                        break;
                    }
                    enemy.stateChange((byte)5);
                    break;
                }
                if (n7 > enemy.enemyType.lostRangeQf) {
                    enemy.stateChange((byte)10);
                    break;
                }
                enemy.moveFrom(Mafia.player.positionXf, Mafia.player.positionYf, n);
                if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                    enemy.proposedPositionXf = Map.widthTotalF - 1024;
                } else if (enemy.proposedPositionXf < 1024) {
                    enemy.proposedPositionXf = 1023;
                }
                if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                    enemy.proposedPositionXf = Map.heightTotalF - 1024;
                } else if (enemy.proposedPositionYf < 1024) {
                    enemy.proposedPositionYf = 1023;
                }
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.direction = Sprite.getDirectionOpposite(enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf));
                    enemy.positionAccept();
                    break;
                }
                if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1023;
                    }
                    if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                        enemy.proposedPositionXf = Map.heightTotalF - 1024;
                    } else if (enemy.proposedPositionYf < 1024) {
                        enemy.proposedPositionYf = 1023;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? -enemy.speedF : enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1023;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? -enemy.speedF : enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                            enemy.proposedPositionXf = Map.heightTotalF - 1024;
                        } else if (enemy.proposedPositionYf < 1024) {
                            enemy.proposedPositionYf = 1024;
                        }
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.shootRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                            enemy.stateChange((byte)6);
                        }
                    }
                }
                enemy.direction = Enemy.getDirectionToTarget(0, 0, enemy.speedAlternativeXf, enemy.speedAlternativeYf);
                break;
            }
            case 9: {
                if (enemy.getStateTime() > (long)enemy.stateTimeOverall) {
                    enemy.stateChange((byte)5);
                    break;
                }
                int n8 = Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf);
                if (n8 > enemy.enemyType.lostRangeQf) {
                    enemy.stateChange((byte)10);
                    break;
                }
                enemy.moveFrom(Mafia.player.positionXf, Mafia.player.positionYf, n);
                if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                    enemy.proposedPositionXf = Map.widthTotalF - 1024;
                } else if (enemy.proposedPositionXf < 1024) {
                    enemy.proposedPositionXf = 1024;
                }
                if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                    enemy.proposedPositionXf = Map.heightTotalF - 1024;
                } else if (enemy.proposedPositionYf < 1024) {
                    enemy.proposedPositionYf = 1024;
                }
                if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                    enemy.isSlide = false;
                    enemy.isSlideReverse = false;
                    enemy.direction = Sprite.getDirectionOpposite(enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf));
                    enemy.positionAccept();
                    break;
                }
                if (enemy.isSlide) {
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1024;
                    }
                    if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                        enemy.proposedPositionXf = Map.heightTotalF - 1024;
                    } else if (enemy.proposedPositionYf < 1024) {
                        enemy.proposedPositionYf = 1024;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.proposedPositionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionAccept();
                    } else {
                        enemy.isSlide = false;
                    }
                } else {
                    enemy.isSlide = true;
                    enemy.speedAlternativeXf = Mafia.player.positionXf > enemy.positionXf ? -enemy.speedF : enemy.speedF;
                    enemy.speedAlternativeYf ^= enemy.speedAlternativeYf;
                    enemy.proposedPositionXf = enemy.positionXf + (enemy.speedAlternativeXf * n >> 10);
                    if (enemy.proposedPositionXf > Map.widthTotalF - 1024) {
                        enemy.proposedPositionXf = Map.widthTotalF - 1024;
                    } else if (enemy.proposedPositionXf < 1024) {
                        enemy.proposedPositionXf = 1024;
                    }
                    if (!this.collisionTestMobVsEnv(enemy.proposedPositionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                        enemy.positionXf = enemy.proposedPositionXf;
                    } else {
                        enemy.speedAlternativeXf ^= enemy.speedAlternativeXf;
                        enemy.speedAlternativeYf = Mafia.player.positionYf > enemy.positionYf ? -enemy.speedF : enemy.speedF;
                        enemy.proposedPositionYf = enemy.positionYf + (enemy.speedAlternativeYf * n >> 10);
                        if (enemy.proposedPositionYf > Map.heightTotalF - 1024) {
                            enemy.proposedPositionXf = Map.heightTotalF - 1024;
                        } else if (enemy.proposedPositionYf < 1024) {
                            enemy.proposedPositionYf = 1024;
                        }
                        if (!this.collisionTestMobVsEnv(enemy.positionXf, enemy.positionYf) && !this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf)) {
                            enemy.positionYf = enemy.proposedPositionYf;
                        } else {
                            enemy.stateChange((byte)5);
                        }
                    }
                }
                enemy.direction = Enemy.getDirectionToTarget(0, 0, enemy.speedAlternativeXf, enemy.speedAlternativeYf);
                break;
            }
            case 0: {
                if (enemy.aggroLevel == 1 && Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
                break;
            }
            case 10: {
                if (Mafia.getRangeQ(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf) <= enemy.enemyType.eyeRangeQf && map.isShootPossible(enemy.positionXf, enemy.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) {
                    enemy.stateChange((byte)5);
                } else if (!(enemy.getStateTime() <= 5000L || this.spritesIsOnScreen(enemy.positionXf, enemy.positionYf) || this.spritesIsOnScreen((enemy.spawnPositionX << 10) + 512, (enemy.spawnPositionY << 10) + 512) || this.collisionTestMobVsCars(enemy.proposedPositionXf, enemy.proposedPositionYf))) {
                    this.enemyRespawn(enemy);
                    return;
                }
                enemy.direction = enemy.getDirectionToTarget(Mafia.player.positionXf, Mafia.player.positionYf);
            }
        }
    }

    private void epilogInit() {
        int n;
        epilogState = 0;
        Mafia.player.isVisible = false;
        epilogDeathTimeCurrentMs = 0;
        for (n = 0; n < this.citizens.size(); ++n) {
            this.epilogCitizen = (Citizen)this.citizens.elementAt(n);
        }
        for (n = 0; n < this.cars.size(); ++n) {
            this.epilogCar = (Car)this.cars.elementAt(n);
        }
    }

    private void epilogDispose() {
        this.epilogCitizen = null;
        this.epilogCar = null;
    }

    private void epilogUpdate(int n) {
        block0 : switch (epilogState) {
            case 0: {
                this.enemiesUpdate(n);
                this.citizensUpdate(n);
                Mafia.player.positionXf = this.epilogCitizen.positionXf;
                Mafia.player.positionYf = this.epilogCitizen.positionYf;
                this.playerHotSpotTest();
                break;
            }
            case 1: {
                this.citizensUpdate(n);
                this.timerUpdate(n);
                break;
            }
            case 2: {
                if (cameraOffsetCurrentXf != 0 || cameraOffsetCurrentYf != 0) break;
                Mafia.player.car.stateChange((byte)1);
                epilogState = (byte)(epilogState + 1);
                break;
            }
            case 3: {
                cameraCurrentPositionXf = Mafia.player.car.positionXf;
                cameraCurrentPositionYf = Mafia.player.car.positionYf;
                this.carAIMove(Mafia.player.car, n);
                this.carWorldAssign(Mafia.player.car);
                if (Mafia.player.car.positionXf > this.epilogCitizen.positionXf) break;
                epilogState = (byte)(epilogState + 1);
                break;
            }
            case 4: {
                for (int i = 0; i < this.enemies.size(); ++i) {
                    ((Enemy)this.enemies.elementAt((int)i)).isActive = true;
                    ((Enemy)this.enemies.elementAt((int)i)).isVisible = true;
                    ((Enemy)this.enemies.elementAt(i)).setDirection((byte)2);
                }
                this.hotspotTriggerRelease((byte)5);
                epilogState = (byte)(epilogState + 1);
                break;
            }
            case 5: {
                this.timerUpdate(n);
                break;
            }
            case 6: {
                if (cameraOffsetCurrentXf != 0 || cameraOffsetCurrentYf != 0) break;
                epilogState = (byte)(epilogState + 1);
                break;
            }
            case 7: {
                this.enemiesUpdate(n);
                this.citizensUpdate(n);
                for (int i = 0; i < this.enemies.size(); ++i) {
                    Enemy enemy = (Enemy)this.enemies.elementAt(i);
                    if (enemy.enemyType.spriteId != 26 || !enemy.isTargetInShootRange(this.epilogCitizen.positionXf, this.epilogCitizen.positionYf)) continue;
                    enemy.stateChange((byte)0);
                    this.conversationInit(0, inGameState);
                    this.epilogCitizen.stateChange((byte)6);
                    cheatCodeImmortalFlag = true;
                    epilogState = (byte)(epilogState + 1);
                    for (int j = 0; j < this.enemies.size(); ++j) {
                        Enemy enemy2 = (Enemy)this.enemies.elementAt(j);
                        if (enemy2.enemyType.spriteId != 26) continue;
                        enemy2.stateChange((byte)0);
                    }
                    break block0;
                }
                break;
            }
            case 8: {
                this.epilogCitizen.stateChange((byte)6);
                this.enemiesUpdate(n);
                this.citizensUpdate(n);
                if ((epilogDeathTimeCurrentMs += n) < 1200) break;
                cheatCodeImmortalFlag = false;
                for (int i = 0; i < this.enemies.size(); ++i) {
                    Enemy enemy = (Enemy)this.enemies.elementAt(i);
                    if (enemy.enemyType.spriteId != 26) continue;
                    enemy.stateChange((byte)0);
                    enemy.aggroLevel = 0;
                }
                this.epilogCitizen.stateChange((byte)1);
                epilogState = (byte)(epilogState + 1);
                break;
            }
            case 9: {
                this.enemiesUpdate(n);
                this.citizensUpdate(n);
                if (this.epilogCitizen.stateTime <= 1500L) break;
                epilogState = (byte)(epilogState + 1);
                break;
            }
            case 10: {
                this.levelFinalize();
                break;
            }
        }
    }

    private void epilogPaint(Graphics graphics) {
        this.worldPaint(graphics);
    }

    private void hotspotsInit() {
        Trigger trigger;
        this.hotSpotTriggerActive = null;
        this.hotSpots = new Vector();
        int n = 0;
        while ((trigger = Map.layerTriggersHotSpots.getTrigger(n)) != null) {
            if (trigger.params[1] >= 0) {
                this.hotSpots.addElement(new HotSpot(trigger));
            }
            ++n;
        }
    }

    private void hotspotEnter(HotSpot hotSpot) {
        switch (hotSpot.trigger.type) {
            case 1: 
            case 2: 
            case 13: {
                if (inGameState == 1) {
                    Mafia.player.hotSpotBlocked = hotSpot;
                    this.hotspotDeactivate((byte)hotSpot.trigger.params[0]);
                    this.hotspotTriggerRelease(hotSpot.trigger);
                }
                return;
            }
            case 24: 
            case 25: 
            case 26: {
                if (inGameState == 2 && (hotSpot.trigger.params[8] < 0 || Mafia.player.car.carType == this.carTypes[hotSpot.trigger.params[8]])) {
                    Mafia.player.hotSpotBlocked = hotSpot;
                    this.hotspotDeactivate((byte)hotSpot.trigger.params[0]);
                    this.hotspotTriggerRelease(hotSpot.trigger);
                }
                return;
            }
        }
        Mafia.player.hotSpotBlocked = hotSpot;
        this.hotspotDeactivate((byte)hotSpot.trigger.params[0]);
        this.hotspotTriggerRelease(hotSpot.trigger);
    }

    private void hotspotActivate(byte by) {
        if (by < 0) {
            return;
        }
        int n = this.hotSpots.size();
        --n;
        while (n >= 0) {
            HotSpot hotSpot = (HotSpot)this.hotSpots.elementAt(n);
            if ((byte)hotSpot.trigger.params[0] == by) {
                hotSpot.isActive = true;
            }
            --n;
        }
    }

    private void hotspotDeactivate(byte by) {
        if (by < 0) {
            return;
        }
        int n = this.hotSpots.size();
        --n;
        while (n >= 0) {
            HotSpot hotSpot = (HotSpot)this.hotSpots.elementAt(n);
            if ((byte)hotSpot.trigger.params[0] == by) {
                hotSpot.isActive = false;
            }
            --n;
        }
    }

    private void hotspotTriggerFinalize(byte by, byte by2) {
        this.hotspotActivate(by);
        this.hotspotTriggerRelease(by2);
        boolean bl = false;
        int n = Mafia.player.positionXf >> 10;
        int n2 = Mafia.player.positionYf >> 10;
        for (int i = this.hotSpots.size() - 1; i >= 0; --i) {
            HotSpot hotSpot = (HotSpot)this.hotSpots.elementAt(i);
            if (hotSpot.positionLeft > n || hotSpot.positionRight < n || hotSpot.positionUp > n2 || hotSpot.positionDown < n2 || !hotSpot.isActive) continue;
            bl = true;
            Mafia.player.hotSpotBlocked = hotSpot;
            break;
        }
        if (!bl) {
            Mafia.player.hotSpotBlocked = null;
        }
    }

    private void hotspotTriggerFinalize() {
        if (this.hotSpotTriggerActive != null) {
            this.hotspotTriggerFinalize((byte)this.hotSpotTriggerActive.params[5], (byte)this.hotSpotTriggerActive.params[6]);
        }
    }

    private void hotspotTriggerRelease(byte by) {
        if (by < 0) {
            return;
        }
        int n = 0;
        Trigger trigger;
        while ((trigger = Map.layerTriggersHotSpots.getTrigger(n)) != null) {
            if (trigger.params[0] == by) {
                this.hotspotTriggerRelease(trigger);
                return;
            }
            ++n;
        }
        return;
    }

    private void hotspotTriggerRelease(Trigger trigger) {
        this.hotSpotTriggerActive = trigger;
        switch (trigger.type) {
            case 0: {
                this.enemiesActivate(trigger.params[8]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 1: {
                this.conversationInit(trigger.params[8], inGameState);
                break;
            }
            case 2: {
                this.shopInit(trigger.params[8]);
                break;
            }
            case 3: {
                this.dummyVisibilityToggle((byte)trigger.params[8], trigger.params[9] > 0);
                this.hotspotTriggerFinalize();
                break;
            }
            case 4: {
                this.messageInit(this.txtConversationsAndQuests.getText(trigger.params[8]), this.txtConversationsAndQuests, false, true, false, -1, -1);
                break;
            }
            case 5: {
                messageQuestionNegativeAnswerActivateId = (byte)trigger.params[9];
                messageQuestionNegativeAnswerReleaseId = (byte)trigger.params[10];
                this.messageInit(this.txtConversationsAndQuests.getText(trigger.params[8]), this.txtConversationsAndQuests, false, true, true, 0, 1);
                break;
            }
            case 6: {
                this.tutorialLaunch((byte)trigger.params[8]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 7: {
                this.hotspotDeactivate((byte)trigger.params[8]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 8: {
                if (trigger.params[8] != 0) {
                    this.levelEndingConfirm();
                    break;
                }
                this.levelEndingSummary(true);
                break;
            }
            case 9: {
                this.hotspotTriggerFinalize();
                this.inGameSetState((byte)12);
                break;
            }
            case 10: {
                this.scenarioEventStart((byte)trigger.params[8]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 11: {
                this.timerAdd(trigger.params[8], trigger.params[9], trigger.params[10] == 1, (byte)trigger.params[11], (byte)trigger.params[12]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 12: {
                this.cameraEventLaunch(trigger.params[8], trigger.params[10], (byte)trigger.params[5], (byte)trigger.params[6]);
                break;
            }
            case 13: {
                player.stateChange((byte)1);
                this.hotspotTriggerFinalize();
                this.rollerInit((byte)8, true);
                break;
            }
            case 14: {
                if (player.getStatistic((byte)trigger.params[8]) >= trigger.params[9]) {
                    this.hotspotTriggerFinalize();
                    break;
                }
                this.hotspotTriggerFinalize((byte)trigger.params[10], (byte)trigger.params[11]);
                break;
            }
            case 15: {
                player.statisticValueAdd(trigger.params[8], trigger.params[9]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 16: {
                player.setStatistic(trigger.params[8], trigger.params[9]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 17: {
                if (player.inventoryGetAmount((byte)trigger.params[8]) >= trigger.params[9]) {
                    this.hotspotTriggerFinalize();
                    break;
                }
                this.hotspotTriggerFinalize((byte)trigger.params[10], (byte)trigger.params[11]);
                break;
            }
            case 18: {
                player.inventoryAdd((byte)trigger.params[8], trigger.params[9]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 19: {
                player.inventorySet((byte)trigger.params[8], trigger.params[9]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 20: {
                if (crimeLevelInt <= trigger.params[8]) {
                    this.hotspotTriggerFinalize();
                    break;
                }
                this.hotspotTriggerFinalize((byte)trigger.params[9], (byte)trigger.params[10]);
                break;
            }
            case 21: {
                this.crimeLevelSet((byte)(crimeLevelInt + trigger.params[8]));
                this.hotspotTriggerFinalize();
                break;
            }
            case 22: {
                this.crimeLevelSet((byte)trigger.params[8]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 23: {
                this.carsSpawnWaiting(trigger.params[8]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 24: {
                this.hotspotTriggerFinalize();
                break;
            }
            case 25: {
                Car car = Mafia.player.car;
                this.playerCarExit();
                if (car != null) {
                    car.stateChange((byte)-2);
                }
                this.hotspotTriggerFinalize();
                break;
            }
            case 26: {
                if (Mafia.player.car.energyPoints >= trigger.params[9]) {
                    this.hotspotTriggerFinalize();
                    break;
                }
                this.hotspotTriggerFinalize((byte)trigger.params[10], (byte)trigger.params[11]);
                break;
            }
            case 27: {
                this.timerRemove(trigger.params[8]);
                this.hotspotTriggerFinalize();
                break;
            }
            case 28: {
                this.hotspotTriggerFinalize();
                break;
            }
            case 29: {
                this.sniperInit(trigger.params[8], trigger.params[9], trigger.params[10], trigger.params[11]);
            }
        }
    }

    private void hotspotsMarkersPaint(Graphics graphics) {
        for (int i = this.hotSpots.size() - 1; i >= 0; --i) {
            HotSpot hotSpot = (HotSpot)this.hotSpots.elementAt(i);
            if (!hotSpot.isActive || hotSpot.markerType == -1 || hotSpot.markerPositionXf < spritesDisplayBorderLeftF || hotSpot.markerPositionXf > spritesDisplayBorderRightF || hotSpot.markerPositionYf < spritesDisplayBorderTopF || hotSpot.markerPositionYf > spritesDisplayBorderBottomF) continue;
            hudAnimation.drawFrame(graphics, hotSpot.getSequenceId(), animationGlobalCounter, (hotSpot.markerPositionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (hotSpot.markerPositionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 0);
        }
    }

    private void hudBloodInit() {
        hudBloodTimeLeft = 200;
    }

    private void hudBloodUpdate(int n) {
        if (hudBloodTimeLeft > 0 && (hudBloodTimeLeft -= n) < 0) {
            hudBloodTimeLeft = 0;
        }
    }

    private void hudBloodPaint(Graphics graphics) {
        if (hudBloodTimeLeft == 0) {
            return;
        }
        graphics.setColor(0xA00000);
        graphics.drawRect(0, 0, C.getScreenWidth() - 1, C.getScreenHeight() - 1);
        int n = hudBloodTimeLeft >= 100 ? 1 : 0;
        hudAnimation.drawFrame(graphics, 44, n, 0, 0, 0);
        hudAnimation.drawFrame(graphics, 45, n, C.getScreenWidth() - 1, 0, 0);
        hudAnimation.drawFrame(graphics, 46, n, 0, C.getScreenHeight() - 1, 0);
        hudAnimation.drawFrame(graphics, 47, n, C.getScreenWidth() - 1, C.getScreenHeight() - 1, 0);
    }

    private void hudHotspotsArrowsPaint(Graphics graphics) {
        for (int i = this.hotSpots.size() - 1; i >= 0; --i) {
            int n;
            HotSpot hotSpot = (HotSpot)this.hotSpots.elementAt(i);
            if (!hotSpot.isActive || hotSpot.arrowType == -1) continue;
            int n2 = (hotSpot.markerPositionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10;
            int n3 = (hotSpot.markerPositionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10;
            if (n2 < 0) {
                n2 ^= n2;
                if (n3 < 24) {
                    n3 = 24;
                    n = 14;
                } else if (n3 > C.getScreenHeight() - 24) {
                    n3 = C.getScreenHeight() - 24;
                    n = 16;
                } else {
                    n = 10;
                }
            } else if (n2 >= C.getScreenWidth()) {
                n2 = C.getScreenWidth() - 1;
                if (n3 < 24) {
                    n3 = 24;
                    n = 15;
                } else if (n3 > C.getScreenHeight() - 24) {
                    n3 = C.getScreenHeight() - 24;
                    n = 17;
                } else {
                    n = 11;
                }
            } else if (n3 < 24) {
                n3 = 24;
                n = 12;
            } else if (n3 > C.getScreenHeight() - 24) {
                n3 = C.getScreenHeight() - 24;
                n = 13;
            } else {
                n = -1;
            }
            if (n < 0) continue;
            if (hotSpot.arrowType == 1) {
                n += 20;
            }
            hudAnimation.drawFrame(graphics, n, animationGlobalCounter, n2, n3, 0);
        }
    }

    private void hudMessageInit(byte by) {
        switch (by) {
            case 0: {
                int n;
                hudMessagetType = by;
                hudMessageDissplayTime = 0;
                hudMessageIsVisible = true;
                char[] cArray = new char[this.txt.getText(0 + levelCurrent).length];
                for (n = cArray.length - 1; n >= 0; --n) {
                    cArray[n] = this.txt.getText(0 + levelCurrent)[n];
                    if (cArray[n] < 'a' || cArray[n] > 'z') continue;
                    int n2 = n;
                    cArray[n2] = (char)(cArray[n2] + -32);
                }
                hudMessageUpperPosX = -this.txt.getTextWidth(cArray);
                hudMessageUpperCenterPosX = (C.getScreenWidth() >> 1) + (hudMessageUpperPosX >> 1);
                cArray = new char[this.txt.getText(18 + levelCurrent).length];
                for (n = cArray.length - 1; n >= 0; --n) {
                    cArray[n] = this.txt.getText(18 + levelCurrent)[n];
                    if (cArray[n] < 'a' || cArray[n] > 'z') continue;
                    int n3 = n;
                    cArray[n3] = (char)(cArray[n3] + -32);
                }
                hudMessageLowerPosX = C.getScreenWidth();
                hudMessageLowerCenterPosX = C.getScreenWidth() - this.txt.getTextWidth(cArray) >> 1;
                break;
            }
            case 1: {
                int n;
                hudMessagetType = by;
                hudMessageDissplayTime = 0;
                hudMessageIsVisible = true;
                char[] cArray = new char[this.txt.getText(72).length];
                for (n = cArray.length - 1; n >= 0; --n) {
                    cArray[n] = this.txt.getText(72)[n];
                    if (cArray[n] < 'a' || cArray[n] > 'z') continue;
                    int n4 = n;
                    cArray[n4] = (char)(cArray[n4] + -32);
                }
                hudMessageUpperPosX = -this.txt.getTextWidth(cArray);
                hudMessageUpperCenterPosX = (C.getScreenWidth() >> 1) - (this.txt.getTextWidth(cArray) >> 1);
                cArray = new char[this.txt.getText(73).length];
                for (n = cArray.length - 1; n >= 0; --n) {
                    cArray[n] = this.txt.getText(73)[n];
                    if (cArray[n] < 'a' || cArray[n] > 'z') continue;
                    int n5 = n;
                    cArray[n5] = (char)(cArray[n5] + -32);
                }
                hudMessageLowerPosX = C.getScreenWidth();
                hudMessageLowerCenterPosX = C.getScreenWidth() - this.txt.getTextWidth(cArray) >> 1;
            }
        }
    }

    private void hudMessageUpdate(int n) {
        if ((hudMessageDissplayTime += n) > 5000) {
            hudMessageIsVisible = false;
            return;
        }
        if (hudMessageDissplayTime <= 3000) {
            if ((hudMessageUpperPosX += n * 200 >> 10) > hudMessageUpperCenterPosX) {
                hudMessageUpperPosX = hudMessageUpperCenterPosX;
            }
            if ((hudMessageLowerPosX -= n * 200 >> 10) < hudMessageLowerCenterPosX) {
                hudMessageLowerPosX = hudMessageLowerCenterPosX;
            }
        } else {
            hudMessageUpperPosX += n * 200 >> 10;
            hudMessageLowerPosX -= n * 200 >> 10;
        }
    }

    private void hudDrivePaint(Graphics graphics) {
        hudAnimation.drawFrame(graphics, 28, 0, 26, 10, 0);
        graphics.setClip(26, 0, Mafia.player.car.energyPoints * 79 / Mafia.player.car.carType.energyPointsMax, C.getScreenHeight());
        hudAnimation.drawFrame(graphics, 29, 0, 26, 10, 0);
        graphics.setClip(0, 0, C.getScreenWidth(), C.getScreenHeight());
        hudAnimation.drawFrame(graphics, 25, 0, Cfg.HUD_SPEEDOMETER_POS_X, Cfg.HUD_SPEEDOMETER_POS_Y, 0);
        int n = 12;
        int n2 = Mat.abs(Mafia.player.car.driveSpeed) * 180 / n;
        Vect vect = new Vect(-18432, -1024);
        Vect vect2 = new Vect(-18432, 1024);
        Vect vect3 = new Vect(1024, -1024);
        Vect vect4 = new Vect(1024, 1024);
        Vect vect5 = new Vect();
        vect5.rotate(vect, n2);
        Vect vect6 = new Vect();
        vect6.rotate(vect2, n2);
        Vect vect7 = new Vect();
        vect7.rotate(vect3, n2);
        Vect vect8 = new Vect();
        vect8.rotate(vect4, n2);
        int n3 = Cfg.HUD_SPEEDOMETER_POS_X + 1;
        int n4 = Cfg.HUD_SPEEDOMETER_POS_Y - 2;
        int n5 = n3 + (vect5.x >> 10);
        int n6 = n3 + (vect6.x >> 10);
        int n7 = n3 + (vect7.x >> 10);
        int n8 = n3 + (vect8.x >> 10);
        int n9 = n4 + (vect5.y >> 10);
        int n10 = n4 + (vect6.y >> 10);
        int n11 = n4 + (vect7.y >> 10);
        int n12 = n4 + (vect8.y >> 10);
        graphics.setColor(0xB00000);
        graphics.fillTriangle(n5, n9, n7, n11, n6, n10);
        graphics.fillTriangle(n6, n10, n7, n11, n8, n12);
    }

    private void hudCashPaint(Graphics graphics) {
        int n = player.getStatistic((byte)3);
        int n2 = 0;
        Mafia.hudTxtBuffer[n2++] = 120;
        if (n > 0) {
            if (n > 9999) {
                n = 9999;
            }
            boolean bl = true;
            for (int i = 1000; i > 0; i /= 10) {
                int n3 = n / i;
                n -= n3 * i;
                if (n3 == 0 && bl) continue;
                Mafia.hudTxtBuffer[n2++] = (char)(48 + n3);
                bl = false;
            }
        } else {
            Mafia.hudTxtBuffer[n2++] = 48;
        }
        this.txt.drawText(graphics, hudTxtBuffer, n2, (int)Cfg.HUD_POINTS_TEXT_POSITION_X, 12, 6);
        hudAnimation.drawFrame(graphics, 19, 0, Cfg.HUD_POINTS_ICON_POSITION_X, 12, 0);
    }

    private void hudCashInInventoryPaint(Graphics graphics, int n, int n2) {
        int n3 = player.getStatistic((byte)3);
        int n4 = 0;
        Mafia.hudTxtBuffer[n4++] = 120;
        if (n3 > 0) {
            if (n3 > 9999) {
                n3 = 9999;
            }
            boolean bl = true;
            for (int i = 1000; i > 0; i /= 10) {
                int n5 = n3 / i;
                n3 -= n5 * i;
                if (n5 == 0 && bl) continue;
                Mafia.hudTxtBuffer[n4++] = (char)(48 + n5);
                bl = false;
            }
        } else {
            Mafia.hudTxtBuffer[n4++] = 48;
        }
        this.txt.drawText(graphics, hudTxtBuffer, n4, n + 10, n2, 6);
        hudAnimation.drawFrame(graphics, 19, 0, n, n2, 0);
    }

    private void hudWalkPaint(Graphics graphics) {
        if (Mafia.player.car != null) {
            hudAnimation.drawFrame(graphics, 38, animationGlobalCounter, (Mafia.player.car.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (Mafia.player.car.positionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 0);
        }
        this.hudCashPaint(graphics);
        if (!Application.getSingleton().isApplicationPaused()) {
            if (inGameState == 5) {
                this.sprites[1].drawFrame(graphics, 14, 0, 16, Cfg.HUD_WEAPON_ICON_POSITION_Y, 0);
            } else if (Mafia.player.weapon == 0) {
                this.sprites[1].drawFrame(graphics, 10, 0, 16, Cfg.HUD_WEAPON_ICON_POSITION_Y, 0);
            } else if (Mafia.player.weapon == 1) {
                this.sprites[1].drawFrame(graphics, 11, 0, 16, Cfg.HUD_WEAPON_ICON_POSITION_Y, 0);
            } else if (Mafia.player.weapon == 2) {
                this.sprites[1].drawFrame(graphics, 12, 0, 16, Cfg.HUD_WEAPON_ICON_POSITION_Y, 0);
            } else if (Mafia.player.weapon == 3) {
                this.sprites[1].drawFrame(graphics, 13, 0, 16, Cfg.HUD_WEAPON_ICON_POSITION_Y, 0);
            }
            if (Mafia.player.weapon != 0) {
                int n;
                int n2 = 0;
                int n3 = Mafia.player.weaponInfo[Mafia.player.weapon][0];
                if (n3 >= 10) {
                    n = n3 / 10;
                    Mafia.hudTxtBuffer[n2++] = (char)(48 + n);
                    n3 -= n * 10;
                }
                Mafia.hudTxtBuffer[n2++] = (char)(48 + n3);
                Mafia.hudTxtBuffer[n2++] = 47;
                int n4 = Mafia.player.weaponInfo[Mafia.player.weapon][2];
                if (n4 >= 10) {
                    n = n4 / 10;
                    Mafia.hudTxtBuffer[n2++] = (char)(48 + n);
                    n4 -= n * 10;
                }
                Mafia.hudTxtBuffer[n2++] = (char)(48 + n4);
                this.txt.drawText(graphics, hudTxtBuffer, n2, 30, (int)Cfg.HUD_WEAPON_TEXT_POSITION_Y, 4);
            }
        }
        if (player.isCrosshairVisible()) {
            hudAnimation.drawFrame(graphics, player.isTarget() ? 9 : 8, animationGlobalCounter, (Mafia.player.positionXf + Mafia.player.crosshairPosition.x - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (Mafia.player.positionYf + Mafia.player.crosshairPosition.y - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 1);
        }
        hudAnimation.drawFrame(graphics, 26, 0, 26, 10, 0);
        graphics.setClip(26, 0, player.getStatistic((byte)0) * 79 / player.getStatistic((byte)1), C.getScreenHeight());
        hudAnimation.drawFrame(graphics, 27, 0, 26, 10, 0);
        graphics.setClip(0, 0, C.getScreenWidth(), C.getScreenHeight());
    }

    private void hudMessagePaint(Graphics graphics) {
        this.txt.setFont(Application.fontBig);
        int n = 65504;
        switch (hudMessagetType) {
            case 0: {
                int n2;
                int n3;
                char[] cArray = this.txt.getText(0 + levelCurrent);
                char[] cArray2 = new char[cArray.length];
                for (n3 = cArray2.length - 1; n3 >= 0; --n3) {
                    n2 = cArray[n3];
                    if (n2 >= 97 && n2 <= 122) {
                        n2 = (char)(n2 + n);
                    }
                    cArray2[n3] = n2;
                }
                this.txt.drawText(graphics, cArray2, hudMessageUpperPosX, (int)Cfg.HUD_MESSAGE_UPPER_POS_Y, 0);
                cArray = this.txt.getText(18 + levelCurrent);
                cArray2 = new char[cArray.length];
                for (n3 = cArray2.length - 1; n3 >= 0; --n3) {
                    n2 = cArray[n3];
                    if (n2 >= 97 && n2 <= 122) {
                        n2 = (char)(n2 + n);
                    }
                    if (n2 == 252) {
                        n2 = 220;
                    }
                    if (n2 == 322) {
                        n2 = 321;
                    }
                    if (n2 == 243) {
                        n2 = 211;
                    }
                    if (n2 == 228) {
                        n2 = 196;
                    }
                    if (n2 == 246) {
                        n2 = 214;
                    }
                    if (n2 == 224) {
                        n2 = 192;
                    }
                    if (n2 == 231) {
                        n2 = 199;
                    }
                    if (n2 == 232) {
                        n2 = 200;
                    }
                    if (n2 == 233) {
                        n2 = 201;
                    }
                    if (n2 == 241) {
                        n2 = 209;
                    }
                    if (n2 == 242) {
                        n2 = 210;
                    }
                    if (n2 == 237) {
                        n2 = 205;
                    }
                    cArray2[n3] = n2;
                }
                this.txt.drawText(graphics, cArray2, hudMessageLowerPosX, (int)Cfg.HUD_MESSAGE_LOWER_POS_Y, 0);
                break;
            }
            case 1: {
                this.txt.drawText(graphics, this.txt.getText(72), hudMessageUpperPosX, (int)Cfg.HUD_MESSAGE_UPPER_POS_Y, 0);
                this.txt.drawText(graphics, this.txt.getText(73), hudMessageLowerPosX, (int)Cfg.HUD_MESSAGE_LOWER_POS_Y, 0);
            }
        }
        this.txt.setFont(Application.font);
    }

    private void hudCrimeLevelPaint(Graphics graphics) {
        int n = 36;
        int n2 = crimeLevelInt;
        --n2;
        for (int i = 0; i < n2; ++i) {
            hudAnimation.drawFrame(graphics, 40, 0, n, 16, 0);
            n += 16;
        }
        if (n2 >= 0) {
            if (crimeLevelIndicatorIsBlinking) {
                hudAnimation.drawFrame(graphics, 40, hudAnimation.getNextFrameNumber(40, crimeLevelIndicatorFrameCounter, 1), n, 16, 0);
            } else {
                hudAnimation.drawFrame(graphics, 40, 0, n, 16, 0);
            }
        }
    }

    private void hudPaint(Graphics graphics) {
        this.itemMessagePaint(graphics);
        if (hudMessageIsVisible) {
            this.hudMessagePaint(graphics);
        }
        switch (inGameState) {
            case 2: {
                this.hudDrivePaint(graphics);
                break;
            }
            case 1: {
                this.hudWalkPaint(graphics);
                break;
            }
            default: {
                return;
            }
        }
        this.hudHotspotsArrowsPaint(graphics);
        this.hudCrimeLevelPaint(graphics);
        this.hudBloodPaint(graphics);
        this.timerPaint(graphics);
        if (this.cheatShowTime > 0) {
            this.txt.drawText(graphics, this.cheatCodeTextSwitchStatus ? 95 : 96, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
        }
        Application.getSingleton().softs_Paint(graphics, -1, 2);
    }

    private void inGameSetState(byte by) {
        inGameStateTime = 0L;
        inGameStatePrevious = inGameState;
        inGameState = by;
        switch (by) {
            case 12: {
                this.hudMessageInit((byte)1);
                break;
            }
            case 0: {
                levelLoadingStage = 0;
                break;
            }
            case 2: {
                this.cameraModeSet((byte)1);
                cameraOffsetDestXf = 0;
                cameraOffsetDestYf = 0;
                break;
            }
            case 1: {
                this.cameraModeSet((byte)0);
            }
        }
    }

    private void inGameUpdate(int n) {
        inGameStateTime += (long)n;
        switch (inGameState) {
            case 0: {
                this.levelLoadingUpdate(n);
                break;
            }
            case 1: 
            case 2: {
                this.cheatUpdate(n);
                this.playUpdate(n);
                this.cameraUpdate(n);
                this.cheatCheckResult();
                break;
            }
            case 3: {
                this.conversationUpdate(n);
                this.cameraUpdate(n);
                break;
            }
            case 4: {
                this.messageUpdate(n);
                break;
            }
            case 5: {
                this.worldUpdate(n);
                this.sniperUpdate(n);
                this.cameraUpdate(n);
                break;
            }
            case 6: {
                this.cameraUpdate(n);
                this.transitionUpdate(n);
                break;
            }
            case 7: {
                this.shopUpdate(n);
                break;
            }
            case 8: {
                this.cameraUpdate(n);
                this.jackpotUpdate(n);
                break;
            }
            case 9: {
                this.levelEndingSummary(this.messageResponseResult);
                break;
            }
            case 10: {
                this.transitionStart((byte)11, false);
                break;
            }
            case 11: {
                this.levelFinalize();
                break;
            }
            case 12: {
                this.cameraUpdate(n);
                if (inGameStateTime < 2000L) break;
                this.hudMessageInit((byte)0);
                this.transitionStart((byte)13, false);
                break;
            }
            case 13: {
                levelLoadingReset = 0;
                this.levelReset(true);
                break;
            }
            case 14: {
                this.lockPickUpdate(n);
                this.cameraUpdate(n);
                break;
            }
            case 15: {
                this.cameraUpdate(n);
                this.rollerUpdate(n);
                break;
            }
            case 16: {
                this.cameraUpdate(n);
                this.epilogUpdate(n);
                break;
            }
            case 17: {
                this.cheatUpdate(n);
            }
        }
        if (hudMessageIsVisible) {
            this.hudMessageUpdate(n);
        }
    }

    private void inGamePaint(Graphics graphics, byte by) {
        switch (by) {
            case 0: {
                this.levelLoadingPaint(graphics);
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                this.worldPaint(graphics);
                this.hudPaint(graphics);
                break;
            }
            case 3: {
                this.conversationPaint(graphics);
                break;
            }
            case 4: {
                this.inGamePaint(graphics, inGameStatePrevious);
                this.messagePaint(graphics);
                break;
            }
            case 5: {
                this.sniperPaint(graphics);
                break;
            }
            case 6: {
                this.inGamePaint(graphics, this.transitionStateVisible);
                this.transitionPaint(graphics);
                break;
            }
            case 7: {
                this.shopPaint(graphics);
                break;
            }
            case 8: {
                this.worldPaint(graphics);
                this.jackpotPaint(graphics);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.worldPaint(graphics);
                break;
            }
            case 14: {
                this.worldPaint(graphics);
                this.lockPickPaint(graphics);
                break;
            }
            case 15: {
                this.worldPaint(graphics);
                this.rollerPaint(graphics);
                break;
            }
            case 16: {
                this.epilogPaint(graphics);
            }
        }
    }

    private void introInit() {
        introAnimation = new Anim(midlet, "Intro.sai", "Intro.sgs", C.getScreenWidth(), C.getScreenHeight(), null, null, false);
        loadingBarGfx = new Gfx(midlet, "LoadingBar.sgs", 0, null);
        introFrameCurrent = 0;
        introCurrentHeight = -100;
        if (isInfoScreen) {
            try {
                infoScreenGfx = Image.createImage((String)"info.png");
            }
            catch (Exception exception) {
                this.infoTxtLine0 = "M A F I A  II".toCharArray();
                this.infoLogo = new Anim(midlet, "LoadingBar.sai", "LoadingBar.sgs", C.SCREEN_WIDTH, C.SCREEN_HEIGHT, 0, null, C.isDoublePixel());
            }
            int n = 0;
            int[] nArray = new int[]{25, 25, 25, 26, 25};
            int n2 = Application.getSingleton().getLanguageId();
            char[] cArray = this.txt.getText(102);
            this.infoTxtLine1 = new char[nArray[n2]];
            this.infoTxtLine2 = new char[cArray.length - nArray[n2]];
            for (int i = 0; i < cArray.length; ++i) {
                if (nArray[n2] > 0) {
                    this.infoTxtLine1[i] = cArray[i];
                    int n3 = n2;
                    nArray[n3] = nArray[n3] - 1;
                    continue;
                }
                this.infoTxtLine2[n] = cArray[i];
                ++n;
            }
            introState = (byte)3;
        } else {
            introState = 0;
        }
        this.gameSetState((byte)0);
    }

    public void introStateInfoScreenUpdate() {
        if (C.getAction(16)) {
            C.keyClear();
            introState = 0;
            isInfoScreen = false;
        }
    }

    private void introStateMapGoDownUpdate(int n) {
        if ((introCurrentHeight += 512 * n >> 10) >= C.getScreenHeight() >> 1) {
            introState = 1;
        }
    }

    private void introStateInitMapUpdate(int n) {
        introFrameCurrent = (byte)introAnimation.getNextFrameNumber(18 + levelCurrent, introFrameCurrent, 0);
        if (levelCurrent != 17) {
            introArrowsFrameCurrent = (byte)introAnimation.getNextFrameNumber(levelCurrent, introArrowsFrameCurrent, 0);
        }
        if (levelLoadingPressFireTimeCurrent >= 300) {
            this.levelLoadingIsPressFireTxtVisible = !this.levelLoadingIsPressFireTxtVisible;
            levelLoadingPressFireTimeCurrent = 0;
        }
        levelLoadingPressFireTimeCurrent += n;
        if (C.getAction(16)) {
            introState = (byte)2;
        }
    }

    private void introStateMapGoUpUpdate(int n) {
        if ((introCurrentHeight -= 512 * n >> 10) <= -100) {
            this.levelInit(levelCurrent);
        }
    }

    private void introUpdate(int n) {
        switch (introState) {
            case 3: {
                this.introStateInfoScreenUpdate();
                break;
            }
            case 0: {
                this.introStateMapGoDownUpdate(n);
                break;
            }
            case 1: {
                this.introStateInitMapUpdate(n);
                break;
            }
            case 2: {
                this.introStateMapGoUpUpdate(n);
                break;
            }
        }
    }

    private void introStateInfoScreenPaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
        if (infoScreenGfx != null) {
            graphics.drawImage(infoScreenGfx, C.getScreenWidth() - infoScreenGfx.getWidth() >> 1, C.getScreenHeight() - infoScreenGfx.getHeight() >> 1, 0);
        } else {
            this.txt.setFont(Application.fontBig);
            this.txt.drawText(graphics, this.infoTxtLine0, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) - this.txt.getFont().getFontHeight() - (this.infoLogo.getFrameHeight(0, 0) >> 1) - 10, 1);
            this.txt.setFont(Application.font);
            this.infoLogo.drawFrame(graphics, 0, 0, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) - (this.infoLogo.getFrameHeight(0, 0) >> 1) - 10, 0);
        }
        this.txt.setFont(Application.fontBig);
        this.txt.drawText(graphics, this.infoTxtLine1, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) + this.txt.getFont().getFontHeight(), 1);
        this.txt.drawText(graphics, this.infoTxtLine2, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) + this.txt.getFont().getFontHeight() * 2, 1);
        this.txt.setFont(Application.font);
        this.txt.drawText(graphics, 37, C.getScreenWidth() >> 1, C.getScreenHeight() / 8 * 7, 1);
    }

    private void introStateMapGoDownPaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
        introArrowsFrameCurrent = (byte)animationGlobalCounter;
        introFrameCurrent = (byte)animationGlobalCounter;
        introAnimation.drawFrame(graphics, 18 + levelCurrent, introFrameCurrent, C.getScreenWidth() >> 1, introCurrentHeight, 0);
    }

    private void introStateInitMapPaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
        introArrowsFrameCurrent = (byte)animationGlobalCounter;
        introFrameCurrent = (byte)animationGlobalCounter;
        introAnimation.drawFrame(graphics, 18 + levelCurrent, introFrameCurrent, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 0);
        introAnimation.drawFrame(graphics, levelCurrent, introArrowsFrameCurrent, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 0);
        this.txt.drawText(graphics, 0 + levelCurrent, C.getScreenWidth() >> 1, C.getScreenHeight() - 50 + 10, 1);
        this.txt.drawText(graphics, 18 + levelCurrent, C.getScreenWidth() >> 1, C.getScreenHeight() - 50 + 10 + Application.font.getFontHeight(), 1);
        if (this.levelLoadingIsPressFireTxtVisible) {
            this.txt.drawText(graphics, 37, C.getScreenWidth() >> 1, C.getScreenHeight() - 50 + 10 + (Application.font.getFontHeight() << 1), 1);
        }
    }

    private void introStateMapGoUpPaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
        introArrowsFrameCurrent = (byte)animationGlobalCounter;
        introFrameCurrent = (byte)animationGlobalCounter;
        introAnimation.drawFrame(graphics, 18 + levelCurrent, introFrameCurrent, C.getScreenWidth() >> 1, introCurrentHeight, 0);
    }

    private void introPaint(Graphics graphics) {
        switch (introState) {
            case 3: {
                this.introStateInfoScreenPaint(graphics);
                break;
            }
            case 0: {
                this.introStateMapGoDownPaint(graphics);
                break;
            }
            case 1: {
                this.introStateInitMapPaint(graphics);
                break;
            }
            case 2: {
                this.introStateMapGoUpPaint(graphics);
                break;
            }
        }
    }

    private void itemsInit() {
        Trigger trigger;
        int n = 0;
        this.spatialZonesItems = new Vector[Map.sectorsX][Map.sectorsY];
        for (int i = 0; i < Map.sectorsX; ++i) {
            for (int j = 0; j < Map.sectorsY; ++j) {
                this.spatialZonesItems[i][j] = new Vector();
            }
        }
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(10, n)) != null) {
            Item item = new Item();
            item.init();
            item.itemId = (byte)trigger.params[0];
            item.positionXf = (trigger.posX << 10) + 512;
            item.positionYf = (trigger.posY << 10) + 512;
            item.spatialIndicesCalculate();
            this.spatialZonesItems[item.shX][item.shY].addElement(item);
            ++n;
        }
    }

    private byte itemDropRandom() {
        int n = 0;
        int n2 = Util.getRandom(1, 1000);
        for (int i = 0; i < this.itemsLootTable.length; ++i) {
            if ((n += this.itemsLootTable[i]) < n2) continue;
            return (byte)i;
        }
        return -1;
    }

    private void itemDrop(int n, int n2, byte by) {
        if (by != -1) {
            Item item = new Item();
            item.init();
            item.itemId = by;
            item.positionXf = n;
            item.positionYf = n2;
            item.spatialIndicesCalculate();
            this.spatialZonesItems[item.shX][item.shY].addElement(item);
        }
    }

    private void itemMessageAdd(int n, int n2, int n3, int n4) {
        this.itemMessages.addElement(new ItemMessage(n, n2, n3, n4));
    }

    private void itemMessageUpdate(int n) {
        if (this.itemMessages != null) {
            for (int i = 0; i < this.itemMessages.size(); ++i) {
                ItemMessage itemMessage = (ItemMessage)this.itemMessages.elementAt(i);
                itemMessage.timerCurrent += n;
                if (itemMessage.timerCurrent >= itemMessage.endTime) {
                    this.itemMessages.removeElement(itemMessage);
                    itemMessage = null;
                    continue;
                }
                itemMessage.positionY -= 3000 * n >> 10;
            }
        }
    }

    private void itemMessagePaint(Graphics graphics) {
        if (this.itemMessages != null) {
            for (int i = this.itemMessages.size() - 1; i >= 0; --i) {
                ItemMessage itemMessage = (ItemMessage)this.itemMessages.elementAt(i);
                this.txt.drawText(graphics, itemMessage.textId, (itemMessage.positionX - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (itemMessage.positionY - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 1);
            }
        }
    }

    private void itemsPaint(Graphics graphics) {
        for (int i = spritesDisplaySpatialZoneVisibleTop; i <= spritesDisplaySpatialZoneVisibleBottom; ++i) {
            for (int j = spritesDisplaySpatialZoneVisibleLeft; j <= spritesDisplaySpatialZoneVisibleRight; ++j) {
                for (int k = this.spatialZonesItems[j][i].size() - 1; k >= 0; --k) {
                    Item item = (Item)this.spatialZonesItems[j][i].elementAt(k);
                    if (item.positionXf < spritesDisplayBorderLeftF || item.positionXf > spritesDisplayBorderRightF || item.positionYf < spritesDisplayBorderTopF || item.positionYf > spritesDisplayBorderBottomF) continue;
                    this.sprites[1].drawFrame(graphics, 0, animationGlobalCounter, (item.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (item.positionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 1);
                    this.sprites[1].drawFrame(graphics, item.getCurrentSequence(), animationGlobalCounter, (item.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (item.positionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 1);
                }
            }
        }
    }

    private void jackpotInit() {
        int n;
        jackpotState = 1;
        jackpotSpeedf = new int[3];
        jackpotAccelerationf = new int[3];
        jackpotSlot = new int[3][6];
        jackpotItemDifferenceYf = new int[3];
        jackpotTotalHeight = 240;
        jackpotFirstItemHeight = (C.getScreenHeight() >> 1) - (jackpotTotalHeight >> 1);
        jackpotPrizeCurrent = -1;
        jackpotIndexOfPrizeCombinationCurrent = -1;
        jackpotNumberOfWinsItem = -1;
        for (int i = 0; i < 3; ++i) {
            for (n = 0; n < 6; ++n) {
                boolean bl = false;
                block2: while (!bl) {
                    Mafia.jackpotSlot[i][n] = Util.getRandom(0, 6);
                    bl = true;
                    for (int j = 0; j < n; ++j) {
                        if (jackpotSlot[i][n] != jackpotSlot[i][j]) continue;
                        bl = false;
                        continue block2;
                    }
                }
            }
        }
        for (n = 0; n < 3; ++n) {
            Mafia.jackpotItemDifferenceYf[n] = 0;
        }
    }

    private void jackpotUpdate(int n) {
        if (C.getAction(128)) {
            C.keyClear();
            jackpotState = (byte)(jackpotState ^ jackpotState);
            this.rollerInit((byte)1, false);
        }
        if (jackpotState == 0) {
            this.jackpotInit();
        } else if (jackpotState == 1) {
            if (C.getAction(64) || C.getAction(16)) {
                C.keyClear();
                if (player.getStatistic((byte)3) >= 5) {
                    Player2.stats[3] = Player2.stats[3] - 5;
                    jackpotState = (byte)2;
                    for (int i = 0; i < 3; ++i) {
                        Mafia.jackpotSpeedf[i] = Util.getRandom(500, 600);
                        Mafia.jackpotSpeedf[i] = jackpotSpeedf[i] << 4;
                        Mafia.jackpotAccelerationf[i] = Util.getRandom(4, 6);
                    }
                } else {
                    this.messageInit(this.txt.getText(39), this.txt, false, false, false, -1, -1);
                }
            }
        } else if (jackpotState == 2) {
            for (int i = 0; i < 3; ++i) {
                if (jackpotSpeedf[i] == 0 && jackpotItemDifferenceYf[i] > 0) {
                    int n2 = i;
                    jackpotItemDifferenceYf[n2] = jackpotItemDifferenceYf[n2] - n * 64;
                    if (jackpotItemDifferenceYf[i] > 0) continue;
                    Mafia.jackpotItemDifferenceYf[i] = 0;
                    continue;
                }
                if (jackpotSpeedf[i] <= 0) continue;
                int n3 = i;
                jackpotItemDifferenceYf[n3] = jackpotItemDifferenceYf[n3] + (jackpotSpeedf[i] >> 4) * n;
                while (jackpotItemDifferenceYf[i] >> 10 > 40) {
                    this.jackpotSwapElements(jackpotSlot[i]);
                    int n4 = i;
                    jackpotItemDifferenceYf[n4] = jackpotItemDifferenceYf[n4] - 40960;
                }
                Mafia.jackpotSpeedf[i] = jackpotSpeedf[i] - jackpotAccelerationf[i] * n < 0 ? 0 : jackpotSpeedf[i] - jackpotAccelerationf[i] * n;
            }
            if (jackpotSpeedf[0] == 0 && jackpotSpeedf[1] == 0 && jackpotSpeedf[2] == 0 && jackpotItemDifferenceYf[0] == 0 && jackpotItemDifferenceYf[1] == 0 && jackpotItemDifferenceYf[2] == 0) {
                jackpotState = (byte)3;
                jackpotPrizeCurrent = -1;
                jackpotIndexOfPrizeCombinationCurrent = -1;
                jackpotNumberOfWinsItem = -1;
            }
        } else if (jackpotState == 3) {
            if (jackpotPrizeCurrent == -1 && jackpotIndexOfPrizeCombinationCurrent == -1) {
                jackpotPrizeCurrent = 0;
                block8: for (int i = 0; i < Cfg.JACKPOT_WIN_COMBINATION.length; ++i) {
                    switch (Cfg.JACKPOT_WIN_COMBINATION[i].length) {
                        case 1: {
                            for (int j = 0; j < 3; ++j) {
                                if (jackpotSlot[j][3] != Cfg.JACKPOT_WIN_COMBINATION[i][0] || Cfg.JACKPOT_WIN_PRIZE[i] <= jackpotPrizeCurrent) continue;
                                jackpotPrizeCurrent = Cfg.JACKPOT_WIN_PRIZE[i];
                                jackpotIndexOfPrizeCombinationCurrent = j;
                                jackpotNumberOfWinsItem = 1;
                                continue block8;
                            }
                            continue block8;
                        }
                        case 2: {
                            if (jackpotSlot[0][3] == Cfg.JACKPOT_WIN_COMBINATION[i][0] && jackpotSlot[1][3] == Cfg.JACKPOT_WIN_COMBINATION[i][1]) {
                                jackpotPrizeCurrent = Cfg.JACKPOT_WIN_PRIZE[i];
                                jackpotIndexOfPrizeCombinationCurrent = 0;
                                jackpotNumberOfWinsItem = 2;
                                continue block8;
                            }
                            if (jackpotSlot[1][3] != Cfg.JACKPOT_WIN_COMBINATION[i][0] || jackpotSlot[2][3] != Cfg.JACKPOT_WIN_COMBINATION[i][1]) continue block8;
                            jackpotPrizeCurrent = Cfg.JACKPOT_WIN_PRIZE[i];
                            jackpotIndexOfPrizeCombinationCurrent = 1;
                            jackpotNumberOfWinsItem = 2;
                            continue block8;
                        }
                        case 3: {
                            if (jackpotSlot[0][3] != Cfg.JACKPOT_WIN_COMBINATION[i][0] || jackpotSlot[1][3] != Cfg.JACKPOT_WIN_COMBINATION[i][1] || jackpotSlot[2][3] != Cfg.JACKPOT_WIN_COMBINATION[i][2]) continue block8;
                            jackpotPrizeCurrent = Cfg.JACKPOT_WIN_PRIZE[i];
                            jackpotIndexOfPrizeCombinationCurrent = 0;
                            jackpotNumberOfWinsItem = 3;
                            continue block8;
                        }
                    }
                }
                Player2.stats[3] = Player2.stats[3] + jackpotPrizeCurrent;
            }
            if (C.getAction(64) || C.getAction(16)) {
                jackpotState = 1;
            }
        }
    }

    private void jackpotSwapElements(int[] nArray) {
        int n = nArray[nArray.length - 1];
        for (int i = nArray.length - 2; i >= 0; --i) {
            nArray[i + 1] = nArray[i];
        }
        nArray[0] = n;
    }

    private void jackpotPaint(Graphics graphics) {
        int n;
        this.rollerPaint(graphics);
        if (jackpotState == 0) {
            return;
        }
        if (jackpotState == 1 || jackpotState == 2) {
            jackpotAnim.drawFrame(graphics, 2, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
            jackpotAnim.drawFrame(graphics, 3, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
            jackpotAnim.drawFrame(graphics, 4, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
        } else {
            int n2;
            if (jackpotPrizeCurrent > 0) {
                if (jackpotNumberOfWinsItem == 1) {
                    if (jackpotIndexOfPrizeCombinationCurrent == 0) {
                        jackpotAnim.drawFrame(graphics, 5, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 3, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 4, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                    } else if (jackpotIndexOfPrizeCombinationCurrent == 1) {
                        jackpotAnim.drawFrame(graphics, 2, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 6, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 4, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                    } else if (jackpotIndexOfPrizeCombinationCurrent == 2) {
                        jackpotAnim.drawFrame(graphics, 2, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 3, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 7, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                    }
                } else if (jackpotNumberOfWinsItem == 2) {
                    if (jackpotIndexOfPrizeCombinationCurrent == 0) {
                        jackpotAnim.drawFrame(graphics, 5, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 6, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 4, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                    } else if (jackpotIndexOfPrizeCombinationCurrent == 1) {
                        jackpotAnim.drawFrame(graphics, 2, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 6, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                        jackpotAnim.drawFrame(graphics, 7, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                    }
                } else if (jackpotNumberOfWinsItem == 3) {
                    jackpotAnim.drawFrame(graphics, 5, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                    jackpotAnim.drawFrame(graphics, 6, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                    jackpotAnim.drawFrame(graphics, 7, animationGlobalCounter, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                }
            } else {
                jackpotAnim.drawFrame(graphics, 2, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                jackpotAnim.drawFrame(graphics, 3, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
                jackpotAnim.drawFrame(graphics, 4, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
            }
            n = 0;
            if (jackpotPrizeCurrent > 0) {
                for (n2 = 0; n2 < this.txt.getText(38).length; ++n2) {
                    Mafia.hudTxtBuffer[n++] = this.txt.getText(38)[n2];
                }
                Mafia.hudTxtBuffer[n++] = 32;
                n2 = jackpotPrizeCurrent;
                if (n2 > 0) {
                    if (n2 > 9999) {
                        n2 = 9999;
                    }
                    boolean bl = true;
                    for (int i = 1000; i > 0; i /= 10) {
                        int n3 = n2 / i;
                        n2 -= n3 * i;
                        if (n3 == 0 && bl) continue;
                        Mafia.hudTxtBuffer[n++] = (char)(48 + n3);
                        bl = false;
                    }
                } else {
                    Mafia.hudTxtBuffer[n++] = 48;
                }
                Mafia.hudTxtBuffer[n++] = 36;
            } else {
                for (n2 = 0; n2 < this.txt.getText(98).length; ++n2) {
                    Mafia.hudTxtBuffer[n++] = this.txt.getText(98)[n2];
                }
            }
            this.txt.drawText(graphics, hudTxtBuffer, n, C.getScreenWidth() >> 1, C.getScreenHeight() - 45, 1);
        }
        graphics.setClip((C.getScreenWidth() >> 1) - 54 - 27 - 4 + 9, (C.getScreenHeight() >> 1) - 35 + 9, 36, 52);
        for (n = 0; n < 6; ++n) {
            jackpotAnim.drawFrame(graphics, 9 + jackpotSlot[0][n], 0, (C.getScreenWidth() >> 1) - 54 - 4, jackpotFirstItemHeight + n * 40 + (jackpotItemDifferenceYf[0] >> 10), 0);
        }
        graphics.setClip((C.getScreenWidth() >> 1) - 27 + 9, (C.getScreenHeight() >> 1) - 35 + 9, 36, 52);
        for (n = 0; n < 6; ++n) {
            jackpotAnim.drawFrame(graphics, 9 + jackpotSlot[1][n], 0, C.getScreenWidth() >> 1, jackpotFirstItemHeight + n * 40 + (jackpotItemDifferenceYf[1] >> 10), 0);
        }
        graphics.setClip((C.getScreenWidth() >> 1) + 27 + 4 + 9, (C.getScreenHeight() >> 1) - 35 + 9, 36, 52);
        for (n = 0; n < 6; ++n) {
            jackpotAnim.drawFrame(graphics, 9 + jackpotSlot[2][n], 0, (C.getScreenWidth() >> 1) + 54 + 4, jackpotFirstItemHeight + n * 40 + (jackpotItemDifferenceYf[2] >> 10), 0);
        }
        graphics.setClip(0, 0, C.getScreenWidth(), C.getScreenHeight());
        jackpotAnim.drawFrame(graphics, 8, 0, C.getScreenWidth() >> 1, C.getScreenHeight() >> 1, 1);
        this.hudCashPaint(graphics);
        Application.getSingleton().softs_Paint(graphics, 0, 1);
    }

    private boolean jackpotDetermineAppearance() {
        Trigger trigger = Map.layerTriggersHotSpots.getTriggerByType(13, 0);
        return trigger != null;
    }

    private void levelInit(byte by) {
        if (levelLoaded != by) {
            this.gameSetState((byte)1);
            this.inGameSetState((byte)0);
        } else {
            this.levelReset(true);
        }
    }

    private void levelDispose() {
        map.dispose();
        camera = null;
        this.carTypes = null;
        this.cars = null;
        this.carsWaitingForSpawn = null;
        this.citizens = null;
        this.citizenTypes = null;
        this.collisionBoundingBox = null;
        this.conversation = null;
        this.dummiesSpriteID = null;
        this.dummies = null;
        this.enemyTypes = null;
        this.enemies = null;
        this.epilogCitizen = null;
        this.epilogCar = null;
        this.hotSpots = null;
        this.hotSpotTriggerActive = null;
        hudAnimation = null;
        hudTxtBuffer = null;
        this.itemsLootTable = null;
        this.itemMessages = null;
        jackpotSpeedf = null;
        jackpotAccelerationf = null;
        jackpotSlot = null;
        jackpotAnim = null;
        jackpotItemDifferenceYf = null;
        messageTextBox = null;
        this.nickEdit = null;
        portraitsAnimation = null;
        this.rainPositionX = null;
        this.rainPositionY = null;
        this.rainHeight = null;
        this.shops = null;
        this.spatialZonesEnemies = null;
        this.spatialZonesCars = null;
        this.spatialZonesCitizens = null;
        this.spatialZonesStaticNoCollision = null;
        this.spatialZonesStaticCollision = null;
        this.spatialZonesItems = null;
        this.spatialZonesTrafficControlIndices = null;
        this.spritesAppearence = null;
        this.sprites = null;
        textBox = null;
        this.timers = null;
        this.trafficLights = null;
        this.trafficControlZones = null;
        this.txtConversationsAndQuests = null;
        levelLoaded = (byte)-1;
        C.gc();
    }

    private void levelReset(boolean bl) {
        try {
            levelLoadingReset = 0;
            this.enemiesInit();
            levelLoadingReset = 1;
            this.enemiesSpawn();
            levelLoadingReset = (byte)2;
            this.dummiesSpawn();
            levelLoadingReset = (byte)3;
            this.carsSpawn();
            levelLoadingReset = (byte)4;
            this.citizensInit();
            levelLoadingReset = (byte)5;
            this.citizensSpawn();
            levelLoadingReset = (byte)6;
            this.itemsInit();
            levelLoadingReset = (byte)7;
            this.playerInit();
            levelLoadingReset = (byte)8;
            this.crimeLevelReset();
            levelLoadingReset = (byte)9;
            this.hotspotsInit();
            levelLoadingReset = (byte)10;
            this.trafficLightsSpawn();
            levelLoadingReset = (byte)11;
            this.trafficControlZonesSpawn();
            levelLoadingReset = (byte)12;
            this.trafficLightsAssignToZones();
            levelLoadingReset = (byte)13;
            this.spatialZonesInit();
            levelLoadingReset = (byte)14;
            this.scenarioProgressCounter = 0;
            levelTimeCurrent ^= levelTimeCurrent;
            this.itemMessages = new Vector();
            levelLoadingReset = (byte)15;
            levelLoadingReset = (byte)16;
            this.timers = new Vector();
            this.collisionBoundingBox = new Polygon(4);
            hudTxtBuffer = new char[20];
            levelLoadingReset = (byte)17;
            this.cameraInit();
            levelLoadingReset = (byte)18;
            if (rainVisible) {
                this.rainInit();
            }
            levelLoadingReset = (byte)19;
            if (bl) {
                this.transitionStart((byte)1, true);
            }
            levelLoadingReset = (byte)20;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void levelSettingsLoad() {
        block10: {
            FilterInputStream filterInputStream = null;
            try {
                int n;
                filterInputStream = new DataInputStream(midlet.getClass().getResourceAsStream("Levels.sse"));
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readShort();
                short s = ((DataInputStream)filterInputStream).readShort();
                int n2 = ((DataInputStream)filterInputStream).readShort();
                for (n = 0; n < n2; ++n) {
                    if (n == levelCurrent) {
                        Mafia.map.fileMapId = (byte)((DataInputStream)filterInputStream).readShort();
                        Mafia.map.fileTemplatesId = (byte)((DataInputStream)filterInputStream).readShort();
                        Mafia.map.fileBackgroundId = (byte)((DataInputStream)filterInputStream).readShort();
                        Mafia.map.fileForegroundId = (byte)((DataInputStream)filterInputStream).readShort();
                        Mafia.map.filePlaceablesId = (byte)((DataInputStream)filterInputStream).readShort();
                        Conversation.fileConversationId = (byte)((DataInputStream)filterInputStream).readShort();
                        Conversation.fileConversationTxtId = (byte)((DataInputStream)filterInputStream).readShort();
                        continue;
                    }
                    ((DataInputStream)filterInputStream).skipBytes(s << 1);
                }
                s = ((DataInputStream)filterInputStream).readShort();
                n2 = ((DataInputStream)filterInputStream).readShort();
                for (n = 0; n < n2; ++n) {
                    if (n == levelCurrent) {
                        crimeEnemyId = (byte)((DataInputStream)filterInputStream).readShort();
                        crimeLevelIsEnabled = crimeEnemyId >= 0;
                        this.trafficLightsEnabled = ((DataInputStream)filterInputStream).readShort() > 0;
                        rainVisible = ((DataInputStream)filterInputStream).readShort() > 0;
                        continue;
                    }
                    ((DataInputStream)filterInputStream).skipBytes(s << 1);
                }
                this.itemsLootTable = new short[21];
                s = ((DataInputStream)filterInputStream).readShort();
                n2 = ((DataInputStream)filterInputStream).readShort();
                for (n = 0; n < n2; ++n) {
                    if (n == levelCurrent) {
                        this.itemsLootTable[0] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[1] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[2] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[3] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[4] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[5] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[6] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[7] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[8] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[9] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[10] = ((DataInputStream)filterInputStream).readShort();
                        this.itemsLootTable[11] = ((DataInputStream)filterInputStream).readShort();
                        continue;
                    }
                    ((DataInputStream)filterInputStream).skipBytes(s << 1);
                }
                s = ((DataInputStream)filterInputStream).readShort();
                n2 = ((DataInputStream)filterInputStream).readShort();
                this.crimeLevelTime = ((DataInputStream)filterInputStream).readShort() * 1000;
                this.crimeLevelIncomingCopsAtTriggersNumber = (byte)((DataInputStream)filterInputStream).readShort();
                this.crimeLevelIncomingCopsOnRadiusNumber = (byte)((DataInputStream)filterInputStream).readShort();
                this.crimeLevelIncomingCopsArivvalRadius = ((DataInputStream)filterInputStream).readShort();
                this.crimeLevelCopsReactionRadious = ((DataInputStream)filterInputStream).readShort();
                this.crimeLevelCitizenKillPoints = ((DataInputStream)filterInputStream).readShort();
                this.crimeLevelCopKillPoints = ((DataInputStream)filterInputStream).readShort();
                this.crimeLevelCarHijackPoints = ((DataInputStream)filterInputStream).readShort();
                this.crimeLevelShootNearCopPoints = ((DataInputStream)filterInputStream).readShort();
                filterInputStream.close();
            }
            catch (Exception exception) {
                if (filterInputStream == null) break block10;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private void levelLoadingUpdate(int n) {
        if (levelLoadingStage == 0) {
            introAnimation = null;
            C.gc();
        } else if (levelLoadingStage == 47) {
            this.txtConversationsAndQuests = new Txt(midlet, "Conversation" + Util.numberToString(Conversation.fileConversationTxtId, 2) + ".sts");
            this.txtConversationsAndQuests.loadLanguage(midlet, "Conversation" + Util.numberToString(Conversation.fileConversationTxtId, 2) + ".sts", Application.getSingleton().getLanguageId());
            this.txtConversationsAndQuests.setFont(Application.font);
        } else if (levelLoadingStage == 1) {
            map = new Map();
            this.levelSettingsLoad();
        } else if (levelLoadingStage == 2) {
            map.load("Map" + Util.numberToString(Mafia.map.fileMapId, 2), "MapTemplates" + Util.numberToString(Mafia.map.fileTemplatesId, 2), C.getScreenWidth(), C.getScreenHeight());
        } else if (levelLoadingStage == 3) {
            map.setBackgroundGfx(new Gfx(midlet, "MapBackground" + Util.numberToString(Mafia.map.fileBackgroundId, 2) + ".sgs", 0, map.getBackgroundUsageInfo()));
        } else if (levelLoadingStage == 4) {
            if (Mafia.map.fileForegroundId >= 0) {
                map.setForegroundGfx(new Gfx(midlet, "MapForeground" + Util.numberToString(Mafia.map.fileForegroundId, 2) + ".sgs", 0, map.getForegroundUsageInfo()));
            } else {
                map.setForegroundGfx(null);
            }
        } else if (levelLoadingStage == 5) {
            map.setPlaceablesAnimation(new Anim(midlet, "MapPlaceables" + Util.numberToString(Mafia.map.filePlaceablesId, 2) + ".sai", "MapPlaceables" + Util.numberToString(Mafia.map.filePlaceablesId, 2) + ".sgs", C.getScreenWidth(), C.getScreenHeight(), 0, map.getPlaceablesUsageInfo(), false));
        } else if (levelLoadingStage == 6) {
            this.enemiesSettingsLoad();
        } else if (levelLoadingStage == 8) {
            this.citizensSettingsLoad();
        } else if (levelLoadingStage == 7) {
            this.dummiesSettingsLoad();
        } else if (levelLoadingStage == 9) {
            this.carsSettingsLoad();
        } else if (levelLoadingStage == 42) {
            this.shopsSettingsLoad(this.shopsDetermineAppearance());
        } else if (levelLoadingStage != 43) {
            if (levelLoadingStage == 10) {
                this.spritesAppearence = this.spritesDetermineAppearance();
                this.sprites = new Anim[this.spritesAppearence.length];
            } else if (levelLoadingStage >= 11 && levelLoadingStage < 41) {
                int n2 = levelLoadingStage - 11;
                if (this.spritesAppearence[n2]) {
                    this.sprites[n2] = new Anim(midlet, "Sprite" + Util.numberToString(n2, 2) + ".sai", "Sprite" + Util.numberToString(n2, 2) + ".sgs", C.getScreenWidth(), C.getScreenHeight(), Util.getRandom(0, Cfg.SPRITE_COLOR_SETS_NUMBER[n2] - 1), null, false);
                }
            } else if (levelLoadingStage == 41) {
                this.spritesAppearence = null;
            } else if (levelLoadingStage == 44) {
                this.conversationSettingsLoad();
            } else if (levelLoadingStage == 45) {
                portraitsAnimation = new Anim(midlet, "Portraits.sai", "Portraits.sgs", C.getScreenWidth(), C.getScreenHeight(), null, this.portraitsDetermineAppearance(), false);
            } else if (levelLoadingStage == 46) {
                hudAnimation = new Anim(midlet, "Gui.sai", "Gui.sgs", C.getScreenWidth(), C.getScreenHeight(), null, null, false);
            } else if (levelLoadingStage == 48) {
                jackpotAnim = this.jackpotDetermineAppearance() ? new Anim(midlet, "Jackpot.sai", "Jackpot.sgs", C.getScreenWidth(), C.getScreenHeight(), null, null, false) : null;
            } else if (levelLoadingStage != 49 && levelLoadingStage != 50) {
                if (levelLoadingStage == 51) {
                    this.levelReset(false);
                } else if (levelLoadingStage == 52) {
                    if (!C.getAction(16)) {
                        levelLoadingStage = (byte)(levelLoadingStage - 1);
                        if ((levelLoadingPressFireTimeCurrent += n) >= 300) {
                            this.levelLoadingIsPressFireTxtVisible = !this.levelLoadingIsPressFireTxtVisible;
                            levelLoadingPressFireTimeCurrent = 0;
                        }
                    }
                } else if (levelLoadingStage == 53) {
                    loadingBarGfx = null;
                    this.hudMessageInit((byte)0);
                    this.soundPlayMusic();
                    if (levelCurrent == 17) {
                        this.transitionStart((byte)16, true);
                        this.epilogInit();
                    } else {
                        this.transitionStart((byte)1, true);
                    }
                }
            }
        }
        levelLoadingStage = (byte)(levelLoadingStage + 1);
    }

    private void levelLoadingPaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
        if (loadingBarGfx != null) {
            if (levelLoadingStage >= 52) {
                graphics.setClip(0, 0, C.SCREEN_WIDTH, C.SCREEN_HEIGHT);
                loadingBarGfx.drawImage(graphics, 0, (C.getScreenWidth() >> 1) - (Mafia.loadingBarGfx.images[0][0].getWidth() >> 1), (C.getScreenHeight() >> 1) - (Mafia.loadingBarGfx.images[0][0].getHeight() >> 1));
                if (this.levelLoadingIsPressFireTxtVisible) {
                    this.txt.drawText(graphics, 37, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) + Mafia.loadingBarGfx.images[0][0].getHeight(), 1);
                }
            } else {
                graphics.setClip(0, (C.getScreenHeight() >> 1) + (Mafia.loadingBarGfx.images[0][0].getHeight() >> 1) - ((Mafia.loadingBarGfx.images[0][0].getHeight() << 10) / 52 * levelLoadingStage >> 10), C.getScreenWidth(), C.getScreenHeight());
                loadingBarGfx.drawImage(graphics, 0, (C.getScreenWidth() >> 1) - (Mafia.loadingBarGfx.images[0][0].getWidth() >> 1), (C.getScreenHeight() >> 1) - (Mafia.loadingBarGfx.images[0][0].getHeight() >> 1));
                graphics.setClip(0, 0, C.SCREEN_WIDTH, C.SCREEN_HEIGHT);
                this.txt.drawText(graphics, 36, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) + Mafia.loadingBarGfx.images[0][0].getHeight(), 1);
            }
        }
    }

    private void levelEndingConfirm() {
        this.levelEndingInGameState = inGameState;
        this.inGameSetState((byte)9);
        this.messageInit(this.txt.getText(74), this.txt, false, false, false, 0, 1);
    }

    private void levelEndingSummary(boolean bl) {
        if (bl) {
            this.inGameSetState((byte)11);
            if (levelCurrent != 15 && levelCurrent != 17) {
                long l = (levelTimeCurrent >> 10) / 3600L;
                String string = l < 10L ? "0" + l + " : " : l + " : ";
                l = (levelTimeCurrent >> 10) % 3600L / 60L;
                string = l < 10L ? string + "0" + l + " : " : string + l + " : ";
                l = (levelTimeCurrent >> 10) % 3600L % 60L;
                string = l < 10L ? string + "0" + l : string + l;
                String string2 = "\n" + this.txt.getTextAsString(75) + "\n" + String.valueOf(Player2.stats[4]) + "\n\n" + this.txt.getTextAsString(76) + "\n" + String.valueOf(Player2.stats[5]) + "\n\n" + this.txt.getTextAsString(77) + "\n" + String.valueOf(Player2.stats[6]) + "\n\n" + this.txt.getTextAsString(78) + "\n" + String.valueOf(Player2.stats[7]) + "\n\n" + this.txt.getTextAsString(79) + "\n" + String.valueOf(Player2.stats[3]) + "\n\n" + this.txt.getTextAsString(86) + "\n" + string + "\n\n";
                int n = string2.length();
                char[] cArray = new char[n];
                --n;
                while (n >= 0) {
                    cArray[n] = string2.charAt(n);
                    --n;
                }
                string2 = null;
                this.messageInit(cArray, this.txt, false, false, false, -1, -1);
            }
        } else {
            this.inGameSetState(this.levelEndingInGameState);
            if (this.hotSpotTriggerActive != null) {
                this.hotspotTriggerFinalize((byte)this.hotSpotTriggerActive.params[0], (byte)-1);
            }
        }
    }

    private void levelFinalize() {
        if (levelCurrent != 17) {
            player.addStatsCurrentToTotal();
            Player2.stats[14] = (int)((long)Player2.stats[14] + (levelTimeCurrent >> 10));
        }
        if (levelCurrent == 15 || levelCurrent == 17) {
            endGameState = 0;
            this.gameSetState((byte)2);
            long l = Player2.stats[14] / 3600;
            String string = l < 10L ? "0" + l + " : " : l + " : ";
            l = Player2.stats[14] % 3600 / 60;
            string = l < 10L ? string + "0" + l + " : " : string + l + " : ";
            l = Player2.stats[14] % 3600 % 60;
            string = l < 10L ? string + "0" + l : string + l;
            String string2 = "\n" + this.txt.getTextAsString(81) + "  " + String.valueOf(Player2.stats[10]) + "\n\n" + this.txt.getTextAsString(82) + "  " + String.valueOf(Player2.stats[11]) + "\n\n" + this.txt.getTextAsString(83) + "  " + String.valueOf(Player2.stats[12]) + "\n\n" + this.txt.getTextAsString(84) + "  " + String.valueOf(Player2.stats[13]) + "\n\n" + this.txt.getTextAsString(85) + "  " + String.valueOf(Player2.stats[9]) + "\n\n" + this.txt.getTextAsString(86) + "  " + string + "\n\n";
            string = null;
            int n = string2.length();
            char[] cArray = new char[n];
            --n;
            while (n >= 0) {
                cArray[n] = string2.charAt(n);
                --n;
            }
            string2 = null;
            this.messageInit(cArray, this.txt, false, false, false, -1, -1);
        } else if (levelCurrent == 14 && this.scenarioProgressCounter == 1) {
            levelCurrent = (byte)16;
            this.levelDispose();
            this.saveGame();
            this.introInit();
        } else {
            if (levelCurrent == 0) {
                isInfoScreen = true;
            }
            levelCurrent = (byte)(levelCurrent + 1);
            this.levelDispose();
            this.saveGame();
            this.introInit();
        }
    }

    private void lockPickInit() {
        this.lockpickPosX = (short)(C.getScreenWidth() - 142 >> 1);
        this.lockpickPointerPos = (short)Util.getRandom(0, 1023);
        this.lockpickPointerSpeed = (short)800;
        this.lockpickPointerMovingDirectionIsLeft = Util.getRandom(0, 1) == 1;
        this.lockpickBouncesNumber = (short)(this.lockpickBouncesNumber ^ this.lockpickBouncesNumber);
        this.lockpickActiveAreaSizeCurrent = (short)(this.lockpickActiveAreaSizeCurrent ^ this.lockpickActiveAreaSizeCurrent);
        this.lockpickActiveAreaSizeFinal = (short)Util.getRandom(256, 512);
        this.lockpickActiveAreaSizeGrowingSpeed = (short)200;
        this.lockpickActiveAreaSizeGrowingAcceleration = (short)600;
        this.lockpickActiveAreaPosition = (short)Util.getRandom(this.lockpickActiveAreaSizeFinal >> 1, 1024 - (this.lockpickActiveAreaSizeFinal >> 1));
        this.lockpickActiveAreaIsGrowing = true;
        this.lockpickInitializationFinished = true;
    }

    private void lockPickPaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(20, (C.getScreenHeight() >> 1) - 25, C.getScreenWidth() - 40, 50);
        graphics.setColor(65280);
        graphics.fillRect(this.lockpickPosX + ((this.lockpickActiveAreaPosition - (this.lockpickActiveAreaSizeCurrent >> 1)) * 142 + 512 >> 10), (C.getScreenHeight() >> 1) - 25, this.lockpickActiveAreaSizeCurrent * 142 + 512 >> 10, 50);
        graphics.setColor(0xFF0000);
        graphics.drawLine(this.lockpickPosX + (this.lockpickPointerPos * 142 + 512 >> 10), (C.getScreenHeight() >> 1) - 25, this.lockpickPosX + (this.lockpickPointerPos * 142 + 512 >> 10), (C.getScreenHeight() >> 1) + 25);
        this.rollerPaint(graphics);
    }

    private void lockPickUpdate(int n) {
        if (!this.lockpickInitializationFinished) {
            this.lockPickInit();
        } else {
            if (C.getAction(16)) {
                C.keyClear();
                if (this.lockpickPointerPos >= this.lockpickActiveAreaPosition - (this.lockpickActiveAreaSizeFinal >> 1) && this.lockpickPointerPos <= this.lockpickActiveAreaPosition + (this.lockpickActiveAreaSizeFinal >> 1)) {
                    this.playerCarEnterNow(false, true);
                    this.lockpickInitializationFinished = false;
                } else {
                    this.rollerInit((byte)1, false);
                    this.crimeLevelIncrease(1024, true);
                    this.lockpickInitializationFinished = false;
                }
            }
            this.lockpickActiveAreaSizeGrowingSpeed = (short)(this.lockpickActiveAreaSizeGrowingSpeed + (this.lockpickActiveAreaSizeGrowingAcceleration * n + 512 >> 10));
            if (this.lockpickActiveAreaIsGrowing) {
                this.lockpickActiveAreaSizeCurrent = (short)(this.lockpickActiveAreaSizeCurrent + (this.lockpickActiveAreaSizeGrowingSpeed * n + 512 >> 10));
                if (this.lockpickActiveAreaSizeCurrent >= this.lockpickActiveAreaSizeFinal) {
                    this.lockpickActiveAreaSizeCurrent = this.lockpickActiveAreaSizeFinal;
                    this.lockpickActiveAreaSizeGrowingSpeed = 0;
                    this.lockpickActiveAreaIsGrowing = false;
                }
            } else {
                this.lockpickActiveAreaSizeCurrent = (short)(this.lockpickActiveAreaSizeCurrent - (this.lockpickActiveAreaSizeGrowingSpeed * n + 512 >> 10));
                if (this.lockpickActiveAreaSizeCurrent < 0) {
                    this.lockpickActiveAreaSizeCurrent = 0;
                }
            }
            this.lockpickPointerSpeed = (short)(this.lockpickPointerSpeed + (800 * n + 512 >> 10));
            if (this.lockpickPointerSpeed > 2048) {
                this.lockpickPointerSpeed = (short)2048;
            }
            if (!this.lockpickPointerMovingDirectionIsLeft) {
                this.lockpickPointerPos = (short)(this.lockpickPointerPos + (this.lockpickPointerSpeed * n + 512 >> 10));
                if (this.lockpickPointerPos >= 1024) {
                    this.lockpickPointerPos = (short)1024;
                    this.lockpickPointerMovingDirectionIsLeft = true;
                    this.lockpickBouncesNumber = (short)(this.lockpickBouncesNumber + 1);
                }
            } else {
                this.lockpickPointerPos = (short)(this.lockpickPointerPos - (this.lockpickPointerSpeed * n >> 10));
                if (this.lockpickPointerPos <= 0) {
                    this.lockpickPointerPos = 0;
                    this.lockpickPointerMovingDirectionIsLeft = false;
                    this.lockpickBouncesNumber = (short)(this.lockpickBouncesNumber + 1);
                }
            }
            if (this.lockpickBouncesNumber == 3) {
                this.rollerInit((byte)1, false);
                this.crimeLevelIncrease(1024, true);
                this.lockpickInitializationFinished = false;
            }
        }
    }

    private void messageInit(char[] cArray, Txt txt, boolean bl, boolean bl2, boolean bl3, int n, int n2) {
        this.inGameSetState((byte)4);
        messageSoftLeft = n;
        messageSoftRight = n2;
        messageEndAfterTime = bl;
        messageRunTriggerFinalize = bl2;
        messageRunTriggerQestion = bl3;
        this.messageStateTimer ^= this.messageStateTimer;
        messageWidth = 168;
        messageHeight = 180;
        messageTilesH = 28;
        messageTilesV = 30;
        messageTextBox = new TextBox();
        messageTextBox.init(txt);
        messageTextBox.setPositionX((C.getScreenWidth() - messageWidth >> 1) + 8);
        messageTextBox.setPositionY((C.getScreenHeight() - messageHeight >> 1) + 8);
        messageTextBox.setWidth(messageWidth - 16 - 10);
        messageTextBox.setHeight(messageHeight - 16);
        messageTextBox.setTextAlignment(3);
        if (!messageEndAfterTime && messageSoftLeft == -1 && messageSoftRight == -1) {
            int n3;
            char[] cArray2 = new char[cArray.length + this.txt.getText(99).length];
            for (n3 = 0; n3 < cArray.length; ++n3) {
                cArray2[n3] = cArray[n3];
            }
            char[] cArray3 = new char[this.txt.getText(99).length];
            cArray3 = this.txt.getText(99);
            for (int i = 0; i < cArray3.length; ++i) {
                cArray2[n3] = cArray3[i];
                ++n3;
            }
            messageTextBox.setText(cArray2);
        } else {
            messageTextBox.setText(cArray);
        }
        messageTextBox.setScrollBarVisibility(true);
        messageTextBox.setScrollBarSize(10, messageHeight - 32);
        messageTextBox.setScrollBarParameters(2, 1, 1, 0xFFFFFF, 0);
        messageTextBox.calculateSlideSize();
    }

    private void messageUpdate(int n) {
        if (C.getAction(1)) {
            messageTextBox.scrollUp(51200, n);
        }
        if (C.getAction(2)) {
            messageTextBox.scrollDown(51200, n);
        }
        switch (gameState) {
            case 1: {
                if (messageEndAfterTime) {
                    if (this.messageStateTimer >= 6000 || C.getAction(16) || C.getAction(64) || C.getAction(128)) {
                        this.messageResponseResult = !C.getAction(128);
                        this.inGameSetState(inGameStatePrevious);
                        if (messageRunTriggerFinalize) {
                            if (messageRunTriggerQestion && C.getAction(128)) {
                                this.hotspotTriggerFinalize(messageQuestionNegativeAnswerActivateId, messageQuestionNegativeAnswerReleaseId);
                            } else {
                                this.hotspotTriggerFinalize();
                            }
                        }
                        C.keyClear();
                    }
                    this.messageStateTimer += n;
                    break;
                }
                if (!C.getAction(16) && !C.getAction(64) && !C.getAction(128)) break;
                this.messageResponseResult = !C.getAction(128);
                this.inGameSetState(inGameStatePrevious);
                if (messageRunTriggerFinalize) {
                    if (messageRunTriggerQestion && C.getAction(128)) {
                        this.hotspotTriggerFinalize(messageQuestionNegativeAnswerActivateId, messageQuestionNegativeAnswerReleaseId);
                    } else {
                        this.hotspotTriggerFinalize();
                    }
                }
                C.keyClear();
                break;
            }
            case 2: {
                if (!C.getAction(16)) break;
                this.transitionStart((byte)2, false);
                endGameState = 1;
            }
        }
    }

    private void messagePaint(Graphics graphics) {
        int n;
        int n2 = C.getScreenWidth() - messageWidth >> 1;
        int n3 = C.getScreenHeight() - messageHeight >> 1;
        graphics.setColor(0);
        graphics.fillRect(n2, n3, messageWidth - 8, messageHeight - 8);
        if (messageTextBox != null) {
            messageTextBox.paint(graphics);
        }
        hudAnimation.drawFrame(graphics, 0, 0, n2, n3, 0);
        hudAnimation.drawFrame(graphics, 1, 0, n2 + messageWidth - 6, n3, 0);
        hudAnimation.drawFrame(graphics, 2, 0, n2, n3 + messageHeight - 6, 0);
        hudAnimation.drawFrame(graphics, 3, 0, n2 + messageWidth - 6, n3 + messageHeight - 6, 0);
        for (n = 1; n < messageTilesH - 1; ++n) {
            hudAnimation.drawFrame(graphics, 4, 0, n2 + n * 6, n3, 0);
            hudAnimation.drawFrame(graphics, 5, 0, n2 + n * 6, n3 + messageHeight - 6, 0);
        }
        for (n = 1; n < messageTilesV - 1; ++n) {
            hudAnimation.drawFrame(graphics, 6, 0, n2, n3 + n * 6, 0);
            hudAnimation.drawFrame(graphics, 7, 0, n2 + messageWidth - 6, n3 + n * 6, 0);
        }
        Application.getSingleton().softs_Paint(graphics, messageSoftLeft, messageSoftRight);
    }

    private void nickNameInit() {
        this.nickEdit = new Edit(null, this.txt, 6);
        this.nickEdit.setPositionX(C.getScreenWidth() >> 1);
        this.nickEdit.setPositionY(C.getScreenHeight() >> 1);
        this.nickEdit.setAnchorPoint(1);
    }

    private void nickNamePaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
        this.txt.drawText(graphics, 88, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) - (C.getScreenHeight() >> 2), 1);
        this.nickEdit.paint(graphics);
        Application.getSingleton().softs_Paint(graphics, 0, 1);
    }

    private void nickNameUpdate(int n) {
        if (C.getAction(64)) {
            int n2;
            levelCurrent = (byte)-1;
            int n3 = 0;
            for (n2 = 0; n2 < Application.highScorePoints.length; ++n2) {
                if (Application.highScorePoints[n2] >= player.getTotalScore()) continue;
                n3 = n2;
                break;
            }
            for (n2 = Application.highScorePoints.length - 2; n2 >= n3; --n2) {
                Application.highScorePoints[n2 + 1] = Application.highScorePoints[n2];
                for (int i = 0; i < Application.highScoreNames[n2 + 1].length; ++i) {
                    Application.highScoreNames[n2 + 1][i] = Application.highScoreNames[n2][i];
                }
            }
            Application.highScorePoints[n3] = player.getTotalScore();
            for (n2 = 0; n2 < SAF_Application.Cfg.RMS_HIGHSCORES_NAME_LENGTH; ++n2) {
                Application.highScoreNames[n3][n2] = n2 < this.nickEdit.getText().length() ? this.nickEdit.getText().charAt(n2) : (char)32;
            }
            Application.getSingleton().highscoresSave(Application.highScoreNames, Application.highScorePoints);
            this.saveGame();
            Application.getSingleton().menu_InitTextTable();
            Application.getSingleton().game_End(3);
            C.keyClear();
        } else {
            this.nickEdit.update(n);
        }
    }

    private void playUpdate(int n) {
        levelTimeCurrent += (long)n;
        if (C.getAction(128)) {
            this.pause();
        }
        int n2 = 0;
        try {
            if (inGameState == 1) {
                n2 = 1;
                this.playerUpdate(n);
            } else if (inGameState == 2) {
                n2 = 2;
                this.carDriveUpdate(n);
                n2 = 3;
            }
            n2 = 4;
            this.spatialZonesCalcNear(Mafia.player.positionXf, Mafia.player.positionYf);
            Mafia.player.spatialZoneNearX1 = this.spatialZoneNearX1;
            Mafia.player.spatialZoneNearX2 = this.spatialZoneNearX2;
            Mafia.player.spatialZoneNearY1 = this.spatialZoneNearY1;
            Mafia.player.spatialZoneNearY2 = this.spatialZoneNearY2;
            n2 = 5;
            this.crimeLevelUpdate(n);
            n2 = 6;
            this.worldUpdate(n);
            n2 = 7;
            this.itemMessageUpdate(n);
            n2 = 8;
            n2 = 9;
            this.hudBloodUpdate(n);
            n2 = 10;
            this.timerUpdate(n);
            n2 = 11;
            this.rainUpdate(n);
        }
        catch (Exception exception) {
            C.err(N, "play update: " + n2 + "  err: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void playerInit() {
        if (player == null) {
            player = new Player2();
            player.init(midlet, "Player.sse");
        }
        player.reset();
        Trigger trigger = Map.layerTriggersSpawn.getTriggerByType(5);
        Mafia.player.isVisible = true;
        Mafia.player.positionXf = (trigger.posX << 10) + 512;
        Mafia.player.positionYf = (trigger.posY << 10) + 512;
        this.spatialZonesCalcNear(Mafia.player.positionXf, Mafia.player.positionYf);
        Mafia.player.spatialZoneNearX1 = this.spatialZoneNearX1;
        Mafia.player.spatialZoneNearX2 = this.spatialZoneNearX2;
        Mafia.player.spatialZoneNearY1 = this.spatialZoneNearY1;
        Mafia.player.spatialZoneNearY2 = this.spatialZoneNearY2;
        player.setDirection((byte)1);
    }

    private void playerCarTargetHandler() {
        Mafia.player.car = null;
        int n = 0;
        int n2 = Mafia.player.carEnterRangeQF;
        switch (Mafia.player.direction) {
            case 0: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        n ^= n;
                        while (n < this.spatialZonesCars[j][i].size()) {
                            int n3;
                            Car car = (Car)this.spatialZonesCars[j][i].elementAt(n);
                            if (car.positionXf <= Mafia.player.positionXf && (n3 = Mafia.getRangeQ(Mafia.player.positionXf, Mafia.player.positionYf, car.positionXf, car.positionYf)) < n2 && car.state != 3 && car.state != 11) {
                                n2 = n3;
                                Mafia.player.car = car;
                            }
                            ++n;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        n ^= n;
                        while (n < this.spatialZonesCars[j][i].size()) {
                            int n4;
                            Car car = (Car)this.spatialZonesCars[j][i].elementAt(n);
                            if (car.positionXf >= Mafia.player.positionXf && (n4 = Mafia.getRangeQ(Mafia.player.positionXf, Mafia.player.positionYf, car.positionXf, car.positionYf)) < n2 && car.state != 3 && car.state != 11) {
                                n2 = n4;
                                Mafia.player.car = car;
                            }
                            ++n;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        n ^= n;
                        while (n < this.spatialZonesCars[j][i].size()) {
                            int n5;
                            Car car = (Car)this.spatialZonesCars[j][i].elementAt(n);
                            if (car.positionYf <= Mafia.player.positionYf && (n5 = Mafia.getRangeQ(Mafia.player.positionXf, Mafia.player.positionYf, car.positionXf, car.positionYf)) < n2 && car.state != 3 && car.state != 11) {
                                n2 = n5;
                                Mafia.player.car = car;
                            }
                            ++n;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        n ^= n;
                        while (n < this.spatialZonesCars[j][i].size()) {
                            int n6;
                            Car car = (Car)this.spatialZonesCars[j][i].elementAt(n);
                            if (car.positionYf >= Mafia.player.positionYf && (n6 = Mafia.getRangeQ(Mafia.player.positionXf, Mafia.player.positionYf, car.positionXf, car.positionYf)) < n2 && car.state != 3 && car.state != 11) {
                                n2 = n6;
                                Mafia.player.car = car;
                            }
                            ++n;
                        }
                    }
                }
                break;
            }
        }
        if (Mafia.player.car != null) {
            if (Mafia.player.car.getState() == 0) {
                this.tutorialLaunch((byte)9);
            } else if (Mafia.player.car.getState() != 8) {
                this.tutorialLaunch((byte)8);
            }
        }
    }

    private void playerTargetHandler() {
        if (Mafia.player.weapon != 0) {
            int n = player.getShootRangeQ();
            Enemy enemy = null;
            switch (Mafia.player.direction) {
                case 0: {
                    for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                        for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                            int n2 = this.spatialZonesEnemies[j][i].size();
                            --n2;
                            while (n2 >= 0) {
                                int n3;
                                Enemy enemy2 = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n2);
                                if (enemy2.isActive && enemy2.positionXf < Mafia.player.positionXf && (n3 = Mafia.getRangeQ(enemy2.positionXf, enemy2.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n3 < n && map.isShootPossible(Mafia.player.positionXf, Mafia.player.positionYf, enemy2.positionXf, enemy2.positionYf)) {
                                    enemy = enemy2;
                                    n = n3;
                                }
                                --n2;
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                        for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                            int n4 = this.spatialZonesEnemies[j][i].size();
                            --n4;
                            while (n4 >= 0) {
                                int n5;
                                Enemy enemy3 = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n4);
                                if (enemy3.isActive && enemy3.positionXf > Mafia.player.positionXf && (n5 = Mafia.getRangeQ(enemy3.positionXf, enemy3.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n5 < n && map.isShootPossible(Mafia.player.positionXf, Mafia.player.positionYf, enemy3.positionXf, enemy3.positionYf)) {
                                    enemy = enemy3;
                                    n = n5;
                                }
                                --n4;
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                        for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                            int n6 = this.spatialZonesEnemies[j][i].size();
                            --n6;
                            while (n6 >= 0) {
                                int n7;
                                Enemy enemy4 = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n6);
                                if (enemy4.isActive && enemy4.positionYf < Mafia.player.positionYf && (n7 = Mafia.getRangeQ(enemy4.positionXf, enemy4.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n7 < n && map.isShootPossible(Mafia.player.positionXf, Mafia.player.positionYf, enemy4.positionXf, enemy4.positionYf)) {
                                    enemy = enemy4;
                                    n = n7;
                                }
                                --n6;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                        for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                            int n8 = this.spatialZonesEnemies[j][i].size();
                            --n8;
                            while (n8 >= 0) {
                                int n9;
                                Enemy enemy5 = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n8);
                                if (enemy5.isActive && enemy5.positionYf >= Mafia.player.positionYf && (n9 = Mafia.getRangeQ(enemy5.positionXf, enemy5.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n9 < n && map.isShootPossible(Mafia.player.positionXf, Mafia.player.positionYf, enemy5.positionXf, enemy5.positionYf)) {
                                    enemy = enemy5;
                                    n = n9;
                                }
                                --n8;
                            }
                        }
                    }
                    break;
                }
            }
            if (enemy != null) {
                if (Mafia.player.targetEnemy != enemy) {
                    player.setTarget(enemy);
                }
            } else {
                player.setTarget(null);
            }
        }
    }

    private void playerPunchDoDmgOnEnemies() {
        int n = player.getShootRangeQ();
        Enemy enemy = null;
        switch (Mafia.player.direction) {
            case 0: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        int n2 = this.spatialZonesEnemies[j][i].size();
                        --n2;
                        while (n2 >= 0) {
                            int n3;
                            Enemy enemy2 = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n2);
                            if (enemy2.isActive && enemy2.positionXf < Mafia.player.positionXf && (n3 = Mafia.getRangeQ(enemy2.positionXf, enemy2.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n3 < n) {
                                enemy = enemy2;
                                n = n3;
                            }
                            --n2;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        int n4 = this.spatialZonesEnemies[j][i].size();
                        --n4;
                        while (n4 >= 0) {
                            int n5;
                            Enemy enemy3 = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n4);
                            if (enemy3.isActive && enemy3.positionXf > Mafia.player.positionXf && (n5 = Mafia.getRangeQ(enemy3.positionXf, enemy3.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n5 < n) {
                                enemy = enemy3;
                                n = n5;
                            }
                            --n4;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        int n6 = this.spatialZonesEnemies[j][i].size();
                        --n6;
                        while (n6 >= 0) {
                            int n7;
                            Enemy enemy4 = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n6);
                            if (enemy4.isActive && enemy4.positionYf < Mafia.player.positionYf && (n7 = Mafia.getRangeQ(enemy4.positionXf, enemy4.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n7 < n) {
                                enemy = enemy4;
                                n = n7;
                            }
                            --n6;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        int n8 = this.spatialZonesEnemies[j][i].size();
                        --n8;
                        while (n8 >= 0) {
                            int n9;
                            Enemy enemy5 = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n8);
                            if (enemy5.isActive && enemy5.positionYf >= Mafia.player.positionYf && (n9 = Mafia.getRangeQ(enemy5.positionXf, enemy5.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n9 < n) {
                                enemy = enemy5;
                                n = n9;
                            }
                            --n8;
                        }
                    }
                }
                break;
            }
        }
        if (enemy != null) {
            if (enemy.damageTake(player.getDamageDeal()) && enemy.enemyType.aiType == 1) {
                this.crimeLevelIncrease(this.crimeLevelCopKillPoints, true);
            }
            this.scenarioProcessDmgEnemy(enemy);
        }
    }

    private boolean playerPunchDoDmgOnCitizens() {
        int n = player.getShootRangeQ();
        Citizen citizen = null;
        switch (Mafia.player.direction) {
            case 0: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        int n2 = this.spatialZonesCitizens[j][i].size();
                        --n2;
                        while (n2 >= 0) {
                            int n3;
                            Citizen citizen2 = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n2);
                            if (citizen2.getState() != 1 && citizen2.positionXf < Mafia.player.positionXf && (n3 = Mafia.getRangeQ(citizen2.positionXf, citizen2.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n3 < n) {
                                citizen = citizen2;
                                n = n3;
                            }
                            --n2;
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        int n4 = this.spatialZonesCitizens[j][i].size();
                        --n4;
                        while (n4 >= 0) {
                            int n5;
                            Citizen citizen3 = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n4);
                            if (citizen3.getState() != 1 && citizen3.positionXf > Mafia.player.positionXf && (n5 = Mafia.getRangeQ(citizen3.positionXf, citizen3.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n5 < n) {
                                citizen = citizen3;
                                n = n5;
                            }
                            --n4;
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        int n6 = this.spatialZonesCitizens[j][i].size();
                        --n6;
                        while (n6 >= 0) {
                            int n7;
                            Citizen citizen4 = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n6);
                            if (citizen4.getState() != 1 && citizen4.positionYf < Mafia.player.positionYf && (n7 = Mafia.getRangeQ(citizen4.positionXf, citizen4.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n7 < n) {
                                citizen = citizen4;
                                n = n7;
                            }
                            --n6;
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int i = Mafia.player.spatialZoneNearY1; i <= Mafia.player.spatialZoneNearY2; ++i) {
                    for (int j = Mafia.player.spatialZoneNearX1; j <= Mafia.player.spatialZoneNearX2; ++j) {
                        int n8 = this.spatialZonesCitizens[j][i].size();
                        --n8;
                        while (n8 >= 0) {
                            int n9;
                            Citizen citizen5 = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n8);
                            if (citizen5.getState() != 1 && citizen5.positionYf >= Mafia.player.positionYf && (n9 = Mafia.getRangeQ(citizen5.positionXf, citizen5.positionYf, Mafia.player.positionXf, Mafia.player.positionYf)) <= player.getShootRangeQ() && n9 < n) {
                                citizen = citizen5;
                                n = n9;
                            }
                            --n8;
                        }
                    }
                }
                break;
            }
        }
        if (citizen != null) {
            if (citizen.damageTake(player.getDamageDeal())) {
                this.crimeLevelIncrease(this.crimeLevelCitizenKillPoints, true);
            }
            return true;
        }
        return false;
    }

    private boolean playerDamageTake(int n) {
        this.hudBloodInit();
        if (Mafia.player.isInCar) {
            Vect vect = new Vect();
            vect.x = Util.getRandom(Mafia.player.car.carType.geometryBody[1].x, Mafia.player.car.carType.geometryBody[0].x);
            vect.y = Util.getRandom(Mafia.player.car.carType.geometryBody[2].y, Mafia.player.car.carType.geometryBody[0].y);
            vect.rotate(Mafia.player.car.bodyAngleF);
            vect.y = Mafia.player.car.perspectiveTransform(vect.y);
        }
        if (!cheatCodeImmortalFlag) {
            if (player.damageTake(n)) {
                if (Mafia.player.isInCar) {
                    Mafia.player.car.stopNow();
                    this.carExplosion((short)(Mafia.player.car.bodyAngleF >> 10));
                    this.effectFlashInit(0xFFFFFF);
                    this.cameraShakeInit(500);
                } else {
                    this.effectFlashInit(0x800000);
                }
                cameraOffsetDestXf ^= cameraOffsetDestXf;
                cameraOffsetDestYf = -2560;
                return true;
            }
            if (Mafia.player.isInCar) {
                Mafia.player.car.speedClamp();
                if (Mafia.player.car.energyPoints <= Mafia.player.car.carType.energyPoints50) {
                    // empty if block
                }
            }
        }
        return false;
    }

    private void playerCarEnterNow(boolean bl, boolean bl2) {
        if (!Mafia.player.car.isAbandoned) {
            player.statisticValueAdd(6, 1);
        }
        Mafia.player.carExitIsBlocked = bl;
        Mafia.player.car.playerCarEnter();
        Mafia.player.isVisible = false;
        Mafia.player.isInCar = true;
        Mafia.camera.posXf = Mafia.player.car.positionXf;
        Mafia.camera.posYf = Mafia.player.car.positionYf;
        cameraOffsetCurrentXf += Mafia.player.positionXf - Mafia.player.car.positionXf;
        cameraOffsetCurrentYf += Mafia.player.positionYf - Mafia.player.car.positionYf;
        cameraOffsetDestXf ^= cameraOffsetDestXf;
        cameraOffsetDestYf ^= cameraOffsetDestYf;
        this.cameraModeSet((byte)1);
        if (bl2) {
            this.rollerInit((byte)2, false);
        } else {
            this.inGameSetState((byte)2);
        }
    }

    private void playerCarEnter(boolean bl) {
        if (this.collisionTestCarVsEnvRealPos(Mafia.player.car)) {
            return;
        }
        if (Mafia.player.car.isClosed && !bl) {
            cameraOffsetDestXf ^= cameraOffsetDestXf;
            cameraOffsetDestYf = -2048;
            this.cameraModeSet((byte)3);
            this.rollerInit((byte)14, true);
        } else {
            if (!Mafia.player.car.isAbandoned) {
                this.crimeLevelIncrease(this.crimeLevelCarHijackPoints, true);
                this.citizenSpawnOnCarHijack(Mafia.player.car);
            }
            this.playerCarEnterNow(bl, false);
        }
    }

    private void playerCarExit() {
        Vect vect = new Vect();
        vect.rotate(Mafia.player.car.carType.geometryExitPoint, Mafia.player.car.getBodyAngle());
        vect.y = Mafia.player.car.perspectiveTransform(vect.y);
        vect.x += Mafia.player.car.positionXf;
        vect.y += Mafia.player.car.positionYf;
        if (vect.x < 256 || vect.x >= Map.widthTotalF - 256 || vect.y < 256 || vect.y >= Map.heightTotalF - 256 || !map.isShootPossible(Mafia.player.car.positionXf, Mafia.player.car.positionYf, vect.x, vect.y) || this.collisionTestMobVsEnv(vect.x, vect.y) || this.collisionTestMobVsCars(vect.x, vect.y)) {
            Vect vect2 = new Vect(-Mafia.player.car.carType.geometryExitPoint.x, Mafia.player.car.carType.geometryExitPoint.y);
            vect.rotate(vect2, Mafia.player.car.getBodyAngle());
            vect.y = Mafia.player.car.perspectiveTransform(vect.y);
            vect.x += Mafia.player.car.positionXf;
            vect.y += Mafia.player.car.positionYf;
            if (vect.x < 256 || vect.x >= Map.widthTotalF - 256 || vect.y < 256 || vect.y >= Map.heightTotalF - 256 || !map.isShootPossible(Mafia.player.car.positionXf, Mafia.player.car.positionYf, vect.x, vect.y) || this.collisionTestMobVsEnv(vect.x, vect.y) || this.collisionTestMobVsCars(vect.x, vect.y)) {
                return;
            }
        }
        Mafia.player.car.stateChange((byte)8);
        Mafia.player.positionXf = vect.x;
        Mafia.player.positionYf = vect.y;
        player.setDirection(Sprite.getDirectionOpposite(player.getDirectionToTarget(Mafia.player.car.positionXf, Mafia.player.car.positionYf)));
        Mafia.player.isVisible = true;
        Mafia.player.isInCar = false;
        cameraOffsetCurrentXf += Mafia.player.car.positionXf - Mafia.player.positionXf;
        cameraOffsetCurrentYf += Mafia.player.car.positionYf - Mafia.player.positionYf;
        cameraOffsetDestXf ^= cameraOffsetDestXf;
        cameraOffsetDestYf ^= cameraOffsetDestYf;
        this.inGameSetState((byte)1);
    }

    private void playerItemInInverntoryUse(byte by) {
        switch (by) {
            case 0: {
                if (player.getStatistic((byte)0) >= player.getStatistic((byte)1)) break;
                player.statisticValueAdd(0, Mafia.player.medicalHealPoints[0]);
                player.inventoryAdd(by, -1);
                break;
            }
            case 1: {
                if (player.getStatistic((byte)0) >= player.getStatistic((byte)1)) break;
                player.statisticValueAdd(0, Mafia.player.medicalHealPoints[1]);
                player.inventoryAdd(by, -1);
                break;
            }
            case 2: {
                if (player.getStatistic((byte)0) >= player.getStatistic((byte)1)) break;
                player.statisticValueAdd(0, Mafia.player.medicalHealPoints[2]);
                player.inventoryAdd(by, -1);
                break;
            }
            case 3: {
                if (player.getStatistic((byte)0) >= player.getStatistic((byte)1)) break;
                player.statisticValueAdd(0, Mafia.player.medicalHealPoints[3]);
                player.inventoryAdd(by, -1);
            }
        }
        if (player.inventoryGetAmount(by) <= 0) {
            this.shopSelectPrevItem(this.shops[shopActiveId]);
        }
        Shop cfr_ignored_0 = this.shops[shopActiveId];
        Shop.isArrowVisible = this.shopCheckArrowsVisibility(this.shops[shopActiveId]);
    }

    private void playerItemsTest() {
        int n = Mafia.player.positionXf >> 13;
        int n2 = Mafia.player.positionYf >> 13;
        for (int i = this.spatialZonesItems[n][n2].size() - 1; i >= 0; --i) {
            Item item = (Item)this.spatialZonesItems[n][n2].elementAt(i);
            if (item.positionXf >> 10 != Mafia.player.positionXf >> 10 || item.positionYf >> 10 != Mafia.player.positionYf >> 10 || !this.playerItemCollect(item.itemId)) continue;
            this.itemMessageAdd(item.positionXf, item.positionYf, Item.getItemCollectTextId(item.itemId), 1000);
            this.spatialZonesItems[n][n2].removeElement(item);
        }
    }

    private boolean playerItemCollect(byte by) {
        switch (by) {
            case 4: {
                player.statisticValueAdd(3, 10);
                this.tutorialLaunch((byte)3);
                return true;
            }
            case 5: {
                player.statisticValueAdd(3, 20);
                this.tutorialLaunch((byte)3);
                return true;
            }
            case 6: {
                player.statisticValueAdd(3, 50);
                this.tutorialLaunch((byte)3);
                return true;
            }
            case 7: {
                player.statisticValueAdd(3, 100);
                this.tutorialLaunch((byte)3);
                return true;
            }
            case 8: {
                player.statisticValueAdd(3, 200);
                this.tutorialLaunch((byte)3);
                return true;
            }
            case 9: {
                if (!player.weaponCollect((byte)1, Mafia.player.weaponInfo[1][1])) break;
                this.tutorialLaunch((byte)4);
                return true;
            }
            case 10: {
                if (!player.weaponCollect((byte)2, Mafia.player.weaponInfo[2][1])) break;
                this.tutorialLaunch((byte)4);
                return true;
            }
            case 11: {
                if (!player.weaponCollect((byte)3, Mafia.player.weaponInfo[3][1])) break;
                this.tutorialLaunch((byte)4);
                return true;
            }
            case 12: {
                this.tutorialLaunch((byte)4);
                return true;
            }
            case 0: {
                player.inventoryAdd((byte)0, 1);
                this.tutorialLaunch((byte)2);
                return true;
            }
            case 1: {
                player.inventoryAdd((byte)1, 1);
                this.tutorialLaunch((byte)2);
                return true;
            }
            case 2: {
                player.inventoryAdd((byte)2, 1);
                this.tutorialLaunch((byte)2);
                return true;
            }
            case 3: {
                player.inventoryAdd((byte)3, 1);
                this.tutorialLaunch((byte)2);
                return true;
            }
            default: {
                player.inventoryAdd(by, 1);
                return true;
            }
        }
        return false;
    }

    private void playerCarHotspotTest() {
        boolean bl = false;
        int n = Mafia.player.positionXf >> 10;
        int n2 = Mafia.player.positionYf >> 10;
        for (int i = this.hotSpots.size() - 1; i >= 0; --i) {
            HotSpot hotSpot = (HotSpot)this.hotSpots.elementAt(i);
            if (hotSpot.positionLeft > n || hotSpot.positionRight < n || hotSpot.positionUp > n2 || hotSpot.positionDown < n2 || !hotSpot.isActive) continue;
            bl = true;
            if (Mafia.player.hotSpotBlocked == hotSpot) continue;
            this.hotspotEnter(hotSpot);
            break;
        }
        if (!bl) {
            Mafia.player.hotSpotBlocked = null;
        }
    }

    private void playerHotSpotTest() {
        boolean bl = false;
        int n = Mafia.player.positionXf >> 10;
        int n2 = Mafia.player.positionYf >> 10;
        for (int i = this.hotSpots.size() - 1; i >= 0; --i) {
            HotSpot hotSpot = (HotSpot)this.hotSpots.elementAt(i);
            if (hotSpot.positionLeft > n || hotSpot.positionRight < n || hotSpot.positionUp > n2 || hotSpot.positionDown < n2 || !hotSpot.isActive) continue;
            bl = true;
            if (Mafia.player.hotSpotBlocked == hotSpot) continue;
            this.hotspotEnter(hotSpot);
            break;
        }
        if (!bl) {
            Mafia.player.hotSpotBlocked = null;
        }
    }

    private void playerShotProcess() {
        switch (Mafia.player.weapon) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (Mafia.player.weaponBulletsShooted != 0) break;
                break;
            }
        }
        if (Mafia.player.weapon != 0) {
            boolean bl;
            if (Mafia.player.weaponBulletsShooted == 0) {
                this.enemiesAggroTest();
                this.citizensPanic();
            }
            if (!(bl = Mafia.player.targetEnemy != null ? this.citizenCheckDamage(Mafia.player.targetEnemy.positionXf, Mafia.player.targetEnemy.positionYf) : this.citizenCheckDamage(Mafia.player.positionXf + (Mafia.player.crosshairPosition.x << 1), Mafia.player.positionYf + (Mafia.player.crosshairPosition.y + Mafia.player.crosshairVerticalOffsetF << 1))) && player.isTarget() && Mafia.player.targetEnemy != null) {
                if (Mafia.player.targetEnemy.damageTake(player.getDamageDeal()) && Mafia.player.targetEnemy.enemyType.aiType == 1) {
                    this.crimeLevelIncrease(this.crimeLevelCopKillPoints, true);
                }
                this.scenarioProcessDmgEnemy(Mafia.player.targetEnemy);
            }
        } else {
            this.enemiesAggroTest();
            if (!this.playerPunchDoDmgOnCitizens()) {
                this.playerPunchDoDmgOnEnemies();
            }
        }
        if (player.shotAmmoDecrease()) {
            if (Mafia.player.weaponInfo[Mafia.player.weapon][2] > 0) {
                // empty if block
            }
            player.stateChange((byte)7);
        } else {
            player.stateChange((byte)5);
        }
    }

    private boolean playerChangePosition(int n, int n2) {
        int n3 = Mat.abs(n) > Mat.abs(n2) ? Mat.abs(n) >> 8 : Mat.abs(n2) >> 8;
        int n4 = n / ++n3;
        int n5 = n2 / n3;
        for (int i = 0; i < n3; ++i) {
            Mafia.player.positionXf += n4;
            Mafia.player.positionYf += n5;
            if (!this.collisionTestMobVsEnv(Mafia.player.positionXf, Mafia.player.positionYf) && !this.collisionTestMobVsCars(Mafia.player.positionXf, Mafia.player.positionYf)) continue;
            Mafia.player.positionXf -= n4;
            Mafia.player.positionYf -= n5;
            return false;
        }
        return true;
    }

    private void playerMoveLeft(int n) {
        Mafia.player.speedCurrentYf = 0;
        Mafia.player.speedCurrentXf = -Mafia.player.speedXf;
        player.setDirection((byte)0);
        player.crosshairCalculateDestinationAngle();
        int n2 = Mafia.player.speedCurrentXf * n;
        if (Mafia.player.positionXf - 256 + n2 < 0) {
            player.stateChange((byte)0);
            return;
        }
        if (this.playerChangePosition(n2, 0)) {
            player.stateChange((byte)2);
            this.playerItemsTest();
            this.playerHotSpotTest();
        } else {
            player.stateChange((byte)0);
        }
    }

    private void playerMoveRight(int n) {
        Mafia.player.speedCurrentYf = 0;
        Mafia.player.speedCurrentXf = Mafia.player.speedXf;
        player.setDirection((byte)1);
        player.crosshairCalculateDestinationAngle();
        int n2 = Mafia.player.speedCurrentXf * n;
        if (Mafia.player.positionXf + 256 + n2 >= Map.widthTotalF) {
            player.stateChange((byte)0);
            return;
        }
        if (this.playerChangePosition(n2, 0)) {
            player.stateChange((byte)2);
            this.playerItemsTest();
            this.playerHotSpotTest();
        } else {
            player.stateChange((byte)0);
        }
    }

    private void playerMoveUp(int n) {
        Mafia.player.speedCurrentXf = 0;
        Mafia.player.speedCurrentYf = -Mafia.player.speedYf;
        player.setDirection((byte)2);
        player.crosshairCalculateDestinationAngle();
        int n2 = Mafia.player.speedCurrentYf * n;
        if (Mafia.player.positionYf - 256 + n2 < 1536) {
            player.stateChange((byte)0);
            return;
        }
        if (this.playerChangePosition(0, n2)) {
            player.stateChange((byte)2);
            this.playerItemsTest();
            this.playerHotSpotTest();
        } else {
            player.stateChange((byte)0);
        }
    }

    private void playerMoveDown(int n) {
        Mafia.player.speedCurrentXf = 0;
        Mafia.player.speedCurrentYf = Mafia.player.speedYf;
        player.setDirection((byte)3);
        player.crosshairCalculateDestinationAngle();
        int n2 = Mafia.player.speedCurrentYf * n;
        if (Mafia.player.positionYf + 256 + n2 >= Map.heightTotalF) {
            player.stateChange((byte)0);
            return;
        }
        if (this.playerChangePosition(0, n2)) {
            player.stateChange((byte)2);
            this.playerItemsTest();
            this.playerHotSpotTest();
        } else {
            player.stateChange((byte)0);
        }
    }

    private void playerControl(int n) {
        Mafia.player.speedCurrentXf = 0;
        Mafia.player.speedCurrentYf = 0;
        if (C.getAction(16)) {
            C.keyClear();
            if (player.getState() == 0 || player.getState() == 1 || player.getState() == 6) {
                Mafia.player.weaponBulletsShooted = 0;
                player.shoot();
            }
        } else if (C.getAction(64) && !Mafia.player.weaponChangeBlocked) {
            C.keyClear();
            player.weaponSwapNext();
            if (player.getState() == 6) {
                player.stateChange((byte)8);
            } else {
                player.stateChange((byte)9);
            }
        } else if (C.getAction(4)) {
            this.playerMoveLeft(n);
        } else if (C.getAction(8)) {
            this.playerMoveRight(n);
        } else if (C.getAction(1)) {
            this.playerMoveUp(n);
        } else if (C.getAction(2)) {
            this.playerMoveDown(n);
        } else if (C.getAction(4096)) {
            if (Mafia.player.car != null) {
                C.keyClear();
                this.playerCarEnter(false);
            }
        } else if (C.getAction(1024)) {
            C.keyClear();
            this.shopInit(0);
        } else if (player.getState() == 2) {
            player.stateChange((byte)0);
        }
    }

    private void playerUpdate(int n) {
        Mafia.player.controlIsBlocked = false;
        player.update(n);
        this.playerCarTargetHandler();
        switch (player.getState()) {
            case 3: {
                if (Mafia.player.stateTime > (long)Mafia.player.stateTimePrepareToShot) {
                    player.stateChange((byte)4);
                }
                player.controlBlock();
                break;
            }
            case 4: {
                this.playerShotProcess();
                player.controlBlock();
                break;
            }
            case 5: {
                if (Mafia.player.stateTime <= (long)Mafia.player.weaponInfo[Mafia.player.weapon][8]) break;
                Mafia.player.stateTime ^= Mafia.player.stateTime;
                if (Mafia.player.weaponBulletsShooted < Mafia.player.weaponInfo[Mafia.player.weapon][7]) {
                    player.stateChange((byte)4);
                    break;
                }
                player.stateChange((byte)6);
                break;
            }
            case 6: {
                if (Mafia.player.stateTime <= (long)Mafia.player.stateTimeHoldingOutWeapon) break;
                if (Mafia.player.weapon != 0 && Mafia.player.weaponInfo[Mafia.player.weapon][0] < Mafia.player.weaponInfo[Mafia.player.weapon][1] && Mafia.player.weaponInfo[Mafia.player.weapon][2] > 0) {
                    player.stateChange((byte)11);
                    break;
                }
                player.stateChange((byte)1);
                break;
            }
            case 7: {
                if (Mafia.player.weaponInfo[Mafia.player.weapon][2] > 0) {
                    while (Mafia.player.stateTime > (long)Mafia.player.weaponInfo[Mafia.player.weapon][6]) {
                        if (Mafia.player.weaponInfo[Mafia.player.weapon][2] > 0 && Mafia.player.weaponInfo[Mafia.player.weapon][0] < Mafia.player.weaponInfo[Mafia.player.weapon][1]) {
                            int[] nArray = Mafia.player.weaponInfo[Mafia.player.weapon];
                            nArray[0] = nArray[0] + 1;
                            int[] nArray2 = Mafia.player.weaponInfo[Mafia.player.weapon];
                            nArray2[2] = nArray2[2] - 1;
                            Mafia.player.stateTime -= (long)Mafia.player.weaponInfo[Mafia.player.weapon][6];
                            continue;
                        }
                        player.stateChange((byte)8);
                    }
                    break;
                }
                if (Mafia.player.weaponInfo[Mafia.player.weapon][0] == 0) {
                    player.weaponSwapBest();
                }
                player.stateChange((byte)8);
                break;
            }
            case 8: {
                if (Mafia.player.stateTime > (long)Mafia.player.stateTimeHidingWeapon) {
                    if (Mafia.player.weapon != Mafia.player.weaponNext) {
                        player.stateChange((byte)9);
                    } else {
                        player.stateChange((byte)0);
                    }
                }
                player.controlBlock();
                break;
            }
            case 9: {
                if (Mafia.player.stateTime > (long)Mafia.player.stateTimeHiddenWeaponOnSwap) {
                    Mafia.player.weapon = Mafia.player.weaponNext;
                    if (Mafia.player.weaponNext == 0) {
                        player.setTarget(null);
                    }
                    player.stateChange((byte)10);
                }
                player.controlBlock();
                break;
            }
            case 10: {
                if (Mafia.player.stateTime <= (long)Mafia.player.stateTimeShowingWeapon) break;
                player.stateChange((byte)6);
                break;
            }
            case 11: {
                if (Mafia.player.stateTime <= (long)Mafia.player.stateTimeShowingWeapon) break;
                player.stateChange((byte)7);
                break;
            }
            case 0: {
                if (Mafia.player.stateTime <= (long)Mafia.player.stateTimeReloadAfterIdle) break;
                if (Mafia.player.weapon != 0 && Mafia.player.weaponInfo[Mafia.player.weapon][0] < Mafia.player.weaponInfo[Mafia.player.weapon][1] && Mafia.player.weaponInfo[Mafia.player.weapon][2] > 0) {
                    player.stateChange((byte)11);
                    break;
                }
                player.stateChange((byte)1);
                break;
            }
            case 12: {
                if (Mafia.player.stateTime > (long)Mafia.player.stateTimeDeath) {
                    this.inGameSetState((byte)12);
                }
                player.controlBlock();
                break;
            }
        }
        if (!Mafia.player.controlIsBlocked) {
            this.playerControl(n);
        }
        this.playerTargetHandler();
        player.crosshairUpdate(n);
    }

    private boolean[] portraitsDetermineAppearance() {
        int n;
        boolean[] blArray = new boolean[2];
        for (n = 0; n < 2; ++n) {
            blArray[n] = false;
        }
        for (n = 0; n < this.conversation.length; ++n) {
            if (this.conversation[n].portraitId == null) continue;
            for (int i = 0; i < this.conversation[n].portraitId.length; ++i) {
                if (this.conversation[n].portraitId[i] < 0) continue;
                blArray[this.conversation[n].portraitId[i]] = true;
            }
        }
        for (n = 0; n < this.shops.length; ++n) {
            if (this.shops[n] == null || this.shops[n].portraitId < 0) continue;
            blArray[this.shops[n].portraitId] = true;
        }
        return blArray;
    }

    private void rainInit() {
        this.rainPositionX = new int[384];
        this.rainPositionY = new int[384];
        this.rainHeight = new int[384];
        for (int i = 0; i < 384; ++i) {
            this.rainHeight[i] = 0;
        }
        rainUpLeftCornerCurrentXf = Mafia.camera.posXf;
        rainUpLeftCornerCurrentYf = Mafia.camera.posYf;
    }

    private void rainRandom(int n) {
        int n2 = -200;
        int n3 = C.getScreenHeight() + 200;
        int n4 = -200;
        int n5 = C.getScreenWidth() + 200;
        this.rainPositionX[n] = Util.getRandom(n4, n5);
        this.rainPositionY[n] = Util.getRandom(n2, n3);
        this.rainHeight[n] = Util.getRandom(128, 360);
    }

    private void rainUpdate(int n) {
        if (rainVisible) {
            int n2 = 200 * n >> 10;
            for (int i = 0; i < 384; ++i) {
                if (this.rainHeight[i] <= 0) {
                    this.rainRandom(i);
                    continue;
                }
                int n3 = i;
                this.rainHeight[n3] = this.rainHeight[n3] - n2;
                int n4 = i;
                this.rainPositionY[n4] = this.rainPositionY[n4] + n2;
                int n5 = i;
                this.rainPositionX[n5] = this.rainPositionX[n5] - n2;
            }
        }
    }

    private void rainPaint(Graphics graphics) {
        int n = ((rainUpLeftCornerCurrentXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10) - 0;
        int n2 = ((rainUpLeftCornerCurrentYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10) - 0;
        for (int i = 0; i < 384; ++i) {
            int n3 = i;
            this.rainPositionX[n3] = this.rainPositionX[n3] + n;
            int n4 = i;
            this.rainPositionY[n4] = this.rainPositionY[n4] + n2;
            int n5 = this.rainPositionX[i];
            int n6 = this.rainPositionY[i];
            rainUpLeftCornerCurrentXf = Mafia.camera.posXf;
            rainUpLeftCornerCurrentYf = Mafia.camera.posYf;
            if (n5 < 0 || n5 > C.getScreenWidth() || n6 > C.getScreenHeight() || n6 < 0) continue;
            if (this.rainHeight[i] < 8) {
                graphics.setColor(0x86868B);
                for (int j = 0; j < 360; j += 60) {
                    int n7 = Mat.cos(j);
                    int n8 = Mat.sin(j);
                    graphics.drawLine(n5 + (n7 * 2 >> 10), n6 + (n8 * 2 >> 10), n5 + (n7 * 3 >> 10), n6 - (n8 * 3 >> 10));
                }
            } else {
                graphics.setColor(9408411);
                graphics.drawLine(n5, n6, n5 + 8, n6 - 8);
            }
            graphics.setColor(0xB4B4C4);
            graphics.drawLine(n5, n6, n5 + 1, n6 - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGame() {
        DataInputStream dataInputStream = C.rmsLoad("Game");
        try {
            levelCurrent = dataInputStream.readByte();
            this.tutorialMessages = new boolean[Cfg.TXT_ID_TUTORIAL_MESSAGES.length];
            for (int i = 0; i < this.tutorialMessages.length; ++i) {
                this.tutorialMessages[i] = dataInputStream.readBoolean();
            }
            Player2.stats[9] = dataInputStream.readInt();
            Player2.stats[10] = dataInputStream.readInt();
            Player2.stats[11] = dataInputStream.readInt();
            Player2.stats[12] = dataInputStream.readInt();
            Player2.stats[13] = dataInputStream.readInt();
            Player2.stats[14] = dataInputStream.readInt();
        }
        catch (Exception exception) {
        }
        finally {
            if (dataInputStream != null) {
                try {
                    C.rmsClose();
                    dataInputStream.close();
                    dataInputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveGame() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeByte(levelCurrent);
            for (int i = 0; i < this.tutorialMessages.length; ++i) {
                dataOutputStream.writeBoolean(this.tutorialMessages[i]);
            }
            dataOutputStream.writeInt(Player2.stats[9]);
            dataOutputStream.writeInt(Player2.stats[10]);
            dataOutputStream.writeInt(Player2.stats[11]);
            dataOutputStream.writeInt(Player2.stats[12]);
            dataOutputStream.writeInt(Player2.stats[13]);
            dataOutputStream.writeInt(Player2.stats[14]);
            C.rmsSave("Game", byteArrayOutputStream);
        }
        catch (Exception exception) {
        }
        finally {
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.close();
                    dataOutputStream = null;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void rollerInit(byte by, boolean bl) {
        rollerNextState = by;
        rollerDirectionUp = bl;
        this.inGameSetState((byte)15);
        rollerDifferenceCurrent = rollerDirectionUp ? 0 : 60;
    }

    public void rollerUpdate(int n) {
        if (rollerDirectionUp) {
            int n2 = rollerDifferenceCurrent = rollerDifferenceCurrent + (150 * n + 512 >> 10) > 60 ? 60 : rollerDifferenceCurrent + (150 * n + 512 >> 10);
            if (rollerDifferenceCurrent >= 60) {
                this.inGameSetState(rollerNextState);
            }
        } else {
            int n3 = rollerDifferenceCurrent = rollerDifferenceCurrent - (150 * n + 512 >> 10) < 0 ? 0 : rollerDifferenceCurrent - (150 * n + 512 >> 10);
            if (rollerDifferenceCurrent <= 0) {
                this.inGameSetState(rollerNextState);
            }
        }
    }

    public void rollerPaint(Graphics graphics) {
        graphics.setClip(0, 0, C.getScreenWidth(), C.getScreenHeight());
        graphics.setColor(0);
        graphics.drawRect(0, C.getScreenHeight() - rollerDifferenceCurrent, C.getScreenWidth(), C.getScreenHeight());
        graphics.fillRect(0, C.getScreenHeight() - rollerDifferenceCurrent, C.getScreenWidth(), C.getScreenHeight());
        graphics.drawRect(0, 0, C.getScreenWidth(), rollerDifferenceCurrent);
        graphics.fillRect(0, 0, C.getScreenWidth(), rollerDifferenceCurrent);
    }

    private void scenarioProcessCrimeLevelDecrased() {
        switch (levelCurrent) {
            case 3: {
                if (crimeLevelInt >= 1 || this.scenarioProgressCounter != 1) break;
                this.scenarioProgressCounter = (byte)(this.scenarioProgressCounter + 1);
                this.hotspotTriggerRelease((byte)7);
            }
        }
    }

    private void scenarioProcessCrimeLevelIncreased() {
    }

    private void scenarioProcessDmgEnemy(Enemy enemy) {
        switch (levelCurrent) {
            case 0: {
                if (enemy.enemyType.typeId != 10 || enemy.healthPoints > enemy.enemyType.healthPointsMax / 3) break;
                enemy.stateChange((byte)0);
                enemy.isActive = false;
                this.hotspotTriggerRelease((byte)15);
                break;
            }
            case 2: {
                if (enemy.enemyType.typeId != 24 || enemy.healthPoints > enemy.enemyType.healthPointsMax / 3) break;
                break;
            }
            case 8: {
                if (enemy.enemyType.typeId != 10 || enemy.healthPoints > enemy.enemyType.healthPointsMax / 3) break;
                enemy.stateChange((byte)0);
                enemy.isActive = false;
                this.hotspotTriggerRelease((byte)15);
                break;
            }
            case 13: {
                if (enemy.enemyType.typeId != 20) break;
                if (this.scenarioProgressCounter == 0) {
                    if (enemy.healthPoints > enemy.enemyType.healthPointsMax * 2 / 3) break;
                    this.scenarioProgressCounter = 1;
                    this.hotspotTriggerRelease((byte)10);
                    break;
                }
                if (this.scenarioProgressCounter != 1 || enemy.healthPoints > enemy.enemyType.healthPointsMax / 3) break;
                this.scenarioProgressCounter = (byte)2;
                this.hotspotTriggerRelease((byte)11);
                Mafia.player.weaponChangeBlocked = false;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void scenarioProcessKillEnemy(Enemy enemy) {
        switch (levelCurrent) {
            case 0: {
                switch (enemy.enemyType.typeId) {
                    case 8: {
                        if (this.enemiesGetCount(enemy.enemyType) != 1) return;
                        this.hotspotTriggerRelease((byte)8);
                    }
                }
                return;
            }
            case 1: {
                switch (enemy.enemyType.typeId) {
                    case 4: {
                        if (this.enemiesGetCount(enemy.enemyType) != 1) break;
                        this.hotspotActivate((byte)2);
                        return;
                    }
                    case 11: {
                        if (this.enemiesGetCount(enemy.enemyType) != 1) break;
                        this.hotspotTriggerRelease((byte)14);
                    }
                }
                return;
            }
            case 2: {
                switch (enemy.enemyType.typeId) {
                    case 0: {
                        if (this.enemiesGetCount(this.enemyTypes[7]) != 0 || this.enemiesGetCount(this.enemyTypes[24]) != 0 || this.enemiesGetCount(this.enemyTypes[0]) != 1) break;
                        this.hotspotTriggerRelease((byte)6);
                        return;
                    }
                    case 7: {
                        if (this.enemiesGetCount(this.enemyTypes[0]) != 0 || this.enemiesGetCount(this.enemyTypes[24]) != 0) break;
                        this.hotspotTriggerRelease((byte)6);
                        return;
                    }
                    case 4: {
                        if (this.enemiesGetCount(enemy.enemyType) != 1) break;
                        this.hotspotTriggerRelease((byte)9);
                        return;
                    }
                    case 12: {
                        if (this.enemiesGetCount(enemy.enemyType) != 1) break;
                        this.hotspotTriggerRelease((byte)24);
                        return;
                    }
                    case 24: {
                        int n = enemy.positionXf;
                        int n2 = enemy.positionYf - 1024;
                        this.effectFlashInit(0xFFFFFF);
                        this.cameraShakeInit(500);
                        n >>= 10;
                        n2 >>= 10;
                        for (int i = this.cars.size() - 1; i >= 0; --i) {
                            Car car = (Car)this.cars.elementAt(i);
                            if (car.positionXf >> 10 != n || car.positionYf >> 10 != n2) continue;
                            car.stateChange((byte)11);
                            break;
                        }
                        if (this.enemiesGetCount(this.enemyTypes[7]) != 0 || this.enemiesGetCount(this.enemyTypes[24]) != 1 || this.enemiesGetCount(this.enemyTypes[0]) != 0) break;
                        this.hotspotTriggerRelease((byte)6);
                    }
                }
                return;
            }
            case 3: {
                switch (enemy.enemyType.typeId) {
                    case 0: {
                        if (this.enemiesGetCount(this.enemyTypes[0]) != 1) break;
                        this.hotspotTriggerRelease((byte)2);
                        return;
                    }
                    case 12: {
                        if (this.enemiesGetCount(this.enemyTypes[12]) != 1) break;
                        this.hotspotTriggerRelease((byte)3);
                        return;
                    }
                    case 13: {
                        if (this.enemiesGetCount(this.enemyTypes[13]) != 1) break;
                        this.scenarioProgressCounter = 1;
                        this.hotspotTriggerRelease((byte)5);
                    }
                }
                return;
            }
            case 4: {
                switch (enemy.enemyType.typeId) {
                    case 4: {
                        if (this.enemiesGetCount(this.enemyTypes[4]) != 1) return;
                        this.hotspotActivate((byte)28);
                    }
                }
                return;
            }
            case 5: {
                switch (enemy.enemyType.typeId) {
                    case 15: {
                        if (this.enemiesGetCount(this.enemyTypes[15]) != 1) return;
                        this.hotspotActivate((byte)25);
                    }
                }
                return;
            }
            case 9: {
                switch (enemy.enemyType.typeId) {
                    case 17: {
                        if (this.enemiesGetCount(this.enemyTypes[17]) != 1) break;
                        this.hotspotActivate((byte)4);
                        return;
                    }
                    case 18: {
                        if (this.enemiesGetCount(this.enemyTypes[18]) != 1) break;
                        this.hotspotActivate((byte)6);
                        return;
                    }
                    case 19: {
                        if (this.enemiesGetCount(this.enemyTypes[19]) != 1) break;
                        this.hotspotTriggerRelease((byte)8);
                    }
                }
                return;
            }
            case 12: {
                switch (enemy.enemyType.typeId) {
                    case 7: {
                        if (this.enemiesGetCount(this.enemyTypes[7]) != 1) return;
                        this.hotspotActivate((byte)35);
                    }
                }
                return;
            }
            case 13: {
                switch (enemy.enemyType.typeId) {
                    case 21: {
                        if (this.enemiesGetCount(this.enemyTypes[21]) != 1) return;
                        this.hotspotTriggerRelease((byte)16);
                    }
                }
                return;
            }
            case 14: {
                switch (enemy.enemyType.typeId) {
                    case 22: {
                        if (this.enemiesGetCount(this.enemyTypes[22]) != 1) return;
                        inGameState = inGameStatePrevious;
                        this.hotspotTriggerRelease((byte)9);
                        Mafia.player.weapon = sniperPlayerPreviousWeapon;
                    }
                }
            }
        }
    }

    private void scenarioEventStart(byte by) {
        block0 : switch (levelCurrent) {
            case 3: {
                switch (by) {
                    case 0: {
                        Mafia.player.carExitIsBlocked = true;
                    }
                }
                break;
            }
            case 4: {
                block13 : switch (by) {
                    case 0: {
                        int n;
                        int n2;
                        Trigger trigger;
                        int n3 = 0;
                        do {
                            trigger = Map.layerTriggersSpawn.getTriggerByType(6, n3);
                            ++n3;
                        } while (trigger != null && trigger.params[0] != 1);
                        if (trigger != null) {
                            n2 = (trigger.posX << 10) + 512;
                            n = (trigger.posY << 10) + 512;
                        } else {
                            n2 = Mafia.player.positionXf;
                            n = Mafia.player.positionYf;
                        }
                        this.effectFlashInit(0xFFFFFF);
                        this.cameraShakeInit(500);
                        int n4 = 3072;
                        n4 *= n4;
                        if ((n4 >>= 10) < Mafia.getRangeQ(Mafia.player.positionXf, Mafia.player.positionYf, n2, n)) break;
                        this.playerDamageTake(1000);
                        break;
                    }
                    case 1: {
                        CarType carType = this.carTypes[4];
                        for (int i = this.cars.size() - 1; i >= 0; --i) {
                            Car car = (Car)this.cars.elementAt(i);
                            if (car.carType != carType) continue;
                            car.stateChange((byte)-2);
                            break block13;
                        }
                        break;
                    }
                }
                break;
            }
            case 7: {
                block17 : switch (by) {
                    case 0: {
                        for (int i = 0; i < this.cars.size(); ++i) {
                            if (((Car)this.cars.elementAt((int)i)).carType != this.carTypes[3]) continue;
                            Mafia.player.car = (Car)this.cars.elementAt(i);
                            this.playerCarEnter(true);
                            break block17;
                        }
                        break;
                    }
                }
                break;
            }
            case 11: {
                switch (by) {
                    case 0: {
                        this.effectFlashInit(0xFFFFFF);
                        this.cameraShakeInit(1500);
                        break;
                    }
                    case 1: {
                        this.playerDamageTake(1000);
                    }
                }
                break;
            }
            case 12: {
                switch (by) {
                    case 1: {
                        cameraOffsetDestXf = cameraLookAtOffsetXf;
                        cameraOffsetDestYf = cameraLookAtOffsetYf;
                        cameraMode = (byte)4;
                        cameraLookAtTime = 4000;
                        camerTriggerFinalizeActivateId = (byte)-1;
                        cameraTriggerFinalizeReleaseId = (byte)18;
                        this.effectFlashInit(0xFFFFFF);
                        this.cameraShakeInit(1000);
                        break;
                    }
                    case 0: {
                        this.enemiesStateChange((byte)5, (byte)11);
                    }
                }
                break;
            }
            case 13: {
                switch (by) {
                    case 0: {
                        Mafia.player.weaponNext = 0;
                        if (player.getState() == 6) {
                            player.stateChange((byte)8);
                        } else {
                            player.stateChange((byte)9);
                        }
                        Mafia.player.weaponChangeBlocked = true;
                    }
                }
                break;
            }
            case 14: {
                switch (by) {
                    case 0: {
                        this.scenarioProgressCounter = 1;
                        this.hotspotTriggerRelease((byte)18);
                    }
                }
                break;
            }
            case 17: {
                switch (by) {
                    case 0: {
                        this.epilogCitizen.setDirection((byte)3);
                        this.epilogCitizen.stateChange((byte)5);
                        epilogState = (byte)(epilogState + 1);
                        break block0;
                    }
                    case 1: {
                        Mafia.player.car = this.epilogCar;
                        Mafia.player.car.isVisible = true;
                        epilogState = (byte)(epilogState + 1);
                        this.cameraModeSet((byte)3);
                        cameraOffsetDestXf = 0;
                        cameraOffsetCurrentXf = cameraCurrentPositionXf - Mafia.player.car.positionXf;
                        cameraCurrentPositionXf = Mafia.player.car.positionXf;
                        cameraOffsetDestYf = 0;
                        cameraOffsetCurrentYf = cameraCurrentPositionYf - Mafia.player.car.positionYf;
                        cameraCurrentPositionYf = Mafia.player.car.positionYf;
                        break block0;
                    }
                    case 3: {
                        cameraOffsetDestXf = 0;
                        cameraOffsetCurrentXf = cameraCurrentPositionXf - Mafia.player.positionXf;
                        cameraCurrentPositionXf = Mafia.player.positionXf;
                        cameraOffsetDestYf = 0;
                        cameraOffsetCurrentYf = cameraCurrentPositionYf - Mafia.player.positionYf;
                        cameraCurrentPositionYf = Mafia.player.positionYf;
                        epilogState = (byte)(epilogState + 1);
                    }
                }
            }
        }
    }

    private void shopsSettingsLoad(boolean[] blArray) {
        block11: {
            this.shops = new Shop[10];
            for (int i = 0; i < this.shops.length; ++i) {
                this.shops[i] = blArray[i] ? new Shop() : null;
            }
            FilterInputStream filterInputStream = null;
            try {
                filterInputStream = new DataInputStream(midlet.getClass().getResourceAsStream("Shops.sse"));
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readChar();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readByte();
                int n = ((DataInputStream)filterInputStream).readShort();
                short s = ((DataInputStream)filterInputStream).readShort();
                int n2 = ((DataInputStream)filterInputStream).readShort();
                for (int i = 0; i < n2; ++i) {
                    if (blArray[i]) {
                        this.shops[i].inferiorGraphicsId = (byte)((DataInputStream)filterInputStream).readShort();
                        this.shops[i].portraitId = (byte)((DataInputStream)filterInputStream).readShort();
                        this.shops[i].upperTextId = ((DataInputStream)filterInputStream).readShort();
                        this.shops[i].colourSchemeId = (byte)((DataInputStream)filterInputStream).readShort();
                        this.shops[i].inventoryOverlapId = (byte)((DataInputStream)filterInputStream).readShort();
                        continue;
                    }
                    ((DataInputStream)filterInputStream).skipBytes(s << 1);
                }
                for (int i = 1; i < n; ++i) {
                    int n3;
                    s = ((DataInputStream)filterInputStream).readShort();
                    n2 = ((DataInputStream)filterInputStream).readShort();
                    byte[] byArray = new byte[n2];
                    short[] sArray = new short[n2];
                    short[] sArray2 = new short[n2];
                    for (n3 = 0; n3 < n2; ++n3) {
                        byArray[n3] = (byte)((DataInputStream)filterInputStream).readShort();
                        sArray[n3] = ((DataInputStream)filterInputStream).readShort();
                        sArray2[n3] = ((DataInputStream)filterInputStream).readShort();
                    }
                    for (n3 = 0; n3 < this.shops.length; ++n3) {
                        if (this.shops[n3] == null || this.shops[n3].inventoryOverlapId != i) continue;
                        this.shops[n3].itemId = new byte[n2];
                        this.shops[n3].textId = new short[n2];
                        this.shops[n3].price = new short[n2];
                        for (int j = 0; j < n2; ++j) {
                            this.shops[n3].itemId[j] = byArray[j];
                            this.shops[n3].textId[j] = sArray[j];
                            this.shops[n3].price[j] = sArray2[j];
                        }
                    }
                }
                filterInputStream.close();
            }
            catch (Exception exception) {
                if (filterInputStream == null) break block11;
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean[] shopsDetermineAppearance() {
        Trigger trigger;
        int n = 0;
        boolean[] blArray = new boolean[10];
        while ((trigger = Map.layerTriggersHotSpots.getTrigger(n)) != null) {
            if (trigger.type == 2) {
                blArray[trigger.params[8]] = true;
            }
            ++n;
        }
        blArray[0] = true;
        return blArray;
    }

    private void shopInit(int n) {
        player.stateChange((byte)0);
        shopActiveId = n;
        textBox = null;
        Shop.upperLabelHeight = 0;
        if (this.shops[Mafia.shopActiveId].upperTextId >= 0) {
            Shop.upperLabelHeight = (short)(Application.font.getFontHeight() + 20);
        }
        if (this.shops[Mafia.shopActiveId].portraitId >= 0 && portraitsAnimation.getFrameHeight(this.shops[Mafia.shopActiveId].portraitId, 0) + 2 > Shop.upperLabelHeight) {
            Shop.upperLabelHeight = (short)portraitsAnimation.getFrameHeight(this.shops[Mafia.shopActiveId].portraitId, 0);
            Shop.upperLabelHeight = (short)(Shop.upperLabelHeight + 2);
        }
        if (this.shops[Mafia.shopActiveId].inferiorGraphicsId >= 0 && 64 + Shop.upperLabelHeight + 2 > Shop.upperLabelHeight) {
            Shop.upperLabelHeight = (short)64;
            Shop.upperLabelHeight = (short)(Shop.upperLabelHeight + 2);
        }
        Shop.itemSelected = 0;
        Shop.itemFirstVisible = 0;
        if (n == 0 && player.inventoryGetAmount(this.shops[n].itemId[Shop.itemSelected]) <= 0) {
            this.shopSelectNextItem(this.shops[n]);
        }
        Shop cfr_ignored_0 = this.shops[shopActiveId];
        Shop.isArrowVisible = this.shopCheckArrowsVisibility(this.shops[shopActiveId]);
        this.transitionStart((byte)7, false);
    }

    private boolean shopCheckArrowsVisibility(Shop shop) {
        int n = Shop.upperLabelHeight + 6 + 0;
        int n2 = C.getScreenHeight() - 28 - 0;
        int n3 = 0;
        int n4 = n + 40;
        for (int i = 0; i < shop.itemId.length; ++i) {
            if (shopActiveId == 0 && player.inventoryGetAmount(shop.itemId[i]) <= 0) continue;
            if ((n4 += 40) > n2 && i < Shop.itemSelected) break;
            ++n3;
        }
        return n + n3 * 40 > n2;
    }

    private void shopBuyItem(byte by) {
        if (player.getStatistic((byte)3) >= this.shops[Mafia.shopActiveId].price[by]) {
            int n = 1;
            int n2 = -1;
            switch (this.shops[Mafia.shopActiveId].itemId[by]) {
                case 13: 
                case 14: {
                    n2 = 1;
                    break;
                }
                case 9: {
                    n = Mafia.player.weaponInfo[1][1];
                    n2 = n + Mafia.player.weaponInfo[1][3];
                    break;
                }
                case 10: {
                    n = Mafia.player.weaponInfo[2][1];
                    n2 = n + Mafia.player.weaponInfo[2][3];
                    break;
                }
                case 11: {
                    n = Mafia.player.weaponInfo[3][1];
                    n2 = n + Mafia.player.weaponInfo[3][3];
                    break;
                }
                case 12: {
                    n = Mafia.player.weaponInfo[4][1];
                    n2 = n + Mafia.player.weaponInfo[4][3];
                }
            }
            if (n2 == -1 || player.inventoryGetAmount(this.shops[Mafia.shopActiveId].itemId[by]) < n2) {
                player.inventoryAdd(this.shops[Mafia.shopActiveId].itemId[by], n);
                player.statisticValueAdd(3, -this.shops[Mafia.shopActiveId].price[by]);
            } else {
                this.messageInit(this.txt.getText(87), this.txt, false, false, false, -1, -1);
            }
        } else {
            this.messageInit(this.txt.getText(39), this.txt, false, false, false, -1, -1);
        }
        Shop cfr_ignored_0 = this.shops[shopActiveId];
        Shop.isArrowVisible = this.shopCheckArrowsVisibility(this.shops[shopActiveId]);
    }

    private void shopUpdate(int n) {
        if (C.getAction(1024)) {
            C.keyClear();
            if (shopActiveId == 0) {
                this.transitionStart((byte)1, false);
            }
        }
        if (C.getAction(128)) {
            C.keyClear();
            if (shopActiveId != 0) {
                this.hotspotTriggerFinalize();
            }
            this.transitionStart((byte)1, false);
        } else if (C.getAction(2)) {
            this.shopSelectNextItem(this.shops[shopActiveId]);
            C.keyClear();
        } else if (C.getAction(1)) {
            this.shopSelectPrevItem(this.shops[shopActiveId]);
            C.keyClear();
        } else if ((C.getAction(16) || C.getAction(64)) && Shop.itemSelected >= 0) {
            C.keyClear();
            if (shopActiveId != 0) {
                this.shopBuyItem(Shop.itemSelected);
            } else {
                this.playerItemInInverntoryUse(this.shops[Mafia.shopActiveId].itemId[Shop.itemSelected]);
            }
        }
    }

    private void shopSelectPrevItem(Shop shop) {
        if (shopActiveId == 0) {
            byte by = -1;
            for (byte by2 = shop.itemId.length - 1; by2 >= 0; --by2) {
                if (player.inventoryGetAmount(shop.itemId[by2]) <= 0) continue;
                by = by2;
                if (by2 < Shop.itemSelected) break;
            }
            Shop.itemSelected = by;
        } else if ((Shop.itemSelected = (byte)(Shop.itemSelected - 1)) < 0) {
            Shop.itemSelected = (byte)(Shop.itemSelected + 1);
        }
    }

    private void shopSelectNextItem(Shop shop) {
        if (shopActiveId == 0) {
            byte by = -1;
            for (byte by2 = 0; by2 < shop.itemId.length; ++by2) {
                if (player.inventoryGetAmount(shop.itemId[by2]) <= 0) continue;
                by = by2;
                if (by2 > Shop.itemSelected) break;
            }
            Shop.itemSelected = by;
        } else if ((Shop.itemSelected = (byte)(Shop.itemSelected + 1)) >= shop.itemId.length) {
            Shop.itemSelected = (byte)(Shop.itemSelected - 1);
        }
    }

    private void shopPaint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        Shop shop = this.shops[shopActiveId];
        graphics.setColor(0);
        graphics.fillRect(0, 0, C.getScreenWidth(), C.getScreenHeight());
        if (shop.portraitId >= 0) {
            portraitsAnimation.drawFrame(graphics, shop.portraitId, 0, 2, 2, 0);
        }
        if (shop.upperTextId >= 0) {
            if (shop.portraitId >= 0) {
                this.txt.drawText(graphics, shop.upperTextId, portraitsAnimation.getFrameWidth(shop.portraitId, 0) + 10, Shop.upperLabelHeight - 10, 36);
            } else {
                this.txt.drawText(graphics, shop.upperTextId, C.getScreenWidth() >> 1, Shop.upperLabelHeight - 10, 33);
            }
        }
        graphics.setColor(Cfg.SHOP_COLOUR_SCHEMES[shop.colourSchemeId][0]);
        graphics.fillRect(6, Shop.upperLabelHeight + 6, C.getScreenWidth() - 12, C.getScreenHeight() - Shop.upperLabelHeight - 6 - 28);
        int n4 = hudAnimation.getFrameWidth(3, 0);
        for (n3 = 6 + n4; n3 < C.getScreenWidth() - n4; n3 += n4) {
            hudAnimation.drawFrame(graphics, 4, 0, n3, Shop.upperLabelHeight + 6, 0);
            hudAnimation.drawFrame(graphics, 5, 0, n3, C.getScreenHeight() - 28, 0);
        }
        n4 = hudAnimation.getFrameHeight(3, 0);
        for (n3 = Shop.upperLabelHeight + 6 + n4; n3 < C.getScreenHeight() - 28; n3 += n4) {
            hudAnimation.drawFrame(graphics, 6, 0, 6, n3, 0);
            hudAnimation.drawFrame(graphics, 7, 0, C.getScreenWidth() - 6, n3, 0);
        }
        hudAnimation.drawFrame(graphics, 0, 0, 6, Shop.upperLabelHeight + 6, 0);
        hudAnimation.drawFrame(graphics, 1, 0, C.getScreenWidth() - 6, Shop.upperLabelHeight + 6, 0);
        hudAnimation.drawFrame(graphics, 2, 0, 6, C.getScreenHeight() - 28, 0);
        hudAnimation.drawFrame(graphics, 3, 0, C.getScreenWidth() - 6, C.getScreenHeight() - 28, 0);
        n3 = Shop.upperLabelHeight + 6 + 0;
        int n5 = C.getScreenHeight() - 28 - 0;
        int n6 = 0;
        if (Shop.itemSelected >= 0) {
            if (Shop.itemSelected < Shop.itemFirstVisible) {
                Shop.itemFirstVisible = Shop.itemSelected;
            }
            n2 = n3 + 40;
            for (n = Shop.itemFirstVisible; n < shop.itemId.length; ++n) {
                if ((shopActiveId != 0 || player.inventoryGetAmount(shop.itemId[n]) > 0) && (n2 += 40) > n5 && n < Shop.itemSelected) {
                    Shop.itemFirstVisible = (byte)(Shop.itemSelected - n6);
                    break;
                }
                ++n6;
            }
        }
        for (n2 = Shop.itemFirstVisible; n2 < shop.itemId.length && n3 + 40 <= n5; ++n2) {
            int n7;
            if (shopActiveId == 0 && player.inventoryGetAmount(shop.itemId[n2]) <= 0) continue;
            if (Shop.itemSelected == n2) {
                graphics.setColor(Cfg.SHOP_COLOUR_SCHEMES[shop.colourSchemeId][1]);
                graphics.fillRect(6, n3, C.getScreenWidth() - 12, 40);
            }
            this.sprites[1].drawFrame(graphics, 0, animationGlobalCounter, 32, n3 + 20, 0);
            if (Shop.itemSelected == n2) {
                this.sprites[1].drawFrame(graphics, Item.getItemSequence(shop.itemId[n2]), animationGlobalCounter, 32, n3 + 20, 0);
            } else {
                this.sprites[1].drawFrame(graphics, Item.getItemSequence(shop.itemId[n2]), 0, 32, n3 + 20, 0);
            }
            this.txt.drawText(graphics, shop.textId[n2], 60, n3 + 20, 6);
            n = 0;
            if (shopActiveId == 0) {
                Mafia.hudTxtBuffer[n++] = 120;
                Mafia.hudTxtBuffer[n++] = 32;
                n7 = player.inventoryGetAmount(shop.itemId[n2]);
            } else {
                Mafia.hudTxtBuffer[n++] = 36;
                Mafia.hudTxtBuffer[n++] = 32;
                n7 = shop.price[n2];
            }
            if (n7 > 9999) {
                n7 = 9999;
            }
            boolean bl = true;
            for (int i = 1000; i > 0; i /= 10) {
                int n8 = n7 / i;
                n7 -= n8 * i;
                if (n8 == 0 && bl) continue;
                Mafia.hudTxtBuffer[n++] = (char)(48 + n8);
                bl = false;
            }
            this.txt.drawText(graphics, hudTxtBuffer, n, C.getScreenWidth() - 20, n3 + 20, 10);
            n3 += 40;
        }
        if (shopActiveId == 0) {
            n2 = portraitsAnimation.getFrameWidth(shop.portraitId, 0) + 20;
            hudAnimation.drawFrame(graphics, 26, 0, n2, 18, 0);
            graphics.setClip(n2, 0, player.getStatistic((byte)0) * 79 / player.getStatistic((byte)1), C.getScreenHeight());
            hudAnimation.drawFrame(graphics, 27, 0, n2, 18, 0);
            graphics.setClip(0, 0, C.getScreenWidth(), C.getScreenHeight());
            this.hudCashInInventoryPaint(graphics, portraitsAnimation.getFrameWidth(shop.portraitId, 0) + 14, 45);
        } else {
            this.hudCashPaint(graphics);
        }
        if (Shop.isArrowVisible) {
            int n9 = C.getScreenWidth() >> 1;
            int n10 = C.getScreenHeight();
            Application.getSingleton();
            hudAnimation.drawFrame(graphics, 48, animationGlobalCounter, n9, n10 - (Application.softs.getFrameHeight(0, 0) >> 1) - 2, 0);
        }
        Application.getSingleton().softs_Paint(graphics, 0, 1);
    }

    private void sniperSetState(byte by) {
        sniperState = by;
    }

    private void sniperInit(int n, int n2, int n3, int n4) {
        this.inGameSetState((byte)5);
        this.sniperSetState((byte)0);
        sniperPlayerPreviousWeapon = Mafia.player.weapon;
        Mafia.player.weapon = (byte)4;
        Mafia.player.weaponInfo[Mafia.player.weapon][0] = 5;
        sniperSpeedCurrentXf = 0;
        sniperSpeedCurrentYf = 0;
        sniperOscillationCurrentTimeMS = 0;
        sniperAreaLeftUpCornerPosX = n;
        sniperAreaLeftUpCornerPosY = n2;
        sniperAreaWidth = n3;
        sniperAreaHeight = n4;
        sniperCurrentPositionXf = (sniperAreaLeftUpCornerPosX + (sniperAreaWidth >> 1) << 10) + 512;
        sniperCurrentPositionYf = (sniperAreaLeftUpCornerPosY + (sniperAreaHeight >> 1) << 10) + 512;
        this.cameraModeSet((byte)2);
    }

    private void sniperUpdate(int n) {
        if (C.getAction(64) || Mafia.player.weaponInfo[Mafia.player.weapon][0] <= 0 && Mafia.player.weaponInfo[Mafia.player.weapon][2] <= 0) {
            Mafia.player.weapon = sniperPlayerPreviousWeapon;
            this.inGameSetState(inGameStatePrevious);
            this.hotspotTriggerFinalize();
        } else {
            int n2;
            int n3;
            int n4;
            if (sniperState == 2 || sniperState == 3) {
                sniperSpeedCurrentXf = 0;
                sniperSpeedCurrentYf = 0;
            } else if (C.getAction(4)) {
                sniperSpeedCurrentXf = sniperSpeedCurrentXf - (1000 * n >> 10) < -3000 ? -3000 : sniperSpeedCurrentXf - (1000 * n >> 10);
            } else if (C.getAction(1)) {
                sniperSpeedCurrentYf = sniperSpeedCurrentYf - (1000 * n >> 10) < -3000 ? -3000 : sniperSpeedCurrentYf - (1000 * n >> 10);
            } else if (C.getAction(8)) {
                sniperSpeedCurrentXf = sniperSpeedCurrentXf + (1000 * n >> 10) > 3000 ? 3000 : sniperSpeedCurrentXf + (1000 * n >> 10);
            } else if (C.getAction(2)) {
                sniperSpeedCurrentYf = sniperSpeedCurrentYf + (1000 * n >> 10) > 3000 ? 3000 : sniperSpeedCurrentYf + (1000 * n >> 10);
            } else {
                if (sniperSpeedCurrentYf > 0) {
                    sniperSpeedCurrentYf = sniperSpeedCurrentYf - (1000 * n >> 10) < 0 ? 0 : sniperSpeedCurrentYf - (1000 * n >> 10);
                } else if (sniperSpeedCurrentYf < 0) {
                    int n5 = sniperSpeedCurrentYf = sniperSpeedCurrentYf + (1000 * n >> 10) > 0 ? 0 : sniperSpeedCurrentYf + (1000 * n >> 10);
                }
                if (sniperSpeedCurrentXf > 0) {
                    sniperSpeedCurrentXf = sniperSpeedCurrentXf - (1000 * n >> 10) < 0 ? 0 : sniperSpeedCurrentXf - (1000 * n >> 10);
                } else if (sniperSpeedCurrentXf < 0) {
                    sniperSpeedCurrentXf = sniperSpeedCurrentXf + (1000 * n >> 10) > 0 ? 0 : sniperSpeedCurrentXf + (1000 * n >> 10);
                }
            }
            sniperCurrentPositionXf += sniperSpeedCurrentXf;
            sniperCurrentPositionYf += sniperSpeedCurrentYf;
            if (sniperOscillationCurrentTimeMS > 300) {
                sniperOscillationSpeedX = Util.getRandom(-1500, 1500);
                sniperOscillationSpeedY = Util.getRandom(-1500, 1500);
                sniperOscillationCurrentTimeMS = 0;
            } else {
                sniperOscillationCurrentTimeMS += n;
                sniperCurrentPositionXf += sniperOscillationSpeedX * n >> 10;
                sniperCurrentPositionYf += sniperOscillationSpeedY * n >> 10;
            }
            if (sniperCurrentPositionXf > (sniperAreaLeftUpCornerPosX + sniperAreaWidth << 10) + 512) {
                sniperCurrentPositionXf = (sniperAreaLeftUpCornerPosX + sniperAreaWidth << 10) + 512;
                sniperSpeedCurrentXf = 0;
            } else if (sniperCurrentPositionXf < (sniperAreaLeftUpCornerPosX << 10) + 512) {
                sniperCurrentPositionXf = (sniperAreaLeftUpCornerPosX << 10) + 512;
                sniperSpeedCurrentXf = 0;
            }
            if (sniperCurrentPositionYf > (sniperAreaLeftUpCornerPosY + sniperAreaHeight << 10) + 512) {
                sniperCurrentPositionYf = (sniperAreaLeftUpCornerPosY + sniperAreaHeight << 10) + 512;
                sniperSpeedCurrentYf = 0;
            } else if (sniperCurrentPositionYf < (sniperAreaLeftUpCornerPosY << 10) + 512) {
                sniperCurrentPositionYf = (sniperAreaLeftUpCornerPosY << 10) + 512;
                sniperSpeedCurrentYf = 0;
            }
            Enemy enemy = null;
            if (sniperState != 2 && sniperState != 3) {
                this.spatialZonesCalcNear(sniperCurrentPositionXf, sniperCurrentPositionYf);
                this.sniperSetState((byte)0);
                for (n4 = this.spatialZoneNearY1; n4 <= this.spatialZoneNearY2; ++n4) {
                    block7: for (n3 = this.spatialZoneNearX1; n3 <= this.spatialZoneNearX2; ++n3) {
                        for (n2 = 0; n2 < this.spatialZonesEnemies[n3][n4].size(); ++n2) {
                            enemy = (Enemy)this.spatialZonesEnemies[n3][n4].elementAt(n2);
                            if (enemy.positionXf < sniperCurrentPositionXf - 1024 || enemy.positionXf > sniperCurrentPositionXf + 1024 || sniperCurrentPositionYf < enemy.positionYf - 2048 || sniperCurrentPositionYf > enemy.positionYf) continue;
                            this.sniperSetState((byte)1);
                            continue block7;
                        }
                    }
                }
            }
            switch (sniperState) {
                case 0: {
                    if (!C.getAction(16)) break;
                    for (n4 = this.spatialZoneNearY1; n4 <= this.spatialZoneNearY2; ++n4) {
                        for (n3 = this.spatialZoneNearX1; n3 <= this.spatialZoneNearX2; ++n3) {
                            for (n2 = 0; n2 < this.spatialZonesCitizens[n3][n4].size(); ++n2) {
                                Citizen citizen = (Citizen)this.spatialZonesCitizens[n3][n4].elementAt(n2);
                                if (citizen.positionXf < sniperCurrentPositionXf - 1024 || citizen.positionXf > sniperCurrentPositionXf + 1024 || citizen.positionYf < sniperCurrentPositionYf - 1024 || citizen.positionYf > sniperCurrentPositionYf + 1024) continue;
                                citizen.damageTake(1000);
                            }
                        }
                    }
                    player.shotAmmoDecrease();
                    sniperState = 2;
                    sniperShootMaxHeight = sniperCurrentPositionYf - 600 < (sniperAreaLeftUpCornerPosY << 10) + 512 ? (sniperAreaLeftUpCornerPosY << 10) + 512 : sniperCurrentPositionYf - 600;
                    sniperShootBeginHeight = sniperCurrentPositionYf;
                    C.keyClear();
                    break;
                }
                case 1: {
                    if (!C.getAction(16)) break;
                    if (enemy != null) {
                        enemy.damageTake(1000);
                    }
                    player.shotAmmoDecrease();
                    sniperState = 2;
                    sniperShootMaxHeight = sniperCurrentPositionYf - 600 < (sniperAreaLeftUpCornerPosY << 10) + 512 ? (sniperAreaLeftUpCornerPosY << 10) + 512 : sniperCurrentPositionYf - 600;
                    sniperShootBeginHeight = sniperCurrentPositionYf;
                    C.keyClear();
                    break;
                }
                case 2: {
                    int n6 = sniperCurrentPositionYf = sniperCurrentPositionYf - (15000 * n >> 10) < sniperShootMaxHeight ? sniperShootMaxHeight : sniperCurrentPositionYf - (15000 * n >> 10);
                    if (sniperCurrentPositionYf > sniperShootMaxHeight) break;
                    sniperState = 3;
                    break;
                }
                case 3: {
                    int n7 = sniperCurrentPositionYf = sniperCurrentPositionYf + (3000 * n >> 10) > sniperShootBeginHeight ? sniperShootBeginHeight : sniperCurrentPositionYf + (3000 * n >> 10);
                    if (sniperCurrentPositionYf < sniperShootBeginHeight) break;
                    sniperState = 0;
                }
            }
        }
    }

    private void sniperPaint(Graphics graphics) {
        this.worldPaint(graphics);
        int n = (sniperCurrentPositionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10;
        int n2 = (sniperCurrentPositionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10;
        switch (sniperState) {
            case 0: 
            case 2: 
            case 3: {
                graphics.setColor(0);
                graphics.drawLine((C.getScreenWidth() >> 1) - 10, C.getScreenHeight() >> 1, (C.getScreenWidth() >> 1) + 10, C.getScreenHeight() >> 1);
                graphics.drawLine(C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) - 10, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) + 10);
                break;
            }
            case 1: {
                graphics.setColor(0xFF0000);
                graphics.drawLine((C.getScreenWidth() >> 1) - 10, C.getScreenHeight() >> 1, (C.getScreenWidth() >> 1) + 10, C.getScreenHeight() >> 1);
                graphics.drawLine(C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) - 10, C.getScreenWidth() >> 1, (C.getScreenHeight() >> 1) + 10);
            }
        }
    }

    private void soundInit() {
        this.soundPlayTimes = new long[13];
        for (int i = 0; i < this.soundPlayTimes.length; ++i) {
            this.soundPlayTimes[i] = 0L;
        }
    }

    private void soundPlayMusic() {
        if (!Sound.getSingleton().isPlaying(1)) {
            Sound.getSingleton().dispose();
            Application.loadSounds();
            Sound.getSingleton().play(1, Application.getSingleton().settingsMusicVolumeCurrent, true);
        }
    }

    private int soundPlayingAtmNumber() {
        int n = 0;
        long l = System.currentTimeMillis();
        for (int i = this.soundPlayTimes.length - 1; i >= 0; --i) {
            if (this.soundPlayTimes[i] + (long)Cfg.SOUNDS_TIMES[i] < l) continue;
            ++n;
        }
        return n;
    }

    private void soundStopAll() {
        Sound.getSingleton().stop();
    }

    public static boolean soundIsMusicSupposedToPlay() {
        if (gameState == 1) {
            switch (inGameState) {
                case 0: 
                case 13: {
                    return false;
                }
            }
            if (Application.getSingleton().settingsMusicVolumeCurrent != 0) {
                return true;
            }
        }
        return false;
    }

    private void spatialZonesInit() {
        int n;
        short s;
        this.spatialZonesEnemies = new Vector[Map.sectorsX][Map.sectorsY];
        this.spatialZonesCars = new Vector[Map.sectorsX][Map.sectorsY];
        this.spatialZonesCitizens = new Vector[Map.sectorsX][Map.sectorsY];
        this.spatialZonesStaticNoCollision = new Vector[Map.sectorsX][Map.sectorsY];
        this.spatialZonesStaticCollision = new Vector[Map.sectorsX][Map.sectorsY];
        this.spatialZonesTrafficControlIndices = new Vector[Map.sectorsX][Map.sectorsY];
        for (s = 0; s < Map.sectorsX; ++s) {
            for (n = 0; n < Map.sectorsY; ++n) {
                this.spatialZonesEnemies[s][n] = new Vector();
                this.spatialZonesCars[s][n] = new Vector();
                this.spatialZonesCitizens[s][n] = new Vector();
                this.spatialZonesStaticNoCollision[s][n] = new Vector();
                this.spatialZonesStaticCollision[s][n] = new Vector();
                this.spatialZonesTrafficControlIndices[s][n] = new Vector();
            }
        }
        for (s = 0; s < this.enemies.size(); ++s) {
            Enemy enemy = (Enemy)this.enemies.elementAt(s);
            enemy.spatialIndicesCalculate();
            this.spatialZonesEnemies[enemy.shX][enemy.shY].addElement(enemy);
        }
        for (s = 0; s < this.citizens.size(); ++s) {
            Citizen citizen = (Citizen)this.citizens.elementAt(s);
            citizen.spatialIndicesCalculate();
            this.spatialZonesCitizens[citizen.shX][citizen.shY].addElement(citizen);
        }
        if (this.cars != null) {
            for (n = 0; n < this.cars.size(); ++n) {
                Car car = (Car)this.cars.elementAt(n);
                car.spatialIndicesCalculate();
                this.spatialZonesCars[car.shX][car.shY].addElement(car);
            }
        }
        for (s = 0; s < this.dummies.length; ++s) {
            this.dummies[s].spatialIndicesCalculate();
            this.spatialZonesStaticNoCollision[this.dummies[s].shX][this.dummies[s].shY].addElement(this.dummies[s]);
        }
        if (this.trafficLights != null) {
            for (n = 0; n < this.trafficLights.size(); ++n) {
                TrafficLight trafficLight = (TrafficLight)this.trafficLights.elementAt(n);
                trafficLight.spatialIndicesCalculate();
                this.spatialZonesStaticCollision[trafficLight.shX][trafficLight.shY].addElement(trafficLight);
            }
        }
        for (s = 0; s < this.trafficControlZones.length; s = (short)((short)(s + 1))) {
            n = this.trafficControlZones[s].positionLeft >> 3;
            int n2 = this.trafficControlZones[s].positionRight >> 3;
            int n3 = this.trafficControlZones[s].positionUp >> 3;
            int n4 = this.trafficControlZones[s].positionDown >> 3;
            for (int i = n3; i <= n4; ++i) {
                for (int j = n; j <= n2; ++j) {
                    this.spatialZonesTrafficControlIndices[j][i].addElement(new Short(s));
                }
            }
        }
    }

    private void spatialZonesCalcNear(int n, int n2) {
        this.spatialZoneNearX1 = this.spatialZoneNearX2 = n >> 13;
        if ((n >> 10 & 7) >= 4) {
            if (this.spatialZoneNearX2 < Map.sectorsXLastId) {
                ++this.spatialZoneNearX2;
            }
        } else if (this.spatialZoneNearX1 > 0) {
            --this.spatialZoneNearX1;
        }
        this.spatialZoneNearY1 = this.spatialZoneNearY2 = n2 >> 13;
        if ((n2 >> 10 & 7) >= 4) {
            if (this.spatialZoneNearY2 < Map.sectorsYLastId) {
                ++this.spatialZoneNearY2;
            }
        } else if (this.spatialZoneNearY1 > 0) {
            --this.spatialZoneNearY1;
        }
    }

    private boolean[] spritesDetermineAppearance() {
        int n;
        boolean[] blArray = new boolean[30];
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        blArray[0] = true;
        blArray[1] = true;
        if (this.trafficLightsEnabled) {
            blArray[28] = true;
        }
        if (this.enemyTypes != null) {
            for (n = 0; n < this.enemyTypes.length; ++n) {
                if (this.enemyTypes[n] == null || this.enemyTypes[n].spriteId < 0) continue;
                blArray[this.enemyTypes[n].spriteId] = true;
            }
        }
        if (this.dummiesSpriteID != null) {
            for (n = 0; n < this.dummiesSpriteID.length; ++n) {
                blArray[this.dummiesSpriteID[n]] = true;
            }
        }
        for (n = 0; n < this.citizenTypes.length; ++n) {
            if (this.citizenTypes[n] == null) continue;
            blArray[this.citizenTypes[n].spriteId] = true;
        }
        for (n = 0; n < this.carTypes.length; ++n) {
            if (this.carTypes[n] == null) continue;
            blArray[this.carTypes[n].spriteId] = true;
        }
        return blArray;
    }

    private void spritesCalculateVisibilityArea() {
        spritesDisplayBorderLeftF = Mafia.camera.posXf - 4096;
        if (spritesDisplayBorderLeftF < 0) {
            spritesDisplayBorderLeftF = 0;
        }
        if ((spritesDisplayBorderRightF = Mafia.camera.posXf + (Map.tilesBackgroundOnScreenX << 10) + 4096) >= Map.widthTotalF) {
            spritesDisplayBorderRightF = Map.widthTotalF;
            --spritesDisplayBorderRightF;
        }
        if ((spritesDisplayBorderTopF = Mafia.camera.posYf - 2048) < 0) {
            spritesDisplayBorderTopF = 0;
        }
        if ((spritesDisplayBorderBottomF = Mafia.camera.posYf + (Map.tilesBackgroundOnScreenY << 10) + 5120) >= Map.heightTotalF) {
            spritesDisplayBorderBottomF = Map.heightTotalF;
            --spritesDisplayBorderBottomF;
        }
        spritesDisplaySpatialZoneVisibleLeft = spritesDisplayBorderLeftF >> 13;
        spritesDisplaySpatialZoneVisibleRight = spritesDisplayBorderRightF >> 13;
        spritesDisplaySpatialZoneVisibleTop = spritesDisplayBorderTopF >> 13;
        spritesDisplaySpatialZoneVisibleBottom = spritesDisplayBorderBottomF >> 13;
    }

    private boolean spritesIsOnScreen(int n, int n2) {
        return n >= spritesDisplayBorderLeftF && n <= spritesDisplayBorderRightF && n2 >= spritesDisplayBorderTopF && n2 <= spritesDisplayBorderBottomF;
    }

    private void spritesDisplayPrepare() {
        spriteLastShown ^= spriteLastShown;
        this.spritesVisible.removeAllElements();
        this.spritesVisible.addElement(player);
        for (int i = spritesDisplaySpatialZoneVisibleTop; i <= spritesDisplaySpatialZoneVisibleBottom; ++i) {
            for (int j = spritesDisplaySpatialZoneVisibleLeft; j <= spritesDisplaySpatialZoneVisibleRight; ++j) {
                int n;
                int n2 = this.spatialZonesCitizens[j][i].size();
                --n2;
                while (n2 >= 0) {
                    Citizen citizen = (Citizen)this.spatialZonesCitizens[j][i].elementAt(n2);
                    if (citizen.positionXf >= spritesDisplayBorderLeftF && citizen.positionXf <= spritesDisplayBorderRightF && citizen.positionYf >= spritesDisplayBorderTopF && citizen.positionYf <= spritesDisplayBorderBottomF) {
                        for (n = this.spritesVisible.size(); n > 0 && citizen.positionYf < ((Sprite)this.spritesVisible.elementAt((int)(n - 1))).positionYf; --n) {
                        }
                        this.spritesVisible.insertElementAt(citizen, n);
                    }
                    --n2;
                }
                n2 = this.spatialZonesCars[j][i].size();
                --n2;
                while (n2 >= 0) {
                    Car car = (Car)this.spatialZonesCars[j][i].elementAt(n2);
                    if (car.positionXf >= spritesDisplayBorderLeftF && car.positionXf <= spritesDisplayBorderRightF && car.positionYf >= spritesDisplayBorderTopF && car.positionYf <= spritesDisplayBorderBottomF) {
                        for (n = this.spritesVisible.size(); n > 0 && car.positionYf < ((Sprite)this.spritesVisible.elementAt((int)(n - 1))).positionYf; --n) {
                        }
                        this.spritesVisible.insertElementAt(car, n);
                    }
                    --n2;
                }
                n2 = this.spatialZonesEnemies[j][i].size();
                --n2;
                while (n2 >= 0) {
                    Enemy enemy = (Enemy)this.spatialZonesEnemies[j][i].elementAt(n2);
                    if (enemy.positionXf >= spritesDisplayBorderLeftF && enemy.positionXf <= spritesDisplayBorderRightF && enemy.positionYf >= spritesDisplayBorderTopF && enemy.positionYf <= spritesDisplayBorderBottomF) {
                        for (n = this.spritesVisible.size(); n > 0 && enemy.positionYf < ((Sprite)this.spritesVisible.elementAt((int)(n - 1))).positionYf; --n) {
                        }
                        this.spritesVisible.insertElementAt(enemy, n);
                    }
                    --n2;
                }
                n2 = this.spatialZonesStaticNoCollision[j][i].size();
                --n2;
                while (n2 >= 0) {
                    Dummy dummy = (Dummy)this.spatialZonesStaticNoCollision[j][i].elementAt(n2);
                    if (dummy.isVisible && dummy.positionXf >= spritesDisplayBorderLeftF && dummy.positionXf <= spritesDisplayBorderRightF && dummy.positionYf >= spritesDisplayBorderTopF && dummy.positionYf <= spritesDisplayBorderBottomF) {
                        for (n = this.spritesVisible.size(); n > 0 && dummy.positionYf < ((Sprite)this.spritesVisible.elementAt((int)(n - 1))).positionYf; --n) {
                        }
                        this.spritesVisible.insertElementAt(dummy, n);
                    }
                    --n2;
                }
                n2 = this.spatialZonesStaticCollision[j][i].size();
                --n2;
                while (n2 >= 0) {
                    TrafficLight trafficLight = (TrafficLight)this.spatialZonesStaticCollision[j][i].elementAt(n2);
                    if (trafficLight.positionXf >= spritesDisplayBorderLeftF && trafficLight.positionXf <= spritesDisplayBorderRightF && trafficLight.positionYf >= spritesDisplayBorderTopF && trafficLight.positionYf <= spritesDisplayBorderBottomF) {
                        for (n = this.spritesVisible.size(); n > 0 && trafficLight.positionYf < ((Sprite)this.spritesVisible.elementAt((int)(n - 1))).positionYf; --n) {
                        }
                        this.spritesVisible.insertElementAt(trafficLight, n);
                    }
                    --n2;
                }
            }
        }
    }

    private void spritesLayerPaint(Graphics graphics) {
        int n;
        int n2 = -((Mafia.camera.posXf & 0x3FF) * Map.tileWidth + 512) >> 10;
        int n3 = n = -((Mafia.camera.posYf & 0x3FF) * Map.tileHeight + 512) >> 10;
        int n4 = Mafia.camera.posYf >> 10;
        spriteLastShown = 0;
        for (int i = 0; i < Map.tilesPlaceablesOnScreenX; ++i) {
            if (n4 >= 0) {
                if (n4 >= Map.cellsOnMapTotalY) break;
                this.spritesPaint(graphics, (n4 << 10) + 1023);
                int n5 = Mafia.camera.posXf >> 10;
                n5 -= 4;
                int n6 = n2 - 4 * Map.tileWidth;
                for (int j = 0; j < Map.tilesPlaceablesOnScreenX; ++j) {
                    if (n5 >= 0) {
                        int n7;
                        if (n5 >= Map.cellsOnMapTotalX) break;
                        byte by = Map.templatesPosX[n5 >> 3][n4 >> 3];
                        byte by2 = Map.templatesPosY[n5 >> 3][n4 >> 3];
                        if (Map.layerPlaceables.tiles[by][by2] != null && (n7 = Map.layerPlaceables.tiles[by][by2][n5 & 7][n4 & 7]) != 0) {
                            n7 = n7 < 0 ? (n7 += 255) : --n7;
                            Map.placeablesAnim.drawFrame(graphics, n7, animationGlobalCounter, n6, n3, 1);
                        }
                    }
                    n6 += Map.tileWidth;
                    ++n5;
                }
            }
            n3 += Map.tileHeight;
            ++n4;
        }
    }

    private void spritesPaint(Graphics graphics, int n) {
        while (spriteLastShown < this.spritesVisible.size()) {
            int n2;
            int n3;
            Sprite sprite = (Sprite)this.spritesVisible.elementAt(spriteLastShown);
            if (sprite.positionYf >= n) break;
            if (sprite.type == 0) {
                if (Mafia.player.isVisible) {
                    n3 = player.getCurrentFrame();
                    n2 = player.getCurrentSequence();
                    if (!player.isAnimLoop()) {
                        n3 = this.sprites[0].getNextFrameNumber(n2, n3 - 1, 1);
                    }
                    this.sprites[0].drawFrame(graphics, n2, n3, (Mafia.player.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (Mafia.player.positionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 0);
                }
            } else if (sprite.type == 3) {
                Citizen citizen = (Citizen)sprite;
                this.sprites[citizen.citizenType.spriteId].drawFrame(graphics, citizen.getCurrentSequence(), citizen.getCurrentFrame(), (citizen.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (citizen.positionYf - Mafia.camera.posYf) * Map.tileWidth + 512 >> 10, 1);
            } else if (sprite.type == 4) {
                Car car = (Car)sprite;
                this.sprites[car.carType.spriteId].drawFrame(graphics, car.getCurrentSequence(), car.getCurrentFrame(), (car.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (car.positionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 1);
            } else if (sprite.type == 2) {
                Dummy dummy = (Dummy)sprite;
                this.sprites[this.dummiesSpriteID[dummy.dummyID]].drawFrame(graphics, dummy.getCurrentSequence(), dummy.getCurrentFrame(), (dummy.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (dummy.positionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10, 1);
            } else if (sprite.type == 1) {
                Enemy enemy = (Enemy)sprite;
                if (enemy.isVisible) {
                    int n4 = (enemy.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10;
                    int n5 = (enemy.positionYf - Mafia.camera.posYf) * Map.tileHeight + 512 >> 10;
                    if (enemy.enemyType.spriteId >= 0) {
                        n2 = enemy.getCurrentSequence();
                        n3 = enemy.getCurrentFrame();
                        if (enemy.getState() != 11) {
                            n2 += enemy.direction;
                        }
                        if (enemy.getState() == 7 || enemy.getState() == 11) {
                            n3 = this.sprites[enemy.enemyType.spriteId].getNextFrameNumber(n2, n3 - 1, 1);
                        }
                        this.sprites[enemy.enemyType.spriteId].drawFrame(graphics, n2, n3, n4, n5, 1);
                    }
                    if (enemy.isActive) {
                        graphics.setColor(0);
                        graphics.fillRect(n4 - 12, n5 + enemy.enemyType.healthBarOffsetVertical - 2, 24, 4);
                        int n6 = enemy.healthPoints * 100 / enemy.enemyType.healthPointsMax;
                        if (n6 > 0) {
                            if (n6 > 66) {
                                graphics.setColor(65280);
                            } else if (n6 > 33) {
                                graphics.setColor(0xFFFF00);
                            } else {
                                graphics.setColor(0xFF0000);
                            }
                            graphics.fillRect(n4 - 12 + 1, n5 + enemy.enemyType.healthBarOffsetVertical - 1, n6 * 22528 / 100 < 1024 ? 1 : n6 * 22528 / 100 >> 10, 2);
                        }
                    }
                }
            } else if (sprite.type == 6) {
                TrafficLight trafficLight = (TrafficLight)sprite;
                this.sprites[28].drawFrame(graphics, trafficLight.getCurrentSequence(), trafficLight.getCurrentFrame(), (trafficLight.positionXf - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10, (trafficLight.positionYf - Mafia.camera.posYf) * Map.tileWidth + 512 >> 10, 1);
            }
            ++spriteLastShown;
        }
    }

    private void timerAdd(int n, int n2, boolean bl, byte by, byte by2) {
        this.timers.addElement(new Timer(n, n2 << 10, bl, by, by2));
    }

    private void timerRemove(int n) {
        for (int i = this.timers.size() - 1; i >= 0; --i) {
            if (((Timer)this.timers.elementAt((int)i)).id != n) continue;
            this.timers.removeElementAt(i);
        }
    }

    private void timerUpdate(int n) {
        for (int i = this.timers.size() - 1; i >= 0; --i) {
            Timer timer = (Timer)this.timers.elementAt(i);
            timer.timeMs -= n;
            if (timer.timeMs > 0) continue;
            this.timers.removeElement(timer);
            this.timerEvent(timer);
            timer = null;
        }
    }

    private void timerPaint(Graphics graphics) {
        for (int i = 0; i < this.timers.size(); ++i) {
            int n;
            int n2;
            boolean bl;
            int n3;
            Timer timer = (Timer)this.timers.elementAt(i);
            if (!timer.visible) continue;
            char[] cArray = new char[5];
            int n4 = (timer.timeMs >> 10) / 60;
            if (n4 < 10) {
                cArray[0] = 48;
                cArray[1] = (char)(48 + n4);
            } else {
                if (n4 > 60) {
                    n4 = 60;
                }
                n3 = 0;
                bl = true;
                for (n2 = 10; n2 > 0; n2 /= 10) {
                    n = n4 / n2;
                    n4 = (short)(n4 - n * n2);
                    if (n == 0 && bl) continue;
                    cArray[n3++] = (char)(48 + n);
                    bl = false;
                }
            }
            cArray[2] = 58;
            n4 = (short)((timer.timeMs >> 10) % 60);
            if (n4 < 10) {
                cArray[3] = 48;
                cArray[4] = (char)(48 + n4);
            } else {
                if (n4 > 60) {
                    n4 = 60;
                }
                n3 = 3;
                bl = true;
                for (n2 = 10; n2 > 0; n2 /= 10) {
                    n = n4 / n2;
                    n4 = (short)(n4 - n * n2);
                    if (n == 0 && bl) continue;
                    cArray[n3++] = (char)(48 + n);
                    bl = false;
                }
            }
            this.txt.drawText(graphics, cArray, Cfg.TIMER_POSITION_X, Cfg.TIMER_POSITION_Y, 1);
        }
    }

    private void timerEvent(Timer timer) {
        if (timer.triggerToReleaseId != -1) {
            this.hotspotActivate(timer.triggerToActivateId);
        }
        if (timer.triggerToReleaseId != -1) {
            this.hotspotTriggerRelease(timer.triggerToReleaseId);
        }
    }

    private void trafficControlZonesSpawn() {
        int n;
        int n2 = 0;
        for (n = 0; n < Map.layerTriggersSpawn.triggers[0][0].length; ++n) {
            if (Map.layerTriggersSpawn.triggers[0][0][n].type != 8) continue;
            ++n2;
        }
        this.trafficControlZones = new TrafficControlZone[n2];
        n2 ^= n2;
        for (n = 0; n < Map.layerTriggersSpawn.triggers[0][0].length; ++n) {
            Trigger trigger = Map.layerTriggersSpawn.triggers[0][0][n];
            if (trigger.type != 8) continue;
            this.trafficControlZones[n2] = new TrafficControlZone();
            this.trafficControlZones[n2].Init(trigger.posX, trigger.posY, trigger.params[0], trigger.params[1]);
            ++n2;
        }
    }

    private void trafficLightsAssignToZones() {
        for (int i = 0; i < this.trafficLights.size(); ++i) {
            TrafficLight trafficLight = (TrafficLight)this.trafficLights.elementAt(i);
            int n = trafficLight.positionXf >> 10;
            int n2 = trafficLight.positionYf >> 10;
            for (int j = 0; j < this.trafficControlZones.length; ++j) {
                if (n < this.trafficControlZones[j].positionLeft || n > this.trafficControlZones[j].positionRight || n2 < this.trafficControlZones[j].positionUp || n2 > this.trafficControlZones[j].positionDown) continue;
                this.trafficControlZones[j].addTrafficLight(trafficLight);
            }
        }
    }

    private void trafficLightsUpdate(int n) {
        this.trafficLightsTimeCounter += n;
        if (this.trafficLightsTimeCounter >= 500) {
            this.trafficLightsTimeCounter -= 500;
            for (int i = 0; i < this.trafficControlZones.length; ++i) {
                this.trafficControlZones[i].tick();
            }
        }
    }

    private void trafficLightsSpawn() {
        Trigger trigger;
        int n = 0;
        this.trafficLightsTimeCounter = 0;
        this.trafficLights = new Vector();
        while ((trigger = Map.layerTriggersSpawn.getTriggerByType(7, n)) != null) {
            TrafficLight trafficLight = new TrafficLight();
            trafficLight.init();
            trafficLight.positionXf = (trigger.posX << 10) + 512;
            trafficLight.positionYf = (trigger.posY << 10) + 512;
            trafficLight.direction = (byte)trigger.params[0];
            this.trafficLights.addElement(trafficLight);
            ++n;
        }
    }

    private void transitionStart(byte by, boolean bl) {
        if (!bl) {
            transitionNextInGameState = by;
            this.transitionIsOut = true;
            this.transitionTimeMs = 0;
            transitionBarWidth = 0;
            transitionBarHeight = 0;
        } else {
            this.transitionStateVisible = transitionNextInGameState = by;
            this.transitionTimeMs = 500;
            this.transitionIsOut = false;
            transitionBarWidth = (short)(C.getScreenWidth() >> 1);
            transitionBarHeight = (short)(C.getScreenHeight() >> 1);
        }
        this.inGameSetState((byte)6);
    }

    private void transitionUpdate(int n) {
        if (this.transitionIsOut) {
            this.transitionTimeMs += n;
            if (this.transitionTimeMs >= 500) {
                switch (gameState) {
                    case 1: {
                        this.transitionTimeMs = 500;
                        this.transitionStateVisible = transitionNextInGameState;
                        this.transitionIsOut = false;
                        break;
                    }
                    case 2: {
                        if (player.getTotalScore() > Application.highScorePoints[Application.highScorePoints.length - 1]) {
                            endGameState = 2;
                            this.nickNameInit();
                            break;
                        }
                        levelCurrent = 0;
                        this.saveGame();
                        this.endGame();
                        C.keyClear();
                    }
                }
            }
        } else {
            this.transitionTimeMs -= n;
            if (this.transitionTimeMs <= 0) {
                this.inGameSetState(transitionNextInGameState);
            }
        }
        transitionBarWidth = (short)((C.getScreenWidth() >> 1) * this.transitionTimeMs / 500);
        transitionBarHeight = (short)((C.getScreenHeight() >> 1) * this.transitionTimeMs / 500);
    }

    private void transitionPaint(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, (int)transitionBarWidth, C.getScreenHeight());
        graphics.fillRect(C.getScreenWidth() - transitionBarWidth, 0, (int)transitionBarWidth, C.getScreenHeight());
        graphics.fillRect(0, 0, C.getScreenWidth(), (int)transitionBarHeight);
        graphics.fillRect(0, C.getScreenHeight() - transitionBarHeight, C.getScreenWidth(), (int)transitionBarHeight);
    }

    private void tutorialLaunch(byte by) {
        if (!this.tutorialMessages[by] && Application.getSingleton().mafiaSettingsTutorialIsEnabled) {
            this.tutorialMessages[by] = true;
            this.messageInit(this.txt.getText(Cfg.TXT_ID_TUTORIAL_MESSAGES[by]), this.txt, false, false, false, -1, -1);
        }
    }

    private void worldUpdate(int n) {
        this.trafficLightsUpdate(n);
        this.enemiesUpdate(n);
        this.citizensUpdate(n);
        this.carsUpdate(n);
    }

    private void worldPaint(Graphics graphics) {
        map.paintBackgroundForegroundLayers(graphics, Mafia.camera.posXf, Mafia.camera.posYf);
        this.hotspotsMarkersPaint(graphics);
        this.itemsPaint(graphics);
        this.spritesLayerPaint(graphics);
        if (rainVisible) {
            this.rainPaint(graphics);
        }
        if (effectFlashTimeMs > 0) {
            this.effectFlashPaint(graphics);
        }
    }

    private void auxPaintPlayerPositinon(Graphics graphics) {
        graphics.setColor(0xFFFF00);
        graphics.drawString("p: " + (Mafia.player.positionXf >> 10) + "," + (Mafia.player.positionYf >> 10), C.getScreenWidth() - 10, 20, 24);
    }

    private void auxPaintFps(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0xFFFFFF);
        graphics.drawString("FPS: " + Application.getSingleton().getFPS(), C.getScreenWidth() - 10, 2, 24);
    }

    private void auxCarPaint(Graphics graphics, Car car) {
        int n = (car.boundingBox.vertices[3].x - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10;
        int n2 = (car.boundingBox.vertices[3].y - Mafia.camera.posYf) * Map.tileWidth + 512 >> 10;
        graphics.setColor(0xFFFF00);
        for (int i = 0; i < 4; ++i) {
            int n3 = (car.boundingBox.vertices[i].x - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10;
            int n4 = (car.boundingBox.vertices[i].y - Mafia.camera.posYf) * Map.tileWidth + 512 >> 10;
            graphics.drawLine(n, n2, n3, n4);
            n = n3;
            n2 = n4;
        }
    }

    private void auxPaintVect(Graphics graphics, Vect vect) {
        int n = (vect.x - Mafia.camera.posXf) * Map.tileWidth + 512 >> 10;
        int n2 = (vect.y - Mafia.camera.posYf) * Map.tileWidth + 512 >> 10;
        graphics.setColor(0xFFFFFF);
        graphics.drawRect(n, n2, 1, 1);
    }

    static {
        cameraCarOffset = new Vect();
        cheatCodeFlag = false;
        cheatCodeImmortalFlag = false;
        cheatCodeAmmoFlag = false;
        hudBloodTimeLeft = 0;
        levelLoaded = (byte)-1;
        isInfoScreen = false;
    }
}

