/*
 * Decompiled with CFR 0.152.
 */
package SAF_Engine;

import SAF_Core.Anim;
import SAF_Engine.LayerCollision;
import SAF_Engine.LayerTemplates;
import SAF_Engine.LayerTile;
import SAF_Engine.LayerTrigger;
import java.io.DataInputStream;

public abstract class Layer {
    public static final byte TYPE_UNKNOWN = -1;
    public static final byte TYPE_TILES = 0;
    public static final byte TYPE_COLLISION = 2;
    public static final byte TYPE_TRIGGERS = 3;
    public static final byte TYPE_TEMPLATES = 4;
    protected int layerSizeX;
    protected int layerSizeY;
    protected int sectorSizeX;
    protected int sectorSizeY;
    protected int cellSizeX;
    protected int cellSizeY;
    protected Anim gfx = null;

    public void setGfx(Anim anim) {
        this.gfx = anim;
    }

    public static int getLayerType(byte[] byArray) {
        if (byArray.length == 3) {
            if (byArray[0] == LayerTile.ID[0] && byArray[1] == LayerTile.ID[1] && byArray[2] == LayerTile.ID[2]) {
                return 0;
            }
            if (byArray[0] == LayerCollision.ID[0] && byArray[1] == LayerCollision.ID[1] && byArray[2] == LayerCollision.ID[2]) {
                return 2;
            }
            if (byArray[0] == LayerTrigger.ID[0] && byArray[1] == LayerTrigger.ID[1] && byArray[2] == LayerTrigger.ID[2]) {
                return 3;
            }
            if (byArray[0] == LayerTemplates.ID[0] && byArray[1] == LayerTemplates.ID[1] && byArray[2] == LayerTemplates.ID[2]) {
                return 4;
            }
        }
        return -1;
    }

    public int getLayerSizeX() {
        return this.layerSizeX;
    }

    public int getLayerSizeY() {
        return this.layerSizeY;
    }

    public int getCellSizeX() {
        return this.cellSizeX;
    }

    public int getCellSizeY() {
        return this.cellSizeX;
    }

    public int getSectorSizeX() {
        return this.sectorSizeX;
    }

    public int getSectorSizeY() {
        return this.sectorSizeY;
    }

    protected boolean initGeneralParams(DataInputStream dataInputStream) {
        try {
            this.cellSizeX = dataInputStream.readUnsignedByte();
            this.cellSizeY = dataInputStream.readUnsignedByte();
            this.sectorSizeX = dataInputStream.readUnsignedByte();
            if (this.sectorSizeX == 0) {
                this.sectorSizeX = 256;
            }
            this.sectorSizeY = dataInputStream.readUnsignedByte();
            if (this.sectorSizeY == 0) {
                this.sectorSizeY = 256;
            }
            this.layerSizeX = dataInputStream.readUnsignedByte();
            this.layerSizeY = dataInputStream.readUnsignedByte();
            dataInputStream.readInt();
            dataInputStream.readInt();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    protected boolean initGeneralParamsExtended(DataInputStream dataInputStream) {
        try {
            this.cellSizeX = dataInputStream.readUnsignedShort();
            this.cellSizeY = dataInputStream.readUnsignedShort();
            this.sectorSizeX = dataInputStream.readUnsignedByte();
            this.sectorSizeY = dataInputStream.readUnsignedByte();
            this.layerSizeX = dataInputStream.readUnsignedByte();
            this.layerSizeY = dataInputStream.readUnsignedByte();
            dataInputStream.readInt();
            dataInputStream.readInt();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public abstract int getType();

    public abstract void init(DataInputStream var1);

    public abstract void dispose();
}

