/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class DashEditBox2
implements SPDefines {
    protected DashImage m_imgArrows;
    protected DashFont m_pFont;
    protected StringBuffer m_text;
    protected int m_numChars;
    protected boolean m_showArrows;
    public boolean hideChars = false;
    public AEERect m_rect;

    public DashEditBox2(AEERect area, int numChars, int fontID, int imgArrowsID) {
        this.m_rect = new AEERect(area);
        this.m_numChars = numChars;
        if (this.m_numChars < 1) {
            this.m_numChars = 1;
        }
        this.m_pFont = DashResourceProvider.getFont(fontID);
        this.m_imgArrows = DashResourceProvider.getImage(imgArrowsID);
        this.m_text = new StringBuffer(numChars);
        this.m_text.append("A");
        this.m_showArrows = true;
    }

    public void hide() {
        this.hideChars = true;
    }

    public String getText() {
        return this.m_text.toString();
    }

    public void setText(String txt) {
        this.m_text = new StringBuffer(this.m_numChars);
        this.m_text.append(txt);
    }

    public boolean pointInRect(int x, int y) {
        if (x < this.m_rect.x || x > this.m_rect.x + this.m_rect.dx) {
            return false;
        }
        return y >= this.m_rect.y && y <= this.m_rect.y + this.m_rect.dy;
    }

    public int getMaxChars() {
        return this.m_numChars;
    }

    public int getNumChars() {
        return this.m_text.length();
    }

    public boolean HandleEvent(int wParam) {
        char curChar = this.m_text.charAt(this.m_text.length() - 1);
        if (wParam == 2 || wParam == 11) {
            if (this.m_text.length() > 1) {
                this.m_text = this.m_text.deleteCharAt(this.m_text.length() - 1);
                return true;
            }
            return false;
        }
        if (wParam == 3 || wParam == 13) {
            if (this.m_text.length() < this.m_numChars) {
                this.m_text.append("A");
            }
            return true;
        }
        if (DashEngine.avk_up(wParam)) {
            do {
                if ((curChar = (char)(curChar + '\u0001')) != '\u007f') continue;
                curChar = '\u0001';
            } while (!this.m_pFont.isValidChar(curChar));
            this.m_text.setCharAt(this.m_text.length() - 1, curChar);
            return true;
        }
        if (wParam == 1 || wParam == 15) {
            do {
                if ((curChar = (char)(curChar - '\u0001')) != '\u0000') continue;
                curChar = '~';
            } while (!this.m_pFont.isValidChar(curChar));
            this.m_text.setCharAt(this.m_text.length() - 1, curChar);
            return true;
        }
        return false;
    }

    public void toggleArrows(boolean show) {
        this.m_showArrows = show;
    }

    public void draw(Graphics g) {
        if (this.m_showArrows) {
            if (this.m_text.length() > 1) {
                this.m_imgArrows.draw(g, this.m_rect.x - this.m_imgArrows.getWidth(), this.m_rect.y + this.m_rect.dy / 2, 0, 6);
            }
            if (this.m_text.length() < this.m_numChars) {
                this.m_imgArrows.draw(g, this.m_rect.x + this.m_rect.dx, this.m_rect.y + this.m_rect.dy / 2, 3, 6);
            }
        }
        if (this.hideChars) {
            g.setColor(0xFFFFFF);
            int size = this.m_pFont.getHeight() - 2;
            int tempY = this.m_rect.y + (this.m_rect.dy - size) / 2;
            int tempX = this.m_rect.x + 1;
            char lastChar = this.m_text.toString().charAt(this.m_text.toString().length() - 1);
            for (int i = 0; i < this.m_text.toString().length() - 1; ++i) {
                g.fillArc(tempX, tempY, size, size, 0, 360);
                tempX += size + 1;
            }
            this.m_pFont.drawString(g, "" + lastChar, tempX, this.m_rect.y + this.m_rect.dy / 2, 6);
            if (this.m_showArrows) {
                this.m_imgArrows.draw(g, (tempX += this.m_pFont.getCharVarW(lastChar) / 2) - this.m_imgArrows.getWidth(2) / 2, this.m_rect.y, 2, 33);
                this.m_imgArrows.draw(g, tempX - this.m_imgArrows.getWidth(1) / 2, this.m_rect.y + this.m_rect.dy, 1, 17);
            }
        } else {
            this.m_pFont.drawString(g, this.m_text.toString(), this.m_rect.x, this.m_rect.y + this.m_rect.dy / 2, 6);
            if (this.m_showArrows) {
                int cursorOffset = this.m_pFont.stringWidth(this.m_text.toString()) - this.m_pFont.stringWidth("" + this.m_text.charAt(this.m_text.length() - 1)) / 2;
                this.m_imgArrows.draw(g, this.m_rect.x + cursorOffset - this.m_imgArrows.getWidth(2) / 2, this.m_rect.y, 2, 33);
                this.m_imgArrows.draw(g, this.m_rect.x + cursorOffset - this.m_imgArrows.getWidth(1) / 2, this.m_rect.y + this.m_rect.dy, 1, 17);
            }
        }
    }
}

