/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class DashScrollableText
implements SPDefines {
    public static int SCROLLBAR_WIDTH = 10;
    public static int VERTICAL_PADDING = 0;
    public int scroll_jump;
    String[] m_text;
    DashFont m_font;
    int dx;
    int dy;
    public AEERect m_subWindow;
    public DashMenuStyle m_style = null;
    public int m_fillColor;
    public int m_borderColor;
    public int scrollPosition;
    public int m_scrollCursor = 0;
    int m_align = 17;
    public int m_pointer_scroll = 0;

    public void init(String text, int width, DashFont font) {
        SCROLLBAR_WIDTH = 10;
        this.m_font = font;
        this.scroll_jump = this.m_font.getHeight() + VERTICAL_PADDING;
        this.dx = width;
        if (text != null) {
            this.setText(text);
        } else {
            this.m_text = null;
            this.dy = 0;
        }
    }

    public DashScrollableText(String text, int width, DashFont font) {
        this.init(text, width, font);
    }

    public DashScrollableText(AEERect area, int borderColor, int fillColor, DashFont font) {
        this.m_subWindow = area;
        this.init(null, area.dx - SCROLLBAR_WIDTH - 4, font);
        this.m_fillColor = fillColor;
        this.m_borderColor = borderColor;
    }

    public DashScrollableText(AEERect area, DashMenuStyle style) {
        this.m_subWindow = area;
        this.m_style = style;
        this.init(null, area.dx - SCROLLBAR_WIDTH, style.getFont());
    }

    public void setText(String text) {
        this.m_scrollCursor = 0;
        this.scrollPosition = 0;
        this.m_text = this.m_font.wrap(text, this.dx - 4);
        this.dy = this.m_text.length * (this.m_font.getHeight() + VERTICAL_PADDING);
    }

    public void addText(String text) {
        String[] newText = this.m_font.wrap(text, this.dx);
        if (this.m_text == null) {
            this.m_text = newText;
        } else {
            String[] completeText = new String[this.m_text.length + newText.length];
            for (int i = 0; i < this.m_text.length; ++i) {
                completeText[i] = this.m_text[i];
            }
            for (int j = 0; j < newText.length; ++j) {
                completeText[i++] = newText[j];
            }
            this.m_text = completeText;
        }
        this.dy = this.m_text.length * (this.m_font.getHeight() + VERTICAL_PADDING);
    }

    public void draw(Graphics g, int xoff, int yoff, int align) {
        if (this.m_text == null) {
            return;
        }
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        g.clipRect(xoff, yoff, this.dx, this.dy);
        int yspacing = this.m_font.getHeight() + VERTICAL_PADDING;
        int line = (clipy - yoff) / yspacing;
        int lastLine = line + cliph / yspacing;
        yoff -= this.m_scrollCursor;
        if (line < 0) {
            line = 0;
        }
        if (lastLine > this.m_text.length) {
            lastLine = this.m_text.length;
        }
        if ((align & 1) != 0) {
            xoff += this.dx / 2;
        } else if ((align & 8) != 0) {
            xoff += this.dx;
        }
        align &= 0xFFFFFFDD;
        while (line < lastLine) {
            this.m_font.drawString(g, this.m_text[line], xoff, yoff + yspacing * line, align);
            ++line;
        }
        g.setClip(clipx, clipy, clipw, cliph);
    }

    public void draw_faster(Graphics g, int xoff, int yoff) {
        yoff -= this.m_scrollCursor;
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        int yspacing = this.m_font.getHeight() + VERTICAL_PADDING;
        int firstLine = (clipy - yoff) / yspacing;
        int lastLine = firstLine + cliph / yspacing + 1;
        if (firstLine < 0) {
            firstLine = 0;
        }
        if (lastLine > this.m_text.length) {
            lastLine = this.m_text.length;
        }
        for (int line = firstLine; line < lastLine; ++line) {
            if (line == firstLine || line == lastLine - 1) {
                g.setClip(clipx, clipy, clipw, cliph);
                this.m_font.drawString(g, this.m_text[line], xoff, yoff + yspacing * line, this.m_align);
            } else {
                this.m_font.drawString(g, this.m_text[line], xoff, yoff + yspacing * line, this.m_align);
            }
            if (lastLine <= this.m_text.length) continue;
            lastLine = this.m_text.length;
        }
        g.setClip(clipx, clipy, clipw, cliph);
    }

    public void Draw(Graphics g) {
        this.Draw(g, 17);
    }

    public void Draw(Graphics g, int align) {
        this.m_align = align;
        if (this.m_subWindow == null) {
            return;
        }
        if (this.m_text == null) {
            return;
        }
        int oldColor = g.getColor();
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        if (this.m_style != null) {
            this.m_style.drawWindow(g, this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy);
        } else {
            if (this.m_fillColor != 0xFF00FF) {
                g.setColor(this.m_fillColor);
                g.fillRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy);
            }
            if (this.m_borderColor != 0xFF00FF && SCROLLBAR_WIDTH == 10) {
                g.setColor(this.m_borderColor);
                g.drawRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx - 1, this.m_subWindow.dy - 1);
            }
        }
        g.clipRect(this.m_subWindow.x, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy);
        int xoff = this.m_subWindow.x + ((this.m_align & 4) != 0 ? 2 : 4);
        if ((this.m_align & 1) != 0) {
            xoff += this.dx / 2;
        }
        if ((this.m_align & 8) != 0) {
            xoff += this.dx;
        }
        this.draw_faster(g, xoff, this.m_subWindow.y + 1 - this.scrollPosition);
        g.setClip(clipx, clipy, clipw, cliph);
        if (this.m_subWindow.dy < this.dy) {
            if (this.m_style != null) {
                boolean uparrow = true;
                boolean downarrow = true;
                if (this.scrollPosition <= 0) {
                    uparrow = false;
                }
                if (this.scrollPosition >= this.dy - this.m_subWindow.dy) {
                    downarrow = false;
                }
                this.m_style.drawScrollBar(g, this.m_subWindow.x + 1, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy, this.scrollPosition, this.dy);
                this.m_style.drawArrows(g, this.m_subWindow.x - SCROLLBAR_WIDTH / 2, this.m_subWindow.y, this.m_subWindow.dx, this.m_subWindow.dy, uparrow, downarrow);
            } else if (this.m_borderColor != 0xFF00FF) {
                g.setColor(this.m_borderColor);
                g.drawRect(this.m_subWindow.x + this.m_subWindow.dx - SCROLLBAR_WIDTH - 1, this.m_subWindow.y, SCROLLBAR_WIDTH, this.m_subWindow.dy);
                int dyFill = this.m_subWindow.dy * this.m_subWindow.dy / this.dy;
                int startY = this.scrollPosition * this.m_subWindow.dy / this.dy;
                g.fillRect(this.m_subWindow.x + this.m_subWindow.dx - SCROLLBAR_WIDTH - 1, this.m_subWindow.y + startY, SCROLLBAR_WIDTH, dyFill);
            }
        }
        g.setColor(oldColor);
    }

    public int getHeight() {
        return this.dy;
    }

    public void HandleAction(int key) {
        if (this.m_subWindow != null) {
            if (key == 0) {
                if (this.scrollPosition <= 0) {
                    return;
                }
                this.scrollPosition -= this.scroll_jump;
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                }
            } else if (key == 1) {
                if (this.scrollPosition >= this.dy - this.m_subWindow.dy) {
                    return;
                }
                this.scrollPosition += this.scroll_jump;
                if (this.scrollPosition >= this.dy - this.m_subWindow.dy) {
                    this.scrollPosition = this.dy - this.m_subWindow.dy;
                }
                if (this.scrollPosition < 0) {
                    this.scrollPosition = 0;
                }
            }
        }
    }

    public void scroll(int pixels) {
        this.scrollPosition += pixels;
        if (this.scrollPosition >= this.dy - this.m_subWindow.dy + this.scroll_jump) {
            this.scrollPosition = this.dy - this.m_subWindow.dy + this.scroll_jump;
        }
        if (this.scrollPosition < 0) {
            this.scrollPosition = 0;
        }
    }

    public void resetPosition() {
        this.scrollPosition = 0;
    }

    public void Update() {
        if (this.m_subWindow != null) {
            if (DashEngine.isKeyPressed(0)) {
                this.scroll(-this.scroll_jump / 2);
            }
            if (DashEngine.isKeyPressed(1)) {
                this.scroll(this.scroll_jump / 2);
            }
        }
    }
}

