/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class LifeBar
implements SPDefines {
    long value;
    long puValue;
    long targetValue;
    long targetPuValue;
    int state;
    int pu_state;
    int lifeWidthInPixels;
    int puHeightInPixels;
    int lifeBarX;
    int lifeBarY;
    int puBarX;
    int puBarY;
    int totalBarW;
    int fillX_l;
    int fillW_l;
    int fillX_pu;
    int fillW_pu;
    int fillY_l;
    int fillY_pu;
    int fillX2_pu;
    int fillY2_pu;
    int fillW2_pu;
    int fillH_pu;
    int fillH2_pu;
    int puTargetValue;
    long lifeFlashTimer;
    boolean doLifeFlash;
    long puFlashTimer;
    boolean doPuFlash;
    int puIconFrameIdx;
    int m_bgColor;
    int fullScrollOffset;
    int fullFrameOffset;
    int pu_fillColor;
    long pu_colorChangeTimer;
    int pu_currColor;
    int pu_targetColor;
    int puicon_posX;
    int puicon_posY;
    int startValue;

    public LifeBar(int startingLife, int equippedPowerup) {
        this.startValue = startingLife;
        DashImage imgBacking = DashResourceProvider.getImage(66);
        DashImage imgPU = DashResourceProvider.getImage(68);
        this.lifeBarX = DashResourceProvider.getScreenWidth() - imgBacking.getWidth() - 10;
        this.lifeBarY = 28;
        this.puBarX = this.lifeBarX + imgBacking.getWidth() - imgPU.getWidth();
        this.puBarY = this.lifeBarY + imgBacking.getHeight() + 7;
        this.fillX_l = this.lifeBarX + 2;
        this.fillW_l = 93;
        this.fillY_l = this.lifeBarY + 23;
        this.fillX_pu = this.puBarX + 21;
        this.fillY_pu = this.puBarY + 21;
        this.fillX2_pu = this.puBarX + 3;
        this.fillY2_pu = this.puBarY + 4;
        this.fillW2_pu = 70;
        this.fillW_pu = 47;
        this.fillH2_pu = 17;
        this.fillH_pu = 14;
        this.pu_fillColor = 0x55AAFF;
        this.pu_colorChangeTimer = -1L;
        this.state = 0;
        this.targetValue = startingLife;
        this.targetPuValue = 0L;
        this.value = startingLife;
        this.puValue = 0L;
        this.lifeWidthInPixels = this.calculateLifeBarWidth(this.value);
        this.puHeightInPixels = this.calculatePowerupBarHeight(this.puValue);
        this.lifeFlashTimer = -1L;
        this.doLifeFlash = false;
        this.puFlashTimer = -1L;
        this.doPuFlash = false;
        this.fullScrollOffset = 0;
        this.setPUIconPos((byte)0);
        this.puIconFrameIdx = equippedPowerup != -1 ? equippedPowerup : -1;
    }

    public void reset() {
        this.state = 0;
        this.targetValue = this.startValue;
        this.targetPuValue = 0L;
        this.value = this.startValue;
        this.puValue = 0L;
        this.lifeWidthInPixels = this.calculateLifeBarWidth(this.value);
        this.lifeFlashTimer = -1L;
        this.doLifeFlash = false;
        this.puFlashTimer = -1L;
        this.doPuFlash = false;
    }

    public void lifeAdjust(int newLifeValue) {
        if ((long)newLifeValue != this.value) {
            if (newLifeValue == 1000) {
                this.lifeFlashTimer = DashResourceProvider.getTime(1);
            } else if (this.value == 1000L && newLifeValue != 1000) {
                this.lifeFlashTimer = -1L;
            }
            this.targetValue = newLifeValue;
            this.state = 1;
        }
    }

    public void puMeterAdjust(int newPuMeterValue) {
        if (this.puIconFrameIdx == 7) {
            return;
        }
        if ((long)newPuMeterValue != this.puValue) {
            this.targetPuValue = newPuMeterValue;
        }
    }

    public void update() {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (this.value != this.targetValue) {
                    if (this.value > this.targetValue) {
                        if (this.value - this.targetValue > 20L) {
                            this.value -= 20L;
                        } else {
                            this.value = this.targetValue;
                            this.state = 0;
                        }
                    } else if (this.targetValue - this.value > 20L) {
                        this.value += 20L;
                    } else {
                        this.value = this.targetValue;
                        this.state = 0;
                    }
                } else {
                    this.value = this.targetValue;
                    this.state = 0;
                }
                this.lifeWidthInPixels = this.calculateLifeBarWidth(this.value);
                break;
            }
        }
        if (this.puValue != this.targetPuValue) {
            this.puValue = this.targetPuValue;
            this.puHeightInPixels = this.calculatePowerupBarHeight(this.puValue);
        }
        if (this.lifeFlashTimer > 0L && DashResourceProvider.getTime(1) - this.lifeFlashTimer > 1000L) {
            this.doLifeFlash = true;
            this.lifeFlashTimer = DashResourceProvider.getTime(1);
        }
        if (this.puFlashTimer > 0L && DashResourceProvider.getTime(1) - this.puFlashTimer > 800L) {
            this.doPuFlash = true;
            this.puFlashTimer = DashResourceProvider.getTime(1);
        }
        if (1000L == this.puValue) {
            ++this.fullFrameOffset;
            if (this.fullFrameOffset >= DashResourceProvider.getImage(68).getNumFrames()) {
                this.fullFrameOffset = 0;
            }
        } else {
            this.fullFrameOffset = 0;
        }
        if (this.pu_colorChangeTimer != -1L) {
            if (DashResourceProvider.getTime(1) > this.pu_colorChangeTimer + 1000L) {
                this.pu_colorChangeTimer = -1L;
                this.pu_fillColor = this.pu_targetColor;
            } else {
                this.pu_fillColor = DashResourceProvider.interpolateColors(this.pu_currColor, this.pu_targetColor, this.pu_colorChangeTimer, DashResourceProvider.getTime(1), this.pu_colorChangeTimer + 1000L);
            }
        }
    }

    public void draw(Graphics g, int posY) {
        boolean xpos = false;
        boolean ypos = false;
        DashImage imgLB = DashResourceProvider.getImage(67);
        DashImage imgPU = DashResourceProvider.getImage(68);
        int p_h = 6;
        if (1000L == this.value) {
            this.fullScrollOffset += 2;
            if (this.fullScrollOffset > imgLB.getWidth()) {
                this.fullScrollOffset = 0;
            }
        } else {
            this.fullScrollOffset = 0;
        }
        DashResourceProvider.getImage(66).draw(g, this.lifeBarX, this.lifeBarY, 20);
        g.setColor(DashEngine.MAKE_RGB(255, 0, 0));
        g.fillRect(this.fillX_l, this.fillY_l, this.lifeWidthInPixels, imgLB.getHeight());
        g.setClip(this.fillX_l, this.fillY_l, this.calculateLifeBarWidth(this.targetValue), imgLB.getHeight());
        imgLB.draw(g, this.fillX_l - this.fullScrollOffset, this.fillY_l, 20);
        if (this.fullScrollOffset != 0) {
            imgLB.draw(g, this.fillX_l - this.fullScrollOffset + imgLB.getWidth(), this.fillY_l, 20);
        }
        g.setClip(0, 0, DashResourceProvider.getScreenWidth(), DashResourceProvider.getScreenHeight());
        if (this.puHeightInPixels > 0) {
            g.setColor(this.pu_fillColor);
            g.fillRect(this.fillX_pu, this.fillY_pu + this.fillH_pu - this.puHeightInPixels, this.fillW_pu, this.puHeightInPixels);
        }
        if (this.puHeightInPixels > this.fillH_pu) {
            g.setColor(this.pu_fillColor);
            g.fillRect(this.fillX2_pu, this.fillY2_pu + this.fillH2_pu - (this.puHeightInPixels - this.fillH_pu), this.fillW2_pu, this.puHeightInPixels - this.fillH_pu);
        }
        imgPU.draw(g, this.puBarX, this.puBarY, this.fullFrameOffset, 20);
    }

    public void setPowerupTargetValue(int tv) {
        this.puTargetValue = tv;
    }

    public void powerupFlash(boolean start) {
        if (start) {
            if (this.puFlashTimer == -1L) {
                this.puFlashTimer = DashResourceProvider.getTime(1);
            }
        } else if (this.puFlashTimer > 0L) {
            this.puFlashTimer = -1L;
        }
    }

    int getBottom() {
        return this.puBarY + DashResourceProvider.getImage(66).getHeight();
    }

    int calculateLifeBarWidth(long lifeValue) {
        int barW = 0;
        barW = (int)((long)this.fillW_l * lifeValue * 1000L / 1000L) / 1000;
        return barW;
    }

    int calculatePowerupBarHeight(long puValue) {
        int barW = 0;
        barW = (int)((long)(this.fillH_pu + this.fillH2_pu) * puValue * 1000L / 1000L) / 1000;
        this.updatePUBarColor();
        return barW;
    }

    public void setPUIconPos(byte pos) {
        DashImage pui = DashResourceProvider.getImage(70);
        DashImage imgPU = DashResourceProvider.getImage(68);
        if (pos == 0) {
            this.puicon_posX = this.puBarX - imgPU.getWidth() * 5 / 4;
            this.puicon_posY = this.puBarY + imgPU.getHeight() / 2 - pui.getHeight() / 2;
        } else if (pos == 1) {
            this.puicon_posX = this.puBarX + imgPU.getWidth() / 2 - pui.getWidth() / 2;
            this.puicon_posY = this.puBarY + imgPU.getHeight() * 5 / 4;
        }
    }

    public void updatePUBarColor() {
        if (this.pu_colorChangeTimer != -1L) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.targetPuValue * 100L / 1000L >= (long)GameDefines.meter_colorChangeValues[i]) continue;
            this.pu_colorChangeTimer = DashResourceProvider.getTime(1);
            this.pu_currColor = this.pu_fillColor;
            this.pu_targetColor = GameDefines.pumeter_colorValues[i];
            break;
        }
    }
}

