/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Random;

public class GVUtil {
    public static final int STRING_BUFFER_SIZE = 400;
    private static StringBuffer sb;
    private static Random random;
    private static int tokenIdx;
    private static String strtoken;
    private static final int READ_BUFFER_SIZE = 1024;

    public static byte[] readFile(String fileName) {
        try {
            int readLen;
            InputStream is = fileName.getClass().getResourceAsStream(fileName);
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            while ((readLen = is.read(buffer)) != -1) {
                bo.write(buffer, 0, readLen);
            }
            is.close();
            byte[] data = bo.toByteArray();
            bo.close();
            return data;
        }
        catch (Exception e) {
            System.out.println("fail to read " + fileName + " e:" + e);
            return null;
        }
    }

    public static StringBuffer getSB() {
        if (sb == null) {
            sb = new StringBuffer(400);
        } else {
            sb.delete(0, 400);
        }
        return sb;
    }

    public static int getRect(int x, int y, int w, int h) {
        return ((byte)x & 0xFF) << 24 | ((byte)y & 0xFF) << 16 | w << 8 | h;
    }

    public static int getX(int rect) {
        return rect >>> 24;
    }

    public static int getY(int rect) {
        return rect >>> 16 & 0xFF;
    }

    public static int getSignedX(int rect) {
        int x = rect >>> 24;
        if (x > 127) {
            x -= 256;
        }
        return x;
    }

    public static int getSignedY(int rect) {
        int y = rect >>> 16 & 0xFF;
        if (y > 127) {
            y -= 256;
        }
        return y;
    }

    public static int getW(int rect) {
        return rect >>> 8 & 0xFF;
    }

    public static int getH(int rect) {
        return rect & 0xFF;
    }

    public static int randomInt() {
        if (random == null) {
            random = new Random();
        }
        return random.nextInt();
    }

    public static int randomInt(int max) {
        if (random == null) {
            random = new Random();
        }
        return Math.abs(random.nextInt()) % max;
    }

    public static void setStrTok(String s) {
        strtoken = s;
        tokenIdx = 0;
    }

    public static String nextToken(char deli) {
        int startIdx = tokenIdx;
        if (strtoken.length() <= startIdx) {
            return null;
        }
        tokenIdx = strtoken.indexOf(deli, startIdx);
        if (tokenIdx != -1) {
            String s = strtoken.substring(startIdx, tokenIdx);
            ++tokenIdx;
            return s;
        }
        return strtoken.substring(startIdx);
    }

    public static boolean hasNextToken() {
        return tokenIdx != -1 && strtoken.length() > tokenIdx;
    }

    public static String makeAuxilary(String src, int kind) {
        boolean bJongSung = GVUtil.isJongSung(src);
        switch (kind) {
            case 0: {
                if (bJongSung) {
                    return src + "\uc740";
                }
                return src + "\ub294";
            }
        }
        return src;
    }

    public static boolean isJongSung(String src) {
        if (src == null) {
            return true;
        }
        char c = (src = src.trim()).charAt(src.length() - 1);
        int jongSung = (c - 44032) % 28;
        if (jongSung > 0) {
            return true;
        }
        if (jongSung == 0) {
            return false;
        }
        if (c >= '0' && c <= '9') {
            switch (c) {
                case '0': 
                case '1': 
                case '3': 
                case '6': 
                case '7': 
                case '8': {
                    return true;
                }
            }
            return false;
        }
        switch (c) {
            case 'l': 
            case 'm': 
            case 'n': 
            case 'r': {
                return true;
            }
        }
        return false;
    }
}

