/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class Graphics {
    private Image backBuffer;
    public javax.microedition.lcdui.Graphics g;
    private int curColor = 0;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final short ANCHORS_NONE = 0;
    public static final short ANCHORS_HCENTER = 1;
    public static final short ANCHORS_VCENTER = 2;
    public static final short ANCHORS_LEFT = 4;
    public static final short ANCHORS_RIGHT = 8;
    public static final short ANCHORS_TOP = 16;
    public static final short ANCHORS_BOTTOM = 32;
    public static final short ANCHORS_TOP_CENTER = 17;
    public static final short ANCHORS_CENTER = 3;
    private static final short ANCHORS_HORIZONTAL = 13;
    private static final short ANCHORS_VERTICAL = 50;

    public void setGraphics(javax.microedition.lcdui.Graphics graphics) {
        this.g = graphics;
    }

    public final void setColor(int n) {
        this.curColor = 0xFF000000 | n;
        this.g.setColor(n);
    }

    public final void fillCircle(int n, int n2, int n3) {
        this.g.fillArc(n, n2, n3, n3, 0, 360);
    }

    public final void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    public final void fillRect(int n, int n2, int n3, int n4, int n5) {
        this.g.setColor(n5);
        this.g.fillRect(n, n2, n3, n4);
        this.g.setColor(this.curColor);
    }

    public final void drawRect(int n, int n2, int n3, int n4) {
        this.g.drawRect(n, n2, n3, n4);
    }

    public final void drawRect(int n, int n2, int n3, int n4, int n5) {
        this.g.setColor(n5);
        this.g.drawRect(n, n2, n3, n4);
        this.g.setColor(this.curColor);
    }

    public final void eraseRgn(int n, int n2, int n3, int n4) {
        this.g.setColor(0);
        this.g.fillRect(n, n2, n3, n4);
        this.g.setColor(this.curColor);
    }

    public final void eraseRgn(int[] nArray) {
        this.eraseRgn(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
    }

    public final void drawLine(int n, int n2, int n3, int n4, int n5) {
        this.g.setColor(n5);
        this.g.drawLine(n, n2, n3, n4);
        this.g.setColor(this.curColor);
    }

    public final void drawImage(Image image, int n, int n2) {
        this.g.drawImage(image, n, n2, 0);
    }

    public final void drawImage(Image image, int n, int n2, int n3) {
        this.g.drawImage(image, n, n2, n3);
    }

    public final void drawImage(Image image, int n, int n2, int n3, int n4) {
        this.drawRegion(image, 0, 0, image.getWidth(), image.getHeight(), n, n2, n3, n4);
    }

    public final void drawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRegion(image, n, n2, n3, n4, n5, n6, 0, 0);
    }

    public final int getClipX() {
        return this.g.getClipX();
    }

    public final int getClipY() {
        return this.g.getClipY();
    }

    public final int getClipWidth() {
        return this.g.getClipWidth();
    }

    public final int getClipHeight() {
        return this.g.getClipHeight();
    }

    public final int getTranslateX() {
        return this.g.getTranslateX();
    }

    public final int getTranslateY() {
        return this.g.getTranslateY();
    }

    public final void drawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        try {
            this.g.drawRegion(image, n, n2, n3, n4, n8, n5, n6, n7);
        }
        catch (Exception exception) {
            App.Error(exception, 110);
        }
    }

    public final void fillRegion(Image image, int n, int n2, int n3, int n4) {
        this.fillRegion(image, 0, 0, image.getWidth(), image.getHeight(), n, n2, n3, n4, 0);
    }

    public final void fillRegion(Image image, int n, int n2, int n3, int n4, int n5) {
        this.fillRegion(image, 0, 0, image.getWidth(), image.getHeight(), n, n2, n3, n4, n5);
    }

    public final void fillRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.fillRegion(image, n, n2, n3, n4, n5, n6, n7, n8, 0);
    }

    public final void fillRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int n12 = n11 + n8;
        for (n11 = n6; n11 < n12; n11 += n10) {
            int n13;
            int n14;
            int n15 = n14 + n7;
            n10 = Math.min(n4, n12 - n11);
            for (n14 = n5; n14 < n15; n14 += n13) {
                n13 = Math.min(n3, n15 - n14);
                this.drawRegion(image, n, n2, n13, n10, n14, n11, 0, n9);
            }
        }
    }

    public final void drawBevel(int n, int n2, int n3, int n4, int n5, int n6) {
        this.setColor(n);
        this.drawLine(n3, n4, n3, n4 + --n6);
        this.drawLine(n3, n4, n3 + --n5, n4);
        this.setColor(n2);
        this.drawLine(n3 + n5, n4, n3 + n5, n4 + n6);
        this.drawLine(n3, n4 + n6, n3 + n5, n4 + n6);
    }

    public final void drawString(Text text, int n, int n2, int n3) {
        this.drawString(Canvas.imgFont, text, n, n2, 12, n3, 0, text.length());
    }

    public final void drawString(Text text, int n, int n2, int n3, int n4, int n5) {
        this.drawString(Canvas.imgFont, text, n, n2, 12, n3, n4, n5);
    }

    public final void drawString(Text text, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawString(Canvas.imgFont, text, n, n2, n3, n4, n5, n6);
    }

    public final void drawString(Image image, Text text, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n6 == -1) {
            n6 = text.length();
        }
        if (n6 == 0) {
            return;
        }
        int n8 = text.getStringWidth(n5, n5 + n6, false);
        int n9 = n;
        if ((n4 & 8) != 0) {
            n9 = n -= n8;
        } else if ((n4 & 1) != 0) {
            n -= n8 / 2 + (n8 & 1);
        }
        if ((n4 & 0x20) != 0) {
            n2 -= n3;
        } else if ((n4 & 2) != 0) {
            n7 = text.getNumLines();
            n2 -= n3 * n7 / 2;
        }
        n7 = n5 + Math.min(n6, text.length() - n5);
        for (int i = n5; i < n7; ++i) {
            char c = text.charAt(i);
            if (c == '\n' || c == '|') {
                n2 += n3;
                if ((n4 & 1) != 0) {
                    n = n9 - text.getStringWidth(i + 1, n7, false) / 2;
                    continue;
                }
                n = n9;
                continue;
            }
            if (c == ' ' || c == '\u00a0') {
                n += 7;
                continue;
            }
            if (c == '\\' && i < n7) {
                int n10;
                if ((n10 = (c = text.charAt(++i)) - 65) < 0 || n10 >= 15) {
                    this.drawChar(image, c, n, n2);
                } else {
                    this.drawBuffIcon(n10, n, n2, 0);
                }
            } else {
                this.drawChar(image, c, n, n2);
            }
            n += 7;
        }
    }

    public final void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    public final void drawChar(Image image, char c, int n, int n2) {
        int[] nArray = Text.getCharIndices(c);
        int n3 = nArray[0];
        int n4 = nArray[3];
        if (n3 < 0 || n3 >= 144 || n4 < 0 || n4 >= 144) {
            n3 = 30;
            n4 = 0;
        }
        this.drawRegion(image, (n3 & 0xF) * 9, ((n3 & 0xF0) >> 4) * 12, 9, 12, c != '\u00ed' ? n + nArray[1] : n + nArray[1] + 2, n2 + nArray[2]);
        if (n4 != 0) {
            this.drawRegion(image, (n4 & 0xF) * 9, ((n4 & 0xF0) >> 4) * 12, 9, 12, n + nArray[4], n2 + nArray[5]);
        }
    }

    public final void drawBoxedString(Text text, int n, int n2, int n3, int n4, int n5) {
        int n6 = text.getStringWidth();
        int n7 = text.getNumLines() * 10 + n3 * 2;
        int n8 = n - n6 / 2 - n3;
        int n9 = n2 - n3;
        int n10 = n8 + n6 + n3 * 2;
        int n11 = n9 + n7;
        this.setColor(n4);
        this.fillRect(n8, n9, n6 + n3 * 2 + 1, n7 + 1);
        this.setColor(n5);
        this.drawLine(--n8, --n9, ++n10, n9);
        this.drawLine(n10, n9, n10, ++n11);
        this.drawLine(n8, n11, n10, n11);
        this.drawLine(n8, n9, n8, n11);
        this.drawString(text, n - 1, n2 + 1, 1);
    }

    public final void drawBuffIcon(int n, int n2, int n3, int n4) {
        this.drawRegion(Canvas.imgBuffIcons, 0, n * 12, 12, 12, n2, n3, n4, 0);
    }

    public final void drawCursor(int n, int n2, int n3) {
        this.drawCursor(n, n2, n3, true);
    }

    public final void drawCursor(int n, int n2, int n3, boolean bl) {
        Text text = Text.getSmallBuffer();
        text.setLength(0);
        if (bl) {
            text.append('\u008a');
        } else {
            text.append('\u0084');
        }
        this.drawString(text, n, n2, n3);
        text.dispose();
    }

    public final void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.g.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
    }

    public final void clipRect(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n2, n3, n4);
    }

    public final void clearClipRect() {
        this.g.setClip(0, 0, Canvas.displayRect[2], Canvas.displayRect[3]);
    }

    public final void setScreenSpace(int[] nArray) {
        this.g.translate(-this.g.getTranslateX(), -this.g.getTranslateY());
        this.g.setClip(nArray[0], nArray[1], nArray[2], nArray[3]);
        this.g.translate(nArray[0], nArray[1]);
    }

    public final void setScreenSpace(int n, int n2, int n3, int n4) {
        this.g.translate(-this.g.getTranslateX(), -this.g.getTranslateY());
        this.g.setClip(n, n2, n3, n4);
        this.g.translate(n, n2);
    }

    public final void resetScreenSpace() {
        this.setScreenSpace(Canvas.displayRect);
    }

    public final void copyTo(javax.microedition.lcdui.Graphics graphics) {
        graphics.drawImage(this.backBuffer, 0, 0, 0);
    }
}

