/*
 * Decompiled with CFR 0.152.
 */
import com.ea.sdk.SDKTextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class Text {
    public static final char C_LINE = '\u0080';
    public static final char C_ELLIPSES = '\u0085';
    public static final char C_RED_ING = '\u00bc';
    public static final char C_BLUE_ING = '\u00bd';
    public static final char C_GREEN_ING = '\u00be';
    public static final char C_CHECK = '\u0087';
    public static final char C_MINIDASH = '\u0088';
    public static final char C_CURSOR2 = '\u0084';
    public static final char C_CURSOR = '\u008a';
    public static final char C_POINTER = '\u0090';
    public static final char C_GREYLINE = '\u0089';
    public static final char C_HEART = '\u008d';
    public static final char C_SHIELD = '\u008b';
    public static final char HYPHEN = '-';
    public static final char NEWLINE = '|';
    public static final char HARD_SPACE = '\u00a0';
    public static final int FONT_WIDTH = 9;
    public static final int FONT_HEIGHT = 12;
    public static final int FONT_SPACING = 7;
    public static final int FONT_SPACE = 7;
    public static final int FONT_MAX = 144;
    public static final int FONT_MINCHAR = 33;
    public static final int FONT_MAXCHAR = 177;
    public static final int TEXT_TYPE_SHIFT = 10;
    public static final int TEXT_ID_MASK = 1023;
    public static final short TEXT_INVALID = -1;
    public static final int FONT_ACCENT_START = 121;
    private static final int USED = 1;
    private static final int FREE = 0;
    private byte[] chars;
    private int length = 0;
    private static char[] wordBreaks = new char[]{'|', '\n', '-', ' '};
    private static final int MAXBUFFERS = 7;
    private static Text[] scratchBuffers = new Text[7];
    private static int bufferFlags = 0;
    private static final int MAX_STRING_ARGS = 50;
    private static Text dynamicArgs = new Text(1024);
    private static short[] argIndex = new short[50];
    public static int numTextArgs = 0;
    public static boolean selectLanguage = false;
    public static int defaultLanguage = -1;
    private static int[] textSizes = new int[17];
    private static int[] textCount = new int[17];
    private static byte[][] text = new byte[17][];
    private static short[][] textMap = new short[17][];
    private static int[] textIndex;
    private static int textLastType;
    private static int textCurChunk;
    private static int textCurOffset;
    private static InputStream textChunkStream;
    private static final int[] indices;

    public static boolean startup() {
        Text.scratchBuffers[0] = new Text(2048);
        Text.scratchBuffers[1] = new Text(2048);
        Text.scratchBuffers[2] = new Text(2048);
        Text.scratchBuffers[3] = new Text(2048);
        Text.scratchBuffers[4] = new Text(2048);
        Text.scratchBuffers[5] = new Text(2048);
        Text.scratchBuffers[6] = new Text(2048);
        try {
            int[] nArray = textCount;
            nArray[0] = 57;
            nArray[1] = 208;
            nArray[2] = 201;
            nArray[3] = 16;
            nArray[4] = 8;
            nArray[5] = 314;
            nArray[6] = 121;
            nArray[7] = 79;
            nArray[8] = 65;
            nArray[9] = 102;
            nArray[10] = 2;
            nArray[11] = 71;
            nArray[12] = 70;
            nArray[13] = 63;
            nArray[14] = 62;
            nArray[15] = 3;
            nArray[16] = 3;
            Text.beginTextLoading();
            int[] nArray2 = textSizes;
            int[] nArray3 = textIndex;
            for (int i = 0; i < 5; ++i) {
                for (int j = 0; j < 17; ++j) {
                    nArray2[j] = Math.max(nArray2[j], nArray3[(j + i * 17) * 3 + 2]);
                }
            }
            Text.finishTextLoading();
            Text.allocateText(0);
            Text.allocateText(1);
            Text.allocateText(2);
            Text.allocateText(4);
            Text.allocateText(5);
            Text.allocateText(16);
            String string = App.app.getAppProperty("Force-Locale");
            if (string != null && string.length() != 0) {
                string = string.toLowerCase();
            }
            if (null == string || string.startsWith("auto-")) {
                string = System.getProperty("microedition.locale").toLowerCase();
                defaultLanguage = Text.identifyLocale(string);
                if (defaultLanguage == -1 && string.startsWith("auto-")) {
                    defaultLanguage = Text.identifyLocale(string.substring(4));
                }
            } else {
                defaultLanguage = string.equals("menu") ? -1 : (string.equals("cz") ? 0 : (string.equals("pl") ? 1 : (string.equals("pt") ? 2 : (string.equals("ru") ? 3 : (string.equals("tr") ? 4 : Text.identifyLocale(string))))));
            }
            boolean bl = selectLanguage = defaultLanguage == -1;
            if (selectLanguage) {
                defaultLanguage = 0;
            }
            App.checkPausedState();
            Text.beginTextLoading();
            Text.loadTextFromIndex(defaultLanguage, 0);
            Text.loadTextFromIndex(defaultLanguage, 1);
            Text.loadTextFromIndex(defaultLanguage, 2);
            Text.loadTextFromIndex(defaultLanguage, 4);
            Text.loadTextFromIndex(defaultLanguage, 5);
            Text.loadTextFromIndex(defaultLanguage, 16);
            Text.finishTextLoading();
            SDKTextUtils.setCurrentLanguage(defaultLanguage);
        }
        catch (IOException iOException) {
            App.Error(iOException, 666);
        }
        Text.resetTextArgs();
        return true;
    }

    public Text(int n) {
        this.chars = new byte[n];
    }

    public int length() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = Math.max(n, 0);
    }

    public Text delete(int n) {
        return this.delete(n, 1);
    }

    public Text delete(int n, int n2) {
        System.arraycopy(this.chars, n + n2, this.chars, n, this.length - (n + n2));
        this.length -= n2;
        return this;
    }

    public char charAt(int n) {
        return (char)(this.chars[n] & 0xFF);
    }

    public void setCharAt(char c, int n) {
        this.chars[n] = (byte)c;
    }

    public Text append(char c) {
        this.chars[this.length++] = (byte)c;
        return this;
    }

    public Text append(byte by) {
        this.chars[this.length++] = by;
        return this;
    }

    public Text append(long l) {
        this.insert(l, this.length);
        return this;
    }

    public Text append(int n) {
        this.insert(n, this.length);
        return this;
    }

    public Text append(int n, int n2) {
        this.insert(n, n2, this.length);
        return this;
    }

    public void appendTextArg(int n) {
        short s = 0;
        short s2 = argIndex[n];
        if (n > 0) {
            s = argIndex[n - 1];
        }
        dynamicArgs.substring(this, s, s2 - s);
    }

    public Text append(Text text) {
        return this.append(text, 0, text.length);
    }

    public Text append(Text text, int n) {
        return this.append(text, n, text.length - n);
    }

    public Text append(Text text, int n, int n2) {
        if (n2 > 0) {
            System.arraycopy(text.chars, n, this.chars, this.length, n2);
            this.length += n2;
        }
        return this;
    }

    public Text append(String string) {
        return this.append(string, 0, string.length());
    }

    public Text append(String string, int n) {
        return this.append(string, n, string.length() - n);
    }

    public Text append(String string, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            this.chars[this.length++] = (byte)string.charAt(i);
        }
        return this;
    }

    public Text insert(char c, int n) {
        System.arraycopy(this.chars, n, this.chars, n + 1, this.length - n);
        this.chars[n] = (byte)c;
        ++this.length;
        return this;
    }

    public Text insert(byte by, int n) {
        System.arraycopy(this.chars, n, this.chars, n + 1, this.length - n);
        this.chars[n] = by;
        ++this.length;
        return this;
    }

    public Text insert(long l, int n) {
        if (l < 0L) {
            this.insert('-', n);
            ++n;
            l = -l;
        }
        do {
            this.insert((char)(48L + l % 10L), n);
        } while ((l /= 10L) != 0L);
        return this;
    }

    public Text insert(int n, int n2) {
        if (n < 0) {
            this.insert('-', n2);
            ++n2;
            n = -n;
        }
        do {
            this.insert((char)(48 + n % 10), n2);
        } while ((n /= 10) != 0);
        return this;
    }

    public Text insert(int n, int n2, int n3) {
        if (n < 0) {
            this.insert('-', n3);
            ++n3;
            n = -n;
        }
        int n4 = this.length;
        this.insert(n >> n2, n3);
        this.insert('.', n3 + (this.length - n4));
        this.insert(n & (1 << n2) - 1, n3 + (this.length - n4));
        return this;
    }

    public Text insert(Text text, int n) {
        return this.insert(text, 0, text.length, n);
    }

    public Text insert(Text text, int n, int n2) {
        return this.insert(text, n, text.length - n, n2);
    }

    public Text insert(Text text, int n, int n2, int n3) {
        System.arraycopy(this.chars, n3, this.chars, n3 + n2, this.length - n3);
        System.arraycopy(text.chars, n, this.chars, n3, n2);
        this.length += n2;
        return this;
    }

    public Text insert(String string, int n) {
        return this.insert(string, 0, string.length(), n);
    }

    public Text insert(String string, int n, int n2) {
        return this.insert(string, n, string.length() - n, n2);
    }

    public Text insert(String string, int n, int n2, int n3) {
        System.arraycopy(this.chars, n3, this.chars, n3 + n2, this.length - n3);
        this.length += n2;
        while (--n2 >= 0) {
            this.chars[n3++] = (byte)string.charAt(n++);
        }
        return this;
    }

    public int findFirstOf(char c) {
        return this.findFirstOf(c, 0);
    }

    public int findFirstOf(char c, int n) {
        while (n < this.length) {
            if (this.chars[n] == c) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findAnyFirstOf(char[] cArray) {
        return this.findAnyFirstOf(cArray, 0);
    }

    public int findAnyFirstOf(char[] cArray, int n) {
        while (n < this.length) {
            for (int i = 0; i < cArray.length; ++i) {
                if (this.chars[n] != cArray[i]) continue;
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findFirstOf(String string) {
        return this.findFirstOf(string, 0);
    }

    public int findFirstOf(String string, int n) {
        int n2 = 0;
        int n3 = n;
        if (string.length() == 0) {
            return -1;
        }
        while (n < this.length) {
            if (this.chars[n] != string.charAt(n2)) {
                n = ++n3;
                n2 = 0;
                continue;
            }
            if (++n2 == string.length()) {
                return n3;
            }
            ++n;
        }
        return -1;
    }

    public int findLastOf(char c) {
        return this.findLastOf(c, this.length);
    }

    public int findLastOf(char c, int n) {
        while (--n >= 0) {
            if (this.chars[n] != c) continue;
            return n;
        }
        return -1;
    }

    public int findAnyLastOf(char[] cArray) {
        return this.findAnyLastOf(cArray, this.length);
    }

    public int findAnyLastOf(char[] cArray, int n) {
        while (--n >= 0 && n < this.length) {
            for (int i = 0; i < cArray.length; ++i) {
                if (this.chars[n] != cArray[i]) continue;
                return n;
            }
        }
        return -1;
    }

    public void substring(Text text) {
        this.substring(text, 0, this.length);
    }

    public void substring(Text text, int n) {
        this.substring(text, n, this.length - n);
    }

    public void substring(Text text, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            text.chars[text.length++] = this.chars[i];
        }
    }

    public void dehyphenate() {
        this.dehyphenate(0, this.length);
    }

    public void dehyphenate(int n) {
        this.dehyphenate(n, this.length - n);
    }

    public void dehyphenate(int n, int n2) {
        int n3;
        while ((n3 = this.findFirstOf('-', n)) != -1 && n3 < n + n2) {
            this.delete(n3);
            n2 -= n3 - n + 2;
            n = ++n3;
        }
    }

    public void trim() {
        this.trim(true, true);
    }

    public void trim(boolean bl, boolean bl2) {
        if (bl) {
            while (this.length > 0 && this.chars[0] == 32) {
                this.delete(0);
            }
        }
        if (bl2) {
            while (this.length > 0 && this.chars[this.length - 1] == 32) {
                this.delete(this.length - 1);
            }
        }
    }

    public int wrapText(int n) {
        return this.wrapText(0, n, -1, '|');
    }

    public int wrapText(int n, char c) {
        return this.wrapText(0, n, -1, c);
    }

    public int wrapText(int n, int n2, char c) {
        return this.wrapText(0, n, n2, c);
    }

    public int wrapText(int n, int n2, int n3, char c) {
        int n4;
        int n5 = this.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n;
        int n10 = 0;
        boolean bl = false;
        byte[] byArray = this.chars;
        while ((n4 = this.findAnyFirstOf(wordBreaks, n)) != -1) {
            int n11;
            n7 += n4 - n;
            if (!bl && n10 == 45) {
                --n7;
            }
            if ((n11 = n7 + (byArray[n4] == 45 ? 1 : 0)) > n2 || n10 == 124 || n10 == 10) {
                n6 += n - n9;
                if (bl) {
                    --n;
                }
                n9 = this.insertLineBreak(n9, n - 1, c);
                n = n9 + 1;
                ++n8;
                while (n < this.length && n8 < n3 && (byArray[n - 1] == 124 || byArray[n - 1] == 10)) {
                    ++n8;
                    ++n;
                    ++n9;
                }
                n7 = 1;
                n10 = 0;
                bl = false;
                if (n3 <= 0 || n8 != n3) continue;
                this.length = n9;
                return n6;
            }
            bl = false;
            n10 = (char)byArray[n4];
            n = n4 + 1;
            ++n7;
            if (n10 != 45 || byArray[n] != 45) continue;
            bl = true;
            ++n;
        }
        n7 += this.length - n;
        if (!bl && n10 == 45) {
            --n7;
        }
        if (n7 > n2 || n10 == 124 || n10 == 10) {
            n6 += n - n9;
            if (bl) {
                --n;
            }
            n9 = this.insertLineBreak(n9, n - 1, c);
            n = n9 + 1;
            if (n3 > 0 && ++n8 == n3) {
                this.length = n9;
                return n6;
            }
        }
        this.dehyphenate(n9, this.length - n9);
        return n5;
    }

    private int insertLineBreak(int n, int n2, char c) {
        if (this.chars[n2] == 45) {
            if (this.chars[++n2] == 45) {
                this.chars[n2] = (byte)c;
            } else {
                this.insert(c, n2);
            }
        } else {
            this.chars[n2] = (byte)c;
        }
        int n3 = this.length;
        this.dehyphenate(n, n2 - n - 1);
        return n2 - (n3 - this.length) + 1;
    }

    public int parseInt() {
        return this.parseInt(0);
    }

    public int parseInt(int n) {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = n; i < this.length; ++i) {
            char c = (char)this.chars[i];
            if (bl) {
                if (!Text.isDigit(c)) break;
                n2 *= 10;
                n2 += c - 48;
                continue;
            }
            if (Text.isDigit(c) || c == '-') {
                bl2 = c == '-';
                bl = true;
                continue;
            }
            if (!Text.isSpace(c)) break;
        }
        if (bl2) {
            n2 = -n2;
        }
        return n2;
    }

    public final int getStringWidth() {
        return this.getStringWidth(0, this.length, true);
    }

    public final int getStringWidth(boolean bl) {
        return this.getStringWidth(0, this.length, bl);
    }

    public final int getStringWidth(int n, int n2) {
        return this.getStringWidth(n, n2, true);
    }

    public final int getStringWidth(int n, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        if (n2 == -1 || n2 >= this.length) {
            n2 = this.length;
        }
        if (n >= 0 && n < n2) {
            for (int i = n; i < n2; ++i) {
                char c = (char)this.chars[i];
                if (c == '\n' || c == '|') {
                    if (!bl) break;
                    if (n4 <= n3) continue;
                    n3 = n4;
                    n4 = 0;
                    continue;
                }
                if (c == ' ') {
                    n4 += 7;
                    continue;
                }
                n4 += 7;
            }
        }
        if (n4 > n3) {
            n3 = n4;
        }
        return n3;
    }

    public final int getNumLines() {
        int n = 1;
        for (int i = 0; i < this.length; ++i) {
            char c = (char)this.chars[i];
            if (c != '\n' && c != '|') continue;
            ++n;
        }
        return n;
    }

    public boolean compareTo(Text text) {
        boolean bl = text.length == this.length;
        for (int i = 0; bl && i < this.length; ++i) {
            bl = bl && text.chars[i] == this.chars[i];
        }
        return bl;
    }

    public boolean compareTo(String string) {
        boolean bl = string.length() == this.length;
        for (int i = 0; bl && i < this.length; ++i) {
            bl = bl && string.charAt(i) == this.chars[i];
        }
        return bl;
    }

    public void toLower() {
        for (int i = 0; i < this.length; ++i) {
            this.chars[i] = (byte)Text.toLower((char)this.chars[i]);
        }
    }

    public void toUpper() {
        for (int i = 0; i < this.length; ++i) {
            this.chars[i] = (byte)Text.toUpper((char)this.chars[i]);
        }
    }

    public Text print() {
        this.print(System.out, 0, this.length);
        return this;
    }

    public Text print(int n) {
        this.print(System.out, n, this.length - n);
        return this;
    }

    public Text print(PrintStream printStream, int n, int n2) {
        for (int i = n; i < n2 + n; ++i) {
            int n3 = this.chars[i];
            if (n3 == 124) {
                printStream.print('|');
                n3 = 10;
            }
            printStream.print((char)n3);
        }
        return this;
    }

    public String toString() {
        return "Unsupported";
    }

    public void dispose() {
        for (int i = 0; i < 7; ++i) {
            if (scratchBuffers[i] != this) continue;
            bufferFlags &= ~(1 << i);
            this.setLength(0);
            return;
        }
    }

    public static boolean isSpace(char c) {
        return c == ' ' || c == '\n' || c == '|' || c == '\r' || c == '\t';
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static char toLower(char c) {
        if (c >= 'A' && c <= 'Z') {
            return (char)(c - 65 + 97);
        }
        return c;
    }

    public static char toUpper(char c) {
        if (c >= 'a' && c <= 'z') {
            return (char)(c - 97 + 65);
        }
        return c;
    }

    public static Text getSmallBuffer() {
        for (int i = 6; i >= 0; --i) {
            if ((bufferFlags & 1 << i) != 0) continue;
            bufferFlags |= 1 << i;
            return scratchBuffers[i];
        }
        return null;
    }

    public static Text getFatalErrorBuffer() {
        scratchBuffers[0].setLength(0);
        return scratchBuffers[0];
    }

    public static Text getLargeBuffer() {
        for (int i = 0; i < 7; ++i) {
            if ((bufferFlags & 1 << i) != 0) continue;
            bufferFlags |= 1 << i;
            return scratchBuffers[i];
        }
        return null;
    }

    public static void freeAllBuffers() {
        bufferFlags = 0;
        for (int i = 0; i < 7; ++i) {
            scratchBuffers[i].setLength(0);
        }
    }

    public static final void allocateText(int n) {
        Text.text[n] = new byte[textSizes[n]];
        Text.textMap[n] = new short[textCount[n]];
    }

    public static final void unloadText(int n) {
        if (text[n] != null) {
            Text.text[n] = null;
            Text.textMap[n] = null;
            System.gc();
        }
    }

    public static final int identifyLocale(String string) {
        int n = defaultLanguage;
        if (string == null) {
            return n;
        }
        try {
            String string2 = "";
            if (string.length() > 3 && string.charAt(2) == '-') {
                string2 = "," + string.substring(0, 2) + ",";
            }
            string = "," + string + ",";
            Text text = Text.getSmallBuffer();
            Text.beginTextLoading();
            for (int i = 0; i < 5; ++i) {
                Text.loadTextFromIndex(i, 16);
                text.setLength(0);
                Text.composeText((short)16, (short)1, text);
                text.insert(',', 0);
                text.append(',');
                if (text.findFirstOf(string) == -1 && text.findFirstOf(string2) == -1) continue;
                n = i;
                break;
            }
            Text.finishTextLoading();
            text.dispose();
        }
        catch (IOException iOException) {
            App.Error(iOException, 666);
        }
        return n;
    }

    public static final void setLanguage(int n) {
        try {
            defaultLanguage = n;
            Text.beginTextLoading();
            for (int i = 0; i < 17; ++i) {
                if (text[i] == null) continue;
                Text.loadTextFromIndex(defaultLanguage, i);
            }
            Text.finishTextLoading();
            SDKTextUtils.setCurrentLanguage(n);
        }
        catch (IOException iOException) {
            App.Error(iOException, 666);
        }
    }

    public static final void beginTextLoading() throws IOException {
        textIndex = Resource.loadFileIndex("/strings.idx");
        textLastType = -1;
        textCurChunk = -1;
    }

    public static final void finishTextLoading() {
        textIndex = null;
        textChunkStream = null;
    }

    public static final void loadTextFromIndex(int n, int n2) {
        try {
            if (n2 < textLastType) {
                App.Error(87);
            }
            textLastType = n2;
            int n3 = textIndex[(n2 + n * 17) * 3];
            int n4 = textIndex[(n2 + n * 17) * 3 + 1];
            int n5 = textIndex[(n2 + n * 17) * 3 + 2];
            if (textCurChunk != n3) {
                textChunkStream = App.getResourceAsStream("/strings" + n3 + ".bin");
                textCurOffset = 0;
                textCurChunk = n3;
            }
            InputStream inputStream = textChunkStream;
            if (n4 != textCurOffset) {
                Resource.bufSkip(inputStream, n4 - textCurOffset, false);
                textCurOffset += n4 - textCurOffset;
            }
            Resource.readByteArray(inputStream, text[n2], 0, n5);
            textCurOffset += n5;
            inputStream = null;
            short[] sArray = textMap[n2];
            byte[] byArray = text[n2];
            int n6 = 0;
            sArray[n6++] = 0;
            for (int i = 0; i < n5; ++i) {
                if (byArray[i] != 0) continue;
                sArray[n6++] = (short)(i + 1);
            }
        }
        catch (Exception exception) {
            App.Error(exception, 88);
        }
    }

    public static final void loadText(int n) {
        try {
            Text.allocateText(n);
            Text.beginTextLoading();
            Text.loadTextFromIndex(defaultLanguage, n);
            Text.finishTextLoading();
        }
        catch (IOException iOException) {
            App.Error(iOException, 666);
        }
    }

    public static final void resetTextArgs() {
        numTextArgs = 0;
        dynamicArgs.setLength(0);
    }

    public static final void addTextArg(boolean bl) {
        if (bl) {
            Text.composeText((short)5, (short)180, dynamicArgs);
        } else {
            Text.composeText((short)5, (short)181, dynamicArgs);
        }
        Text.argIndex[Text.numTextArgs++] = (short)dynamicArgs.length();
    }

    public static final void addTextArg(char c) {
        if (numTextArgs + 1 >= 50) {
            App.Error(new Exception("Added too many String Args"), 50);
        }
        dynamicArgs.append(c);
        Text.argIndex[Text.numTextArgs++] = (short)dynamicArgs.length();
    }

    public static final void addTextArg(int n) {
        if (numTextArgs + 1 >= 50) {
            App.Error(new Exception("Added too many String Args"), 50);
        }
        dynamicArgs.append(n);
        Text.argIndex[Text.numTextArgs++] = (short)dynamicArgs.length();
    }

    public static final void addTextArg(Text text, int n, int n2) {
        if (numTextArgs + 1 >= 50) {
            App.Error(new Exception("Added too many String Args"), 50);
        }
        text.substring(dynamicArgs, n, n2 - n);
        Text.argIndex[Text.numTextArgs++] = (short)dynamicArgs.length();
    }

    public static final void addTextArg(Text text) {
        if (numTextArgs + 1 >= 50) {
            App.Error(new Exception("Added too many String Args"), 50);
        }
        dynamicArgs.append(text);
        Text.argIndex[Text.numTextArgs++] = (short)dynamicArgs.length();
    }

    public static final void addTextArg(String string) {
        if (numTextArgs + 1 >= 50) {
            App.Error(new Exception("Added too many String Args"), 50);
        }
        dynamicArgs.append(string);
        Text.argIndex[Text.numTextArgs++] = (short)dynamicArgs.length();
    }

    public static final void addTextIDArg(short s) {
        Text.addTextArg((short)(s >> 10 & 0x1F), (short)(s & 0x3FF));
    }

    public static final void addTextArg(short s, short s2) {
        Text text = Text.getLargeBuffer();
        Text.composeText(s, s2, text);
        Text.addTextArg(text);
        text.dispose();
    }

    public static final int STRINGID(short s, short s2) {
        return s << 10 | s2;
    }

    public static final void composeText(int n, Text text) {
        Text.composeText((short)(n >> 10 & 0x1F), (short)(n & 0x3FF), text);
    }

    public static final void composeText(short s, short s2, Text text) {
        byte[] byArray = Text.text[s];
        if (byArray == null) {
            App.Error(85);
        }
        if (s2 < 0 || s2 > textMap[s].length) {
            App.Error(84);
        }
        short s3 = textMap[s][s2];
        int n = byArray[s3] & 0xFF;
        while (n != 0) {
            if (n == 92) {
                n = byArray[s3 = (short)(s3 + 1)];
                if (n == 37) {
                    text.append((char)n);
                } else if (n == 110) {
                    text.append('\n');
                } else {
                    text.append('\\');
                    text.append((char)n);
                }
            } else if (n == 37) {
                s3 = (short)(s3 + 1);
                n = byArray[s3];
                s3 = (short)(s3 + 1);
                int n2 = (n - 48) * 10 + (byArray[s3] - 48);
                if (--n2 < 0 || n2 >= numTextArgs) {
                    App.Error(86);
                }
                text.appendTextArg(n2);
            } else {
                text.append((char)n);
            }
            s3 = (short)(s3 + 1);
            n = byArray[s3] & 0xFF;
        }
    }

    public static void composeTextField(int n, Text text) {
        Text.composeText((short)(n >> 10), (short)(n & 0x3FF), text);
    }

    public static int[] getCharIndices(char c) {
        char c2 = c;
        int n = c2 - 33;
        int n2 = 0;
        Text.indices[5] = 0;
        Text.indices[4] = 0;
        Text.indices[2] = 0;
        Text.indices[1] = 0;
        switch (c2) {
            case '\u0085': {
                n = 94;
                break;
            }
            case '\u00a6': {
                n = 124;
                break;
            }
            case '\u00b0': {
                n = 126;
                break;
            }
            case '\u00ba': {
                n = 63;
                break;
            }
            case '\u00a9': {
                n = 106;
                break;
            }
            case '\u00aa': {
                n = 135;
                Text.indices[2] = -3;
                break;
            }
            case '\u00f5': {
                n = 128;
                Text.indices[2] = -3;
                break;
            }
            case '\u00f6': {
                n = 131;
                Text.indices[2] = -3;
                break;
            }
            case '\u0099': {
                n = 107;
                break;
            }
            case '\u008c': {
                n = 142;
                break;
            }
            case '\u009c': {
                n = 143;
                break;
            }
            case '\u00bf': {
                n = 119;
                break;
            }
            case '\u00a1': {
                n = 120;
                break;
            }
            case '\u00a2': {
                n = 127;
                break;
            }
            case '\u00e7': {
                n = 116;
                break;
            }
            case '\u008d': {
                n = 100;
                break;
            }
            case '\u008b': {
                n = 101;
                break;
            }
            case '\u00bc': 
            case '\u00bd': 
            case '\u00be': {
                n = c2 - 188 + 108;
                break;
            }
            case '\u00d8': {
                n = 46;
                n2 = 14;
                break;
            }
            case '\u00c0': 
            case '\u00c1': 
            case '\u00c2': 
            case '\u00c3': 
            case '\u00c4': 
            case '\u00c5': {
                n2 = 121 + (c2 - 192);
                n = 128;
                break;
            }
            case '\u00c6': {
                n2 = 120;
                n = 132;
                break;
            }
            case '\u00c8': 
            case '\u00c9': 
            case '\u00ca': 
            case '\u00cb': {
                n2 = 121 + (c2 - 200);
                if (c2 == '\u00cb') {
                    ++n2;
                }
                n = 129;
                break;
            }
            case '\u00cc': 
            case '\u00cd': 
            case '\u00ce': 
            case '\u00cf': {
                n2 = 121 + (c2 - 204);
                if (c2 == '\u00cf') {
                    ++n2;
                }
                n = 130;
                break;
            }
            case '\u00d2': 
            case '\u00d3': 
            case '\u00d4': 
            case '\u00d5': 
            case '\u00d6': {
                n2 = 121 + (c2 - 210);
                n = 131;
                break;
            }
            case '\u00d9': 
            case '\u00da': 
            case '\u00db': 
            case '\u00dc': {
                n2 = 121 + (c2 - 217);
                if (c2 == '\u00dc') {
                    ++n2;
                }
                n = 132;
                break;
            }
            case '\u00d1': {
                n = 134;
                n2 = 124;
                break;
            }
            case '\u00dd': {
                n = 133;
                n2 = 122;
                break;
            }
            case '\u00d0': {
                n = 83;
                n2 = 0;
                break;
            }
            case '\u00de': {
                n = 84;
                n2 = 0;
                break;
            }
            case '\u00df': {
                n2 = 122;
                n = 135;
                break;
            }
            case '\u00e0': {
                n2 = 120;
                n = 135;
                break;
            }
            case '\u00e1': {
                n2 = 120;
                n = 136;
                break;
            }
            case '\u00e2': {
                n = 85;
                n2 = 0;
                break;
            }
            case '\u00e3': {
                n2 = 120;
                n = 129;
                break;
            }
            case '\u00e4': {
                n2 = 120;
                n = 137;
                break;
            }
            case '\u00e5': {
                n2 = 126;
                n = 130;
                break;
            }
            case '\u00e6': {
                n = 86;
                n2 = 0;
                break;
            }
            case '\u00e8': {
                n = 122;
                n2 = 134;
                break;
            }
            case '\u00e9': {
                n = 120;
                n2 = 134;
                break;
            }
            case '\u00ea': {
                n = 142;
                n2 = 0;
                break;
            }
            case '\u00eb': {
                n = 120;
                n2 = 138;
                break;
            }
            case '\u00ec': {
                n = 122;
                n2 = 139;
                break;
            }
            case '\u00ed': {
                n = 0;
                n2 = 87;
                break;
            }
            case '\u00ee': {
                n = 120;
                n2 = 139;
                break;
            }
            case '\u00ef': {
                n = 120;
                n2 = 140;
                break;
            }
            case '\u00f0': {
                n = 126;
                n2 = 132;
                break;
            }
            case '\u00f1': {
                n = 125;
                n2 = 133;
                break;
            }
            case '\u00f2': {
                n = 122;
                n2 = 141;
                break;
            }
            case '\u00f3': {
                n = 126;
                n2 = 141;
                break;
            }
            case '\u00f4': {
                n = 120;
                n2 = 141;
                break;
            }
            case '\u00f7': {
                n = 12;
                n2 = 0;
            }
        }
        Text.indices[0] = (char)n;
        Text.indices[3] = (char)n2;
        return indices;
    }

    private static void Test() {
    }

    static {
        indices = new int[6];
    }
}

