/*
 * Decompiled with CFR 0.152.
 */
package Sprites;

import Frame.CLayer;
import OI.CObjectCommon;
import Objects.CObject;
import RunLoop.CCreateObjectInfo;
import RunLoop.CRun;
import Sprites.CSprite;
import Sprites.CSpriteGen;
import Transitions.CTrans;

public class CRSpr {
    public static final short RSFLAG_HIDDEN = 1;
    public static final short RSFLAG_INACTIVE = 2;
    public static final short RSFLAG_SLEEPING = 4;
    public static final short RSFLAG_SCALE_RESAMPLE = 8;
    public static final short RSFLAG_ROTATE_ANTIA = 16;
    public static final short RSFLAG_VISIBLE = 32;
    public static final short SPRTYPE_TRUESPRITE = 0;
    public static final short SPRTYPE_OWNERDRAW = 1;
    public static final short SPRTYPE_QUICKDISPLAY = 2;
    public CObject hoPtr;
    public CSpriteGen spriteGen;
    public int rsFlash;
    public int rsFlashCpt;
    public short rsLayer;
    public int rsZOrder;
    public int rsCreaFlags;
    public int rsBackColor;
    public int rsEffect;
    public int rsEffectParam;
    public short rsFlags;
    public short rsFadeCreaFlags;
    public short rsSpriteType;
    public CTrans rsTrans = null;

    public void init1(CObject cObject, CObjectCommon cObjectCommon, CCreateObjectInfo cCreateObjectInfo) {
        this.hoPtr = cObject;
        this.spriteGen = cObject.hoAdRunHeader.spriteGen;
        this.rsLayer = (short)cCreateObjectInfo.cobLayer;
        this.rsZOrder = cCreateObjectInfo.cobZOrder;
        this.rsCreaFlags = 1;
        if ((this.hoPtr.hoLimitFlags & 0x100) == 0) {
            this.rsCreaFlags &= 0xFFFFFFFE;
        }
        this.rsBackColor = 0;
        if ((this.hoPtr.hoOEFlags & 4) == 0 || (this.hoPtr.hoOiList.oilOCFlags2 & 1) != 0) {
            this.hoPtr.hoOEFlags &= 0xFFFFFFFB;
            this.rsCreaFlags |= 0x200;
            if ((this.hoPtr.hoOiList.oilOCFlags2 & 2) != 0) {
                this.rsBackColor = this.hoPtr.hoOiList.oilBackColor;
                this.rsCreaFlags |= 0x400;
            }
        }
        if ((this.hoPtr.hoOEFlags & 0x400) != 0) {
            this.rsCreaFlags |= 0x4000;
        }
        if ((this.hoPtr.hoOiList.oilOCFlags2 & 4) != 0) {
            this.rsCreaFlags |= 0x100;
        }
        if ((cCreateObjectInfo.cobFlags & 2) != 0) {
            this.rsCreaFlags |= 0x80;
            this.rsFlags = 1;
            if (this.hoPtr.hoType == 3) {
                this.hoPtr.hoFlags = (short)(this.hoPtr.hoFlags | 0x2000);
            }
        } else {
            this.rsFlags = (short)(this.rsFlags | 0x20);
        }
        this.rsEffect = this.hoPtr.hoOiList.oilInkEffect;
        this.rsEffectParam = this.hoPtr.hoOiList.oilEffectParam;
        if (this.hoPtr.roc.rcMovementType == 0) {
            this.rsFlags = (short)(this.rsFlags | 2);
            this.rsCreaFlags |= 8;
        }
        this.rsFadeCreaFlags = (short)this.rsCreaFlags;
    }

    public void init2() {
        this.createSprite(null);
    }

    public void displayRoutine() {
        switch (this.rsSpriteType) {
            case 0: {
                if (this.hoPtr.roc.rcSprite == null) break;
                this.spriteGen.modifSpriteEx(this.hoPtr.roc.rcSprite, this.hoPtr.hoX - this.hoPtr.hoAdRunHeader.rhWindowX, this.hoPtr.hoY - this.hoPtr.hoAdRunHeader.rhWindowY, this.hoPtr.roc.rcImage, this.hoPtr.roc.rcScaleX, this.hoPtr.roc.rcScaleY, (this.hoPtr.ros.rsFlags & 8) != 0, this.hoPtr.roc.rcAngle, (this.hoPtr.ros.rsFlags & 0x10) != 0);
                break;
            }
            case 1: {
                if (this.hoPtr.roc.rcSprite == null) break;
                this.spriteGen.activeSprite(this.hoPtr.roc.rcSprite, 1, null);
                break;
            }
            case 2: {
                this.hoPtr.hoAdRunHeader.display_OwnerQuickDisplay(this.hoPtr);
            }
        }
    }

    public void handle() {
        CRun cRun = this.hoPtr.hoAdRunHeader;
        if ((this.rsFlags & 4) == 0) {
            if (this.rsFlash != 0) {
                this.rsFlashCpt -= cRun.rhTimerDelta;
                if (this.rsFlashCpt < 0) {
                    this.rsFlashCpt = this.rsFlash;
                    if ((this.rsFlags & 0x20) == 0) {
                        this.rsFlags = (short)(this.rsFlags | 0x20);
                        this.obShow();
                    } else {
                        this.rsFlags = (short)(this.rsFlags & 0xFFFFFFDF);
                        this.obHide();
                    }
                }
            }
            if (this.hoPtr.rom != null) {
                this.hoPtr.rom.move();
            }
            if (this.hoPtr.roc.rcPlayer != 0) {
                return;
            }
            if ((this.hoPtr.hoOEFlags & 0x4000) != 0) {
                return;
            }
            int n = this.hoPtr.hoX - this.hoPtr.hoImgXSpot;
            int n2 = this.hoPtr.hoY - this.hoPtr.hoImgYSpot;
            int n3 = n + this.hoPtr.hoImgWidth;
            int n4 = n2 + this.hoPtr.hoImgHeight;
            if (n3 >= cRun.rh3XMinimum && n <= cRun.rh3XMaximum && n4 >= cRun.rh3YMinimum && n2 <= cRun.rh3YMaximum) {
                return;
            }
            if (n3 >= cRun.rh3XMinimumKill && n <= cRun.rh3XMaximumKill && n4 >= cRun.rh3YMinimumKill && n2 <= cRun.rh3YMaximumKill) {
                this.rsFlags = (short)(this.rsFlags | 4);
                if (this.hoPtr.roc.rcSprite != null) {
                    this.rsZOrder = this.hoPtr.roc.rcSprite.sprZOrder;
                    cRun.spriteGen.delSpriteFast(this.hoPtr.roc.rcSprite);
                    this.hoPtr.roc.rcSprite = null;
                    return;
                }
                this.hoPtr.killBack();
                return;
            }
            if ((this.hoPtr.hoOEFlags & 0x2000) == 0) {
                cRun.destroy_Add(this.hoPtr.hoNumber);
            }
            return;
        }
        int n = this.hoPtr.hoX - this.hoPtr.hoImgXSpot;
        int n5 = this.hoPtr.hoY - this.hoPtr.hoImgYSpot;
        int n6 = n + this.hoPtr.hoImgWidth;
        int n7 = n5 + this.hoPtr.hoImgHeight;
        if (n6 >= cRun.rh3XMinimum && n <= cRun.rh3XMaximum && n7 >= cRun.rh3YMinimum && n5 <= cRun.rh3YMaximum) {
            this.rsFlags = (short)(this.rsFlags & 0xFFFFFFFB);
            this.init2();
        }
    }

    public void modifRoutine() {
        switch (this.rsSpriteType) {
            case 0: {
                if (this.hoPtr.roc.rcSprite == null) break;
                this.spriteGen.modifSpriteEx(this.hoPtr.roc.rcSprite, this.hoPtr.hoX - this.hoPtr.hoAdRunHeader.rhWindowX, this.hoPtr.hoY - this.hoPtr.hoAdRunHeader.rhWindowY, this.hoPtr.roc.rcImage, this.hoPtr.roc.rcScaleX, this.hoPtr.roc.rcScaleY, (this.hoPtr.ros.rsFlags & 8) != 0, this.hoPtr.roc.rcAngle, (this.hoPtr.ros.rsFlags & 0x10) != 0);
                break;
            }
            case 1: {
                this.objGetZoneInfos();
                if (this.hoPtr.roc.rcSprite == null) break;
                this.spriteGen.modifOwnerDrawSprite(this.hoPtr.roc.rcSprite, this.hoPtr.hoRect.left, this.hoPtr.hoRect.top, this.hoPtr.hoRect.right, this.hoPtr.hoRect.bottom);
                break;
            }
            case 2: {
                this.hoPtr.hoAdRunHeader.display_OwnerQuickDisplay(this.hoPtr);
            }
        }
    }

    public boolean createSprite(CSprite cSprite) {
        if ((this.hoPtr.hoOEFlags & 0x20) != 0) {
            CSprite cSprite2 = this.spriteGen.addSprite(this.hoPtr.hoX - this.hoPtr.hoAdRunHeader.rhWindowX, this.hoPtr.hoY - this.hoPtr.hoAdRunHeader.rhWindowY, this.hoPtr.roc.rcImage, this.rsLayer, this.rsZOrder, this.rsBackColor, this.rsCreaFlags, this.hoPtr);
            if (cSprite2 != null) {
                this.hoPtr.roc.rcSprite = cSprite2;
                this.hoPtr.hoFlags = (short)(this.hoPtr.hoFlags | 4);
                this.spriteGen.modifSpriteEffect(cSprite2, this.rsEffect, this.rsEffectParam);
                if (cSprite != null) {
                    this.spriteGen.moveSpriteBefore(cSprite2, cSprite);
                }
                this.rsSpriteType = 0;
            }
            return true;
        }
        if ((this.hoPtr.hoOEFlags & 0x1000) == 0) {
            this.rsCreaFlags |= 0x2008;
            if ((this.rsCreaFlags & 0x100) == 0) {
                this.rsCreaFlags |= 0x800000;
            }
            this.rsFlags = (short)(this.rsFlags | 2);
            this.hoPtr.hoFlags = (short)(this.hoPtr.hoFlags | 0x20);
            this.hoPtr.hoRect.left = this.hoPtr.hoX - this.hoPtr.hoAdRunHeader.rhWindowX - this.hoPtr.hoImgXSpot;
            this.hoPtr.hoRect.top = this.hoPtr.hoY - this.hoPtr.hoAdRunHeader.rhWindowY - this.hoPtr.hoImgYSpot;
            this.hoPtr.hoRect.right = this.hoPtr.hoRect.left + this.hoPtr.hoImgWidth;
            this.hoPtr.hoRect.bottom = this.hoPtr.hoRect.top + this.hoPtr.hoImgHeight;
            CSprite cSprite3 = this.spriteGen.addOwnerDrawSprite(this.hoPtr.hoRect.left, this.hoPtr.hoRect.top, this.hoPtr.hoRect.right, this.hoPtr.hoRect.bottom, this.rsLayer, this.rsZOrder, this.rsBackColor, this.rsCreaFlags, this.hoPtr, this.hoPtr);
            if (cSprite3 == null) {
                return false;
            }
            this.hoPtr.roc.rcSprite = cSprite3;
            if (cSprite != null) {
                this.spriteGen.moveSpriteBefore(cSprite3, cSprite);
            }
            this.rsSpriteType = 1;
            return true;
        }
        this.hoPtr.hoNextQuickDisplay = (this.rsCreaFlags & 0x80) == 0 ? (short)-1 : (short)-2;
        this.rsSpriteType = (short)2;
        return true;
    }

    public void kill(boolean bl) {
        if (this.hoPtr.roc.rcSprite != null) {
            this.rsZOrder = this.hoPtr.roc.rcSprite.sprZOrder;
            if (!bl) {
                this.spriteGen.delSprite(this.hoPtr.roc.rcSprite);
            } else {
                this.spriteGen.delSpriteFast(this.hoPtr.roc.rcSprite);
            }
            this.hoPtr.roc.rcSprite = null;
        }
    }

    public void reInit_Spr(boolean bl) {
        if (this.hoPtr.roc.rcSprite != null) {
            this.init2();
        }
        this.displayRoutine();
    }

    public void objGetZoneInfos() {
        this.hoPtr.getZoneInfos();
        this.hoPtr.hoRect.left = this.hoPtr.hoX - this.hoPtr.hoAdRunHeader.rhWindowX - this.hoPtr.hoImgXSpot;
        this.hoPtr.hoRect.right = this.hoPtr.hoRect.left + this.hoPtr.hoImgWidth;
        this.hoPtr.hoRect.top = this.hoPtr.hoY - this.hoPtr.hoAdRunHeader.rhWindowY - this.hoPtr.hoImgYSpot;
        this.hoPtr.hoRect.bottom = this.hoPtr.hoRect.top + this.hoPtr.hoImgHeight;
    }

    public void obHide() {
        if ((this.rsFlags & 1) == 0) {
            this.rsFlags = (short)(this.rsFlags | 1);
            this.rsCreaFlags |= 0x80;
            this.rsFadeCreaFlags = (short)(this.rsFadeCreaFlags | 0x80);
            this.hoPtr.roc.rcChanged = true;
            if (this.hoPtr.roc.rcSprite != null) {
                this.hoPtr.hoAdRunHeader.spriteGen.showSprite(this.hoPtr.roc.rcSprite, false);
            } else if ((this.hoPtr.hoOEFlags & 0x1000) != 0) {
                this.hoPtr.hoAdRunHeader.display_OwnerQuickDisplay(this.hoPtr);
            }
        }
    }

    public void obShow() {
        if ((this.rsFlags & 1) != 0) {
            CLayer cLayer = this.hoPtr.hoAdRunHeader.rhFrame.layers[this.hoPtr.hoLayer];
            if ((cLayer.dwOptions & 0x20010) == 16) {
                this.rsCreaFlags &= 0xFFFFFF7F;
                this.rsFadeCreaFlags = (short)(this.rsFadeCreaFlags & 0xFFFFFF7F);
                this.rsFlags = (short)(this.rsFlags & 0xFFFFFFFE);
                this.hoPtr.hoFlags = (short)(this.hoPtr.hoFlags & 0xFFFFDFFF);
                this.hoPtr.roc.rcChanged = true;
                if (this.hoPtr.roc.rcSprite != null) {
                    this.hoPtr.hoAdRunHeader.spriteGen.showSprite(this.hoPtr.roc.rcSprite, true);
                } else if ((this.hoPtr.hoOEFlags & 0x1000) != 0) {
                    if (this.hoPtr.hoNextQuickDisplay == -2) {
                        this.hoPtr.hoNextQuickDisplay = (short)-1;
                    }
                    this.hoPtr.hoAdRunHeader.display_OwnerQuickDisplay(this.hoPtr);
                }
            }
        }
    }
}

