/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class SoftButtonControl {
    protected Displayable m_displayable;
    protected Command m_leftCommand;
    protected Command m_rightCommand;
    protected Command m_backCommand;
    protected CommandListener m_listener;
    protected boolean m_leftCommandEnabled = true;
    protected boolean m_rightCommandEnabled = true;
    protected char[] m_left;
    protected char[] m_right;
    protected Font m_font;
    protected int m_maxWidth;
    protected static final int COL_BORDER = -2008809472;
    protected static final int COL_BG = -1153171456;
    protected static final int COL_COMMAND = 0xFFFFFF;
    protected static final int COL_DISABLED_COMMAND = 0x888888;
    protected int[] m_transpBuf;

    public void init(Displayable displayable, Font font, Command command, Command command2) {
        this.m_displayable = displayable;
        this.m_font = font;
        this.setRightCommand(command2);
        this.setLeftCommand(command);
    }

    public CommandListener getCommandListener() {
        return this.m_listener;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.m_listener = commandListener;
    }

    public Command getLeftCommand() {
        return this.m_leftCommand;
    }

    public void setLeftCommand(Command command) {
        if (this.m_backCommand == this.m_leftCommand) {
            this.m_backCommand = null;
        }
        this.m_leftCommand = command;
        if (this.m_leftCommand != null) {
            this.m_left = this.m_leftCommand.getLabel().toCharArray();
            if (this.m_leftCommand.getCommandType() == 2) {
                this.m_backCommand = command;
            }
            this.enable(command, true);
        }
        this.calcWidth();
    }

    public Command getRightCommand() {
        return this.m_rightCommand;
    }

    public void setRightCommand(Command command) {
        if (this.m_backCommand == this.m_rightCommand) {
            this.m_backCommand = null;
        }
        this.m_rightCommand = command;
        if (this.m_rightCommand != null) {
            this.m_right = this.m_rightCommand.getLabel().toCharArray();
            if (this.m_rightCommand.getCommandType() == 2) {
                this.m_backCommand = command;
            }
            this.enable(command, true);
        }
        this.calcWidth();
    }

    public void enable(Command command, boolean bl) {
        if (command == this.m_leftCommand) {
            this.m_leftCommandEnabled = bl;
        }
        if (command == this.m_rightCommand) {
            this.m_rightCommandEnabled = bl;
        }
    }

    public void keyPressed(int n) {
        if (n == -6) {
            if (this.m_leftCommand != null && this.m_listener != null && this.m_leftCommandEnabled) {
                this.m_listener.commandAction(this.m_leftCommand, this.m_displayable);
            }
        } else if (n == -7) {
            if (this.m_rightCommand != null && this.m_listener != null && this.m_rightCommandEnabled) {
                this.m_listener.commandAction(this.m_rightCommand, this.m_displayable);
            }
        } else if (n == -11 && this.m_backCommand != null && this.m_listener != null && (this.m_backCommand == this.m_leftCommand && this.m_leftCommandEnabled || this.m_backCommand == this.m_rightCommand && this.m_rightCommandEnabled)) {
            this.m_listener.commandAction(this.m_backCommand, this.m_displayable);
        }
    }

    public void paint(Graphics graphics) {
        int n = this.m_displayable.getWidth();
        int n2 = this.m_displayable.getHeight();
        graphics.setFont(this.m_font);
        if (this.m_leftCommand != null) {
            this.paintCommand(graphics, this.m_left, n, n2, this.m_leftCommandEnabled, false);
        }
        if (this.m_rightCommand != null) {
            this.paintCommand(graphics, this.m_right, n, n2, this.m_rightCommandEnabled, true);
        }
    }

    protected void calcWidth() {
        int n;
        int n2 = this.m_right == null ? 0 : this.m_font.charsWidth(this.m_right, 0, this.m_right.length);
        int n3 = Math.max(n2, n = this.m_left == null ? 0 : this.m_font.charsWidth(this.m_left, 0, this.m_left.length));
        if (this.m_maxWidth != n3) {
            this.m_maxWidth = n3;
            this.recalcTransparantBuffer();
        }
    }

    protected void paintCommand(Graphics graphics, char[] cArray, int n, int n2, boolean bl, boolean bl2) {
        int n3 = this.m_font.getHeight();
        int n4 = 0;
        if (bl2) {
            n4 = n - this.m_maxWidth - 2;
        }
        graphics.drawRGB(this.m_transpBuf, 0, this.m_maxWidth + 2, n4, n2 - n3 - 1, this.m_maxWidth + 2, n3 + 1, true);
        graphics.setColor(bl ? 0xFFFFFF : 0x888888);
        n4 += this.m_maxWidth / 2;
        graphics.drawChars(cArray, 0, cArray.length, n4 += bl2 ? 2 : 1, n2, 33);
    }

    protected void recalcTransparantBuffer() {
        int n;
        this.m_transpBuf = new int[(this.m_maxWidth + 2) * (this.m_font.getHeight() + 1)];
        for (n = this.m_maxWidth + 2; n < this.m_transpBuf.length; ++n) {
            this.m_transpBuf[n] = -1153171456;
        }
        for (n = 0; n < this.m_maxWidth + 2; ++n) {
            this.m_transpBuf[n] = -2008809472;
        }
        for (n = 0; n < this.m_font.getHeight() + 1; ++n) {
            this.m_transpBuf[n * (this.m_maxWidth + 2)] = -2008809472;
            this.m_transpBuf[n * (this.m_maxWidth + 2) + this.m_maxWidth + 1] = -2008809472;
        }
    }
}

