/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.animation;

import bluegammon.Resources;
import bluegammon.gui.BoardCanvas;
import bluegammon.gui.animation.Animation;
import bluegammon.logic.BoardMediator;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CommitMoveAnim
extends Animation {
    protected static final Font FONT = Font.getFont((int)64, (int)1, (int)16);
    protected static final char[] MESS = Resources.getChars(Resources.TXT_A_QUERY_COMMIT);
    protected static final int MESSW = FONT.charsWidth(MESS, 0, MESS.length);
    protected static final int MESSH = FONT.getHeight();
    protected boolean m_white;
    protected int m_step = 0;
    protected int m_x;
    protected int m_y;
    protected int m_minX;
    protected int m_dx;
    protected static final int DT = 8;

    public CommitMoveAnim(boolean bl) {
        this.m_white = !bl;
        this.m_x = (BoardCanvas.getInstance().getWidth() - MESSW) / 2;
        this.m_y = (BoardCanvas.getInstance().getBoardHeight() - MESSH) / 2;
        this.m_minX = -MESSW - 16;
        this.m_dx = (this.m_x - this.m_minX) / 8;
    }

    public void paint(Graphics graphics) {
        int n = 0;
        if (this.m_step >= 0 && this.m_step < 8) {
            n = this.m_minX + this.m_dx * this.m_step;
        } else if (this.m_step < 40) {
            n = this.m_x;
        } else if (this.m_step < 48) {
            n = this.m_x + this.m_dx * (this.m_step - 40);
        } else {
            if (this.m_step <= 80) {
                return;
            }
            if (this.m_step > 80) {
                this.m_step = 0;
                return;
            }
        }
        graphics.setFont(FONT);
        graphics.setColor(this.m_white ? 0 : 0xFFFFFF);
        graphics.drawChars(MESS, 0, MESS.length, n - 1, this.m_y, 20);
        graphics.drawChars(MESS, 0, MESS.length, n + 1, this.m_y, 20);
        graphics.drawChars(MESS, 0, MESS.length, n, this.m_y - 1, 20);
        graphics.drawChars(MESS, 0, MESS.length, n, this.m_y + 1, 20);
        graphics.setColor(this.m_white ? 0xFFFFFF : 0);
        graphics.drawChars(MESS, 0, MESS.length, n, this.m_y, 20);
    }

    public void next() {
        ++this.m_step;
        BoardCanvas.getInstance().requestRepaint();
    }

    public boolean isFinished() {
        return !BoardCanvas.getInstance().waitingForCommit() || BoardMediator.isGameFinished();
    }

    public void onExit() {
        BoardCanvas.getInstance().requestRepaint();
    }

    public long getInterval() {
        return 40L;
    }
}

