/*
 * Decompiled with CFR 0.152.
 */
package bluegammon.gui.menu;

import bluegammon.gui.menu.PageItem;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class MenuPage {
    public static final int LAYOUT_LEFT = 0;
    public static final int LAYOUT_RIGHT = 1;
    protected char[] m_title;
    protected Image m_titleImage;
    protected int m_layout = 0;
    protected Vector m_items = new Vector();
    protected int m_currentIndex = -1;

    public MenuPage(char[] cArray, Image image) {
        this.setTitle(cArray);
        this.setTitleImage(image);
    }

    public void setLayout(int n) {
        this.m_layout = n;
    }

    public int getLayout() {
        return this.m_layout;
    }

    public char[] getTitle() {
        return this.m_title;
    }

    public void setTitle(char[] cArray) {
        this.m_title = cArray;
    }

    public Image getTitleImage() {
        return this.m_titleImage;
    }

    public void setTitleImage(Image image) {
        this.m_titleImage = image;
    }

    public synchronized void addItem(PageItem pageItem) {
        this.m_items.addElement(pageItem);
        pageItem.addedToPage();
        if (this.m_currentIndex == -1) {
            this.m_currentIndex = 0;
        }
    }

    public synchronized void removeItem(PageItem pageItem) {
        this.m_items.removeElement(pageItem);
        if (this.size() == 0) {
            this.m_currentIndex = -1;
        }
    }

    public synchronized void removeItem(int n) {
        this.m_items.removeElementAt(n);
    }

    public synchronized int size() {
        return this.m_items.size();
    }

    public synchronized int getSelectedIndex() {
        PageItem pageItem = this.itemAt(this.m_currentIndex);
        if (pageItem != null && !pageItem.isEnabled()) {
            this.setSelectedIndex(this.m_currentIndex + 1);
        }
        return this.m_currentIndex;
    }

    public synchronized void setSelectedIndex(int n) {
        int n2;
        int n3 = this.size();
        boolean bl = n - this.m_currentIndex > 0;
        boolean bl2 = true;
        for (n2 = 0; bl2 && n2 < n3; ++n2) {
            bl2 = !this.itemAt(n2).isEnabled();
        }
        if (n3 == 0 || bl2) {
            n = -1;
        } else {
            n2 = 1;
            do {
                if (n >= n3) {
                    n = 0;
                } else if (n < 0) {
                    n = n3 - 1;
                }
                n2 = this.itemAt(n).isEnabled() ? 1 : 0;
                if (n2 != 0) continue;
                if (bl) {
                    ++n;
                    continue;
                }
                --n;
            } while (n2 == 0);
        }
        this.m_currentIndex = n;
    }

    public synchronized PageItem itemAt(int n) {
        if (n < 0 || n >= this.size()) {
            return null;
        }
        return (PageItem)this.m_items.elementAt(n);
    }

    public synchronized int getIndex(PageItem pageItem) {
        return this.m_items.indexOf(pageItem);
    }

    public synchronized void removeAllItems() {
        this.m_items.removeAllElements();
    }
}

