/*
 * Decompiled with CFR 0.152.
 */
public class Upal {
    private static final int[] crc_table = new int[256];

    public static int png_calculate_crc(byte[] buf, int pos, int len) {
        int crc = -1;
        int max = pos + len;
        int[] crc_table_copy = crc_table;
        while (pos != max) {
            crc = crc_table_copy[(crc ^ buf[pos]) & 0xFF] ^ crc >>> 8;
            ++pos;
        }
        return ~crc;
    }

    public static int png_get_PLTE_pos(byte[] buf) {
        int pos = 8;
        while (buf[pos + 4] != 80 || buf[pos + 5] != 76 || buf[pos + 6] != 84 || buf[pos + 7] != 69) {
            int chunk_len = Upal.getInt_Byte(buf, pos);
            pos += 8 + chunk_len + 4;
        }
        return pos;
    }

    public static int setByte_Int(byte[] buf, int pos, int dat) {
        buf[pos + 0] = (byte)(dat >> 24 & 0xFF);
        buf[pos + 1] = (byte)(dat >> 16 & 0xFF);
        buf[pos + 2] = (byte)(dat >> 8 & 0xFF);
        buf[pos + 3] = (byte)(dat & 0xFF);
        return pos + 4;
    }

    public static int png_get_PLTE_count(byte[] buf, int pos_PLTE) {
        return Upal.getInt_Byte(buf, pos_PLTE) / 3;
    }

    public static int getInt_Byte(byte[] aa2, int i1) {
        return (aa2[i1] & 0xFF) << 24 | (aa2[i1 + 1] & 0xFF) << 16 | (aa2[i1 + 2] & 0xFF) << 8 | aa2[i1 + 3] & 0xFF;
    }

    public static int png_write_crc(byte[] buf, int pos_chunk) {
        int chunk_len = Upal.getInt_Byte(buf, pos_chunk);
        int crc = Upal.png_calculate_crc(buf, pos_chunk + 4, 4 + chunk_len);
        return Upal.setByte_Int(buf, pos_chunk + 4 + 4 + chunk_len, crc);
    }

    public static void png_read_palette(byte[] buf, int pos_PLTE, int index, int count, byte[] rgb) {
        System.arraycopy(buf, pos_PLTE + 4 + 4 + 3 * index, rgb, 0, 3 * count);
    }

    public static void png_write_palette(byte[] buf, int pos_PLTE, int index, int count, byte[] rgb) {
        System.arraycopy(rgb, 0, buf, pos_PLTE + 4 + 4 + 3 * index, 3 * count);
    }

    public static void pal_change(int[] pal, int[] change, byte[] rgb) {
        for (int i2 = 0; i2 < rgb.length; i2 += 3) {
            for (int j2 = 0; j2 < pal.length; j2 += 3) {
                if (rgb[i2] != (byte)pal[j2] || rgb[i2 + 1] != (byte)pal[j2 + 1] || rgb[i2 + 2] != (byte)pal[j2 + 2]) continue;
                rgb[i2] = (byte)change[j2];
                rgb[i2 + 1] = (byte)change[j2 + 1];
                rgb[i2 + 2] = (byte)change[j2 + 2];
            }
        }
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            int r2 = i2;
            for (int j2 = 0; j2 < 8; ++j2) {
                if ((r2 & 1) != 0) {
                    r2 = r2 >>> 1 ^ 0xEDB88320;
                    continue;
                }
                r2 >>>= 1;
            }
            Upal.crc_table[i2] = r2;
        }
    }
}

