/*
 * Decompiled with CFR 0.152.
 */
package Jim.Engine;

import Jim.Engine.JCore;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class JTool {
    public static final byte CENTER = 1;
    public static final int COLOR_BLACK = 0;
    public static final int COLOR_BLUE = 255;
    public static final int COLOR_GRAY = 0x525050;
    public static final int COLOR_ORANGE = 16734720;
    public static final int COLOR_PINK = 0xFF00FF;
    public static final int COLOR_RED = 0xFF0000;
    public static final int COLOR_WHITE = 0xFFFFFF;
    public static final int COLOR_YELLOW = 0xFFFF00;
    public static int ClipHeight;
    public static int ClipWidth;
    public static int DrawPosX;
    public static int DrawPosY;
    public static final byte FRAME = 1;
    public static int Height;
    public static final byte LEFT = 0;
    public static final byte NORMAL = -1;
    public static final byte OUTLINE = 0;
    public static int PosX;
    public static int PosY;
    public static final byte RIGHT = 2;
    public static final byte SHADOW = 0;
    public static final byte SORT_BIG = 0;
    public static final byte SORT_SMALL = 1;
    public static int Width;
    private static Random rnd;

    static {
        rnd = new Random();
    }

    public static Image createImage(String fileName) {
        Image tempImage = null;
        try {
            tempImage = Image.createImage((String)("/images/" + fileName));
        }
        catch (Exception ex) {
            System.out.print("image file " + fileName + " not found!");
        }
        return tempImage;
    }

    public static void drawBigString(Graphics g, String str, int x, int y) {
        g.setFont(Font.getFont((int)0, (int)1, (int)16));
        g.drawString(str, x + DrawPosX, y + DrawPosY, 0);
    }

    public static void drawClipImage(Graphics g, Image image, int x, int y, int index, int width, int height, int rec_width, int rec_height, byte type) {
        JTool.drawImage(g, image, x - index * width, y, width, height, rec_width, rec_height, type);
        g.setClip(0, 0, ClipWidth, ClipHeight);
    }

    public static void drawClipImage(Graphics g, Image image, int x, int y, int index, int width, int height) {
        g.setClip(x + DrawPosX, y + DrawPosY, width, height);
        g.drawImage(image, x + DrawPosX - index * width, y + DrawPosY, 0);
        g.setClip(0, 0, ClipWidth, ClipHeight);
    }

    public static void drawClipImageAny(Graphics g, Image image, int x, int y, int wNum, int hNum, int index, int width, int height) {
        int y1 = hNum * height;
        int x1 = wNum * width;
        g.setClip(x + DrawPosX, y + DrawPosY, width, height);
        g.drawImage(image, x + DrawPosX - x1, y + DrawPosY - y1, 0);
        g.setClip(0, 0, ClipWidth, ClipHeight);
    }

    public static void drawClipImageAny(Graphics g, Image image, int x, int y, int x1, int y1, int width, int height) {
        g.setClip(x + DrawPosX, y + DrawPosY, width, height);
        g.drawImage(image, x + DrawPosX - x1, y + DrawPosY - y1, 0);
        g.setClip(0, 0, ClipWidth, ClipHeight);
    }

    public static void drawClipImageHeight(Graphics g, Image image, int x, int y, int index, int width, int height) {
        g.setClip(x + DrawPosX, y + DrawPosY, width, height);
        g.drawImage(image, x + DrawPosX, y + DrawPosY - index * height, 0);
        g.setClip(0, 0, ClipWidth, ClipHeight);
    }

    public static void drawImage(Graphics g, Image img, int x, int y) {
        if (x == -1000) {
            x = (JCore.GameScreenWidth - img.getWidth()) / 2;
        }
        if (y == -1000) {
            y = (JCore.GameScreenHeight - img.getHeight()) / 2;
        }
        g.drawImage(img, x + DrawPosX, y + DrawPosY, 0);
        PosX = x;
        PosY = y;
    }

    public static void drawImage(Graphics g, Image img, int x, int y, int width, int height, int rec_width, int rec_height, byte type) {
        int x1 = x;
        int y1 = y;
        if (type == 1) {
            x1 = x + (rec_width - width) / 2;
            if (x1 < 0) {
                x1 = 0;
            }
            if ((y1 = y + (rec_height - height) / 2) < 0) {
                y1 = 0;
            }
        }
        g.setClip(x1 + DrawPosX, y1 + DrawPosY, width, height);
        g.drawImage(img, x1 + DrawPosX, y1 + DrawPosY, 0);
        PosX = x;
        PosY = y;
    }

    public static void drawNumber(Graphics g, Image number_img, int score, int x, int y, int space, int num, int start, short w, short h) {
        int number;
        if (num < 0 || score < 0) {
            return;
        }
        String s = "" + score;
        String snum = "";
        int i = number = s.length();
        while (i < num) {
            snum = snum + '0';
            ++i;
        }
        s = snum + score;
        if (x == -1000) {
            x = (JCore.GameScreenWidth - num * space) / 2;
        }
        int i2 = 0;
        while (i2 < num) {
            JTool.drawClipImage(g, number_img, x + i2 * space, y, start + Integer.parseInt("" + s.charAt(i2)), w, h);
            ++i2;
        }
    }

    public static void drawOutLineString(Graphics g, String str, int x, int y) {
        int Font_width = JCore.Font.stringWidth(str);
        int Font_height = JCore.Font.getHeight();
        if (x == -1000) {
            x = (JCore.GameScreenWidth - Font_width) / 2;
        }
        if (y == -1000) {
            y = (JCore.GameScreenWidth - Font_height) / 2;
        }
        int color = g.getColor();
        g.setColor(0);
        g.drawString(str, (x += DrawPosX) - 1, (y += DrawPosY) - 1, 0);
        g.drawString(str, x + 1, y - 1, 0);
        g.drawString(str, x - 1, y + 1, 0);
        g.drawString(str, x + 1, y + 1, 0);
        g.setColor(color);
        g.drawString(str, x, y, 0);
        PosX = x;
        PosY = y;
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height) {
        g.drawRect(x + DrawPosX, y + DrawPosY, width, height);
    }

    public static void drawString(Graphics g, int x, int y, int width, int height, String str, byte type) {
        int Font_width = JCore.Font.stringWidth(str);
        int Font_height = JCore.Font.getHeight();
        int x1 = 0;
        int y1 = 0;
        if (type == 1) {
            x1 = width - Font_width;
            x = x1 < 0 ? (x -= (Font_width - width) / 2) : (x += (width - Font_width) / 2);
            y = y + height + 2;
        } else if (type == 2) {
            y1 = height - Font_height;
            y = y1 < 0 ? (y -= (Font_height - height) / 2) : (y += (height - Font_height) / 2);
            x = x + width + 2;
        }
        JTool.drawString(g, str, x, y, (byte)-1, null);
        PosX = x;
        PosY = y;
        Height = Font_height;
        Width = Font_width;
    }

    public static void drawString(Graphics g, String str, int x, int y, byte type, Image back_img) {
        int width = 0;
        int height = 0;
        if (x == -1000) {
            width = JCore.Font.stringWidth(str);
            x = (JCore.GameScreenWidth - width) / 2;
        }
        if (y == -1000) {
            height = JCore.Font.getHeight();
            y = (JCore.GameScreenHeight - height) / 2;
        }
        if (back_img != null) {
            g.setColor(255, 255, 255);
            JTool.drawRect(g, x - 3, y - 3, width + 6, height + 6);
        }
        if (type >= 0) {
            int color = g.getColor();
            if (type == 0) {
                g.setColor(255, 255, 255);
                JTool.drawString(g, str, x + 1, y + 1);
            } else if (type == 1) {
                width = JCore.Font.stringWidth(str);
                height = JCore.Font.getHeight();
                g.setColor(0);
                JTool.fillRect(g, x - 3, y - 3, width + 6, height + 6);
                g.setColor(255, 255, 255);
                JTool.drawRect(g, x - 3, y - 3, width + 6, height + 6);
            }
            g.setColor(color);
        }
        JTool.drawString(g, str, x, y);
        PosX = x;
        PosY = y;
    }

    public static void drawString(Graphics g, String str, int x, int y) {
        g.drawString(str, x + DrawPosX, y + DrawPosY, 0);
    }

    public static void drawString(Graphics g, String str, int x, int y, int font_color, int back_color, byte state) {
        int Font_width = JCore.Font.stringWidth(str);
        int Font_height = JCore.Font.getHeight();
        if (x == -1000) {
            x = (JCore.GameScreenWidth - Font_width) / 2;
        }
        if (y == -1000) {
            y = (JCore.GameScreenWidth - Font_height) / 2;
        }
        PosX = x;
        PosY = y;
        x += DrawPosX;
        y += DrawPosY;
        if (state == 0) {
            g.setColor(back_color);
            g.drawString(str, x - 1, y - 1, 0);
            g.drawString(str, x, y - 1, 0);
            g.drawString(str, x + 1, y - 1, 0);
            g.drawString(str, x - 1, y + 1, 0);
            g.drawString(str, x + 1, y + 1, 0);
            g.drawString(str, x, y + 1, 0);
        }
        g.setColor(font_color);
        g.drawString(str, x, y, 0);
    }

    public static void fillRect(Graphics g, int x, int y, int width, int height) {
        g.fillRect(x + DrawPosX, y + DrawPosY, width, height);
    }

    public static String findStringSpec(String str, char b, char e, int index) {
        String temp = "";
        int begin = 0;
        int end = 0;
        int i = 0;
        while (i < index) {
            end = str.indexOf(e, end + 1);
            ++i;
        }
        if (index == 0) {
            end = -1;
        }
        begin = str.indexOf(b, end + 1);
        end = str.indexOf(e, begin + 1);
        temp = str.substring(begin + 1, end);
        return temp;
    }

    public static int getRand(int min, int max) {
        boolean check = false;
        int number = 0;
        if (min >= max) {
            int temp = max;
            max = min;
            min = temp;
        }
        while (!check) {
            number = Math.abs(rnd.nextInt() % max);
            if (number < min || number >= max) continue;
            check = true;
        }
        return number;
    }

    public static int getRand(int i) {
        if (i == 0) {
            return 0;
        }
        return Math.abs(rnd.nextInt() % i);
    }

    public static int getWidthOfString(String str, Font font) {
        int width = 0;
        int a = 0;
        while (a < str.length()) {
            width += font.charWidth(str.charAt(a));
            ++a;
        }
        return width;
    }

    public static void randIndex(short[] index, short[] index2) {
        int len = index.length;
        int count = 0;
        boolean[] check = new boolean[len];
        do {
            int rand;
            if (check[rand = JTool.getRand(len)]) continue;
            check[rand] = true;
            index[count++] = index2[rand];
        } while (count < len);
    }

    public static Image scaleImage(Image src, int dstW, int dstH) {
        int srcW = src.getWidth();
        int srcH = src.getHeight();
        Image tmp = Image.createImage((int)dstW, (int)srcH);
        Graphics g = tmp.getGraphics();
        int delta = (srcW << 16) / dstW;
        int pos = delta / 2;
        int x = 0;
        while (x < dstW) {
            g.setClip(x, 0, 1, srcH);
            g.drawImage(src, x - (pos >> 16), 0, 0);
            pos += delta;
            ++x;
        }
        Image dst = Image.createImage((int)dstW, (int)dstH);
        g = dst.getGraphics();
        delta = (srcH << 16) / dstH;
        pos = delta / 2;
        int y = 0;
        while (y < dstH) {
            g.setClip(0, y, dstW, 1);
            g.drawImage(tmp, 0, y - (pos >> 16), 0);
            pos += delta;
            ++y;
        }
        return dst;
    }

    public static void set(int x, int y, int clipWidth, int clipHeight) {
        DrawPosX = x;
        DrawPosY = y;
        ClipWidth = clipWidth;
        ClipHeight = clipHeight;
    }

    public static int[] sortIndex(int[] index, int num, byte type) {
        if (num == -1) {
            num = index.length;
        }
        int[] sortIndex = new int[num];
        int i = 0;
        while (i < num) {
            sortIndex[i] = i;
            ++i;
        }
        boolean ok = true;
        do {
            int tempindex;
            int temp;
            int i2;
            ok = true;
            if (type == 1) {
                i2 = 0;
                while (i2 < num - 1) {
                    if (index[i2] > index[i2 + 1]) {
                        temp = index[i2 + 1];
                        tempindex = sortIndex[i2 + 1];
                        index[i2 + 1] = index[i2];
                        sortIndex[i2 + 1] = sortIndex[i2];
                        index[i2] = temp;
                        sortIndex[i2] = tempindex;
                        ok = false;
                    }
                    ++i2;
                }
            } else {
                if (type != 0) continue;
                i2 = 0;
                while (i2 < num - 1) {
                    if (index[i2 + 1] > index[i2]) {
                        temp = index[i2 + 1];
                        tempindex = sortIndex[i2 + 1];
                        index[i2 + 1] = index[i2];
                        sortIndex[i2 + 1] = sortIndex[i2];
                        index[i2] = temp;
                        sortIndex[i2] = tempindex;
                        ok = false;
                    }
                    ++i2;
                }
            }
        } while (!ok);
        return sortIndex;
    }

    public static short turnByteToShort(byte[] b) {
        int k = b[0];
        int l = b[1];
        if (k < 0) {
            k += 256;
        }
        if (l < 0) {
            l += 256;
        }
        return (short)(k + (l << 8));
    }

    public static int turnBytesToInt(byte[] b) {
        int mask = 255;
        int temp = 0;
        int res = 0;
        int i = 0;
        while (i < 4) {
            res <<= 8;
            temp = b[i] & mask;
            res |= temp;
            ++i;
        }
        return res;
    }
}

