/*
 * Decompiled with CFR 0.152.
 */
package com.linkyun.screen;

import com.linkyun.screen.MainMenuScreen;
import com.linkyun.screen.ResultScreen;
import com.linkyun.screen.ScreenManage;
import com.linkyun.screen.StandardScreen;
import com.linkyun.tools.GameConst;
import com.linkyun.tools.GraphicsTools;
import com.linkyun.tools.MathTools;
import com.linkyun.tools.MusicPlayer;
import com.linkyun.tools.RMSDB;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainGameScreen
extends StandardScreen {
    private int m_nLevel;
    private int m_nBgIndex;
    private int m_nContinuous;
    private int m_nMaxContinuous;
    private int m_nAngleW;
    private int m_nAngle;
    private double m_dRadian;
    private int m_nStartX;
    private int m_nStartY;
    private int m_nVertexX;
    private int m_nVertexY;
    int tmp_nPointLen;
    private int m_nPointerX;
    private int m_nPointerY;
    private int m_nFlyX;
    private int m_nFlyY;
    private int m_nToVertexLen;
    private int m_nToVertexFrame;
    private int m_nToAshbinFrame;
    private int m_nWindVelocity;
    private String m_nWindVelocityG;
    private int m_nMaxWindVelocity;
    private int m_nFlightSpeedX;
    private int m_nFlightSpeedY;
    private int m_nAshbinY;
    private int m_nAngleSpeed;
    private long m_nResultFrame;
    private boolean m_bIsToRight = true;
    private boolean m_bBinUp = true;
    private boolean m_bEnter = false;
    private boolean m_bSuccess = false;
    private boolean m_bBreakRecord = false;
    private boolean m_bIsMenu;
    private int m_nMenuLevel;
    private int[] m_nMenuIndex = new int[]{0, 0};
    private int m_nRubbishIndex;
    private int m_nRubbishSize;
    private int m_nRubbishState;
    private int m_nRubbishAnchor;
    private static final int STATE_READY = 0;
    private static final int STATE_FLY_TO_VERTEX = 1;
    private static final int STATE_FLY_TO_ASHBIN = 2;
    private static final int STATE_RESULT = 3;
    private Image m_imgBackGround;
    private Image m_imgMenuBG;
    private Image m_imgMenuBG2;
    private Image m_imgHelpBG;
    private Image m_imgIconMenu;
    private Image m_imgIconBack;
    private Image m_imgSelectMenu;
    private Image m_imgKite;
    private Image m_imgArrow;
    private Image m_imgAshbin;
    private Image m_imgRubbish;
    private Image[][][] m_aImgRubbishs;
    private Image m_imgSuccess;
    private Image[] m_aImgSuccess;
    private int[] m_anMenu;
    private static final int STATE_CONTINUE = 0;
    private static final int STATE_H = 1;
    private static final int STATE_MUSICAL = 2;
    private static final int STATE_BACKTO = 3;
    private int m_nRmsLevel;
    private int m_nLevelIndex;
    private Image m_imgShadow;
    private Image m_imgScore;

    public MainGameScreen(int LevelIndex, int _Difficult, int _BgIndex) {
        this.loadStageLock();
        this.m_nLevelIndex = LevelIndex;
        this.m_nLevel = _Difficult;
        this.m_nBgIndex = _BgIndex;
        this.m_anMenu = new int[]{0, 1, 3};
        this.m_anMenu = new int[]{0, 1, 2, 3};
        this.init();
    }

    private void init() {
        this.loadRes();
        this.m_nRubbishAnchor = 0;
        this.m_nRubbishIndex = 0;
        this.m_imgRubbish = this.m_aImgRubbishs[this.m_nRubbishIndex][0][0];
        this.m_nMaxContinuous = this.loadContinuous(this.m_nBgIndex * 3 + this.m_nLevel);
        this.m_nStartX = 120;
        int nStartY = 290;
        switch (320) {
            case 320: {
                this.m_nStartY = nStartY;
                switch (this.m_nLevel) {
                    case 0: {
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 130;
                        this.m_nToVertexFrame = 10;
                        this.m_nAngleW = 40;
                        break;
                    }
                    case 1: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 100;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 38;
                        break;
                    }
                    case 2: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 50;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 35;
                    }
                }
                this.m_nAngle = 90 + this.m_nAngleW;
                this.m_nVertexY = this.m_nAshbinY - 100;
                break;
            }
            case 204: {
                switch (this.m_nLevel) {
                    case 0: {
                        this.m_nStartY = nStartY + 12;
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 85;
                        this.m_nToVertexFrame = 10;
                        this.m_nAngleW = 40;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 65;
                        break;
                    }
                    case 1: {
                        this.m_nStartY = nStartY;
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 55;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 38;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 70;
                        break;
                    }
                    case 2: {
                        this.m_nStartY = nStartY;
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 30;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 40;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 55;
                    }
                }
                break;
            }
            case 208: {
                switch (this.m_nLevel) {
                    case 0: {
                        this.m_nStartY = nStartY + 12;
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 85;
                        this.m_nToVertexFrame = 10;
                        this.m_nAngleW = 40;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 85;
                        break;
                    }
                    case 1: {
                        this.m_nStartY = nStartY;
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 55;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 38;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 70;
                        break;
                    }
                    case 2: {
                        this.m_nStartY = nStartY;
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 30;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 40;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 55;
                    }
                }
                break;
            }
            case 220: {
                switch (this.m_nLevel) {
                    case 0: {
                        this.m_nStartY = nStartY + 15;
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 90;
                        this.m_nToVertexFrame = 10;
                        this.m_nAngleW = 40;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 75;
                        break;
                    }
                    case 1: {
                        this.m_nStartY = nStartY + 15;
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 60;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 38;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 65;
                        break;
                    }
                    case 2: {
                        this.m_nStartY = nStartY;
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 30;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 40;
                        this.m_nAngle = 90 + this.m_nAngleW;
                        this.m_nVertexY = this.m_nAshbinY - 45;
                    }
                }
                break;
            }
            case 304: {
                this.m_nStartY = nStartY;
                switch (this.m_nLevel) {
                    case 0: {
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 130;
                        this.m_nToVertexFrame = 10;
                        this.m_nAngleW = 40;
                        break;
                    }
                    case 1: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 95;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 38;
                        break;
                    }
                    case 2: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 45;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 35;
                    }
                }
                this.m_nAngle = 90 + this.m_nAngleW;
                this.m_nVertexY = this.m_nAshbinY - 100;
                break;
            }
            case 360: {
                this.m_nStartY = nStartY;
                switch (this.m_nLevel) {
                    case 0: {
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 120;
                        this.m_nToVertexFrame = 10;
                        this.m_nAngleW = 40;
                        break;
                    }
                    case 1: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 150;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 38;
                        break;
                    }
                    case 2: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 70;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 35;
                    }
                }
                this.m_nAngle = 90 + this.m_nAngleW;
                this.m_nVertexY = this.m_nAshbinY - 100;
                break;
            }
            case 240: {
                this.m_nStartY = nStartY;
                switch (this.m_nLevel) {
                    case 0: {
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 50;
                        this.m_nToVertexFrame = 10;
                        this.m_nAngleW = 40;
                        break;
                    }
                    case 1: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 40;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 38;
                        break;
                    }
                    case 2: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 35;
                        this.m_nToVertexFrame = 15;
                        this.m_nAngleW = 35;
                    }
                }
                this.m_nAngle = 90 + this.m_nAngleW;
                this.m_nVertexY = this.m_nAshbinY - 60;
                break;
            }
            case 149: 
            case 160: {
                this.m_nStartY = nStartY;
                switch (this.m_nLevel) {
                    case 0: {
                        this.m_nAngleSpeed = -3;
                        this.m_nAshbinY = 60;
                        this.m_nToVertexFrame = 6;
                        this.m_nAngleW = 40;
                        break;
                    }
                    case 1: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 40;
                        this.m_nToVertexFrame = 12;
                        this.m_nAngleW = 38;
                        break;
                    }
                    case 2: {
                        this.m_nAngleSpeed = -2;
                        this.m_nAshbinY = 25;
                        this.m_nToVertexFrame = 10;
                        this.m_nAngleW = 35;
                    }
                }
                this.m_nAngle = 90 + this.m_nAngleW;
                this.m_nVertexY = this.m_nAshbinY - 35;
            }
        }
        this.m_nToVertexLen = this.m_nStartY - this.m_nVertexY;
        int tmp_nAngle = this.m_nAngle - 90;
        int tmp_nX = (int)(MathTools.tan(MathTools.getRadian(tmp_nAngle)) * (double)this.m_nToVertexLen);
        this.m_nFlightSpeedY = this.m_nToVertexLen / this.m_nToVertexFrame;
        int tmp_nToAshbinX = Math.abs(tmp_nX) - (this.m_imgAshbin.getWidth() >> 2);
        int tmp_nToAshbinY = this.m_nAshbinY - (this.m_aImgRubbishs[this.m_nRubbishIndex][2][0].getHeight() >> 1) - this.m_nVertexY;
        this.m_nToAshbinFrame = tmp_nToAshbinY / (this.m_nFlightSpeedY >> 1);
        this.m_nMaxWindVelocity = tmp_nToAshbinX / this.m_nToAshbinFrame;
        this.randomWind();
    }

    void click(int x, int y) {
    }

    void input(int key) {
        if (this.m_bIsMenu) {
            this.inputMenu(key);
            return;
        }
        switch (this.m_nStatus) {
            case 0: {
                switch (key) {
                    case -5: 
                    case 53: {
                        this.inputReady();
                        return;
                    }
                    case -7: {
                        this.m_bIsMenu = true;
                    }
                }
            }
        }
    }

    void logic() {
        if (this.m_bIsMenu) {
            return;
        }
        switch (this.m_nStatus) {
            case 0: {
                this.m_nAngle += this.m_nAngleSpeed;
                if (this.m_nAngle > 90 + this.m_nAngleW || this.m_nAngle < 90 - this.m_nAngleW) {
                    this.m_nAngleSpeed = -this.m_nAngleSpeed;
                    this.m_nAngle += this.m_nAngleSpeed;
                }
                this.m_dRadian = MathTools.getRadian(this.m_nAngle);
                switch (320) {
                    case 204: 
                    case 208: 
                    case 220: 
                    case 240: 
                    case 320: 
                    case 360: {
                        this.tmp_nPointLen = 40;
                        break;
                    }
                    case 160: {
                        this.tmp_nPointLen = 20;
                    }
                }
                int tmp_nX = (int)(MathTools.cos(this.m_dRadian) * (double)this.tmp_nPointLen);
                int tmp_nY = (int)(MathTools.sin(this.m_dRadian) * (double)this.tmp_nPointLen);
                this.m_nPointerX = this.m_nStartX + tmp_nX;
                this.m_nPointerY = this.m_nStartY - tmp_nY;
                break;
            }
            case 1: {
                this.m_imgRubbish = this.m_aImgRubbishs[this.m_nRubbishIndex][this.m_nRubbishSize][this.m_nRubbishState];
                this.m_nFlyX += this.m_nFlightSpeedX;
                this.m_nFlyY += this.m_nFlightSpeedY;
                if (this.m_nFlyY < this.m_nStartY - this.m_nVertexY >> 1) {
                    this.m_nRubbishSize = 1;
                }
                if (this.m_nFlyY >= this.m_nVertexY) break;
                this.m_nFlyY = this.m_nVertexY;
                this.m_nFlyX = this.m_nVertexX;
                if (this.m_nLevel > 0) {
                    this.m_nRubbishSize = 2;
                }
                this.m_nFlightSpeedY = -(this.m_nFlightSpeedY >> 1);
                this.m_nStatus = 2;
                return;
            }
            case 2: {
                this.m_imgRubbish = this.m_aImgRubbishs[this.m_nRubbishIndex][this.m_nRubbishSize][this.m_nRubbishState];
                this.m_nFlyX += this.m_nWindVelocity;
                this.m_nFlyY += this.m_nFlightSpeedY;
                if (this.m_nFlyY >= this.m_nAshbinY + (this.m_imgAshbin.getHeight() >> 2)) {
                    this.m_imgRubbish = this.m_aImgRubbishs[this.m_nRubbishIndex][this.m_nRubbishSize][7];
                }
                if (this.m_bBinUp && this.m_nFlyY > this.m_nAshbinY - (this.m_imgRubbish.getHeight() >> 1)) {
                    this.logicToAshbin();
                }
                if ((!this.m_bEnter || this.m_nFlyY < this.m_nAshbinY + (this.m_imgRubbish.getHeight() >> 1)) && this.m_nFlyY < this.m_nAshbinY + (this.m_imgAshbin.getHeight() >> 1)) break;
                this.m_nResultFrame = this.m_nFrameCounter;
                if (this.m_bSuccess) {
                    ++this.m_nContinuous;
                    if (this.m_nContinuous > this.m_nMaxContinuous) {
                        this.m_bBreakRecord = true;
                        this.m_nMaxContinuous = this.m_nContinuous;
                        int[] tmp_an = RMSDB.getIntsRecord("LY_EPHero_Continuous", 1);
                        tmp_an[this.m_nBgIndex * 3 + this.m_nLevel] = (byte)this.m_nMaxContinuous;
                        RMSDB.updateRecord("LY_EPHero_Continuous", 1, tmp_an);
                    }
                    if (MusicPlayer.m_bSound) {
                        new Thread(){

                            public void run() {
                                MusicPlayer.playMusic(GameConst.MUSIC_LIST[0], 1);
                            }
                        }.start();
                    }
                } else {
                    this.m_nContinuous = 0;
                    this.m_bBreakRecord = false;
                }
                this.m_nStatus = 3;
                return;
            }
            case 3: {
                switch (this.m_nLevelIndex) {
                    case 0: {
                        if (this.m_nContinuous < 7) break;
                        this.m_bIsClearRes = true;
                        ScreenManage.setCurrentScreen(new ResultScreen(this.m_nLevelIndex + 1, 0));
                        return;
                    }
                    case 1: {
                        if (this.m_nContinuous < 7) break;
                        this.m_bIsClearRes = true;
                        ScreenManage.setCurrentScreen(new ResultScreen(this.m_nLevelIndex + 1, 0));
                        return;
                    }
                    case 2: {
                        if (this.m_nContinuous < 5) break;
                        this.m_bIsClearRes = true;
                        ScreenManage.setCurrentScreen(new ResultScreen(this.m_nLevelIndex + 1, 0));
                        return;
                    }
                    case 3: {
                        if (this.m_nContinuous < 5) break;
                        this.m_bIsClearRes = true;
                        ScreenManage.setCurrentScreen(new ResultScreen(this.m_nLevelIndex + 1, 0));
                        return;
                    }
                    case 4: {
                        if (this.m_nContinuous < 3) break;
                        this.m_bIsClearRes = true;
                        ScreenManage.setCurrentScreen(new ResultScreen(this.m_nLevelIndex + 1, 0));
                        return;
                    }
                    case 5: {
                        if (this.m_nContinuous < 3) break;
                        this.m_bIsClearRes = true;
                        ScreenManage.setCurrentScreen(new ResultScreen(this.m_nLevelIndex + 1, 0));
                        return;
                    }
                }
                this.logicResult();
            }
        }
    }

    void paint(Graphics g) {
        ++this.m_nFrameCounter;
        g.drawImage(this.m_imgBackGround, 0, 0, 20);
        int tmp_nTmpShadowY = 0;
        switch (this.m_nLevelIndex) {
            case 0: 
            case 1: {
                tmp_nTmpShadowY = 206;
                break;
            }
            case 2: 
            case 3: {
                tmp_nTmpShadowY = 147;
                break;
            }
            case 4: 
            case 5: {
                tmp_nTmpShadowY = 81;
            }
        }
        switch (this.m_nStatus) {
            case 0: {
                int tmp_nY = 240;
                switch (320) {
                    case 320: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 110, tmp_nTmpShadowY, 17);
                        break;
                    }
                    case 304: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 110, tmp_nTmpShadowY, 17);
                        break;
                    }
                    case 220: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 40, 17);
                        break;
                    }
                    case 360: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 80, 17);
                        break;
                    }
                    case 240: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 40, 17);
                        tmp_nY = 230;
                        break;
                    }
                    case 149: 
                    case 160: {
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 20, 17);
                        tmp_nY = 230;
                    }
                }
                GraphicsTools.drawRegion(g, this.m_imgRubbish, 0, 0, this.m_imgRubbish.getWidth(), this.m_imgRubbish.getHeight(), 0, this.m_nStartX, this.m_nStartY, 3);
                if (this.m_bIsToRight) {
                    GraphicsTools.drawRegion(g, this.m_imgArrow, 0, 0, this.m_imgArrow.getWidth(), this.m_imgArrow.getHeight(), 3, 120, tmp_nY, 17);
                } else {
                    g.drawImage(this.m_imgArrow, 120, tmp_nY, 17);
                }
                g.drawImage(this.m_imgAshbin, 120, this.m_nAshbinY, 17);
                g.drawString("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0432\u0435\u0442\u0440\u0430:" + this.m_nWindVelocityG, 120, tmp_nY, 33);
                this.drawPointer(g);
                break;
            }
            case 1: {
                switch (320) {
                    case 160: {
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 20, 17);
                        break;
                    }
                    case 320: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 110, tmp_nTmpShadowY, 17);
                        break;
                    }
                    case 220: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 40, 17);
                        break;
                    }
                    case 360: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 80, 17);
                        break;
                    }
                    case 240: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 40, 17);
                        break;
                    }
                    case 304: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 110, tmp_nTmpShadowY, 17);
                    }
                }
                g.drawImage(this.m_imgAshbin, 120, this.m_nAshbinY, 17);
                GraphicsTools.drawRegion(g, this.m_imgRubbish, 0, 0, this.m_imgRubbish.getWidth(), this.m_imgRubbish.getHeight(), this.m_nRubbishAnchor, this.m_nFlyX, this.m_nFlyY, 3);
                this.m_nRubbishState = this.m_nRubbishState >= 7 ? 0 : this.m_nRubbishState + 1;
                break;
            }
            case 2: {
                if (!this.m_bEnter) {
                    GraphicsTools.drawRegion(g, this.m_imgRubbish, 0, 0, this.m_imgRubbish.getWidth(), this.m_imgRubbish.getHeight(), this.m_nRubbishAnchor, this.m_nFlyX, this.m_nFlyY, 3);
                }
                switch (320) {
                    case 160: {
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 20, 17);
                        break;
                    }
                    case 320: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 110, tmp_nTmpShadowY, 17);
                        break;
                    }
                    case 220: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 40, 17);
                        break;
                    }
                    case 360: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 80, 17);
                        break;
                    }
                    case 240: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 40, 17);
                        break;
                    }
                    case 304: {
                        g.drawImage(this.m_imgScore, 0, 50, 20);
                        g.drawImage(this.m_imgShadow, 110, tmp_nTmpShadowY, 17);
                    }
                }
                g.drawImage(this.m_imgAshbin, 120, this.m_nAshbinY, 17);
                this.m_nRubbishState = this.m_nRubbishState >= 7 ? 0 : this.m_nRubbishState + 1;
                break;
            }
            case 3: {
                this.paintResult(g);
            }
        }
        this.drawKite(g);
        int tmp_nScore = 0;
        switch (this.m_nLevelIndex) {
            case 0: 
            case 1: {
                tmp_nScore = 7;
                break;
            }
            case 2: 
            case 3: {
                tmp_nScore = 5;
                break;
            }
            case 4: 
            case 5: {
                tmp_nScore = 3;
            }
        }
        switch (320) {
            case 320: {
                g.setColor(0xFFFFFF);
                g.drawString(": " + tmp_nScore, 33, 72, 33);
                g.drawString(": " + this.m_nContinuous, 33, 94, 33);
                break;
            }
            case 304: {
                g.setColor(0xFFFFFF);
                g.drawString(": " + tmp_nScore, 35, 72, 33);
                g.drawString(": " + this.m_nContinuous, 35, 94, 33);
                break;
            }
            case 360: {
                g.setColor(0xFFFFFF);
                g.drawString(": " + tmp_nScore, 44, 75, 33);
                g.drawString(": " + this.m_nContinuous, 44, 105, 33);
                break;
            }
            case 220: {
                g.setColor(0xFFFFFF);
                g.drawString(": " + tmp_nScore, 24, 65, 33);
                g.drawString(": " + this.m_nContinuous, 24, 90, 33);
                break;
            }
            case 240: {
                g.setColor(0xFFFFFF);
                g.drawString(": " + tmp_nScore, 30, 73, 33);
                g.drawString(": " + this.m_nContinuous, 30, 95, 33);
                break;
            }
            default: {
                g.setColor(0xFF0000);
                g.drawString("\u0423\u0441\u043f\u0435\u0445:" + this.m_nContinuous, 0, 15, 20);
                g.drawString("\u0426\u0435\u043b\u044c: 7", 0, 0, 20);
            }
        }
        if (this.m_bIsMenu) {
            this.paintMenu(g);
        } else {
            g.drawImage(this.m_imgIconMenu, 240, 320, 40);
        }
    }

    void loadRes() {
        this.m_aImgRubbishs = new Image[1][3][8];
        this.m_aImgSuccess = new Image[3];
        try {
            int i;
            this.m_imgBackGround = Image.createImage((String)("/background" + this.m_nLevelIndex + this.m_nBgIndex + ".png"));
            this.m_imgMenuBG = Image.createImage((String)"/menu.png");
            this.m_imgMenuBG2 = Image.createImage((String)"/menu2.png");
            this.m_imgHelpBG = Image.createImage((String)"/help_bg.png");
            this.m_imgIconMenu = Image.createImage((String)"/icon_menu.png");
            this.m_imgIconBack = Image.createImage((String)"/icon_back.png");
            this.m_imgSelectMenu = Image.createImage((String)"/select_menu.png");
            this.m_imgKite = Image.createImage((String)"/kite.png");
            this.m_imgArrow = Image.createImage((String)"/arrow_wind.png");
            this.m_imgAshbin = Image.createImage((String)("/ashbin" + this.m_nLevel + ".png"));
            int tmp_nRuLen = this.m_aImgRubbishs.length;
            for (i = 0; i < tmp_nRuLen; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.m_aImgRubbishs[i][j][0] = Image.createImage((String)("/rubbish" + i + j + "0.png"));
                    this.m_aImgRubbishs[i][j][1] = Image.createImage((String)("/rubbish" + i + j + "1.png"));
                    this.m_aImgRubbishs[i][j][2] = Image.createImage((String)("/rubbish" + i + j + "2.png"));
                    this.m_aImgRubbishs[i][j][3] = Image.createImage((String)("/rubbish" + i + j + "3.png"));
                    this.m_aImgRubbishs[i][j][4] = Image.createImage((String)("/rubbish" + i + j + "4.png"));
                    this.m_aImgRubbishs[i][j][5] = Image.createImage((String)("/rubbish" + i + j + "5.png"));
                    this.m_aImgRubbishs[i][j][6] = Image.createImage((String)("/rubbish" + i + j + "6.png"));
                    this.m_aImgRubbishs[i][j][7] = Image.createImage((String)("/rubbish" + i + j + "7.png"));
                }
            }
            tmp_nRuLen = this.m_aImgSuccess.length;
            for (i = 0; i < tmp_nRuLen; ++i) {
                this.m_aImgSuccess[i] = Image.createImage((String)("/success" + i + ".png"));
            }
            switch (320) {
                case 160: 
                case 220: 
                case 240: 
                case 304: 
                case 320: 
                case 360: {
                    this.m_imgShadow = Image.createImage((String)"/Shadow.png");
                    this.m_imgScore = Image.createImage((String)"/Score.png");
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void clearRes() {
        this.m_imgBackGround = null;
        this.m_imgMenuBG = null;
        this.m_imgMenuBG2 = null;
        this.m_imgHelpBG = null;
        this.m_imgIconMenu = null;
        this.m_imgIconBack = null;
        this.m_imgSelectMenu = null;
        this.m_imgKite = null;
        this.m_imgArrow = null;
        this.m_imgAshbin = null;
        this.m_imgRubbish = null;
        this.m_aImgRubbishs = null;
        this.m_aImgSuccess = null;
        this.m_imgSuccess = null;
        this.m_imgShadow = null;
        this.m_imgScore = null;
    }

    void setStatus(int _Status) {
        this.m_nStatus = _Status;
    }

    private void inputMenu(int key) {
        block26: {
            block0 : switch (this.m_nMenuLevel) {
                case 0: {
                    block4 : switch (key) {
                        case -1: 
                        case 50: {
                            this.m_nMenuIndex[this.m_nMenuLevel] = this.m_nMenuIndex[this.m_nMenuLevel] > 0 ? this.m_nMenuIndex[this.m_nMenuLevel] - 1 : this.m_anMenu.length - 1;
                            break;
                        }
                        case -2: 
                        case 56: {
                            this.m_nMenuIndex[this.m_nMenuLevel] = this.m_nMenuIndex[this.m_nMenuLevel] < this.m_anMenu.length - 1 ? this.m_nMenuIndex[this.m_nMenuLevel] + 1 : 0;
                            break;
                        }
                        case -5: 
                        case 53: {
                            switch (this.m_anMenu[this.m_nMenuIndex[this.m_nMenuLevel]]) {
                                case 0: {
                                    this.m_bIsMenu = false;
                                    break block4;
                                }
                                case 1: {
                                    this.m_nMenuLevel = 1;
                                    return;
                                }
                                case 2: {
                                    MusicPlayer.m_bSound = !MusicPlayer.m_bSound;
                                    break block4;
                                }
                                case 3: {
                                    this.m_nMenuLevel = 1;
                                    return;
                                }
                            }
                        }
                    }
                    return;
                }
                case 1: {
                    switch (this.m_anMenu[this.m_nMenuIndex[0]]) {
                        case 1: {
                            if (key == -7) {
                                this.m_nMenuLevel = 0;
                                break block0;
                            }
                            break block26;
                        }
                        case 3: {
                            switch (key) {
                                case -1: 
                                case 50: {
                                    this.m_nMenuIndex[this.m_nMenuLevel] = this.m_nMenuIndex[this.m_nMenuLevel] > 0 ? this.m_nMenuIndex[this.m_nMenuLevel] - 1 : 0;
                                    break block0;
                                }
                                case -2: 
                                case 56: {
                                    this.m_nMenuIndex[this.m_nMenuLevel] = this.m_nMenuIndex[this.m_nMenuLevel] < 1 ? this.m_nMenuIndex[this.m_nMenuLevel] + 1 : 1;
                                    break block0;
                                }
                                case -5: 
                                case 53: {
                                    if (this.m_nMenuIndex[this.m_nMenuLevel] == 0) {
                                        this.m_bIsClearRes = true;
                                        ScreenManage.setCurrentScreen(new MainMenuScreen());
                                        break block0;
                                    }
                                    this.m_nMenuIndex[this.m_nMenuLevel] = 0;
                                    this.m_nMenuLevel = 0;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void inputReady() {
        boolean tmp_bIsLeft = false;
        int tmp_nAngle = 90 - this.m_nAngle;
        if (this.m_nAngle > 90) {
            tmp_nAngle = this.m_nAngle - 90;
            tmp_bIsLeft = true;
        }
        int tmp_nX = (int)(MathTools.tan(MathTools.getRadian(tmp_nAngle)) * (double)this.m_nToVertexLen);
        if (tmp_bIsLeft) {
            tmp_nX = -tmp_nX;
        }
        this.m_nVertexX = this.m_nStartX + tmp_nX;
        this.m_nFlightSpeedX = tmp_nX / this.m_nToVertexFrame;
        this.m_nFlightSpeedY = -(this.m_nToVertexLen / this.m_nToVertexFrame);
        this.m_nFlyX = this.m_nStartX;
        this.m_nFlyY = this.m_nStartY;
        this.m_nRubbishSize = 0;
        this.m_nRubbishState = 0;
        this.m_nStatus = 1;
    }

    private void logicResult() {
        if ((long)this.m_nFrameCounter - this.m_nResultFrame < 20L) {
            return;
        }
        this.randomWind();
        this.m_nRubbishIndex = 0;
        this.m_imgRubbish = this.m_aImgRubbishs[this.m_nRubbishIndex][0][0];
        this.m_nAngle = 90 + this.m_nAngleW;
        this.m_bBinUp = true;
        this.m_bEnter = false;
        this.m_nStatus = 0;
    }

    private void logicToAshbin() {
        int tmp_nAshbinW = this.m_imgAshbin.getWidth() >> 1;
        int tmp_nRubbishW = this.m_imgRubbish.getWidth();
        int tmp_nRubbishWH = this.m_imgRubbish.getWidth() >> 1;
        int tmp_nAshbinHCenterW = tmp_nAshbinW / 5;
        int tmp_nAshbinLeftStartX = 120 - tmp_nAshbinW;
        int tmp_nAshbinLeftEndX = 120 + tmp_nAshbinW;
        this.m_bBinUp = false;
        if (this.m_nFlyX >= tmp_nAshbinLeftStartX && this.m_nFlyX - tmp_nRubbishW <= tmp_nAshbinLeftStartX) {
            this.m_nFlyX = tmp_nAshbinLeftStartX + tmp_nRubbishW;
        }
        if (this.m_nFlyX <= tmp_nAshbinLeftEndX && this.m_nFlyX + tmp_nRubbishW >= tmp_nAshbinLeftEndX) {
            this.m_nFlyX = tmp_nAshbinLeftEndX - tmp_nRubbishW;
        }
        if (this.m_nFlyX > tmp_nAshbinLeftStartX && this.m_nFlyX < tmp_nAshbinLeftEndX) {
            this.m_bEnter = true;
            this.m_bSuccess = this.m_nRubbishIndex % 2 == 0;
            return;
        }
        if (this.m_nFlyX > tmp_nAshbinLeftStartX - tmp_nRubbishWH && this.m_nFlyX < tmp_nAshbinLeftStartX) {
            if (this.m_nVertexX < 120) {
                this.m_nWindVelocity = -this.m_nWindVelocity;
            }
            this.m_bEnter = false;
            this.m_bSuccess = false;
            return;
        }
        this.m_bEnter = false;
        this.m_bSuccess = false;
    }

    private void paintMenu(Graphics g) {
        block0 : switch (this.m_nMenuLevel) {
            case 0: {
                String tmp_s = MusicPlayer.m_bSound ? "\u0412\u044b\u043a\u043b" : "\u0412\u044b\u043a\u043b";
                String[] tmp_aS1 = new String[]{"\u0412 \u0438\u0433\u0440\u0443", "\u041f\u043e\u043c\u043e\u0449\u044c", "\u0417\u0432\u0443\u043a" + tmp_s, "\u0413\u043b. \u041c\u0435\u043d\u044e"};
                this.drawMenuText(g, tmp_aS1);
                break;
            }
            case 1: {
                switch (this.m_anMenu[this.m_nMenuIndex[0]]) {
                    case 1: {
                        g.drawImage(this.m_imgHelpBG, 120, 160, 3);
                        g.drawImage(this.m_imgIconBack, 230, 310, 40);
                        break block0;
                    }
                    case 3: {
                        String[] tmp_aS2 = new String[]{"\u0414\u0430", "\u041d\u0435\u0442"};
                        this.drawMenuText(g, tmp_aS2);
                    }
                }
            }
        }
    }

    private void paintResult(Graphics g) {
        if (!this.m_bEnter) {
            GraphicsTools.drawRegion(g, this.m_imgRubbish, 0, 0, this.m_imgRubbish.getWidth(), this.m_imgRubbish.getHeight(), this.m_nRubbishAnchor, this.m_nFlyX, this.m_nFlyY, 3);
        }
        int tmp_nTmpShadowY = 0;
        switch (this.m_nLevelIndex) {
            case 0: 
            case 1: {
                tmp_nTmpShadowY = 206;
                break;
            }
            case 2: 
            case 3: {
                tmp_nTmpShadowY = 147;
                break;
            }
            case 4: 
            case 5: {
                tmp_nTmpShadowY = 81;
            }
        }
        switch (320) {
            case 160: {
                g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 20, 17);
                break;
            }
            case 220: {
                g.drawImage(this.m_imgScore, 0, 50, 20);
                g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 40, 17);
                break;
            }
            case 360: {
                g.drawImage(this.m_imgScore, 0, 50, 20);
                g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 80, 17);
                break;
            }
            case 320: {
                g.drawImage(this.m_imgScore, 0, 50, 20);
                g.drawImage(this.m_imgShadow, 110, tmp_nTmpShadowY, 17);
                break;
            }
            case 240: {
                g.drawImage(this.m_imgScore, 0, 50, 20);
                g.drawImage(this.m_imgShadow, 120, this.m_nAshbinY + 40, 17);
                break;
            }
            case 304: {
                g.drawImage(this.m_imgScore, 0, 50, 20);
                g.drawImage(this.m_imgShadow, 110, tmp_nTmpShadowY, 17);
            }
        }
        g.drawImage(this.m_imgAshbin, 120, this.m_nAshbinY, 17);
        int tmp_nCurrFrame = (int)((long)this.m_nFrameCounter - this.m_nResultFrame);
        if (this.m_bSuccess && tmp_nCurrFrame < 15) {
            this.m_imgSuccess = tmp_nCurrFrame < 5 ? this.m_aImgSuccess[2] : (tmp_nCurrFrame < 9 ? this.m_aImgSuccess[1] : this.m_aImgSuccess[0]);
            int tmp_nOffSetX = this.m_imgAshbin.getWidth() >> 2;
            int tmp_nOffSetY = this.m_nAshbinY - (this.m_imgSuccess.getHeight() * 3 >> 1);
            if (this.m_nLevel == 2) {
                tmp_nOffSetX = this.m_imgAshbin.getWidth() + this.m_aImgSuccess[0].getWidth() >> 1;
                tmp_nOffSetY += this.m_imgAshbin.getHeight();
            }
            if (this.m_nRubbishIndex % 2 == 1) {
                tmp_nOffSetX = -tmp_nOffSetX;
            }
            g.drawImage(this.m_imgSuccess, 120 + tmp_nOffSetX - 10, tmp_nOffSetY, 17);
        }
    }

    private void randomWind() {
        double tmp_dWind;
        do {
            tmp_dWind = MathTools.getRandom(-this.m_nMaxWindVelocity, this.m_nMaxWindVelocity);
            this.m_nWindVelocity = (int)tmp_dWind;
        } while (tmp_dWind == 0.0);
        this.m_bIsToRight = tmp_dWind > 0.0;
        String tmp_sFeng = String.valueOf(tmp_dWind / 7.0);
        int tmp_nSlen = tmp_sFeng.length();
        if (this.m_bIsToRight) {
            int tmp_nEndIndex = tmp_nSlen < 4 ? tmp_nSlen : 4;
            this.m_nWindVelocityG = tmp_sFeng.substring(0, tmp_nEndIndex);
        } else {
            int tmp_nEndIndex = tmp_nSlen < 5 ? tmp_nSlen : 5;
            this.m_nWindVelocityG = tmp_sFeng.substring(1, tmp_nEndIndex);
        }
    }

    private void rotor() {
        switch (this.m_nRubbishState) {
            case 0: {
                this.m_nRubbishAnchor = 0;
                break;
            }
            case 1: {
                this.m_nRubbishAnchor = 0;
                break;
            }
            case 2: {
                this.m_nRubbishAnchor = 5;
                break;
            }
            case 3: {
                this.m_nRubbishAnchor = 5;
                break;
            }
            case 4: {
                this.m_nRubbishAnchor = 3;
                break;
            }
            case 5: {
                this.m_nRubbishAnchor = 3;
                break;
            }
            case 6: {
                this.m_nRubbishAnchor = 6;
                break;
            }
            case 7: {
                this.m_nRubbishAnchor = 6;
            }
        }
    }

    private void drawPointer(Graphics g) {
        g.setColor(0xFF0000);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX - 1, this.m_nStartY - 1);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX - 1, this.m_nStartY);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX - 1, this.m_nStartY + 1);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX, this.m_nStartY - 1);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX, this.m_nStartY);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX, this.m_nStartY + 1);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX + 1, this.m_nStartY - 1);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX + 1, this.m_nStartY);
        g.drawLine(this.m_nPointerX, this.m_nPointerY, this.m_nStartX + 1, this.m_nStartY + 1);
    }

    private void drawMenuText(Graphics g, String[] as) {
        g.setFont(null);
        Image tmp_imgMenuBG = this.m_imgMenuBG;
        if (this.m_nMenuLevel == 1) {
            tmp_imgMenuBG = this.m_imgMenuBG2;
        }
        g.drawImage(tmp_imgMenuBG, 120, 160, 3);
        int tmp_nOffSetY = this.m_imgSelectMenu.getHeight() + 5;
        int tmp_nAsLen = as.length;
        int tmp_nStartX = 80;
        switch (320) {
            case 360: {
                tmp_nStartX = 130;
                break;
            }
            case 240: {
                tmp_nStartX = 130;
                break;
            }
            case 149: 
            case 160: {
                tmp_nStartX = 50;
                break;
            }
            case 204: 
            case 208: 
            case 220: {
                tmp_nStartX = 60;
            }
        }
        int tmp_nStartY = 160 - (tmp_nAsLen * tmp_nOffSetY >> 1);
        g.drawImage(this.m_imgSelectMenu, tmp_nStartX - 5, tmp_nStartY - 2 + this.m_nMenuIndex[this.m_nMenuLevel] * tmp_nOffSetY, 24);
        g.setColor(0);
        for (int i = 0; i < tmp_nAsLen; ++i) {
            g.drawString(as[i], tmp_nStartX, tmp_nStartY + i * tmp_nOffSetY, 20);
        }
    }

    private void drawKite(Graphics g) {
        int tmp_nOffSet = 5;
        int tmp_nOffSetPix = this.m_nFrameCounter % 4;
        if (this.m_bIsToRight) {
            GraphicsTools.drawRegion(g, this.m_imgKite, 0, 0, this.m_imgKite.getWidth(), this.m_imgKite.getHeight(), 2, 240 - tmp_nOffSet - tmp_nOffSetPix, tmp_nOffSet + tmp_nOffSetPix, 24);
        } else {
            g.drawImage(this.m_imgKite, tmp_nOffSet + tmp_nOffSetPix, tmp_nOffSet + tmp_nOffSetPix, 20);
        }
    }

    private int loadContinuous(int _level) {
        int[] tmp_an = new int[]{0, 0, 0, 0, 0, 0};
        if (RMSDB.existRecordStore("LY_EPHero_Continuous")) {
            tmp_an = RMSDB.getIntsRecord("LY_EPHero_Continuous", 1);
        } else {
            RMSDB.newRecordStore("LY_EPHero_Continuous");
            RMSDB.newRecord("LY_EPHero_Continuous", tmp_an);
        }
        return tmp_an[_level];
    }

    private void loadStageLock() {
        if (RMSDB.existRecordStore("LY_EPHero_Level")) {
            this.m_nRmsLevel = RMSDB.getIntegerRecord("LY_EPHero_Level", 1);
        } else {
            RMSDB.newRecordStore("LY_EPHero_Level");
            this.m_nRmsLevel = 0;
            RMSDB.newRecord("LY_EPHero_Level", this.m_nRmsLevel);
        }
    }
}

