/*
 * Decompiled with CFR 0.152.
 */
package com.linkyun.tools;

import com.linkyun.tools.PublicTools;
import javax.microedition.rms.RecordStore;

public class RMSDB {
    public static void newRecordStore(String recordStoreName) {
        try {
            String[] name = RecordStore.listRecordStores();
            for (int i = 0; name != null && i < name.length; ++i) {
                if (!name[i].equals(recordStoreName)) continue;
                RMSDB.deleteRecordStore(recordStoreName);
            }
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            return;
        }
    }

    public static int newRecord(String recordStoreName, byte data) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] d = new byte[]{data};
            int n = rs.addRecord(d, 0, d.length);
            rs.closeRecordStore();
            return n;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int newRecord(String recordStoreName, byte[] data) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] d = data;
            int n = rs.addRecord(d, 0, d.length);
            rs.closeRecordStore();
            return n;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int newRecord(String recordStoreName, int data) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] d = PublicTools.intToBytes(data);
            int n = rs.addRecord(d, 0, d.length);
            rs.closeRecordStore();
            return n;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int newRecord(String recordStoreName, int[] data) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] d = PublicTools.intsToBytes(data);
            int n = rs.addRecord(d, 0, d.length);
            rs.closeRecordStore();
            return n;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static int newRecord(String recordStoreName, String data) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] d = data.getBytes("UTF-8");
            int n = rs.addRecord(d, 0, d.length);
            rs.closeRecordStore();
            return n;
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static byte getByteRecord(String recordStoreName, int index) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] data = rs.getRecord(index);
            rs.closeRecordStore();
            return data[0];
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static byte[] getBytesRecord(String recordStoreName, int index) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] data = rs.getRecord(index);
            rs.closeRecordStore();
            return data;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static int getIntRecord(String recordStoreName, int index) {
        int record = 0;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] data = rs.getRecord(index);
            record = PublicTools.bytesToInt(data);
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            return 0;
        }
        return record;
    }

    public static int[] getIntsRecord(String recordStoreName, int index) {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] data = rs.getRecord(index);
            int[] tmp_an = PublicTools.bytesToInts(data);
            rs.closeRecordStore();
            return tmp_an;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getStringRecord(String recordStoreName, int index) {
        String record = null;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] data = rs.getRecord(index);
            rs.closeRecordStore();
            record = data == null ? "" : new String(data, "UTF-8");
        }
        catch (Exception ex) {
            return null;
        }
        return record;
    }

    public static void deleteRecordStore(String recordStoreName) {
        try {
            String[] name = RecordStore.listRecordStores();
            for (int i = 0; i < name.length; ++i) {
                if (!name[i].equals(recordStoreName)) continue;
                RecordStore.deleteRecordStore((String)recordStoreName);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteRecord(String recordStoreName, int index) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            record.deleteRecord(index);
            record.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateRecord(String recordStoreName, int index, byte data) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            byte[] d = new byte[]{data};
            record.setRecord(index, d, 0, d.length);
            record.closeRecordStore();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void updateRecord(String recordStoreName, int index, byte[] data) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] d = data;
            record.setRecord(index, d, 0, d.length);
            record.closeRecordStore();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void updateRecord(String recordStoreName, int index, int data) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            byte[] d = PublicTools.intToBytes(data);
            record.setRecord(index, d, 0, d.length);
            record.closeRecordStore();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void updateRecord(String recordStoreName, int index, int[] data) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordStoreName, (boolean)true);
            byte[] d = PublicTools.intsToBytes(data);
            record.setRecord(index, d, 0, d.length);
            record.closeRecordStore();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void updateRecord(String recordStoreName, int index, String data) {
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] d = data.getBytes("UTF-8");
            record.setRecord(index, d, 0, d.length);
            record.closeRecordStore();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static boolean existRecordStore(String recordStoreName) {
        boolean have = false;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            if (rs != null) {
                have = true;
            }
            rs.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return have;
    }

    public static int getRecordNum(String recordStoreName) {
        int num = 0;
        try {
            RecordStore record = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            num = record.getNumRecords();
            record.closeRecordStore();
        }
        catch (Exception ex) {
            return num;
        }
        return num;
    }

    public static int getIntegerRecord(String recordStoreName, int index) {
        int record = 0;
        try {
            RecordStore rs = RecordStore.openRecordStore((String)recordStoreName, (boolean)false);
            byte[] data = rs.getRecord(index);
            record = PublicTools.changeInteger(data);
            rs.closeRecordStore();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0;
        }
        return record;
    }
}

