/*
 * Decompiled with CFR 0.152.
 */
package com.game.util;

import com.game.util.Tools;

public final class OString {
    private int defaultColor;
    private int[][] markList;
    private String str;
    private int lenght;
    private static final String LBCOLOR = "<c";
    private static final String LBGT = ">";

    public OString(String str) {
        this(str, 0xFFFFFF);
    }

    public OString(String str, int color) {
        this.str = this.analyze(str);
        this.lenght = this.str.length();
        this.defaultColor = color;
    }

    public final int length() {
        return this.lenght;
    }

    public final char charAt(int index) {
        return this.str.charAt(index);
    }

    public final int getColor(int index) {
        if (this.markList != null && index >= this.markList[0][0]) {
            for (int i = 0; i < this.markList.length; ++i) {
                if (this.markList[i][0] > index || index >= this.markList[i][1]) continue;
                return this.markList[i][2];
            }
        }
        return this.defaultColor;
    }

    public final int getStringWidth() {
        return Tools.getStringWidth(this.str);
    }

    private final String analyze(String s) {
        int colorLen = 6;
        byte len = (byte)LBCOLOR.length();
        int lblen = 6 + len;
        int cspos = 0;
        int start_pos = 0;
        int pos = 0;
        StringBuffer sb = new StringBuffer();
        while (pos != -1) {
            String str1;
            pos = s.indexOf(LBCOLOR, start_pos);
            if (pos > -1) {
                str1 = s.substring(start_pos, pos);
                sb.append(str1);
                start_pos = pos + len;
                String clr = s.substring(start_pos, start_pos + 6);
                int color1 = Integer.parseInt(clr, 16);
                int rpos = s.indexOf(LBGT, start_pos += 6);
                if (this.markList == null) {
                    cspos = lblen;
                    this.markList = new int[][]{{start_pos - cspos, rpos - cspos, color1}};
                } else {
                    this.markList = Tools.exPandArray(this.markList, 1);
                    this.markList[this.markList.length - 1] = new int[]{start_pos - (cspos += lblen + LBGT.length()), rpos - cspos, color1};
                }
                if (rpos == -1) continue;
                String strc = s.substring(start_pos, rpos);
                sb.append(strc);
                start_pos = rpos + LBGT.length();
                continue;
            }
            if (start_pos >= s.length()) continue;
            str1 = s.substring(start_pos);
            sb.append(str1);
        }
        return sb.toString();
    }
}

