/*
 * Decompiled with CFR 0.152.
 */
public final class GameLogicFillingShooter
extends GameLogicShooter {
    private static final byte BULLET_MAX = 3;
    private static final byte BULLET_LAST = 2;
    private static final int PLAYER_SIZE = 1;
    private static final int LIFE_MAX = 3;
    private static final byte SCORE_INC = 20;
    private static final byte STEP_INC = 3;
    private static final byte STEP_RES = 4;
    private int iLineToEmpty = -2;
    private boolean isOnDeleting = false;
    private int iFillingPos = -1;

    public GameLogicFillingShooter() {
        this.firstKeydownDelay = 90;
        SCORE_UP_MIN = 200;
        SCORE_UP_INC = 80;
    }

    public final void save() throws Exception {
        super.save();
        GUtillIo.writeInt(this.iLineToEmpty);
        GUtillIo.writeBoolean(this.isOnDeleting);
        GUtillIo.writeInt(this.iFillingPos);
    }

    public final void load() throws Exception {
        super.load();
        this.iLineToEmpty = GUtillIo.readInt();
        this.isOnDeleting = GUtillIo.readBoolean();
        this.iFillingPos = GUtillIo.readInt();
    }

    public void updateState() {
        if (!this.isOnDeleting) {
            super.updateState();
        }
    }

    public void keyClicked(int key) {
        if (key == 7 && !this.active) {
            this.active = true;
        } else if (this.canUpdate() && this.active && !this.isOnDeleting) {
            if (key == 7 && !this.isOnDeleting && this.iArrBulletPos[2] == -1) {
                int pos = this.figure_pos[0] + GameField.step[2];
                if (GameField.getBrickType(pos + GameField.step[2]) != 1) {
                    GUtillArray.insert(this.iArrBulletPos, pos, 0);
                    GameField.setBrickType(pos, 5);
                } else {
                    GameField.setBrickType(pos, 1);
                    this.lifeDecr();
                }
            }
            byte[] border = GameField.border(this.figure_pos[0]);
            if (E.keyIsPressed(6)) {
                if (!GUtillArray.contains(border, (byte)1)) {
                    this.figure_pos[0] = this.figure_pos[0] - 1;
                }
            } else if (E.keyIsPressed(8) && !GUtillArray.contains(border, (byte)2)) {
                this.figure_pos[0] = this.figure_pos[0] + 1;
            }
        }
    }

    public boolean updateEvent() {
        if (this.canUpdate()) {
            if (this.active && !this.isOnDeleting) {
                int j = 0;
                for (int i = 0; i < 3 && !this.isOnDeleting; ++i) {
                    int next = this.iArrBulletPos[2 - i];
                    for (j = 0; j <= 3 && next >= 0; next += GameField.step[2], ++j) {
                        if (GameField.getBrickType(next + GameField.step[2]) == 5) {
                            GameField.setBrickType(next, 5);
                            this.iFillingPos = next;
                            this.checkScore();
                            break;
                        }
                        if (GameField.getBrickType(next + GameField.step[2] * 2) != 1) continue;
                        GameField.setBrickType(next + GameField.step[2], 1);
                        this.iFillingPos = next + GameField.step[2];
                        this.checkScore();
                        break;
                    }
                    GameField.setBrickType(this.iArrBulletPos[2 - i], 0);
                    if (j == 4) {
                        this.iArrBulletPos[2 - i] = next;
                        GameField.setBrickType(this.iArrBulletPos[2 - i], 5);
                        continue;
                    }
                    this.iArrBulletPos[2 - i] = -1;
                    GUtillArray.moveOut(this.iArrBulletPos, 2 - i, 2);
                }
            } else if (this.isOnDeleting) {
                this.checkScore();
            }
        }
        return false;
    }

    private void checkScore() {
        int i;
        int lineToClean = -1;
        boolean full = false;
        int width = 10;
        for (i = this.iFillingPos / 10; i >= 0; --i) {
            int j;
            int last = i * 10;
            int first = last + 10 - 1;
            full = true;
            for (j = first; j >= last && (full &= GameField.getBrickType(j) == 1); --j) {
            }
            if (!full) continue;
            for (j = first; j >= last; --j) {
                GameField.setBrickType(j, 0);
            }
            lineToClean = first / 10;
            this.isOnDeleting = true;
            break;
        }
        if (lineToClean != -1) {
            for (i = this.sLast - 1; i >= lineToClean * 10; --i) {
                GameField.setBrickType(i, 0);
            }
            this.score += 20;
            this.CurrentScore += 20;
            this.iLineToEmpty = -2;
            this.isOnDeleting = false;
            this.iFillingPos = -1;
            lineToClean = -1;
        }
    }

    protected void placePlayer() {
        super.placePlayer();
        for (int i = 0; i < this.iArrBulletPos.length; ++i) {
            this.iArrBulletPos[0] = 0;
        }
        this.isOnDeleting = false;
        this.iFillingPos = -1;
    }
}

