/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.common;

public class EventQueue {
    private int[][] eventQueue;
    private int eventQueueTop;
    private int eventQueueBottom;
    private short m_size;

    public EventQueue(short size) {
        this.m_size = size;
        this.eventQueueTop = 0;
        this.eventQueueBottom = 0;
        this.eventQueue = new int[size][2];
    }

    public synchronized boolean pushEvent(int key, int event) {
        if (this.eventQueueBottom == this.eventQueueTop - 1 || this.eventQueueBottom == this.m_size && this.eventQueueTop == 0) {
            return false;
        }
        this.eventQueue[this.eventQueueTop][0] = key;
        this.eventQueue[this.eventQueueTop][1] = event;
        --this.eventQueueTop;
        if (this.eventQueueTop < 0) {
            this.eventQueueTop = this.m_size - 1;
        }
        return true;
    }

    public synchronized int[] popEvent() {
        if (this.eventQueueBottom == this.eventQueueTop) {
            return null;
        }
        int[] ret = this.eventQueue[this.eventQueueBottom--];
        if (this.eventQueueBottom < 0) {
            this.eventQueueBottom = this.m_size - 1;
        }
        return ret;
    }

    public synchronized void clearEvents() {
        this.eventQueueTop = 0;
        this.eventQueueBottom = 0;
    }

    public void destroy() {
        this.eventQueue = null;
    }
}

