/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.common;

public class StateStack {
    private short[] m_stateStack;
    private short m_stackTop;
    private short m_size;

    public StateStack(short size) {
        this.m_size = size;
        this.m_stackTop = (short)-1;
        this.m_stateStack = new short[size];
    }

    public synchronized boolean pushState(short state) {
        if (this.m_stackTop == this.m_size) {
            return false;
        }
        this.m_stackTop = (short)(this.m_stackTop + 1);
        this.m_stateStack[this.m_stackTop] = state;
        return true;
    }

    public synchronized short popState() {
        short res;
        if (this.m_stackTop == -1) {
            res = -1;
        } else {
            short s = this.m_stackTop;
            this.m_stackTop = (short)(s - 1);
            res = this.m_stateStack[s];
        }
        return res;
    }

    public synchronized short getTop() {
        short res = this.m_stackTop == -1 ? (short)-1 : this.m_stateStack[this.m_stackTop];
        return res;
    }

    public synchronized short getPreviousState() {
        int pos = this.m_stackTop - 1;
        short res = this.m_stackTop < 0 ? (short)-1 : this.m_stateStack[pos];
        return res;
    }

    public synchronized boolean returnToState(short state) {
        boolean found = false;
        while (!found && this.m_stackTop != -1) {
            this.m_stackTop = (short)(this.m_stackTop - 1);
            if (this.m_stateStack[this.m_stackTop] != state) continue;
            found = true;
        }
        return found;
    }

    public synchronized void clearStack() {
        this.m_stackTop = (short)-1;
    }

    public synchronized int getElementCount() {
        return this.m_stackTop + 1;
    }

    public void destroy() {
        this.m_stateStack = null;
    }
}

