/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.party;

import com.kitmaker.games.common.TextBuffer;
import com.kitmaker.games.party.Game;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.rms.RecordStore;

public class Persister {
    private TextBuffer m_textBuffer;

    public Persister(TextBuffer textBuffer) {
        this.m_textBuffer = textBuffer;
    }

    public void destroy() {
        this.m_textBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte createProfile(String name, String[] inUseNames) {
        RecordStore recordStore = null;
        int res = 1;
        String lastUnusedName = null;
        if (name.length() == 0 || name.equals(this.m_textBuffer.getText(24))) {
            res = -1;
        } else {
            try {
                recordStore = RecordStore.openRecordStore((String)"names", (boolean)true);
            }
            catch (Exception e) {
                res = -1;
            }
        }
        if (res == 1) {
            byte[] buffer = null;
            try {
                buffer = recordStore.getRecord(1);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
                DataInputStream reader = new DataInputStream(inputStream);
                int profileCount = reader.readByte();
                boolean exists = false;
                for (int i = 0; i < profileCount; ++i) {
                    String str = reader.readUTF();
                    if (str.equals(name)) {
                        exists = true;
                    }
                    int j = 0;
                    boolean used = false;
                    while (!used && j < inUseNames.length) {
                        if (inUseNames[j] != null && inUseNames[j].equals(str)) {
                            used = true;
                            continue;
                        }
                        ++j;
                    }
                    if (used) continue;
                    lastUnusedName = str;
                }
                reader.close();
                inputStream.close();
                reader = null;
                inputStream = null;
                if (exists) {
                    res = -2;
                } else if (profileCount == 10 && lastUnusedName == null) {
                    res = -3;
                } else {
                    boolean mustRemove = false;
                    if (profileCount < 10) {
                        profileCount = (byte)(profileCount + 1);
                    } else {
                        mustRemove = true;
                    }
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DataOutputStream writer = new DataOutputStream(outputStream);
                    writer.writeByte(profileCount);
                    writer.writeUTF(name);
                    inputStream = new ByteArrayInputStream(buffer);
                    reader = new DataInputStream(inputStream);
                    reader.readByte();
                    int writeCount = 0;
                    for (int j = 0; j < profileCount - 1; ++j) {
                        String str = reader.readUTF();
                        if (!mustRemove || !str.equals(lastUnusedName)) {
                            writer.writeUTF(str);
                            ++writeCount;
                            continue;
                        }
                        --j;
                    }
                    if (mustRemove && writeCount < profileCount) {
                        writer.writeUTF(lastUnusedName);
                    }
                    lastUnusedName = null;
                    reader.close();
                    inputStream.close();
                    reader = null;
                    inputStream = null;
                    writer.close();
                    outputStream.close();
                    byte[] finalBuffer = outputStream.toByteArray();
                    recordStore.setRecord(1, finalBuffer, 0, finalBuffer.length);
                    writer = null;
                    outputStream = null;
                    buffer = null;
                    finalBuffer = null;
                }
            }
            catch (Exception e) {
                try {
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    DataOutputStream writer = new DataOutputStream(outputStream);
                    writer.writeByte(1);
                    writer.writeUTF(name);
                    writer.close();
                    outputStream.close();
                    buffer = outputStream.toByteArray();
                    recordStore.addRecord(buffer, 0, buffer.length);
                    writer = null;
                    outputStream = null;
                    buffer = null;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {}
                recordStore = null;
            }
        }
        return (byte)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToRanking(String name, int score) {
        boolean res = false;
        String[] names = null;
        int[] scores = null;
        Object[][] ranking = this.getRanking();
        if (ranking != null) {
            names = new String[ranking.length];
            scores = new int[ranking.length];
            for (int i = 0; i < names.length; ++i) {
                scores[i] = (Integer)ranking[i][0];
                names[i] = (String)ranking[i][1];
            }
            ranking = null;
        }
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"rank", (boolean)true);
        }
        catch (Exception e) {
            recordStore = null;
        }
        if (recordStore != null) {
            String[] finalNames;
            int[] finalScores;
            if (names == null) {
                finalScores = new int[1];
                finalNames = new String[]{name};
                finalScores[0] = score;
                res = true;
            } else {
                int i;
                if (scores.length == 10) {
                    finalScores = scores;
                    finalNames = names;
                } else {
                    finalScores = new int[scores.length + 1];
                    finalNames = new String[scores.length + 1];
                    for (i = 0; i < scores.length; ++i) {
                        finalScores[i] = scores[i];
                        finalNames[i] = names[i];
                    }
                    finalScores[scores.length] = Integer.MIN_VALUE;
                    finalNames[scores.length] = null;
                }
                for (i = 0; i < finalScores.length; ++i) {
                    if (score <= finalScores[i]) continue;
                    if (i == 0) {
                        res = true;
                    }
                    for (int j = finalScores.length - 1; j > i; --j) {
                        finalScores[j] = finalScores[j - 1];
                        finalNames[j] = finalNames[j - 1];
                    }
                    finalScores[i] = score;
                    finalNames[i] = name;
                    break;
                }
            }
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                DataOutputStream writer = new DataOutputStream(outputStream);
                writer.writeInt(finalScores.length);
                for (int i = 0; i < finalScores.length; ++i) {
                    writer.writeInt(finalScores[i]);
                    writer.writeUTF(finalNames[i]);
                }
                writer.close();
                outputStream.close();
                byte[] buffer = outputStream.toByteArray();
                if (scores != null) {
                    recordStore.setRecord(1, buffer, 0, buffer.length);
                } else {
                    recordStore.addRecord(buffer, 0, buffer.length);
                }
                writer = null;
                outputStream = null;
                buffer = null;
            }
            catch (Exception e) {
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {}
                recordStore = null;
            }
            finalNames = null;
            finalScores = null;
        }
        scores = null;
        names = null;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[][] getRanking() {
        String[] names;
        int[] scores;
        RecordStore recordStore = null;
        Object[][] res = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"rank", (boolean)false);
        }
        catch (Exception e) {
            recordStore = null;
        }
        if (recordStore != null) {
            byte[] buffer = null;
            try {
                buffer = recordStore.getRecord(1);
                if (buffer != null) {
                    int i;
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
                    DataInputStream reader = new DataInputStream(inputStream);
                    int count = reader.readInt();
                    scores = new int[count];
                    names = new String[count];
                    for (i = 0; i < count; ++i) {
                        scores[i] = reader.readInt();
                        names[i] = reader.readUTF();
                    }
                    reader.close();
                    inputStream.close();
                    reader = null;
                    inputStream = null;
                    res = new Object[count][2];
                    for (i = 0; i < count; ++i) {
                        res[i][0] = new Integer(scores[i]);
                        res[i][1] = names[i];
                    }
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {}
                recordStore = null;
            }
        }
        scores = null;
        names = null;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSavedNames() {
        RecordStore recordStore = null;
        String[] res = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"names", (boolean)true);
        }
        catch (Exception e) {
            recordStore = null;
        }
        if (recordStore != null) {
            byte[] buffer = null;
            try {
                buffer = recordStore.getRecord(1);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
                DataInputStream reader = new DataInputStream(inputStream);
                byte profileCount = reader.readByte();
                res = new String[profileCount + 1];
                res[0] = this.m_textBuffer.getText(24);
                for (int i = 1; i < profileCount + 1; ++i) {
                    String str;
                    res[i] = str = reader.readUTF();
                }
                reader.close();
                inputStream.close();
                reader = null;
                inputStream = null;
            }
            catch (Exception e) {
                res = new String[]{this.m_textBuffer.getText(24)};
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {}
                recordStore = null;
            }
        }
        return res;
    }

    public void writeOptions(Game game) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"opt", (boolean)true);
        }
        catch (Exception e) {
            recordStore = null;
        }
        if (recordStore != null) {
            try {
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                DataOutputStream writer = new DataOutputStream(outputStream);
                writer.writeBoolean(game.isSoundEnabled());
                writer.close();
                outputStream.close();
                byte[] buffer = outputStream.toByteArray();
                try {
                    recordStore.getRecord(1);
                    recordStore.setRecord(1, buffer, 0, buffer.length);
                }
                catch (Exception e2) {
                    recordStore.addRecord(buffer, 0, buffer.length);
                }
                writer = null;
                outputStream = null;
                buffer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOptions(Game game) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"opt", (boolean)true);
        }
        catch (Exception e) {
            recordStore = null;
        }
        if (recordStore != null) {
            byte[] buffer = null;
            try {
                buffer = recordStore.getRecord(1);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
                DataInputStream reader = new DataInputStream(inputStream);
                game.setSound(reader.readBoolean());
                reader.close();
                inputStream.close();
                reader = null;
                inputStream = null;
            }
            catch (Exception e) {
                this.writeOptions(game);
            }
            finally {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception e) {}
                recordStore = null;
            }
        }
    }
}

