/*
 * Decompiled with CFR 0.152.
 */
package elventales.avoider.util;

import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class PlayerData {
    private static PlayerData instance;
    public static final int LEVEL_LOCKED = 0;
    public static final int LEVEL_OPEN = 1;
    public static final int LEVEL_COMPLETED = 2;
    public int[] levelState = new int[7];
    public int[] levelScore = new int[7];

    public static PlayerData getInstance() {
        if (instance == null) {
            instance = new PlayerData();
        }
        return instance;
    }

    public PlayerData() {
        this.resetData();
    }

    public final void resetData() {
        for (int i = 0; i < 7; ++i) {
            this.levelState[i] = 0;
            this.levelScore[i] = 0;
        }
        this.levelState[0] = 1;
    }

    public boolean unlockLevel(int index, int score) {
        boolean isHighscore = false;
        this.levelState[index] = 2;
        this.levelScore[index] = score;
        if (index < this.levelState.length - 1) {
            this.levelState[index + 1] = 1;
        }
        if (this.levelScore[index] < score) {
            isHighscore = true;
        }
        return isHighscore;
    }

    public void Clear() {
        try {
            RecordStore.deleteRecordStore((String)"SkyExpressSaveData");
        }
        catch (RecordStoreException ex) {
            System.out.println("Clear " + (Object)((Object)ex));
        }
    }

    public void Load() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"SkyExpressSaveData", (boolean)true);
            if (rs.getNumRecords() > 0) {
                String record = new String(rs.getRecord(1));
                this.ByteDecoder(record);
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            System.out.println("Load " + (Object)((Object)ex));
        }
    }

    public void Save() {
        try {
            RecordStore.deleteRecordStore((String)"SkyExpressSaveData");
            RecordStore rs = RecordStore.openRecordStore((String)"SkyExpressSaveData", (boolean)true);
            byte[] bytes = this.ByteEncoder();
            rs.addRecord(bytes, 0, bytes.length);
            rs.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            System.out.println("Save " + (Object)((Object)ex));
        }
    }

    private byte[] ByteEncoder() {
        int i;
        String temp = "";
        for (i = 0; i < this.levelState.length; ++i) {
            temp = temp + this.levelState[i] + "|";
        }
        for (i = 0; i < this.levelScore.length; ++i) {
            temp = temp + this.levelScore[i] + "|";
        }
        return temp.getBytes();
    }

    private void ByteDecoder(String string) {
        int pointer = 0;
        int counter = 0;
        for (int i = 0; i < 10; ++i) {
            while (++counter < string.length() && string.charAt(counter) != '|') {
            }
            if (i < 5) {
                this.levelState[i] = Integer.parseInt(string.substring(pointer, counter));
            } else {
                this.levelScore[i - 5] = Integer.parseInt(string.substring(pointer, counter));
            }
            pointer = ++counter;
        }
    }
}

