/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

public class TKFighter
implements ICollidable {
    public static final int MAX_FIGHTERS_IN_POOL = 14;
    public static final int FIGHTER_STARTING_HEALTH_POINTS = 100;
    public static TKFighter[] s_fightersPool;
    public static AALTileset[][] s_fightersTilesets;
    public static GTKAnim[][] s_fightersAnims;
    public static short[][][] s_fightersHitboxes;
    public static short[][][] s_fightersAttacks;
    public static short[][] s_fightersImpacts;
    public static byte[][] s_fightersMatrix;
    public static short[][] s_fightersChains;
    public static int s_fightersCount;
    private static final int MAX_INPUT_BUFFER_LENGTH = 15;
    private int[] m_inputBuffer;
    short[][][] m_comboData;
    public int m_comboCounter;
    private boolean m_isStandGuarding;
    private boolean m_isCrouchGuarding;
    private int m_inputBufferOffset;
    private int m_techingState;
    private int m_techingTimer;
    private TKFighter m_fighterThrown;
    private TKFighter m_fighterThrowing;
    public int m_currentThrow;
    public int m_currentThrowEscape;
    public int m_currentOutfitId;
    public static final int THROW_NONE = 0;
    public static final int THROW_FORWARD = 1;
    public static final int THROW_BACKWARD = 2;
    public static final int TECHING_STATE_PENDING = 0;
    public static final int TECHING_STATE_FAIL = 1;
    public static final int TECHING_STATE_SUCCESS = 2;
    private static final int TECHING_TIME_WINDOW = 300;
    private int m_standingUpDirection;
    private static final int STANDING_UP_DIRECTION_BACKWARD = 0;
    private static final int STANDING_UP_DIRECTION_NEUTRAL = 1;
    private static final int STANDING_UP_DIRECTION_FORWARD = 2;
    private static int s_maximumNeutralTime;
    private static final int LYING_DOWN_TIMEOUT = 500;
    int m_freezeTimer;
    private static final int IMPACT_FREEZE_DURATION_LIGHT = 50;
    private static final int IMPACT_FREEZE_DURATION_STRONG = 100;
    private static final int INPUT_UP = 1;
    private static final int INPUT_DOWN = 2;
    private static final int INPUT_BACKWARD = 4;
    private static final int INPUT_FORWARD = 8;
    private static final int INPUT_LIGHT_PUNCH = 16;
    private static final int INPUT_HEAVY_PUNCH = 32;
    private static final int INPUT_LIGHT_KICK = 64;
    private static final int INPUT_HEAVY_KICK = 128;
    private static final int INPUT_NEUTRAL = 256;
    private static final int INPUT_BITS_COUNT = 9;
    public static final int TEKKEN_KEY_NONE = -1;
    public static final int TEKKEN_KEY_JUMP_BACKWARD = 0;
    public static final int TEKKEN_KEY_JUMP_NEUTRAL = 1;
    public static final int TEKKEN_KEY_JUMP_FORWARD = 2;
    public static final int TEKKEN_KEY_BACKWARD = 3;
    public static final int TEKKEN_KEY_FORWARD = 4;
    public static final int TEKKEN_KEY_CROUCH = 5;
    public static final int TEKKEN_KEY_PUNCH = 6;
    public static final int TEKKEN_KEY_KICK = 7;
    public static final int TEKKEN_KEY_THROW = 8;
    public static final int TEKKEN_KEY_COUNTER = 9;
    public static final int TEKKEN_KEY_DODGE = 10;
    public static final int TEKKEN_KEY_SFK_LEFT = 11;
    public static final int TEKKEN_KEY_SFK_RIGHT = 12;
    public static final int TEKKEN_KEY_COUNTS = 13;
    public static final int[][] TEKKEN_KEYMAP;
    public static final int KEYMAP_CONTROLS_ADVANCED = 0;
    public static final int KEYMAP_CONTROLS_BEGINNER = 1;
    public static final int MAX_TFM_JUGGLE_COUNT = 5;
    private static final int INPUT_QCF = 0;
    private static final int INPUT_HCF = 1;
    private static final int INPUT_QCB = 2;
    private static final int INPUT_HCB = 3;
    private static final int INPUT_CBF = 4;
    private static final int INPUT_BF = 5;
    private static final int INPUT_FB = 6;
    private static final int INPUT_FF = 7;
    private static final int INPUT_CC = 8;
    private static final int INPUT_BB = 9;
    private static final int INPUT_B = 10;
    private static final int INPUT_F = 11;
    private static final int INPUT_U = 12;
    private static final int INPUT_D = 13;
    private static final int INPUT_NO = 14;
    private static final int INPUT_AIR = 15;
    private static final int INPUT_STEP_ATTACK = 16;
    private static final int INPUTS_COUNT = 17;
    private static final int INPUTS_ATTACK_TYPES_COUNT = 4;
    private static final int[] PATTERN;
    private static final int FIGHTER_WEIGHT = 7;
    public static boolean isBattleOver;
    public static AALTileset s_fightersShadowsTileset;
    private static GTKAnim[] s_fightersShadowsAnims;
    public static AALTileset s_fightersFXImpactTileset;
    private static GTKAnim s_fightersFXImpactAnim;
    public static final int COMBO_DATA_CURRENT_ATTACK = 0;
    public static final int COMBO_DATA_REQUIRED_COMMAND = 1;
    public static final int COMBO_DATA_TEKKEN_KEY = 2;
    public static final int COMBO_DATA_TIME_RANGE_MIN = 3;
    public static final int COMBO_DATA_TIME_RANGE_MAX = 4;
    public static final int COMBO_DATA_CANCEL_TIMER = 5;
    public static final int SIZEOF_COMBO_ATTACK = 6;
    public static final int FIGHTER_STATE_STAND = 0;
    public static final int FIGHTER_STATE_WALK_FORWARD = 1;
    public static final int FIGHTER_STATE_DASH_FORWARD = 2;
    public static final int FIGHTER_STATE_WALK_BACKWARD = 3;
    public static final int FIGHTER_STATE_DASH_BACKWARD = 4;
    public static final int FIGHTER_STATE_CROUCH = 5;
    public static final int FIGHTER_STATE_JUMP_IN = 6;
    public static final int FIGHTER_STATE_JUMP_FALL = 7;
    public static final int FIGHTER_STATE_JUMP_LAND = 8;
    public static final int FIGHTER_STATE_STEP_START = 9;
    public static final int FIGHTER_STATE_STEP_END = 10;
    public static final int FIGHTER_STATE_STAND_HIT = 11;
    public static final int FIGHTER_STATE_STAND_HIT_LOW = 12;
    public static final int FIGHTER_STATE_STAND_HIT_MID = 13;
    public static final int FIGHTER_STATE_STAND_HIT_HIGH = 14;
    public static final int FIGHTER_STATE_AIR_HIT = 15;
    public static final int FIGHTER_STATE_STAND_GUARD = 16;
    public static final int FIGHTER_STATE_CROUCH_GUARD = 17;
    public static final int FIGHTER_STATE_THROW_CONNECT = 18;
    public static final int FIGHTER_STATE_THROW_CAUGHT = 19;
    public static final int FIGHTER_STATE_LYING_DOWN = 20;
    public static final int FIGHTER_STATE_STANDING_UP_BACKWARD = 21;
    public static final int FIGHTER_STATE_STANDING_UP_NEUTRAL = 22;
    public static final int FIGHTER_STATE_STANDING_UP_FORWARD = 23;
    public static final int FIGHTER_STATE_TECHING_BACKWARD = 24;
    public static final int FIGHTER_STATE_TECHING_NEUTRAL = 25;
    public static final int FIGHTER_STATE_TECHING_FORWARD = 26;
    public static final int FIGHTER_STATE_WIN_POSING = 27;
    public static final int FIGHTER_STATE_ATTACK = 28;
    public static final int FIGHTER_STANDARD_STATES_COUNT = 28;
    public int[] m_physicsData;
    public int[] m_impactData = null;
    public int[] m_lastImpactData = null;
    public int m_lastAttackTimer;
    public int m_chainComboCounter;
    public short m_currentAttackId;
    public short m_currentComboId;
    public boolean m_autoComboEnabled;
    public short m_currentComboStep;
    public short m_currentThrowAttackId;
    public short m_nextAttackId;
    public int m_nextAttackTimer;
    public int m_animInstance;
    public int m_currentAnimId;
    public int m_healthPoints;
    public int m_blockStunTimer;
    public int m_hitStunTimer;
    public int m_state;
    public int m_stateTimer;
    public int m_fighterID;
    public int m_orientation;
    public int m_tempFlags;
    public static final int TEMP_FLAG_JUST_ON_GROUND = 1;
    public static final int TEMP_FLAG_JUST_ON_WALL = 2;
    private static final int FP_DAMAGE_RATIO = 245;
    private static final int FIGHTER_MAX_BLOCKSTUN_TIMER = 400;
    public int m_queriedOrientation;
    public boolean m_isActive;
    public boolean m_isAIControlled;
    public boolean m_isPracticeModeDummy;
    public boolean m_isOnGround;
    public int m_juggleCount;
    public byte[] m_data;
    private int[] m_attacksProperties;
    private long m_attacksInMatrix;
    private int m_fpFighterDashVectorX = 12800;
    private int m_stepDuration = 750;
    private boolean m_isTrajectoryReversed = false;
    private int m_queuedState = -1;
    private int m_currentJumpDirection = 0;
    private static final int FIGHTER_JUMP_FORWARD = 0;
    private static final int FIGHTER_JUMP_NEUTRAL = 1;
    private static final int FIGHTER_JUMP_BACKWARD = 2;
    public int m_totalPoints;
    public int m_currentPoints;
    private static final int LIGHT_PUNCH_POINTS = 15;
    private static final int STRONG_PUNCH_POINTS = 50;
    private static final int LIGHT_KICK_POINTS = 20;
    private static final int STRONG_KICK_POINTS = 50;
    private static final int STEP_ATTACK_POINTS = 100;
    private static final int LOW_ATTACK_POINTS = 30;
    private static final int JUMP_ATTACK_POINTS = 30;
    private static final int THROW_ATTACK_POINTS = 100;
    private static final int COMBO_BONUS_POINTS = 30;
    public static final int PERFECT_BONUS_POINTS = 500;
    public static final int TIME_BONUS_POINTS = 10;
    public static final int LIFE_BONUS_POINTS = 1;
    private boolean m_isImpactDrawn = false;
    private int m_impactInstance;
    public static final int CONTROLS_TYPE_PRO_SYSTEM = 0;
    public static final int CONTROLS_TYPE_NORMAL_SYSTEM = 1;
    public static final int CONTROLS_TYPE_AUTO_SYSTEM = 2;
    private static final int ATTACK_BUFFER_TIMER = 300;
    private static final int TFM_TURN_DELAY = 200;
    private static final int ANTI_THROW_TIMER = 3000;
    public boolean m_disableControls;
    public int m_controlsType;
    public boolean m_disableAI;
    private short m_bufferAttackId;
    private int m_bufferAttackTimer;
    private short m_detectedAttackId;
    private int m_fpBufferXAdjustment;
    private int m_fpTotalBufferXAdjustment;
    private boolean m_comboFailed;
    private boolean m_attackConnected;
    private short m_maxAutoComboSteps;
    private boolean m_toggleBlink;
    private static int m_antiThrowTimer;
    private int m_techingDirection;
    public static int s_currentKeymap;
    private static final int FIGHTER_STATE_COLLSIONBOX_START = 0;
    private static final int FIGHTER_STATE_COLLSIONBOX_END = 1;
    private static final int FIGHTER_STATE_COLLSIONBOX_TOP = 2;
    private static final int FIGHTER_STATE_COLLSIONBOX_LEFT = 3;
    private static final int FIGHTER_STATE_COLLSIONBOX_RIGHT = 4;
    private static final int FIGHTER_STATE_COLLSIONBOX_BOTTOM = 5;
    private static final int FIGHTER_STATE_DATA_LENGTH = 6;
    private static final int ATTACK_ANIMATION_ID = 0;
    private static final int ATTACK_COLLISIONBOX = 1;
    private static final int ATTACK_TRAJECTORY = 2;
    private static final int ATTACK_COLLSIONBOX_START = 1;
    private static final int ATTACK_COLLSIONBOX_END = 2;
    private static final int ATTACK_COLLSIONBOX_TOP = 3;
    private static final int ATTACK_COLLSIONBOX_LEFT = 4;
    private static final int ATTACK_COLLSIONBOX_RIGHT = 5;
    private static final int ATTACK_COLLSIONBOX_BOTTOM = 6;
    private static final int ATTACK_COLLSIONBOX_IMPACT_ID = 7;
    private static final int ATTACK_COLLISIONBOX_DATA_LENGTH = 8;
    private static final int ATTACKS_DATA_LENGTH = 4;
    private static final int ATTACKS_PROPERTY_IMPACT_START_TIMER = 0;
    private static final int ATTACKS_PROPERTY_IMPACT_END_TIMER = 1;
    private static final int ATTACKS_PROPERTY_IMPACT_ID = 2;
    private static final int ATTACKS_PROPERTY_IMPACT_MASK = 3;
    private static final int ATTACKS_PROPERTIES_LENGTH = 4;
    public static final int CHAIN_DATA_COMBO_ID = 0;
    public static final int CHAIN_DATA_CHAIN_COUNTER = 1;
    public static final int CHAIN_DATA_CURRENT_ATTACK_ID = 2;
    public static final int CHAIN_DATA_TIME_RANGE_MIN = 3;
    public static final int CHAIN_DATA_TIME_RANGE_MAX = 4;
    public static final int CHAIN_DATA_REQUIRED_INPUT = 5;
    public static final int CHAIN_DATA_NEXT_ATTACK_ID = 6;
    public static final int CHAIN_DATA_NEXT_ATTACK_TIMER = 7;
    public static final int SIZEOF_CHAIN_DATA = 8;
    private static final int ATTACK_STATUS_NONE = -1;
    private static final int ATTACK_STATUS_PREPARE = 0;
    private static final int ATTACK_STATUS_ACTIVE = 1;
    private static final int ATTACK_STATUS_RECOVER = 2;
    public int m_currentPattern;
    public int m_currentPatternStep;
    public static int s_aiRandomTimer;
    public static final int AI_PATTERN_DASH_THROW = 0;
    public static final int AI_PATTERN_JUMP = 1;
    public static final int AI_PATTERN_JUMP_ATTACK = 2;
    public static final int AI_PATTERN_WALK_JUMP_ATTACK = 3;
    public static final int AI_PATTERN_JUMP_RANDOM = 4;
    public static final int AI_PATTERN_DODGE_ATTACK = 5;
    public static final int AI_PATTERN_DASH_COMBO = 6;
    public static final int AI_PATTERN_10_HIT_COMBO = 7;
    public static final int AI_PATTERN_LOW_ATTACK = 8;
    public static final int AI_PATTERN_DASH_POKE = 9;
    public static final int AI_PATTERN_BACKDASH_ATTACK = 10;
    public static final int AI_PATTERN_CROUCH_LAUNCHER = 11;
    public static final int AI_PATTERN_WALK_RANDOM = 12;
    public static final int AI_PATTERN_CROUCH_N_PUNISH = 13;
    public static final int AI_PATTERN_DODGE_N_PUNISH = 14;
    public static final int AI_PATTERN_GUARD_N_PUNISH = 15;
    public static final int AI_PATTERNS_COUNT = 16;
    public static final int AI_PATTERNS_GROUP_ZONING = 0;
    public static final int AI_PATTERNS_GROUP_ESCAPING = 1;
    public static final int AI_PATTERNS_GROUP_ATTACKING = 2;
    public static final int[][] AI_PATTERNS_BY_GROUP;
    private static final int AI_STATE_TIMEOUT = 3000;
    private static final int GROUND_JUGGLE_MAX_TIMER = 200;
    public int m_currentTestPattern = -1;
    private int m_aiLevel;
    private boolean m_autoPunish;
    private boolean m_aiUltimateDefense;
    private int s_aiLatencyTimer;
    private int m_aiStateTimer;
    private static final int TECH_BACKWARD = 0;
    private static final int TECH_NEUTRAL = 1;
    private static final int TECH_FORWARD = 2;
    private static final int STANDING_UP_BACKWARD = 0;
    private static final int STANDING_UP_NEUTRAL = 1;
    private static final int STANDING_UP_FORWARD = 2;
    public static final int DAMAGE_REMOVE_DELAY = 2000;
    private int m_lastDamageTimer;
    private static int s_lastKeyPressed;
    private static int s_lastKeyTimesPressed;
    private static int s_lastKeyPressedTimer;
    private static final int SPAM_TIMEOUT = 1000;
    private static final int SPAM_TOLERANCY = 5;
    private final int DUMMY_ACTION_DELAY = 1000;
    private final int DUMMY_BEHAVIOUR_STAND = 0;
    private final int DUMMY_BEHAVIOUR_CROUCH = 1;
    private final int DUMMY_BEHAVIOUR_JUMP_NEUTRAL = 2;
    private final int DUMMY_BEHAVIOUR_JUMP_FORWARD = 3;
    private final int DUMMY_BEHAVIOUR_JUMP_BACKWARD = 4;
    private final int DUMMY_BEHAVIOUR_ATTACK_LOW = 5;
    private final int DUMMY_BEHAVIOUR_ATTACK_MID = 6;
    private final int DUMMY_BEHAVIOUR_ATTACK_HIGH = 7;
    private final int DUMMY_BEHAVIOUR_AI = 8;
    private final int DUMMY_BEHAVIOUR_THROW = 9;
    private final int DUMMY_GUARD_NO = 0;
    private final int DUMMY_GUARD_AFTER_HIT = 1;
    private final int DUMMY_GUARD_ALL = 2;
    private final int DUMMY_TECH_NO = 0;
    private final int DUMMY_TECH_FORWARD = 1;
    private final int DUMMY_TECH_BACKWARD = 2;
    private final int DUMMY_TECH_NEUTRAL = 3;
    private final int DUMMY_TECH_RANDOM = 4;

    private TKFighter() {
    }

    public static void fighterLoadResources(int p_fighterId, int p_outfitId, DataInputStream p_stream) {
        try {
            int[] gfxDeclarations = new int[p_stream.readByte() * 2];
            for (int i = 0; i < gfxDeclarations.length / 2; ++i) {
                gfxDeclarations[2 * i] = p_stream.readInt();
                gfxDeclarations[2 * i + 1] = p_stream.readBoolean() ? 1 : 0;
            }
            p_stream.readByte();
            int tmpTilesetId = p_stream.readInt();
            if (p_outfitId > 0) {
                int[] basePalette = GameMidlet.OUTFITS[p_fighterId][0];
                int[] destinationPalette = null;
                if (p_outfitId == 7) {
                    GameMidlet.rmsLoadCustom();
                    destinationPalette = GameMidlet.s_playersCustomPalettes[p_fighterId];
                    if (destinationPalette != null) {
                        AALDevice.s_forcePaletteCopy = true;
                    }
                } else {
                    destinationPalette = GameMidlet.OUTFITS[p_fighterId][p_outfitId];
                }
                if (destinationPalette == null) {
                    destinationPalette = GameMidlet.OUTFITS[p_fighterId][0];
                }
                if (AALDevice.s_forcePaletteCopy) {
                    AALDevice.setColorRemap(destinationPalette, destinationPalette);
                } else {
                    AALDevice.setColorRemap(basePalette, destinationPalette);
                }
            }
            if (null == s_fightersTilesets[p_fighterId][p_outfitId]) {
                TKFighter.s_fightersTilesets[p_fighterId][p_outfitId] = AALDevice.createTileset(++tmpTilesetId, false);
            }
            AALDevice.s_forcePaletteCopy = false;
            int animId = 0;
            if (null == s_fightersAnims[p_fighterId]) {
                TKFighter.s_fightersAnims[p_fighterId] = new GTKAnim[gfxDeclarations.length / 2];
                for (int i = 0; i < gfxDeclarations.length; i += 2) {
                    if (gfxDeclarations[i] != -1) {
                        TKFighter.s_fightersAnims[p_fighterId][animId] = GTKAnim.loadAnimation(gfxDeclarations[i], gfxDeclarations[i + 1]);
                    }
                    ++animId;
                }
            }
        }
        catch (Exception e) {
            AALMidlet.outputDebugString(e.getMessage());
            e.printStackTrace();
        }
    }

    public static void initPool() {
        s_fightersPool = new TKFighter[14];
        s_fightersCount = 0;
        for (int i = 0; i < s_fightersPool.length; ++i) {
            TKFighter.s_fightersPool[i] = new TKFighter();
            TKFighter.s_fightersPool[i].m_physicsData = new int[5];
            TKFighter.s_fightersPool[i].m_lastImpactData = new int[8];
            s_fightersPool[i].cleanup();
            TKFighter.s_fightersPool[i].m_inputBuffer = new int[15];
            TKFighter.s_fightersPool[i].m_inputBufferOffset = 0;
        }
        s_fightersTilesets = new AALTileset[8][8];
        s_fightersAnims = new GTKAnim[8][];
        s_fightersHitboxes = new short[8][][];
        s_fightersAttacks = new short[8][][];
        s_fightersImpacts = new short[8][];
        s_fightersMatrix = new byte[8][];
        s_fightersChains = new short[8][];
        try {
            s_fightersFXImpactTileset = AALDevice.createTileset(16777370, false);
            s_fightersFXImpactAnim = GTKAnim.loadAnimation(16777254, 0);
            s_fightersShadowsTileset = AALDevice.createTileset(16777381, false);
            s_fightersShadowsAnims = new GTKAnim[4];
            TKFighter.s_fightersShadowsAnims[0] = GTKAnim.loadAnimation(16777330, 1);
            TKFighter.s_fightersShadowsAnims[1] = GTKAnim.loadAnimation(16777331, 1);
            TKFighter.s_fightersShadowsAnims[2] = GTKAnim.loadAnimation(16777332, 1);
            TKFighter.s_fightersShadowsAnims[3] = GTKAnim.loadAnimation(16777333, 1);
        }
        catch (Exception e) {
            AALMidlet.outputDebugString("Error during shadows loading : " + e.getMessage());
        }
    }

    public static void updateFighters() {
        for (int i = 0; i < s_fightersPool.length; ++i) {
            if (!TKFighter.s_fightersPool[i].m_isActive) continue;
            s_fightersPool[i].update();
        }
    }

    public static void drawFighters() {
        for (int pass = 0; pass < 3; ++pass) {
            for (int i = 0; i < s_fightersPool.length; ++i) {
                boolean fighterBehind;
                if (!TKFighter.s_fightersPool[i].m_isActive) continue;
                boolean bl = fighterBehind = TKFighter.s_fightersPool[i].m_state == 9 || TKFighter.s_fightersPool[i].m_state == 10 || TKFighter.s_fightersPool[i].m_state == 19;
                if (pass == 0) {
                    s_fightersPool[i].drawShadow();
                } else if (pass == 1 && fighterBehind || pass == 2 && !fighterBehind) {
                    s_fightersPool[i].draw();
                }
                if (pass != 2 || !TKFighter.s_fightersPool[i].m_isImpactDrawn) continue;
                int x = (TKFighter.s_fightersPool[i].m_physicsData[0] >> 8) - GameMidlet.s_cameraLeft;
                int y = (GameMidlet.s_fpGroundLevel >> 8) - GameMidlet.s_cameraTop;
                s_fightersFXImpactAnim.drawInstance(TKFighter.s_fightersPool[i].m_impactInstance, s_fightersFXImpactTileset, x, y, 0);
            }
        }
    }

    private void drawShadow() {
        int fpHeight = GameMidlet.s_fpGroundLevel - this.m_physicsData[1] >> 8;
        int shadowId = 0;
        if (fpHeight > 48) {
            shadowId = 3;
        } else if (fpHeight > 32) {
            shadowId = 2;
        } else if (fpHeight > 16) {
            shadowId = 1;
        }
        int x = (this.m_physicsData[0] >> 8) - GameMidlet.s_cameraLeft;
        int y = (GameMidlet.s_fpGroundLevel >> 8) - GameMidlet.s_cameraTop;
        GTKAnim shadowAnim = s_fightersShadowsAnims[shadowId];
        shadowAnim.drawInstance(1, s_fightersShadowsTileset, x, y, 0);
    }

    public static void cleanupPool() {
        s_fightersAnims = null;
        s_fightersTilesets = null;
        s_fightersPool = null;
        s_fightersHitboxes = null;
        s_fightersAttacks = null;
        s_fightersImpacts = null;
        s_fightersMatrix = null;
        s_fightersChains = null;
        s_fightersShadowsTileset = null;
        s_fightersShadowsAnims = null;
        s_fightersFXImpactTileset = null;
        s_fightersFXImpactAnim = null;
    }

    private void executeCommand(int p_commandId, int p_attackId) {
        if (!this.m_isOnGround) {
            p_commandId = 15;
        }
        if (this.m_state == 28) {
            this.updateComboInputDetection();
        }
        if (this.m_state == 9) {
            p_commandId = 16;
        }
        this.m_detectedAttackId = (short)-1;
        switch (p_attackId << 23 >> 23) {
            case 16: {
                this.m_detectedAttackId = s_fightersMatrix[this.m_fighterID][(p_commandId << 2) + 0];
                break;
            }
            case 32: {
                this.m_detectedAttackId = s_fightersMatrix[this.m_fighterID][(p_commandId << 2) + 1];
                break;
            }
            case 64: {
                this.m_detectedAttackId = s_fightersMatrix[this.m_fighterID][(p_commandId << 2) + 2];
                break;
            }
            case 128: {
                this.m_detectedAttackId = s_fightersMatrix[this.m_fighterID][(p_commandId << 2) + 3];
            }
        }
    }

    public int getCommandOfAttack(int p_attackId) {
        int validCommandId = -1;
        for (int currentCommand = 0; currentCommand < 17; ++currentCommand) {
            if (s_fightersMatrix[this.m_fighterID][currentCommand * 4 + 1] == p_attackId) {
                validCommandId = currentCommand * 4 + 1;
            }
            if (s_fightersMatrix[this.m_fighterID][currentCommand * 4 + 3] != p_attackId) continue;
            validCommandId = currentCommand * 4 + 3;
        }
        return validCommandId;
    }

    public short getTekkenKeyOfAttack(int p_attackId) {
        short tekkenKey = -1;
        for (int currentCommand = 0; currentCommand < 17; ++currentCommand) {
            if (s_fightersMatrix[this.m_fighterID][currentCommand * 4 + 1] == p_attackId) {
                return 6;
            }
            if (s_fightersMatrix[this.m_fighterID][currentCommand * 4 + 3] != p_attackId) continue;
            return 7;
        }
        return tekkenKey;
    }

    private void detectPaterns(int p_detectOffset) {
        for (int i = 0; i < PATTERN.length; ++i) {
            int patternLength = PATTERN[i + 1];
            int k = 0;
            boolean isThisPattern = true;
            for (int j = patternLength; j > 0; --j) {
                if (p_detectOffset - k < 0) {
                    if (15 + p_detectOffset - k == 0) {
                        isThisPattern = false;
                        break;
                    }
                    if ((this.m_inputBuffer[15 + p_detectOffset - k] & 0x100) != 0) {
                        if (this.m_inputBuffer[15 + p_detectOffset - k] >> 9 < s_maximumNeutralTime) {
                            ++j;
                            ++k;
                            continue;
                        }
                        isThisPattern = false;
                        break;
                    }
                    if ((this.m_inputBuffer[15 + p_detectOffset - k] & PATTERN[i + 1 + j]) == 0) {
                        isThisPattern = false;
                        break;
                    }
                    ++k;
                    continue;
                }
                if ((this.m_inputBuffer[p_detectOffset - k] & 0x100) != 0) {
                    if (this.m_inputBuffer[p_detectOffset - k] >> 9 < s_maximumNeutralTime) {
                        ++j;
                        ++k;
                        continue;
                    }
                    isThisPattern = false;
                    break;
                }
                if ((this.m_inputBuffer[p_detectOffset - k] & PATTERN[i + 1 + j]) == 0) {
                    isThisPattern = false;
                    break;
                }
                ++k;
            }
            if (isThisPattern) {
                this.executeCommand(PATTERN[i], this.m_inputBuffer[this.m_inputBufferOffset]);
                return;
            }
            i += patternLength + 1;
        }
    }

    private void doTranslateKeysPressed() {
        int tekkenKey = this.getTekkenKey();
        if ((this.m_inputBuffer[this.m_inputBufferOffset] & 8) != 0 && tekkenKey == 4) {
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] >> 9;
            int n = this.m_inputBufferOffset;
            this.m_inputBuffer[n] = this.m_inputBuffer[n] + GameMidlet.s_ingameElapsedTimeClamped;
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] << 9;
            int n2 = this.m_inputBufferOffset;
            this.m_inputBuffer[n2] = this.m_inputBuffer[n2] + 8;
        } else if ((this.m_inputBuffer[this.m_inputBufferOffset] & 4) != 0 && tekkenKey == 3) {
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] >> 9;
            int n = this.m_inputBufferOffset;
            this.m_inputBuffer[n] = this.m_inputBuffer[n] + GameMidlet.s_ingameElapsedTimeClamped;
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] << 9;
            int n3 = this.m_inputBufferOffset;
            this.m_inputBuffer[n3] = this.m_inputBuffer[n3] + 4;
        } else if ((this.m_inputBuffer[this.m_inputBufferOffset] & 1) != 0 && tekkenKey == 1) {
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] >> 9;
            int n = this.m_inputBufferOffset;
            this.m_inputBuffer[n] = this.m_inputBuffer[n] + GameMidlet.s_ingameElapsedTimeClamped;
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] << 9;
            int n4 = this.m_inputBufferOffset;
            this.m_inputBuffer[n4] = this.m_inputBuffer[n4] + 1;
        } else if ((this.m_inputBuffer[this.m_inputBufferOffset] & 0x100) != 0 && tekkenKey == -1) {
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] >> 9;
            int n = this.m_inputBufferOffset;
            this.m_inputBuffer[n] = this.m_inputBuffer[n] + GameMidlet.s_ingameElapsedTimeClamped;
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] << 9;
            int n5 = this.m_inputBufferOffset;
            this.m_inputBuffer[n5] = this.m_inputBuffer[n5] + 256;
        } else if ((this.m_inputBuffer[this.m_inputBufferOffset] & 2) != 0 && tekkenKey == 5) {
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] >> 9;
            int n = this.m_inputBufferOffset;
            this.m_inputBuffer[n] = this.m_inputBuffer[n] + GameMidlet.s_ingameElapsedTimeClamped;
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] << 9;
            int n6 = this.m_inputBufferOffset;
            this.m_inputBuffer[n6] = this.m_inputBuffer[n6] + 2;
        } else if ((this.m_inputBuffer[this.m_inputBufferOffset] & 0x20) != 0 && tekkenKey == 6) {
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] >> 9;
            int n = this.m_inputBufferOffset;
            this.m_inputBuffer[n] = this.m_inputBuffer[n] + GameMidlet.s_ingameElapsedTimeClamped;
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] << 9;
            int n7 = this.m_inputBufferOffset;
            this.m_inputBuffer[n7] = this.m_inputBuffer[n7] + 32;
        } else if ((this.m_inputBuffer[this.m_inputBufferOffset] & 0x80) != 0 && tekkenKey == 7) {
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] >> 9;
            int n = this.m_inputBufferOffset;
            this.m_inputBuffer[n] = this.m_inputBuffer[n] + GameMidlet.s_ingameElapsedTimeClamped;
            this.m_inputBuffer[this.m_inputBufferOffset] = this.m_inputBuffer[this.m_inputBufferOffset] << 9;
            int n8 = this.m_inputBufferOffset;
            this.m_inputBuffer[n8] = this.m_inputBuffer[n8] + 128;
        } else {
            if (s_lastKeyPressed == tekkenKey && s_lastKeyPressedTimer > 0) {
                ++s_lastKeyTimesPressed;
                s_lastKeyPressedTimer = 1000;
            } else if (tekkenKey == 6 || tekkenKey == 7 || tekkenKey == 8) {
                s_lastKeyPressed = tekkenKey;
                s_lastKeyTimesPressed = 0;
                s_lastKeyPressedTimer = 1000;
            }
            if (tekkenKey == 4) {
                this.m_inputBufferOffset = (this.m_inputBufferOffset + 1) % 15;
                this.m_inputBuffer[this.m_inputBufferOffset] = 8;
            } else if (tekkenKey == 3) {
                this.m_inputBufferOffset = (this.m_inputBufferOffset + 1) % 15;
                this.m_inputBuffer[this.m_inputBufferOffset] = 4;
            } else if (tekkenKey == 1) {
                this.m_inputBufferOffset = (this.m_inputBufferOffset + 1) % 15;
                this.m_inputBuffer[this.m_inputBufferOffset] = 1;
            } else if (tekkenKey == 5) {
                this.m_inputBufferOffset = (this.m_inputBufferOffset + 1) % 15;
                this.m_inputBuffer[this.m_inputBufferOffset] = 2;
            } else if (tekkenKey == 6) {
                this.m_inputBufferOffset = (this.m_inputBufferOffset + 1) % 15;
                this.m_inputBuffer[this.m_inputBufferOffset] = 32;
                if (this.m_inputBufferOffset > 0) {
                    this.detectPaterns(this.m_inputBufferOffset - 1);
                } else {
                    this.detectPaterns(14);
                }
            } else if (tekkenKey == 7) {
                this.m_inputBufferOffset = (this.m_inputBufferOffset + 1) % 15;
                this.m_inputBuffer[this.m_inputBufferOffset] = 128;
                if (this.m_inputBufferOffset > 0) {
                    this.detectPaterns(this.m_inputBufferOffset - 1);
                } else {
                    this.detectPaterns(14);
                }
            } else {
                this.m_inputBufferOffset = (this.m_inputBufferOffset + 1) % 15;
                this.m_inputBuffer[this.m_inputBufferOffset] = 256;
            }
        }
    }

    public static TKFighter createFighter(int p_fighterId, int p_posX, int p_posY, int p_outfitId) {
        AALDevice.clearKeyStates();
        if (s_fightersCount < 14) {
            int id = s_fightersCount;
            TKFighter newFighter = s_fightersPool[id];
            newFighter.m_isActive = true;
            newFighter.m_fighterID = p_fighterId;
            newFighter.m_physicsData[0] = p_posX << 8;
            newFighter.m_physicsData[1] = p_posY << 8;
            newFighter.m_data = GameMidlet.FIGHTER_DATA[p_fighterId];
            newFighter.m_currentPoints = 0;
            newFighter.m_currentOutfitId = p_outfitId;
            boolean isDataRead = false;
            isDataRead = s_fightersAttacks[p_fighterId] != null && s_fightersImpacts[p_fighterId] != null && s_fightersMatrix[p_fighterId] != null && s_fightersHitboxes[p_fighterId] != null && s_fightersTilesets[p_fighterId][p_outfitId] != null;
            try {
                int combosCount;
                int i;
                int j;
                int i2;
                int m_attacksCount;
                DataInputStream stream = AALDevice.openFileAsStream(GameMidlet.FIGHTER_DATA_TABLE[p_fighterId]);
                if (!isDataRead) {
                    TKFighter.fighterLoadResources(p_fighterId, p_outfitId, stream);
                }
                if (!isDataRead) {
                    m_attacksCount = stream.readUnsignedByte();
                    TKFighter.s_fightersAttacks[p_fighterId] = new short[m_attacksCount * 4][];
                } else {
                    m_attacksCount = s_fightersAttacks[p_fighterId].length / 4;
                }
                newFighter.m_attacksProperties = new int[m_attacksCount * 4];
                for (int k = 0; k < newFighter.m_attacksProperties.length; ++k) {
                    newFighter.m_attacksProperties[k] = -1;
                }
                for (i2 = 0; i2 < m_attacksCount; ++i2) {
                    int m_collisionBoxesCount;
                    int attackOffset = i2 * 4;
                    if (!isDataRead) {
                        TKFighter.s_fightersAttacks[p_fighterId][attackOffset] = new short[1];
                        TKFighter.s_fightersAttacks[p_fighterId][attackOffset][0] = (short)stream.readUnsignedByte();
                        m_collisionBoxesCount = stream.readUnsignedByte();
                        TKFighter.s_fightersAttacks[p_fighterId][attackOffset + 1] = new short[m_collisionBoxesCount * 8];
                    } else {
                        m_collisionBoxesCount = s_fightersAttacks[p_fighterId][attackOffset + 1].length / 8;
                    }
                    for (j = 0; j < m_collisionBoxesCount; ++j) {
                        int attackSubOffet = j * 8;
                        int attackCollisionBoxOffset = attackOffset + 1;
                        if (!isDataRead) {
                            TKFighter.s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 0] = (short)stream.readUnsignedByte();
                            TKFighter.s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 1] = (short)stream.readUnsignedShort();
                            TKFighter.s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 2] = (short)stream.readUnsignedShort();
                            TKFighter.s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 3] = (short)(stream.readByte() * 32 / 32);
                            TKFighter.s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 4] = (short)(stream.readByte() * 32 / 32);
                            TKFighter.s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 5] = (short)(stream.readByte() * 32 / 32);
                            TKFighter.s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 6] = (short)(stream.readByte() * 32 / 32);
                            TKFighter.s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 7] = stream.readByte();
                        }
                        if (s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 0] == 0) continue;
                        int propertiesOffset = i2 * 4;
                        int start = s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 1];
                        int end = s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 2];
                        int impactId = s_fightersAttacks[p_fighterId][attackCollisionBoxOffset][attackSubOffet + 7];
                        if (newFighter.m_attacksProperties[propertiesOffset + 0] > start || newFighter.m_attacksProperties[propertiesOffset + 0] == -1) {
                            newFighter.m_attacksProperties[propertiesOffset + 0] = start;
                            newFighter.m_attacksProperties[propertiesOffset + 2] = impactId;
                        }
                        if (newFighter.m_attacksProperties[propertiesOffset + 1] >= end && newFighter.m_attacksProperties[propertiesOffset + 1] != -1) continue;
                        newFighter.m_attacksProperties[propertiesOffset + 1] = end;
                        newFighter.m_attacksProperties[propertiesOffset + 2] = impactId;
                    }
                    if (isDataRead) continue;
                    int m_trajectoryCount = stream.readUnsignedByte();
                    TKFighter.s_fightersAttacks[p_fighterId][i2 * 4 + 2] = new short[m_trajectoryCount * 5];
                    for (j = 0; j < m_trajectoryCount; ++j) {
                        int attackTrajectoryOffset = attackOffset + 2;
                        TKFighter.s_fightersAttacks[p_fighterId][attackTrajectoryOffset][j + 0] = stream.readByte();
                        TKFighter.s_fightersAttacks[p_fighterId][attackTrajectoryOffset][j + 1] = stream.readShort();
                        TKFighter.s_fightersAttacks[p_fighterId][attackTrajectoryOffset][j + 2] = stream.readShort();
                        TKFighter.s_fightersAttacks[p_fighterId][attackTrajectoryOffset][j + 3] = (short)(stream.readShort() * 32 / 32);
                        TKFighter.s_fightersAttacks[p_fighterId][attackTrajectoryOffset][j + 4] = (short)(stream.readShort() * 32 / 32);
                    }
                }
                if (!isDataRead) {
                    int m_impactsCount = stream.readUnsignedByte();
                    TKFighter.s_fightersImpacts[p_fighterId] = new short[m_impactsCount * 6];
                    for (i = 0; i < m_impactsCount; ++i) {
                        int impactOffset = i * 6;
                        TKFighter.s_fightersImpacts[p_fighterId][impactOffset + 0] = (short)(stream.readShort() * 32 / 32);
                        TKFighter.s_fightersImpacts[p_fighterId][impactOffset + 1] = (short)(stream.readShort() * 32 / 32);
                        TKFighter.s_fightersImpacts[p_fighterId][impactOffset + 3] = (short)stream.readUnsignedShort();
                        TKFighter.s_fightersImpacts[p_fighterId][impactOffset + 2] = (short)stream.readUnsignedShort();
                        TKFighter.s_fightersImpacts[p_fighterId][impactOffset + 4] = (short)stream.readUnsignedShort();
                        TKFighter.s_fightersImpacts[p_fighterId][impactOffset + 5] = (short)stream.readUnsignedByte();
                    }
                }
                if (!isDataRead) {
                    TKFighter.s_fightersMatrix[p_fighterId] = new byte[68];
                    newFighter.m_attacksInMatrix = 0L;
                    for (i2 = 0; i2 < 68; ++i2) {
                        TKFighter.s_fightersMatrix[p_fighterId][i2] = (byte)stream.readUnsignedByte();
                        newFighter.m_attacksInMatrix |= 1L << s_fightersMatrix[p_fighterId][i2];
                    }
                    TKFighter.s_fightersMatrix[p_fighterId][45] = s_fightersMatrix[p_fighterId][56];
                    TKFighter.s_fightersMatrix[p_fighterId][47] = s_fightersMatrix[p_fighterId][58];
                } else {
                    newFighter.m_attacksInMatrix = 0L;
                    for (i2 = 0; i2 < 68; ++i2) {
                        newFighter.m_attacksInMatrix |= 1L << s_fightersMatrix[p_fighterId][i2];
                    }
                }
                if (!isDataRead) {
                    TKFighter.s_fightersHitboxes[p_fighterId] = new short[28][];
                    for (i = 0; i < 28; ++i) {
                        int m_hitboxesCount = stream.readUnsignedByte();
                        TKFighter.s_fightersHitboxes[p_fighterId][i] = new short[m_hitboxesCount * 6];
                        for (j = 0; j < m_hitboxesCount; ++j) {
                            int colboxOffset = j * 6;
                            TKFighter.s_fightersHitboxes[p_fighterId][i][colboxOffset + 0] = (short)stream.readUnsignedShort();
                            TKFighter.s_fightersHitboxes[p_fighterId][i][colboxOffset + 1] = (short)stream.readUnsignedShort();
                            TKFighter.s_fightersHitboxes[p_fighterId][i][colboxOffset + 2] = (short)(stream.readShort() * 32 / 32);
                            TKFighter.s_fightersHitboxes[p_fighterId][i][colboxOffset + 3] = (short)(stream.readShort() * 32 / 32);
                            TKFighter.s_fightersHitboxes[p_fighterId][i][colboxOffset + 4] = (short)(stream.readShort() * 32 / 32);
                            TKFighter.s_fightersHitboxes[p_fighterId][i][colboxOffset + 5] = (short)(stream.readShort() * 32 / 32);
                        }
                    }
                }
                if (!isDataRead) {
                    int m_combosCount = stream.readUnsignedByte();
                    TKFighter.s_fightersChains[p_fighterId] = new short[8 * m_combosCount];
                    int comboId = -1;
                    for (int i3 = 0; i3 < m_combosCount; ++i3) {
                        TKFighter.s_fightersChains[p_fighterId][i3 * 8 + 1] = (short)stream.readUnsignedByte();
                        TKFighter.s_fightersChains[p_fighterId][i3 * 8 + 2] = (short)stream.readUnsignedByte();
                        TKFighter.s_fightersChains[p_fighterId][i3 * 8 + 3] = (short)stream.readUnsignedShort();
                        TKFighter.s_fightersChains[p_fighterId][i3 * 8 + 4] = (short)stream.readUnsignedShort();
                        TKFighter.s_fightersChains[p_fighterId][i3 * 8 + 5] = (short)stream.readUnsignedByte();
                        TKFighter.s_fightersChains[p_fighterId][i3 * 8 + 6] = (short)stream.readUnsignedByte();
                        TKFighter.s_fightersChains[p_fighterId][i3 * 8 + 7] = (short)stream.readUnsignedShort();
                        if (s_fightersChains[p_fighterId][i3 * 8 + 1] == 0) {
                            comboId = (short)(comboId + 1);
                        }
                        TKFighter.s_fightersChains[p_fighterId][i3 * 8 + 0] = comboId;
                    }
                    combosCount = comboId + 1;
                } else {
                    combosCount = s_fightersChains[p_fighterId][(s_fightersChains[p_fighterId].length / 8 - 1) * 8 + 0] + 1;
                }
                newFighter.m_comboData = new short[combosCount][][];
                short previousComboId = -1;
                int currentComboSize = -1;
                for (int offset = 0; offset < s_fightersChains[p_fighterId].length; offset += 8) {
                    short currentComboId = s_fightersChains[p_fighterId][offset + 0];
                    if (currentComboId > previousComboId) {
                        if (previousComboId >= 0) {
                            newFighter.m_comboData[previousComboId] = new short[currentComboSize][6];
                        }
                        currentComboSize = 2;
                    } else {
                        ++currentComboSize;
                    }
                    previousComboId = currentComboId;
                }
                newFighter.m_comboData[previousComboId] = new short[currentComboSize][6];
                int currentAttackId = 0;
                short[] chains = s_fightersChains[p_fighterId];
                for (int chainOffset = 0; chainOffset < chains.length; chainOffset += 8) {
                    short currentComboId = chains[chainOffset + 0];
                    if (currentComboId > previousComboId) {
                        currentAttackId = 0;
                    }
                    short c_currentAttack = chains[chainOffset + 2];
                    short c_nextAttack = chains[chainOffset + 6];
                    short c_cancelTimer = chains[chainOffset + 7];
                    short c_timingMin = chains[chainOffset + 3];
                    short c_timingMax = chains[chainOffset + 4];
                    short c_input = chains[chainOffset + 5];
                    int requiredTekkenKey = -1;
                    if ((c_input & 0x30) != 0) {
                        requiredTekkenKey = 6;
                    }
                    if ((c_input & 0xC0) != 0) {
                        requiredTekkenKey = 7;
                    }
                    int nextAttackId = currentAttackId + 1;
                    newFighter.m_comboData[currentComboId][currentAttackId][0] = c_currentAttack;
                    newFighter.m_comboData[currentComboId][nextAttackId][0] = c_nextAttack;
                    newFighter.m_comboData[currentComboId][nextAttackId][1] = -1;
                    newFighter.m_comboData[currentComboId][nextAttackId][2] = requiredTekkenKey;
                    newFighter.m_comboData[currentComboId][nextAttackId][3] = c_timingMin;
                    newFighter.m_comboData[currentComboId][nextAttackId][4] = c_timingMax;
                    newFighter.m_comboData[currentComboId][nextAttackId][5] = c_cancelTimer;
                    if (currentAttackId == 0) {
                        newFighter.m_comboData[currentComboId][currentAttackId][2] = newFighter.getTekkenKeyOfAttack(c_currentAttack);
                        newFighter.m_comboData[currentComboId][currentAttackId][3] = 0;
                        newFighter.m_comboData[currentComboId][currentAttackId][4] = 0;
                        newFighter.m_comboData[currentComboId][currentAttackId][5] = 0;
                    }
                    previousComboId = currentComboId;
                    ++currentAttackId;
                }
                for (int i4 = 0; i4 < newFighter.m_attacksProperties.length; i4 += 4) {
                    int impactId = newFighter.m_attacksProperties[i4 + 2];
                    if (impactId == -1) continue;
                    newFighter.m_attacksProperties[i4 + 3] = s_fightersImpacts[p_fighterId][impactId * 6 + 4];
                }
            }
            catch (Exception e) {
                AALMidlet.outputDebugString(e.toString());
            }
            newFighter.m_physicsData[4] = 1792;
            newFighter.init();
            ++s_fightersCount;
            int currentAttack = 0;
            boolean attackExists = true;
            while (attackExists) {
                int command = newFighter.getCommandOfAttack(currentAttack);
                if (command == -1) {
                    attackExists = false;
                    continue;
                }
                ++currentAttack;
            }
            AALDevice.cleanup();
            TKFighter.displayAttackList(p_fighterId);
            return newFighter;
        }
        return null;
    }

    public void init() {
        this.m_orientation = 1;
        this.m_isActive = true;
        this.m_healthPoints = 100;
        this.m_queuedState = -1;
        this.initState(0);
    }

    public boolean skipPhysics() {
        return this.m_freezeTimer > 0;
    }

    public void update() {
        this.m_freezeTimer -= GameMidlet.s_ingameElapsedTimeClamped;
        if (this.m_fpBufferXAdjustment != 0) {
            int fpAdjustmentSpeed = 65536;
            int fpPossibleXAdjust = fpAdjustmentSpeed * GameMidlet.s_ingameElapsedTimeClamped / 1000;
            if (this.m_fpBufferXAdjustment > 0) {
                if (this.m_fpBufferXAdjustment > fpPossibleXAdjust) {
                    GameMidlet.battleSetFighterAdjustment(this, fpPossibleXAdjust, 0);
                    this.m_fpBufferXAdjustment -= fpPossibleXAdjust;
                } else {
                    GameMidlet.battleSetFighterAdjustment(this, this.m_fpBufferXAdjustment, 0);
                    this.m_fpBufferXAdjustment = 0;
                }
            } else if (this.m_fpBufferXAdjustment < 0) {
                if (this.m_fpBufferXAdjustment < -fpPossibleXAdjust) {
                    GameMidlet.battleSetFighterAdjustment(this, -fpPossibleXAdjust, 0);
                    this.m_fpBufferXAdjustment += fpPossibleXAdjust;
                } else {
                    GameMidlet.battleSetFighterAdjustment(this, this.m_fpBufferXAdjustment, 0);
                    this.m_fpBufferXAdjustment = 0;
                }
            }
        }
        if (this.m_freezeTimer > 0) {
            return;
        }
        this.m_freezeTimer = 0;
        if (this.m_currentAnimId != -1) {
            GTKAnim currentAnim = s_fightersAnims[this.m_fighterID][this.m_currentAnimId];
            this.m_animInstance = this.m_state == 13 || this.m_state == 11 || this.m_state == 14 || this.m_state == 12 ? currentAnim.updateInstance(1, this.m_stateTimer) : currentAnim.updateInstance(this.m_animInstance, GameMidlet.s_ingameElapsedTimeClamped);
        }
        if (this.m_isImpactDrawn) {
            this.m_impactInstance = s_fightersFXImpactAnim.updateInstance(this.m_impactInstance, GameMidlet.s_ingameElapsedTimeClamped);
            if (GTKAnim.getInstanceCurrentState(this.m_impactInstance) == 0) {
                this.m_isImpactDrawn = false;
            }
        }
        this.updateState();
    }

    public static void drawTouchscreenContols() {
    }

    public void draw() {
        this.drawState();
    }

    public void cleanup() {
        this.m_blockStunTimer = 0;
        this.m_hitStunTimer = 0;
        this.m_healthPoints = 0;
        this.m_state = -1;
        this.m_stateTimer = 0;
        this.m_fighterID = -1;
        this.m_isActive = false;
        this.m_isOnGround = true;
        this.m_nextAttackId = (short)-1;
        this.m_currentAttackId = (short)-1;
        this.m_isStandGuarding = false;
        this.m_tempFlags = 0;
        this.m_comboCounter = 0;
        this.m_healthPoints = 0;
        this.m_currentComboId = (short)-1;
        this.m_currentComboStep = (short)-1;
        this.m_queriedOrientation = 1;
        this.m_orientation = 1;
        if (this.m_physicsData != null) {
            for (int i = 0; i < this.m_physicsData.length; ++i) {
                this.m_physicsData[i] = 0;
            }
        }
    }

    public void initState(int p_newState) {
        this.cleanupState(this.m_state);
        boolean attack = false;
        switch (p_newState) {
            case 0: {
                this.m_isOnGround = true;
                this.m_currentAttackId = (short)-1;
                this.m_nextAttackId = (short)-1;
                this.m_isStandGuarding = false;
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 1: {
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 2: {
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 3: {
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 4: {
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 5: {
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 6: {
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 7: {
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 8: {
                this.m_isOnGround = true;
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.m_hitStunTimer = this.m_impactData[3];
                ++this.m_comboCounter;
                this.resetCurrentCombo();
                break;
            }
            case 15: {
                this.m_isOnGround = false;
                ++this.m_juggleCount;
                ++this.m_comboCounter;
                this.resetTeching();
                this.resetCurrentCombo();
                break;
            }
            case 16: 
            case 17: {
                this.m_isStandGuarding = true;
                this.m_isOnGround = true;
                this.resetComboCounter(true);
                this.resetCurrentCombo();
                break;
            }
            case 20: {
                GameMidlet.startShakeCameraY();
                GameMidlet.playVibration();
                this.m_isOnGround = true;
                break;
            }
            case 28: {
                this.m_attackConnected = false;
                if (this.m_nextAttackId != -1) {
                    this.m_currentAttackId = this.m_nextAttackId;
                    this.m_nextAttackId = (short)-1;
                    ++this.m_chainComboCounter;
                }
                this.resetComboCounter(true);
                this.m_lastAttackTimer = GameMidlet.s_battleTotalElapsedTime;
                attack = true;
                GameMidlet.antiInfiniteNotifyNewAttack(this);
                break;
            }
            case 19: {
                this.m_isCrouchGuarding = false;
                this.m_isStandGuarding = false;
                ++this.m_comboCounter;
                break;
            }
            case 18: {
                this.m_currentThrowAttackId = this.m_currentAttackId;
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                GameMidlet.startShakeCameraY();
            }
        }
        if (!attack) {
            this.m_currentAttackId = (short)-1;
            this.m_nextAttackId = (short)-1;
        }
        if (this.m_state == p_newState && attack) {
            this.m_currentAnimId = s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 0][0];
            this.m_animInstance = 1;
        } else if (this.m_state == 15 || this.m_state == 13 || this.m_state == 11 || this.m_state == 14 || this.m_state == 12) {
            this.m_currentAnimId = p_newState;
            this.m_animInstance = 1;
        } else if (this.m_state != p_newState) {
            if (!attack) {
                this.m_currentAnimId = p_newState;
                this.m_animInstance = 1;
            } else {
                this.m_currentAnimId = s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 0][0];
                this.m_animInstance = 1;
            }
        }
        this.m_state = p_newState;
        this.m_stateTimer = 0;
    }

    public static void displayAttackList(int p_fighterId) {
    }

    private int retriveQueuedState() {
        int queuedStateHolder = this.m_queuedState;
        this.m_queuedState = -1;
        return queuedStateHolder;
    }

    public void executeQueueState() {
        int queuedStateHolder = this.retriveQueuedState();
        if (queuedStateHolder != -1) {
            this.initState(queuedStateHolder);
        }
    }

    public boolean checkForDashForward() {
        if ((this.m_inputBuffer[this.m_inputBufferOffset] & 0x100) != 0 && this.m_inputBuffer[this.m_inputBufferOffset] >> 9 < s_maximumNeutralTime) {
            int checkedInputBuffer = this.m_inputBufferOffset - 1;
            if (checkedInputBuffer < 0) {
                checkedInputBuffer += 15;
            }
            if ((this.m_inputBuffer[checkedInputBuffer] & 8) != 0) {
                checkedInputBuffer = this.m_inputBufferOffset - 2;
                if (checkedInputBuffer < 0) {
                    checkedInputBuffer += 15;
                }
                if ((this.m_inputBuffer[checkedInputBuffer] & 0x100) != 0 && this.m_inputBuffer[checkedInputBuffer] >> 9 < s_maximumNeutralTime) {
                    checkedInputBuffer = this.m_inputBufferOffset - 3;
                    if (checkedInputBuffer < 0) {
                        checkedInputBuffer += 15;
                    }
                    if ((this.m_inputBuffer[checkedInputBuffer] & 8) != 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean checkForDashBackward() {
        if ((this.m_inputBuffer[this.m_inputBufferOffset] & 0x100) != 0 && this.m_inputBuffer[this.m_inputBufferOffset] >> 9 < s_maximumNeutralTime) {
            int checkedInputBuffer2 = this.m_inputBufferOffset - 1;
            if (checkedInputBuffer2 < 0) {
                checkedInputBuffer2 += 15;
            }
            if ((this.m_inputBuffer[checkedInputBuffer2] & 4) != 0) {
                checkedInputBuffer2 = this.m_inputBufferOffset - 2;
                if (checkedInputBuffer2 < 0) {
                    checkedInputBuffer2 += 15;
                }
                if ((this.m_inputBuffer[checkedInputBuffer2] & 0x100) != 0 && this.m_inputBuffer[checkedInputBuffer2] >> 9 < s_maximumNeutralTime) {
                    checkedInputBuffer2 = this.m_inputBufferOffset - 3;
                    if (checkedInputBuffer2 < 0) {
                        checkedInputBuffer2 += 15;
                    }
                    if ((this.m_inputBuffer[checkedInputBuffer2] & 4) != 0) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void updateGuard() {
        int tekkenKey = this.getTekkenKey();
        this.m_isStandGuarding = false;
        this.m_isCrouchGuarding = false;
        if (this.isInPossibleGuardState()) {
            if (tekkenKey == 3) {
                this.m_isStandGuarding = true;
            } else if (tekkenKey == 5) {
                this.m_isCrouchGuarding = true;
            }
        }
    }

    public int getTekkenKey() {
        if (this.m_healthPoints <= 0) {
            return -1;
        }
        if (GameMidlet.s_ingameState == 4 && this == GameMidlet.s_battleFighter2 && GTKBluetooth.isServer()) {
            return GameMidlet.s_remoteTekkenKey;
        }
        int keymapOffset = this.m_orientation == 1 ? 0 : 13;
        for (int tekkenKey = 0; tekkenKey < 13; ++tekkenKey) {
            if ((AALDevice.s_virtualKeysDown & TEKKEN_KEYMAP[s_currentKeymap][keymapOffset + tekkenKey]) == 0) continue;
            return tekkenKey;
        }
        return -1;
    }

    public boolean isInPossibleAttackState() {
        return this.m_state == 0 || this.m_state == 5 || this.m_state == 3 || this.m_state == 1 || this.m_state == 2 || this.m_state == 4 || this.m_state == 6 || this.m_state == 7 || this.m_state == 8 || this.m_state == 9 || this.m_state == 10;
    }

    public void resetAttackBuffer() {
        this.m_bufferAttackId = (short)-1;
        this.m_bufferAttackTimer = 0;
    }

    public void updateUserControls() {
        if (this.m_isAIControlled || this.m_disableControls) {
            return;
        }
        this.updateGuard();
        this.m_detectedAttackId = (short)-1;
        this.doTranslateKeysPressed();
        this.m_bufferAttackTimer -= GameMidlet.s_ingameElapsedTimeClamped;
        if (this.m_bufferAttackTimer < 0) {
            this.resetAttackBuffer();
        }
        if (this.isInPossibleAttackState()) {
            if (this.m_detectedAttackId != -1) {
                if (this.m_currentAttackId == -1) {
                    this.m_currentAttackId = this.m_detectedAttackId;
                    this.initState(28);
                    return;
                }
            } else if (this.m_bufferAttackId >= 0) {
                // empty if block
            }
        } else if (this.m_detectedAttackId != -1 && this.m_bufferAttackId == -1) {
            if (this.m_isOnGround) {
                this.m_bufferAttackId = this.m_detectedAttackId;
                this.m_bufferAttackTimer = 300;
            } else {
                this.resetAttackBuffer();
            }
        }
        if (this.m_bufferAttackTimer < 0) {
            this.m_bufferAttackTimer = 0;
        }
        if (this.m_bufferAttackId != -1 && this.isInPossibleAttackState()) {
            if (this.m_bufferAttackTimer > 0) {
                this.m_currentAttackId = this.m_bufferAttackId;
                this.m_bufferAttackId = (short)-1;
                this.m_bufferAttackTimer = 300;
                this.initState(28);
            } else {
                this.m_bufferAttackId = (short)-1;
                this.m_bufferAttackTimer = 0;
            }
        }
        int nextState = -1;
        int tekkenKey = this.getTekkenKey();
        if (s_currentKeymap != 1 && tekkenKey == 1) {
            tekkenKey = 10;
        }
        switch (this.m_state) {
            case 0: 
            case 8: {
                switch (tekkenKey) {
                    case 3: {
                        nextState = 3;
                        break;
                    }
                    case 4: {
                        nextState = 1;
                        break;
                    }
                    case 5: {
                        nextState = 5;
                        break;
                    }
                    case 10: {
                        nextState = 9;
                        break;
                    }
                    case 8: {
                        if (this.isInPossibleAttackState()) {
                            this.m_currentAttackId = this.m_data[0];
                        }
                        nextState = 28;
                        break;
                    }
                    case 2: {
                        this.m_currentJumpDirection = 0;
                        nextState = 6;
                        break;
                    }
                    case 1: {
                        this.m_currentJumpDirection = 1;
                        nextState = 6;
                        break;
                    }
                    case 0: {
                        this.m_currentJumpDirection = 2;
                        nextState = 6;
                    }
                }
                if (nextState >= 0) {
                    this.initState(nextState);
                    break;
                }
                if (this.checkForDashForward()) {
                    this.initState(2);
                    break;
                }
                if (!this.checkForDashBackward()) break;
                this.initState(4);
                break;
            }
            case 1: {
                switch (tekkenKey) {
                    case 3: {
                        nextState = 3;
                        break;
                    }
                    case 4: {
                        nextState = 1;
                        break;
                    }
                    case 5: {
                        nextState = 5;
                        break;
                    }
                    case 10: {
                        nextState = 9;
                        break;
                    }
                    case 8: {
                        if (this.isInPossibleAttackState()) {
                            this.m_currentAttackId = this.m_data[0];
                        }
                        nextState = 28;
                        break;
                    }
                    case 2: {
                        this.m_currentJumpDirection = 0;
                        nextState = 6;
                        break;
                    }
                    case 1: {
                        this.m_currentJumpDirection = 1;
                        nextState = 6;
                        break;
                    }
                    case 0: {
                        this.m_currentJumpDirection = 2;
                        nextState = 6;
                        break;
                    }
                    case -1: {
                        nextState = 0;
                    }
                }
                if (nextState >= 0) {
                    this.initState(nextState);
                    break;
                }
                if (!this.checkForDashForward()) break;
                this.initState(2);
                break;
            }
            case 3: {
                switch (tekkenKey) {
                    case 3: {
                        if (GameMidlet.s_ingameState != 3 || GameMidlet.s_tekkenForceModeState != 2 || this.m_stateTimer <= 200) break;
                        this.m_queriedOrientation = this.m_orientation * -1;
                        nextState = 1;
                        break;
                    }
                    case 4: {
                        nextState = 1;
                        break;
                    }
                    case 5: {
                        nextState = 5;
                        break;
                    }
                    case 10: {
                        nextState = 9;
                        break;
                    }
                    case 8: {
                        if (this.isInPossibleAttackState()) {
                            this.m_currentAttackId = this.m_data[0];
                        }
                        nextState = 28;
                        break;
                    }
                    case 2: {
                        this.m_currentJumpDirection = 0;
                        nextState = 6;
                        break;
                    }
                    case 1: {
                        this.m_currentJumpDirection = 1;
                        nextState = 6;
                        break;
                    }
                    case 0: {
                        this.m_currentJumpDirection = 2;
                        nextState = 6;
                        break;
                    }
                    case -1: {
                        nextState = 0;
                    }
                }
                if (nextState >= 0) {
                    this.initState(nextState);
                    break;
                }
                if (!this.checkForDashBackward()) break;
                this.initState(4);
                break;
            }
            case 5: {
                switch (tekkenKey) {
                    case 3: {
                        nextState = 3;
                        break;
                    }
                    case 4: {
                        nextState = 1;
                        break;
                    }
                    case 5: {
                        nextState = 5;
                        break;
                    }
                    case 10: {
                        nextState = 9;
                        break;
                    }
                    case 8: {
                        if (this.isInPossibleAttackState()) {
                            this.m_currentAttackId = this.m_data[0];
                        }
                        nextState = 28;
                        break;
                    }
                    case 2: {
                        this.m_currentJumpDirection = 0;
                        nextState = 6;
                        break;
                    }
                    case 1: {
                        this.m_currentJumpDirection = 1;
                        nextState = 6;
                        break;
                    }
                    case 0: {
                        this.m_currentJumpDirection = 2;
                        nextState = 6;
                    }
                }
                if (nextState < 0) break;
                this.initState(nextState);
                break;
            }
            case 2: {
                switch (tekkenKey) {
                    case 3: {
                        nextState = 3;
                        break;
                    }
                    case 5: {
                        nextState = 5;
                        break;
                    }
                    case 10: {
                        nextState = 9;
                        break;
                    }
                    case 8: {
                        if (this.isInPossibleAttackState()) {
                            this.m_currentAttackId = this.m_data[0];
                        }
                        nextState = 28;
                        break;
                    }
                    case 2: {
                        this.m_currentJumpDirection = 0;
                        nextState = 6;
                        break;
                    }
                    case 1: {
                        this.m_currentJumpDirection = 1;
                        nextState = 6;
                        break;
                    }
                    case 0: {
                        this.m_currentJumpDirection = 2;
                        nextState = 6;
                    }
                }
                if (nextState < 0) break;
                this.initState(nextState);
                break;
            }
            case 20: {
                if (this.hasAnimationStopped()) {
                    switch (tekkenKey) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 5: 
                        case 6: 
                        case 7: {
                            nextState = 22;
                            break;
                        }
                        case 3: {
                            nextState = 21;
                            break;
                        }
                        case 4: {
                            nextState = 23;
                        }
                    }
                }
                if (nextState < 0) break;
                this.initState(nextState);
            }
        }
    }

    public void resetTeching() {
        this.m_techingState = 0;
        this.m_techingTimer = 0;
    }

    public void updateTeching() {
        int tekkenKey = this.getTekkenKey();
        if (this.m_healthPoints <= 0) {
            this.m_techingState = 1;
            return;
        }
        boolean techSuccess = tekkenKey == 6 || tekkenKey == 4 || tekkenKey == 3;
        switch (this.m_techingState) {
            case 0: {
                if (this.m_disableControls || this.m_isAIControlled || !techSuccess) break;
                this.m_techingState = 2;
                this.m_techingTimer = 300;
                switch (tekkenKey) {
                    case 6: {
                        this.m_techingDirection = 1;
                        break;
                    }
                    case 3: {
                        this.m_techingDirection = 0;
                        break;
                    }
                    case 4: {
                        this.m_techingDirection = 2;
                    }
                }
                break;
            }
            case 2: {
                this.m_techingTimer -= GameMidlet.s_ingameElapsedTimeClamped;
                if (this.m_techingTimer > 0) break;
                this.m_techingState = 1;
                break;
            }
        }
    }

    public void updateState() {
        boolean fighterFrozen;
        int timer = GameMidlet.s_ingameElapsedTimeClamped;
        this.m_stateTimer += timer;
        if ((m_antiThrowTimer -= GameMidlet.s_ingameElapsedTimeClamped) < 0) {
            m_antiThrowTimer = 0;
        }
        if (this.m_queriedOrientation != this.m_orientation && (this.m_state == 0 || this.m_state == 5 || this.m_state == 1 || this.m_state == 3 || this.m_state == 8)) {
            this.m_orientation = this.m_queriedOrientation;
        }
        this.updateUserControls();
        this.updateAI();
        this.updateAutoCombo();
        this.updatePracticeModeDummy();
        boolean bl = fighterFrozen = this.m_physicsData[1] == 0 && this.m_physicsData[2] == 0 && this.m_physicsData[3] == 0 && this.hasAnimationStopped() && this.m_state == 15;
        if (fighterFrozen) {
            this.m_tempFlags |= 1;
        }
        switch (this.m_state) {
            case 0: {
                break;
            }
            case 2: {
                if (!this.hasAnimationStopped()) break;
                this.initState(0);
                break;
            }
            case 4: {
                if (!this.hasAnimationStopped()) break;
                this.initState(0);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                if (this.m_physicsData[3] <= 0) break;
                this.initState(7);
                break;
            }
            case 7: {
                if ((this.m_tempFlags & 1) == 0) break;
                this.initState(8);
                break;
            }
            case 8: {
                if (!this.hasAnimationStopped()) break;
                this.initState(0);
                break;
            }
            case 9: {
                if (!this.hasAnimationStopped() || this.m_stateTimer <= this.m_stepDuration) break;
                this.initState(10);
                break;
            }
            case 10: {
                if (!this.hasAnimationStopped()) break;
                this.initState(0);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (this.m_stateTimer < this.m_hitStunTimer) break;
                this.m_hitStunTimer = 0;
                this.initState(0);
                break;
            }
            case 15: {
                if ((this.m_tempFlags & 1) == 0) break;
                this.m_hitStunTimer = 0;
                this.m_isImpactDrawn = true;
                this.m_impactInstance = 1;
                if (this.m_techingState == 2) {
                    switch (this.m_techingDirection) {
                        case 0: {
                            this.initState(24);
                            break;
                        }
                        case 1: {
                            this.initState(25);
                            break;
                        }
                        case 2: {
                            this.initState(26);
                        }
                    }
                    break;
                }
                this.initState(20);
                break;
            }
            case 20: {
                if (!this.hasAnimationStopped() || this.m_stateTimer <= 500 || this.m_healthPoints <= 0) break;
                this.initState(22);
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                if (!this.hasAnimationStopped()) break;
                this.initState(0);
                break;
            }
            case 19: {
                if (this.m_fighterThrowing != null && (this.m_fighterThrowing.m_state == 28 || this.m_fighterThrowing.m_state == 18)) break;
                this.initState(0);
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                if (!this.hasAnimationStopped()) break;
                this.initState(0);
                break;
            }
            case 28: {
                if ((this.m_tempFlags & 1) != 0) {
                    this.initState(8);
                    break;
                }
                if (this.hasAnimationStopped() && !this.m_isOnGround) break;
                if (this.hasAnimationStopped() && this.m_isOnGround) {
                    this.m_currentAttackId = (short)-1;
                    this.initState(0);
                    break;
                }
                if (this.m_nextAttackId == -1 || this.m_stateTimer < this.m_nextAttackTimer) break;
                this.initState(28);
                break;
            }
            case 16: {
                if (this.m_stateTimer < this.m_blockStunTimer || this.m_isStandGuarding) break;
                this.m_blockStunTimer = 0;
                this.initState(0);
                break;
            }
            case 17: {
                if (this.m_stateTimer < this.m_blockStunTimer || this.m_isCrouchGuarding) break;
                this.m_blockStunTimer = 0;
                this.initState(5);
                break;
            }
            case 18: {
                if (!this.hasAnimationStopped()) break;
                this.m_currentAttackId = (short)(this.m_currentThrowAttackId + 1);
                this.initState(28);
            }
        }
        switch (this.m_state) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 28: {
                break;
            }
            case 15: {
                this.updateTeching();
                break;
            }
            case 18: {
                if (this.m_fighterThrown == null) break;
                int offsetX = 12288 * this.m_orientation;
                int[] attackingFighterData = this.getPhysicsData();
                int[] attackedFighterData = this.m_fighterThrown.getPhysicsData();
                attackedFighterData[0] = attackingFighterData[0] + offsetX;
                attackedFighterData[1] = attackingFighterData[1];
            }
        }
        this.m_tempFlags = 0;
    }

    public void resetCurrentCombo() {
        this.m_currentComboId = (short)-1;
        this.m_currentComboStep = 0;
        this.m_comboFailed = false;
        this.m_autoComboEnabled = false;
        this.m_maxAutoComboSteps = (short)99;
    }

    public boolean combosShareCommonFirstAttacks(int p_comboId1, int p_comboId2, int p_numberOfCommonAttacks) {
        if (p_numberOfCommonAttacks == 0) {
            return false;
        }
        short[][] combo1 = this.m_comboData[p_comboId1];
        short[][] combo2 = this.m_comboData[p_comboId2];
        for (int index = 0; index < p_numberOfCommonAttacks; ++index) {
            boolean sameAttack;
            boolean bl = sameAttack = combo1.length > index && combo2.length > index && combo1[index][0] == combo2[index][0] && combo1[index][2] == combo2[index][2];
            if (sameAttack) continue;
            return false;
        }
        return true;
    }

    public void updateAutoCombo() {
        if (!this.m_autoComboEnabled || this.m_currentComboId == -1 || this.m_currentComboStep == 0 && !this.isInPossibleAttackState()) {
            return;
        }
        short[][] combo = this.m_comboData[this.m_currentComboId];
        if (this.m_currentComboStep < combo.length && this.m_stateTimer >= combo[this.m_currentComboStep][5] && this.m_currentComboStep < this.m_maxAutoComboSteps) {
            this.m_currentAttackId = combo[this.m_currentComboStep][0];
            this.initState(28);
            this.m_currentComboStep = (short)(this.m_currentComboStep + 1);
        }
    }

    private void updateComboInputDetection() {
        if (this.m_nextAttackId != -1 || this.m_comboFailed || this.m_autoComboEnabled) {
            return;
        }
        int playerInput = this.m_inputBuffer[this.m_inputBufferOffset];
        int punchMask = 48;
        int kickMask = 192;
        short playerTekkenKey = -1;
        if ((playerInput & punchMask) != 0) {
            playerTekkenKey = 6;
        } else if ((playerInput & kickMask) != 0) {
            playerTekkenKey = 7;
        }
        int validComboMask = 0;
        for (int currentComboId = 0; currentComboId < this.m_comboData.length; ++currentComboId) {
            if (this.m_currentComboId != -1 && this.m_currentComboId != currentComboId && !this.combosShareCommonFirstAttacks(this.m_currentComboId, currentComboId, this.m_currentComboStep)) continue;
            validComboMask |= 1 << currentComboId;
        }
        boolean comboFailed = false;
        boolean comboSucceded = false;
        for (int currentComboId = 0; currentComboId < this.m_comboData.length; currentComboId = (int)((short)(currentComboId + 1))) {
            short[][] combo;
            if ((validComboMask & 1 << currentComboId) == 0 || this.m_currentComboStep >= (combo = this.m_comboData[currentComboId]).length - 1) continue;
            short c_currentAttackId = combo[this.m_currentComboStep][0];
            short c_nextAttackId = combo[this.m_currentComboStep + 1][0];
            short c_timerMin = combo[this.m_currentComboStep + 1][3];
            short c_timerMax = combo[this.m_currentComboStep + 1][4];
            short c_tekkenKey = combo[this.m_currentComboStep + 1][2];
            int c_nextAttackTimer = combo[this.m_currentComboStep + 1][5];
            if (this.m_currentAttackId == c_currentAttackId && this.m_stateTimer >= c_timerMin && this.m_stateTimer <= c_timerMax && c_tekkenKey == playerTekkenKey) {
                this.m_currentComboId = (short)currentComboId;
                this.m_nextAttackId = c_nextAttackId;
                this.m_nextAttackTimer = c_nextAttackTimer;
                this.m_currentComboStep = (short)(this.m_currentComboStep + 1);
                this.m_comboFailed = false;
                return;
            }
            if (playerTekkenKey == -1) continue;
            comboFailed = true;
        }
        if (comboFailed) {
            this.m_comboFailed = true;
        }
    }

    public void drawState() {
        if (this.m_state == -1) {
            return;
        }
        int x = (this.m_physicsData[0] >> 8) - GameMidlet.s_cameraLeft;
        int y = (this.m_physicsData[1] >> 8) - GameMidlet.s_cameraTop;
        if (this.m_currentAnimId != -1) {
            if (GameMidlet.s_ingameState == 3 && GameMidlet.s_tekkenForceModeState != 6 && GameMidlet.s_tekkenForceModeState != 7 && !GameMidlet.s_isIngamePaused) {
                if (this.m_state != 20 || this.m_state == 20 && this.m_healthPoints > 0 || this.m_state == 20 && this.m_healthPoints <= 0 && !this.hasAnimationStopped() || this.m_state == 20 && this.m_healthPoints <= 0 && this.hasAnimationStopped() && this.m_toggleBlink) {
                    s_fightersAnims[this.m_fighterID][this.m_currentAnimId].drawInstance(this.m_animInstance, s_fightersTilesets[this.m_fighterID][this.m_currentOutfitId], x, y, this.m_orientation == 1 ? 0 : 4);
                }
                this.m_toggleBlink = !this.m_toggleBlink;
            } else {
                s_fightersAnims[this.m_fighterID][this.m_currentAnimId].drawInstance(this.m_animInstance, s_fightersTilesets[this.m_fighterID][this.m_currentOutfitId], x, y, this.m_orientation == 1 ? 0 : 4);
            }
        }
    }

    public void cleanupState(int p_cleanupState) {
        switch (p_cleanupState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 28: {
                if (this.m_nextAttackId == -1 && !this.m_autoComboEnabled) {
                    this.resetCurrentCombo();
                }
                this.m_attackConnected = false;
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                m_antiThrowTimer = 3000;
            }
        }
    }

    public boolean hasAnimationStopped() {
        return GTKAnim.getInstanceCurrentState(this.m_animInstance) == 0;
    }

    public int[] getPhysicsData() {
        return this.m_physicsData;
    }

    public boolean getImpactData(int[] p_out, int p_impactId) {
        if (s_fightersImpacts[this.m_fighterID] != null) {
            int offset = 6 * p_impactId;
            p_out[0] = s_fightersImpacts[this.m_fighterID][offset + 0];
            p_out[1] = s_fightersImpacts[this.m_fighterID][offset + 1];
            p_out[2] = s_fightersImpacts[this.m_fighterID][offset + 2];
            p_out[3] = s_fightersImpacts[this.m_fighterID][offset + 3];
            p_out[4] = s_fightersImpacts[this.m_fighterID][offset + 4];
            p_out[5] = s_fightersImpacts[this.m_fighterID][offset + 5];
            p_out[6] = this.m_lastAttackTimer;
            return true;
        }
        return false;
    }

    public boolean getCollisionBox(int p_collisionBoxType, int p_collisionBoxId, int[] p_outputBuffer, int p_outputBufferOffset) {
        int x = this.m_physicsData[0] >> 8;
        int y = this.m_physicsData[1] >> 8;
        switch (p_collisionBoxType) {
            case 0: {
                int j;
                if (this.m_state == 19 || this.m_state == 18) {
                    p_outputBuffer[p_outputBufferOffset + 0] = y - 96;
                    p_outputBuffer[p_outputBufferOffset + 1] = x - 8;
                    p_outputBuffer[p_outputBufferOffset + 2] = x + 8;
                    p_outputBuffer[p_outputBufferOffset + 3] = y;
                    return true;
                }
                if (this.m_state == 24 || this.m_state == 26 || this.m_state == 21 || this.m_state == 23) {
                    p_outputBuffer[p_outputBufferOffset + 0] = y - 32;
                    p_outputBuffer[p_outputBufferOffset + 1] = x - 16;
                    p_outputBuffer[p_outputBufferOffset + 2] = x + 16;
                    p_outputBuffer[p_outputBufferOffset + 3] = y;
                    return true;
                }
                if (this.m_state != 28) {
                    int j2;
                    int i = 0;
                    for (j2 = 0; j2 < s_fightersHitboxes[this.m_fighterID][this.m_state].length; j2 += 6) {
                        if (s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 0] <= GTKAnim.getInstanceCurrentTime(this.m_animInstance) && s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 1] >= GTKAnim.getInstanceCurrentTime(this.m_animInstance) || s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 0] <= Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped) && s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 1] >= Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped)) {
                            ++i;
                        }
                        if (i == p_collisionBoxId + 1) break;
                    }
                    try {
                        p_outputBuffer[p_outputBufferOffset + 0] = y + s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 2];
                        if (this.m_orientation == 1) {
                            p_outputBuffer[p_outputBufferOffset + 1] = x + s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 3];
                            p_outputBuffer[p_outputBufferOffset + 2] = x + s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 4];
                        } else {
                            p_outputBuffer[p_outputBufferOffset + 2] = x - s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 3];
                            p_outputBuffer[p_outputBufferOffset + 1] = x - s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 4];
                        }
                        p_outputBuffer[p_outputBufferOffset + 3] = y + s_fightersHitboxes[this.m_fighterID][this.m_state][j2 + 5];
                    }
                    catch (Exception e) {
                        GameMidlet.outputDebugString("ERROR: Collision box not found for state: " + this.m_state + " current time: " + GTKAnim.getInstanceCurrentTime(this.m_animInstance));
                        p_outputBuffer[p_outputBufferOffset + 0] = y - 100;
                        p_outputBuffer[p_outputBufferOffset + 1] = x - 20;
                        p_outputBuffer[p_outputBufferOffset + 2] = x + 25;
                        p_outputBuffer[p_outputBufferOffset + 3] = y;
                    }
                    return true;
                }
                if (this.m_currentAttackId == -1) break;
                int i = 0;
                for (j = 0; j < s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1].length; j += 8) {
                    if (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j] == p_collisionBoxType && (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 1] <= GTKAnim.getInstanceCurrentTime(this.m_animInstance) && s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 2] >= GTKAnim.getInstanceCurrentTime(this.m_animInstance) || s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 1] <= Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped) && s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 2] >= Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped))) {
                        ++i;
                    }
                    if (i == p_collisionBoxId + 1) break;
                }
                p_outputBuffer[p_outputBufferOffset + 0] = y + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 3];
                if (this.m_orientation == 1) {
                    p_outputBuffer[p_outputBufferOffset + 1] = x + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 4];
                    p_outputBuffer[p_outputBufferOffset + 2] = x + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 5];
                } else {
                    p_outputBuffer[p_outputBufferOffset + 2] = x - s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 4];
                    p_outputBuffer[p_outputBufferOffset + 1] = x - s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 5];
                }
                p_outputBuffer[p_outputBufferOffset + 3] = y + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 6];
                return true;
            }
            case 1: {
                int j;
                if (this.m_state != 28) {
                    return false;
                }
                if (this.m_currentAttackId == -1) break;
                int i = 0;
                for (j = 0; j < s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1].length; j += 8) {
                    if (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j] == p_collisionBoxType && (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 1] <= GTKAnim.getInstanceCurrentTime(this.m_animInstance) && s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 2] >= GTKAnim.getInstanceCurrentTime(this.m_animInstance) || s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 1] <= Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped) && s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 2] >= Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped))) {
                        ++i;
                    }
                    if (i == p_collisionBoxId + 1) break;
                }
                if (this.m_orientation > 0) {
                    p_outputBuffer[p_outputBufferOffset + 0] = y + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 3];
                    p_outputBuffer[p_outputBufferOffset + 1] = x + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 4];
                    p_outputBuffer[p_outputBufferOffset + 2] = x + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 5];
                    p_outputBuffer[p_outputBufferOffset + 3] = y + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 6];
                    p_outputBuffer[p_outputBufferOffset + 4] = s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 7];
                } else {
                    p_outputBuffer[p_outputBufferOffset + 0] = y + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 3];
                    p_outputBuffer[p_outputBufferOffset + 1] = x - s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 5];
                    p_outputBuffer[p_outputBufferOffset + 2] = x - s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 4];
                    p_outputBuffer[p_outputBufferOffset + 3] = y + s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 6];
                    p_outputBuffer[p_outputBufferOffset + 4] = s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 7];
                }
                return true;
            }
        }
        return false;
    }

    public int getCollisionBoxesCount(int p_collisionBoxType) {
        switch (p_collisionBoxType) {
            case 0: {
                if (this.m_state != 28) {
                    int i = 0;
                    for (int j = 0; j < s_fightersHitboxes[this.m_fighterID][this.m_state].length; j += 6) {
                        if ((s_fightersHitboxes[this.m_fighterID][this.m_state][j + 0] > GTKAnim.getInstanceCurrentTime(this.m_animInstance) || s_fightersHitboxes[this.m_fighterID][this.m_state][j + 1] < GTKAnim.getInstanceCurrentTime(this.m_animInstance)) && (s_fightersHitboxes[this.m_fighterID][this.m_state][j + 0] > Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped) || s_fightersHitboxes[this.m_fighterID][this.m_state][j + 1] < Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped))) continue;
                        ++i;
                    }
                    return i;
                }
                int i = 0;
                for (int j = 0; j < s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1].length; j += 8) {
                    if (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j] != p_collisionBoxType || (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 1] > GTKAnim.getInstanceCurrentTime(this.m_animInstance) || s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 2] < GTKAnim.getInstanceCurrentTime(this.m_animInstance)) && (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 1] > Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped) || s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 2] < Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped))) continue;
                    ++i;
                }
                return i;
            }
            case 1: {
                if (this.m_state != 28) break;
                int i = 0;
                for (int j = 0; j < s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1].length; j += 8) {
                    if (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j] != p_collisionBoxType || (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 1] > GTKAnim.getInstanceCurrentTime(this.m_animInstance) || s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 2] < GTKAnim.getInstanceCurrentTime(this.m_animInstance)) && (s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 1] > Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped) || s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 1][j + 2] < Math.max(0, GTKAnim.getInstanceCurrentTime(this.m_animInstance) - GameMidlet.s_ingameElapsedTimeClamped))) continue;
                    ++i;
                }
                return i;
            }
        }
        return 0;
    }

    public boolean getRequiredVelocity(int[] p_outputBuffer, int p_outputBufferOffset) {
        int fpVelocityX = 24576;
        switch (this.m_state) {
            case 1: {
                p_outputBuffer[p_outputBufferOffset + 0] = fpVelocityX * this.m_orientation;
                p_outputBuffer[p_outputBufferOffset + 1] = 0;
                return true;
            }
            case 3: {
                p_outputBuffer[p_outputBufferOffset + 0] = fpVelocityX * this.m_orientation * -1;
                p_outputBuffer[p_outputBufferOffset + 1] = 0;
                return true;
            }
        }
        return false;
    }

    public boolean getRequiredMomentum(int[] p_outputBuffer, int p_outputBufferOffset) {
        int Ydivider = 1;
        if (this.isInOkizemeState()) {
            Ydivider = 8;
        }
        if (this.m_impactData != null) {
            if (this.m_impactData[7] == 1) {
                p_outputBuffer[p_outputBufferOffset + 1] = 0;
                p_outputBuffer[p_outputBufferOffset + 0] = 0;
                this.m_impactData = null;
                return true;
            }
            if ((this.m_impactData[4] & 0x100) != 0 || !this.m_isOnGround) {
                p_outputBuffer[p_outputBufferOffset + 1] = (this.m_impactData[1] << 8) / Ydivider;
                p_outputBuffer[p_outputBufferOffset + 0] = (this.m_impactData[0] << 8) * this.m_orientation * -1;
            }
            this.m_impactData = null;
            return true;
        }
        if (this.m_state == 6 && this.m_stateTimer >= 50 && this.m_isOnGround) {
            if (this.m_currentJumpDirection == 2) {
                p_outputBuffer[p_outputBufferOffset + 0] = -87040 * this.m_orientation;
                p_outputBuffer[p_outputBufferOffset + 1] = -640000;
            } else if (this.m_currentJumpDirection == 1) {
                p_outputBuffer[p_outputBufferOffset + 0] = 0 * this.m_orientation;
                p_outputBuffer[p_outputBufferOffset + 1] = -640000;
            } else {
                p_outputBuffer[p_outputBufferOffset + 0] = 87040 * this.m_orientation;
                p_outputBuffer[p_outputBufferOffset + 1] = -640000;
            }
            this.m_currentJumpDirection = 0;
            this.m_isOnGround = false;
            return true;
        }
        if (this.m_state == 17 && this.m_stateTimer == 0) {
            p_outputBuffer[p_outputBufferOffset + 0] = 256000 * this.m_orientation * -1;
            p_outputBuffer[p_outputBufferOffset + 1] = 0;
            return true;
        }
        return false;
    }

    public boolean getRequiredTrajectory(int[] p_outBuffer, int p_outputBufferOffset) {
        if (this.m_state == 19 || this.m_state == 18) {
            p_outBuffer[p_outputBufferOffset + 0] = -1;
            return true;
        }
        if (this.m_state == 28 && this.m_stateTimer == 0 && s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 2][0] != -1) {
            p_outBuffer[p_outputBufferOffset + 0] = s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 2][0];
            p_outBuffer[p_outputBufferOffset + 1] = s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 2][1];
            p_outBuffer[p_outputBufferOffset + 2] = s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 2][2];
            p_outBuffer[p_outputBufferOffset + 4] = s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 2][4];
            if (!this.m_isTrajectoryReversed) {
                p_outBuffer[p_outputBufferOffset + 3] = this.m_orientation * s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 2][3];
            } else {
                p_outBuffer[p_outputBufferOffset + 3] = -1 * this.m_orientation * s_fightersAttacks[this.m_fighterID][this.m_currentAttackId * 4 + 2][3];
                this.m_isTrajectoryReversed = false;
            }
            return true;
        }
        this.m_isTrajectoryReversed = false;
        if ((this.m_state == 2 || this.m_state == 26 || this.m_state == 23) && this.m_stateTimer == 0) {
            p_outBuffer[p_outputBufferOffset + 0] = 1;
            p_outBuffer[p_outputBufferOffset + 1] = 0;
            p_outBuffer[p_outputBufferOffset + 2] = s_fightersAnims[this.m_fighterID][this.m_currentAnimId].getTotalDuration();
            p_outBuffer[p_outputBufferOffset + 4] = 0;
            p_outBuffer[p_outputBufferOffset + 3] = this.m_orientation * this.m_fpFighterDashVectorX * 32 / 32;
            return true;
        }
        if ((this.m_state == 4 || this.m_state == 24 || this.m_state == 21) && this.m_stateTimer == 0) {
            p_outBuffer[p_outputBufferOffset + 0] = 1;
            p_outBuffer[p_outputBufferOffset + 1] = 0;
            p_outBuffer[p_outputBufferOffset + 2] = s_fightersAnims[this.m_fighterID][this.m_currentAnimId].getTotalDuration();
            p_outBuffer[p_outputBufferOffset + 4] = 0;
            p_outBuffer[p_outputBufferOffset + 3] = -1 * this.m_orientation * this.m_fpFighterDashVectorX * 32 / 32;
            return true;
        }
        if (this.m_state == 15 || this.m_state == 13 || this.m_state == 11 || this.m_state == 12 || this.m_state == 14) {
            p_outBuffer[p_outputBufferOffset + 0] = -1;
            p_outBuffer[p_outputBufferOffset + 1] = 0;
            p_outBuffer[p_outputBufferOffset + 2] = 0;
            p_outBuffer[p_outputBufferOffset + 4] = 0;
            p_outBuffer[p_outputBufferOffset + 3] = 0;
        }
        return false;
    }

    public boolean isImpactDifferent(int[] p_impactData) {
        return this.m_lastImpactData[0] != p_impactData[0] || this.m_lastImpactData[1] != p_impactData[1] || this.m_lastImpactData[4] != p_impactData[4] || this.m_lastImpactData[6] != p_impactData[6];
    }

    public int onHit(ICollidable p_AttackingObject, int[] p_impactData, int[] p_collsionBoundaries) {
        if (!this.isInPossibleGuardState()) {
            this.m_isStandGuarding = false;
            this.m_isCrouchGuarding = false;
        } else if (!this.m_isAIControlled && !this.m_disableControls && s_currentKeymap == 1) {
            this.m_isStandGuarding = true;
            this.m_isCrouchGuarding = true;
        }
        TKFighter fighter = (TKFighter)p_AttackingObject;
        boolean forceJuggle = GameMidlet.checkIfAttackIsAlreadyUsed(this);
        if (GameMidlet.s_ingameState == 3 && GameMidlet.s_tekkenForceModeState == 2 && this != GameMidlet.s_mainFighter && (this.m_healthPoints <= 0 && (this.m_state == 15 || this.m_state == 20) && this.m_comboCounter >= 5 || this.m_healthPoints <= 0 && this.m_state == 20 && this.m_stateTimer > 200)) {
            return 0;
        }
        if (GameMidlet.s_ingameState == 2) {
            this.m_lastDamageTimer = 0;
            fighter.m_lastDamageTimer = 0;
        } else if (GameMidlet.s_ingameState == 3 && !this.m_isAIControlled && GameMidlet.s_tekkenForceModeState == 2) {
            if (this.m_orientation != fighter.m_orientation && this.isInPossibleGuardState()) {
                this.m_isCrouchGuarding = true;
                this.m_isStandGuarding = true;
            } else {
                this.m_isCrouchGuarding = false;
                this.m_isStandGuarding = false;
            }
        }
        if (!(!this.isImpactDifferent(p_impactData) || this.m_state != 9 && this.m_state != 10 || (p_impactData[4] & 0x200) != 0 || (p_impactData[4] & 0x40) != 0 && (p_impactData[4] & 0x100) == 0)) {
            return 0;
        }
        if ((p_impactData[4] & 0x200) != 0) {
            if (!this.isThrowable()) {
                return 0;
            }
            m_antiThrowTimer = 3000;
            this.initState(19);
            fighter.initState(18);
            this.m_fighterThrowing = fighter;
            fighter.m_fighterThrown = this;
            return 0;
        }
        if (this.isImpactDifferent(p_impactData) && this.m_isStandGuarding && (p_impactData[4] & 4) == 0 || this.isImpactDifferent(p_impactData) && this.m_isCrouchGuarding && (p_impactData[4] & 2) == 0 && p_AttackingObject.isOnGround()) {
            int freezeDuration;
            GameMidlet.loadMusic(116, true);
            GameMidlet.s_currentSFX = 1;
            GameMidlet.playMusic();
            GameMidlet.addParticle(1, p_collsionBoundaries, 0, p_impactData, this.m_orientation);
            this.copyImpactData(p_impactData);
            this.m_impactData = p_impactData;
            this.m_impactData[7] = 1;
            this.m_blockStunTimer += p_impactData[2];
            if (this.m_blockStunTimer > 400) {
                this.m_blockStunTimer = 400;
            }
            if (this.m_isCrouchGuarding && (p_impactData[4] & 4) != 0) {
                this.initState(17);
            } else {
                this.initState(16);
            }
            fighter.m_freezeTimer = freezeDuration = (p_impactData[4] & 0x40) != 0 ? 100 : 50;
            this.m_freezeTimer = freezeDuration;
            int fpAdjust = (p_impactData[4] & 0x40) != 0 ? 1024 : 512;
            this.m_fpBufferXAdjustment = this.m_fpTotalBufferXAdjustment = this.m_orientation * -1 * fpAdjust;
        } else if (this.isImpactDifferent(p_impactData) && (this.m_tempFlags & 1) == 0) {
            int fpAdjust;
            int freezeDuration;
            this.copyImpactData(p_impactData);
            this.m_impactData = p_impactData;
            this.m_impactData[7] = 0;
            this.m_hitStunTimer = p_impactData[3];
            this.handleImpactDamage();
            GameMidlet.loadMusic(115, true);
            GameMidlet.s_currentSFX = (byte)2;
            GameMidlet.playMusic();
            GameMidlet.fighterHit(this);
            if (!fighter.m_isOnGround) {
                fighter.m_currentPoints += 30;
            }
            if (fighter.m_currentAttackId == s_fightersMatrix[this.m_fighterID][64]) {
                fighter.m_currentPoints += 100;
            } else if ((p_impactData[4] & 0x200) != 0) {
                fighter.m_currentPoints += 100;
            } else if ((p_impactData[4] & 4) != 0) {
                fighter.m_currentPoints += 30;
            } else if ((p_impactData[4] & 0x10) != 0) {
                if ((p_impactData[4] & 0x20) != 0) {
                    fighter.m_currentPoints += 20;
                } else if ((p_impactData[4] & 0x40) != 0) {
                    fighter.m_currentPoints += 50;
                }
            } else if ((p_impactData[4] & 8) != 0) {
                if ((p_impactData[4] & 0x20) != 0) {
                    fighter.m_currentPoints += 15;
                } else if ((p_impactData[4] & 0x40) != 0) {
                    fighter.m_currentPoints += 50;
                }
            }
            fighter.m_freezeTimer = freezeDuration = (p_impactData[4] & 0x40) != 0 ? 100 : 50;
            this.m_freezeTimer = freezeDuration;
            boolean airHit = false;
            if (!this.m_isOnGround || (p_impactData[4] & 0x100) != 0 || forceJuggle || this.m_healthPoints <= 0 || this.isInOkizemeState()) {
                this.initState(15);
                airHit = true;
            } else if ((this.m_impactData[4] & 4) != 0) {
                this.initState(12);
            } else if ((this.m_impactData[4] & 2) != 0) {
                this.initState(13);
            } else if ((this.m_impactData[4] & 1) != 0) {
                this.initState(14);
            } else {
                this.initState(11);
            }
            int n = fpAdjust = (p_impactData[4] & 0x40) != 0 ? 3276 : 1638;
            this.m_fpTotalBufferXAdjustment = airHit ? (this.m_fpTotalBufferXAdjustment += this.m_orientation * -1 * fpAdjust) : this.m_orientation * -1 * fpAdjust;
            this.m_fpBufferXAdjustment = this.m_fpTotalBufferXAdjustment;
            GameMidlet.addParticle(2, p_collsionBoundaries, 0, p_impactData, this.m_orientation);
            if ((this.m_impactData[4] & 0x180) != 0) {
                GameMidlet.startShakeCameraY();
                GameMidlet.addParticle(3, p_collsionBoundaries, 0, p_impactData, this.m_orientation);
            }
        }
        return 0;
    }

    private boolean isThrowable() {
        return this.m_isOnGround && m_antiThrowTimer == 0 && this.m_state != 5 && this.m_state != 17 && this.m_state != 20 && this.m_state != 21 && this.m_state != 22 && this.m_state != 23 && this.m_state != 24 && this.m_state != 25 && this.m_state != 26;
    }

    private boolean isInOkizemeState() {
        return this.m_state == 20 || this.m_state == 21 || this.m_state == 22 || this.m_state == 23 || this.m_state == 24 || this.m_state == 25 || this.m_state == 26;
    }

    private void handleImpactDamage() {
        int fpDamagePoints = this.m_impactData[5] << 8;
        for (int i = 1; i < this.m_comboCounter; ++i) {
            fpDamagePoints = (int)((long)fpDamagePoints * 245L >> 8);
        }
        this.m_healthPoints -= fpDamagePoints >> 8;
    }

    public void copyImpactData(int[] p_impactData) {
        this.m_lastImpactData[0] = p_impactData[0];
        this.m_lastImpactData[1] = p_impactData[1];
        this.m_lastImpactData[4] = p_impactData[4];
        this.m_lastImpactData[6] = p_impactData[6];
        this.m_lastImpactData[7] = p_impactData[7];
    }

    public void onAttackConnected(ICollidable p_AttackedObject, int[] p_impactData) {
        this.m_attackConnected = true;
    }

    private void resetComboCounter(boolean p_displayCurrentCombo) {
        if (this.m_comboCounter > 1) {
            this.m_currentPoints += 30 * this.m_comboCounter;
        }
        this.m_fpTotalBufferXAdjustment = 0;
        this.m_juggleCount = 0;
        this.m_comboCounter = 0;
    }

    public void onEnvironmentCollided(int p_environmentType) {
        switch (p_environmentType) {
            case 8: {
                this.m_tempFlags |= 1;
                break;
            }
            case 2: 
            case 4: {
                this.m_tempFlags |= 2;
            }
        }
    }

    public boolean isOnGround() {
        return this.m_isOnGround;
    }

    public boolean isNextToWall() {
        return (this.m_tempFlags & 2) != 0;
    }

    public String toString() {
        if (this.m_fighterID >= 0) {
            return GameMidlet.getFighterName(this.m_fighterID);
        }
        return "ErrMac";
    }

    public void resetState() {
        if (this.m_state == 3 || this.m_state == 1 || this.m_state == 5) {
            this.initState(0);
        }
    }

    public boolean AIopponentHitByAttack() {
        TKFighter opponent = this.getOpponentOfAI();
        return opponent.m_state == 13 || opponent.m_state == 16 || opponent.m_state == 17 || opponent.m_state == 15 || opponent.m_state == 14 || opponent.m_state == 12 || opponent.m_state == 11;
    }

    public boolean IsFalling() {
        return this.m_physicsData[3] > 0;
    }

    public boolean opponentIsFalling() {
        return this.getOpponentOfAI().IsFalling();
    }

    public int getCurrentAttackStatus() {
        if (this.m_currentAttackId == -1) {
            return -1;
        }
        int propertiesOffset = this.m_currentAttackId * 4;
        if (this.m_stateTimer < this.m_attacksProperties[propertiesOffset + 0]) {
            return 0;
        }
        if (this.m_stateTimer > this.m_attacksProperties[propertiesOffset + 1]) {
            return 2;
        }
        return 1;
    }

    public int getRemainingTimeInCurrentAttackStatus() {
        int currentAttackStatus = this.getCurrentAttackStatus();
        if (currentAttackStatus == -1) {
            return -1;
        }
        int propertiesOffset = this.m_currentAttackId * 4;
        int startTimer = this.m_attacksProperties[propertiesOffset + 0];
        int endTimer = this.m_attacksProperties[propertiesOffset + 1];
        int totalTimer = s_fightersAnims[this.m_fighterID][this.m_currentAnimId].getTotalDuration();
        if (currentAttackStatus == 0) {
            return startTimer - this.m_stateTimer;
        }
        if (currentAttackStatus == 1) {
            return endTimer - this.m_stateTimer;
        }
        return totalTimer - this.m_stateTimer;
    }

    public int getCurrentAttackMask() {
        if (this.m_currentAttackId == -1) {
            return -1;
        }
        return this.getAttackMask(this.m_currentAttackId);
    }

    public int getAttackMask(int p_attackId) {
        return this.m_attacksProperties[p_attackId * 4 + 3];
    }

    public int getAttackStartingTimer(int p_attackId) {
        return this.m_attacksProperties[p_attackId * 4 + 0];
    }

    public int lookForAttack(int p_maxTimer) {
        long validAttacks = 0L;
        int attacksCount = s_fightersAttacks[this.m_fighterID].length / 4;
        for (int i = 0; i < attacksCount; ++i) {
            if ((this.m_attacksInMatrix & 1L << i) == 0L || this.getAttackStartingTimer(i) >= p_maxTimer) continue;
            validAttacks |= (long)(1 << i);
        }
        if (this.m_state == 10 || this.m_state == 9) {
            byte stepAttackId = s_fightersMatrix[this.m_fighterID][64];
            validAttacks &= (long)(1 << stepAttackId);
        }
        validAttacks = this.m_isOnGround ? (validAttacks &= (long)(~(1 << s_fightersMatrix[this.m_fighterID][60]))) : (long)(1 << s_fightersMatrix[this.m_fighterID][60]);
        return GameMidlet.getRandomInBitfield(validAttacks);
    }

    public int getRandomAttackInCommandMatrix() {
        long attacksMatrix = this.m_attacksInMatrix;
        if (this.m_state == 10 || this.m_state == 9) {
            byte stepAttackId = s_fightersMatrix[this.m_fighterID][64];
            attacksMatrix &= (long)(1 << stepAttackId);
        }
        attacksMatrix = this.m_isOnGround ? (attacksMatrix &= (long)(~(1 << s_fightersMatrix[this.m_fighterID][60]))) : (long)(1 << s_fightersMatrix[this.m_fighterID][60]);
        return GameMidlet.getRandomInBitfield(attacksMatrix);
    }

    public TKFighter getOpponentOfAI() {
        if (GameMidlet.s_ingameState != 3) {
            return this == GameMidlet.s_battleFighter1 ? GameMidlet.s_battleFighter2 : GameMidlet.s_battleFighter1;
        }
        return GameMidlet.s_mainFighter;
    }

    public int getDistanceFromOpponent() {
        TKFighter opponent = this.getOpponentOfAI();
        int distance = opponent.m_physicsData[0] - this.m_physicsData[0];
        return distance < 0 ? -distance : distance;
    }

    public boolean isInPossibleGuardState() {
        return this.m_state == 0 || this.m_state == 16 || this.m_state == 5 || this.m_state == 17 || this.m_state == 3 || (this.m_state == 24 || this.m_state == 25 || this.m_state == 26 || this.m_state == 21 || this.m_state == 22 || this.m_state == 23) && this.m_stateTimer > 200;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void updateAI() {
        TKFighter opponent;
        block145: {
            int opponentAttackStatus;
            block149: {
                block150: {
                    int impactMask;
                    block146: {
                        int possibleAttackId;
                        block147: {
                            block148: {
                                if (!this.m_isActive || !this.m_isAIControlled || this.m_isAIControlled && this.m_disableAI) {
                                    if (!this.m_disableControls) return;
                                    this.m_currentPattern = -1;
                                    this.m_currentPatternStep = 0;
                                    this.m_isStandGuarding = false;
                                    this.m_isCrouchGuarding = false;
                                    return;
                                }
                                this.m_aiStateTimer += GameMidlet.s_ingameElapsedTimeClamped;
                                this.m_aiLevel = GameMidlet.s_gameDifficulty * 3;
                                if ((s_lastKeyPressedTimer -= GameMidlet.s_ingameElapsedTimeClamped) > 0) {
                                    this.m_aiLevel += Math.max(0, s_lastKeyTimesPressed - 5);
                                }
                                if (GameMidlet.s_ingameState == 0) {
                                    this.m_aiLevel += GameMidlet.s_arcadeModeCurrentFight;
                                } else if (GameMidlet.s_ingameState == 1) {
                                    this.m_aiLevel += GameMidlet.s_storyModeCurrentFight;
                                } else if (GameMidlet.s_ingameState == 3) {
                                    this.m_aiLevel += GameMidlet.s_forceModeCurrentWorld;
                                }
                                if (this.m_aiLevel > 10) {
                                    this.m_aiLevel = 10;
                                }
                                opponent = this.getOpponentOfAI();
                                if (this.m_state == 16 && this.m_stateTimer >= this.m_blockStunTimer) {
                                    this.initState(0);
                                } else if (this.m_state == 17 && this.m_stateTimer >= this.m_blockStunTimer) {
                                    this.initState(5);
                                }
                                if (this.isInPossibleAttackState() && this.m_currentAttackId == -1 && this.m_currentPattern == -1 && this.m_autoPunish) {
                                    int punishmentAttack = this.lookForAttack(opponent.getRemainingTimeInCurrentAttackStatus());
                                    if (punishmentAttack != -1) {
                                        this.m_currentAttackId = (short)punishmentAttack;
                                        this.initState(28);
                                    }
                                    this.m_currentPattern = -1;
                                    this.m_autoPunish = false;
                                }
                                if (this.m_aiStateTimer > 3000) {
                                    this.m_currentPattern = -1;
                                    this.m_currentPatternStep = 0;
                                    this.m_aiStateTimer = 0;
                                }
                                if (this.isInPossibleAttackState() && this.m_currentAttackId == -1 && this.m_currentPattern == -1 && !this.m_autoPunish) {
                                    if (opponent.m_state == 20) {
                                        int group = 0;
                                        this.m_currentPattern = AI_PATTERNS_BY_GROUP[group][GameMidlet.getRandomInt(0, AI_PATTERNS_BY_GROUP[group].length - 1)];
                                    } else {
                                        this.m_currentPattern = opponent.m_state == 15 ? (GameMidlet.getRandomInt(0, this.m_aiLevel) == 0 ? 9 : 6) : GameMidlet.getRandomInt(0, 12);
                                    }
                                    this.s_aiLatencyTimer = 300 - this.m_aiLevel * 30 + GameMidlet.getRandomInt(0, 700 - 70 * this.m_aiLevel);
                                    this.m_aiUltimateDefense = GameMidlet.getRandomInt(this.m_aiLevel, 10) > 9;
                                    this.m_currentPatternStep = 0;
                                    this.m_aiStateTimer = 0;
                                }
                                if (GameMidlet.s_ingameState == 3 && GameMidlet.s_ingameSubState == 150 && GameMidlet.s_mainFighter != this) {
                                    this.m_isStandGuarding = false;
                                    this.m_isCrouchGuarding = false;
                                    this.m_aiUltimateDefense = false;
                                } else {
                                    this.m_isStandGuarding = GameMidlet.getRandomInt(this.m_aiLevel, 10) > 6;
                                    boolean bl = this.m_isCrouchGuarding = GameMidlet.getRandomInt(this.m_aiLevel, 10) > 6;
                                    if (this.m_aiUltimateDefense && this.isInPossibleGuardState()) {
                                        this.m_isStandGuarding = true;
                                        this.m_isCrouchGuarding = true;
                                    }
                                }
                                if (!this.m_aiUltimateDefense || !this.isInPossibleAttackState() || !this.m_isOnGround || (opponentAttackStatus = opponent.getCurrentAttackStatus()) == -1) break block145;
                                int timeLeft = opponent.getRemainingTimeInCurrentAttackStatus();
                                possibleAttackId = this.lookForAttack(timeLeft);
                                impactMask = opponent.getCurrentAttackMask();
                                if (opponentAttackStatus != 0) break block146;
                                if (possibleAttackId != -1) break block147;
                                if (!opponent.m_isOnGround) break block148;
                                if ((impactMask & 0x201) != 0) {
                                    this.m_currentPattern = 13;
                                    this.m_currentPatternStep = 0;
                                    break block145;
                                } else if ((impactMask & 0x40) != 0) {
                                    this.m_currentPattern = 14;
                                    this.m_currentPatternStep = 0;
                                    break block145;
                                } else {
                                    this.m_autoPunish = true;
                                }
                                break block145;
                            }
                            this.m_autoPunish = true;
                            break block145;
                        }
                        if (opponent.m_isOnGround) {
                            this.m_currentPattern = -1;
                            this.m_currentAttackId = (short)possibleAttackId;
                            this.initState(28);
                            break block145;
                        } else {
                            this.m_autoPunish = true;
                        }
                        break block145;
                    }
                    if (opponentAttackStatus != 1) break block149;
                    if (!opponent.m_isOnGround) break block150;
                    if ((impactMask & 0x201) != 0) {
                        this.m_currentPattern = 13;
                        this.m_currentPatternStep = 0;
                        break block145;
                    } else if ((impactMask & 0x40) != 0) {
                        this.m_currentPattern = 14;
                        this.m_currentPatternStep = 0;
                        break block145;
                    } else {
                        this.m_autoPunish = true;
                    }
                    break block145;
                }
                this.m_currentPattern = 15;
                this.m_currentPatternStep = 0;
                break block145;
            }
            if (opponentAttackStatus == 2) {
                this.m_autoPunish = true;
            }
        }
        boolean readyForPattern = this.isInPossibleAttackState() && this.m_isOnGround && this.m_stateTimer >= this.s_aiLatencyTimer;
        int punishmentAttack = -1;
        block0 : switch (this.m_currentPattern) {
            case 0: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        this.initState(2);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (this.m_state != 2 || !this.hasAnimationStopped() && this.m_stateTimer <= 150) break;
                        this.m_currentAttackId = this.m_data[0];
                        this.initState(28);
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 1: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (readyForPattern) {
                            this.m_currentJumpDirection = 0;
                            this.initState(6);
                            this.m_currentPattern = -1;
                            break;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        this.m_currentJumpDirection = 0;
                        this.initState(6);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (GameMidlet.getRandomInt(0, 1) == 0) {
                            ++this.m_currentPatternStep;
                            break;
                        }
                        this.m_currentPatternStep += 2;
                        break;
                    }
                    case 2: {
                        if (this.m_state != 6 || this.m_stateTimer <= 100) break;
                        this.m_currentAttackId = this.m_data[2];
                        this.initState(28);
                        this.m_currentPattern = -1;
                        break;
                    }
                    case 3: {
                        if (this.m_state != 7 || this.m_stateTimer <= 100) break;
                        this.m_currentAttackId = this.m_data[2];
                        this.initState(28);
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 11: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        this.initState(5);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (this.m_state != 5 || this.m_stateTimer <= 200) break;
                        this.m_currentAttackId = this.m_data[1];
                        this.initState(28);
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 3: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        this.initState(1);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (this.m_state != 1 || this.m_stateTimer <= this.s_aiLatencyTimer) break;
                        this.initState(6);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 2: {
                        if (GameMidlet.getRandomInt(0, 1) == 0) {
                            ++this.m_currentPatternStep;
                            break;
                        }
                        this.m_currentPatternStep += 2;
                        break;
                    }
                    case 3: {
                        if (this.m_state != 6 || this.m_stateTimer <= 100) break;
                        this.m_currentAttackId = this.m_data[2];
                        this.initState(28);
                        this.m_currentPattern = -1;
                        break;
                    }
                    case 4: {
                        if (this.m_state != 7 || this.m_stateTimer <= 100) break;
                        this.m_currentAttackId = this.m_data[2];
                        this.initState(28);
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 4: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (readyForPattern) {
                            this.m_currentJumpDirection = GameMidlet.getRandomInt(0, 2);
                            this.initState(6);
                            this.m_currentPattern = -1;
                            break;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        this.initState(9);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (this.m_state != 10) break;
                        this.m_currentAttackId = s_fightersMatrix[this.m_fighterID][64];
                        this.initState(28);
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        this.initState(2);
                        this.m_currentPatternStep = GameMidlet.getRandomInt(1, 2);
                        break;
                    }
                    case 1: {
                        if (this.m_stateTimer < 90) break;
                        this.m_autoComboEnabled = true;
                        this.m_currentComboId = (short)GameMidlet.getRandomInt(0, this.m_comboData.length - 1);
                        int combobhv = GameMidlet.getRandomInt(0, 2);
                        switch (combobhv) {
                            case 0: {
                                this.m_maxAutoComboSteps = (short)99;
                            }
                            case 1: {
                                this.m_maxAutoComboSteps = (short)3;
                            }
                            case 2: {
                                this.m_maxAutoComboSteps = (short)5;
                                break;
                            }
                        }
                        this.m_currentPatternStep = 3;
                        break;
                    }
                    case 2: {
                        if (!this.hasAnimationStopped()) break;
                        this.m_autoComboEnabled = true;
                        this.m_currentComboId = (short)GameMidlet.getRandomInt(0, this.m_comboData.length - 1);
                        int combobhv = GameMidlet.getRandomInt(0, 2);
                        switch (combobhv) {
                            case 0: {
                                this.m_maxAutoComboSteps = (short)99;
                            }
                            case 1: {
                                this.m_maxAutoComboSteps = (short)3;
                            }
                            case 2: {
                                this.m_maxAutoComboSteps = (short)5;
                                break;
                            }
                        }
                        this.m_currentPatternStep = 3;
                        break;
                    }
                    case 3: {
                        if (this.m_autoComboEnabled) break;
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (readyForPattern && this.isInPossibleAttackState()) {
                            this.m_autoComboEnabled = true;
                            this.m_currentComboId = (short)(this.m_comboData.length - 1);
                            this.m_maxAutoComboSteps = (short)99;
                            this.m_currentPattern = -1;
                            break;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (readyForPattern) {
                            this.m_currentAttackId = this.m_data[4];
                            this.initState(28);
                            this.m_currentPattern = -1;
                            break;
                        }
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        this.initState(2);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (this.m_stateTimer <= 80 + this.s_aiLatencyTimer && !this.hasAnimationStopped()) break;
                        this.m_currentAttackId = (short)this.getRandomAttackInCommandMatrix();
                        this.initState(28);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 2: {
                        if (GameMidlet.getRandomInt(0, 1) == 0) {
                            this.m_currentPatternStep = 0;
                            break;
                        }
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 10: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        this.initState(4);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (this.m_stateTimer <= 150 && !this.hasAnimationStopped()) break;
                        this.m_currentAttackId = (short)this.getRandomAttackInCommandMatrix();
                        this.initState(28);
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 12: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!readyForPattern) break;
                        if (GameMidlet.getRandomInt(0, 1) == 0) {
                            this.initState(1);
                            ++this.m_currentPatternStep;
                            break;
                        }
                        this.initState(3);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (this.m_stateTimer <= 500) break;
                        this.initState(0);
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 13: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!this.isInPossibleAttackState()) break;
                        this.initState(5);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (opponent.getCurrentAttackStatus() == 0 || opponent.getCurrentAttackStatus() == 1) break;
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 2: {
                        punishmentAttack = this.lookForAttack(opponent.getRemainingTimeInCurrentAttackStatus());
                        if (punishmentAttack != -1) {
                            this.m_currentAttackId = (short)punishmentAttack;
                            this.initState(28);
                        }
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 14: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!this.isInPossibleAttackState()) break;
                        this.initState(9);
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (opponent.getCurrentAttackStatus() != 2) break;
                        this.m_autoPunish = true;
                        this.m_currentPattern = -1;
                        break;
                    }
                }
                break;
            }
            case 15: {
                switch (this.m_currentPatternStep) {
                    case 0: {
                        if (!this.isInPossibleAttackState()) break;
                        this.initState(3);
                        this.m_autoPunish = true;
                        ++this.m_currentPatternStep;
                        break;
                    }
                    case 1: {
                        if (opponent.getCurrentAttackStatus() == 0 || opponent.getCurrentAttackStatus() == 1) break;
                        this.initState(0);
                        this.m_currentPattern = -1;
                    }
                }
                break;
            }
        }
        int maxComboSteps = this.m_aiLevel < 2 ? 1 : (this.m_aiLevel < 4 ? 2 : (this.m_aiLevel < 6 ? 3 : (this.m_aiLevel < 8 ? 4 : 99)));
        if (maxComboSteps < this.m_maxAutoComboSteps) {
            this.m_maxAutoComboSteps = maxComboSteps;
        }
        switch (this.m_state) {
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                this.m_currentPattern = -1;
                return;
            }
            case 15: {
                this.m_currentPattern = -1;
                if (this.m_healthPoints <= 0) return;
                this.m_techingState = 2;
                this.m_techingTimer = 300;
                this.m_techingDirection = 1;
                return;
            }
            case 16: 
            case 17: {
                this.m_currentPattern = -1;
                return;
            }
            case 20: {
                if (!this.hasAnimationStopped()) return;
                if (this.m_healthPoints > 0) {
                    this.m_currentPattern = -1;
                    this.initState(22);
                    return;
                }
                this.resetComboCounter(true);
                return;
            }
        }
    }

    public int detectAIPattern() {
        return 0;
    }

    private void updatePracticeModeDummy() {
        if (!this.m_isPracticeModeDummy) {
            return;
        }
        this.m_lastDamageTimer += GameMidlet.s_ingameElapsedTimeClamped;
        if (this.m_lastDamageTimer > 2000) {
            this.m_healthPoints = 100;
        }
        this.m_lastDamageTimer += GameMidlet.s_ingameElapsedTimeClamped;
        if (this.m_lastDamageTimer > 2000) {
            this.m_healthPoints = 100;
            if (this.m_state == 16 || this.m_state == 17) {
                this.initState(0);
            }
            this.m_isStandGuarding = false;
            this.m_isCrouchGuarding = false;
        } else if (this.isInPossibleGuardState() && GameMidlet.s_dummyGuardDescription == 1) {
            this.m_isStandGuarding = true;
            this.m_isCrouchGuarding = true;
        }
        switch (GameMidlet.s_dummyGuardDescription) {
            case 0: {
                this.m_isStandGuarding = false;
                this.m_isCrouchGuarding = false;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.isInPossibleGuardState()) {
                    this.m_isStandGuarding = true;
                    this.m_isCrouchGuarding = true;
                    break;
                }
                this.m_isStandGuarding = false;
                this.m_isCrouchGuarding = false;
            }
        }
        if (GameMidlet.s_dummyBehaviourDescription == 8) {
            this.m_isAIControlled = true;
            this.m_disableAI = false;
        } else {
            this.m_isAIControlled = false;
            this.m_disableAI = true;
        }
        block5 : switch (this.m_state) {
            case 0: {
                if (this.m_stateTimer < 1000) break;
                switch (GameMidlet.s_dummyBehaviourDescription) {
                    case 0: {
                        break block5;
                    }
                    case 1: {
                        this.initState(5);
                        break block5;
                    }
                    case 2: {
                        this.m_currentJumpDirection = 1;
                        this.initState(6);
                        break block5;
                    }
                    case 3: {
                        this.m_currentJumpDirection = 0;
                        this.initState(6);
                        break block5;
                    }
                    case 4: {
                        this.m_currentJumpDirection = 2;
                        this.initState(6);
                        break block5;
                    }
                    case 5: {
                        this.m_currentAttackId = this.m_data[4];
                        this.initState(28);
                        break block5;
                    }
                    case 6: {
                        this.m_currentAttackId = 1;
                        this.initState(28);
                        break block5;
                    }
                    case 7: {
                        this.m_currentAttackId = (short)3;
                        this.initState(28);
                        break block5;
                    }
                    case 9: {
                        this.m_currentAttackId = this.m_data[0];
                        this.initState(28);
                        break block5;
                    }
                }
                break;
            }
            case 5: {
                if (GameMidlet.s_dummyBehaviourDescription == 1 || GameMidlet.s_dummyBehaviourDescription == 8) break;
                this.initState(0);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 15: {
                block26 : switch (GameMidlet.s_dummyTechDescription) {
                    case 0: {
                        this.m_techingState = 1;
                        break;
                    }
                    case 1: {
                        this.m_techingState = 2;
                        this.m_techingTimer = 300;
                        this.m_techingDirection = 2;
                        break;
                    }
                    case 2: {
                        this.m_techingState = 2;
                        this.m_techingTimer = 300;
                        this.m_techingDirection = 0;
                        break;
                    }
                    case 3: {
                        this.m_techingState = 2;
                        this.m_techingTimer = 300;
                        this.m_techingDirection = 1;
                        break;
                    }
                    case 4: {
                        switch (GameMidlet.getRandomInt(0, 3)) {
                            case 0: {
                                this.m_techingState = 1;
                                break block26;
                            }
                            case 1: {
                                this.m_techingState = 2;
                                this.m_techingTimer = 300;
                                this.m_techingDirection = 2;
                                break block26;
                            }
                            case 2: {
                                this.m_techingState = 2;
                                this.m_techingTimer = 300;
                                this.m_techingDirection = 0;
                                break block26;
                            }
                            case 3: {
                                this.m_techingState = 2;
                                this.m_techingTimer = 300;
                                this.m_techingDirection = 1;
                            }
                        }
                    }
                }
                break;
            }
            case 19: {
                this.m_isStandGuarding = false;
                this.m_isCrouchGuarding = false;
                break;
            }
            case 16: 
            case 17: {
                break;
            }
            case 20: {
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                if (!this.isInPossibleGuardState() || GameMidlet.s_dummyGuardDescription != 1) break;
                this.m_isStandGuarding = true;
                this.m_isCrouchGuarding = true;
            }
        }
    }

    static {
        s_maximumNeutralTime = 200;
        TEKKEN_KEYMAP = new int[][]{{4, 0, 16, 8224, 16512, 66048, 131136, 1024, 256, 2048, 32776, 262144, 524288, 16, 0, 4, 16512, 8224, 66048, 131136, 1024, 256, 2048, 32776, 262144, 524288}, {4, 32776, 16, 8224, 16512, 66048, 131136, 1024, 256, 2048, 0, 262144, 524288, 16, 32776, 4, 16512, 8224, 66048, 131136, 1024, 256, 2048, 0, 262144, 524288}};
        PATTERN = new int[]{3, 3, 8, 2, 4, 1, 3, 4, 2, 8, 4, 3, 2, 4, 8, 2, 2, 2, 4, 5, 2, 4, 8, 6, 2, 8, 4, 7, 2, 8, 8, 8, 2, 2, 2, 0, 2, 2, 8, 9, 2, 4, 4, 10, 1, 4, 11, 1, 8, 12, 1, 1, 13, 1, 2, 14, 0};
        isBattleOver = false;
        s_currentKeymap = 0;
        AI_PATTERNS_BY_GROUP = new int[][]{{12}, {10, 5}, {3, 5, 6, 7, 9, 0, 11, 2}};
    }
}

