/*
 * Decompiled with CFR 0.152.
 */
package screens;

import game.Apearance;
import game.Scenario;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Fonts;
import lib.Lib;
import main.FrameOfScenario;
import main.GameManager;
import screens.LogoScreen;
import screens.MenuScreen;
import screens.elements.Hint;
import screens.elements.MassageSessionModus;

public class DialogScreen {
    public static int COLOR_DIALOG_BKG_PLAYER_LIGHT = 0xFFFFFF;
    public static int COLOR_DIALOG_BKG_PLAYER_DARK = 0xCCCCFF;
    public static int COLOR_DIALOG_BKG_OTHER_WOMAN = 0xFFCCCC;
    public static int COLOR_DIALOG_BKG_INFO = 0xFFFFFF;
    public static int COLOR_CHANGE_STEP = 328960;
    public static int DIALOG_ARROW_MARGIN = 1;
    public static int DIALOG_ARROW_MOVEMENT_STEP = 50;
    public static int DIALOG_ARROW_MOVEMENT_SIZE = 500;
    public static final int TALKING_NON = 0;
    public static final int TALKING_PLAYER = 1;
    public static final int TALKING_LADY = 2;
    private static int arrowDialogOffset = 0;
    private static int arrowDialogMovementDirection;
    private static int colorDialogPlayer;
    private static int colorChangeDirection;
    public static FrameOfScenario currentFrame;
    private static int previousFrameId;
    public static int whosTalking;
    public static int playerTextSelected;
    public static int[][][] curentTextShownWrapped;
    public static boolean isArcadeModeActive;
    private static boolean isArcadeDialogDiscard;
    private static boolean isArcadeGameWon;
    public static final int ARCADE_STATE_NONE = -1;
    public static final int ARCADE_STATE_DIALOG = 1;
    public static final int ARCADE_STATE_HORIZONTAL = 2;
    public static final int ARCADE_STATE_VERTICAL = 3;
    public static final int ARCADE_STATE_PRESENTATION = 4;
    public static final int ARCADE_STATE_PROMPT = 5;
    public static int arcadeState;
    public static boolean isImageBlured;
    private static int requestedArcadeNextFrame;
    private static int boxHeight;
    public static int currentImageId;
    public static int continueFrameId;
    public static int continueInitialClothes;
    public static boolean stopAnimateGame;
    public static int currentClothes;
    public static boolean currentClothesVisible;
    public static final int TALKING_INFO = 3;
    public static final int ARCADE_STATE_BEFORE = 7;
    public static final int ARCADE_STATE_IN_PROGRESS = 8;
    public static final int ARCADE_STATE_AFTER = 9;
    public static int requestedNextFrameIndex;
    private static int previousFrameImageId;
    public static int DIALOG_TEXT_INTERLINE;
    public static int DIALOG_TEXT_OFFSET;
    public static int DIALOG_BOX_ADDITIONAL_SPACE;

    public static void showGameScreen(boolean newGame) {
        colorChangeDirection = COLOR_CHANGE_STEP;
        colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_LIGHT;
        arrowDialogMovementDirection = DIALOG_ARROW_MOVEMENT_STEP;
        arrowDialogOffset = 0;
        arrowDialogMovementDirection = DIALOG_ARROW_MOVEMENT_STEP;
        GameManager.isContinueIconEnabled = false;
        continueFrameId = -1;
        continueInitialClothes = -1;
        currentImageId = -1;
        MassageSessionModus.isBreastVisible = false;
        for (int i = 0; i < Scenario.size(); ++i) {
            FrameOfScenario fos = Scenario.elementAt(i);
            if (fos.type != 86) continue;
            Scenario.setFramesStates(i, 0);
        }
        GameManager.current.startOperation(4, 10);
        if (newGame) {
            currentFrame = null;
            whosTalking = -1;
            currentImageId = 0;
            Scenario.initFrameStates();
        }
        DialogScreen.nextGameStep();
        GameManager.current.startOperation(6);
    }

    public static void showGameScreen(int initialFrame) {
        currentFrame = new FrameOfScenario(0, 0, 73, 1, 1);
        DialogScreen.currentFrame.nextId[0] = initialFrame;
        currentImageId = -1;
        DialogScreen.showGameScreen(false);
    }

    public static void paint_GameDialog(Graphics g) {
        if (isArcadeModeActive || arcadeState == 9) {
            g.drawImage(GameManager.imgCurrentImage, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
            if (isArcadeModeActive || arcadeState == 9) {
                int currentAnimationFrameModified = 100 * MassageSessionModus.currentAnimationFrame / 100;
                MassageSessionModus.currentBreastVisible = MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[0][Lib.mod(currentAnimationFrameModified, Apearance.ANIMATION_SEQUENCES[0].length)]] + MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[1][Lib.mod(currentAnimationFrameModified, Apearance.ANIMATION_SEQUENCES[1].length)]] + MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[2][Lib.mod(currentAnimationFrameModified, Apearance.ANIMATION_SEQUENCES[2].length)]] + MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[3][Lib.mod(currentAnimationFrameModified, Apearance.ANIMATION_SEQUENCES[3].length)]] + MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[4][Lib.mod(currentAnimationFrameModified, Apearance.ANIMATION_SEQUENCES[4].length)]];
            } else if (DialogScreen.currentFrame.type == 67) {
                MassageSessionModus.currentBreastVisible = DialogScreen.currentFrame.nextId[DialogScreen.currentFrame.parametersCount - 1];
            }
            MassageSessionModus.drawParts(g);
            if (isArcadeModeActive) {
                g.setColor(0);
                if (!GameManager.gamePaused) {
                    if (MassageSessionModus.timeLeft > 9) {
                        Fonts.fontMenu.drawString(g, Fonts.fontMapper.mapString("0:" + MassageSessionModus.timeLeft), 30, 24, Apearance.TIMER_DIGITS_POSITION_ABSOLUTE);
                    } else {
                        Fonts.fontMenu.drawString(g, Fonts.fontMapper.mapString("0:0" + MassageSessionModus.timeLeft), 30, 24, Apearance.TIMER_DIGITS_POSITION_ABSOLUTE);
                    }
                    g.drawImage(MassageSessionModus.imgHand, MassageSessionModus.arrowX, MassageSessionModus.arrowY, 3);
                }
                Hint.drawHint(g, Hint.shownHintId);
                return;
            }
        } else {
            g.drawImage(GameManager.imgCurrentImage, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
        }
        int DIALOG_TEXT_INTERLINE = 0;
        int DIALOG_TEXT_OFFSET = -1;
        int DIALOG_BOX_ADDITIONAL_SPACE = 5;
        if (curentTextShownWrapped != null) {
            boxHeight = curentTextShownWrapped[playerTextSelected].length * (Fonts.fontDialog.getHeight() + DIALOG_TEXT_INTERLINE) + DIALOG_BOX_ADDITIONAL_SPACE + 2 * DIALOG_TEXT_INTERLINE;
            boxHeight = Math.max(boxHeight, 125 * GameManager.imgArrows.getHeight() / 200);
        } else {
            boxHeight = 0;
        }
        int upperBox = GameManager.current.getHeight() - boxHeight;
        if (!(isArcadeModeActive && arcadeState == 8 || whosTalking == 0)) {
            boolean blinking = false;
            if (whosTalking == 1 && (DialogScreen.currentFrame.type == 68 || DialogScreen.currentFrame.type == 67 || DialogScreen.currentFrame.type == 74 || DialogScreen.currentFrame.type == 86) && DialogScreen.currentFrame.selectionsCount > 1 || whosTalking == 1 && arcadeState == 7 && arcadeState == 9 && DialogScreen.currentFrame.selectionsCount > 3) {
                blinking = true;
            }
            if (whosTalking == 1 && (DialogScreen.currentFrame.type == 74 || DialogScreen.currentFrame.type == 86)) {
                blinking = false;
            }
            if (whosTalking == 1 || whosTalking == 3) {
                if (DialogScreen.currentFrame.headIds[playerTextSelected] >= 0) {
                    Lib.drawSprite(g, GameManager.imgFaces, 5, upperBox - 1 - GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight() * DialogScreen.currentFrame.headIds[playerTextSelected], 0);
                }
                if (blinking) {
                    g.setColor(colorDialogPlayer);
                } else if (DialogScreen.currentFrame.headIds[playerTextSelected] >= 0) {
                    g.setColor(COLOR_DIALOG_BKG_PLAYER_DARK);
                } else {
                    g.setColor(COLOR_DIALOG_BKG_INFO);
                }
            } else if (whosTalking == 2 && DialogScreen.currentFrame.headIds[playerTextSelected + DialogScreen.currentFrame.selectionsCount] >= 0) {
                Lib.drawSprite(g, GameManager.imgFaces, 5, upperBox - 1 - GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight(), GameManager.imgFaces.getHeight() * DialogScreen.currentFrame.headIds[playerTextSelected + DialogScreen.currentFrame.selectionsCount], 0);
            }
            switch (DialogScreen.currentFrame.headIds[playerTextSelected + (whosTalking == 2 ? DialogScreen.currentFrame.selectionsCount : 0)]) {
                case 0: {
                    if (blinking) {
                        g.setColor(colorDialogPlayer);
                        break;
                    }
                    g.setColor(COLOR_DIALOG_BKG_PLAYER_DARK);
                    break;
                }
                case 1: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_WOMAN);
                    break;
                }
                case 2: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_WOMAN);
                    break;
                }
                case 3: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_WOMAN);
                    break;
                }
                case 4: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_WOMAN);
                    break;
                }
                case 5: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_WOMAN);
                    break;
                }
                case 6: {
                    g.setColor(COLOR_DIALOG_BKG_OTHER_WOMAN);
                    break;
                }
                default: {
                    g.setColor(COLOR_DIALOG_BKG_INFO);
                }
            }
            g.fillRoundRect(0, upperBox - 1, GameManager.current.getWidth() - 1, GameManager.current.getHeight() - upperBox, 12, 12);
            g.setColor(Apearance.COLOR_WHITE);
            g.drawRoundRect(0, upperBox - 1, GameManager.current.getWidth() - 1, GameManager.current.getHeight() - upperBox, 12, 12);
            g.setColor(Apearance.COLOR_BLACK);
            g.drawRoundRect(1, upperBox, GameManager.current.getWidth() - 3, GameManager.current.getHeight() - upperBox - 2, 12, 12);
            g.setColor(Apearance.COLOR_BLACK);
            if (curentTextShownWrapped != null) {
                Lib.drawTextLines(g, curentTextShownWrapped[playerTextSelected], GameManager.current.getWidth() / 2, (GameManager.current.getHeight() + upperBox + DIALOG_TEXT_OFFSET) / 2, Fonts.fontDialog, true, DIALOG_TEXT_INTERLINE);
            }
            if (blinking) {
                Lib.drawSprite(g, GameManager.imgArrows, DIALOG_ARROW_MARGIN + arrowDialogOffset / 100 + 1, (GameManager.current.getHeight() + upperBox) / 2 - GameManager.imgArrows.getHeight() / 4 - 1, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, 0, 0);
                Lib.drawSprite(g, GameManager.imgArrows, GameManager.current.getWidth() - DIALOG_ARROW_MARGIN - GameManager.imgArrows.getWidth() / 2 - arrowDialogOffset / 100 - 1, (GameManager.current.getHeight() + upperBox) / 2 - GameManager.imgArrows.getHeight() / 4 - 1, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, GameManager.imgArrows.getWidth() / 2, 0);
            }
        }
        Hint.drawHint(g, Hint.shownHintId);
        GameManager.keysBlocked = false;
    }

    public static void keyPressed_GameDialog(int key) throws InterruptedException {
        if (Hint.shownHintId == 3) {
            Hint.shownHintId = -1;
            GameManager.gamePaused = false;
            return;
        }
        Hint.shownHintId = -1;
        if (key == GameManager.KEY_SOFTKEY2 || key == -GameManager.KEY_SOFTKEY2) {
            GameManager.gamePaused = true;
            DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
            MenuScreen.showInGameMain(true);
            return;
        }
        if (GameManager.current.getGameAction(key) == 8) {
            DialogScreen.nextGameStep();
            return;
        }
        int selectionCount = -1;
        if ((DialogScreen.currentFrame.type == 68 || DialogScreen.currentFrame.type == 67) && whosTalking == 1) {
            selectionCount = DialogScreen.currentFrame.selectionsCount;
        }
        if (DialogScreen.currentFrame.type == 65 && arcadeState == 1 && whosTalking == 1) {
            selectionCount = DialogScreen.currentFrame.selectionsCount - 2;
        }
        if (selectionCount > 0) {
            switch (GameManager.current.getGameAction(key)) {
                case 5: {
                    ++playerTextSelected;
                    playerTextSelected = Lib.mod(playerTextSelected, selectionCount);
                    if (DialogScreen.skipEmptyFrame()) {
                        return;
                    }
                    GameManager.current.repaint();
                    return;
                }
                case 2: {
                    --playerTextSelected;
                    playerTextSelected = Lib.mod(playerTextSelected, selectionCount);
                    if (DialogScreen.skipEmptyFrame()) {
                        return;
                    }
                    GameManager.current.repaint();
                    return;
                }
            }
        }
        if (DialogScreen.currentFrame.type == 65) {
            return;
        }
        if (key == 1 || key == 6 || key == 2 || key == 5) {
            return;
        }
        if (whosTalking != 1 || DialogScreen.currentFrame.textPlayer.length <= 1) {
            Hint.hintUsed[1] = false;
            Hint.enableShowHint(1);
            GameManager.current.repaint();
        }
    }

    static void closeGame() {
        stopAnimateGame = true;
        currentFrame = null;
        currentImageId = -1;
        isArcadeModeActive = false;
        whosTalking = -1;
        arcadeState = -1;
        requestedArcadeNextFrame = -1;
        playerTextSelected = 0;
        currentClothesVisible = false;
        isImageBlured = false;
    }

    public static void nextGameStep() {
        DialogScreen.nextGameStepImpl();
        if (DialogScreen.currentFrame.type == 69 && whosTalking != 1) {
            return;
        }
        DialogScreen.skipEmptyFrame();
    }

    public static boolean skipEmptyFrame() {
        if (curentTextShownWrapped != null && arcadeState != 2 && arcadeState != 3 && curentTextShownWrapped[playerTextSelected][0][0] == Fonts.fontMapper.mapString("(-)")[0]) {
            DialogScreen.nextGameStep();
            return true;
        }
        return false;
    }

    private static void nextGameStepImpl() {
        if (isArcadeModeActive) {
            return;
        }
        boolean forceRepaint = false;
        if (whosTalking == 1) {
            whosTalking = 2;
            curentTextShownWrapped = DialogScreen.currentFrame.textLady;
            GameManager.current.repaint();
            return;
        }
        if (currentFrame != null && DialogScreen.currentFrame.type == 65 && arcadeState == 9) {
            requestedNextFrameIndex = playerTextSelected * 2 + 1;
            DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
        }
        if (currentFrame == null) {
            currentFrame = (FrameOfScenario)Scenario.scenario.firstElement();
            whosTalking = 1;
        } else if (!isArcadeModeActive) {
            if (DialogScreen.currentFrame.type == 69) {
                curentTextShownWrapped = DialogScreen.currentFrame.textLady;
                GameManager.current.startOperation(4, 89);
                return;
            }
            if (DialogScreen.currentFrame.type == 74) {
                requestedNextFrameIndex = Scenario.framesStates[DialogScreen.currentFrame.nextId[0]] + 1;
            }
            if (requestedNextFrameIndex > 0) {
                System.out.println("requested frame: " + requestedNextFrameIndex);
                System.out.println("Length = " + DialogScreen.currentFrame.nextId.length);
                DialogScreen.switchCurrentFrameTo(DialogScreen.currentFrame.nextId[requestedNextFrameIndex]);
                requestedNextFrameIndex = -1;
                if (DialogScreen.currentFrame.type != 65 && arcadeState == 9) {
                    arcadeState = -1;
                }
            } else {
                DialogScreen.switchCurrentFrameTo(DialogScreen.currentFrame.nextId[playerTextSelected]);
            }
        }
        if (!isArcadeModeActive) {
            if (DialogScreen.currentFrame.type == 68 || DialogScreen.currentFrame.type == 67 || DialogScreen.currentFrame.type == 74 || DialogScreen.currentFrame.type == 86 || DialogScreen.currentFrame.type == 65 && arcadeState == 9) {
                whosTalking = 1;
                if (DialogScreen.currentFrame.type != 74 && DialogScreen.currentFrame.type != 86) {
                    if (!Hint.hintUsed[2] && DialogScreen.currentFrame.textPlayer.length > 1) {
                        Hint.enableShowHint(2);
                        Hint.hintUsed[2] = true;
                    } else if (!Hint.hintUsed[0]) {
                        Hint.enableShowHint(0);
                        Hint.hintUsed[0] = true;
                    }
                }
            } else if (DialogScreen.currentFrame.type != 65) {
                whosTalking = 3;
                if (!Hint.hintUsed[0]) {
                    Hint.enableShowHint(0);
                    Hint.hintUsed[0] = true;
                }
            }
            if (DialogScreen.currentFrame.type == 65) {
                arcadeState = 8;
                whosTalking = 0;
                if (continueFrameId < 0) {
                    continueFrameId = previousFrameId;
                }
                GameManager.isContinueIconEnabled = true;
                if (GameManager.imgClothesParts == null) {
                    GameManager.imgClothesParts = new Image[Apearance.CLOTHES_PARTS_POSITIONS_X.length];
                }
                LogoScreen.loadingProgress = 0;
                GameManager.current.repaint();
                GameManager.current.serviceRepaints();
                DialogScreen.clearPartsMemory();
                try {
                    for (int i = 0; i < Apearance.ANIMATION_SEQUENCES.length; ++i) {
                        for (int n = 0; n < Apearance.ANIMATION_SEQUENCES[i].length; ++n) {
                            if (Apearance.ANIMATION_SEQUENCES[i][n] == 0 || GameManager.imgClothesParts[Apearance.ANIMATION_SEQUENCES[i][n] - 1] != null) continue;
                            GameManager.imgClothesParts[Apearance.ANIMATION_SEQUENCES[i][n] - 1] = Image.createImage((String)("/part" + Apearance.ANIMATION_SEQUENCES[i][n] + ".png"));
                        }
                    }
                }
                catch (IOException ex) {
                    GameManager.showErrorScreen("Error: Out of memory while loading images");
                }
                LogoScreen.loadingProgress = 100;
                GameManager.current.repaint();
                GameManager.current.serviceRepaints();
                MassageSessionModus.arrowX = GameManager.current.getWidth() / 2;
                MassageSessionModus.arrowY = GameManager.current.getHeight() / 2;
                MassageSessionModus.timeLeft = 20;
                MassageSessionModus.movesCounter = 0;
                MassageSessionModus.isBreastVisible = true;
                isArcadeModeActive = true;
                MassageSessionModus.currentBreastVisible = MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[0][0]] + MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[1][0]] + MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[2][0]] + MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[3][0]] + MassageSessionModus.MASSAGE_POWERS[Apearance.ANIMATION_SEQUENCES[4][0]];
                Hint.enableShowHint(3);
                DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
                GameManager.current.startOperation(50);
                GameManager.current.startOperation(51);
                GameManager.current.repaint();
                return;
            }
            if (DialogScreen.currentFrame.type == 74) {
                playerTextSelected = Scenario.framesStates[DialogScreen.currentFrame.nextId[0]];
            } else if (DialogScreen.currentFrame.type == 86) {
                playerTextSelected = Scenario.framesStates[DialogScreen.currentFrame.id];
                if (playerTextSelected >= DialogScreen.currentFrame.selectionsCount) {
                    playerTextSelected = DialogScreen.currentFrame.selectionsCount - 1;
                }
            } else {
                playerTextSelected = 0;
            }
        }
        curentTextShownWrapped = DialogScreen.currentFrame.textPlayer;
        if (DialogScreen.currentFrame.type == 67) {
            int i;
            MassageSessionModus.currentAnimationFrame = 0;
            MassageSessionModus.currentBreastVisible = DialogScreen.currentFrame.nextId[DialogScreen.currentFrame.nextId.length - 1];
            if (GameManager.imgClothesParts == null) {
                GameManager.imgClothesParts = new Image[Apearance.CLOTHES_PARTS_POSITIONS_X.length];
            }
            boolean missingParts = false;
            for (i = 0; i < GameManager.imgClothesParts.length; ++i) {
                if ((MassageSessionModus.currentBreastVisible & MassageSessionModus.MASSAGE_POWERS[i + 1]) != MassageSessionModus.MASSAGE_POWERS[i + 1] || GameManager.imgClothesParts[i] != null) continue;
                missingParts = true;
                break;
            }
            if (missingParts) {
                DialogScreen.clearPartsMemory();
                LogoScreen.loadingProgress = 49;
                GameManager.current.repaint();
                GameManager.current.serviceRepaints();
                for (i = 0; i < GameManager.imgClothesParts.length; ++i) {
                    if ((MassageSessionModus.currentBreastVisible & MassageSessionModus.MASSAGE_POWERS[i + 1]) != MassageSessionModus.MASSAGE_POWERS[i + 1] || GameManager.imgClothesParts[i] != null) continue;
                    GameManager.imgClothesParts[i] = Lib.loadImage("/part" + (i + 1) + ".png");
                }
                LogoScreen.loadingProgress = 99;
                GameManager.current.repaint();
                GameManager.current.serviceRepaints();
                LogoScreen.loadingProgress = 100;
            }
            MassageSessionModus.isBreastVisible = true;
            DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, true);
        } else {
            DialogScreen.requestImageUpdate(DialogScreen.currentFrame.imageId, forceRepaint);
        }
        GameManager.current.repaint();
    }

    private static void clearPartsMemory() {
        if (GameManager.imgClothesParts != null) {
            for (int i = 0; i < GameManager.imgClothesParts.length; ++i) {
                GameManager.imgClothesParts[i] = null;
            }
        }
        System.gc();
        GameManager.imgClothesParts = new Image[Apearance.CLOTHES_PARTS_POSITIONS_X.length];
    }

    private static void loadClothes(int clothes) {
        int i;
        boolean missingParts = false;
        for (i = 0; i < GameManager.imgClothesParts.length; ++i) {
            if ((clothes & Lib.POWERS[i + 1]) != Lib.POWERS[i + 1] || GameManager.imgClothesParts[i] != null) continue;
            missingParts = true;
            break;
        }
        if (missingParts) {
            DialogScreen.clearPartsMemory();
            for (i = 0; i < GameManager.imgClothesParts.length; ++i) {
                if ((clothes & Lib.POWERS[i + 1]) != Lib.POWERS[i + 1] || GameManager.imgClothesParts[i] != null) continue;
                GameManager.imgClothesParts[i] = Lib.loadImage("/part" + (i + 1) + ".png");
            }
        }
    }

    private static void switchCurrentFrameTo(int nextFrameId) {
        if (DialogScreen.currentFrame.type != 65) {
            Scenario.setFramesStates(DialogScreen.currentFrame.id, playerTextSelected + 1);
        }
        if (nextFrameId == 999) {
            nextFrameId = previousFrameId;
            isArcadeDialogDiscard = true;
        }
        previousFrameId = DialogScreen.currentFrame.id;
        previousFrameImageId = DialogScreen.currentFrame.imageId;
        currentFrame = Scenario.elementAt(nextFrameId);
        if (DialogScreen.currentFrame.imageId != currentImageId) {
            currentClothesVisible = false;
        }
        if (DialogScreen.currentFrame.imageId != previousFrameImageId && DialogScreen.currentFrame.imageId != 64) {
            MassageSessionModus.isBreastVisible = false;
        }
    }

    public static void opAnimateGame() throws InterruptedException {
        System.out.println("OP_GAME started");
        stopAnimateGame = false;
        while (!stopAnimateGame) {
            if (arcadeState == 2 || arcadeState == 3) continue;
            DialogScreen.doAnimateDialog();
        }
        stopAnimateGame = false;
        System.out.println("    OP_GAME stopped");
    }

    private static void doAnimateDialog() throws InterruptedException {
        if (whosTalking == 1) {
            if ((colorDialogPlayer += colorChangeDirection) <= COLOR_DIALOG_BKG_PLAYER_DARK) {
                colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_DARK;
                colorChangeDirection = -colorChangeDirection;
            }
            if (colorDialogPlayer >= COLOR_DIALOG_BKG_PLAYER_LIGHT) {
                colorDialogPlayer = COLOR_DIALOG_BKG_PLAYER_LIGHT;
                colorChangeDirection = -colorChangeDirection;
            }
            if ((arrowDialogOffset += arrowDialogMovementDirection) < 0) {
                arrowDialogOffset = 0;
                arrowDialogMovementDirection = -arrowDialogMovementDirection;
            }
            if (arrowDialogOffset > DIALOG_ARROW_MOVEMENT_SIZE) {
                arrowDialogOffset = DIALOG_ARROW_MOVEMENT_SIZE;
                arrowDialogMovementDirection = -arrowDialogMovementDirection;
            }
            GameManager.current.repaint();
            Thread.sleep(MenuScreen.MENU_ANIMATION_BASE_INTERVAL);
        } else if (arcadeState != 2 && arcadeState != 3) {
            Thread.sleep(MenuScreen.MENU_ANIMATION_BASE_INTERVAL);
        }
    }

    public static void requestImageUpdate(int requestedImageId, boolean forceUpdate) {
        if (GameManager.imgCurrentImage == null || !GameManager.imgCurrentImage.isMutable()) {
            GameManager.imgCurrentImage = Image.createImage((int)GameManager.current.getWidth(), (int)GameManager.current.getHeight());
        }
        if (requestedImageId == 64) {
            requestedImageId = currentImageId;
        }
        if (currentImageId != requestedImageId) {
            GameManager.imgCurrentBackground = null;
            forceUpdate = true;
            System.gc();
            GameManager.imgCurrentBackground = Lib.loadImage("/" + (char)requestedImageId + ".png");
            Apearance.MAIN_IMAGE_OFFSETX = GameManager.current.getWidth() / 2 - GameManager.imgCurrentBackground.getWidth() / 2;
            Apearance.MAIN_IMAGE_OFFSETY = GameManager.current.getHeight() / 2 - GameManager.imgCurrentBackground.getHeight() / 2;
            currentImageId = DialogScreen.currentFrame.imageId;
        }
        Graphics g = GameManager.imgCurrentImage.getGraphics();
        if (forceUpdate) {
            int currentColor = g.getColor();
            g.setColor(Apearance.COLOR_BLACK);
            g.fillRect(0, 0, GameManager.current.getWidth(), GameManager.current.getHeight());
            g.drawImage(GameManager.imgCurrentBackground, GameManager.current.getWidth() / 2, GameManager.current.getHeight() / 2, 3);
            g.setColor(currentColor);
            if (DialogScreen.currentFrame.type == 65 || MassageSessionModus.isBreastVisible || DialogScreen.currentFrame.type == 67) {
                MassageSessionModus.drawParts(g);
            }
        }
    }

    static {
        currentFrame = null;
        previousFrameId = 0;
        whosTalking = 0;
        playerTextSelected = 0;
        curentTextShownWrapped = null;
        isArcadeModeActive = false;
        isArcadeDialogDiscard = false;
        isArcadeGameWon = false;
        arcadeState = -1;
        isImageBlured = false;
        requestedArcadeNextFrame = -1;
        boxHeight = 0;
        currentImageId = -1;
        continueFrameId = -1;
        continueInitialClothes = -1;
        stopAnimateGame = false;
        currentClothesVisible = false;
        requestedNextFrameIndex = -1;
        previousFrameImageId = -1;
        DIALOG_TEXT_INTERLINE = 0;
        DIALOG_TEXT_OFFSET = -1;
        DIALOG_BOX_ADDITIONAL_SPACE = 5;
    }
}

