/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Enemy
extends Entity {
    public static final float kEnemyDecayTime = 3.0f;
    EnemyClass mEnemyClass;
    Vector mPathNodes = new Vector();
    Vector mEffectList = new Vector();
    int mCurrentAnimationId;
    int mTargetAnimationId;
    Map mMap;
    tEffectType mAppliedEffects;
    tEnemyState mState;
    tDirection mMovementDirection;
    Effect mSlowEffect;
    float mPathProgress;
    int mTransparency;
    float mAnimTimer;
    float mDecayTimer;
    float mHealth;
    float mHealthModifier;
    float mHealthBarTimer;
    float mFlashTimer;
    int mStreamIndex;
    int mCurrentPathNode = -1;
    int mAnimFrame;
    int mDestinationTileGridIndex = -1;
    boolean mShowHealth;
    boolean mHealthBarTimerForward;
    boolean mPathNodesDirty;
    boolean mTargetAnimationLoop;
    boolean mRestartAnimation;
    boolean mIsMovementSoundPlaying;
    public boolean mIsPlayingDeathSound;
    public static final float kHealthBarHalfWidth = 12.0f;
    public static final float kHealthBarHeight = 2.0f;
    public static final float kGooColorIntensity = 0.25f;
    public static final float kGooFadeTime = 0.1f;
    public static final float kFlashSpeed = 0.2f;
    private boolean isDirectionLocked = false;

    public void set_showHealth(boolean bl) {
        this.mShowHealth = bl;
        this.mHealthBarTimerForward = true;
    }

    public boolean showHealth() {
        return this.mShowHealth;
    }

    public Enemy(EnemyClass enemyClass, Map map) {
        super(enemyClass);
        this.mMap = map;
        this.mPathProgress = 0.0f;
        this.mAnimFrame = 0;
        this.mAnimTimer = 0.0f;
        this.mDecayTimer = 3.0f;
        this.mFlashTimer = 0.2f;
        this.mStreamIndex = -1;
        this.mEnemyClass = enemyClass;
        this.mSlowEffect = null;
        this.mTargetAnimationId = 99;
        this.mCurrentAnimationId = 99;
        this.mState = tEnemyState.kEnemyState_Move;
        this.mAppliedEffects = tEffectType.kEffectType_None;
        this.mShowHealth = false;
        this.mHealthBarTimer = 0.0f;
        this.mHealthModifier = 1.0f;
        this.mHealthBarTimerForward = true;
        this.mTargetAnimationLoop = true;
        this.mRestartAnimation = true;
        this.mTransparency = 255;
        this.mPathNodesDirty = false;
        this.mHealth = enemyClass.mMaxHealth;
        this.mMovementDirection = tDirection.kDirection_East;
        this.mIsMovementSoundPlaying = false;
        this.mIsPlayingDeathSound = false;
        this.mType = kEnemyType;
    }

    public void applyHealthModifier(float f) {
        this.mHealth *= f;
        this.mHealthModifier = f;
    }

    public boolean playAnimation(MapGraphics mapGraphics, int n, float f, boolean bl) {
        if (this.mTargetAnimationId == 99) {
            return true;
        }
        int n2 = this.mAnimationController.getFrameCountForAnimationWithId(this.mTargetAnimationId);
        if (n2 == 0 && this.mState == tEnemyState.kEnemyState_Death) {
            this.mTargetAnimationId = 5;
            n2 = this.mAnimationController.getFrameCountForAnimationWithId(this.mTargetAnimationId);
        }
        Animation animation = this.mAnimationController.getAnimationForAnimationWithId(this.mTargetAnimationId);
        this.mAnimTimer += f;
        if (animation != null) {
            while (this.mAnimTimer >= animation.mInterval) {
                this.mAnimTimer -= animation.mInterval;
                ++this.mAnimFrame;
            }
        }
        int n3 = 0;
        if (this.mEnemyClass.mMirrorHorizontal && this.mMovementDirection == tDirection.kDirection_West) {
            n3 = 1;
        }
        if (this.mCurrentAnimationId != n) {
            this.mCurrentAnimationId = n;
            if (this.mRestartAnimation) {
                this.mAnimTimer = 0.0f;
                this.mAnimFrame = 0;
            } else {
                this.mRestartAnimation = true;
            }
        }
        boolean bl2 = false;
        if (bl) {
            this.mAnimFrame %= n2;
            if (this.mAnimFrame >= n2) {
                this.mAnimFrame = 0;
            }
        } else if (this.mAnimFrame >= n2) {
            this.mAnimFrame = n2 - 1;
            bl2 = true;
        }
        this.mAnimationController.renderWithAnimation(mapGraphics, this.mTargetAnimationId, this.mAnimFrame, null, this.mX, this.mY, 0.0f, 1.0f, true, n3);
        return bl2;
    }

    public void renderHealthBarWithElapsedTime(MapGraphics mapGraphics, float f) {
        int n;
        if (this.mHealthBarTimerForward) {
            this.mHealthBarTimer += f;
            if (this.mHealthBarTimer > 1.0f) {
                this.mHealthBarTimerForward = false;
            }
        } else {
            this.mHealthBarTimer -= f;
            if (this.mHealthBarTimer < 0.0f) {
                this.mHealthBarTimer = 0.0f;
                this.mHealthBarTimerForward = true;
                this.mShowHealth = false;
            }
        }
        if (!this.mShowHealth) {
            return;
        }
        float f2 = 1.0f - this.mHealth / (this.mEnemyClass.mMaxHealth * this.mHealthModifier);
        int n2 = n = 20;
        mapGraphics.setColor(255, 0, 0);
        mapGraphics.fillRect((int)(this.mX - 8.0f), (int)(this.mY - 30.0f), n, 2);
        if (this.mEnemyClass.mMaxHealth != this.mHealth) {
            n2 = (int)(f2 * (float)n2);
        }
        mapGraphics.setColor(0, 255, 0);
        mapGraphics.fillRect((int)(this.mX - 8.0f), (int)(this.mY - 30.0f), n - n2, 2);
    }

    public void renderWithElapsedTime(MapGraphics mapGraphics, float f) {
        if (!this.mEnemyClass.mSlowImmunity && this.mAppliedEffects == tEffectType.kEffectType_Slow && this.mState != tEnemyState.kEnemyState_Death) {
            ProjectileTechLevel projectileTechLevel = this.mSlowEffect.mProjectileClass.getProjectileTechLevel(this.mSlowEffect.mTowerTechLevelIndex);
            f *= 1.0f - projectileTechLevel.mEffectIntensity;
        }
        this.playAnimation(mapGraphics, this.mTargetAnimationId, f, this.mTargetAnimationLoop);
        if (this.mShowHealth && this.mHealth > 0.0f) {
            this.renderHealthBarWithElapsedTime(mapGraphics, f);
        }
    }

    public void serializeWithBinaryFile(GameState gameState) {
        super.serializeWithBinaryFile(gameState);
        this.mState = tEnemyState.fromInt(gameState.SERIALIZE(this.mState.toInt()));
        this.mMovementDirection = tDirection.fromInt(gameState.SERIALIZE(this.mMovementDirection.toInt()));
        this.mPathProgress = gameState.SERIALIZE(this.mPathProgress);
        this.mTransparency = gameState.SERIALIZE(this.mTransparency);
        this.mAnimTimer = gameState.SERIALIZE(this.mAnimTimer);
        this.mDecayTimer = gameState.SERIALIZE(this.mDecayTimer);
        this.mHealth = gameState.SERIALIZE(this.mHealth);
        this.mHealthModifier = gameState.SERIALIZE(this.mHealthModifier);
        this.mHealthBarTimer = gameState.SERIALIZE(this.mHealthBarTimer);
        this.mFlashTimer = gameState.SERIALIZE(this.mFlashTimer);
        this.mCurrentPathNode = gameState.SERIALIZE(this.mCurrentPathNode);
        this.mAnimFrame = gameState.SERIALIZE(this.mAnimFrame);
        this.mDestinationTileGridIndex = gameState.SERIALIZE(this.mDestinationTileGridIndex);
        this.mShowHealth = gameState.SERIALIZE(this.mShowHealth);
        this.mHealthBarTimerForward = gameState.SERIALIZE(this.mHealthBarTimerForward);
        this.mPathNodesDirty = gameState.SERIALIZE(this.mPathNodesDirty);
        this.mTargetAnimationLoop = gameState.SERIALIZE(this.mTargetAnimationLoop);
        this.mStreamIndex = gameState.SERIALIZE(this.mStreamIndex);
        int n = this.mEffectList.size();
        n = gameState.SERIALIZE(n);
        if (gameState.isLoading()) {
            for (int i = 0; i < n; ++i) {
                Effect effect = new Effect();
                effect.serializeWithBinaryFile(gameState);
                effect.mProjectileClass = (ProjectileClass)Map.getProjectileClassList().elementAt(effect.mProjectileClassIndex);
                this.mEffectList.addElement(effect);
                effect = null;
            }
            this.mRestartAnimation = false;
        } else {
            for (int i = 0; i < this.mEffectList.size(); ++i) {
                Effect effect = (Effect)this.mEffectList.elementAt(i);
                effect.serializeWithBinaryFile(gameState);
            }
        }
    }

    public boolean updateGoalStateWithElapsedTime(float f) {
        return true;
    }

    public boolean predictPositionInElapsedTime(float f, CGPoint cGPoint) {
        if (this.mHealth > 0.0f) {
            int n = this.mCurrentPathNode;
            if (this.mCurrentPathNode >= 0 && this.mCurrentPathNode < this.mPathNodes.size()) {
                float f2 = 1.0f;
                if (this.mSlowEffect != null) {
                    ProjectileTechLevel projectileTechLevel = this.mSlowEffect.mProjectileClass.getProjectileTechLevel(this.mSlowEffect.mTowerTechLevelIndex);
                    f2 = 1.0f - projectileTechLevel.mEffectIntensity;
                }
                float f3 = this.mPathProgress + f * this.mEnemyClass.mSpeed * f2;
                while ((double)f3 > 1.0) {
                    f3 -= 1.0f;
                    --n;
                }
                if (n <= 0) {
                    return false;
                }
                Point point = (Point)this.mPathNodes.elementAt(n);
                cGPoint.x = (float)(point.x * this.mMap.mTileWidth) + (float)this.mMap.mTileWidth * 0.5f + (float)this.mMap.mOffsetX;
                cGPoint.y = (float)(point.y * this.mMap.mTileHeight) + (float)this.mMap.mTileHeight * 0.5f + (float)this.mMap.mOffsetY;
                if (n - 1 >= 0) {
                    Point point2 = (Point)this.mPathNodes.elementAt(n - 1);
                    int n2 = this.mMap.getTileGridIndexForTilePos(point2.x, point2.y);
                    Point point3 = this.mMap.getTilePosFromTileGridIndex(n2);
                    cGPoint.x += (float)((point3.x - point.x) * this.mMap.mTileWidth) * f3;
                    cGPoint.y += (float)((point3.y - point.y) * this.mMap.mTileHeight) * f3;
                }
            }
        } else {
            cGPoint.x = this.mX;
            cGPoint.y = this.mY;
            return false;
        }
        return true;
    }

    public void updateMoveStateWithElapsedTime(float f) {
        float f2 = this.mX;
        float f3 = this.mY;
        if (this.mHealth > 0.0f) {
            if (this.mCurrentPathNode >= 0 && this.mCurrentPathNode < this.mPathNodes.size()) {
                Point point;
                boolean bl = false;
                if (this.mPathNodesDirty) {
                    if (this.mCurrentPathNode > this.mPathNodes.size() - 1) {
                        this.mCurrentPathNode = this.mPathNodes.size() - 1;
                    }
                    if (this.mCurrentPathNode - 1 >= 0) {
                        point = (Point)this.mPathNodes.elementAt(this.mCurrentPathNode - 1);
                        int n = this.mMap.getTileGridIndexForTilePos(point.x, point.y);
                        if (n != this.mDestinationTileGridIndex) {
                            bl = true;
                        } else {
                            this.mPathNodesDirty = false;
                        }
                    }
                }
                this.mPathProgress += !bl ? f * this.mEnemyClass.mSpeed : -f * this.mEnemyClass.mSpeed;
                if (this.mPathProgress < 0.0f && this.mEnemyClass.mType != tEnemyType.kEnemyType_Air) {
                    bl = false;
                    this.mPathProgress = -this.mPathProgress;
                    this.mPathNodesDirty = false;
                }
                while ((double)this.mPathProgress > 1.0) {
                    this.mPathProgress = (float)((double)this.mPathProgress - 1.0);
                    --this.mCurrentPathNode;
                }
                if (this.mCurrentPathNode <= 0) {
                    this.mCurrentPathNode = 0;
                    this.mState = tEnemyState.kEnemyState_Goal;
                    this.mHealth = 0.0f;
                    this.mMap.notifyEnemyHasEscaped(this);
                    this.mIsMovementSoundPlaying = false;
                } else {
                    Point point2 = (Point)this.mPathNodes.elementAt(this.mCurrentPathNode);
                    this.mTileGridIndex = this.mMap.getTileGridIndexForTilePos(point2.x, point2.y);
                    this.mX = point2.x * this.mMap.mTileWidth + (this.mMap.mTileWidth >> 1) + this.mMap.mOffsetX;
                    this.mY = point2.y * this.mMap.mTileHeight + (this.mMap.mTileHeight >> 1) + this.mMap.mOffsetY;
                    if (this.mCurrentPathNode - 1 >= 0) {
                        int n;
                        int n2;
                        if (!this.mPathNodesDirty) {
                            point = (Point)this.mPathNodes.elementAt(this.mCurrentPathNode - 1);
                            this.mDestinationTileGridIndex = this.mMap.getTileGridIndexForTilePos(point.x, point.y);
                            n2 = point.x;
                            n = point.y;
                        } else {
                            Point point3 = this.mMap.getTilePosFromTileGridIndex(this.mDestinationTileGridIndex);
                            n2 = point3.x;
                            n = point3.y;
                        }
                        float f4 = (float)((n2 - point2.x) * this.mMap.mTileWidth) * this.mPathProgress;
                        float f5 = (float)((n - point2.y) * this.mMap.mTileHeight) * this.mPathProgress;
                        if (this.isDirectionLocked) {
                            if (this.mTargetAnimationId == 1) {
                                this.mX = f4 > 0.0f ? (this.mX += f4) : (this.mX += -f4);
                            } else if (this.mTargetAnimationId == 2) {
                                this.mY = f5 > 0.0f ? (this.mY += f5) : (this.mY += -f5);
                            }
                        } else {
                            this.mX += f4;
                            this.mY += f5;
                        }
                        if (!this.isDirectionLocked) {
                            this.mMovementDirection = n2 > point2.x ? (!bl ? tDirection.kDirection_East : tDirection.kDirection_West) : (n2 < point2.x ? (!bl ? tDirection.kDirection_West : tDirection.kDirection_East) : (n > point2.y ? (!bl ? tDirection.kDirection_South : tDirection.kDirection_North) : (!bl ? tDirection.kDirection_North : tDirection.kDirection_South)));
                        }
                    }
                }
            }
        } else {
            this.mState = tEnemyState.kEnemyState_Death;
            this.mMap.notifyEnemyHasBeenKilled(this);
            if (this.mIsMovementSoundPlaying) {
                this.mIsMovementSoundPlaying = false;
            }
            this.mMap.mPlayer.mResources = Can.MULTIPLY_PAYOUT_BY_5 ? (this.mMap.mPlayer.mResources += this.mEnemyClass.mResources * 5) : (this.mMap.mPlayer.mResources += this.mEnemyClass.mResources);
            this.mMap.addScore(this.mEnemyClass.mScore);
        }
        if (!this.isDirectionLocked) {
            if (tDirection.kDirection_North.toInt() == this.mMovementDirection.toInt()) {
                this.mTargetAnimationId = 0;
            } else if (tDirection.kDirection_East.toInt() == this.mMovementDirection.toInt()) {
                this.mTargetAnimationId = 1;
            } else if (tDirection.kDirection_South.toInt() == this.mMovementDirection.toInt()) {
                this.mTargetAnimationId = 2;
            } else if (tDirection.kDirection_West.toInt() == this.mMovementDirection.toInt()) {
                this.mTargetAnimationId = this.mEnemyClass.mMirrorHorizontal ? 1 : 3;
            }
        } else if (this.mEnemyClass.mType == tEnemyType.kEnemyType_Air) {
            if (this.mTargetAnimationId == 1) {
                this.mY = f3;
            } else if (this.mTargetAnimationId == 2) {
                this.mX = f2;
            }
        }
        if (this.mEnemyClass.mType == tEnemyType.kEnemyType_Air) {
            this.isDirectionLocked = true;
        }
    }

    public boolean updateWithElapsedTime(float f) {
        boolean bl = false;
        if (f < 0.001f && this.mTargetAnimationId != 99) {
            return bl;
        }
        float f2 = f;
        this.mAppliedEffects = tEffectType.kEffectType_None;
        for (int i = this.mEffectList.size() - 1; i >= 0; --i) {
            Effect effect = (Effect)this.mEffectList.elementAt(i);
            effect.mTimeRemaining -= f;
            if (effect.mProjectileClass.mEffectType == tEffectType.kEffectType_Slow) {
                this.mSlowEffect = effect;
                ProjectileTechLevel projectileTechLevel = effect.mProjectileClass.getProjectileTechLevel(effect.mTowerTechLevelIndex);
                f2 *= 1.0f - projectileTechLevel.mEffectIntensity;
                this.mAppliedEffects = tEffectType.kEffectType_Slow;
            } else if (effect.mProjectileClass.mEffectType == tEffectType.kEffectType_Flash) {
                this.mFlashTimer -= f;
                while (this.mFlashTimer < 0.0f) {
                    this.mFlashTimer += 0.2f;
                }
            }
            if (!(effect.mTimeRemaining <= 0.0f)) continue;
            if (effect.mProjectileClass.mEffectType == tEffectType.kEffectType_Slow) {
                this.mSlowEffect = null;
                this.mAppliedEffects = tEffectType.kEffectType_None;
            }
            this.mEffectList.removeElement(effect);
        }
        if (this.mState == tEnemyState.kEnemyState_Move) {
            this.updateMoveStateWithElapsedTime(f2);
        } else if (this.mState == tEnemyState.kEnemyState_Death) {
            bl = this.updateDeathStateWithElapsedTime(f2);
        } else if (this.mState == tEnemyState.kEnemyState_Goal) {
            bl = this.updateGoalStateWithElapsedTime(f2);
        }
        return bl;
    }

    boolean updateDeathStateWithElapsedTime(float f) {
        int n;
        this.mTargetAnimationLoop = false;
        if (this.mMovementDirection == tDirection.kDirection_North) {
            this.mTargetAnimationId = 4;
        } else if (this.mMovementDirection == tDirection.kDirection_East) {
            this.mTargetAnimationId = 5;
        } else if (this.mMovementDirection == tDirection.kDirection_South) {
            this.mTargetAnimationId = 6;
        } else if (this.mMovementDirection == tDirection.kDirection_West) {
            int n2 = this.mTargetAnimationId = this.mEnemyClass.mMirrorHorizontal ? 5 : 7;
        }
        if (this.mCurrentAnimationId != this.mTargetAnimationId && !this.mAnimationController.DoesAnimationExist(this.mTargetAnimationId)) {
            this.mTargetAnimationId = 5;
        }
        if ((n = this.mAnimationController.getFrameCountForAnimationWithId(this.mTargetAnimationId)) == 0) {
            this.mTargetAnimationId = 5;
            n = this.mAnimationController.getFrameCountForAnimationWithId(this.mTargetAnimationId);
        }
        if (this.mAnimFrame == n - 1) {
            this.mDecayTimer -= f;
            if (this.mDecayTimer < 1.0f) {
                this.mDecayTimer = Math.max(this.mDecayTimer, 0.0f);
                this.mTransparency = (int)(this.mDecayTimer * 255.0f);
            }
        }
        if (this.mAnimFrame >= n / 2 && this.mEnemyClass.mType != tEnemyType.kEnemyType_Air) {
            this.mRenderFirst = true;
        }
        return this.mDecayTimer <= 0.0f;
    }
}

