/*
 * Decompiled with CFR 0.152.
 */
public class MathUtilities {
    public static final float kPrecisionErrorCorrection = 0.001f;
    public static final float kPI = (float)Math.PI;
    public static final float kPISQR = (float)(Math.PI * Math.PI);
    public static final float kTwoPI = 6.28f;
    public static final float kHalfPI = 1.5707964f;
    public static final float kPIOver180 = (float)Math.PI / 180;
    public static final float k180OverPI = 57.29578f;

    public static float SQUARE(float f) {
        return f * f;
    }

    public static boolean IS_ZERO(float f) {
        return f >= -0.001f && f <= 0.001f;
    }

    public static float fastSin(float f) {
        float f2 = 1.2732395f * f + -0.40528473f * f * Math.abs(f);
        f2 = 0.225f * (f2 * Math.abs(f2) - f2) + f2;
        return f2;
    }

    public static int simpleDistanceSquared(int n, int n2, int n3, int n4) {
        return (n - n3) * (n - n3) + (n2 - n4) * (n2 - n4);
    }

    public static float normalizeAngle(float f, float f2, float f3) {
        while (f >= f3) {
            f -= f3;
        }
        while (f < f2) {
            f += f3;
        }
        return f;
    }

    public static boolean NOT_EQUAL(float f, float f2) {
        return !MathUtilities.IS_ZERO(f - f2);
    }

    public static boolean NOT_ZERO(float f) {
        return f < -0.001f || f > 0.001f;
    }

    public static boolean IS_GREATER_THAN(float f, float f2) {
        return f > f2 - 0.001f;
    }

    public static boolean IS_LESS_THAN(float f, float f2) {
        return f < f2 + 0.001f;
    }

    public static boolean IS_EQUAL(float f, float f2) {
        return MathUtilities.IS_ZERO(f - f2);
    }

    public static float RADIANS_TO_DEGREES(float f) {
        return f * 57.29578f;
    }

    public static float DEGREES_TO_RADIANS(float f) {
        return f * ((float)Math.PI / 180);
    }

    static float Sqrt(float f) {
        float f2 = 0.0f;
        f2 = f < 0.0f ? 1.0f / MathUtilities.InvSqrt(f) : (float)Math.sqrt(f);
        return f2;
    }

    static float InvSqrt(float f) {
        float f2 = 0.5f * f;
        int n = Float.floatToIntBits(f);
        n = 1597463007 - (n >> 1);
        f = Float.intBitsToFloat(n);
        f *= 1.5f - f2 * f * f;
        return f;
    }
}

