/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ParticleSystem {
    public static final int kMaxParticlesBatchSize = 2000;
    float[] mParticleVertexPositions = new float[24000];
    float[] mParticleTexCoords = new float[24000];
    int[] mParticleColors = new int[48000];
    Vector mParticleList = new Vector();
    tBlendState mBlendState;
    String mName;
    float mEmissionInterval;
    float mLifetime;
    float mLifetimeVariance;
    float mVelocity = 0.0f;
    float mSpread;
    float mGrowthRate;
    float mScale;
    float mMinInitialOrientationAngle;
    float mMaxInitialOrientationAngle;
    long mTextureID;
    long mAlphaAdditiveTextureID;
    int mParticleCount = 0;
    int mTextureWidth;
    int mTextureHeight;

    public ParticleSystem(String string) {
        this.initParticleRenderData();
        this.loadFromFile(string);
    }

    public void clearAllParticles() {
        this.mParticleCount = 0;
    }

    public void initParticleRenderData() {
        try {
            for (int i = 1999; i >= 0; --i) {
                int n = i * 12;
                int n2 = i * 24;
                this.mParticleTexCoords[n + 0] = 0.0f;
                this.mParticleTexCoords[n + 1] = 0.0f;
                this.mParticleColors[n2 + 0] = 255;
                this.mParticleColors[n2 + 1] = 255;
                this.mParticleColors[n2 + 2] = 255;
                this.mParticleTexCoords[n + 2] = 1.0f;
                this.mParticleTexCoords[n + 3] = 0.0f;
                this.mParticleColors[n2 + 4] = 255;
                this.mParticleColors[n2 + 5] = 255;
                this.mParticleColors[n2 + 6] = 255;
                this.mParticleTexCoords[n + 4] = 0.0f;
                this.mParticleTexCoords[n + 5] = 1.0f;
                this.mParticleColors[n2 + 8] = 255;
                this.mParticleColors[n2 + 9] = 255;
                this.mParticleColors[n2 + 10] = 255;
                this.mParticleTexCoords[n + 6] = 1.0f;
                this.mParticleTexCoords[n + 7] = 0.0f;
                this.mParticleColors[n2 + 12] = 255;
                this.mParticleColors[n2 + 13] = 255;
                this.mParticleColors[n2 + 14] = 255;
                this.mParticleTexCoords[n + 8] = 1.0f;
                this.mParticleTexCoords[n + 9] = 1.0f;
                this.mParticleColors[n2 + 16] = 255;
                this.mParticleColors[n2 + 17] = 255;
                this.mParticleColors[n2 + 18] = 255;
                this.mParticleTexCoords[n + 10] = 0.0f;
                this.mParticleTexCoords[n + 11] = 1.0f;
                this.mParticleColors[n2 + 20] = 255;
                this.mParticleColors[n2 + 21] = 255;
                this.mParticleColors[n2 + 22] = 255;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadFromFile(String string) {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        KXmlParser kXmlParser = new KXmlParser();
        try {
            kXmlParser.setInput(inputStream, null);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        try {
            kXmlParser.nextTag();
            this.mName = kXmlParser.getName();
            this.mBlendState = tBlendState.kBlendState_Alpha;
            this.mLifetime = 0.0f;
            this.mLifetimeVariance = 0.0f;
            this.mSpread = 0.0f;
            this.mVelocity = 0.0f;
            this.mGrowthRate = 0.0f;
            this.mScale = 1.0f;
            this.mEmissionInterval = 0.0f;
            this.mTextureID = 0L;
            this.mAlphaAdditiveTextureID = 0L;
            this.mMinInitialOrientationAngle = 0.0f;
            this.mMaxInitialOrientationAngle = 360.0f;
            String string2 = null;
            int n = kXmlParser.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String string3 = kXmlParser.getAttributeName(i);
                String string4 = kXmlParser.getAttributeValue(i);
                if (string3.compareTo("image") == 0) continue;
                if (string3.compareTo("alphaAdditiveImage") == 0) {
                    string2 = string4;
                    continue;
                }
                if (string3.compareTo("lifetime") == 0) {
                    this.mLifetime = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("lifetimeVariance") == 0) {
                    this.mLifetimeVariance = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("spread") == 0) {
                    this.mSpread = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("velocity") == 0) {
                    this.mVelocity = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("growthRate") == 0) {
                    this.mGrowthRate = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("scale") == 0) {
                    this.mScale = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("minInitialOrientation") == 0) {
                    this.mMinInitialOrientationAngle = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("maxInitialOrientation") == 0) {
                    this.mMaxInitialOrientationAngle = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("emissionRate") == 0) {
                    this.mEmissionInterval = Float.parseFloat(string4);
                    continue;
                }
                if (string3.compareTo("blendingMode") != 0) continue;
                if (string4.compareTo("none") == 0) {
                    this.mBlendState = tBlendState.kBlendState_None;
                    continue;
                }
                if (string4.compareTo("overwrite") == 0) {
                    this.mBlendState = tBlendState.kBlendState_Overwrite;
                    continue;
                }
                if (string4.compareTo("alpha") == 0) {
                    this.mBlendState = tBlendState.kBlendState_Alpha;
                    continue;
                }
                if (string4.compareTo("multiply") == 0) {
                    this.mBlendState = tBlendState.kBlendState_Multiply;
                    continue;
                }
                if (string4.compareTo("add") == 0) {
                    this.mBlendState = tBlendState.kBlendState_Add;
                    continue;
                }
                if (string4.compareTo("alphaAdditive") == 0) {
                    this.mBlendState = tBlendState.kBlendState_AlphaAdd;
                    continue;
                }
                if (string4.compareTo("count") != 0) continue;
                this.mBlendState = tBlendState.kBlendState_Count;
            }
            this.mEmissionInterval = this.mEmissionInterval > 0.0f ? 1.0f / this.mEmissionInterval : 0.0f;
            this.mSpread = (float)Math.toRadians(this.mSpread * 0.5f);
            this.mMinInitialOrientationAngle = (float)Math.toRadians(this.mMinInitialOrientationAngle);
            this.mMaxInitialOrientationAngle = (float)Math.toRadians(this.mMaxInitialOrientationAngle);
            if (string2 == null) {
                // empty if block
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        kXmlParser = null;
        System.gc();
        return true;
    }

    public void renderWithElapsedTime(Graphics graphics, float f) {
        if (this.mParticleCount == 0) {
            return;
        }
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        for (int i = this.mParticleCount - 1; i >= 0; --i) {
            Particle particle = (Particle)this.mParticleList.elementAt(i);
            int n = i * 12;
            int n2 = i * 24;
            fArray[0] = -0.5f * particle.mScale;
            fArray2[0] = -0.5f * particle.mScale;
            fArray[1] = 0.5f * particle.mScale;
            fArray2[2] = 0.5f * particle.mScale;
            fArray[2] = fArray[0];
            fArray[3] = fArray[1];
            fArray2[1] = fArray2[0];
            fArray2[3] = fArray2[2];
            float f2 = (float)Math.cos(particle.mAngle);
            float f3 = (float)Math.sin(particle.mAngle);
            int n3 = 0;
            while (n3 < 4) {
                float f4 = fArray[n3];
                fArray[n3] = f2 * fArray[n3] - f3 * fArray2[n3];
                fArray2[n3] = f3 * f4 + f2 * fArray2[n3];
                int n4 = n3;
                fArray[n4] = fArray[n4] + particle.mX;
                int n5 = n3++;
                fArray2[n5] = fArray2[n5] + particle.mY;
            }
            this.mParticleVertexPositions[n + 0] = fArray[0];
            this.mParticleVertexPositions[n + 1] = fArray2[0];
            this.mParticleColors[n2 + 3] = (int)(255.0f * particle.mOpacity);
            this.mParticleVertexPositions[n + 2] = fArray[1];
            this.mParticleVertexPositions[n + 3] = fArray2[1];
            this.mParticleColors[n2 + 7] = (int)(255.0f * particle.mOpacity);
            this.mParticleVertexPositions[n + 4] = fArray[2];
            this.mParticleVertexPositions[n + 5] = fArray2[2];
            this.mParticleColors[n2 + 11] = (int)(255.0f * particle.mOpacity);
            this.mParticleVertexPositions[n + 6] = fArray[1];
            this.mParticleVertexPositions[n + 7] = fArray2[1];
            this.mParticleColors[n2 + 15] = (int)(255.0f * particle.mOpacity);
            this.mParticleVertexPositions[n + 8] = fArray[3];
            this.mParticleVertexPositions[n + 9] = fArray2[3];
            this.mParticleColors[n2 + 19] = (int)(255.0f * particle.mOpacity);
            this.mParticleVertexPositions[n + 10] = fArray[2];
            this.mParticleVertexPositions[n + 11] = fArray2[2];
            this.mParticleColors[n2 + 23] = (int)(255.0f * particle.mOpacity);
        }
        if (this.mAlphaAdditiveTextureID > 0L) {
            // empty if block
        }
    }

    public Particle spawnParticleAtPos(float f, float f2) {
        if (this.mParticleCount + 1 >= 2000) {
            return null;
        }
        Particle particle = (Particle)this.mParticleList.elementAt(this.mParticleCount);
        particle.mX = f;
        particle.mY = f2;
        particle.mVelocityX = this.mVelocity;
        particle.mVelocityY = this.mVelocity;
        particle.mScale = 0.0f;
        particle.mOpacity = 0.0f;
        particle.mAngle = RandomUtilities.RANDOM_FLOAT_IN_RANGE(Math.min(this.mMinInitialOrientationAngle, this.mMaxInitialOrientationAngle), Math.max(this.mMinInitialOrientationAngle, this.mMaxInitialOrientationAngle));
        particle.mAge = 0.0f;
        particle.mLifetime = this.mLifetime + RandomUtilities.RANDOM_FLOAT_IN_RANGE(-this.mLifetimeVariance * 0.5f, this.mLifetimeVariance);
        ++this.mParticleCount;
        return particle;
    }

    public Particle spawnParticleAtPos(float f, float f2, float f3) {
        Particle particle = this.spawnParticleAtPos(f, f2);
        float f4 = RandomUtilities.RANDOM_FLOAT_IN_RANGE(-this.mSpread, this.mSpread);
        Vector2f vector2f = new Vector2f();
        vector2f = vector2f.initWithOrientationAxis();
        vector2f.scaleBy(this.mVelocity);
        vector2f.rotateBY(f3 + f4);
        particle.mVelocityX = vector2f.x;
        particle.mVelocityY = vector2f.y;
        return particle;
    }

    public void updateWithElapsedTime(float f) {
        for (int i = this.mParticleCount - 1; i >= 0; --i) {
            Particle particle;
            Particle particle2 = (Particle)this.mParticleList.elementAt(i);
            particle2.mX += particle2.mVelocityX * f;
            particle2.mY += particle2.mVelocityY * f;
            particle2.mAge += f;
            particle2.mOpacity = particle2.mAge < particle2.mLifetime * 0.5f ? Math.min(particle2.mAge / (particle2.mLifetime * 0.05f), 1.0f) : 2.0f - particle2.mAge / (particle2.mLifetime * 0.5f);
            if (!(particle2.mAge > particle2.mLifetime)) continue;
            if (this.mParticleCount > 1 && (particle = (Particle)this.mParticleList.lastElement()) != particle2) {
                particle2 = particle;
            }
            --this.mParticleCount;
        }
    }
}

