/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class ProjectileClass
extends EntityClass {
    int mType;
    tEffectType mEffectType = tEffectType.kEffectType_None;
    Vector mTechLevels;
    String mName;
    float mParabolicScale = 0.0f;
    float mParabolicHeight = 0.0f;
    float mMinRotationSpeed = 0.0f;
    float mMaxRotationSpeed = 0.0f;
    float mTimeToImpact = 0.0f;
    float mMaxSpeed;
    float mAcceleration = 0.0f;
    float mDisplayTime = -1.0f;
    float mEffectDuration = Float.MAX_VALUE;
    int mTextureID;

    public ProjectileClass(String string) {
        this.mTechLevels = new Vector();
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        KXmlParser kXmlParser = new KXmlParser();
        try {
            kXmlParser.setInput(inputStream, null);
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        try {
            Object object;
            int n;
            kXmlParser.nextTag();
            this.mName = kXmlParser.getName();
            String string2 = null;
            String string3 = null;
            int n2 = kXmlParser.getAttributeCount();
            for (n = 0; n < n2; ++n) {
                object = kXmlParser.getAttributeName(n);
                String string4 = kXmlParser.getAttributeValue(n);
                if (((String)object).compareTo("sprite") == 0) {
                    string3 = string4;
                    continue;
                }
                if (((String)object).compareTo("image") == 0) {
                    string2 = string4;
                    continue;
                }
                if (((String)object).compareTo("type") == 0) {
                    if (string4.compareTo("beam") == 0) {
                        this.mType = 1;
                        continue;
                    }
                    if (string4.compareTo("parabolic") == 0) {
                        this.mType = 2;
                        continue;
                    }
                    if (string4.compareTo("spray") == 0) {
                        this.mType = 3;
                        continue;
                    }
                    this.mType = 0;
                    continue;
                }
                if (((String)object).compareTo("effect") == 0) {
                    if (string4.compareTo("slow") == 0) {
                        this.mEffectType = tEffectType.kEffectType_Slow;
                        continue;
                    }
                    if (string4.compareTo("flash") == 0) {
                        this.mEffectType = tEffectType.kEffectType_Flash;
                        continue;
                    }
                    this.mEffectType = tEffectType.kEffectType_None;
                    continue;
                }
                if (((String)object).compareTo("impactSound") == 0 || ((String)object).startsWith("impactSound") && ((String)object).endsWith("Volume") || ((String)object).startsWith("impactSound") && ((String)object).endsWith("PitchVariance") || ((String)object).startsWith("impactSound") && ((String)object).endsWith("VolumeVariance") || ((String)object).compareTo("launchSound") == 0 || ((String)object).startsWith("launchSound") && ((String)object).endsWith("Volume") || ((String)object).startsWith("launchSound") && ((String)object).endsWith("PitchVariance") || ((String)object).startsWith("launchSound") && ((String)object).endsWith("VolumeVariance")) continue;
                if (((String)object).compareTo("effectDuration") == 0) {
                    this.mEffectDuration = Float.parseFloat(string4);
                    continue;
                }
                if (((String)object).compareTo("minRotationSpeed") == 0) {
                    this.mMinRotationSpeed = Float.parseFloat(string4);
                    continue;
                }
                if (((String)object).compareTo("maxRotationSpeed") == 0) {
                    this.mMaxRotationSpeed = Float.parseFloat(string4);
                    continue;
                }
                if (((String)object).compareTo("parabolicScale") == 0) {
                    this.mParabolicScale = Float.parseFloat(string4);
                    continue;
                }
                if (((String)object).compareTo("parabolicHeight") == 0) {
                    this.mParabolicHeight = Float.parseFloat(string4);
                    continue;
                }
                if (((String)object).compareTo("speed") == 0) {
                    this.mMaxSpeed = Float.parseFloat(string4) * Can.BASE_SIZE_FOR_ART_RESOURCES;
                    continue;
                }
                if (((String)object).compareTo("acceleration") == 0) {
                    this.mAcceleration = Float.parseFloat(string4);
                    continue;
                }
                if (((String)object).compareTo("timeToImpact") == 0) {
                    this.mTimeToImpact = Float.parseFloat(string4);
                    continue;
                }
                if (((String)object).compareTo("displayTime") != 0) continue;
                this.mDisplayTime = Float.parseFloat(string4);
            }
            kXmlParser.nextTag();
            n = kXmlParser.getEventType();
            if (kXmlParser.getName().compareTo(this.mName) != 0 || n != 3) {
                kXmlParser.nextTag();
                while (kXmlParser.getName() != "TechLevels") {
                    object = new ProjectileTechLevel();
                    ((ProjectileTechLevel)object).mEffectIntensity = 1.0f;
                    for (int i = 0; i < kXmlParser.getAttributeCount(); ++i) {
                        String string5 = kXmlParser.getAttributeName(i);
                        String string6 = kXmlParser.getAttributeValue(i);
                        if (string5.compareTo("effectIntensity") == 0) {
                            ((ProjectileTechLevel)object).mEffectIntensity = Float.parseFloat(string6);
                        }
                        if (((ProjectileTechLevel)object).mEffectIntensity <= 0.0f || ((ProjectileTechLevel)object).mEffectIntensity >= 1.0f) {
                            // empty if block
                        }
                        this.mTechLevels.addElement(object);
                    }
                    kXmlParser.nextTag();
                    kXmlParser.nextTag();
                    n = kXmlParser.getEventType();
                    if (kXmlParser.getName().compareTo("TechLevels") != 0 || n != 3) continue;
                    break;
                }
            }
            object = "/Projectiles/";
            if (string3 != null) {
                this.mSprite = new Sprite(string3, (String)object);
            } else {
                this.mTextureID = Sprite.initTextureFromFile(string2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        kXmlParser = null;
        System.gc();
    }

    public ProjectileTechLevel getProjectileTechLevel(int n) {
        return (ProjectileTechLevel)this.mTechLevels.elementAt(n);
    }
}

