/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class ScoresForm
extends Form {
    public static final String kUserNameDefaultKey = "PlayerName";
    public static final String kHighScoresDefaultKey = "HighScores";
    public static final String kScoreKey = "score";
    public static final String kRoundKey = "wave";
    public static final int kNumHighScoreRows = 6;
    public static final int kNumHighScoreEntries = 5;
    Text[] mPlayerNamesText = new Text[6];
    Text[] mScoresText = new Text[6];
    Text[] mWavesText = new Text[6];
    String mMapName;
    float mFadeTimer;
    float mHighlightTimer;
    int mNewestScoreIndex;
    boolean mHighlightNewestHighScore;
    String mTitle = "GRASSLANDS";
    int mSelectedState = 0;
    int mTitlex = 45;
    int mTitley = 20;
    private int kSelectGrasslandId = 0;
    private int kSelectCrossRoadsId = 1;
    private int kSelectDrylandsId = 2;
    public static final String kScoresFontName = "Arial";
    public static final int kScoresFontSize = 13;
    public static final float kScoresFontHeight = 0.058f;
    public static final float kScoreTextTop = 0.223f;
    public static final float kScoreFadeSpeed = 0.5f;
    public static final int kHighlightMinIntensity = 92;
    public static final int kHighlightMaxIntensity = 230;
    public static final float kHighlightFlashSpeed = 5.0f;

    public void initFromFile(String string, MapScreen mapScreen, UserInterface userInterface, String string2) {
        super.initFromFile(string, mapScreen, userInterface, string2);
        this.mMapName = "grasslands";
    }

    public void displayScoresForMapName(String string) {
        this.mFadeTimer = 0.0f;
        for (int i = 0; i < 6; ++i) {
            String string2 = null;
            string2 = i == 0 ? "Score" : Settings.GetHighScore(string, i - 1);
            if (string2 == null) break;
            this.mScoresText[i] = new Text(string2, this.mView, 0.17f, 0.058f, tTextAlignmentType.kTextAlignmentType_Center, kScoresFontName, 13);
            this.mScoresText[i].x = 0.25f;
            this.mScoresText[i].y = 0.223f + (float)i * 0.058f;
            this.mScoresText[i].mRed = 255;
            this.mScoresText[i].mGreen = 255;
            this.mScoresText[i].mBlue = 92;
            this.mScoresText[i].mAlpha = 255;
            string2 = i == 0 ? "Round" : Settings.GetHighScoreWave(string, i - 1);
            this.mWavesText[i] = new Text(string2, this.mView, 0.085f, 0.058f, tTextAlignmentType.kTextAlignmentType_Center, kScoresFontName, 13);
            this.mWavesText[i].x = 0.65f;
            this.mWavesText[i].y = 0.223f + (float)i * 0.058f;
            this.mWavesText[i].mRed = 255;
            this.mWavesText[i].mGreen = 255;
            this.mWavesText[i].mBlue = 92;
            this.mWavesText[i].mAlpha = 255;
        }
    }

    public void onButtonPressMap01(Button button, Point point) {
        this.refreshDisplayForMapWithIndex(0);
    }

    public void onButtonPressMap02(Button button, Point point) {
        this.refreshDisplayForMapWithIndex(1);
    }

    public void onButtonPressMap03(Button button, Point point) {
        this.refreshDisplayForMapWithIndex(2);
    }

    public void onButtonReleaseX(Button button, Point point) {
        this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kTitleScreenFormNameID);
    }

    public void onFormClose() {
        super.onFormClose();
        this.releaseDynamicTextAndLayoutThumbnails();
        try {
            this.mView.mMap.mGameState = tGameState.kGameState_Stopped;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onFormOpen() {
        super.onFormOpen();
        this.mView.mMap.pauseGame();
        if (this.mMapName == null) {
            this.mMapName = "grasslands";
        }
        this.displayScoresForMapName(this.mMapName);
        this.refreshDisplayForMapWithIndex(0);
    }

    public void handleButtonReleaseAction(Button button, Point point) {
        String string;
        if (button != null && (string = button.mReleaseSelector).compareTo("onButtonReleaseX:withTouches:withEvent:") == 0) {
            this.onButtonReleaseX(button, point);
        }
    }

    public void handleButtonPressAction(Button button, Point point) {
        if (button != null) {
            String string = button.mPressSelector;
            if (string.compareTo("onButtonPressMap01:withTouches:withEvent:") == 0) {
                this.onButtonPressMap01(button, point);
            } else if (string.compareTo("onButtonPressMap02:withTouches:withEvent:") == 0) {
                this.onButtonPressMap02(button, point);
            } else if (string.compareTo("onButtonPressMap03:withTouches:withEvent:") == 0) {
                this.onButtonPressMap03(button, point);
            }
        }
    }

    public void refreshDisplayForMapWithIndex(int n) {
        if (this.mMapName != null && this.mMapName.compareTo(Map.getOfficialMapNameForIndex(n)) == 0) {
            return;
        }
        this.mMapName = Map.getOfficialMapNameForIndex(n);
        this.mHighlightNewestHighScore = false;
        this.releaseDynamicTextAndLayoutThumbnails();
        this.displayScoresForMapName(this.mMapName);
    }

    public void releaseDynamicTextAndLayoutThumbnails() {
        for (int i = 0; i < 6; ++i) {
            this.mPlayerNamesText[i] = null;
            this.mScoresText[i] = null;
            this.mWavesText[i] = null;
        }
    }

    public void renderWithElapsedTime(Graphics graphics, float f) {
        graphics.setClip(0, 0, Can.VIEW_X, Can.VIEW_Y);
        super.renderWithElapsedTime(graphics, f);
        for (int i = 0; i < 6; ++i) {
            if (this.mScoresText[i] == null) continue;
            this.mScoresText[i].renderWithElapsedTime(graphics, f);
            this.mWavesText[i].renderWithElapsedTime(graphics, f);
        }
        graphics.drawImage(this.mView.mSoftLeft, this.mView.mAtL.x, this.mView.mAtL.y, 3);
        if (this.mSelectedState != this.kSelectDrylandsId) {
            graphics.drawImage(this.mView.mSoftRight, this.mView.mAtR.x, this.mView.mAtR.y, 3);
        }
        Map.mArtFont.DrawString(graphics, this.mTitle, this.mTitlex, this.mTitley);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void touchStart(Point point) {
        try {
            CGPoint cGPoint = new CGPoint(point.x, point.y);
            this.mPressedButton = null;
            cGPoint.x /= (float)this.mView.width();
            cGPoint.y /= (float)this.mView.height();
            this.mActiveButton = null;
            if (Key.mPressed == 0x200000 || Key.mPressed == 262144) {
                if (this.mSelectedState == this.kSelectGrasslandId) {
                    this.onButtonReleaseX(this.mActiveButton, point);
                    return;
                } else if (this.mSelectedState == this.kSelectCrossRoadsId) {
                    this.onButtonPressMap01(this.mActiveButton, point);
                    this.mSelectedState = this.kSelectGrasslandId;
                    this.mTitle = "GRASSLANDS";
                    return;
                } else {
                    if (this.mSelectedState != this.kSelectDrylandsId) return;
                    this.onButtonPressMap02(this.mActiveButton, point);
                    this.mSelectedState = this.kSelectCrossRoadsId;
                    this.mTitle = "CROSSROADS";
                    this.mTitlex = 45;
                }
                return;
            }
            if (Key.mPressed == 524288 || Key.mPressed == 0x400000 || Key.mPressed == 0x100000) {
                if (this.mSelectedState == this.kSelectGrasslandId) {
                    this.onButtonPressMap02(this.mActiveButton, point);
                    this.mSelectedState = this.kSelectCrossRoadsId;
                    this.mTitle = "CROSSROADS";
                    return;
                } else {
                    if (this.mSelectedState != this.kSelectCrossRoadsId) return;
                    this.onButtonPressMap03(this.mActiveButton, point);
                    this.mSelectedState = this.kSelectDrylandsId;
                    this.mTitle = "DRYLANDS";
                    this.mTitlex = 60;
                }
                return;
            }
            if (Key.mPressed != 32768) return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void touchEnd(Point point) {
        try {
            if (Key.mReleased == 0x200000) {
                for (int i = 0; i < this.mButtonList.size(); ++i) {
                    Button button = (Button)this.mButtonList.elementAt(i);
                    if (!button.mName.equals("X") || button.mIsHidden || button.mIsDisabled) continue;
                    if (button.mReleaseSelector != null && button == this.mPressedButton) {
                        this.handleButtonReleaseAction(this.mActiveButton, point);
                        button.mState = tButtonState.kButtonState_Enabled;
                        if (!button.mIsToggleable) break;
                        button.mIsToggled = !button.mIsToggled;
                        break;
                    }
                    button.mState = tButtonState.kButtonState_Enabled;
                }
            }
            this.mActiveButton = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

