/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class Settings {
    private static final String kRecordStoreName = "FR_Settings";
    public static final int kGrasslandsIndex = 0;
    public static final int kCrossroadsIndex = 1;
    public static final int kDrylandsIndex = 2;
    public static final int kGrasslands_unlocked = 1;
    public static final int kCrossroads_unlocked = 2;
    public static final int kDrylands_unlocked = 3;
    public static final int kGrasslands_FastForward = 4;
    public static final int kCrossroads_FastForward = 5;
    public static final int kDrylands_FastForward = 6;
    public static final int kGrasslands_Classic = 7;
    public static final int kCrossroads_Classic = 8;
    public static final int kDrylands_Classic = 9;
    public static final int kGrasslands_Endless = 10;
    public static final int kCrossroads_Endless = 11;
    public static final int kDrylands_Endless = 12;
    public static final int kGrasslands_Extended = 13;
    public static final int kCrossroads_Extended = 14;
    public static final int kDrylands_Extended = 15;
    public static final int kDifficultyLevel = 16;
    public static final int kGameplayMode = 17;
    public static final int kGrasslands_HighScore1_Name = 18;
    public static final int kGrasslands_HighScore1_Score = 19;
    public static final int kGrasslands_HighScore1_Round = 20;
    public static final int kGrasslands_HighScore2_Name = 21;
    public static final int kGrasslands_HighScore2_Score = 22;
    public static final int kGrasslands_HighScore2_Round = 23;
    public static final int kGrasslands_HighScore3_Name = 24;
    public static final int kGrasslands_HighScore3_Score = 25;
    public static final int kGrasslands_HighScore3_Round = 26;
    public static final int kGrasslands_HighScore4_Name = 27;
    public static final int kGrasslands_HighScore4_Score = 28;
    public static final int kGrasslands_HighScore4_Round = 29;
    public static final int kGrasslands_HighScore5_Name = 30;
    public static final int kGrasslands_HighScore5_Score = 31;
    public static final int kGrasslands_HighScore5_Round = 32;
    public static final int kGrasslands_HighScore6_Name = 33;
    public static final int kGrasslands_HighScore6_Score = 34;
    public static final int kGrasslands_HighScore6_Round = 35;
    public static final int kGrasslands_HighScore7_Name = 36;
    public static final int kGrasslands_HighScore7_Score = 37;
    public static final int kGrasslands_HighScore7_Round = 38;
    public static final int kGrasslands_HighScore8_Name = 39;
    public static final int kGrasslands_HighScore8_Score = 40;
    public static final int kGrasslands_HighScore8_Round = 41;
    public static final int kGrasslands_HighScore9_Name = 42;
    public static final int kGrasslands_HighScore9_Score = 43;
    public static final int kGrasslands_HighScore9_Round = 44;
    public static final int kGrasslands_HighScore10_Name = 45;
    public static final int kGrasslands_HighScore10_Score = 46;
    public static final int kGrasslands_HighScore10_Round = 47;
    public static final int kCrossroads_HighScore1_Name = 48;
    public static final int kCrossroads_HighScore1_Score = 49;
    public static final int kCrossroads_HighScore1_Round = 50;
    public static final int kCrossroads_HighScore2_Name = 51;
    public static final int kCrossroads_HighScore2_Score = 52;
    public static final int kCrossroads_HighScore2_Round = 53;
    public static final int kCrossroads_HighScore3_Name = 54;
    public static final int kCrossroads_HighScore3_Score = 55;
    public static final int kCrossroads_HighScore3_Round = 56;
    public static final int kCrossroads_HighScore4_Name = 57;
    public static final int kCrossroads_HighScore4_Score = 58;
    public static final int kCrossroads_HighScore4_Round = 59;
    public static final int kCrossroads_HighScore5_Name = 60;
    public static final int kCrossroads_HighScore5_Score = 61;
    public static final int kCrossroads_HighScore5_Round = 62;
    public static final int kCrossroads_HighScore6_Name = 63;
    public static final int kCrossroads_HighScore6_Score = 64;
    public static final int kCrossroads_HighScore6_Round = 65;
    public static final int kCrossroads_HighScore7_Name = 66;
    public static final int kCrossroads_HighScore7_Score = 67;
    public static final int kCrossroads_HighScore7_Round = 68;
    public static final int kCrossroads_HighScore8_Name = 69;
    public static final int kCrossroads_HighScore8_Score = 70;
    public static final int kCrossroads_HighScore8_Round = 71;
    public static final int kCrossroads_HighScore9_Name = 72;
    public static final int kCrossroads_HighScore9_Score = 73;
    public static final int kCrossroads_HighScore9_Round = 74;
    public static final int kCrossroads_HighScore10_Name = 75;
    public static final int kCrossroads_HighScore10_Score = 76;
    public static final int kCrossroads_HighScore10_Round = 77;
    public static final int kDrylands_HighScore1_Name = 78;
    public static final int kDrylands_HighScore1_Score = 79;
    public static final int kDrylands_HighScore1_Round = 80;
    public static final int kDrylands_HighScore2_Name = 81;
    public static final int kDrylands_HighScore2_Score = 82;
    public static final int kDrylands_HighScore2_Round = 83;
    public static final int kDrylands_HighScore3_Name = 84;
    public static final int kDrylands_HighScore3_Score = 85;
    public static final int kDrylands_HighScore3_Round = 86;
    public static final int kDrylands_HighScore4_Name = 87;
    public static final int kDrylands_HighScore4_Score = 88;
    public static final int kDrylands_HighScore4_Round = 89;
    public static final int kDrylands_HighScore5_Name = 90;
    public static final int kDrylands_HighScore5_Score = 91;
    public static final int kDrylands_HighScore5_Round = 92;
    public static final int kDrylands_HighScore6_Name = 93;
    public static final int kDrylands_HighScore6_Score = 94;
    public static final int kDrylands_HighScore6_Round = 95;
    public static final int kDrylands_HighScore7_Name = 96;
    public static final int kDrylands_HighScore7_Score = 97;
    public static final int kDrylands_HighScore7_Round = 98;
    public static final int kDrylands_HighScore8_Name = 99;
    public static final int kDrylands_HighScore8_Score = 100;
    public static final int kDrylands_HighScore8_Round = 101;
    public static final int kDrylands_HighScore9_Name = 102;
    public static final int kDrylands_HighScore9_Score = 103;
    public static final int kDrylands_HighScore9_Round = 104;
    public static final int kDrylands_HighScore10_Name = 105;
    public static final int kDrylands_HighScore10_Score = 106;
    public static final int kDrylands_HighScore10_Round = 107;
    public static final int kSoundSetting = 108;
    private static final int kTotalSettings = 108;
    public static final int kSoundSetting_New = 0;
    public static final int kSoundSetting_On = 1;
    public static final int kSoundSetting_Off = 2;

    private static boolean SaveBoolSetting(int n, boolean bl) {
        boolean bl2 = false;
        try {
            RecordStore recordStore = Settings.GetRecordStore();
            if (recordStore != null) {
                byte[] byArray = new byte[]{(byte)(bl ? 1 : 0)};
                recordStore.setRecord(n, byArray, 0, byArray.length);
                recordStore.closeRecordStore();
                bl2 = true;
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        return bl2;
    }

    private static boolean GetBoolSetting(int n) {
        boolean bl = false;
        try {
            RecordStore recordStore = Settings.GetRecordStore();
            if (recordStore != null) {
                byte[] byArray = recordStore.getRecord(n);
                recordStore.closeRecordStore();
                if (byArray != null) {
                    bl = byArray[0] > 0;
                }
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        return bl;
    }

    private static boolean SaveIntSetting(int n, int n2) {
        boolean bl;
        block8: {
            bl = false;
            try {
                RecordStore recordStore = Settings.GetRecordStore();
                if (recordStore == null) break block8;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                try {
                    dataOutputStream.writeInt(n2);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                byte[] byArray = byteArrayOutputStream.toByteArray();
                try {
                    recordStore.setRecord(n, byArray, 0, byArray.length);
                }
                catch (RecordStoreException recordStoreException) {
                    recordStoreException.printStackTrace();
                }
                recordStore.closeRecordStore();
                bl = true;
            }
            catch (RecordStoreFullException recordStoreFullException) {
                recordStoreFullException.printStackTrace();
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                recordStoreNotFoundException.printStackTrace();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
        return bl;
    }

    private static int GetIntSetting(int n) {
        int n2 = 0;
        try {
            RecordStore recordStore = Settings.GetRecordStore();
            if (recordStore != null) {
                byte[] byArray = recordStore.getRecord(n);
                recordStore.closeRecordStore();
                if (byArray != null) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    n2 = dataInputStream.readInt();
                }
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n2;
    }

    private static RecordStore GetRecordStore() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)kRecordStoreName, (boolean)true);
            while (recordStore.getNumRecords() < 108) {
                recordStore.addRecord(null, 0, 0);
            }
        }
        catch (RecordStoreFullException recordStoreFullException) {
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        return recordStore;
    }

    private static int GetGameplayFeatureKey(tGameplayFeature tGameplayFeature2, String string) {
        int n = Map.getIndexFromOfficialMapName(string);
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 3;
            }
        }
        return 4;
    }

    private static int GetGameplayModeKey(int n, String string) {
        int n2 = Map.getIndexFromOfficialMapName(string);
        switch (n2) {
            case 0: {
                if (n == 2) {
                    return 13;
                }
                if (n == 1) {
                    return 10;
                }
                return 7;
            }
            case 1: {
                if (n == 2) {
                    return 14;
                }
                if (n == 1) {
                    return 11;
                }
                return 8;
            }
            case 2: {
                if (n == 2) {
                    return 15;
                }
                if (n == 1) {
                    return 12;
                }
                return 9;
            }
        }
        return 7;
    }

    public static boolean IsGameplayFeatureUnlocked(tGameplayFeature tGameplayFeature2, String string) {
        if (Can.UNLOCK_ALL_FEATURES) {
            return true;
        }
        return Settings.GetBoolSetting(Settings.GetGameplayFeatureKey(tGameplayFeature2, string));
    }

    public static void UnlockGameplayFeature(tGameplayFeature tGameplayFeature2, String string) {
        Settings.SaveBoolSetting(Settings.GetGameplayFeatureKey(tGameplayFeature2, string), true);
    }

    public static boolean IsGameplayModeUnlocked(int n, String string) {
        if (Can.UNLOCK_ALL_FEATURES) {
            return true;
        }
        return Settings.GetBoolSetting(Settings.GetGameplayModeKey(n, string));
    }

    public static void UnlockGameplayMode(int n, String string) {
        Settings.SaveBoolSetting(Settings.GetGameplayModeKey(n, string), true);
    }

    public static boolean IsMapUnlocked(String string) {
        if (Can.UNLOCK_ALL_FEATURES) {
            return true;
        }
        return Settings.GetBoolSetting(Map.getIndexFromOfficialMapName(string) + 1);
    }

    public static void UnlockMap(String string) {
        Settings.SaveBoolSetting(Map.getIndexFromOfficialMapName(string) + 1, true);
    }

    public static void UpdateDifficultyLevel(int n) {
        Settings.SaveIntSetting(16, n);
    }

    public static int GetDifficultyLevel() {
        int n = Settings.GetIntSetting(16);
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        return 0;
    }

    public static void SetSoundSetting(int n) {
        Settings.SaveIntSetting(108, n);
    }

    public static int GetSoundSetting() {
        int n = Settings.GetIntSetting(108);
        return n;
    }

    public static void SetGameplayMode(int n) {
        Settings.SaveIntSetting(17, n);
    }

    public static int GetGameplayMode() {
        int n = Settings.GetIntSetting(17);
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        return 0;
    }

    public static int SetHighScore(String string, int n, int n2) {
        int n3;
        block7: {
            block8: {
                block6: {
                    n3 = -1;
                    if (0 != string.compareTo("grasslands")) break block6;
                    boolean bl = false;
                    int n4 = 0;
                    int n5 = 0;
                    for (int i = 0; i < 5; ++i) {
                        int n6 = Settings.GetHighScoreAsInt(string, i);
                        int n7 = Settings.GetHighScoreWaveAsInt(string, i);
                        if (!bl) {
                            if (n2 <= n6) continue;
                            n3 = i;
                            bl = true;
                            n4 = n6;
                            n5 = n7;
                            Settings.SaveIntSetting(19 + i * 3, n2);
                            Settings.SaveIntSetting(20 + i * 3, n + 1);
                            continue;
                        }
                        Settings.SaveIntSetting(19 + i * 3, n4);
                        Settings.SaveIntSetting(20 + i * 3, n5);
                        n4 = n6;
                        n5 = n7;
                    }
                    break block7;
                }
                if (0 != string.compareTo("crossroads")) break block8;
                boolean bl = false;
                int n8 = 0;
                int n9 = 0;
                for (int i = 0; i < 5; ++i) {
                    int n10 = Settings.GetHighScoreAsInt(string, i);
                    int n11 = Settings.GetHighScoreWaveAsInt(string, i);
                    if (!bl) {
                        if (n2 <= n10) continue;
                        n3 = i;
                        bl = true;
                        n8 = n10;
                        n9 = n11;
                        Settings.SaveIntSetting(49 + i * 3, n2);
                        Settings.SaveIntSetting(50 + i * 3, n + 1);
                        continue;
                    }
                    Settings.SaveIntSetting(49 + i * 3, n8);
                    Settings.SaveIntSetting(50 + i * 3, n9);
                    n8 = n10;
                    n9 = n11;
                }
                break block7;
            }
            if (0 != string.compareTo("drylands")) break block7;
            boolean bl = false;
            int n12 = 0;
            int n13 = 0;
            for (int i = 0; i < 5; ++i) {
                int n14 = Settings.GetHighScoreAsInt(string, i);
                int n15 = Settings.GetHighScoreWaveAsInt(string, i);
                if (!bl) {
                    if (n2 <= n14) continue;
                    n3 = i;
                    bl = true;
                    n12 = n14;
                    n13 = n15;
                    Settings.SaveIntSetting(79 + i * 3, n2);
                    Settings.SaveIntSetting(80 + i * 3, n + 1);
                    continue;
                }
                Settings.SaveIntSetting(79 + i * 3, n12);
                Settings.SaveIntSetting(80 + i * 3, n13);
                n12 = n14;
                n13 = n15;
            }
        }
        return n3;
    }

    public static int GetHighScoreAsInt(String string, int n) {
        int n2 = 0;
        if (0 == string.compareTo("grasslands")) {
            n2 = Settings.GetIntSetting(19 + n * 3);
        } else if (0 == string.compareTo("crossroads")) {
            n2 = Settings.GetIntSetting(49 + n * 3);
        } else if (0 == string.compareTo("drylands")) {
            n2 = Settings.GetIntSetting(79 + n * 3);
        }
        return n2;
    }

    public static String GetHighScore(String string, int n) {
        int n2 = 0;
        if (0 == string.compareTo("grasslands")) {
            n2 = Settings.GetIntSetting(19 + n * 3);
        } else if (0 == string.compareTo("crossroads")) {
            n2 = Settings.GetIntSetting(49 + n * 3);
        } else if (0 == string.compareTo("drylands")) {
            n2 = Settings.GetIntSetting(79 + n * 3);
        }
        String string2 = null;
        if (n2 > 0) {
            string2 = "" + n2;
        }
        return string2;
    }

    public static String GetHighScoreName(String string, int n) {
        return "test";
    }

    public static int GetHighScoreWaveAsInt(String string, int n) {
        int n2 = 0;
        if (0 == string.compareTo("grasslands")) {
            n2 = Settings.GetIntSetting(20 + n * 3);
        } else if (0 == string.compareTo("crossroads")) {
            n2 = Settings.GetIntSetting(50 + n * 3);
        } else if (0 == string.compareTo("drylands")) {
            n2 = Settings.GetIntSetting(80 + n * 3);
        }
        return n2;
    }

    public static String GetHighScoreWave(String string, int n) {
        String string2 = "";
        if (0 == string.compareTo("grasslands")) {
            string2 = string2 + Settings.GetIntSetting(20 + n * 3);
        } else if (0 == string.compareTo("crossroads")) {
            string2 = string2 + Settings.GetIntSetting(50 + n * 3);
        } else if (0 == string.compareTo("drylands")) {
            string2 = string2 + Settings.GetIntSetting(80 + n * 3);
        }
        return string2;
    }

    public static int NumHighScoreEntries(String string) {
        return 0;
    }
}

