/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Tower
extends Entity {
    public static final int kDefaultCapacityOfCachedEnemiesInTowerAttackRange = 30;
    public static final float kPredictionTolerance = 8.0f;
    Vector mEnemiesWithinAttackRange;
    TowerClass mTowerClass;
    Enemy mTarget;
    Map mMap;
    TechLevel mTechLevel;
    Color mColor;
    int mTargetUniqueID;
    int mDiscretizedAngle;
    int mFakeDiscretizedAngle;
    int mProjectileAngle;
    int mLightningProjectileAngle;
    int mMirrorType;
    int mMirrorTypeNone;
    int mState;
    float mFireAnimTimer;
    float mReloadTimer;
    float mOrientationAngle;
    float mFakeOrientationAngle;
    float mAnimTimer;
    int mTechLevelIndex;
    int mAnimFrame;
    boolean mHasBeenSimulated;
    boolean mShowFireAnim;
    boolean mTargetWithinLineOfSight;
    boolean mRemoveFromList;
    boolean mIsAttackSoundPlaying;
    int mLightningOffsetY;
    int mLightningRenderY;
    long currentSoundLengthInMillis = 0L;
    long currentSoundStartTime = 0L;
    private long lastCleanupTime = 0L;
    private static long cleanupThreshold = 3000L;

    public Tower(TowerClass towerClass, Map map) {
        super(towerClass);
        this.mTowerClass = towerClass;
        this.mMap = map;
        this.mTarget = null;
        this.mEnemiesWithinAttackRange = new Vector();
        this.mTechLevelIndex = 0;
        this.mState = 0;
        this.mMirrorType = 0;
        this.mMirrorTypeNone = 0;
        this.mOrientationAngle = 180.0f;
        this.mFakeOrientationAngle = 180.0f;
        this.mDiscretizedAngle = 0;
        this.mFakeDiscretizedAngle = 0;
        this.mProjectileAngle = 0;
        this.mLightningProjectileAngle = 0;
        this.mFireAnimTimer = 0.0f;
        this.mLightningOffsetY = 15;
        this.mLightningRenderY = 10;
        this.mAnimTimer = 0.0f;
        this.mAnimFrame = 0;
        this.mShowFireAnim = false;
        this.mColor = new Color();
        this.mColor.setR(255);
        this.mColor.setG(255);
        this.mColor.setB(255);
        this.mColor.setA(255);
        this.mHasBeenSimulated = false;
        this.mRemoveFromList = false;
        this.mIsAttackSoundPlaying = false;
        this.mType = kEnemyType;
        this.computeDiscretizedAngle();
        this.mTechLevel = (TechLevel)this.mTowerClass.mTechLevels.elementAt(this.mTechLevelIndex);
        this.mTargetWithinLineOfSight = !(this.mTechLevel.mTurnSpeed > 0.001f);
    }

    public Enemy cacheAliveEnemiesWithinAttackRange() {
        Enemy enemy = null;
        this.mEnemiesWithinAttackRange.removeAllElements();
        float f = Float.MAX_VALUE;
        for (int i = 0; i < this.mMap.mEnemyList.size(); ++i) {
            float f2;
            Enemy enemy2 = (Enemy)this.mMap.mEnemyList.elementAt(i);
            if (!(enemy2.mHealth > 0.0f) || !((f2 = (enemy2.mX - this.mX) * (enemy2.mX - this.mX) + (enemy2.mY - this.mY) * (enemy2.mY - this.mY)) <= this.mTechLevel.mAttackRadiusSquared) || !(f2 >= this.mTechLevel.mMinAttackRadiusSquared)) continue;
            this.mEnemiesWithinAttackRange.addElement(enemy2);
            if (!(enemy2.mHealth < f)) continue;
            if (this.mTechLevel.mProjectileClass != null && this.mTechLevel.mProjectileClass.mType == 2) {
                float f3 = this.mTechLevel.mProjectileClass.mTimeToImpact + this.mTechLevel.mProjectileSpawnDelay;
                CGPoint cGPoint = new CGPoint();
                boolean bl = enemy2.predictPositionInElapsedTime(f3, cGPoint);
                float f4 = (cGPoint.x - this.mX) * (cGPoint.x - this.mX) + (cGPoint.y - this.mY) * (cGPoint.y - this.mY);
                float f5 = Math.max(this.mTechLevel.mSplashDamageRange - 8.0f, 0.0f);
                if (f4 > this.mTechLevel.mAttackRadiusSquared + f5 || f4 < this.mTechLevel.mMinAttackRadiusSquared - f5) continue;
            }
            f = enemy2.mHealth;
            enemy = enemy2;
        }
        return enemy;
    }

    float calculatePerSecondDamage(float f) {
        float f2 = (int)RandomUtilities.RANDOM_FLOAT_IN_RANGE(this.mTechLevel.mMinDamage, this.mTechLevel.mMaxDamage + 1.0f);
        return f2 *= f;
    }

    private void computeDiscretizedAngle() {
        this.mDiscretizedAngle = (int)this.mOrientationAngle;
        this.mDiscretizedAngle = (this.mDiscretizedAngle + 15) / 30 * 30 % 360;
        this.mDiscretizedAngle /= 30;
        this.mProjectileAngle = this.mDiscretizedAngle;
        if (this.mTowerClass.mMirrorHorizontal && this.mDiscretizedAngle > 6) {
            this.mMirrorType = 1;
            this.mDiscretizedAngle = 6 - (this.mDiscretizedAngle - 6);
        } else {
            this.mMirrorType = 0;
        }
    }

    private void computeFakeDiscretizedAngle() {
        int n = 30;
        this.mFakeDiscretizedAngle = (int)this.mFakeOrientationAngle;
        this.mFakeDiscretizedAngle = (this.mFakeDiscretizedAngle + 15) / 30 * 30 % 360;
        this.mFakeDiscretizedAngle /= 30;
        this.mLightningProjectileAngle = this.mFakeDiscretizedAngle;
        this.mLightningProjectileAngle = this.mFakeDiscretizedAngle;
    }

    public int findAngleToEnemy(Enemy enemy) {
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = enemy.mX;
        cGPoint.y = enemy.mY;
        Vector2f vector2f = new Vector2f();
        vector2f.x = cGPoint.x - this.mX;
        vector2f.y = cGPoint.y - this.mY;
        vector2f.normalize();
        float f = vector2f.computeAngleBetweenVector(Vector2f.orientationAxis());
        if (vector2f.isCounterClockwiseToVector(Vector2f.orientationAxis())) {
            f = 6.28f - f;
        }
        return (int)MathUtilities.RADIANS_TO_DEGREES(f);
    }

    public boolean initiateUpgrade() {
        if (this.mTechLevelIndex + 1 < this.mTowerClass.mTechLevels.size()) {
            TechLevel techLevel = (TechLevel)this.mTowerClass.mTechLevels.elementAt(this.mTechLevelIndex + 1);
            if (this.mMap.mPlayer.mResources >= techLevel.mCost) {
                int n = techLevel.mCost;
                if (!Can.NO_UPGRADE_COSTS) {
                    this.mMap.mPlayer.mResources -= n;
                }
                if (this.mState == 1) {
                    this.mTarget = null;
                }
                this.mState = 2;
                this.updateWithElapsedTime(0.0f);
                return true;
            }
        }
        return false;
    }

    public void launchProjectile() {
        CGPoint cGPoint = new CGPoint();
        boolean bl = false;
        bl = this.mClass.mSprite.getTagPointPosRelativeToAnchorWithName("attack01", 13 + this.mTechLevelIndex, this.mDiscretizedAngle, cGPoint);
        if (!bl) {
            bl = this.mClass.mSprite.getTagPointPosRelativeToAnchorWithName("attack01", 10 + this.mTechLevelIndex, this.mDiscretizedAngle, cGPoint);
        }
        if (this.mMirrorType == 1) {
            cGPoint.x = -cGPoint.x;
        }
        if (this.mTechLevel.mProjectileClass.mType == 2) {
            CGPoint cGPoint2 = new CGPoint();
            float f = this.mTechLevel.mProjectileClass.mTimeToImpact + this.mTechLevel.mProjectileSpawnDelay;
            this.mTarget.predictPositionInElapsedTime(f, cGPoint2);
            Vector2f vector2f = new Vector2f(cGPoint2.x, cGPoint2.y);
            vector2f.x -= this.mX;
            vector2f.y -= this.mY;
            vector2f.clampTo(this.mTechLevel.mMinAttackRadius, this.mTechLevel.mAttackRadius);
            vector2f.x += this.mX;
            vector2f.y += this.mY;
            Projectile projectile = new Projectile(this.mTechLevel.mProjectileClass, this.mMap, this, vector2f);
            projectile.mX = this.mX + cGPoint.x;
            projectile.mY = this.mY + cGPoint.y;
            this.mMap.addProjectile(projectile);
            projectile = null;
        } else if (this.mTowerClass.mID == 2) {
            Projectile projectile = new Projectile(this.mTechLevel.mProjectileClass, this.mMap, this, this.mTarget);
            switch (this.mProjectileAngle) {
                case 0: {
                    projectile.setFrameForMissile(this.mProjectileAngle, this.mMirrorTypeNone);
                    break;
                }
                case 1: 
                case 2: {
                    projectile.setFrameForMissile(1, this.mMirrorTypeNone);
                    break;
                }
                case 3: {
                    projectile.setFrameForMissile(2, this.mMirrorTypeNone);
                    break;
                }
                case 4: 
                case 5: {
                    projectile.setFrameForMissile(3, this.mMirrorTypeNone);
                    break;
                }
                case 6: {
                    projectile.setFrameForMissile(4, this.mMirrorTypeNone);
                    break;
                }
                case 7: 
                case 8: {
                    projectile.setFrameForMissile(5, this.mMirrorTypeNone);
                    break;
                }
                case 9: {
                    projectile.setFrameForMissile(6, this.mMirrorTypeNone);
                    break;
                }
                case 10: 
                case 11: {
                    projectile.setFrameForMissile(7, this.mMirrorTypeNone);
                    break;
                }
                default: {
                    projectile.setFrameForMissile(0, this.mMirrorTypeNone);
                }
            }
            projectile.mX = this.mX;
            projectile.mY = this.mY;
            this.mMap.addProjectile(projectile);
            projectile = null;
        } else {
            Projectile projectile = new Projectile(this.mTechLevel.mProjectileClass, this.mMap, this, this.mTarget);
            projectile.mX = this.mX + cGPoint.x;
            projectile.mY = this.mY + cGPoint.y;
            this.mMap.addProjectile(projectile);
            projectile = null;
        }
    }

    public boolean playAnimation(MapGraphics mapGraphics, int n, float f, boolean bl) {
        int n2 = this.mAnimationController.getFrameCountForAnimationWithId(n);
        Animation animation = this.mAnimationController.getAnimationForAnimationWithId(n);
        this.mAnimTimer += f;
        while (this.mAnimTimer >= animation.mInterval) {
            this.mAnimTimer -= animation.mInterval;
            ++this.mAnimFrame;
        }
        boolean bl2 = false;
        if (bl) {
            this.mAnimFrame %= n2;
        } else if (this.mAnimFrame >= n2) {
            this.mAnimFrame = n2 - 1;
            bl2 = true;
            this.mAnimTimer = 0.0f;
            this.mAnimFrame = 0;
        }
        return bl2;
    }

    public void renderWithElapsedTime(MapGraphics mapGraphics, float f) {
        try {
            int n;
            float f2;
            this.mFireAnimTimer -= f;
            float f3 = f2 = this.mTechLevel.mProjectileClass != null ? this.mTechLevel.mProjectileClass.mDisplayTime * 2.0f : this.mTechLevel.mFireDisplayTime * 2.0f;
            if (f2 < 0.001f) {
                f2 = this.mTechLevel.mReloadSpeed;
            }
            if (this.mTechLevel.mProjectileClass != null && this.mTechLevel.mTurnSpeed == 0.0f && this.mTechLevel.mProjectileClass.mDisplayTime < 0.001f) {
                if (this.mFireAnimTimer > f2 * 0.5f) {
                    n = this.mTowerClass.getAttackAnimationIdForTechLevel(this.mTechLevelIndex);
                    boolean bl = this.playAnimation(mapGraphics, n, f, false);
                    this.mDiscretizedAngle = this.mAnimFrame;
                    if (bl) {
                        this.mAnimTimer = 0.0f;
                        this.mAnimFrame = 0;
                        this.mFireAnimTimer = 0.0f;
                    }
                } else {
                    n = this.mTowerClass.getIdleAnimationIdForTechLevel(this.mTechLevelIndex);
                    this.playAnimation(mapGraphics, n, f, true);
                    this.mDiscretizedAngle = this.mAnimFrame;
                }
            }
            if (this.mFireAnimTimer > f2 * 0.5f) {
                n = this.mTowerClass.getAttackAnimationIdForTechLevel(this.mTechLevelIndex);
                this.mAnimationController.renderWithAnimation(mapGraphics, n, this.mDiscretizedAngle, this.mColor, this.mX, this.mY, 0.0f, 1.0f, true, this.mMirrorType);
            } else {
                n = this.mTowerClass.getIdleAnimationIdForTechLevel(this.mTechLevelIndex);
                this.mAnimationController.renderWithAnimation(mapGraphics, n, this.mDiscretizedAngle, this.mColor, this.mX, this.mY, 0.0f, 1.0f, false, this.mMirrorType);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("***************************************************");
            System.out.println("Tower.renderWithElapsedTime: NULL POINTER EXCEPTION");
            System.out.println(":: Error: " + nullPointerException.getMessage());
            System.out.println(":: mAnimationController = " + this.mAnimationController);
            System.out.println(":: mTowerClass = " + this.mTowerClass);
            System.out.println(":: mTechLevel = " + this.mTechLevel);
            System.out.println(":: mTechLevel.mProjectileClass = " + this.mTechLevel.mProjectileClass);
            System.out.println(":: mTechLevel.mFireDisplay = " + this.mTechLevel.mFireDisplayTime);
            nullPointerException.printStackTrace();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void restoreTargetFromEnemyList(Vector vector) {
        if (this.mTargetUniqueID != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Enemy enemy = (Enemy)vector.elementAt(i);
                if (enemy.mUniqueID != this.mTargetUniqueID) continue;
                this.mTarget = enemy;
            }
        }
    }

    public void serializeWithBinaryFile(GameState gameState) {
        super.serializeWithBinaryFile(gameState);
        this.mState = gameState.SERIALIZE(this.mState);
        this.mFireAnimTimer = gameState.SERIALIZE(this.mFireAnimTimer);
        this.mOrientationAngle = gameState.SERIALIZE(this.mOrientationAngle);
        this.mTechLevelIndex = gameState.SERIALIZE(this.mTechLevelIndex);
        this.mShowFireAnim = gameState.SERIALIZE(this.mShowFireAnim);
        this.mTargetWithinLineOfSight = gameState.SERIALIZE(this.mTargetWithinLineOfSight);
        this.mReloadTimer = gameState.SERIALIZE(this.mReloadTimer);
        this.mRemoveFromList = gameState.SERIALIZE(this.mRemoveFromList);
        this.mHasBeenSimulated = gameState.SERIALIZE(this.mHasBeenSimulated);
        int n = this.mTarget != null ? this.mTarget.mUniqueID : 0;
        this.mTargetUniqueID = gameState.SERIALIZE(n);
        if (gameState.isLoading()) {
            this.mTechLevel = (TechLevel)this.mTowerClass.mTechLevels.elementAt(this.mTechLevelIndex);
        }
    }

    public void setColor(int n, int n2, int n3, int n4) {
        this.mColor.setR(n);
        this.mColor.setG(n2);
        this.mColor.setB(n3);
        this.mColor.setA(n4);
    }

    void updateAttackStateWithElapsedTime(float f) {
        try {
            boolean bl = false;
            if (this.mTarget.mHealth > 0.0f) {
                CGPoint cGPoint = new CGPoint();
                float f2 = MathUtilities.Sqrt(MathUtilities.SQUARE(this.mTarget.mX - this.mX) + MathUtilities.SQUARE(this.mTarget.mY - this.mY));
                if (f2 <= this.mTechLevel.mAttackRadius && f2 >= this.mTechLevel.mMinAttackRadius) {
                    float f3;
                    if (this.mTechLevel.mTurnSpeed > 0.001f) {
                        this.updateOrientationAngle(f);
                    }
                    if (this.mTechLevel.mProjectileClass != null && this.mTechLevel.mProjectileClass.mType == 2) {
                        f3 = this.mTechLevel.mProjectileClass.mTimeToImpact + this.mTechLevel.mProjectileSpawnDelay;
                        boolean bl2 = this.mTarget.predictPositionInElapsedTime(f3, cGPoint);
                        if (!bl2) {
                            bl = true;
                        }
                        float f4 = Math.max(this.mTechLevel.mSplashDamageRange - 8.0f, 0.0f);
                        float f5 = MathUtilities.Sqrt(MathUtilities.SQUARE(cGPoint.x - this.mX) + MathUtilities.SQUARE(cGPoint.y - this.mY));
                        if (f5 > this.mTechLevel.mAttackRadius + f4 || f5 < this.mTechLevel.mMinAttackRadius - f4) {
                            bl = true;
                        }
                    }
                    if (this.mTargetWithinLineOfSight && this.mReloadTimer <= 0.001f && !bl) {
                        this.mReloadTimer = this.mTechLevel.mReloadSpeed;
                        float f6 = f3 = this.mTechLevel.mProjectileClass != null ? this.mTechLevel.mProjectileClass.mDisplayTime : this.mTechLevel.mFireDisplayTime;
                        if (f3 > 0.0f && f3 < f) {
                            f3 = f;
                        }
                        f3 *= 2.0f;
                        if (this.mFireAnimTimer < 0.001f) {
                            this.mFireAnimTimer = f3 > 0.001f ? f3 : this.mTechLevel.mReloadSpeed;
                            this.mAnimTimer = 0.0f;
                            this.mAnimFrame = 0;
                        }
                        if (this.mTechLevel.mProjectileClass != null) {
                            this.launchProjectile();
                        } else {
                            float f7 = this.calculatePerSecondDamage(f);
                            if (this.mTechLevel.mSplashDamageModifier > 0.0f) {
                                for (int i = 0; i < this.mMap.mEnemyList.size(); ++i) {
                                    float f8;
                                    Enemy enemy = (Enemy)this.mMap.mEnemyList.elementAt(i);
                                    if (enemy == this.mTarget || !((f8 = MathUtilities.Sqrt(MathUtilities.SQUARE(this.mTarget.mX - enemy.mX) + MathUtilities.SQUARE(this.mTarget.mY - enemy.mY))) <= this.mTechLevel.mSplashDamageRange)) continue;
                                    enemy.mHealth -= f7 * this.mTechLevel.mSplashDamageModifier;
                                    enemy.mShowHealth = true;
                                }
                            }
                            this.mTarget.mHealth -= f7;
                            this.mTarget.mShowHealth = true;
                        }
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.mTarget = null;
                this.mState = 0;
                this.mTargetWithinLineOfSight = !(this.mTechLevel.mTurnSpeed > 0.001f);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void updateIdleStateWithElapsedTime(float f) {
        if (this.mIsAttackSoundPlaying) {
            this.mIsAttackSoundPlaying = false;
        }
        boolean bl = this.mEnemiesWithinAttackRange.size() > 0;
        Enemy enemy = this.cacheAliveEnemiesWithinAttackRange();
        if (enemy != null) {
            this.mTarget = enemy;
            if (this.mTechLevel.mTurnSpeed > 0.001f) {
                this.updateOrientationAngle(f);
            } else {
                this.updateFakeOrientationAngle(f);
            }
            if (this.mTargetWithinLineOfSight) {
                this.mState = 1;
            } else {
                this.mTarget = null;
            }
        }
    }

    void updateOrientationAngle(float f) {
        float f2;
        boolean bl;
        float f3 = this.findAngleToEnemy(this.mTarget);
        float f4 = f3 - this.mOrientationAngle;
        this.mTargetWithinLineOfSight = Math.abs(f4) <= this.mTechLevel.mFieldOfView * 0.5f;
        boolean bl2 = bl = f4 >= 0.0f;
        if (f4 > 180.0f || f4 < -180.0f) {
            boolean bl3 = bl = !bl;
        }
        this.mOrientationAngle = (f2 = f * this.mTechLevel.mTurnSpeed) < Math.abs(f4) ? (this.mOrientationAngle += (float)(bl ? 1 : -1) * f2) : f3;
        this.mOrientationAngle = MathUtilities.normalizeAngle(this.mOrientationAngle, 0.0f, 360.0f);
    }

    void updateFakeOrientationAngle(float f) {
        float f2;
        boolean bl;
        float f3 = this.findAngleToEnemy(this.mTarget);
        float f4 = f3 - this.mFakeOrientationAngle;
        this.mTargetWithinLineOfSight = Math.abs(f4) <= this.mTechLevel.mFieldOfView * 0.5f;
        boolean bl2 = bl = f4 >= 0.0f;
        if (f4 > 180.0f || f4 < -180.0f) {
            boolean bl3 = bl = !bl;
        }
        this.mFakeOrientationAngle = (f2 = f * 310.0f) < Math.abs(f4) ? (this.mFakeOrientationAngle += (float)(bl ? 1 : -1) * f2) : f3;
        this.mFakeOrientationAngle = MathUtilities.normalizeAngle(this.mFakeOrientationAngle, 0.0f, 360.0f);
    }

    void updateUpgradeStateWithElapsedTime(float f) {
        ++this.mTechLevelIndex;
        this.mTechLevel = (TechLevel)this.mTowerClass.mTechLevels.elementAt(this.mTechLevelIndex);
        this.mState = 0;
    }

    public boolean updateWithElapsedTime(float f) {
        this.mReloadTimer -= f;
        this.mReloadTimer = Math.max(this.mReloadTimer, 0.0f);
        if (f > 0.001f) {
            this.mHasBeenSimulated = true;
        }
        if (this.mTowerClass.mID == 4) {
            this.computeFakeDiscretizedAngle();
        } else {
            this.computeDiscretizedAngle();
        }
        if (this.mState == 1) {
            if (f > 0.001f) {
                this.updateAttackStateWithElapsedTime(f);
            }
        } else if (this.mState == 2) {
            this.updateUpgradeStateWithElapsedTime(f);
        } else if (this.mState == 0 && f > 0.001f) {
            this.updateIdleStateWithElapsedTime(f);
        }
        return this.mRemoveFromList;
    }
}

