/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class AnimationController {
    Sprite mSprite;
    int mCurrentAnimationID;
    Vector mCurrentAnimationFrameList;
    AnimationFrame mCurrentAnimationFrame;
    Animation mCurrentAnimation;
    int mCurrentFrame;
    AnimationComplete mIsAnimationComplete;
    public static final int kMoveN = 0;
    public static final int kMoveE = 1;
    public static final int kMoveS = 2;
    public static final int kMoveW = 3;
    public static final int kDeathN = 4;
    public static final int kDeathE = 5;
    public static final int kDeathS = 6;
    public static final int kDeathW = 7;
    public static final int kIdle1 = 10;
    public static final int kIdle2 = 11;
    public static final int kIdle3 = 12;
    public static final int kAttack1 = 13;
    public static final int kAttack2 = 14;
    public static final int kAttack3 = 15;
    public static final int kIdle = 20;
    public static final int kDeath = 21;
    public static final int kNoAnim = 99;

    public static int NameToID(String string) {
        if (string.compareTo("move_north") == 0) {
            return 0;
        }
        if (string.compareTo("move_east") == 0) {
            return 1;
        }
        if (string.compareTo("move_south") == 0) {
            return 2;
        }
        if (string.compareTo("move_west") == 0) {
            return 3;
        }
        if (string.compareTo("death_north") == 0) {
            return 4;
        }
        if (string.compareTo("death_east") == 0) {
            return 5;
        }
        if (string.compareTo("death_south") == 0) {
            return 6;
        }
        if (string.compareTo("death_west") == 0) {
            return 7;
        }
        if (string.compareTo("idle_level1") == 0) {
            return 10;
        }
        if (string.compareTo("idle_level2") == 0) {
            return 11;
        }
        if (string.compareTo("idle_level3") == 0) {
            return 12;
        }
        if (string.compareTo("attack_level1") == 0) {
            return 13;
        }
        if (string.compareTo("attack_level2") == 0) {
            return 14;
        }
        if (string.compareTo("attack_level3") == 0) {
            return 15;
        }
        if (string.compareTo("idle") == 0) {
            return 20;
        }
        if (string.compareTo("death") == 0) {
            return 21;
        }
        Fieldrunners.alert("Unknown animation name " + string);
        return 99;
    }

    public AnimationController(Sprite sprite) {
        this.mSprite = sprite;
        this.mCurrentAnimationID = 99;
        this.mCurrentAnimationFrameList = null;
        this.mCurrentAnimationFrame = null;
        this.mCurrentAnimation = null;
        this.mCurrentFrame = -1;
        this.mIsAnimationComplete = new AnimationComplete();
    }

    boolean DoesAnimationExist(int n) {
        return this.mSprite.doesContainAnimationWithID(n);
    }

    Animation getAnimationForAnimationWithId(int n) {
        if (this.mCurrentAnimationID != n) {
            Animation animation = this.mSprite.getAnimationFromAnimID(n);
            return animation;
        }
        return this.mCurrentAnimation;
    }

    int getFrameCountForAnimationWithId(int n) {
        Animation animation;
        if (this.mCurrentAnimationID != n && (animation = this.mSprite.getAnimationFromAnimID(n)) != null) {
            return animation.mAnimationFrameList.size();
        }
        return this.mCurrentAnimationFrameList.size();
    }

    boolean renderWithAnimation(MapGraphics mapGraphics, int n, int n2, Color color, float f, float f2, float f3, float f4, boolean bl) {
        return this.renderWithAnimation(mapGraphics, n, n2, color, f, f2, f3, f4, bl, this.mIsAnimationComplete, 0);
    }

    boolean renderWithAnimation(MapGraphics mapGraphics, int n, int n2, Color color, float f, float f2, float f3, float f4, boolean bl, int n3) {
        return this.renderWithAnimation(mapGraphics, n, n2, color, f, f2, f3, f4, bl, this.mIsAnimationComplete, n3);
    }

    boolean renderProjectileWithAnimation(MapGraphics mapGraphics, int n, int n2, Color color, float f, float f2, float f3, float f4, boolean bl, AnimationComplete animationComplete, int n3) {
        try {
            boolean bl2 = false;
            this.mIsAnimationComplete.mIsAnimationComplete = false;
            if (this.mCurrentAnimationID == 99 || this.mCurrentAnimationID != n) {
                this.mCurrentAnimationID = n;
                this.mCurrentAnimation = this.mSprite.getAnimationFromAnimID(n);
                this.mCurrentAnimationFrameList = this.mCurrentAnimation.mAnimationFrameList;
                bl2 = true;
            } else if (n2 != this.mCurrentFrame) {
                bl2 = true;
            }
            if (bl2) {
                if (bl) {
                    n2 %= this.mCurrentAnimationFrameList.size();
                } else if (n2 >= this.mCurrentAnimationFrameList.size()) {
                    n2 = this.mCurrentAnimationFrameList.size() - 1;
                    this.mIsAnimationComplete.mIsAnimationComplete = true;
                }
                this.mCurrentFrame = n2;
                this.mCurrentAnimationFrame = (AnimationFrame)this.mCurrentAnimationFrameList.elementAt(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.mSprite.renderProjectileWithAnimationFrame(mapGraphics, this.mCurrentAnimationFrame, color, f, f2, f3, f4, n3);
    }

    boolean renderProjectileWithAnimation(MapGraphics mapGraphics, int n, int n2, Color color, float f, float f2, float f3, float f4, boolean bl, int n3) {
        return this.renderProjectileWithAnimation(mapGraphics, n, n2, color, f, f2, f3, f4, bl, this.mIsAnimationComplete, n3);
    }

    boolean renderWithAnimation(MapGraphics mapGraphics, int n, int n2, Color color, float f, float f2, float f3, float f4, boolean bl, AnimationComplete animationComplete, int n3) {
        try {
            boolean bl2 = false;
            this.mIsAnimationComplete.mIsAnimationComplete = false;
            if (this.mCurrentAnimationID == 99 || this.mCurrentAnimationID != n) {
                this.mCurrentAnimationID = n;
                this.mCurrentAnimation = this.mSprite.getAnimationFromAnimID(n);
                this.mCurrentAnimationFrameList = this.mCurrentAnimation.mAnimationFrameList;
                bl2 = true;
            } else if (n2 != this.mCurrentFrame) {
                bl2 = true;
            }
            if (bl2) {
                if (bl) {
                    n2 %= this.mCurrentAnimationFrameList.size();
                } else if (n2 >= this.mCurrentAnimationFrameList.size()) {
                    n2 = this.mCurrentAnimationFrameList.size() - 1;
                    this.mIsAnimationComplete.mIsAnimationComplete = true;
                }
                if (animationComplete != null) {
                    animationComplete.mIsAnimationComplete = this.mIsAnimationComplete.mIsAnimationComplete;
                }
                this.mCurrentFrame = n2;
                this.mCurrentAnimationFrame = (AnimationFrame)this.mCurrentAnimationFrameList.elementAt(n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.mSprite.renderWithAnimationFrame(mapGraphics, this.mCurrentAnimationFrame, color, f, f2, f3, f4, n3);
    }
}

