/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameHudForm
extends Form {
    public static int LEFTMOST_ARROW_LOCATION = 20;
    public static int UPMOST_ARROW_LOCATION = 35;
    public static int RIGHTMOST_ARROW_LOCATION = 216;
    public static int BOTTOMMOST_ARROW_LOCATION = 300;
    public int totalTime;
    Vector mAchievementQueue = null;
    String mStatusString = null;
    String mStatusStringLastUpdate = null;
    String mStatusStringSaved = null;
    Tower mTowerCursor = null;
    Tower mTowerFlasher;
    int mTowerFlasherIndex;
    Text mResourcesText = null;
    Text mHealthText = null;
    Text mScoreText = null;
    Text mStatusText = null;
    float mStatusTextCurrentOpacity = 0.0f;
    float mStatusTextSavedOpacity = 0.0f;
    float mStatusTextTargetOpacity = 0.0f;
    Button mFastForwardButton;
    Button mTutorialParent;
    Button mBuildTowerMenu;
    Button mModifyTowerMenu = null;
    Button mSellTowerButton = null;
    Button mUpgradeTowerButton = null;
    Button mPlaybackButton = null;
    Button mAchievementBox = null;
    Button mAchievementBoxParent = null;
    Button mGearButton;
    Overlay mVictoryTextOverlay;
    Overlay mDefeatTextOverlay;
    Overlay mEndGameTextOverlay = null;
    CGPoint mViewPos;
    CGPoint mKeyViewPos;
    Point mCursorPoint;
    Point mMidPoint;
    CGPoint mPreviousViewPos;
    FontStrip mNumberFont = null;
    CGPoint mClampedSpawnViewPos;
    CGPoint mSpawnViewPos;
    Point mCursorPosition;
    float mAchievementTimer = 0.0f;
    float mEndGameTextOverlayHalfWidth;
    float mEndGameTextOverlayHalfHeight;
    float mEndGameTextDisplayTimer;
    float mEndGameTextScale;
    float mTouchDeltaViewSpace = 0.0f;
    float mTowerCursorRangeIndicatorVisibility = 0.0f;
    int mResourcesLastUpdate = -1;
    int mHealthLastUpdate = -1;
    int mScoreLastUpdate = -1;
    int mTowerCursorIndex = -1;
    int mSelectedTowerTileGridIndex = -1;
    int mPreviouslySelectedTowerTileGridIndex = -1;
    int mUpgradeTowerInTileGridIndex;
    public boolean mFirstTouch;
    boolean mIsValidBuildLocation = false;
    boolean mShowEndGameText = false;
    boolean mEndGameTextDisplayTimerHasExpired;
    MapGraphics mMapGraphics = null;
    String mTowerKeyPressed = "";
    boolean mOpenMenu = false;
    boolean mItATower = false;
    boolean mModifyingTower = false;
    boolean mPlacingTower = false;
    boolean mSelectedByMenu = false;
    boolean mFudgeUpValue = false;
    boolean mAddDownValue = false;
    boolean mAddUpValue = false;
    boolean mAtWorldBottom = false;
    boolean mAtFarRight = false;
    int mRectX = 48;
    int mRectY = 48;
    int mMoveDelta = 32;
    int mRectMidDelta = 12;
    int mRectMidDeltay = 12;
    private int mKeyOffsetX = 5;
    private int mKeyOffsetY = 12;
    boolean mFirstDownMovement = true;
    boolean mFirstUpMovement = true;
    boolean mRenderDone = true;
    int mSelectedTower;
    boolean shouldShowLoadingBarNow;
    boolean mShowIt;
    int mPlayorResume;
    long loadingBarStartTime;
    Vector2f mArrowDirection;
    Image mStreamArrow;
    Image mStreamArrowDownLeft;
    Image mStreamArrowLeft;
    Image mStreamArrowUpLeft;
    Image mStreamArrowUpRight;
    Image mNiceCursor;
    Image mNaughtyCursor;
    tGameState mLastGameState;
    public static final float kZoomSpeed = 100.0f;
    public static final float kAutomaticZoomSpeed = 4.0f;
    public static final float kScrollSpeed = 1.0f;
    public static final float kTowerPlacementVerticalOffset = -40.0f;
    public static final float kRangeIndicatorFadeSpeed = 5.0f;
    public static final String kHUDFontName = "Arial";
    public static final int kHUDFontSize = 7;
    public static final float kResourceTextPosX = 0.06667f;
    public static final float kResourceTextPosY = 0.019f;
    public static final float kHealthTextPosX = 0.805f;
    public static final float kHealthTextPosY = 0.019f;
    public static final float kScoreTextWidth = 0.25f;
    public static final float kScoreTextPosX = 0.375f;
    public static final float kScoreTextPosY = 0.019f;
    public static final float kStatusTextWidth = 0.5f;
    public static final float kStatusTextPosX = 0.25f;
    public static final float kStatusTextPosY = 0.08f;
    public static final float kStatusTextDisplayTime = 3.0f;
    public static final float kStatusTextFadeInTime = 0.4f;
    public static final float kStatusTextFadeOutTime = 0.4f;
    public static final float kEndGameTextDisplayTime = 4.0f;
    public static final float kEndGameTextFadeSpeed = 2.0f;
    public static final float kEndGameTextScaleSpeed = 3.0f;
    public static final float kEndGameTextInitialScale = 3.0f;
    public static final float kTextShadowOffset = 0.0035f;
    public static final float kBackgroundMusicFadeOutSpeed = 0.5f;
    public static final float kAchievementDisplayTime = 5.0f;
    public float kStreamIndicatorArrowTopScreenPadding = 0.0f;
    public float kStreamIndicatorArrowBottomScreenPadding = 0.0f;
    public float kStreamIndicatorArrowLeftScreenPadding;
    public final float kStreamIndicatorArrowRightScreenPadding = this.kStreamIndicatorArrowLeftScreenPadding = 0.0f;
    public static final float kStreamIndicatorArrowScaleUpAnimSpeed = 5.0f;
    public static final float kStreamIndicatorArrowScaleDownAnimSpeed = 7.0f;
    public static final float kStreamIndicatorArrowMaxStretchSize = 1.7f;
    public static final float kStreamIndicatorArrowFadeSpeed = 1.0f;
    public static final float kStreamIndicatorArrowMinOpacity = 0.45f;
    int mSelectButtonPos = 0;
    public static final int kGatlingTowerIndex = 0;
    public static final int kGooTowerIndex = 1;
    public static final int kMissileTowerIndex = 2;
    public static final int kFlameTowerIndex = 3;
    public static final int kLightningTowerIndex = 4;
    public static final int kMortarTowerIndex = 5;
    private boolean exitOnNextTick = false;
    private long newHighScoreNotificationTime = 0L;
    private static long newHighScoreNotificationTimeout = 3000L;
    private boolean mSwitchToHighScoreList = false;

    public GameHudForm() {
        this.mViewPos = new CGPoint();
        this.mViewPos.x = 0.0f;
        this.mViewPos.y = 0.0f;
        this.mPreviousViewPos = new CGPoint();
        this.mPreviousViewPos.x = 0.0f;
        this.mPreviousViewPos.y = 0.0f;
        this.mKeyViewPos = new CGPoint(0.0f, 0.0f);
        this.mCursorPoint = new Point(0, 0);
        this.mMidPoint = new Point(0, 0);
        this.mCursorPosition = new Point(1, 1);
        this.mFirstTouch = true;
        this.mMapGraphics = new MapGraphics(Fieldrunners.mCanvas.getGraphics(), this);
        this.mNumberFont = new FontStrip(1);
    }

    public void initFromFile(String string, MapScreen mapScreen, UserInterface userInterface, String string2) {
        Object object;
        int n;
        super.initFromFile(string, mapScreen, userInterface, string2);
        Vector vector = Map.getTowerClassList();
        TowerClass towerClass = (TowerClass)vector.elementAt(0);
        this.mTowerFlasher = new Tower(towerClass, this.mView.mMap);
        this.mTowerFlasherIndex = 0;
        this.mMapGraphics.screenWidth = this.mView.width();
        this.mMapGraphics.screenHeight = this.mView.height();
        this.kStreamIndicatorArrowTopScreenPadding = 0.09f * (float)this.mView.height() + 16.0f;
        this.kStreamIndicatorArrowBottomScreenPadding = 0.156f * (float)this.mView.height() + 16.0f;
        this.kStreamIndicatorArrowLeftScreenPadding = 0.02f * (float)this.mView.width() + 16.0f;
        this.mAchievementQueue = new Vector();
        this.mTowerCursor = null;
        this.mTowerCursorRangeIndicatorVisibility = 0.0f;
        this.mIsValidBuildLocation = false;
        this.mShowEndGameText = false;
        this.mTowerCursorIndex = -1;
        this.mSelectedTowerTileGridIndex = -1;
        this.mPreviouslySelectedTowerTileGridIndex = -1;
        this.mEndGameTextOverlay = null;
        this.mAchievementBox = null;
        this.mAchievementBoxParent = null;
        this.mModifyTowerMenu = null;
        this.mSellTowerButton = null;
        this.mUpgradeTowerButton = null;
        this.mPlaybackButton = null;
        this.mResourcesText = null;
        this.mHealthText = null;
        this.mScoreText = null;
        this.mStatusText = null;
        this.mStatusString = null;
        this.mStatusStringSaved = null;
        this.mStatusStringLastUpdate = null;
        this.mStatusTextCurrentOpacity = 0.0f;
        this.mStatusTextTargetOpacity = 0.0f;
        this.mStatusTextSavedOpacity = 0.0f;
        this.mAchievementTimer = 0.0f;
        this.mResourcesLastUpdate = -1;
        this.mHealthLastUpdate = -1;
        this.mScoreLastUpdate = -1;
        this.mOpenMenu = false;
        this.mItATower = false;
        this.mModifyingTower = false;
        this.mViewPos = new CGPoint();
        this.mViewPos.x = 0.0f;
        this.mViewPos.y = 0.0f;
        this.mArrowDirection = new Vector2f();
        this.mPreviousViewPos = new CGPoint();
        this.mPreviousViewPos.x = 0.0f;
        this.mPreviousViewPos.y = 0.0f;
        this.mFirstTouch = true;
        try {
            this.mStreamArrow = Image.createImage((String)"/UserInterface/stream_arrow.png");
            this.mStreamArrowDownLeft = Image.createImage((String)"/UserInterface/stream_arrow_down_left.png");
            this.mStreamArrowLeft = Image.createImage((String)"/UserInterface/stream_arrow_left.png");
            this.mStreamArrowUpLeft = Image.createImage((String)"/UserInterface/stream_arrow_up_left.png");
            this.mStreamArrowUpRight = Image.createImage((String)"/UserInterface/stream_arrow_up_right.png");
            this.mNiceCursor = Image.createImage((String)"/UserInterface/cursor.png");
            this.mNaughtyCursor = Image.createImage((String)"/UserInterface/cursorx.png");
        }
        catch (Exception exception) {
            System.out.println("bad arrow load");
            exception.printStackTrace();
        }
        for (n = 0; n < this.mButtonList.size(); ++n) {
            int n2;
            TechLevel techLevel;
            object = (Button)this.mButtonList.elementAt(n);
            if (((Button)object).mName.compareTo("ModifyTower") == 0) {
                this.mModifyTowerMenu = object;
                continue;
            }
            if (((Button)object).mName.compareTo("SellTower") == 0) {
                this.mSellTowerButton = object;
                this.mSellTowerButton.mTrackTimer = 0.0f;
                continue;
            }
            if (((Button)object).mName.compareTo("UpgradeTower") == 0) {
                this.mUpgradeTowerButton = object;
                this.mUpgradeTowerButton.mTrackTimer = 0.0f;
                continue;
            }
            if (((Button)object).mName.compareTo("BuildParent") == 0) {
                this.mBuildTowerMenu = object;
                this.mBuildTowerMenu.mTrackParentPos = false;
                continue;
            }
            if (((Button)object).mName.compareTo("Playback") == 0) {
                this.mPlaybackButton = object;
                continue;
            }
            if (((Button)object).mName.compareTo("AchievementParent") == 0) {
                this.mAchievementBoxParent = object;
                this.mAchievementBoxParent.mIsHidden = true;
                continue;
            }
            if (((Button)object).mName.compareTo("Achievement") == 0) {
                this.mAchievementBox = object;
                this.mAchievementBox.mLabelColor = new Color(217, 255, 86, 255);
                continue;
            }
            if (((Button)object).mName.compareTo("Configure") == 0) {
                this.mGearButton = object;
                continue;
            }
            if (((Button)object).mName.equals("FastForward")) {
                this.mFastForwardButton = object;
                continue;
            }
            if (((Button)object).mName.compareTo("GatlingTower") == 0) {
                towerClass = (TowerClass)Map.getTowerClassList().elementAt(0);
                techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
                n2 = techLevel.mCost;
                ((Button)object).setLabelWithString("$" + n2);
                continue;
            }
            if (((Button)object).mName.compareTo("GooTower") == 0) {
                towerClass = (TowerClass)Map.getTowerClassList().elementAt(1);
                techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
                n2 = techLevel.mCost;
                ((Button)object).setLabelWithString("$" + n2);
                continue;
            }
            if (((Button)object).mName.compareTo("MissileTower") == 0) {
                towerClass = (TowerClass)Map.getTowerClassList().elementAt(2);
                techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
                n2 = techLevel.mCost;
                ((Button)object).setLabelWithString("$" + n2);
                continue;
            }
            if (((Button)object).mName.compareTo("LightningTower") == 0) {
                towerClass = (TowerClass)Map.getTowerClassList().elementAt(4);
                techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
                n2 = techLevel.mCost;
                ((Button)object).setLabelWithString("$" + n2);
                continue;
            }
            if (((Button)object).mName.compareTo("FlameTower") == 0) {
                towerClass = (TowerClass)Map.getTowerClassList().elementAt(3);
                techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
                n2 = techLevel.mCost;
                ((Button)object).setLabelWithString("$" + n2);
                continue;
            }
            if (((Button)object).mName.compareTo("MortarTower") == 0) {
                towerClass = (TowerClass)Map.getTowerClassList().elementAt(5);
                techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
                n2 = techLevel.mCost;
                ((Button)object).setLabelWithString("$" + n2);
                continue;
            }
            if (((Button)object).mName.compareTo("TutorialParent") != 0) continue;
            this.mTutorialParent = object;
            this.mTutorialParent.mIsHidden = true;
            this.mTutorialParent.mIsDisabled = true;
            this.mTutorialParent.mTrackParentPos = true;
        }
        for (n = 0; n < this.mOverlayList.size(); ++n) {
            object = (Overlay)this.mOverlayList.elementAt(n);
            if (((Overlay)object).mName.compareTo("VictoryText") == 0) {
                this.mVictoryTextOverlay = object;
                continue;
            }
            if (((Overlay)object).mName.compareTo("DefeatText") != 0) continue;
            this.mDefeatTextOverlay = object;
        }
        this.mResourcesText = new Text("", this.mView, 0.13f, 0.057f, tTextAlignmentType.kTextAlignmentType_Left, kHUDFontName, 7);
        this.mHealthText = new Text("", this.mView, 0.065f, 0.057f, tTextAlignmentType.kTextAlignmentType_Right, kHUDFontName, 7);
        this.mScoreText = new Text("", this.mView, 0.25f, 0.057f, tTextAlignmentType.kTextAlignmentType_Center, kHUDFontName, 7);
        this.mStatusText = new Text("", this.mView, 0.5f, 0.057f, tTextAlignmentType.kTextAlignmentType_Center, kHUDFontName, 7);
        this.mCursorPosition.x = this.mView.mMap.mMinBuildTileX;
        this.mCursorPosition.y = this.mView.mMap.mMinBuildTileY;
        Can.FIX_THAT_SCROLL = true;
    }

    public void queueAchievement(String string) {
        String string2 = string;
        this.mAchievementQueue.addElement(string2);
        this.mAchievementBoxParent.mIsHidden = false;
    }

    public CGPoint convertToWorldPosFromViewPos(CGPoint cGPoint) {
        CGPoint cGPoint2 = new CGPoint();
        cGPoint2.x = cGPoint.x - this.mViewPos.x;
        cGPoint2.y = cGPoint.y - this.mViewPos.y;
        return cGPoint2;
    }

    public CGPoint convertToViewPosFromWorldPos(float f, float f2) {
        CGPoint cGPoint = new CGPoint();
        cGPoint.x = f + this.mViewPos.x;
        cGPoint.y = f2 + this.mViewPos.y;
        return cGPoint;
    }

    public void buildTower(int n, Point point) {
        if (this.mSelectedTowerTileGridIndex != -1) {
            return;
        }
        Vector vector = Map.getTowerClassList();
        n = Math.min(n, vector.size() - 1);
        TowerClass towerClass = (TowerClass)vector.elementAt(n);
        TechLevel techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
        if (this.mView.mMap.mPlayer.mResources >= techLevel.mCost) {
            if (this.mTowerCursor != null) {
                this.mTowerCursor.setColor(255, 255, 255, 255);
                this.mView.mMap.buyTower(this.mTowerCursor);
                this.mTowerCursor = null;
            }
            this.mBuildTowerMenu.mTrackParentPos = true;
            CGPoint cGPoint = new CGPoint();
            cGPoint.x = point.x;
            cGPoint.y = point.y;
            CGPoint cGPoint2 = this.convertToWorldPosFromViewPos(cGPoint);
            int n2 = this.mView.mMap.getTileGridIndexForWorldPos((int)cGPoint2.x, (int)cGPoint2.y);
            if (n2 > 0) {
                cGPoint2 = this.mView.mMap.getWorldPosFromTileGridIndex(n2);
                Fieldrunners.mDisplay.vibrate(10);
                this.mTowerCursor = new Tower(towerClass, this.mView.mMap);
                this.mTowerCursor.mX = cGPoint2.x + (float)this.mView.mMap.mTileWidth * 0.5f;
                this.mTowerCursor.mY = cGPoint2.y + (float)this.mView.mMap.mTileHeight * 0.5f;
                this.mTowerCursor.mTileGridIndex = n2;
                this.mTowerCursorRangeIndicatorVisibility = 0.0f;
                this.mIsValidBuildLocation = this.mView.mMap.isValidBuildLocation(this.mTowerCursor.mTileGridIndex);
            }
        }
    }

    public int findSelectedTowerAtWorldPos(float f, float f2) {
        int n = this.mView.mMap.getTileGridIndexForWorldPos((int)f, (int)f2);
        Point point = this.mView.mMap.getTilePosFromTileGridIndex(n);
        float f3 = Float.MAX_VALUE;
        for (int i = Math.max(point.x - 1, this.mView.mMap.mMinBuildTileX); i <= Math.min(point.x + 1, this.mView.mMap.mMaxBuildTileX); ++i) {
            for (int j = Math.max(point.y - 1, this.mView.mMap.mMinBuildTileY); j <= Math.min(point.y + 1, this.mView.mMap.mMaxBuildTileY); ++j) {
                int n2 = this.mView.mMap.getTileGridIndexForTilePos(i, j);
                if (!this.mView.mMap.isTowerAtTileGridIndex(n2)) continue;
                CGPoint cGPoint = this.mView.mMap.getWorldPosFromTilePos(i, j);
                cGPoint.x += (float)this.mView.mMap.mTileWidth * 0.5f;
                cGPoint.y += (float)this.mView.mMap.mTileHeight * 0.5f;
                float f4 = (float)Math.sqrt(MathUtilities.SQUARE(cGPoint.x - f) + MathUtilities.SQUARE(cGPoint.y - f2));
                if (!(f4 < f3)) continue;
                f3 = f4;
                n = n2;
            }
        }
        return n;
    }

    public boolean isModifyTowerButtonInFocus() {
        return this.mActiveButton == this.mSellTowerButton || this.mActiveButton == this.mUpgradeTowerButton;
    }

    public void onButtonPressConfigure(Button button, Point point) {
        this.shouldShowLoadingBarNow = true;
        this.loadingBarStartTime = System.currentTimeMillis();
        this.mPlayorResume = 0;
        if (this.mTowerCursor != null) {
            this.mTowerCursor.setColor(255, 255, 255, 255);
            this.mTowerCursor = null;
            this.mTowerCursorIndex = -1;
        }
        this.exitOnNextTick = true;
    }

    public void exitToMenu() {
        this.mView.mMap.mGameState = tGameState.kGameState_Paused;
        this.mView.mMap.exitGame();
        this.mFastForwardButton.mIsToggled = false;
        this.mView.mMap.mGameState = tGameState.kGameState_Stopped;
        Can.FIX_THAT_SCROLL = true;
        try {
            this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kConfirmQuitGameFormNameID);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onButtonPressFastForward(Button button, Point point) {
        this.mView.mMap.mPlaybackSpeed = this.mView.mMap.mPlaybackSpeed == 1 ? 2 : 1;
    }

    public void onButtonPressPlayback(Button button, Point point) {
        try {
            if (this.mView.mMap.mGameState == tGameState.kGameState_Running) {
                this.pauseGame();
            } else {
                this.unPauseGame();
            }
            this.mLastGameState = this.mView.mMap.mGameState;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onButtonExitBuildGatlingTower(Button button, Point point) {
        if (this.mTowerCursor == null) {
            this.buildTower(0, point);
        }
    }

    public void onButtonExitBuildGooTower(Button button, Point point) {
        if (this.mTowerCursor == null) {
            this.buildTower(1, point);
        }
    }

    public void onButtonExitBuildMissileTower(Button button, Point point) {
        if (this.mTowerCursor == null) {
            this.buildTower(2, point);
        }
    }

    public void onButtonExitBuildLightningTower(Button button, Point point) {
        if (this.mTowerCursor == null) {
            this.buildTower(4, point);
        }
    }

    public void onButtonExitBuildFlameTower(Button button, Point point) {
        if (this.mTowerCursor == null) {
            this.buildTower(3, point);
        }
    }

    public void onButtonExitBuildMortarTower(Button button, Point point) {
        if (this.mTowerCursor == null) {
            this.buildTower(5, point);
        }
    }

    public void onButtonPressBuildGatlingTower(Button button, Point point) {
        if (this.mTowerCursorIndex == -1) {
            this.mTowerCursorIndex = 0;
        }
    }

    public void onButtonPressBuildGooTower(Button button, Point point) {
        if (this.mTowerCursorIndex == -1) {
            this.mTowerCursorIndex = 1;
        }
    }

    public void onButtonPressBuildMissileTower(Button button, Point point) {
        if (this.mTowerCursorIndex == -1) {
            this.mTowerCursorIndex = 2;
        }
    }

    public void onButtonPressBuildLightningTower(Button button, Point point) {
        if (this.mTowerCursorIndex == -1) {
            this.mTowerCursorIndex = 4;
        }
    }

    public void onButtonPressBuildFlameTower(Button button, Point point) {
        if (this.mTowerCursorIndex == -1) {
            this.mTowerCursorIndex = 3;
        }
    }

    public void onButtonPressBuildMortarTower(Button button, Point point) {
        if (this.mTowerCursorIndex == -1) {
            this.mTowerCursorIndex = 5;
        }
    }

    public void onButtonPressSellTower(Button button, Point point) {
        if (this.mSelectedTowerTileGridIndex != -1) {
            this.mView.mMap.sellTowerAtTileGridIndex(this.mSelectedTowerTileGridIndex);
            if (!this.mModifyTowerMenu.mTrackParentPos) {
                // empty if block
            }
            this.mModifyTowerMenu.mTrackParentPos = true;
            this.mSelectedTowerTileGridIndex = -1;
        }
    }

    public void onButtonPressUpgradeTower(Button button, Point point) {
        if (this.mSelectedTowerTileGridIndex != -1) {
            this.mView.mMap.upgradeTowerAtTileGridIndex(this.mSelectedTowerTileGridIndex);
            this.updateModifyTowerButtonLabelsForTowerAtTileGridIndex(this.mSelectedTowerTileGridIndex);
            this.mModifyTowerMenu.getClass();
            this.mModifyTowerMenu.mTrackParentPos = true;
            this.mSelectedTowerTileGridIndex = -1;
        }
    }

    public void onFormClose() {
        this.mView.mMap.mPlaybackSpeed = 1;
        this.mPlacingTower = false;
        this.mModifyingTower = false;
        this.mOpenMenu = false;
        this.mRectX = 48;
        this.mRectY = 48;
        this.mFirstDownMovement = true;
        this.mFirstUpMovement = true;
    }

    public void onFormOpen() {
        if (this.mView.mMap.mGameplayMode == 0) {
            this.switchUserInterfaceToClassicMode();
        }
        if (this.mView.mMap.mFilename.compareTo("grasslands") == 0 || this.mView.mMap.mFilename.compareTo("grasslands_extended") == 0) {
            Can.SOUNDPLAYER.playLoop(SoundPlayer.SOUND_GRASSLANDS);
        } else if (this.mView.mMap.mFilename.compareTo("crossroads") == 0 || this.mView.mMap.mFilename.compareTo("crossroads_extended") == 0) {
            Can.SOUNDPLAYER.playLoop(SoundPlayer.SOUND_CROSSROADS);
        } else if (this.mView.mMap.mFilename.compareTo("drylands") == 0 || this.mView.mMap.mFilename.compareTo("drylands_extended") == 0) {
            Can.SOUNDPLAYER.playLoop(SoundPlayer.SOUND_DRYLANDS);
        }
        this.showUnlockedGameplayFeatures();
        this.mShowEndGameText = false;
        this.mDefeatTextOverlay.mIsHidden = true;
        this.mVictoryTextOverlay.mIsHidden = true;
        this.shouldShowLoadingBarNow = false;
        this.mShowIt = false;
        this.loadingBarStartTime = 0L;
        super.onFormOpen();
    }

    public void renderDynamicTextWithElapsedTime(Graphics graphics, float f) {
        if (this.mView.mMap.mGameState == tGameState.kGameState_Paused) {
            f = 0.0f;
        }
        if (this.mResourcesText != null) {
            this.mResourcesText.renderShadowWithElapsedTime(graphics, f, 0.0035f);
            this.mResourcesText.renderWithElapsedTime(graphics, f);
        }
        if (this.mHealthText != null) {
            this.mHealthText.renderShadowWithElapsedTime(graphics, f, 0.0035f);
            this.mHealthText.renderWithElapsedTime(graphics, f);
        }
        if (this.mScoreText != null) {
            this.mScoreText.renderShadowWithElapsedTime(graphics, f, 0.0035f);
            this.mScoreText.renderWithElapsedTime(graphics, f);
        }
        if (this.mStatusText != null) {
            float f2;
            if (this.mStatusTextCurrentOpacity < this.mStatusTextTargetOpacity) {
                this.mStatusTextCurrentOpacity += f;
                if (this.mStatusTextCurrentOpacity >= this.mStatusTextTargetOpacity) {
                    this.mStatusTextCurrentOpacity = this.mStatusTextTargetOpacity;
                    this.mStatusTextTargetOpacity = 0.0f;
                }
                f2 = Math.min(this.mStatusTextCurrentOpacity, 0.4f);
                f2 /= 0.4f;
            } else {
                this.mStatusTextCurrentOpacity -= f;
                this.mStatusTextCurrentOpacity = Math.max(this.mStatusTextCurrentOpacity, this.mStatusTextTargetOpacity);
                f2 = Math.min(this.mStatusTextCurrentOpacity, 0.4f);
                f2 /= 0.4f;
            }
            if (f2 > 0.001f) {
                int n;
                this.mStatusText.mAlpha = n = (int)(f2 * 255.0f);
                this.mStatusText.renderShadowWithElapsedTime(graphics, f, 0.0035f);
                this.mStatusText.renderWithElapsedTime(graphics, f);
            } else {
                this.mStatusString = null;
            }
        }
    }

    public void renderEndGameTextWithElapsedTime(Graphics graphics, float f) {
        this.mEndGameTextOverlay.mHalfWidth = this.mEndGameTextOverlayHalfWidth * this.mEndGameTextScale;
        this.mEndGameTextOverlay.mHalfHeight = this.mEndGameTextOverlayHalfHeight * this.mEndGameTextScale;
        Color color = this.mEndGameTextOverlay.mColor;
        color.setA((int)(255.0f * Math.max(Math.min((4.0f - this.mEndGameTextDisplayTimer) * 2.0f, 1.0f), 0.0f)));
        this.mEndGameTextOverlay.mColor = color;
        int n = (Fieldrunners.mCanvas.getWidth() - this.mView.mLoadingImage.getWidth()) / 2;
        int n2 = (Fieldrunners.mCanvas.getHeight() - this.mView.mLoadingImage.getHeight()) / 2;
        if (this.mEndGameTextOverlay.mTextureImage != null) {
            graphics.drawImage(this.mEndGameTextOverlay.mTextureImage, n, n2, 0);
        }
    }

    public void renderStreamIndicatorArrowsWithElapsedTime(Graphics graphics, float f) {
        if (this.mView.mMap.mStreamIndicatorWaveIndex < 0 || this.mView.mMap.mStreamIndicatorWaveIndex >= this.mView.mMap.mWaves.size() || this.mView.mMap.mPathList.size() <= 1 || !this.mView.mMap.mShowStreamIndicatorArrows) {
            return;
        }
        Wave wave = (Wave)this.mView.mMap.mWaves.elementAt(this.mView.mMap.mStreamIndicatorWaveIndex);
        if (wave == null) {
            System.out.println("null wave");
            return;
        }
        for (int i = 0; i < wave.mStreams.size(); ++i) {
            Stream stream = (Stream)wave.mStreams.elementAt(i);
            Integer n = (Integer)((Path)this.mView.mMap.mPathList.elementAt((int)stream.mPathIndex)).mSpawnTiles.elementAt(0);
            Point point = this.mView.mMap.getTilePosFromTileGridIndex(n);
            int n2 = point.x * this.mView.mMap.mTileWidth;
            int n3 = point.y * this.mView.mMap.mTileWidth;
            this.mSpawnViewPos = this.mClampedSpawnViewPos = this.convertToViewPosFromWorldPos(n2, n3);
            if (this.mClampedSpawnViewPos.x < (float)LEFTMOST_ARROW_LOCATION) {
                this.mClampedSpawnViewPos.x = LEFTMOST_ARROW_LOCATION;
            }
            if (this.mClampedSpawnViewPos.x > (float)RIGHTMOST_ARROW_LOCATION) {
                this.mClampedSpawnViewPos.x = RIGHTMOST_ARROW_LOCATION;
            }
            if (this.mClampedSpawnViewPos.y < (float)UPMOST_ARROW_LOCATION) {
                this.mClampedSpawnViewPos.y = UPMOST_ARROW_LOCATION;
            }
            if (this.mClampedSpawnViewPos.y > (float)BOTTOMMOST_ARROW_LOCATION) {
                this.mClampedSpawnViewPos.y = BOTTOMMOST_ARROW_LOCATION;
            }
            this.mArrowDirection.x = 120.0f - this.mClampedSpawnViewPos.x;
            this.mArrowDirection.y = 160.0f - this.mClampedSpawnViewPos.y;
            this.mArrowDirection.normalize();
            if ((double)this.mArrowDirection.x < 0.2) {
                if (this.mArrowDirection.x < -0.4f) {
                    if (this.mStreamArrowUpRight == null) continue;
                    graphics.drawImage(this.mStreamArrowUpRight, (int)this.mClampedSpawnViewPos.x - 15, (int)this.mClampedSpawnViewPos.y - 3, 3);
                    continue;
                }
                if (this.mStreamArrow == null) continue;
                graphics.drawImage(this.mStreamArrow, (int)this.mClampedSpawnViewPos.x - 15, (int)this.mClampedSpawnViewPos.y - 3, 3);
                continue;
            }
            if ((double)this.mArrowDirection.y > 0.383) {
                if (this.mStreamArrowUpLeft == null) continue;
                graphics.drawImage(this.mStreamArrowUpLeft, (int)this.mClampedSpawnViewPos.x, (int)this.mClampedSpawnViewPos.y - 15, 3);
                continue;
            }
            if ((double)this.mArrowDirection.y < -0.383) {
                if (this.mStreamArrowDownLeft == null) continue;
                graphics.drawImage(this.mStreamArrowDownLeft, (int)this.mClampedSpawnViewPos.x, (int)this.mClampedSpawnViewPos.y - 15, 3);
                continue;
            }
            if (this.mStreamArrowLeft == null) continue;
            graphics.drawImage(this.mStreamArrowLeft, (int)this.mClampedSpawnViewPos.x, (int)this.mClampedSpawnViewPos.y - 15, 3);
        }
    }

    public void renderTowerCursorWithElapsedTime(Graphics graphics, float f) {
        if (this.mTowerCursor != null) {
            if (this.mTowerCursorIndex >= 0) {
                if (this.mTowerCursorRangeIndicatorVisibility < 0.001f) {
                    TowerClass.initRangeIndicatorVertexBuffersWithTower(this.mTowerCursor);
                }
                this.mTowerCursorRangeIndicatorVisibility += f * 5.0f;
                this.mTowerCursorRangeIndicatorVisibility = Math.min(this.mTowerCursorRangeIndicatorVisibility, 1.0f);
                if (this.mIsValidBuildLocation) {
                    this.mTowerCursor.setColor(255, 255, 255, 255);
                } else {
                    this.mTowerCursor.setColor(255, 0, 0, 255);
                }
                TowerClass.renderRangeIndicatorWithTower(this.mMapGraphics, this.mTowerCursor, this.mTowerCursorRangeIndicatorVisibility, !this.mIsValidBuildLocation);
                if ((this.totalTime & 0x100) == 0) {
                    this.mTowerCursor.renderWithElapsedTime(this.mMapGraphics, 0.0f);
                }
            } else {
                this.mTowerCursorRangeIndicatorVisibility -= f * 5.0f;
                this.mTowerCursorRangeIndicatorVisibility = Math.max(this.mTowerCursorRangeIndicatorVisibility, 0.0f);
                TowerClass.renderRangeIndicatorWithTower(this.mMapGraphics, this.mTowerCursor, this.mTowerCursorRangeIndicatorVisibility, false);
                if ((this.totalTime & 0x100) == 0) {
                    this.mTowerCursor.renderWithElapsedTime(this.mMapGraphics, 0.0f);
                }
                if (this.mTowerCursorRangeIndicatorVisibility <= 0.0f) {
                    this.mTowerCursor.setColor(255, 255, 255, 255);
                    this.mView.mMap.buyTower(this.mTowerCursor);
                    this.mTowerCursor = null;
                    this.mTowerCursorIndex = -1;
                }
            }
            this.mRenderDone = true;
        }
    }

    public void renderSpecialButtonsWithElapsedTime(Graphics graphics, float f) {
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (!button.mName.equals("AchievementParent") && !button.mName.equals("Achievement")) continue;
            button.mSkipLabelDraw = false;
            button.renderWithElapsedTime(graphics, f);
        }
    }

    public void renderButtonsWithElapsedTime(Graphics graphics, float f) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (button.mLabelText != null) {
                graphics.setColor(0, 0, 0);
                n = (int)(button.mLabelText.x * 240.0f);
                n2 = (int)(button.mLabelText.y * 320.0f);
            }
            int n3 = n - 8;
            int n4 = n2 - 12;
            int n5 = n + 7;
            int n6 = n2 + 16;
            if (button.mName.equals("GatlingTower")) {
                button.mSkipLabelDraw = true;
                button.renderWithElapsedTime(graphics, f);
                this.mNumberFont.DrawString(graphics, "1", n3, n4);
                this.mNumberFont.DrawString(graphics, button.mLabelText.mString, n5, n6);
            }
            if (button.mName.equals("GooTower")) {
                button.mSkipLabelDraw = true;
                button.renderWithElapsedTime(graphics, f);
                this.mNumberFont.DrawString(graphics, "2", n3, n4);
                this.mNumberFont.DrawString(graphics, button.mLabelText.mString, n5, n6);
            }
            if (button.mName.equals("MissileTower")) {
                button.mSkipLabelDraw = true;
                button.renderWithElapsedTime(graphics, f);
                this.mNumberFont.DrawString(graphics, "3", n3, n4);
                this.mNumberFont.DrawString(graphics, button.mLabelText.mString, n5, n6);
            }
            if (button.mName.equals("LightningTower")) {
                button.mSkipLabelDraw = true;
                button.renderWithElapsedTime(graphics, f);
                this.mNumberFont.DrawString(graphics, "5", n3, n4);
                this.mNumberFont.DrawString(graphics, button.mLabelText.mString, n5, n6);
            }
            if (button.mName.equals("FlameTower")) {
                button.mSkipLabelDraw = true;
                button.renderWithElapsedTime(graphics, f);
                this.mNumberFont.DrawString(graphics, "4", n3, n4);
                this.mNumberFont.DrawString(graphics, button.mLabelText.mString, n5, n6);
            }
            if (!button.mName.equals("MortarTower")) continue;
            button.mSkipLabelDraw = true;
            button.renderWithElapsedTime(graphics, f);
            this.mNumberFont.DrawString(graphics, "6", n3, n4);
            this.mNumberFont.DrawString(graphics, button.mLabelText.mString, n5 - 5, n6);
        }
    }

    public void renderWithElapsedTime(Graphics graphics, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        Tower tower;
        this.totalTime = (int)((float)this.totalTime + f * 1000.0f);
        if (Can.SOUNDPLAYER.mNeedSoundRestart && Can.SOUNDPLAYER.mNeedSoundRestartCount-- <= 0) {
            if (this.mView.mMap.mFilename.compareTo("grasslands") == 0 || this.mView.mMap.mFilename.compareTo("grasslands_extended") == 0) {
                Can.SOUNDPLAYER.playLoop(SoundPlayer.SOUND_GRASSLANDS);
            } else if (this.mView.mMap.mFilename.compareTo("crossroads") == 0 || this.mView.mMap.mFilename.compareTo("crossroads_extended") == 0) {
                Can.SOUNDPLAYER.playLoop(SoundPlayer.SOUND_CROSSROADS);
            } else {
                Can.SOUNDPLAYER.playLoop(SoundPlayer.SOUND_DRYLANDS);
            }
            Can.SOUNDPLAYER.mNeedSoundRestart = false;
        }
        if (Can.FIX_THAT_SCROLL) {
            this.updateCamera();
            Can.FIX_THAT_SCROLL = false;
        }
        this.mView.mMap.updateWithElapsedTime(f * (float)this.mView.mMap.mPlaybackSpeed);
        this.mView.mMap.renderWithElapsedTime(this.mMapGraphics, f * (float)this.mView.mMap.mPlaybackSpeed);
        if (!this.mModifyTowerMenu.mTrackParentPos) {
            tower = this.mView.mMap.getTowerAtTileGridIndex(this.mSelectedTowerTileGridIndex);
            if (tower != null) {
                if (this.mTowerCursorRangeIndicatorVisibility < 0.001f || this.mPreviouslySelectedTowerTileGridIndex != this.mSelectedTowerTileGridIndex) {
                    TowerClass.initRangeIndicatorVertexBuffersWithTower(tower);
                }
                this.mTowerCursorRangeIndicatorVisibility += f * 5.0f;
                this.mTowerCursorRangeIndicatorVisibility = Math.min(this.mTowerCursorRangeIndicatorVisibility, 1.0f);
                TowerClass.renderRangeIndicatorWithTower(this.mMapGraphics, tower, this.mTowerCursorRangeIndicatorVisibility, false);
                tower.renderWithElapsedTime(this.mMapGraphics, 0.0f);
            }
            this.mPreviouslySelectedTowerTileGridIndex = this.mSelectedTowerTileGridIndex;
        } else if (this.mTowerCursor == null && this.mPreviouslySelectedTowerTileGridIndex != -1) {
            this.mTowerCursorRangeIndicatorVisibility -= f * 5.0f;
            this.mTowerCursorRangeIndicatorVisibility = Math.max(this.mTowerCursorRangeIndicatorVisibility, 0.0f);
            if (this.mTowerCursorRangeIndicatorVisibility > 0.0f && (tower = this.mView.mMap.getTowerAtTileGridIndex(this.mPreviouslySelectedTowerTileGridIndex)) != null) {
                TowerClass.renderRangeIndicatorWithTower(this.mMapGraphics, tower, this.mTowerCursorRangeIndicatorVisibility, false);
                tower.renderWithElapsedTime(this.mMapGraphics, 0.0f);
            }
        }
        this.renderStreamIndicatorArrowsWithElapsedTime(graphics, f);
        if (this.mFormType != tFormType.kFormType_Overlay) {
            super.renderForm(graphics);
        }
        this.renderOverlays(graphics);
        this.renderDynamicTextWithElapsedTime(graphics, f);
        if (this.mShowEndGameText) {
            this.renderEndGameTextWithElapsedTime(graphics, f);
        }
        this.renderTowerCursorWithElapsedTime(graphics, f);
        if (this.mOpenMenu) {
            this.mTowerFlasher.mX = (float)(this.mRectX + 12) - this.mViewPos.x;
            this.mTowerFlasher.mY = (float)(this.mRectY + 12) - this.mViewPos.y;
            this.mTowerFlasher.mTileGridIndex = this.mView.mMap.getTileGridIndexForWorldPos((int)this.mTowerFlasher.mX, (int)this.mTowerFlasher.mY);
            if (this.mView.mMap.mPlayer.mResources > 4) {
                TowerClass.renderRangeIndicatorWithTower(this.mMapGraphics, this.mTowerFlasher, this.mTowerCursorRangeIndicatorVisibility, !this.mView.mMap.isValidBuildLocation(this.mTowerFlasher.mTileGridIndex));
            }
            this.renderButtonsWithElapsedTime(graphics, f);
        } else {
            this.renderSpecialButtonsWithElapsedTime(graphics, f);
        }
        if (this.mModifyingTower) {
            graphics.setColor(0, 0, 0);
            if (this.mUpgradeTowerButton.mLabelText != null && !this.mUpgradeTowerButton.mIsHidden) {
                int n5 = (int)(this.mUpgradeTowerButton.mLabelText.x * 240.0f);
                n4 = (int)(this.mUpgradeTowerButton.mLabelText.y * 320.0f);
                n3 = n5 - 6;
                n2 = n4 - 9;
                n = n5 + 3;
                int n6 = n4 + 19;
                this.mUpgradeTowerButton.mSkipLabelDraw = true;
                this.mUpgradeTowerButton.renderWithElapsedTime(graphics, f);
                this.mNumberFont.DrawString(graphics, "9", n3, n2);
                this.mNumberFont.DrawString(graphics, this.mUpgradeTowerButton.mLabelText.mString, n, n6);
            }
            if (this.mSellTowerButton.mLabelText != null && !this.mSellTowerButton.mIsHidden) {
                int n7 = (int)(this.mSellTowerButton.mLabelText.x * 240.0f);
                n4 = (int)(this.mSellTowerButton.mLabelText.y * 320.0f);
                n3 = n7 - 2;
                n2 = n4 + 19;
                this.mSellTowerButton.mSkipLabelDraw = true;
                this.mSellTowerButton.renderWithElapsedTime(graphics, f);
                this.mNumberFont.DrawString(graphics, this.mSellTowerButton.mLabelText.mString, n3, n2);
            }
        }
        if (this.mGearButton != null) {
            this.mGearButton.renderWithElapsedTime(graphics, f);
        }
        if (this.mPlaybackButton != null) {
            this.mPlaybackButton.renderWithElapsedTime(graphics, f);
        }
        if (this.mFastForwardButton != null && !this.mFastForwardButton.mIsHidden) {
            this.mFastForwardButton.renderWithElapsedTime(graphics, f);
        }
        int n8 = this.mView.mMap.getTileGridIndexForTilePos(this.mCursorPosition.x, this.mCursorPosition.y);
        if (this.mOpenMenu && (this.totalTime & 0x100) == 0 && this.mView.mMap.mPlayer.mResources > 4) {
            this.mTowerFlasher.renderWithElapsedTime(this.mMapGraphics, f);
        }
        if (!this.mShowEndGameText) {
            if (!this.mView.mMap.isValidBuildLocation(n8) && this.mTowerCursor != null) {
                graphics.drawImage(this.mNaughtyCursor, this.mRectX + 12, this.mRectY + 12, 3);
            } else {
                graphics.drawImage(this.mNiceCursor, this.mRectX + 12, this.mRectY + 12, 3);
            }
        }
        if (this.exitOnNextTick) {
            if (this.shouldShowLoadingBarNow) {
                n4 = (Fieldrunners.mCanvas.getWidth() - this.mView.mLoadingImage.getWidth()) / 2;
                n3 = (Fieldrunners.mCanvas.getHeight() - this.mView.mLoadingImage.getHeight()) / 2;
                n2 = n4;
                n = n3;
                graphics.drawImage(this.mView.mLoadingImage, n4, n3, 0);
                long l = System.currentTimeMillis() - this.loadingBarStartTime;
                float f2 = (float)l / 370.0f;
                graphics.setClip(n4 + 25, n3 + 17, (int)((float)(n4 + 25) + 150.0f * f2), n3 + 27);
                if (this.mShowIt) {
                    graphics.drawImage(this.mView.mLoadingBar, n2, n, 0);
                    this.mShowIt = false;
                } else {
                    graphics.drawImage(this.mView.mLoadingBar2, n2, n, 0);
                    this.mShowIt = true;
                }
                graphics.setClip(0, 0, Can.VIEW_X, Can.VIEW_Y);
            }
            if (this.loadingBarStartTime != 0L && System.currentTimeMillis() - this.loadingBarStartTime > 370L) {
                this.shouldShowLoadingBarNow = false;
                this.loadingBarStartTime = 0L;
                this.exitToMenu();
                this.exitOnNextTick = false;
            }
        }
    }

    public void renderOverlays(Graphics graphics) {
        if (!this.mOverlayList.isEmpty()) {
            int n = this.mOverlayList.size();
            for (int i = 0; i < n; ++i) {
                Overlay overlay = (Overlay)this.mOverlayList.elementAt(i);
                if (overlay.mName.equals("DefeatText") || overlay.mName.equals("VictoryText") || overlay.mIsHidden || overlay.mTextureImage == null) continue;
                int n2 = (int)((float)Fieldrunners.mCanvas.getWidth() * overlay.mCenterX);
                int n3 = (int)((float)Fieldrunners.mCanvas.getHeight() * overlay.mCenterY);
                graphics.drawImage(overlay.mTextureImage, n2, n3, 3);
            }
        }
    }

    public void serializeWithBinaryFile(GameState gameState) {
        this.mViewPos.x = gameState.SERIALIZE(this.mViewPos.x);
        this.mViewPos.y = gameState.SERIALIZE(this.mViewPos.y);
        this.mCursorPosition.x = gameState.SERIALIZE(this.mCursorPosition.x);
        this.mCursorPosition.y = gameState.SERIALIZE(this.mCursorPosition.y);
        if (gameState.isLoading()) {
            String string = "Paused";
            this.setStatusString(string, 0.0f, true);
            this.mPlaybackButton.mIsToggled = true;
        }
        this.mFirstTouch = false;
        this.updateView();
    }

    public void pressedSelect(Point point) {
        this.mKeyViewPos.x = this.mRectX + this.mRectMidDelta;
        this.mKeyViewPos.y = this.mRectY + this.mRectMidDeltay;
        CGPoint cGPoint = this.convertToWorldPosFromViewPos(this.mKeyViewPos);
        if (this.mPlacingTower) {
            this.mPlacingTower = false;
        } else if (this.mOpenMenu) {
            this.mTowerCursorIndex = this.mSelectButtonPos;
            switch (this.mTowerCursorIndex) {
                case 0: {
                    this.mTowerKeyPressed = "GatlingTower";
                    break;
                }
                case 1: {
                    this.mTowerKeyPressed = "GooTower";
                    break;
                }
                case 2: {
                    this.mTowerKeyPressed = "MissileTower";
                    break;
                }
                case 4: {
                    this.mTowerKeyPressed = "LightningTower";
                    break;
                }
                case 3: {
                    this.mTowerKeyPressed = "FlameTower";
                    break;
                }
                case 5: {
                    this.mTowerKeyPressed = "MortarTower";
                }
            }
            this.doSetTowerBuild(point);
            this.mPlacingTower = true;
            this.mOpenMenu = false;
        } else {
            int n = this.mView.mMap.getTileGridIndexForWorldPos((int)cGPoint.x, (int)cGPoint.y);
            if (this.mView.mMap.isTowerAtTileGridIndex(n) && !this.mModifyingTower) {
                this.mModifyingTower = true;
            } else if (this.mModifyingTower) {
                if (this.mSellTowerButton.mState == tButtonState.kButtonState_Selected) {
                    this.onButtonPressSellTower(this.mSellTowerButton, point);
                }
                if (this.mUpgradeTowerButton.mState == tButtonState.kButtonState_Selected) {
                    this.onButtonPressUpgradeTower(this.mUpgradeTowerButton, point);
                }
                this.mSellTowerButton.mState = tButtonState.kButtonState_Enabled;
                this.mUpgradeTowerButton.mState = tButtonState.kButtonState_Enabled;
                this.mModifyingTower = false;
            } else if (!this.mOpenMenu) {
                this.mOpenMenu = true;
                this.mSelectButtonPos = 0;
                this.setCurrentTowerFlasher();
                this.activateButton();
            }
        }
    }

    public void setStatusString(String string) {
        this.setStatusString(string, 3.0f, false);
    }

    public void setStatusString(String string, float f, boolean bl) {
        try {
            if (string == null) {
                this.mStatusTextCurrentOpacity = this.mStatusTextSavedOpacity;
                this.mStatusTextTargetOpacity = 0.0f;
                this.mStatusString = this.mStatusStringSaved;
                this.mStatusStringSaved = null;
            } else {
                if (this.mStatusString == null) {
                    this.mStatusTextTargetOpacity = f * 0.5f;
                    this.mStatusTextCurrentOpacity = 0.0f;
                }
                if (bl) {
                    this.mStatusTextSavedOpacity = this.mStatusTextCurrentOpacity;
                    this.mStatusStringSaved = null;
                    this.mStatusStringSaved = this.mStatusString;
                    this.mStatusTextCurrentOpacity = Math.max(1.0f, this.mStatusTextCurrentOpacity);
                }
                if (this.mStatusString != null) {
                    if (this.mStatusString.compareTo(string) != 0) {
                        if (this.mStatusString != null) {
                            this.mStatusString = null;
                        }
                        this.mStatusString = string != null ? string : null;
                        this.mStatusTextTargetOpacity = f * 0.5f;
                    }
                } else {
                    this.mStatusString = string != null ? string : null;
                    this.mStatusTextTargetOpacity = f * 0.5f;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showEndGameText(boolean bl) {
        this.mFastForwardButton.mIsHidden = true;
        this.mPlaybackButton.mIsHidden = true;
        this.mGearButton.mIsHidden = true;
        this.mFastForwardButton.mIsToggled = false;
        if (!this.mShowEndGameText) {
            this.mShowEndGameText = true;
            this.shouldShowLoadingBarNow = true;
            this.loadingBarStartTime = System.currentTimeMillis();
            this.mPlayorResume = 0;
            this.mEndGameTextOverlay = bl ? this.mVictoryTextOverlay : this.mDefeatTextOverlay;
            this.mEndGameTextOverlay.mIsHidden = false;
            this.mEndGameTextDisplayTimer = 4.0f;
            this.mEndGameTextDisplayTimerHasExpired = false;
            this.mEndGameTextScale = 3.0f;
            Color color = this.mEndGameTextOverlay.mColor;
            color.setA(0);
            this.mEndGameTextOverlay.mColor = color;
            this.mEndGameTextOverlayHalfWidth = this.mEndGameTextOverlay.mHalfWidth;
            this.mEndGameTextOverlayHalfHeight = this.mEndGameTextOverlay.mHalfHeight;
            this.mView.mMap.handleGameEnd();
        }
    }

    public void showUnlockedGameplayFeatures() {
        this.restoreHudButtons();
        this.mFastForwardButton.mIsHidden = !Map.isGameplayFeatureUnlocked(tGameplayFeature.kGameplayFeature_FastForward, this.mView.mMap.mName);
    }

    public void switchUserInterfaceToClassicMode() {
    }

    public void handleButtonPressAction(Button button, Point point) {
        if (button != null) {
            String string = button.mPressSelector;
            if (string.compareTo("onButtonPressBuildGatlingTower:withTouches:withEvent:") == 0) {
                this.onButtonPressBuildGatlingTower(button, point);
            } else if (string.compareTo("onButtonPressBuildGooTower:withTouches:withEvent:") == 0) {
                this.onButtonPressBuildGooTower(button, point);
            } else if (string.compareTo("onButtonPressBuildMissileTower:withTouches:withEvent:") == 0) {
                this.onButtonPressBuildMissileTower(button, point);
            } else if (string.compareTo("onButtonPressBuildLightningTower:withTouches:withEvent:") == 0) {
                this.onButtonPressBuildLightningTower(button, point);
            } else if (string.compareTo("onButtonPressBuildFlameTower:withTouches:withEvent:") == 0) {
                this.onButtonPressBuildFlameTower(button, point);
            } else if (string.compareTo("onButtonPressBuildMortarTower:withTouches:withEvent:") == 0) {
                this.onButtonPressBuildMortarTower(button, point);
            } else if (string.compareTo("onButtonPressConfigure:withTouches:withEvent:") == 0) {
                this.onButtonPressConfigure(button, point);
            } else if (string.compareTo("onButtonPressFastForward:withTouches:withEvent:") == 0) {
                this.onButtonPressFastForward(button, point);
            } else if (string.compareTo("onButtonPressPlayback:withTouches:withEvent:") == 0) {
                this.onButtonPressPlayback(button, point);
            } else if (string.compareTo("onButtonPressSellTower:withTouches:withEvent:") == 0) {
                this.onButtonPressSellTower(button, point);
            } else if (string.compareTo("onButtonPressUpgradeTower:withTouches:withEvent:") == 0) {
                this.onButtonPressUpgradeTower(button, point);
            }
        }
    }

    public boolean doSetTowerBuild(Point point) {
        boolean bl = false;
        if (!this.mTowerKeyPressed.equals("")) {
            for (int i = 0; i < this.mButtonList.size(); ++i) {
                Button button = (Button)this.mButtonList.elementAt(i);
                if (!button.mName.equalsIgnoreCase(this.mTowerKeyPressed) || button.mIsHidden || button.mIsDisabled) continue;
                bl = true;
                this.mPressedButton = button;
                this.mActiveButton = button;
                if (button.mPressSelector != null) {
                    this.handleButtonPressAction(button, point);
                    this.mItATower = true;
                    if (button.mIsToggleable) {
                        button.mIsToggled = !button.mIsToggled;
                    }
                }
                button.mState = tButtonState.kButtonState_Pressed;
                this.mOpenMenu = false;
                break;
            }
        }
        return bl;
    }

    public void activateButton() {
        Object object;
        TowerClass towerClass;
        String string = "GatlingTower";
        boolean bl = false;
        if (this.mSelectButtonPos == 0) {
            string = "GatlingTower";
            towerClass = (TowerClass)Map.getTowerClassList().elementAt(0);
            object = (TechLevel)towerClass.mTechLevels.elementAt(0);
            bl = this.mView.mMap.mPlayer.mResources >= ((TechLevel)object).mCost;
        } else if (this.mSelectButtonPos == 1) {
            string = "GooTower";
            towerClass = (TowerClass)Map.getTowerClassList().elementAt(1);
            object = (TechLevel)towerClass.mTechLevels.elementAt(0);
            bl = this.mView.mMap.mPlayer.mResources >= ((TechLevel)object).mCost;
        } else if (this.mSelectButtonPos == 2) {
            string = "MissileTower";
            towerClass = (TowerClass)Map.getTowerClassList().elementAt(2);
            object = (TechLevel)towerClass.mTechLevels.elementAt(0);
            bl = this.mView.mMap.mPlayer.mResources >= ((TechLevel)object).mCost;
        } else if (this.mSelectButtonPos == 3) {
            string = "FlameTower";
            towerClass = (TowerClass)Map.getTowerClassList().elementAt(4);
            object = (TechLevel)towerClass.mTechLevels.elementAt(0);
            boolean bl2 = bl = this.mView.mMap.mPlayer.mResources >= ((TechLevel)object).mCost;
        }
        if (this.mSelectButtonPos == 4) {
            string = "LightningTower";
            towerClass = (TowerClass)Map.getTowerClassList().elementAt(3);
            object = (TechLevel)towerClass.mTechLevels.elementAt(0);
            boolean bl3 = bl = this.mView.mMap.mPlayer.mResources >= ((TechLevel)object).mCost;
        }
        if (this.mSelectButtonPos == 5) {
            string = "MortarTower";
            towerClass = (TowerClass)Map.getTowerClassList().elementAt(5);
            object = (TechLevel)towerClass.mTechLevels.elementAt(0);
            boolean bl4 = bl = this.mView.mMap.mPlayer.mResources >= ((TechLevel)object).mCost;
        }
        if (bl) {
            for (int i = 0; i < this.mButtonList.size(); ++i) {
                object = (Button)this.mButtonList.elementAt(i);
                ((Button)object).mState = tButtonState.kButtonState_Enabled;
                if (!((Button)object).mName.equals(string)) continue;
                ((Button)object).mState = tButtonState.kButtonState_Selected;
                this.mSelectedByMenu = true;
            }
        }
    }

    public boolean canAffordTower(int n) {
        TowerClass towerClass = (TowerClass)Map.getTowerClassList().elementAt(n);
        TechLevel techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
        boolean bl = this.mView.mMap.mPlayer.mResources >= techLevel.mCost;
        return bl;
    }

    public void updateCamera() {
        int n = this.mView.width() / 2 - 12;
        int n2 = this.mView.height() / 2 - 12;
        Map map = this.mView.mMap;
        CGPoint cGPoint = map.getWorldPosFromTilePos(this.mCursorPosition.x, this.mCursorPosition.y);
        this.mViewPos.x = (float)n - cGPoint.x;
        this.mViewPos.y = (float)n2 - cGPoint.y;
        if (this.mViewPos.x > 0.0f) {
            this.mViewPos.x = 0.0f;
        }
        if (this.mViewPos.y > 0.0f) {
            this.mViewPos.y = 0.0f;
        }
        if (this.mViewPos.x + (float)map.mImageWidth < (float)this.mView.width()) {
            this.mViewPos.x = this.mView.width() - map.mImageWidth;
        }
        if (this.mViewPos.y + (float)map.mImageHeight < (float)this.mView.height()) {
            this.mViewPos.y = this.mView.height() - map.mImageHeight;
        }
        this.mRectX = (int)(this.mViewPos.x + cGPoint.x);
        this.mRectY = (int)(this.mViewPos.y + cGPoint.y);
    }

    private void changeCursorPosition(int n, int n2) {
        int n3;
        int n4 = this.mCursorPosition.x + n;
        int n5 = this.mCursorPosition.y + n2;
        if (n4 > this.mView.mMap.mMaxBuildTileX) {
            n4 = this.mView.mMap.mMaxBuildTileX;
        }
        if (n4 < this.mView.mMap.mMinBuildTileX) {
            n4 = this.mView.mMap.mMinBuildTileX;
        }
        if (n5 > this.mView.mMap.mMaxBuildTileY) {
            n5 = this.mView.mMap.mMaxBuildTileY;
        }
        if (n5 < this.mView.mMap.mMinBuildTileY) {
            n5 = this.mView.mMap.mMinBuildTileY;
        }
        if (this.mView.mMap.mTileGrid[n3 = this.mView.mMap.getTileGridIndexForTilePos(n4, n5)] == Entity.dummyEntity()) {
            return;
        }
        this.mCursorPosition.x = n4;
        this.mCursorPosition.y = n5;
        this.updateCamera();
    }

    public void testForwardselect() {
        block19: {
            int n;
            block18: {
                n = this.mView.mMap.mPlayer.mResources;
                ++this.mSelectButtonPos;
                if (this.mUserInterface.mActiveBackgroundFormName.compareTo(UserInterface.kGameHudExtendedFormName) != 0) break block18;
                switch (this.mSelectButtonPos) {
                    case 6: {
                        this.mSelectButtonPos = 0;
                    }
                    default: {
                        break;
                    }
                    case 1: {
                        if (n < 10) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block19;
                    }
                    case 2: {
                        if (n < 20) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block19;
                    }
                    case 3: {
                        if (n < 50) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block19;
                    }
                    case 4: {
                        if (n < 70) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block19;
                    }
                    case 5: {
                        if (n < 120) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block19;
                    }
                }
                break block19;
            }
            switch (this.mSelectButtonPos) {
                default: {
                    this.mSelectButtonPos = 0;
                    break;
                }
                case 1: {
                    if (n >= 10) break;
                    this.mSelectButtonPos = 0;
                    break;
                }
                case 2: {
                    if (n >= 20) break;
                    this.mSelectButtonPos = 0;
                    break;
                }
                case 3: 
                case 4: {
                    this.mSelectButtonPos = n < 70 ? 0 : 4;
                }
            }
        }
        this.setCurrentTowerFlasher();
    }

    public void testBackwardselect() {
        block30: {
            int n;
            block29: {
                n = this.mView.mMap.mPlayer.mResources;
                --this.mSelectButtonPos;
                if (this.mUserInterface.mActiveBackgroundFormName.compareTo(UserInterface.kGameHudExtendedFormName) != 0) break block29;
                switch (this.mSelectButtonPos) {
                    default: {
                        break;
                    }
                    case 1: {
                        if (n < 10) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block30;
                    }
                    case 2: {
                        if (n < 20 && n >= 10) {
                            this.mSelectButtonPos = 1;
                            break;
                        }
                        if (n < 10) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block30;
                    }
                    case 3: {
                        if (n < 50 && n >= 20) {
                            this.mSelectButtonPos = 2;
                            break;
                        }
                        if (n < 20 && n >= 10) {
                            this.mSelectButtonPos = 1;
                            break;
                        }
                        if (n < 10) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block30;
                    }
                    case 4: {
                        if (n < 70 && n >= 50) {
                            this.mSelectButtonPos = 3;
                            break;
                        }
                        if (n < 50 && n >= 20) {
                            this.mSelectButtonPos = 2;
                            break;
                        }
                        if (n < 20 && n >= 10) {
                            this.mSelectButtonPos = 1;
                            break;
                        }
                        if (n < 10) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        break block30;
                    }
                    case -1: 
                    case 5: {
                        if (n < 120 && n >= 70) {
                            this.mSelectButtonPos = 4;
                        }
                        if (n < 70 && n >= 50) {
                            this.mSelectButtonPos = 3;
                            break;
                        }
                        if (n < 50 && n >= 20) {
                            this.mSelectButtonPos = 2;
                            break;
                        }
                        if (n < 20 && n >= 10) {
                            this.mSelectButtonPos = 1;
                            break;
                        }
                        if (n < 10) {
                            this.mSelectButtonPos = 0;
                            break;
                        }
                        this.mSelectButtonPos = 5;
                        break;
                    }
                }
                break block30;
            }
            switch (this.mSelectButtonPos) {
                default: {
                    break;
                }
                case 1: {
                    if (n >= 10) break;
                    this.mSelectButtonPos = 0;
                    break;
                }
                case 2: 
                case 3: {
                    if (n < 20 && n >= 10) {
                        this.mSelectButtonPos = 1;
                        break;
                    }
                    if (n < 10) {
                        this.mSelectButtonPos = 0;
                        break;
                    }
                    this.mSelectButtonPos = 2;
                    break;
                }
                case -1: {
                    this.mSelectButtonPos = n < 70 && n >= 20 ? 2 : (n < 70 && n >= 10 ? 1 : (n < 10 ? 0 : 4));
                }
            }
        }
        this.setCurrentTowerFlasher();
    }

    public void setCurrentTowerFlasher() {
        this.mTowerFlasherIndex = this.mSelectButtonPos;
        Vector vector = Map.getTowerClassList();
        TowerClass towerClass = (TowerClass)vector.elementAt(this.mTowerFlasherIndex);
        if (this.mTowerFlasher != null) {
            this.mTowerFlasher.mTowerClass = towerClass;
            this.mTowerFlasher.mClass = towerClass;
            this.mTowerFlasher.mAnimationController = null;
            this.mTowerFlasher.mAnimationController = new AnimationController(towerClass.mSprite);
        }
        switch (this.mSelectButtonPos) {
            case 0: 
            case 3: {
                this.mTowerFlasher.mTechLevel.mAttackRadius = 54.0f;
                break;
            }
            case 1: 
            case 4: {
                this.mTowerFlasher.mTechLevel.mAttackRadius = 62.0f;
                break;
            }
            case 2: {
                this.mTowerFlasher.mTechLevel.mAttackRadius = 90.0f;
                break;
            }
            case 5: {
                this.mTowerFlasher.mTechLevel.mAttackRadius = 109.0f;
            }
        }
    }

    public void setCurrentTowerCursor(int n) {
        this.mTowerCursorIndex = n;
        Vector vector = Map.getTowerClassList();
        TowerClass towerClass = (TowerClass)vector.elementAt(n);
        if (this.mTowerCursor != null) {
            TechLevel techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
            if (techLevel.mCost <= this.mView.mMap.mPlayer.mResources) {
                this.mTowerCursor.mTechLevel = techLevel;
                this.mTowerCursor.mTowerClass = towerClass;
                this.mTowerCursor.mClass = towerClass;
                this.mTowerCursor.mAnimationController = null;
                this.mTowerCursor.mAnimationController = new AnimationController(towerClass.mSprite);
            }
        }
    }

    public void touchStart(Point point) {
        try {
            int n;
            Object object;
            if (this.mFirstTouch) {
                this.mFirstTouch = false;
                this.unPauseGame();
                this.mPlaybackButton.mIsToggled = false;
                return;
            }
            int n2 = this.mTowerCursorIndex;
            if (Key.mPressed == 2) {
                if (this.mPlacingTower) {
                    if (this.mTowerCursorIndex == 0) {
                        this.pressedSelect(point);
                    } else {
                        this.setCurrentTowerCursor(0);
                    }
                } else if (!this.mPlacingTower && this.mView.mMap.mPlayer.mResources >= 5) {
                    this.mTowerKeyPressed = "GatlingTower";
                    this.mTowerCursorIndex = 0;
                    if (this.doSetTowerBuild(point)) {
                        this.mPlacingTower = true;
                    }
                }
            } else if (Key.mPressed == 4) {
                if (this.mPlacingTower) {
                    if (this.mTowerCursorIndex == 1) {
                        this.pressedSelect(point);
                    } else {
                        this.setCurrentTowerCursor(1);
                    }
                } else if (!this.mPlacingTower && this.mView.mMap.mPlayer.mResources >= 10) {
                    this.mTowerKeyPressed = "GooTower";
                    this.mTowerCursorIndex = 1;
                    if (this.doSetTowerBuild(point)) {
                        this.mPlacingTower = true;
                    }
                }
            } else if (Key.mPressed == 8) {
                if (this.mPlacingTower) {
                    if (this.mTowerCursorIndex == 2) {
                        this.pressedSelect(point);
                    } else {
                        this.setCurrentTowerCursor(2);
                    }
                } else if (!this.mPlacingTower && this.mView.mMap.mPlayer.mResources >= 20) {
                    this.mTowerKeyPressed = "MissileTower";
                    this.mTowerCursorIndex = 2;
                    if (this.doSetTowerBuild(point)) {
                        this.mPlacingTower = true;
                    }
                }
            } else if (Key.mPressed == 32) {
                if (this.mPlacingTower) {
                    if (this.mTowerCursorIndex == 4) {
                        this.pressedSelect(point);
                    } else {
                        this.setCurrentTowerCursor(4);
                    }
                } else if (!this.mPlacingTower && this.mView.mMap.mPlayer.mResources >= 70) {
                    this.mTowerKeyPressed = "LightningTower";
                    this.mTowerCursorIndex = 4;
                    if (this.doSetTowerBuild(point)) {
                        this.mPlacingTower = true;
                    }
                }
            } else if (Key.mPressed == 16 && this.mUserInterface.mActiveBackgroundFormName.compareTo(UserInterface.kGameHudExtendedFormName) == 0) {
                if (this.mPlacingTower) {
                    if (this.mTowerCursorIndex == 3) {
                        this.pressedSelect(point);
                    } else {
                        this.setCurrentTowerCursor(3);
                    }
                } else if (!this.mPlacingTower && this.mView.mMap.mPlayer.mResources >= 50) {
                    this.mTowerKeyPressed = "FlameTower";
                    this.mTowerCursorIndex = 3;
                    if (this.doSetTowerBuild(point)) {
                        this.mPlacingTower = true;
                    }
                }
            } else if (Key.mPressed == 64 && this.mUserInterface.mActiveBackgroundFormName.compareTo(UserInterface.kGameHudExtendedFormName) == 0) {
                if (this.mPlacingTower) {
                    if (this.mTowerCursorIndex == 5) {
                        this.pressedSelect(point);
                    } else {
                        this.setCurrentTowerCursor(5);
                    }
                } else if (!this.mPlacingTower && this.mView.mMap.mPlayer.mResources >= 120) {
                    this.mTowerKeyPressed = "MortarTower";
                    this.mTowerCursorIndex = 5;
                    if (this.doSetTowerBuild(point)) {
                        this.mPlacingTower = true;
                    }
                }
            } else if (Key.mPressed == 512) {
                if (this.mModifyingTower) {
                    this.mModifyingTower = false;
                }
                this.mKeyViewPos.x = this.mRectX + this.mRectMidDelta;
                this.mKeyViewPos.y = this.mRectY + this.mRectMidDeltay;
                object = this.convertToWorldPosFromViewPos(this.mKeyViewPos);
                n = this.mView.mMap.getTileGridIndexForWorldPos((int)((CGPoint)object).x, (int)((CGPoint)object).y);
                if (this.mView.mMap.isTowerAtTileGridIndex(n)) {
                    this.mSelectedTowerTileGridIndex = n;
                    this.onButtonPressUpgradeTower(this.mUpgradeTowerButton, point);
                }
            } else if (Key.mPressed == 1) {
                if (!this.mFastForwardButton.mIsHidden) {
                    if (this.mFastForwardButton.mIsToggled) {
                        this.mFastForwardButton.mIsToggled = false;
                        this.mView.mMap.mPlaybackSpeed = 1;
                    } else {
                        this.mFastForwardButton.mIsToggled = true;
                        this.mView.mMap.mPlaybackSpeed = 2;
                    }
                }
            } else if (Key.mPressed == 262144) {
                if (this.mModifyingTower) {
                    this.mSellTowerButton.mState = tButtonState.kButtonState_Selected;
                    this.mUpgradeTowerButton.mState = tButtonState.kButtonState_Enabled;
                } else if (this.mOpenMenu) {
                    this.testBackwardselect();
                    this.activateButton();
                } else {
                    this.changeCursorPosition(-1, 0);
                    if (this.mPlacingTower) {
                        this.mCursorPoint.x = this.mRectX;
                        this.mCursorPoint.y = this.mRectY;
                        this.moveTowerCursor(this.mCursorPoint);
                        this.mRenderDone = false;
                    }
                }
            } else if (Key.mPressed == 65536) {
                if (this.mOpenMenu) {
                    this.testForwardselect();
                    this.activateButton();
                } else {
                    this.changeCursorPosition(0, -1);
                }
                if (this.mPlacingTower) {
                    this.mCursorPoint.x = this.mRectX;
                    this.mCursorPoint.y = this.mRectY;
                    this.moveTowerCursor(this.mCursorPoint);
                    this.mRenderDone = false;
                } else if (this.mModifyingTower) {
                    this.mSellTowerButton.mState = tButtonState.kButtonState_Enabled;
                    this.mUpgradeTowerButton.mState = tButtonState.kButtonState_Enabled;
                    this.mModifyingTower = false;
                }
            } else if (Key.mPressed == 524288) {
                if (this.mModifyingTower) {
                    this.mSellTowerButton.mState = tButtonState.kButtonState_Enabled;
                    this.mUpgradeTowerButton.mState = tButtonState.kButtonState_Selected;
                } else if (this.mOpenMenu) {
                    this.testForwardselect();
                    this.activateButton();
                } else {
                    this.changeCursorPosition(1, 0);
                    if (this.mPlacingTower) {
                        object = new Point(this.mRectX, this.mRectY);
                        this.moveTowerCursor((Point)object);
                    }
                }
            } else if (Key.mPressed == 131072) {
                if (this.mOpenMenu) {
                    this.testBackwardselect();
                    this.activateButton();
                } else {
                    this.changeCursorPosition(0, 1);
                }
                if (this.mPlacingTower) {
                    object = new Point(this.mRectX, this.mRectY);
                    this.moveTowerCursor((Point)object);
                } else if (this.mModifyingTower) {
                    this.mSellTowerButton.mState = tButtonState.kButtonState_Enabled;
                    this.mUpgradeTowerButton.mState = tButtonState.kButtonState_Enabled;
                    this.mModifyingTower = false;
                }
            } else if (Key.mPressed == 0x100000) {
                this.pressedSelect(point);
            } else if (Key.mPressed == 32768) {
                if (this.mOpenMenu) {
                    this.mOpenMenu = false;
                }
                if (this.mModifyingTower) {
                    this.mSellTowerButton.mState = tButtonState.kButtonState_Enabled;
                    this.mUpgradeTowerButton.mState = tButtonState.kButtonState_Enabled;
                    this.mModifyingTower = false;
                }
                if (this.mPlacingTower) {
                    this.mPlacingTower = false;
                    this.cancelTowerPlacement();
                }
            } else if (Key.mPressed == 0x200000) {
                if (!this.mPlacingTower) {
                    this.doHandleButtonPress("Playback", point);
                }
            } else if (Key.mPressed == 0x400000 && !this.mGearButton.mIsHidden) {
                this.doHandleButtonPress("Configure", point);
            }
            if (this.mTowerCursorIndex >= 0 && this.mItATower) {
                this.mMidPoint.x = this.mRectX + this.mRectMidDelta;
                this.mMidPoint.y = this.mRectY + this.mRectMidDeltay;
                this.buildTower(this.mTowerCursorIndex, this.mMidPoint);
                this.mItATower = false;
            }
            if (this.mModifyingTower) {
                this.mKeyViewPos.x = this.mRectX + this.mRectMidDelta;
                this.mKeyViewPos.y = this.mRectY + this.mRectMidDeltay;
                this.mTouchDeltaViewSpace = 0.0f;
                object = this.convertToWorldPosFromViewPos(this.mKeyViewPos);
                this.mSelectedTowerTileGridIndex = this.findSelectedTowerAtWorldPos(((CGPoint)object).x, ((CGPoint)object).y);
                if (this.mActiveButton != null || !this.mView.mMap.isTowerAtTileGridIndex(this.mSelectedTowerTileGridIndex)) {
                    this.mSelectedTowerTileGridIndex = -1;
                    this.mModifyingTower = false;
                }
                this.mPreviousViewPos.x = this.mKeyViewPos.x;
                this.mPreviousViewPos.y = this.mKeyViewPos.y;
            } else if (!this.isModifyTowerButtonInFocus()) {
                if (!this.mModifyTowerMenu.mTrackParentPos) {
                    // empty if block
                }
                this.mModifyTowerMenu.mTrackParentPos = true;
                this.mSelectedTowerTileGridIndex = -1;
            }
            this.mActiveButton = null;
            this.checkIfTowerDone();
            this.mKeyViewPos.x = this.mRectX + this.mRectMidDelta;
            this.mKeyViewPos.y = this.mRectY + this.mRectMidDeltay;
            object = this.convertToWorldPosFromViewPos(this.mKeyViewPos);
            if (this.mModifyingTower) {
                n = this.findSelectedTowerAtWorldPos(((CGPoint)object).x, ((CGPoint)object).y);
                if (this.mSelectedTowerTileGridIndex == n && this.mView.mMap.isTowerAtTileGridIndex(n)) {
                    Point point2 = this.mView.mMap.getTilePosFromTileGridIndex(n);
                    CGPoint cGPoint = this.mView.mMap.getWorldPosFromTilePos(point2.x, point2.y);
                    cGPoint.x += (float)this.mView.mMap.mTileWidth * 0.5f;
                    cGPoint.y += (float)this.mView.mMap.mTileHeight * 0.5f;
                    CGPoint cGPoint2 = this.convertToViewPosFromWorldPos(cGPoint.x, cGPoint.y);
                    this.mModifyTowerMenu.mCenterX = cGPoint2.x / (float)this.mView.width();
                    this.mModifyTowerMenu.mCenterY = cGPoint2.y / (float)this.mView.height();
                    this.mModifyTowerMenu.mTrackParentPos = false;
                    this.updateModifyTowerButtonLabelsForTowerAtTileGridIndex(n);
                } else {
                    if (!this.mModifyTowerMenu.mTrackParentPos) {
                        // empty if block
                    }
                    this.mModifyTowerMenu.mTrackParentPos = true;
                    this.mSelectedTowerTileGridIndex = -1;
                }
            } else {
                if (!this.mModifyTowerMenu.mTrackParentPos) {
                    // empty if block
                }
                this.mModifyTowerMenu.mTrackParentPos = true;
                this.mSelectedTowerTileGridIndex = -1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void pauseGame() {
        this.mView.mMap.pauseGame();
        String string = "PAUSED";
        this.setStatusString(string, 0.0f, true);
        this.mPlaybackButton.mIsToggled = false;
    }

    void unPauseGame() {
        this.mView.mMap.unpauseGame();
        this.mView.mMap.updateStatusTextWithCurrentRound();
        this.mPlaybackButton.mIsToggled = true;
    }

    public void moveTowerCursor(Point point) {
        if (this.mTowerCursorIndex >= 0) {
            this.mKeyViewPos.x = point.x;
            this.mKeyViewPos.y = point.y;
            CGPoint cGPoint = this.convertToWorldPosFromViewPos(this.mKeyViewPos);
            int n = this.mView.mMap.getTileGridIndexForWorldPos((int)cGPoint.x, (int)cGPoint.y);
            if (n > 0 && this.mTowerCursor != null) {
                cGPoint = this.mView.mMap.getWorldPosFromTileGridIndex(n);
                this.mTowerCursor.mX = cGPoint.x + (float)this.mView.mMap.mTileWidth * 0.5f;
                this.mTowerCursor.mY = cGPoint.y + (float)this.mView.mMap.mTileHeight * 0.5f;
                this.mTowerCursor.mTileGridIndex = n;
                this.mIsValidBuildLocation = this.mView.mMap.isValidBuildLocation(this.mTowerCursor.mTileGridIndex);
            }
        }
    }

    public void touchEnd(Point point) {
    }

    private void cancelTowerPlacement() {
        this.mPlacingTower = false;
        this.mTowerCursorRangeIndicatorVisibility = 0.0f;
        this.mTowerCursor = null;
        this.mPreviouslySelectedTowerTileGridIndex = -1;
        this.mSelectedTowerTileGridIndex = -1;
        this.mTowerCursorIndex = -1;
    }

    public void checkIfTowerDone() {
        if (this.mTowerCursor != null && !this.mPlacingTower) {
            if (!this.mIsValidBuildLocation) {
                this.mTowerCursorRangeIndicatorVisibility = 0.0f;
                this.mTowerCursor = null;
                this.mPreviouslySelectedTowerTileGridIndex = -1;
                this.mSelectedTowerTileGridIndex = -1;
            } else if (this.mTowerCursorIndex != -1) {
                // empty if block
            }
        }
        this.mBuildTowerMenu.mTrackParentPos = false;
        if (!this.mPlacingTower) {
            this.mTowerCursorIndex = -1;
        }
    }

    public void doHandleButtonPress(String string, Point point) {
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (!button.mName.equalsIgnoreCase(string) || button.mIsHidden || button.mIsDisabled) continue;
            this.mPressedButton = button;
            this.mActiveButton = button;
            if (button.mPressSelector != null) {
                this.handleButtonPressAction(button, point);
                if (button.mIsToggleable) {
                    button.mIsToggled = !button.mIsToggled;
                }
            }
            button.mState = tButtonState.kButtonState_Pressed;
            break;
        }
    }

    public void updateAchievementDisplayWithElapsedTime(float f) {
        if (this.mAchievementQueue.size() > 0 && this.mView.mMap.mGameState != tGameState.kGameState_Paused) {
            this.mAchievementTimer -= f;
            if (this.mAchievementTimer <= 0.001f) {
                if (!this.mAchievementBoxParent.mTrackParentPos) {
                    this.mAchievementQueue.removeElementAt(0);
                    this.mAchievementBoxParent.mTrackParentPos = true;
                } else if (this.mAchievementQueue.size() > 0 && MathUtilities.IS_EQUAL(this.mAchievementBox.mTrackTimer, 0.0f)) {
                    this.mAchievementTimer = 5.0f;
                    String string = (String)this.mAchievementQueue.elementAt(0);
                    this.mAchievementBox.setLabelWithString(string);
                    this.mAchievementBox.mLabelOffsetY = 0.0094f;
                    this.mAchievementBoxParent.mTrackParentPos = false;
                }
            }
        }
    }

    public void updateDynamicTextWithElapsedTime(float f) {
        if (this.mResourcesLastUpdate != this.mView.mMap.mPlayer.mResources) {
            this.mResourcesText.mString = "" + this.mView.mMap.mPlayer.mResources;
            this.mResourcesText.x = 0.06667f;
            this.mResourcesText.y = 0.019f;
            this.mResourcesText.mRed = 255;
            this.mResourcesText.mGreen = 255;
            this.mResourcesText.mBlue = 255;
            this.mResourcesText.mAlpha = 255;
            this.mResourcesLastUpdate = this.mView.mMap.mPlayer.mResources;
        }
        if (this.mHealthLastUpdate != this.mView.mMap.mPlayer.mHealth) {
            this.mHealthText.mString = "" + this.mView.mMap.mPlayer.mHealth;
            this.mHealthText.x = 0.805f;
            this.mHealthText.y = 0.019f;
            this.mHealthText.mRed = 255;
            this.mHealthText.mGreen = 255;
            this.mHealthText.mBlue = 255;
            this.mHealthText.mAlpha = 255;
            this.mHealthLastUpdate = this.mView.mMap.mPlayer.mHealth;
        }
        if (this.mScoreLastUpdate != this.mView.mMap.mPlayer.mScore) {
            this.mScoreText.mString = "" + this.mView.mMap.mPlayer.mScore;
            this.mScoreText.x = 0.375f;
            this.mScoreText.y = 0.019f;
            this.mScoreText.mRed = 255;
            this.mScoreText.mGreen = 255;
            this.mScoreText.mBlue = 255;
            this.mScoreText.mAlpha = 255;
            this.mScoreLastUpdate = this.mView.mMap.mPlayer.mScore;
        }
        if (this.mStatusString != null && this.mStatusStringLastUpdate != this.mStatusString) {
            this.mStatusText.mString = this.mStatusString;
            this.mStatusText.x = 0.25f;
            this.mStatusText.y = 0.08f;
            this.mStatusText.mRed = 255;
            this.mStatusText.mGreen = 255;
            this.mStatusText.mBlue = 255;
            this.mStatusText.mAlpha = 255;
            this.mStatusStringLastUpdate = this.mStatusString;
        }
    }

    public void updateEndGameTextWithElapsedTime(float f) {
        this.mEndGameTextDisplayTimer -= f;
        this.mEndGameTextScale -= f * 3.0f;
        this.mEndGameTextScale = Math.max(this.mEndGameTextScale, 1.0f);
        if (this.mEndGameTextDisplayTimer <= 0.0f && this.mAchievementQueue.size() == 0 && MathUtilities.IS_EQUAL(this.mAchievementBox.mTrackTimer, 0.0f) && !this.mEndGameTextDisplayTimerHasExpired) {
            this.mEndGameTextOverlay.mHalfWidth = this.mEndGameTextOverlayHalfWidth;
            this.mEndGameTextOverlay.mHalfHeight = this.mEndGameTextOverlayHalfHeight;
            this.mEndGameTextDisplayTimer = 4.0f;
            this.mEndGameTextDisplayTimerHasExpired = true;
            this.mShowEndGameText = false;
            this.mSwitchToHighScoreList = false;
            this.newHighScoreNotificationTime = 0L;
            Can.FIX_THAT_SCROLL = true;
            if (this.mView.mMap.mHighScoreAchieved) {
                try {
                    this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kNewHighScoreFormNameID);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                try {
                    this.mSwitchToHighScoreList = false;
                    ScoresForm scoresForm = (ScoresForm)this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kScoresFormNameID);
                    scoresForm.mHighlightNewestHighScore = false;
                    scoresForm.mMapName = this.mView.mMap.mName;
                    Map.deleteSaveGame();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void updateModifyTowerButtonLabelsForTowerAtTileGridIndex(int n) {
        Tower tower = this.mView.mMap.getTowerAtTileGridIndex(n);
        TowerClass towerClass = tower.mTowerClass;
        TechLevel techLevel = null;
        if (tower.mTechLevelIndex + 1 < towerClass.mTechLevels.size()) {
            techLevel = (TechLevel)towerClass.mTechLevels.elementAt(tower.mTechLevelIndex + 1);
        }
        if (techLevel != null) {
            this.mUpgradeTowerButton.setLabelWithString("$" + techLevel.mCost);
        } else {
            this.mUpgradeTowerButton.setLabelWithString("-");
        }
        int n2 = this.mView.mMap.getTowerSellCostAtTileGridIndex(n);
        this.mSellTowerButton.setLabelWithString("$" + n2);
    }

    public void updateView() {
        this.mViewPos.x = Math.min(this.mViewPos.x, 0.0f);
        this.mViewPos.x = Math.max(this.mViewPos.x, -1.0f * ((float)this.mView.mMap.mImageWidth - this.mView.mScreenDimensions.width));
        this.mViewPos.y = Math.min(this.mViewPos.y, 0.0f);
        this.mViewPos.y = Math.max(this.mViewPos.y, -1.0f * ((float)this.mView.mMap.mImageHeight - this.mView.mScreenDimensions.height));
    }

    public void restoreHudButtons() {
        this.mFastForwardButton.mIsHidden = false;
        this.mPlaybackButton.mIsHidden = false;
        this.mGearButton.mIsHidden = false;
    }

    public void updateWithElapsedTime(float f) {
        long l;
        super.updateWithElapsedTime(f);
        this.updateDynamicTextWithElapsedTime(f);
        this.updateAchievementDisplayWithElapsedTime(f);
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (button.mName == null) continue;
            int n = -1;
            if (button.mName.compareTo("GatlingTower") == 0) {
                n = 0;
            } else if (button.mName.compareTo("GooTower") == 0) {
                n = 1;
            } else if (button.mName.compareTo("MissileTower") == 0) {
                n = 2;
            } else if (button.mName.compareTo("LightningTower") == 0) {
                n = 4;
            } else if (button.mName.compareTo("FlameTower") == 0) {
                n = 3;
            } else if (button.mName.compareTo("MortarTower") == 0) {
                n = 5;
            }
            if (n < 0 || n >= Map.getTowerClassList().size()) continue;
            TowerClass towerClass = (TowerClass)Map.getTowerClassList().elementAt(n);
            TechLevel techLevel = (TechLevel)towerClass.mTechLevels.elementAt(0);
            button.mIsDisabled = this.mView.mMap.mPlayer.mResources < techLevel.mCost;
        }
        if (this.mSelectedTowerTileGridIndex != -1) {
            Tower tower = this.mView.mMap.getTowerAtTileGridIndex(this.mSelectedTowerTileGridIndex);
            boolean bl = false;
            if (tower.mTechLevelIndex < tower.mTowerClass.mTechLevels.size() - 1) {
                TechLevel techLevel = (TechLevel)tower.mTowerClass.mTechLevels.elementAt(tower.mTechLevelIndex + 1);
                if (this.mView.mMap.mPlayer.mResources >= techLevel.mCost) {
                    bl = true;
                }
            }
            boolean bl2 = this.mUpgradeTowerButton.mIsDisabled = !bl;
        }
        if (this.mShowEndGameText) {
            this.updateEndGameTextWithElapsedTime(f);
        }
        if (0L != this.newHighScoreNotificationTime && (l = System.currentTimeMillis()) - newHighScoreNotificationTimeout > this.newHighScoreNotificationTime) {
            this.newHighScoreNotificationTime = 0L;
            this.mSwitchToHighScoreList = true;
        }
        if (this.mSwitchToHighScoreList) {
            this.mSwitchToHighScoreList = false;
            Can.FIX_THAT_SCROLL = true;
            try {
                this.mShowEndGameText = false;
                ScoresForm scoresForm = (ScoresForm)this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kScoresFormNameID);
                scoresForm.mHighlightNewestHighScore = true;
                scoresForm.mMapName = this.mView.mMap.mName;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

