/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class GameState {
    public int mSaveByteCount;
    RecordStore rs;
    public int mVersion;
    public boolean mLoading;
    public int mKey;
    public byte[] mPermanentStorageBuff = new byte[12000];
    public byte[] mStorageBuff;
    public byte[] mSmallBuff;
    public byte[] mSaveBuff;

    GameState(String string, boolean bl) {
        if (this.mPermanentStorageBuff.length < 2000) {
            System.out.println("not enough memory for game save");
        }
        this.mSmallBuff = new byte[128];
        this.rs = GameState.GetRecordStore(string, true);
        this.mLoading = bl;
        this.mKey = 1;
    }

    private static RecordStore GetRecordStore(String string, boolean bl) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)bl);
        }
        catch (RecordStoreFullException recordStoreFullException) {
            recordStoreFullException.printStackTrace();
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        return recordStore;
    }

    public static boolean doesFileExist(String string) {
        boolean bl = false;
        RecordStore recordStore = GameState.GetRecordStore(string, false);
        bl = recordStore != null;
        try {
            if (recordStore != null) {
                recordStore.closeRecordStore();
            }
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            recordStoreNotOpenException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
        recordStore = null;
        return bl;
    }

    public static void deleteFile(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
        }
        catch (RecordStoreException recordStoreException) {
            recordStoreException.printStackTrace();
        }
    }

    public void close() {
        try {
            this.rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            System.out.print("bad record store in close");
            recordStoreNotOpenException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            System.out.print("bad record store in close 2");
            recordStoreException.printStackTrace();
        }
    }

    public boolean isLoading() {
        return this.mLoading;
    }

    public boolean beginSerializing() {
        this.mSaveByteCount = 0;
        System.out.println("available memory before begin Serializing: " + Runtime.getRuntime().freeMemory());
        if (this.mLoading) {
            try {
                byte[] byArray = this.rs.getRecord(this.mKey);
                this.mStorageBuff = byArray;
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            }
            catch (RecordStoreException recordStoreException) {}
        } else {
            this.mStorageBuff = this.mPermanentStorageBuff;
        }
        System.out.println("available memory at end of begin Serializing: " + Runtime.getRuntime().freeMemory());
        return true;
    }

    public boolean endSerializing() {
        System.out.println(" *** END OF SERIALIZING *** \n");
        System.out.print(this.mSaveByteCount);
        System.out.println("\n");
        boolean bl = false;
        if (!this.mLoading) {
            try {
                if (this.rs != null) {
                    this.mKey = this.rs.addRecord(this.mStorageBuff, 0, this.mSaveByteCount);
                    bl = true;
                }
            }
            catch (RecordStoreFullException recordStoreFullException) {
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
        this.mStorageBuff = null;
        System.out.println("available memory after endSerializing: " + Runtime.getRuntime().freeMemory());
        return bl;
    }

    boolean SaveString(String string) {
        boolean bl = true;
        int n = 1;
        this.mSaveBuff = string.getBytes();
        n = this.mSaveBuff.length;
        this.SERIALIZE(n);
        for (int i = 0; i < n; ++i) {
            this.mStorageBuff[this.mSaveByteCount++] = this.mSaveBuff[i];
        }
        return true;
    }

    private String GetString() {
        int n = 1;
        n = this.SERIALIZE(n);
        String string = new String(this.mStorageBuff, this.mSaveByteCount, n);
        this.mSaveByteCount += n;
        return string;
    }

    public String SERIALIZE_STRING(String string) {
        if (this.mLoading) {
            string = this.GetString();
        } else {
            this.SaveString(string);
        }
        return string;
    }

    public int SERIALIZE(int n) {
        if (this.mLoading) {
            n = 0xFF000000 & this.mStorageBuff[this.mSaveByteCount++] << 24 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 16 | 0xFF00 & this.mStorageBuff[this.mSaveByteCount++] << 8 | 0xFF & this.mStorageBuff[this.mSaveByteCount++];
        } else {
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(n >> 24 & 0xFF);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(n >> 16 & 0xFF);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(n >> 8 & 0xFF);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(n & 0xFF);
        }
        return n;
    }

    public long SERIALIZE(long l) {
        if (this.mLoading) {
            l = 0xFF000000 & this.mStorageBuff[this.mSaveByteCount++] << 56 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 48 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 40 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 32 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 24 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 16 | 0xFF00 & this.mStorageBuff[this.mSaveByteCount++] << 8 | 0xFF & this.mStorageBuff[this.mSaveByteCount++];
        } else {
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 56 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 48 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 40 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 32 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 24 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 16 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 8 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l & 0xFFL);
        }
        return l;
    }

    public float SERIALIZE(float f) {
        int n = Float.floatToIntBits(f);
        if (this.mLoading) {
            n = 0xFF000000 & this.mStorageBuff[this.mSaveByteCount++] << 24 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 16 | 0xFF00 & this.mStorageBuff[this.mSaveByteCount++] << 8 | 0xFF & this.mStorageBuff[this.mSaveByteCount++];
            f = Float.intBitsToFloat(n);
        } else {
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(n >> 24 & 0xFF);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(n >> 16 & 0xFF);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(n >> 8 & 0xFF);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(n & 0xFF);
        }
        return f;
    }

    public double SERIALIZE(double d) {
        long l = Double.doubleToLongBits(d);
        if (this.mLoading) {
            l = 0xFF000000 & this.mStorageBuff[this.mSaveByteCount++] << 56 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 48 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 40 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 32 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 24 | 0xFF0000 & this.mStorageBuff[this.mSaveByteCount++] << 16 | 0xFF00 & this.mStorageBuff[this.mSaveByteCount++] << 8 | 0xFF & this.mStorageBuff[this.mSaveByteCount++];
            d = Double.longBitsToDouble(l);
        } else {
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 56 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 48 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 40 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 32 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 24 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 16 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l >> 8 & 0xFFL);
            this.mStorageBuff[this.mSaveByteCount++] = (byte)(l & 0xFFL);
        }
        this.mSaveByteCount += 8;
        return d;
    }

    public boolean SERIALIZE(boolean bl) {
        if (this.mLoading) {
            return this.mStorageBuff[this.mSaveByteCount++] == 1;
        }
        this.mStorageBuff[this.mSaveByteCount++] = bl ? (byte)1 : 0;
        return bl;
    }
}

