/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class Map {
    public static final int kSellTowerScorePenalty = -2500;
    public static final int kRemainingHealthScoreBonus = 1000;
    public static final int kRemainingResourceScoreBonus = 10;
    public static final float kTimeBeforeFirstWave = 10.0f;
    public static final float kStreamIndicatorFadeSpeed = 2.0f;
    public static final float kEscapeFlashLength = 0.1f;
    public static final String kSaveGameFilename = "FieldrunnersState";
    public static final int kSaveGameMagicNumber = -1168197103;
    public static final int kGameReleaseVersion = 1;
    public static final int kGameMajorVersion = 2;
    public static final int kGameMinorVersion = 2;
    public static Vector gTowerClassList = null;
    public static Vector gProjectileClassList = null;
    public static final int kWaveToUnlockEndlessMode = 100;
    public static final int kWaveToUnlockExtendedMode = 100;
    public static final int kWaveToUnlockMaps = 49;
    public static final int kWaveToUnlockFastForward = 74;
    public static final int kMaxRecordedReplayEvents = 2000;
    public static final int kNumOfficialMaps = 3;
    Entity[] mTileGrid;
    float[] mPlacementGridVertexPositions;
    int mPlacementGridTileCount;
    Fieldrunners mApp;
    MapScreen mView;
    GameHudForm mGameHudForm;
    Vector mRenderLastOverlayList;
    PathFinder mPathFinder;
    Image mMapTextureID;
    Image mWallsTextureID;
    int mGridTextureID;
    int mShadowMapTextureID;
    Vector mProjectileList;
    Vector mEnemyList;
    Vector mTowerList;
    public int mPlaybackSpeed;
    int mStreamIndicatorWaveIndex;
    int mCurrentReplayEventIndex;
    boolean mRestoringGameState;
    boolean mRenderPlacementGrid;
    boolean mFirstWave;
    boolean mRecordReplay;
    boolean mShowStreamIndicatorArrows = false;
    Vector mRenderList;
    Vector mRenderFirstListUnsorted;
    Vector mRenderLastList;
    Vector mStreamStatsList;
    Vector mPathList;
    String mName;
    String mFilename;
    Player mPlayer;
    int mDifficultyLevel;
    int mGameplayMode;
    float mGameCountdownTimer;
    long mCurrentPlayTimeTick;
    int mWaveIndex;
    int mUnboundedWaveIndex;
    int mNumSpawnsRemaining;
    int mNumEnemiesAlive;
    boolean mIsCompleted;
    boolean mHighScoreAchieved;
    Vector mWaves;
    Vector mBlockedTiles;
    String mImageFilename = "";
    String mShadowMapImageFilename = null;
    int mPathingType;
    tGameState mGameState;
    tGameState mSavedGameState;
    tDirection mInitialFocusRegion;
    float mPlacementGridOpacity;
    float mShadowMapOffsetU;
    float mShadowMapOffsetV;
    float mShadowMapMovementSpeedX;
    float mShadowMapMovementSpeedY;
    float mShadowMapTilingU;
    float mShadowMapTilingV;
    float mEndlessModeHealthModifier;
    int mStartingHealth = -1;
    int mStartingResources = -1;
    int mTilesAcross = -1;
    int mTilesDown = -1;
    int mTileWidth = -1;
    int mTileHeight = -1;
    int mOffsetX = -1;
    int mOffsetY = -1;
    int mEndlessModeWaveStart = -1;
    int mEndlessModeWaveEnd = -1;
    int mMinBuildTileX = -1;
    int mMinBuildTileY = -1;
    int mMaxBuildTileX = -1;
    int mMaxBuildTileY = -1;
    int mMinVisibleTileX = -1;
    int mMaxVisibleTileX = -1;
    int mMinVisibleTileY = -1;
    int mMaxVisibleTileY = -1;
    int mImageWidth = -1;
    int mImageHeight = -1;
    boolean mIgnoreGameNotifies;
    static FontStrip mArtFont = null;
    public static final String MAP_NAME_GRASSLANDS = "grasslands";
    public static final String MAP_NAME_CROSSROADS = "crossroads";
    public static final String MAP_NAME_DRYLANDS = "drylands";
    private long currentFreeHeap = 0L;
    private long lastHeapUpdate = 0L;
    private static long HEAP_UPDATE_INTERVAL = 1000L;
    float mTimeToShowFlash = 0.0f;
    public static Random sRan = new Random(System.currentTimeMillis());
    static /* synthetic */ Class class$Tower;

    public Map(MapScreen mapScreen, Fieldrunners fieldrunners) {
        this.mApp = fieldrunners;
        this.mPathList = new Vector();
        this.mWaves = new Vector();
        this.mBlockedTiles = new Vector();
        this.mRenderLastOverlayList = new Vector();
        this.mTileGrid = null;
        this.mPlacementGridVertexPositions = null;
        this.mStreamStatsList = null;
        this.mGameHudForm = null;
        this.mPathFinder = null;
        this.mName = null;
        this.mFilename = null;
        this.mPlayer = null;
        this.mView = mapScreen;
        this.mDifficultyLevel = 1;
        this.mGameplayMode = 0;
        this.mPlaybackSpeed = 1;
        this.mMapTextureID = null;
        this.mWallsTextureID = null;
        this.mGridTextureID = 0;
        this.mShadowMapTextureID = 0;
        this.mMinBuildTileX = 0;
        this.mMinBuildTileY = 0;
        this.mMaxBuildTileX = 0;
        this.mMaxBuildTileY = 0;
        this.mMinVisibleTileX = 0;
        this.mMaxVisibleTileX = 0;
        this.mMinVisibleTileY = 0;
        this.mMaxVisibleTileY = 0;
        this.mEndlessModeWaveStart = 0;
        this.mEndlessModeWaveEnd = 0;
        this.mEndlessModeHealthModifier = 1.0f;
        this.mStreamIndicatorWaveIndex = -1;
        this.mImageWidth = 0;
        this.mImageHeight = 0;
        this.mPlacementGridOpacity = 0.2f;
        this.mShadowMapOffsetU = 0.0f;
        this.mShadowMapOffsetV = 0.0f;
        this.mShadowMapMovementSpeedX = 0.0f;
        this.mShadowMapMovementSpeedY = 0.0f;
        this.mShadowMapTilingU = 1.0f;
        this.mShadowMapTilingV = 1.0f;
        this.mIgnoreGameNotifies = false;
        this.mRestoringGameState = false;
        this.mHighScoreAchieved = false;
        this.mShowStreamIndicatorArrows = true;
        this.mInitialFocusRegion = tDirection.kDirection_None;
    }

    public static String getAchievementStringForGameplayFeature(tGameplayFeature tGameplayFeature2) {
        String string = null;
        if (tGameplayFeature2 == tGameplayFeature.kGameplayFeature_FastForward) {
            string = "Fast Forward Unlocked";
        }
        return string;
    }

    public static boolean isGameplayFeatureUnlocked(tGameplayFeature tGameplayFeature2, String string) {
        if (Can.UNLOCK_ALL_FEATURES) {
            return true;
        }
        return Settings.IsGameplayFeatureUnlocked(tGameplayFeature2, string);
    }

    public static String unlockGameplayFeature(tGameplayFeature tGameplayFeature2, String string) {
        boolean bl = Map.isGameplayFeatureUnlocked(tGameplayFeature2, string);
        String string2 = null;
        if (!bl) {
            Settings.UnlockGameplayFeature(tGameplayFeature2, string);
            string2 = Map.getAchievementStringForGameplayFeature(tGameplayFeature2);
        }
        return string2;
    }

    public static String unlockGameplayMode(int n, String string) {
        String string2 = null;
        if (n == 2) {
            string2 = "Extended Mode Unlocked";
        } else if (n == 1) {
            string2 = "Endless Mode Unlocked";
        }
        boolean bl = Settings.IsGameplayModeUnlocked(n, string);
        if (!bl) {
            Settings.UnlockGameplayMode(n, string);
        } else {
            string2 = null;
        }
        return string2;
    }

    public static String unlockMap(String string) {
        String string2 = null;
        boolean bl = Settings.IsMapUnlocked(string);
        if (!bl) {
            Settings.UnlockMap(string);
            string2 = "New Map Unlocked";
        }
        return string2;
    }

    public void addEnemy(Enemy enemy) {
        Point point = this.getTilePosFromTileGridIndex(enemy.mTileGridIndex);
        if (this.mWaveIndex >= 0 && this.mWaveIndex < this.mWaves.size()) {
            Wave wave = (Wave)this.mWaves.elementAt(this.mWaveIndex);
            Stream stream = (Stream)wave.mStreams.elementAt(enemy.mStreamIndex);
            Vector vector = ((Path)this.mPathList.elementAt((int)stream.mPathIndex)).mGoalTiles;
            this.mPathFinder.findPathFromTilePos(point.x, point.y, this.mTileGrid, enemy.mPathNodes, this, enemy.mEnemyClass.mType == tEnemyType.kEnemyType_Air, vector);
        }
        enemy.mCurrentPathNode = enemy.mPathNodes.size() - 1;
        if (enemy.mCurrentPathNode < 0) {
            enemy.mCurrentPathNode = 0;
        }
        if (enemy.mEnemyClass.mType != tEnemyType.kEnemyType_Air) {
            this.mRenderList.addElement(enemy);
        } else {
            this.mRenderLastList.addElement(enemy);
        }
        this.mEnemyList.addElement(enemy);
    }

    public void addProjectile(Projectile projectile) {
        this.mProjectileList.addElement(projectile);
    }

    public void addScore(int n) {
        float f = 1.0f;
        if (this.mDifficultyLevel == 0) {
            f = 0.5f;
        } else if (this.mDifficultyLevel == 1) {
            f = 1.0f;
        } else if (this.mDifficultyLevel == 2) {
            f = 1.5f;
        }
        int n2 = (int)((float)n * f);
        this.mPlayer.mScore = this.mPlayer.mScore + n2 < 0 ? 0 : (Can.MULTIPLY_SCORE_BY_5 ? (this.mPlayer.mScore += n2 * 5) : (this.mPlayer.mScore += n2));
    }

    public void addTower(Tower tower) {
        if (this.mTileGrid[tower.mTileGridIndex] == null) {
            this.mRenderList.addElement(tower);
            this.mTileGrid[tower.mTileGridIndex] = tower;
            this.mTileGrid[tower.mTileGridIndex].mType = Entity.kTowerType;
            this.updatePathingForAllEnemies();
            this.mTowerList.addElement(tower);
        }
    }

    public void autosave() {
        this.saveGameState();
    }

    public void beginNextWave() {
        if (this.mGameplayMode == 1 || this.mWaveIndex + 1 < this.mWaves.size()) {
            System.gc();
            ++this.mUnboundedWaveIndex;
            this.checkUnlockablesAtWaveIndex(this.mUnboundedWaveIndex);
            if (this.mFirstWave) {
                this.mFirstWave = false;
            }
            this.beginWave(this.mUnboundedWaveIndex, false);
            this.unpauseGame();
            this.mGameHudForm.mPlaybackButton.mIsToggled = false;
        }
    }

    public void beginWave(int n, boolean bl) {
        if (n < this.mWaves.size() || this.mGameplayMode == 1) {
            int n2;
            Wave wave = null;
            Wave wave2 = null;
            int n3 = 0;
            if (n2 >= 0) {
                for (n2 = n - 1; n2 >= this.mWaves.size(); n2 -= this.mEndlessModeWaveEnd - this.mEndlessModeWaveStart + 1) {
                    ++n3;
                }
                wave = (Wave)this.mWaves.elementAt(n2);
            }
            this.mWaveIndex = n;
            n3 = 0;
            if (this.mWaveIndex >= this.mWaves.size()) {
                while (this.mWaveIndex > this.mEndlessModeWaveEnd) {
                    ++n3;
                    this.mWaveIndex -= this.mEndlessModeWaveEnd - this.mEndlessModeWaveStart + 1;
                }
            }
            wave2 = Can.JUST_ONE_WAVE ? (Wave)this.mWaves.elementAt(0) : (Wave)this.mWaves.elementAt(this.mWaveIndex);
            float f = (float)(n3 * (this.mEndlessModeWaveEnd - this.mEndlessModeWaveStart + 1)) * this.mEndlessModeHealthModifier;
            this.mNumSpawnsRemaining = 0;
            for (int i = 0; i < wave2.mStreams.size(); ++i) {
                Stream stream = (Stream)wave2.mStreams.elementAt(i);
                Stream stream2 = null;
                if (wave != null && i < wave.mStreams.size()) {
                    stream2 = (Stream)wave.mStreams.elementAt(i);
                }
                StreamStats streamStats = null;
                if (i >= this.mStreamStatsList.size()) {
                    streamStats = new StreamStats();
                    this.mStreamStatsList.addElement(streamStats);
                } else {
                    streamStats = (StreamStats)this.mStreamStatsList.elementAt(i);
                }
                if (bl || wave == null || stream2 == null || wave != null && stream2 != null && stream2.mEnemyFile.compareTo(stream.mEnemyFile) != 0) {
                    String string;
                    if (streamStats.mEnemyClass != null) {
                        streamStats.mEnemyClass.CleanUp();
                        streamStats.mEnemyClass = null;
                    }
                    if (stream.mEnemyFile != null && (string = "/Enemies/" + stream.mEnemyFile + ".enemy") != null) {
                        streamStats.mEnemyClass = new EnemyClass(string);
                    }
                }
                streamStats.mNumSpawnsRemaining = stream.mEnemyCount;
                streamStats.mTimeBeforeNextSpawn = -stream.mDelayStart;
                streamStats.mTimeSinceStreamStart = -stream.mDelayStart;
                streamStats.mHealthModifier = stream.mHealthModifier + stream.mHealthModifier * f;
                this.mNumSpawnsRemaining += stream.mEnemyCount;
            }
            while (this.mStreamStatsList.size() > wave2.mStreams.size()) {
                this.mStreamStatsList.removeElementAt(this.mStreamStatsList.size() - 1);
            }
            this.updateStatusTextWithCurrentRound();
        }
    }

    public void buyTower(Tower tower) {
        if (this.mTileGrid[tower.mTileGridIndex] == null) {
            this.addTower(tower);
            TechLevel techLevel = (TechLevel)tower.mTowerClass.mTechLevels.elementAt(0);
            int n = techLevel.mCost;
            this.mPlayer.mResources -= n;
        }
    }

    public void checkUnlockablesAtWaveIndex(int n) {
        String string;
        for (int i = 0; i < 2; ++i) {
            String string2;
            string = Map.getOfficialMapNameForIndex(i);
            if (this.mName == null || this.mName.compareTo(string) != 0 || n != 49 || (string2 = Map.unlockMap(Map.getOfficialMapNameForIndex(i + 1))) == null) continue;
            this.mGameHudForm.queueAchievement(string2);
        }
        if (n == 74 && (string = Map.unlockGameplayFeature(tGameplayFeature.kGameplayFeature_FastForward, this.mName)) != null) {
            this.mGameHudForm.showUnlockedGameplayFeatures();
            this.mGameHudForm.queueAchievement(string);
        }
    }

    public static void deleteSaveGame() {
        GameState.deleteFile(kSaveGameFilename);
    }

    public static boolean doesSaveGameExist() {
        return GameState.doesFileExist(kSaveGameFilename);
    }

    public void endWave() {
        Wave wave = (Wave)this.mWaves.elementAt(this.mWaveIndex);
        int n = wave.mResourceReward;
        this.mPlayer.mResources += n;
        if (this.mGameplayMode != 1 && this.mWaveIndex + 1 >= this.mWaves.size()) {
            String string = Map.unlockGameplayMode(2, this.mName);
            if (string != null) {
                this.mGameHudForm.queueAchievement(string);
            }
            if ((string = Map.unlockGameplayMode(1, this.mName)) != null) {
                this.mGameHudForm.queueAchievement(string);
            }
            this.mIsCompleted = true;
            this.markMapAsComplete(this.mName);
            this.addScore(this.mPlayer.mHealth * 1000);
            this.addScore(this.mPlayer.mResources * 10);
            this.mGameHudForm.showEndGameText(true);
        }
        this.cleanupWave();
        System.gc();
    }

    public void exitGame() {
        this.saveGameState();
        this.mGameState = tGameState.kGameState_Stopped;
        this.mTileGrid = null;
        this.mPlacementGridVertexPositions = null;
        this.mStreamStatsList = null;
        this.mGameHudForm = null;
        this.mPathFinder = null;
        this.mName = null;
        this.mFilename = null;
        this.mPlayer = null;
        this.mPathFinder = null;
        this.mWaves.removeAllElements();
        this.mEnemyList.removeAllElements();
        this.mRenderLastOverlayList.removeAllElements();
        System.gc();
    }

    public static String getOfficialMapNameForIndex(int n) {
        String[] stringArray = new String[]{MAP_NAME_GRASSLANDS, MAP_NAME_CROSSROADS, MAP_NAME_DRYLANDS};
        return stringArray[n];
    }

    public static int getIndexFromOfficialMapName(String string) {
        if (string.compareTo(Map.getOfficialMapNameForIndex(0)) == 0) {
            return 0;
        }
        if (string.compareTo(Map.getOfficialMapNameForIndex(1)) == 0) {
            return 1;
        }
        if (string.compareTo(Map.getOfficialMapNameForIndex(2)) == 0) {
            return 2;
        }
        return -1;
    }

    public static String getOfficialMapDescriptionForIndex(int n) {
        String[] stringArray = new String[]{"Enemy forces emerge from the west gate in an attempt to infiltrate the base on the east side. ", "Enemies advance from both the north and west gates, crossing paths in the center. ", "A harder, air-focused map, with gates on the north, northwest and southwest sides. "};
        return stringArray[n];
    }

    public static String getOfficialUnlockDescriptionForIndex(int n) {
        String[] stringArray = new String[]{"[LOCKED] To unlock, beat Classic mode.", "[LOCKED] To unlock, reach round 50 on Grasslands.", "[LOCKED] To unlock, reach round 50 on Crossroads."};
        return stringArray[n];
    }

    public static Vector getTowerClassList() {
        if (gTowerClassList == null) {
            gTowerClassList = new Vector();
        }
        return gTowerClassList;
    }

    public static Vector getProjectileClassList() {
        if (gProjectileClassList == null) {
            gProjectileClassList = new Vector();
        }
        return gProjectileClassList;
    }

    public void initPlacementGrid() {
        this.mPlacementGridTileCount = (this.mMaxBuildTileX - this.mMinBuildTileX + 1) * (this.mMaxBuildTileY - this.mMinBuildTileY + 1);
        this.mPlacementGridVertexPositions = new float[this.mPlacementGridTileCount * 6 * 2];
        int n = 0;
        for (int i = this.mMinBuildTileY; i < this.mMaxBuildTileY + 1; ++i) {
            for (int j = this.mMinBuildTileX; j < this.mMaxBuildTileX + 1; ++j) {
                if (j % 2 == 0 && i % 2 == 0 || j % 2 == 1 && i % 2 == 1) continue;
                int n2 = n * 12;
                this.mPlacementGridVertexPositions[n2] = this.mTileWidth * j + this.mOffsetX;
                this.mPlacementGridVertexPositions[n2 + 1] = this.mTileHeight * i + this.mOffsetY;
                this.mPlacementGridVertexPositions[n2 + 2] = this.mTileWidth * (j + 1) + this.mOffsetX;
                this.mPlacementGridVertexPositions[n2 + 3] = this.mTileHeight * i + this.mOffsetY;
                this.mPlacementGridVertexPositions[n2 + 4] = this.mTileWidth * j + this.mOffsetX;
                this.mPlacementGridVertexPositions[n2 + 5] = this.mTileHeight * (i + 1) + this.mOffsetY;
                this.mPlacementGridVertexPositions[n2 + 6] = this.mTileWidth * (j + 1) + this.mOffsetX;
                this.mPlacementGridVertexPositions[n2 + 7] = this.mTileHeight * i + this.mOffsetY;
                this.mPlacementGridVertexPositions[n2 + 8] = this.mTileWidth * (j + 1) + this.mOffsetX;
                this.mPlacementGridVertexPositions[n2 + 9] = this.mTileHeight * (i + 1) + this.mOffsetY;
                this.mPlacementGridVertexPositions[n2 + 10] = this.mTileWidth * j + this.mOffsetX;
                this.mPlacementGridVertexPositions[n2 + 11] = this.mTileHeight * (i + 1) + this.mOffsetY;
                ++n;
            }
        }
        this.mPlacementGridTileCount = n;
    }

    public void initTileGrid() {
        if (this.mTileGrid != null) {
            Fieldrunners.CleanUp(this.mTileGrid);
            this.mTileGrid = null;
            System.gc();
        }
        this.mTileGrid = new Entity[this.mTilesAcross * this.mTilesDown];
        for (int i = 0; i < this.mTilesAcross; ++i) {
            block1: for (int j = 0; j < this.mTilesDown; ++j) {
                int n = this.getTileGridIndexForTilePos(i, j);
                this.mTileGrid[n] = null;
                for (int k = 0; k < this.mBlockedTiles.size(); ++k) {
                    Integer n2 = (Integer)this.mBlockedTiles.elementAt(k);
                    if (n != n2) continue;
                    this.mTileGrid[n] = Entity.dummyEntity();
                    continue block1;
                }
            }
        }
        if (this.mPathFinder != null) {
            this.mPathFinder = null;
            System.gc();
        }
        this.mPathFinder = new PathFinder();
        this.mPathFinder.initWithTilesAcross(this.mTilesAcross, this.mTilesDown);
    }

    public boolean isTileEmptyAtTileGridIndex(int n) {
        return this.mTileGrid[n] == null;
    }

    public boolean isTowerAtTileGridIndex(int n) {
        return this.mTileGrid[n] != null && this.mTileGrid[n].mType == Entity.kTowerType;
    }

    public Tower getTowerAtTileGridIndex(int n) {
        if (n > 0 && this.mTileGrid[n] != null && this.mTileGrid[n].mType == Entity.kTowerType) {
            return (Tower)this.mTileGrid[n];
        }
        return null;
    }

    public boolean isValidBuildLocation(int n) {
        boolean bl = this.mTileGrid[n] == null;
        Point point = this.getTilePosFromTileGridIndex(n);
        if (point.x < this.mMinBuildTileX || point.x > this.mMaxBuildTileX || point.y < this.mMinBuildTileY || point.y > this.mMaxBuildTileY) {
            return false;
        }
        boolean bl2 = true;
        if (bl) {
            this.mTileGrid[n] = Entity.dummyEntity();
            Vector vector = new Vector();
            int n2 = 0;
            Path path = null;
            for (n2 = 0; n2 < 4 + this.mPathList.size(); ++n2) {
                int n3;
                int n4;
                int n5;
                switch (n2) {
                    case 0: {
                        path = (Path)this.mPathList.elementAt(0);
                        n5 = point.x + 1;
                        n4 = point.y;
                        n3 = this.getTileGridIndexForTilePos(n5, n4);
                        break;
                    }
                    case 1: {
                        n5 = point.x - 1;
                        n4 = point.y;
                        n3 = this.getTileGridIndexForTilePos(n5, n4);
                        break;
                    }
                    case 2: {
                        n5 = point.x;
                        n4 = point.y - 1;
                        n3 = this.getTileGridIndexForTilePos(n5, n4);
                        break;
                    }
                    case 3: {
                        n5 = point.x;
                        n4 = point.y + 1;
                        n3 = this.getTileGridIndexForTilePos(n5, n4);
                        break;
                    }
                    default: {
                        path = (Path)this.mPathList.elementAt(Math.max(n2 - 4, 0));
                        Integer n6 = (Integer)path.mSpawnTiles.elementAt(0);
                        point = this.getTilePosFromTileGridIndex(n6);
                        n5 = point.x;
                        n4 = point.y;
                        n3 = n6;
                    }
                }
                boolean bl3 = bl = this.mTileGrid[n3] == null;
                if (bl) {
                    vector.removeAllElements();
                    bl2 = this.mPathFinder.findPathFromTilePos(n5, n4, this.mTileGrid, vector, this, false, path.mGoalTiles);
                    if (!bl2 && n2 < 4) {
                        bl2 = true;
                        for (int i = 0; i < this.mEnemyList.size(); ++i) {
                            Enemy enemy = (Enemy)this.mEnemyList.elementAt(i);
                            if (enemy.mHealth > 0.0f) {
                                int n7 = this.getTileGridIndexForWorldPos((int)enemy.mX, (int)enemy.mY);
                                for (int j = 0; j < vector.size(); ++j) {
                                    Point point2 = (Point)vector.elementAt(j);
                                    int n8 = this.getTileGridIndexForTilePos(point2.x, point2.y);
                                    if (n8 != n7) continue;
                                    bl2 = false;
                                    break;
                                }
                            }
                            if (!bl2) break;
                        }
                    }
                }
                if (!bl2) break;
            }
            this.mTileGrid[n] = null;
            vector = null;
        } else {
            bl2 = false;
        }
        return bl2;
    }

    public int getTileGridIndexForTilePosX(int n, int n2) {
        return this.mTilesAcross * n2 + n;
    }

    public int getTileGridIndexForWorldPosX(int n, int n2) {
        int n3 = (n - this.mOffsetX) / this.mTileWidth;
        int n4 = (n2 - this.mOffsetY) / this.mTileHeight;
        if (n3 >= 0 && n3 < this.mTilesAcross && n4 >= 0 && n4 < this.mTilesDown) {
            return this.getTileGridIndexForTilePos(n3, n4);
        }
        return -1;
    }

    public Point getTilePosFromTileGridIndex(int n) {
        return new Point(n % this.mTilesAcross, n / this.mTilesAcross);
    }

    public int getTowerSellCostAtTileGridIndex(int n) {
        int n2 = 0;
        if (this.mTileGrid[n] != null && this.mTileGrid[n].mType == Entity.kTowerType) {
            Tower tower = (Tower)this.mTileGrid[n];
            for (int i = 0; i <= tower.mTechLevelIndex; ++i) {
                TechLevel techLevel = (TechLevel)tower.mTowerClass.mTechLevels.elementAt(i);
                n2 += techLevel.mCost;
            }
            if (tower.mHasBeenSimulated) {
                n2 = (int)((float)n2 * 0.75f);
            }
        }
        return n2;
    }

    CGPoint getWorldPosFromTilePos(int n, int n2) {
        return new CGPoint(n * this.mTileWidth + this.mOffsetX, n2 * this.mTileHeight + this.mOffsetY);
    }

    CGPoint getWorldPosFromTileGridIndex(int n) {
        int n2 = n % this.mTilesAcross;
        int n3 = n / this.mTilesAcross;
        return new CGPoint(n2 * this.mTileWidth + this.mOffsetX, n3 * this.mTileHeight + this.mOffsetY);
    }

    public void handleGameEnd() {
        int n;
        this.mHighScoreAchieved = true;
        if (Settings.NumHighScoreEntries(this.mName) >= 5 && this.mPlayer.mScore < (n = Integer.parseInt(Settings.GetHighScore(this.mName, 4)))) {
            this.mHighScoreAchieved = false;
        }
        if (this.mHighScoreAchieved) {
            this.autosave();
            Can.HIGHLIGHT_THIS_ROW_IN_HIGH_SCORES = Settings.SetHighScore(this.mName, this.mUnboundedWaveIndex, this.mPlayer.mScore);
        } else {
            Map.deleteSaveGame();
        }
    }

    public void handleReplayEvents() {
    }

    public static boolean loadCommonResources() {
        Object object;
        Vector vector = Map.getProjectileClassList();
        Vector vector2 = Map.getTowerClassList();
        String[] stringArray = new String[]{"projectile_missile", "projectile_goo", "projectile_lightning", "projectile_mortar", "projectile_flame"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = "/Projectiles/" + stringArray[i] + ".projectile";
            object = new ProjectileClass(string);
            vector.addElement(object);
        }
        vector.trimToSize();
        String[] stringArray2 = new String[]{"tower_gatling", "tower_goo", "tower_missile", "tower_flame", "tower_lightning", "tower_mortar"};
        for (int i = 0; i < stringArray2.length; ++i) {
            object = "/Towers/" + stringArray2[i] + ".tower";
            TowerClass towerClass = new TowerClass((String)object, vector);
            vector2.addElement(towerClass);
        }
        vector2.trimToSize();
        mArtFont = new FontStrip(0);
        return true;
    }

    public boolean loadFromFile(String string, Form form) {
        int n;
        String string2 = "/Maps/" + string + ".map";
        String string3 = string2;
        boolean bl = this.loadFromURL(string3, form, n = 25950);
        if (!bl) {
            // empty if block
        }
        if (this.mGameHudForm != null) {
            this.mView.mMap.mGameHudForm.mFirstTouch = true;
        }
        return bl;
    }

    public boolean loadFromURL(String string, Form form, int n) {
        LoadingForm loadingForm = (LoadingForm)form;
        loadingForm.updateLoadingProgressWithPercent(0.0f);
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        KXmlParser kXmlParser = new KXmlParser();
        try {
            kXmlParser.setInput(inputStream, null);
        }
        catch (Exception exception) {
            System.err.println("Error calling Input Stream with url:" + string);
            exception.printStackTrace();
        }
        try {
            String string2;
            kXmlParser.nextTag();
            String string3 = kXmlParser.getName();
            int n2 = kXmlParser.getAttributeCount();
            for (int i = 0; i < n2; ++i) {
                string2 = kXmlParser.getAttributeName(i);
                String string4 = kXmlParser.getAttributeValue(i);
                if (string2.compareTo("image") == 0) {
                    this.mImageFilename = string4;
                    continue;
                }
                if (string2.compareTo("shadowMapImage") == 0) {
                    this.mShadowMapImageFilename = string4;
                    continue;
                }
                if (string2.compareTo("pathingType") == 0) {
                    if (string4.compareTo("dynamic") == 0) {
                        this.mPathingType = 0;
                        continue;
                    }
                    this.mPathingType = 1;
                    continue;
                }
                if (string2.compareTo("tilesAcross") == 0) {
                    this.mTilesAcross = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("tilesDown") == 0) {
                    this.mTilesDown = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("tileWidth") == 0) {
                    this.mTileWidth = (int)((double)((float)Integer.parseInt(string4) * Can.BASE_SIZE_FOR_ART_RESOURCES) + 0.5);
                    continue;
                }
                if (string2.compareTo("tileHeight") == 0) {
                    this.mTileHeight = (int)((double)((float)Integer.parseInt(string4) * Can.BASE_SIZE_FOR_ART_RESOURCES) + 0.5);
                    continue;
                }
                if (string2.compareTo("offsetX") == 0) {
                    this.mOffsetX = (int)((double)((float)Integer.parseInt(string4) * Can.BASE_SIZE_FOR_ART_RESOURCES) + 0.5);
                    continue;
                }
                if (string2.compareTo("offsetY") == 0) {
                    this.mOffsetY = (int)((double)((float)Integer.parseInt(string4) * Can.BASE_SIZE_FOR_ART_RESOURCES) + 0.5);
                    continue;
                }
                if (string2.compareTo("startingHealth") == 0) {
                    this.mStartingHealth = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("startingResources") == 0) {
                    this.mStartingResources = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("minBuildTileX") == 0) {
                    this.mMinBuildTileX = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("minBuildTileY") == 0) {
                    this.mMinBuildTileY = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("maxBuildTileX") == 0) {
                    this.mMaxBuildTileX = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("maxBuildTileY") == 0) {
                    this.mMaxBuildTileY = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("minVisibleTileX") == 0) {
                    this.mMinVisibleTileX = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("maxVisibleTileX") == 0) {
                    this.mMaxVisibleTileX = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("minVisibleTileY") == 0) {
                    this.mMinVisibleTileY = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("maxVisibleTileY") == 0) {
                    this.mMaxVisibleTileY = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("initialFocusRegion") == 0) continue;
                if (string2.compareTo("endlessModeWaveStart") == 0) {
                    this.mEndlessModeWaveStart = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("endlessModeWaveEnd") == 0) {
                    this.mEndlessModeWaveEnd = Integer.parseInt(string4);
                    continue;
                }
                if (string2.compareTo("endlessModeHealthModifier") == 0) {
                    this.mEndlessModeHealthModifier = Float.parseFloat(string4);
                    continue;
                }
                if (string2.compareTo("gridOpacity") == 0) {
                    this.mPlacementGridOpacity = Float.parseFloat(string4);
                    continue;
                }
                if (string2.compareTo("shadowMapTilingU") == 0) {
                    this.mShadowMapTilingU = Float.parseFloat(string4);
                    continue;
                }
                if (string2.compareTo("shadowMapTilingV") == 0) {
                    this.mShadowMapTilingV = Float.parseFloat(string4);
                    continue;
                }
                if (string2.compareTo("shadowMapMovementSpeedX") == 0) {
                    this.mShadowMapMovementSpeedX = Float.parseFloat(string4);
                    continue;
                }
                if (string2.compareTo("shadowMapMovementSpeedY") == 0) {
                    this.mShadowMapMovementSpeedY = Float.parseFloat(string4);
                    continue;
                }
                if (string2.compareTo("showStreamIndicatorArrows") != 0) continue;
                this.mShowStreamIndicatorArrows = string4.compareTo("yes") == 0;
            }
            this.mOffsetX -= this.mTileWidth * this.mMinVisibleTileX;
            this.mOffsetY -= this.mTileHeight * this.mMinVisibleTileY;
            Vector<String> vector = new Vector<String>();
            kXmlParser.nextTag();
            while (kXmlParser.getName() != string3) {
                int n3;
                int n4;
                string2 = kXmlParser.getName();
                if (string2.compareTo("BlockedTiles") == 0) {
                    int n5 = kXmlParser.getEventType();
                    if (n5 == 2) {
                        kXmlParser.nextTag();
                        while (kXmlParser.getName() != "BlockedTiles") {
                            n5 = kXmlParser.getEventType();
                            if (n5 == 2) {
                                n4 = -1;
                                n3 = -1;
                                int n6 = kXmlParser.getAttributeCount();
                                for (int i = 0; i < n6; ++i) {
                                    String string5 = kXmlParser.getAttributeName(i);
                                    String string6 = kXmlParser.getAttributeValue(i);
                                    if (string5.compareTo("tileX") == 0) {
                                        n4 = Integer.parseInt(string6);
                                        continue;
                                    }
                                    if (string5.compareTo("tileY") != 0) continue;
                                    n3 = Integer.parseInt(string6);
                                }
                                Integer n7 = new Integer(this.getTileGridIndexForTilePos(n4, n3));
                                this.mBlockedTiles.addElement(n7);
                            }
                            kXmlParser.nextTag();
                            n5 = kXmlParser.getEventType();
                            if (kXmlParser.getName().compareTo("BlockedTiles") != 0 || n5 != 3) continue;
                            break;
                        }
                    }
                } else if (string2.compareTo("Overlays") == 0) {
                    String string7 = "";
                    kXmlParser.nextTag();
                    while ("Overlays".compareTo(kXmlParser.getName()) != 0) {
                        MapOverlay mapOverlay = new MapOverlay();
                        for (n3 = 0; n3 < kXmlParser.getAttributeCount(); ++n3) {
                            System.out.println("getting attributes for overlays");
                            String string8 = kXmlParser.getAttributeName(n3);
                            if (string8.compareTo("image") == 0) {
                                mapOverlay.mTexture = Image.createImage((String)("/Maps/" + kXmlParser.getAttributeValue(n3)));
                                continue;
                            }
                            if (string8.compareTo("x") == 0) {
                                mapOverlay.mX = (int)(Float.parseFloat(kXmlParser.getAttributeValue(n3)) * Can.BASE_SIZE_FOR_ART_RESOURCES);
                                continue;
                            }
                            if (string8.compareTo("y") == 0) {
                                mapOverlay.mY = (int)(Float.parseFloat(kXmlParser.getAttributeValue(n3)) * Can.BASE_SIZE_FOR_ART_RESOURCES);
                                continue;
                            }
                            if (string8.compareTo("renderOrder") != 0) continue;
                            string7 = kXmlParser.getAttributeValue(n3);
                        }
                        if (mapOverlay.mTexture != null && string7.compareTo("last") == 0) {
                            System.out.println("adding an element");
                            this.mRenderLastOverlayList.addElement(mapOverlay);
                        }
                        string7 = "";
                        mapOverlay = null;
                        kXmlParser.nextTag();
                    }
                } else if (string2.compareTo("Paths") == 0) {
                    kXmlParser.nextTag();
                    while (kXmlParser.getName() != "Paths") {
                        Path path = new Path();
                        vector.addElement(kXmlParser.getName());
                        String string9 = kXmlParser.getName();
                        kXmlParser.nextTag();
                        block12: while (kXmlParser.getName() != string9) {
                            String string10;
                            int n8;
                            int n9;
                            int n10;
                            String string11 = kXmlParser.getName();
                            if (string11.compareTo("SpawnTiles") == 0) {
                                kXmlParser.nextTag();
                                while (kXmlParser.getName() != string9) {
                                    n10 = -1;
                                    n9 = -1;
                                    n8 = kXmlParser.getAttributeCount();
                                    for (int i = 0; i < n8; ++i) {
                                        String string12 = kXmlParser.getAttributeName(i);
                                        string10 = kXmlParser.getAttributeValue(i);
                                        if (string12.compareTo("tileX") == 0) {
                                            n10 = Integer.parseInt(string10);
                                            continue;
                                        }
                                        if (string12.compareTo("tileY") != 0) continue;
                                        n9 = Integer.parseInt(string10);
                                    }
                                    Integer n11 = new Integer(this.getTileGridIndexForTilePos(n10, n9));
                                    path.mSpawnTiles.addElement(n11);
                                    kXmlParser.nextTag();
                                    int n12 = kXmlParser.getEventType();
                                    if (n12 != 3) continue;
                                    kXmlParser.nextTag();
                                    n12 = kXmlParser.getEventType();
                                    if (n12 != 3) continue;
                                    kXmlParser.nextTag();
                                    continue block12;
                                }
                                continue;
                            }
                            if (string11.compareTo("GoalTiles") == 0) {
                                kXmlParser.nextTag();
                                n10 = kXmlParser.getEventType();
                                if (kXmlParser.getName().compareTo("Paths") == 0 && n10 == 3) break;
                                while (kXmlParser.getName() != string9) {
                                    n9 = -1;
                                    n8 = -1;
                                    int n13 = kXmlParser.getAttributeCount();
                                    for (int i = 0; i < n13; ++i) {
                                        string10 = kXmlParser.getAttributeName(i);
                                        String string13 = kXmlParser.getAttributeValue(i);
                                        if (string10.compareTo("tileX") == 0) {
                                            n9 = Integer.parseInt(string13);
                                            continue;
                                        }
                                        if (string10.compareTo("tileY") != 0) continue;
                                        n8 = Integer.parseInt(string13);
                                    }
                                    Integer n14 = new Integer(this.getTileGridIndexForTilePos(n9, n8));
                                    path.mGoalTiles.addElement(n14);
                                    kXmlParser.nextTag();
                                    n10 = kXmlParser.getEventType();
                                    if (n10 != 3) continue;
                                    kXmlParser.nextTag();
                                    n10 = kXmlParser.getEventType();
                                    if (n10 != 3) continue;
                                    kXmlParser.nextTag();
                                    continue block12;
                                }
                                continue;
                            }
                            if (string11.compareTo("Indicators") != 0) continue;
                        }
                        this.mPathList.addElement(path);
                        path = null;
                        kXmlParser.nextTag();
                        n3 = kXmlParser.getEventType();
                        if (n3 != 3) continue;
                        break;
                    }
                } else if (string2.compareTo("DifficultyModifiers") == 0) {
                    kXmlParser.nextTag();
                    while (kXmlParser.getName() != "DifficultyModifiers") {
                        Object object;
                        int n15;
                        int n16 = -1;
                        n4 = -1;
                        n3 = 3;
                        float f = 1.0f;
                        int n17 = kXmlParser.getAttributeCount();
                        for (n15 = 0; n15 < n17; ++n15) {
                            object = kXmlParser.getAttributeName(n15);
                            String string14 = kXmlParser.getAttributeValue(n15);
                            if (((String)object).compareTo("startWave") == 0) {
                                n16 = Integer.parseInt(string14);
                                continue;
                            }
                            if (((String)object).compareTo("endWave") == 0) {
                                n4 = Integer.parseInt(string14);
                                continue;
                            }
                            if (((String)object).compareTo("healthModifier") == 0) {
                                f = Float.parseFloat(string14);
                                continue;
                            }
                            if (((String)object).compareTo("difficulty") != 0) continue;
                            if (string14.compareTo("easy") == 0) {
                                n3 = 0;
                                continue;
                            }
                            if (string14.compareTo("medium") == 0) {
                                n3 = 1;
                                continue;
                            }
                            if (string14.compareTo("hard") != 0) continue;
                            n3 = 2;
                        }
                        --n4;
                        for (n15 = --n16; n15 <= n4; ++n15) {
                            object = (Wave)this.mWaves.elementAt(n15);
                            ((Wave)object).mHealthModifiers[n3] = f;
                        }
                    }
                } else if (string2.compareTo("Waves") == 0) {
                    kXmlParser.nextTag();
                    while (kXmlParser.getName() != "Waves") {
                        Wave wave = new Wave();
                        n4 = kXmlParser.getAttributeCount();
                        for (n3 = 0; n3 < n4; ++n3) {
                            String string15 = kXmlParser.getAttributeName(n3);
                            String string16 = kXmlParser.getAttributeValue(n3);
                            if (string15.compareTo("resourceReward") != 0) continue;
                            wave.mResourceReward = Integer.parseInt(string16);
                        }
                        kXmlParser.nextTag();
                        while (kXmlParser.getName() != "Wave") {
                            String string17;
                            int n18;
                            Stream stream = new Stream();
                            String string18 = null;
                            int n19 = kXmlParser.getAttributeCount();
                            for (n18 = 0; n18 < n19; ++n18) {
                                string17 = kXmlParser.getAttributeName(n18);
                                String string19 = kXmlParser.getAttributeValue(n18);
                                if (string17.compareTo("enemyFile") == 0) {
                                    stream.mEnemyFile = string19;
                                    continue;
                                }
                                if (string17.compareTo("count") == 0) {
                                    stream.mEnemyCount = Integer.parseInt(string19);
                                    continue;
                                }
                                if (string17.compareTo("spawnRate") == 0) {
                                    stream.mSpawnRate = Float.parseFloat(string19);
                                    continue;
                                }
                                if (string17.compareTo("delayStart") == 0) {
                                    stream.mDelayStart = Float.parseFloat(string19);
                                    continue;
                                }
                                if (string17.compareTo("healthModifier") == 0) {
                                    stream.mHealthModifier = Float.parseFloat(string19);
                                    continue;
                                }
                                if (string17.compareTo("path") != 0) continue;
                                string18 = string19;
                            }
                            for (n18 = 0; n18 < vector.size(); ++n18) {
                                string17 = (String)vector.elementAt(n18);
                                if (string18.compareTo(string17) != 0) continue;
                                stream.mPathIndex = n18;
                                break;
                            }
                            wave.mStreams.addElement(stream);
                            kXmlParser.nextTag();
                            kXmlParser.nextTag();
                            n18 = kXmlParser.getEventType();
                            if (kXmlParser.getName().compareTo("Wave") != 0 || n18 != 3) continue;
                            break;
                        }
                        this.mWaves.addElement(wave);
                        kXmlParser.nextTag();
                        n3 = kXmlParser.getEventType();
                        if (kXmlParser.getName().compareTo("Waves") != 0 || n3 != 3) continue;
                        break;
                    }
                }
                kXmlParser.nextTag();
                int n20 = kXmlParser.getEventType();
                if (kXmlParser.getName().compareTo(string3) != 0 || n20 != 3) continue;
                break;
            }
            --this.mEndlessModeWaveStart;
            --this.mEndlessModeWaveEnd;
            this.mEndlessModeWaveStart = Math.min(Math.max(this.mEndlessModeWaveStart, 0), this.mWaves.size() - 1);
            this.mEndlessModeWaveEnd = Math.min(Math.max(this.mEndlessModeWaveEnd, 0), this.mWaves.size() - 1);
            if (this.mImageFilename.indexOf(MAP_NAME_GRASSLANDS) >= 0) {
                this.mMapTextureID = Image.createImage((String)"/Maps/grasslands.png");
            } else {
                Image image;
                string2 = "/Maps/" + this.mImageFilename;
                this.mMapTextureID = image = Image.createImage((String)string2);
                image = null;
            }
            this.mImageWidth = this.mMapTextureID.getWidth();
            this.mImageHeight = this.mMapTextureID.getHeight();
            vector = null;
            kXmlParser = null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
        }
        kXmlParser = null;
        this.mBlockedTiles.trimToSize();
        this.mPathList.trimToSize();
        this.mWaves.trimToSize();
        System.gc();
        return true;
    }

    public void markMapAsComplete(String string) {
    }

    void notifyEnemyHasBeenKilled(Enemy enemy) {
        if (!this.mIgnoreGameNotifies) {
            --this.mNumEnemiesAlive;
            if (enemy.mStreamIndex >= 0 && enemy.mStreamIndex < this.mStreamStatsList.size()) {
                StreamStats streamStats = (StreamStats)this.mStreamStatsList.elementAt(enemy.mStreamIndex);
                --streamStats.mNumEnemiesAlive;
            }
        }
    }

    void notifyEnemyHasEscaped(Enemy enemy) {
        int n = enemy.mEnemyClass.mDamage;
        if (!this.mIgnoreGameNotifies) {
            --this.mNumEnemiesAlive;
            StreamStats streamStats = (StreamStats)this.mStreamStatsList.elementAt(enemy.mStreamIndex);
            --streamStats.mNumEnemiesAlive;
        }
        if (!Can.ENABLE_INFINITE_LIVES) {
            this.mPlayer.mHealth -= n;
        }
        this.mTimeToShowFlash = 0.1f;
        if (this.mPlayer.mHealth <= 0) {
            this.addScore(this.mPlayer.mResources * 10);
            this.mPlayer.mHealth = Math.max(this.mPlayer.mHealth, 0);
            this.mGameState = tGameState.kGameState_Paused;
            this.mGameHudForm.showEndGameText(false);
        }
    }

    public void pauseGame() {
        this.mGameState = tGameState.kGameState_Paused;
    }

    public void renderInvalidTileWithElapsedTime(MapGraphics mapGraphics, float f, int n) {
        int n2 = mapGraphics.getColor();
        mapGraphics.setColor(255, 0, 0);
        CGPoint cGPoint = this.getWorldPosFromTileGridIndex(n);
        mapGraphics.fillRect((int)cGPoint.x, (int)cGPoint.y, this.mTileWidth, this.mTileHeight);
        mapGraphics.setColor(n2);
    }

    public void renderBlockedTilesWithElapsedTime(MapGraphics mapGraphics, float f) {
        Object object;
        int n;
        for (n = 0; n < this.mBlockedTiles.size(); ++n) {
            object = (Integer)this.mBlockedTiles.elementAt(n);
            this.renderInvalidTileWithElapsedTime(mapGraphics, f, (Integer)object);
        }
        for (n = 0; n < this.mRenderList.size(); ++n) {
            if (!(class$Tower == null ? Map.class$("Tower") : class$Tower).isInstance(object = (Entity)this.mRenderList.elementAt(n))) continue;
            this.renderInvalidTileWithElapsedTime(mapGraphics, f, ((Entity)object).mTileGridIndex);
        }
    }

    public void renderOverlaysInList(MapGraphics mapGraphics, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            MapOverlay mapOverlay = (MapOverlay)vector.elementAt(i);
            for (int j = 0; j < mapOverlay.mRenderCount; ++j) {
                mapGraphics.drawImage(mapOverlay.mTexture, mapOverlay.mX, mapOverlay.mY, 0);
            }
        }
    }

    public void renderPlacementGridWithElapsedTime(MapGraphics mapGraphics, float f) {
        int n = 0;
        for (int i = this.mMinBuildTileY; i < this.mMaxBuildTileY + 1; ++i) {
            for (int j = this.mMinBuildTileX; j < this.mMaxBuildTileX + 1; ++j) {
                if (j % 2 == 0 && i % 2 == 0 || j % 2 == 1 && i % 2 == 1) continue;
                int n2 = n * 12;
                int n3 = (int)this.mPlacementGridVertexPositions[n2];
                int n4 = (int)this.mPlacementGridVertexPositions[n2 + 1];
                int n5 = (int)(this.mPlacementGridVertexPositions[n2 + 8] - (float)n3);
                int n6 = (int)(this.mPlacementGridVertexPositions[n2 + 9] - (float)n4);
                mapGraphics.drawRect(n3, n4, n5, n6);
                ++n;
            }
        }
    }

    public void cleanupWave() {
        if (this.mProjectileList != null) {
            this.mProjectileList.removeAllElements();
            System.gc();
        }
        if (this.mEnemyList != null) {
            this.mEnemyList.removeAllElements();
            System.gc();
        }
        System.gc();
    }

    public void reset() {
        this.mIgnoreGameNotifies = true;
        if (this.mPlayer != null) {
            this.mPlayer = null;
            System.gc();
        }
        this.mPlayer = new Player();
        this.mPlayer.mHealth = this.mStartingHealth;
        this.mPlayer.mResources = this.mStartingResources;
        this.mRenderPlacementGrid = false;
        this.mGameCountdownTimer = 10.0f;
        this.mWaveIndex = -1;
        this.mUnboundedWaveIndex = -1;
        this.mNumSpawnsRemaining = 0;
        this.mNumEnemiesAlive = 0;
        this.mCurrentPlayTimeTick = 0L;
        this.mCurrentReplayEventIndex = 0;
        this.mGameState = tGameState.kGameState_Paused;
        this.mSavedGameState = tGameState.kGameState_Paused;
        this.mHighScoreAchieved = false;
        this.mFirstWave = false;
        this.mIsCompleted = false;
        this.mRecordReplay = true;
        if (this.mProjectileList != null) {
            Fieldrunners.CleanUp(this.mProjectileList);
            this.mProjectileList = null;
            System.gc();
        }
        if (this.mEnemyList != null) {
            Fieldrunners.CleanUp(this.mEnemyList);
            this.mEnemyList = null;
            System.gc();
        }
        if (this.mTowerList != null) {
            Fieldrunners.CleanUp(this.mTowerList);
            this.mTowerList = null;
            System.gc();
        }
        if (this.mRenderList != null) {
            Fieldrunners.CleanUp(this.mRenderList);
            this.mRenderList = null;
            System.gc();
        }
        if (this.mRenderFirstListUnsorted != null) {
            Fieldrunners.CleanUp(this.mRenderFirstListUnsorted);
            this.mRenderFirstListUnsorted = null;
            System.gc();
        }
        if (this.mRenderLastList != null) {
            Fieldrunners.CleanUp(this.mRenderLastList);
            this.mRenderLastList = null;
            System.gc();
        }
        if (this.mStreamStatsList != null) {
            Fieldrunners.CleanUp(this.mStreamStatsList);
            this.mStreamStatsList = null;
            System.gc();
        }
        if (this.mGameHudForm != null) {
            this.mGameHudForm = null;
            System.gc();
        }
        this.mProjectileList = new Vector();
        this.mEnemyList = new Vector();
        this.mTowerList = new Vector();
        this.mRenderList = new Vector();
        this.mRenderFirstListUnsorted = new Vector();
        this.mRenderLastList = new Vector();
        this.mStreamStatsList = new Vector();
        this.mIgnoreGameNotifies = false;
        this.initTileGrid();
        if (this.mRenderPlacementGrid) {
            this.initPlacementGrid();
        }
        this.mGameHudForm = (GameHudForm)this.mView.mUserInterface.getFormWithName(UserInterface.kGameHudFormName);
        if (this.mGameHudForm == null) {
            // empty if block
        }
    }

    public boolean restoreGameState() {
        if (GameState.doesFileExist(kSaveGameFilename)) {
            GameState gameState = new GameState(kSaveGameFilename, true);
            this.serializeWithBinaryFile(gameState);
            gameState.close();
            gameState = null;
            if (this.mHighScoreAchieved) {
                // empty if block
            }
        }
        return true;
    }

    public void resumeGameState() {
        this.mGameState = this.mSavedGameState;
    }

    public boolean saveGameState() {
        if (this.mGameState != tGameState.kGameState_Stopped && this.mPlayer != null && (this.mPlayer.mHealth > 0 || this.mHighScoreAchieved)) {
            GameState.deleteFile(kSaveGameFilename);
            GameState gameState = new GameState(kSaveGameFilename, false);
            this.serializeWithBinaryFile(gameState);
            gameState.close();
            gameState = null;
            return true;
        }
        return false;
    }

    public void sellTowerAtTileGridIndex(int n) {
        if (this.mTileGrid[n] != null && this.mTileGrid[n].mType == Entity.kTowerType) {
            int n2 = this.getTowerSellCostAtTileGridIndex(n);
            Tower tower = (Tower)this.mTileGrid[n];
            this.mPlayer.mResources += n2;
            if (tower.mHasBeenSimulated) {
                this.addScore(-2500);
            }
            tower.mRemoveFromList = true;
            this.updateWithElapsedTime(0.0f);
        }
    }

    private int PACK_VERSION_NUMBER(int n, int n2, int n3) {
        return n * 10000 + n2 * 100 + n3;
    }

    public void serializeWithBinaryFile(GameState gameState) {
        int n;
        Entity entity;
        int n2;
        Object object;
        Object object2;
        int n3;
        StreamStats streamStats;
        int n4;
        if (!gameState.beginSerializing()) {
            return;
        }
        int n5 = -1168197103;
        if ((n5 = gameState.SERIALIZE(n5)) != -1168197103) {
            return;
        }
        int n6 = this.PACK_VERSION_NUMBER(1, 2, 2);
        gameState.mVersion = gameState.SERIALIZE(n6);
        if (gameState.isLoading()) {
            this.mName = gameState.SERIALIZE_STRING(this.mName);
            this.mFilename = gameState.SERIALIZE_STRING(this.mFilename);
        } else {
            gameState.SERIALIZE_STRING(this.mName);
            gameState.SERIALIZE_STRING(this.mFilename);
        }
        this.mDifficultyLevel = gameState.SERIALIZE(this.mDifficultyLevel);
        this.mGameplayMode = gameState.SERIALIZE(this.mGameplayMode);
        if (this.mGameHudForm.mTutorialParent != null) {
            this.mGameHudForm.mTutorialParent.mTrackParentPos = true;
            this.mGameHudForm.mTutorialParent.mIsHidden = true;
        }
        this.mPlayer.serializeWithBinaryFile(gameState);
        this.mGameCountdownTimer = gameState.SERIALIZE(this.mGameCountdownTimer);
        this.mWaveIndex = gameState.SERIALIZE(this.mWaveIndex);
        this.mUnboundedWaveIndex = gameState.SERIALIZE(this.mUnboundedWaveIndex);
        this.mIsCompleted = gameState.SERIALIZE(this.mIsCompleted);
        this.mHighScoreAchieved = gameState.SERIALIZE(this.mHighScoreAchieved);
        this.mCurrentPlayTimeTick = gameState.SERIALIZE(this.mCurrentPlayTimeTick);
        if (gameState.isLoading() && this.mGameCountdownTimer <= 0.0f) {
            this.beginWave(this.mUnboundedWaveIndex, true);
        }
        this.mNumSpawnsRemaining = gameState.SERIALIZE(this.mNumSpawnsRemaining);
        this.mNumEnemiesAlive = gameState.SERIALIZE(this.mNumEnemiesAlive);
        int n7 = Entity.getLastUniqueID();
        n7 = gameState.SERIALIZE(n7);
        if (gameState.isLoading()) {
            Entity.setLastUniqueID(n7);
        }
        this.mGameHudForm.serializeWithBinaryFile(gameState);
        if (gameState.isLoading()) {
            for (n4 = 0; n4 < this.mStreamStatsList.size(); ++n4) {
                streamStats = (StreamStats)this.mStreamStatsList.elementAt(n4);
                streamStats.serializeWithBinaryFile(gameState);
            }
        } else {
            for (n4 = 0; n4 < this.mStreamStatsList.size(); ++n4) {
                streamStats = (StreamStats)this.mStreamStatsList.elementAt(n4);
                streamStats.serializeWithBinaryFile(gameState);
            }
        }
        n4 = this.mEnemyList.size();
        n4 = gameState.SERIALIZE(n4);
        if (gameState.isLoading()) {
            for (n3 = 0; n3 < n4; ++n3) {
                int n8 = 0;
                n8 = gameState.SERIALIZE(n8);
                object2 = (StreamStats)this.mStreamStatsList.elementAt(n8);
                object = new Enemy(((StreamStats)object2).mEnemyClass, this);
                ((Enemy)object).serializeWithBinaryFile(gameState);
                this.addEnemy((Enemy)object);
                object = null;
            }
        } else {
            for (n3 = 0; n3 < this.mEnemyList.size(); ++n3) {
                Enemy enemy = (Enemy)this.mEnemyList.elementAt(n3);
                int n9 = enemy.mStreamIndex;
                n9 = gameState.SERIALIZE(n9);
                enemy.serializeWithBinaryFile(gameState);
            }
        }
        n3 = this.mTowerList.size();
        n3 = gameState.SERIALIZE(n3);
        if (gameState.isLoading()) {
            for (n2 = 0; n2 < n3; ++n2) {
                int n10 = 0;
                n10 = gameState.SERIALIZE(n10);
                object = (TowerClass)Map.getTowerClassList().elementAt(n10);
                entity = new Tower((TowerClass)object, this);
                ((Tower)entity).serializeWithBinaryFile(gameState);
                ((Tower)entity).restoreTargetFromEnemyList(this.mEnemyList);
                this.addTower((Tower)entity);
                ((Tower)entity).cacheAliveEnemiesWithinAttackRange();
                entity = null;
            }
            for (n2 = 0; n2 < this.mTowerList.size(); ++n2) {
                Tower tower = (Tower)this.mTowerList.elementAt(n2);
                tower.updateWithElapsedTime(0.0f);
            }
        } else {
            for (n2 = 0; n2 < this.mTowerList.size(); ++n2) {
                object2 = (Tower)this.mTowerList.elementAt(n2);
                int n11 = Map.getTowerClassList().indexOf(((Tower)object2).mTowerClass);
                n11 = gameState.SERIALIZE(n11);
                ((Tower)object2).serializeWithBinaryFile(gameState);
            }
        }
        n2 = this.mProjectileList.size();
        n2 = gameState.SERIALIZE(n2);
        Vector vector = Map.getProjectileClassList();
        if (gameState.isLoading()) {
            Object object3;
            for (n = 0; n < n2; ++n) {
                int n12 = 0;
                n12 = gameState.SERIALIZE(n12);
                object3 = (ProjectileClass)gProjectileClassList.elementAt(n12);
                Projectile projectile = new Projectile((ProjectileClass)object3, this, (Tower)null, (Enemy)null);
                projectile.serializeWithBinaryFile(gameState);
                projectile.restoreTargetFromEnemyList(this.mEnemyList);
                projectile.restoreTowerFromTowerList(this.mTowerList);
                this.addProjectile(projectile);
                projectile = null;
            }
            for (int i = 0; i < this.mProjectileList.size(); ++i) {
                object3 = (Projectile)this.mProjectileList.elementAt(i);
                ((Projectile)object3).updateWithElapsedTime(0.0f);
            }
        } else {
            for (n = 0; n < this.mProjectileList.size(); ++n) {
                entity = (Projectile)this.mProjectileList.elementAt(n);
                int n13 = vector.indexOf(((Projectile)entity).mProjectileClass);
                n13 = gameState.SERIALIZE(n13);
                ((Projectile)entity).serializeWithBinaryFile(gameState);
            }
        }
        if (!gameState.endSerializing()) {
            return;
        }
        if (gameState.isLoading()) {
            this.updatePathingForAllEnemies();
            for (n = 0; n < this.mEnemyList.size(); ++n) {
                Enemy enemy = (Enemy)this.mEnemyList.elementAt(n);
                enemy.updateWithElapsedTime(0.0f);
            }
        }
        if (gameState.isLoading()) {
            this.pauseGame();
        }
    }

    public void setMapNameFromSaveFile() {
        if (GameState.doesFileExist(kSaveGameFilename)) {
            GameState gameState = new GameState(kSaveGameFilename, true);
            int n = 0;
            gameState.beginSerializing();
            n = gameState.SERIALIZE(n);
            int n2 = this.PACK_VERSION_NUMBER(1, 2, 2);
            n2 = gameState.SERIALIZE(n2);
            this.mFilename = null;
            this.mName = null;
            this.mName = gameState.SERIALIZE_STRING(this.mName);
            this.mFilename = gameState.SERIALIZE_STRING(this.mFilename);
            gameState.close();
            gameState = null;
        }
    }

    public void startNewGame() {
        String string = "Press any key to begin play";
        this.mGameHudForm.setStatusString(string, 0.0f, true);
        if (this.mGameHudForm != null) {
            this.mGameHudForm.mFirstTouch = true;
        }
    }

    public void suspendGameState() {
        this.mSavedGameState = this.mGameState;
        this.mGameState = tGameState.kGameState_Paused;
    }

    public void unpauseGame() {
        this.mGameState = tGameState.kGameState_Running;
    }

    public void updateStatusTextWithCurrentRound() {
        String string = "Round " + (Math.max(this.mUnboundedWaveIndex, 0) + 1);
        this.mGameHudForm.setStatusString(string, 9999.0f, true);
    }

    public void updatePathingForAllEnemies() {
        for (int i = 0; i < this.mEnemyList.size(); ++i) {
            Enemy enemy = (Enemy)this.mEnemyList.elementAt(i);
            if (!(enemy.mHealth > 0.0f) || enemy.mEnemyClass.mType == tEnemyType.kEnemyType_Air) continue;
            Point point = this.getTilePosFromTileGridIndex(enemy.mTileGridIndex);
            Wave wave = (Wave)this.mWaves.elementAt(this.mWaveIndex);
            Stream stream = (Stream)wave.mStreams.elementAt(enemy.mStreamIndex);
            Vector vector = ((Path)this.mPathList.elementAt((int)stream.mPathIndex)).mGoalTiles;
            enemy.mPathNodes.removeAllElements();
            boolean bl = false;
            this.mPathFinder.findPathFromTilePos(point.x, point.y, this.mTileGrid, enemy.mPathNodes, this, bl, vector);
            enemy.mPathNodesDirty = true;
            enemy.mCurrentPathNode = enemy.mPathNodes.size() - 1;
            if (enemy.mCurrentPathNode >= 0) continue;
            enemy.mCurrentPathNode = 0;
        }
    }

    public void renderWithElapsedTime(MapGraphics mapGraphics, float f) {
        Object object;
        int n;
        if (this.mGameState == tGameState.kGameState_Stopped) {
            return;
        }
        if (this.mGameState == tGameState.kGameState_Paused) {
            f = 0.0f;
        }
        mapGraphics.setClip(0, 0, mapGraphics.screenWidth, mapGraphics.screenHeight);
        mapGraphics.drawImage(this.mMapTextureID, 0, 0, 20);
        Wave wave = null;
        int n2 = this.mStreamIndicatorWaveIndex = this.mNumSpawnsRemaining == 0 && this.mNumEnemiesAlive == 0 ? this.mWaveIndex + 1 : this.mWaveIndex;
        if (this.mGameplayMode == 1 && this.mStreamIndicatorWaveIndex >= this.mWaves.size()) {
            while (this.mStreamIndicatorWaveIndex > this.mEndlessModeWaveEnd) {
                this.mStreamIndicatorWaveIndex -= this.mEndlessModeWaveEnd - this.mEndlessModeWaveStart + 1;
            }
        }
        if (this.mStreamIndicatorWaveIndex >= 0 && this.mStreamIndicatorWaveIndex < this.mWaves.size()) {
            wave = (Wave)this.mWaves.elementAt(this.mStreamIndicatorWaveIndex);
            block1: for (n = 0; n < wave.mStreams.size(); ++n) {
                object = (Stream)wave.mStreams.elementAt(n);
                for (int i = n + 1; i < wave.mStreams.size(); ++i) {
                    Stream stream = (Stream)wave.mStreams.elementAt(i);
                    if (((Stream)object).mPathIndex != stream.mPathIndex) continue;
                    stream.mIndicatorOpacity = Math.max(((Stream)object).mIndicatorOpacity, stream.mIndicatorOpacity);
                    continue block1;
                }
            }
        }
        QuickSorter.sort(this.mRenderList);
        QuickSorter.sort(this.mRenderLastList);
        for (n = 0; n < this.mRenderFirstListUnsorted.size(); ++n) {
            object = (Entity)this.mRenderFirstListUnsorted.elementAt(n);
            ((Entity)object).renderWithElapsedTime(mapGraphics, f);
        }
        for (n = 0; n < this.mRenderList.size(); ++n) {
            object = (Entity)this.mRenderList.elementAt(n);
            ((Entity)object).renderWithElapsedTime(mapGraphics, f);
        }
        for (n = 0; n < this.mRenderLastList.size(); ++n) {
            object = (Entity)this.mRenderLastList.elementAt(n);
            ((Entity)object).renderWithElapsedTime(mapGraphics, f);
        }
        Projectile projectile = null;
        for (int i = 0; i < this.mProjectileList.size(); ++i) {
            projectile = (Projectile)this.mProjectileList.elementAt(i);
            projectile.renderWithElapsedTime(mapGraphics, f);
        }
        this.renderOverlaysInList(mapGraphics, this.mRenderLastOverlayList);
        this.renderEscapeFlash(mapGraphics, f);
    }

    void renderEscapeFlash(MapGraphics mapGraphics, float f) {
        if (this.mTimeToShowFlash > 0.0f) {
            this.mTimeToShowFlash -= f;
            mapGraphics.setColor(255, 0, 0);
            mapGraphics.fillRectAbsolute(0, 0, mapGraphics.screenWidth, mapGraphics.screenHeight);
        }
    }

    protected void UpdateEnemyPos(Enemy enemy) {
        int n = sRan.nextInt(200);
        int n2 = sRan.nextInt(200);
        CGPoint cGPoint = new CGPoint(50 + n, 50 + n2);
        int n3 = this.getTileGridIndexForWorldPos((int)cGPoint.x, (int)cGPoint.y);
        if (n3 > 0) {
            cGPoint = this.getWorldPosFromTileGridIndex(n3);
            enemy.mStreamIndex = 0;
            enemy.mHealth = 100.0f;
            enemy.mX = cGPoint.x + (float)this.mTileWidth * 0.5f;
            enemy.mY = cGPoint.y + (float)this.mTileHeight * 0.5f;
            enemy.mTileGridIndex = n3;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateWithElapsedTime(float f) {
        if (this.mGameState == tGameState.kGameState_Running || f < 0.001f) {
            Object object;
            if (this.mWaveIndex == -1) {
                this.mGameCountdownTimer -= f;
                String string = "Game will begin in ";
                if (this.mGameCountdownTimer <= 0.0f) {
                    string = string + "0";
                    this.mGameHudForm.setStatusString(string, 0.0f, false);
                    this.mFirstWave = true;
                    this.beginNextWave();
                } else {
                    string = string + ((int)this.mGameCountdownTimer + 1);
                    this.mGameHudForm.setStatusString(string);
                }
            }
            if (this.mWaveIndex >= 0 && !this.mIsCompleted && this.mEnemyList != null) {
                void stream;
                ++this.mCurrentPlayTimeTick;
                int n2 = this.mEnemyList.size();
                if (n2 == 0 && this.mNumSpawnsRemaining <= 0) {
                    this.beginNextWave();
                }
                object = (Wave)this.mWaves.elementAt(this.mWaveIndex);
                boolean n = false;
                while (stream < ((Wave)object).mStreams.size()) {
                    Stream stream2 = (Stream)((Wave)object).mStreams.elementAt((int)stream);
                    StreamStats streamStats = (StreamStats)this.mStreamStatsList.elementAt((int)stream);
                    streamStats.mTimeSinceStreamStart += f;
                    streamStats.mTimeBeforeNextSpawn += f;
                    if (streamStats.mNumSpawnsRemaining > 0) {
                        stream2.mIndicatorOpacity += 2.0f * f;
                        stream2.mIndicatorOpacity = Math.min(stream2.mIndicatorOpacity, 1.0f);
                        if ((double)streamStats.mTimeBeforeNextSpawn >= 0.0) {
                            --this.mNumSpawnsRemaining;
                            ++this.mNumEnemiesAlive;
                            streamStats.mTimeBeforeNextSpawn -= stream2.mSpawnRate;
                            ++streamStats.mNumEnemiesAlive;
                            --streamStats.mNumSpawnsRemaining;
                            Enemy enemy = new Enemy(streamStats.mEnemyClass, this);
                            enemy.mStreamIndex = stream;
                            float f2 = 1.0f;
                            if (this.mDifficultyLevel == 0) {
                                f2 = 0.7f;
                            } else if (this.mDifficultyLevel == 0) {
                                f2 = 1.0f;
                            } else if (this.mDifficultyLevel == 2) {
                                f2 = 1.2f;
                            }
                            enemy.applyHealthModifier(streamStats.mHealthModifier * f2 * ((Wave)object).mHealthModifiers[this.mDifficultyLevel]);
                            if (stream2.mPathIndex >= 0 && stream2.mPathIndex < this.mPathList.size()) {
                                Integer n3 = (Integer)((Path)this.mPathList.elementAt((int)stream2.mPathIndex)).mSpawnTiles.elementAt(0);
                                enemy.mTileGridIndex = n3;
                            } else {
                                this.UpdateEnemyPos(enemy);
                            }
                            this.addEnemy(enemy);
                        }
                    } else if (streamStats.mTimeSinceStreamStart >= 1.5f) {
                        stream2.mIndicatorOpacity -= 2.0f * f;
                        stream2.mIndicatorOpacity = Math.max(stream2.mIndicatorOpacity, 0.0f);
                    } else {
                        stream2.mIndicatorOpacity += 2.0f * f;
                        stream2.mIndicatorOpacity = Math.min(stream2.mIndicatorOpacity, 1.0f);
                    }
                    ++stream;
                }
            }
            if (this.mNumSpawnsRemaining == 0 && this.mNumEnemiesAlive == 0 && this.mStreamIndicatorWaveIndex >= 0 && this.mStreamIndicatorWaveIndex < this.mWaves.size() && this.mWaves.size() > 0) {
                Wave wave = (Wave)this.mWaves.elementAt(this.mStreamIndicatorWaveIndex);
                for (int i = 0; i < wave.mStreams.size(); ++i) {
                    Stream stream = (Stream)wave.mStreams.elementAt(i);
                    stream.mIndicatorOpacity += 2.0f * f;
                    stream.mIndicatorOpacity = Math.min(stream.mIndicatorOpacity, 1.0f);
                }
            }
            if (this.mRenderFirstListUnsorted != null) {
                for (int i = this.mRenderFirstListUnsorted.size() - 1; i >= 0; --i) {
                    object = (Entity)this.mRenderFirstListUnsorted.elementAt(i);
                    boolean bl = ((Entity)object).updateWithElapsedTime(f);
                    if (!bl) continue;
                    if (((Entity)object).mType == Entity.kEnemyType) {
                        this.mEnemyList.removeElement(object);
                    }
                    if (((Entity)object).mType == Entity.kTowerType) {
                        int n = ((Entity)object).mTileGridIndex;
                        this.mTileGrid[n] = null;
                        this.updatePathingForAllEnemies();
                        this.mTowerList.removeElement(object);
                    }
                    this.mRenderFirstListUnsorted.removeElementAt(i);
                }
            }
            if (this.mRenderList != null) {
                for (int i = this.mRenderList.size() - 1; i >= 0; --i) {
                    object = (Entity)this.mRenderList.elementAt(i);
                    boolean bl = ((Entity)object).updateWithElapsedTime(f);
                    if (!bl) continue;
                    if (((Entity)object).mType == Entity.kEnemyType) {
                        this.mEnemyList.removeElement(object);
                    } else if (((Entity)object).mType == Entity.kTowerType) {
                        int n = ((Entity)object).mTileGridIndex;
                        this.mTileGrid[n] = null;
                        this.updatePathingForAllEnemies();
                        this.mTowerList.removeElement(object);
                    }
                    this.mRenderList.removeElementAt(i);
                }
            }
            if (this.mRenderLastList != null) {
                for (int i = this.mRenderLastList.size() - 1; i >= 0; --i) {
                    object = (Entity)this.mRenderLastList.elementAt(i);
                    boolean bl = ((Entity)object).updateWithElapsedTime(f);
                    if (!bl) continue;
                    if (((Entity)object).mType == Entity.kEnemyType) {
                        this.mEnemyList.removeElement(object);
                    } else if (((Entity)object).mType == Entity.kTowerType) {
                        int n = ((Entity)object).mTileGridIndex;
                        this.mTileGrid[n] = null;
                        this.updatePathingForAllEnemies();
                        this.mTowerList.removeElement(object);
                    }
                    this.mRenderLastList.removeElementAt(i);
                }
            }
            if (this.mProjectileList != null) {
                for (int i = this.mProjectileList.size() - 1; i >= 0; --i) {
                    object = (Projectile)this.mProjectileList.elementAt(i);
                    boolean bl = ((Projectile)object).updateWithElapsedTime(f);
                    if (!bl) continue;
                    this.mProjectileList.removeElementAt(i);
                }
            }
            if (this.mWaveIndex >= 0 && !this.mIsCompleted && this.mEnemyList != null && this.mEnemyList.size() == 0 && this.mNumSpawnsRemaining <= 0) {
                this.endWave();
            }
        }
    }

    int getTileGridIndexForTilePos(int n, int n2) {
        return this.mTilesAcross * n2 + n;
    }

    int getTileGridIndexForWorldPos(int n, int n2) {
        int n3 = (n - this.mOffsetX) / this.mTileWidth;
        int n4 = (n2 - this.mOffsetY) / this.mTileHeight;
        if (n3 >= 0 && n3 < this.mTilesAcross && n4 >= 0 && n4 < this.mTilesDown) {
            return this.getTileGridIndexForTilePos(n3, n4);
        }
        return -1;
    }

    public void upgradeTowerAtTileGridIndex(int n) {
        Entity entity = this.mTileGrid[n];
        if (entity.mType == Entity.kTowerType) {
            Tower tower = (Tower)entity;
            tower.initiateUpgrade();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

