/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class Projectile
extends Entity {
    ProjectileClass mProjectileClass;
    Map mMap;
    int mTargetUniqueID;
    int mTowerUniqueID;
    float mScale;
    float mVerticalOffset;
    boolean mIsVisible;
    int mYOffset;
    Vector2f mVelocity;
    Vector2f mTargetLocation;
    Tower mTower;
    Enemy mTarget;
    float mDisplayTimer;
    float mAnimTimer;
    float mParticleTimer;
    float mVisibleTimer;
    float mTimeToImpactTimer;
    float mRotationSpeed;
    float mTargetOffsetX;
    float mTargetOffsetY;
    int mAnimFrame;
    boolean mHasImpact;
    boolean mIsDead;
    boolean mIsDirectional;
    boolean mMirrorHorizontal;
    int mMirrorType;
    String mProjectileName;
    float mProjectileToEnemyAngle;
    AnimationComplete mAnimComplete = null;
    long mAnimationStartTime = 0L;
    Point topLeft = new Point();
    Point bottomLeft = new Point();
    Point topRight = new Point();
    Point bottomRight = new Point();
    Point prevPos = new Point();
    Point pos = new Point();
    Point hitPoint = new Point();

    public Projectile(ProjectileClass projectileClass, Map map, Tower tower) {
        super(projectileClass);
        if (projectileClass.mName.compareTo("projectile_flame") == 0) {
            this.mTargetOffsetX = 5.0f - 10.0f * Map.sRan.nextFloat();
            this.mTargetOffsetY = 5.0f - 10.0f * Map.sRan.nextFloat();
        }
        this.mProjectileClass = projectileClass;
        this.mMap = map;
        this.mAnimTimer = 0.0f;
        this.mTimeToImpactTimer = 0.0f;
        this.mDisplayTimer = projectileClass.mDisplayTime;
        this.mAnimFrame = 0;
        this.mTower = tower;
        if (this.mTower != null) {
            this.mX = this.mTower.mX;
            this.mY = this.mTower.mY;
        }
        this.prevPos.x = (int)this.mX;
        this.prevPos.y = (int)this.mY;
        this.mHasImpact = false;
        this.mIsDead = false;
        this.mIsVisible = false;
        this.mTarget = null;
        this.mTargetLocation = null;
        this.mParticleTimer = 0.0f;
        this.mVerticalOffset = 0.0f;
        this.mScale = 1.0f;
        this.mProjectileToEnemyAngle = 0.0f;
        this.mYOffset = 0;
        this.mRotationSpeed = RandomUtilities.RANDOM_FLOAT_IN_RANGE(this.mProjectileClass.mMinRotationSpeed, this.mProjectileClass.mMaxRotationSpeed);
        this.mVelocity = new Vector2f();
        this.mIsDirectional = false;
        this.mMirrorHorizontal = false;
        this.mAnimationStartTime = System.currentTimeMillis();
        this.mProjectileName = "";
        this.mAnimComplete = null;
        if (this.mTower != null) {
            this.mVisibleTimer = tower.mTechLevel.mProjectileSpawnDelay;
        }
    }

    public Projectile(ProjectileClass projectileClass, Map map, Tower tower, Enemy enemy) {
        this(projectileClass, map, tower);
        this.mTarget = enemy;
        this.mIsDirectional = false;
        this.mMirrorHorizontal = false;
        this.mAnimComplete = new AnimationComplete();
    }

    public Projectile(ProjectileClass projectileClass, Map map, Tower tower, Vector2f vector2f) {
        this(projectileClass, map, tower);
        this.mTargetLocation = vector2f;
        this.mIsDirectional = false;
        this.mMirrorHorizontal = false;
        this.mAnimComplete = new AnimationComplete();
    }

    public void applyDamageToEnemy(Enemy enemy, float f) {
        float f2 = 0.0f;
        f2 = RandomUtilities.RANDOM_FLOAT_IN_RANGE(this.mTower.mTechLevel.mMinDamage, this.mTower.mTechLevel.mMaxDamage);
        if (this.mTower.mTechLevel.mSplashDamageModifier > 0.001f) {
            for (int i = 0; i < this.mMap.mEnemyList.size(); ++i) {
                float f3;
                Enemy enemy2 = (Enemy)this.mMap.mEnemyList.elementAt(i);
                if (enemy2 == enemy || !(enemy2.mHealth >= 0.0f) || !((f3 = (this.mX - enemy2.mX) * (this.mX - enemy2.mX) + (this.mY - enemy2.mY) * (this.mY - enemy2.mY)) <= this.mTower.mTechLevel.mSplashDamageRange * this.mTower.mTechLevel.mSplashDamageRange)) continue;
                enemy2.mHealth -= f2 * this.mTower.mTechLevel.mSplashDamageModifier;
                enemy2.mShowHealth = true;
            }
        }
        this.mHasImpact = true;
        if (enemy != null) {
            enemy.mHealth -= f2;
            enemy.mShowHealth = true;
            if (this.mProjectileClass.mEffectType != tEffectType.kEffectType_None && !enemy.mEnemyClass.mSlowImmunity) {
                int n;
                Effect effect = null;
                for (n = 0; n < enemy.mEffectList.size(); ++n) {
                    Effect effect2 = (Effect)enemy.mEffectList.elementAt(n);
                    if (effect2.mProjectileClass.mEffectType != this.mProjectileClass.mEffectType) continue;
                    effect = effect2;
                    break;
                }
                if (effect == null) {
                    effect = new Effect();
                    effect.mOpacity = 0.0f;
                    enemy.mEffectList.addElement(effect);
                }
                effect.mTimeRemaining = this.mProjectileClass.mEffectDuration;
                effect.mProjectileClass = this.mProjectileClass;
                effect.mTowerTechLevelIndex = this.mTower.mTechLevelIndex;
                effect.mProjectileClassIndex = n = Map.getProjectileClassList().indexOf(this.mProjectileClass);
            }
        }
    }

    public float findAngleToTarget(Enemy enemy) {
        float f;
        Vector2f vector2f = new Vector2f();
        vector2f.x = enemy.mX - this.mX;
        vector2f.y = enemy.mY - this.mY;
        vector2f.normalize();
        this.mProjectileToEnemyAngle = f = vector2f.computeAngleBetweenVector(Vector2f.orientationAxis());
        if (vector2f.isCounterClockwiseToVector(Vector2f.orientationAxis())) {
            f = 6.28f - f;
        }
        return f;
    }

    public void renderBulletProjectileWithElapsedTime(MapGraphics mapGraphics, float f) {
        if (!this.mHasImpact) {
            float f2 = this.mProjectileClass.mType != 2 ? this.findAngleToTarget(this.mTarget) : this.mTimeToImpactTimer * this.mRotationSpeed;
            if (this.mIsDirectional) {
                this.mAnimationController.renderProjectileWithAnimation(mapGraphics, 20, this.mAnimFrame, null, this.mX + this.mTargetOffsetX, this.mY + this.mTargetOffsetY, f2, this.mScale, true, this.mMirrorType);
            } else {
                this.mAnimationController.renderProjectileWithAnimation(mapGraphics, 20, this.mAnimFrame, null, this.mX + this.mTargetOffsetX, this.mY + this.mTargetOffsetY, f2, this.mScale, true, this.mMirrorType);
            }
        } else {
            float f3 = (int)RandomUtilities.RANDOM_FLOAT(Float.MAX_VALUE) % 360;
            f3 = 0.0f;
            f3 = (float)Math.toRadians(f3);
            this.mAnimationController.renderWithAnimation(mapGraphics, 21, this.mAnimFrame, null, this.mX + this.mTargetOffsetX, this.mY + this.mTargetOffsetY, f3, this.mScale, false, this.mAnimComplete, 0);
            this.mIsDead = this.mAnimComplete.mIsAnimationComplete;
        }
    }

    public void renderSprayProjectileWithElapsedTime(MapGraphics mapGraphics, float f) {
        float f2 = (int)RandomUtilities.RANDOM_FLOAT(Float.MAX_VALUE) % 360;
        f2 = 0.0f;
        f2 = (float)Math.toRadians(f2);
        AnimationComplete animationComplete = null;
        float f3 = this.findAngleToTarget(this.mTarget);
        int n = (int)this.mY;
        int n2 = (int)(this.mX + this.mTarget.mX + this.mTarget.mX + this.mTarget.mX) >> 2;
        int n3 = (int)((float)n + this.mTarget.mY + this.mTarget.mY + this.mTarget.mY) >> 2;
        this.mAnimationController.renderWithAnimation(mapGraphics, 20, this.mAnimFrame, null, this.mX, this.mY - 30.0f, f2, this.mScale, true, animationComplete, 0);
        this.mAnimationController.mSprite.renderProjectileWithAnimationFrame(mapGraphics, this.mAnimationController.mCurrentAnimationFrame, null, (int)(this.mX + this.mTarget.mX) >> 1, (int)((float)n + this.mTarget.mY) >> 1, f3, 0.0f, 0);
        n2 = (int)(this.mX + this.mX + this.mX + this.mTarget.mX) >> 2;
        n3 = (int)((float)(n + n + n) + this.mTarget.mX) >> 2;
        this.mAnimationController.mSprite.renderProjectileWithAnimationFrame(mapGraphics, this.mAnimationController.mCurrentAnimationFrame, null, n2, n3, f3, 0.0f, 0);
        this.mAnimationController.renderWithAnimation(mapGraphics, 21, this.mAnimFrame, null, this.mTarget.mX, this.mTarget.mY, f2, this.mScale, true, this.mAnimationController.mIsAnimationComplete, 0);
        this.mAnimTimer += f;
        while (this.mAnimTimer > 0.1f) {
            this.mAnimTimer -= 0.1f;
            ++this.mAnimFrame;
        }
        if (this.mAnimFrame == 3) {
            this.mIsDead = true;
            this.applyDamageToEnemy(this.mTarget, f);
        }
    }

    public void renderBeamProjectileWithElapsedTime(MapGraphics mapGraphics, float f) {
        float f2 = (int)RandomUtilities.RANDOM_FLOAT(3.402823E38f) % 360;
        f2 = 0.0f;
        f2 = (float)Math.toRadians(f2);
        int n = this.mAnimFrame++;
        if (f > 0.001f) {
            // empty if block
        }
        AnimationComplete animationComplete = null;
        float f3 = this.findAngleToTarget(this.mTarget);
        int n2 = (int)this.mY;
        int n3 = (int)(this.mX + this.mTarget.mX + this.mTarget.mX + this.mTarget.mX) >> 2;
        int n4 = (int)((float)n2 + this.mTarget.mY + this.mTarget.mY + this.mTarget.mY) >> 2;
        this.mAnimationController.renderWithAnimation(mapGraphics, 20, n++, null, this.mX, n2, f2, this.mScale, true, animationComplete, 0);
        this.mAnimationController.renderWithAnimation(mapGraphics, 20, n++, null, (int)(this.mX + this.mTarget.mX) >> 1, (int)((float)n2 + this.mTarget.mY) >> 1, f2, this.mScale, true, 0);
        n3 = (int)(this.mX + this.mX + this.mX + this.mTarget.mX) >> 2;
        n4 = (int)((float)(n2 + n2 + n2) + this.mTarget.mY) >> 2;
        this.mAnimationController.renderWithAnimation(mapGraphics, 20, n++, null, n3, n4, f2, this.mScale, true, 0);
        this.mAnimationController.renderWithAnimation(mapGraphics, 21, n, null, this.mTarget.mX, this.mTarget.mY, f2, this.mScale, true, this.mAnimationController.mIsAnimationComplete, 0);
    }

    public void renderParabolicProjectileWithElapsedTime(MapGraphics mapGraphics, float f) {
        if (!this.mHasImpact) {
            int n = this.mAnimFrame;
            this.mAnimFrame = 1;
            float f2 = this.mScale;
            this.mScale = 1.0f - this.mProjectileClass.mParabolicScale + (1.0f - f2);
            this.renderBulletProjectileWithElapsedTime(mapGraphics, f);
            this.mScale = f2;
            this.mAnimFrame = n;
        }
        this.mY += this.mVerticalOffset;
        this.renderBulletProjectileWithElapsedTime(mapGraphics, f);
        this.mY -= this.mVerticalOffset;
    }

    public void renderWithElapsedTime(MapGraphics mapGraphics, float f) {
        if (this.mIsVisible) {
            if (this.mProjectileClass.mType == 1) {
                this.renderBeamProjectileWithElapsedTime(mapGraphics, f);
            } else if (this.mProjectileClass.mType == 0) {
                this.renderBulletProjectileWithElapsedTime(mapGraphics, f);
            } else if (this.mProjectileClass.mType == 2) {
                this.renderParabolicProjectileWithElapsedTime(mapGraphics, f);
            } else if (this.mProjectileClass.mType == 3) {
                this.renderSprayProjectileWithElapsedTime(mapGraphics, f);
            }
        }
    }

    public void restoreTargetFromEnemyList(Vector vector) {
        if (this.mTargetUniqueID != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Enemy enemy = (Enemy)vector.elementAt(i);
                if (enemy.mUniqueID != this.mTargetUniqueID) continue;
                this.mTarget = enemy;
            }
        }
    }

    public void restoreTowerFromTowerList(Vector vector) {
        if (this.mTowerUniqueID != 0) {
            for (int i = 0; i < vector.size(); ++i) {
                Tower tower = (Tower)vector.elementAt(i);
                if (tower.mUniqueID != this.mTowerUniqueID) continue;
                this.mTower = tower;
            }
        }
    }

    public void setFrameForMissile(int n, int n2) {
        this.mAnimFrame = n;
        this.mIsDirectional = true;
        this.mMirrorType = n2;
        this.mAnimComplete.mIsAnimationComplete = true;
    }

    public void setProjectileName(String string, int n) {
        this.mProjectileName = string;
        this.mYOffset = -15;
        this.mMirrorType = n;
        this.mProjectileToEnemyAngle = 0.0f;
    }

    public boolean updateBeamProjectileWithElapsedTime(float f) {
        if (!this.mHasImpact) {
            this.applyDamageToEnemy(this.mTarget, f);
        }
        this.mAnimTimer += f;
        this.mDisplayTimer -= f;
        return this.mDisplayTimer <= 0.0f || this.mTarget == null || this.mTower == null || this.mTower.mRemoveFromList;
    }

    boolean LineIntersectionTest2D(Point point, Point point2, Point point3, Point point4, Point point5) {
        int n = (point.y - point3.y) * (point4.x - point3.x) - (point.x - point3.x) * (point4.y - point3.y);
        int n2 = (point2.x - point.x) * (point4.y - point3.y) - (point2.y - point.y) * (point4.x - point3.x);
        if (n2 == 0) {
            return false;
        }
        n /= 128;
        if ((n2 /= 128) == 0) {
            return false;
        }
        int n3 = n * 64 / n2;
        if (n3 <= 0 || n3 >= 64) {
            return false;
        }
        int n4 = (point.y - point3.y) * (point2.x - point.x) - (point.x - point3.x) * (point2.y - point.y);
        int n5 = (n4 /= 128) * 64 / n2;
        if (n5 <= 0 || n5 >= 64) {
            return false;
        }
        point5.x = point.x + n3 * (point2.x - point.x) / 64;
        point5.y = point.y + n3 * (point2.y - point.y) / 64;
        return true;
    }

    void DoImpact(float f, boolean bl) {
        if (!this.mHasImpact) {
            this.mHasImpact = true;
            this.mAnimFrame = 0;
            if (bl) {
                this.applyDamageToEnemy(this.mTarget, f);
            }
        }
    }

    public boolean updateBulletProjectileWithElapsedTime(float f) {
        if (f < 0.001f) {
            return false;
        }
        if (this.mTarget == null) {
            this.DoImpact(f, false);
            this.mAnimTimer += f;
            while (this.mAnimTimer > 0.1f) {
                this.mAnimTimer -= 0.1f;
                ++this.mAnimFrame;
            }
            return this.mIsDead;
        }
        Vector2f vector2f = null;
        if (vector2f == null) {
            vector2f = new Vector2f();
        }
        vector2f.x = this.mTarget.mX - this.mX;
        vector2f.y = this.mTarget.mY - this.mY;
        vector2f.normalize();
        if (MathUtilities.IS_ZERO(this.mProjectileClass.mAcceleration)) {
            this.mVelocity.x = vector2f.x * this.mProjectileClass.mMaxSpeed * f;
            this.mVelocity.y = vector2f.y * this.mProjectileClass.mMaxSpeed * f;
        }
        int n = MathUtilities.simpleDistanceSquared((int)this.mX, (int)this.mY, (int)this.mTarget.mX, (int)this.mTarget.mY);
        int n2 = MathUtilities.simpleDistanceSquared(0, 0, (int)this.mVelocity.x, (int)this.mVelocity.y);
        this.prevPos.x = (int)this.mX;
        this.prevPos.y = (int)this.mY;
        if (n2 <= n) {
            this.mX += this.mVelocity.x;
            this.mY += this.mVelocity.y;
        } else {
            this.mX = this.mTarget.mX;
            this.mY = this.mTarget.mY;
            if (!this.mHasImpact) {
                this.DoImpact(f, true);
            }
        }
        float f2 = this.mTarget.mX - (float)this.mMap.mTileWidth * 0.3f;
        float f3 = this.mTarget.mX + (float)this.mMap.mTileWidth * 0.3f;
        float f4 = this.mTarget.mY - (float)this.mMap.mTileHeight * 0.3f;
        float f5 = this.mTarget.mY + (float)this.mMap.mTileHeight * 0.3f;
        this.topLeft.x = (int)f2;
        this.topLeft.y = (int)f4;
        this.bottomLeft.x = (int)f2;
        this.topLeft.y = (int)f5;
        this.topRight.x = (int)f3;
        this.topLeft.y = (int)f4;
        this.bottomRight.x = (int)f3;
        this.topLeft.y = (int)f5;
        this.pos.x = (int)this.mX;
        this.pos.y = (int)this.mY;
        if (this.LineIntersectionTest2D(this.topLeft, this.bottomLeft, this.prevPos, this.pos, this.hitPoint) || this.LineIntersectionTest2D(this.topLeft, this.topRight, this.prevPos, this.pos, this.hitPoint) || this.LineIntersectionTest2D(this.bottomLeft, this.bottomRight, this.prevPos, this.pos, this.hitPoint) || this.LineIntersectionTest2D(this.topRight, this.bottomRight, this.prevPos, this.pos, this.hitPoint)) {
            this.mX = this.mTarget.mX;
            this.mY = this.mTarget.mY;
        }
        if (this.mHasImpact || this.mX >= f2 && this.mX <= f3 && this.mY >= f4 && this.mY <= f5) {
            this.mAnimTimer += f;
            while (this.mAnimTimer > 0.1f) {
                this.mAnimTimer -= 0.1f;
                ++this.mAnimFrame;
            }
            if (!this.mHasImpact) {
                this.DoImpact(f, true);
            }
            this.mX = this.mTarget.mX;
            this.mY = this.mTarget.mY;
            return this.mIsDead;
        }
        return this.mIsDead;
    }

    public boolean updateParabolicProjectileWithElapsedTime(float f) {
        Vector2f vector2f = new Vector2f();
        vector2f.x = this.mTargetLocation.x - this.mTower.mX;
        vector2f.y = this.mTargetLocation.y - this.mTower.mY;
        float f2 = Math.min(this.mTimeToImpactTimer, this.mProjectileClass.mTimeToImpact) / this.mProjectileClass.mTimeToImpact;
        vector2f.scaleBy(f2);
        if (this.mTimeToImpactTimer >= this.mProjectileClass.mTimeToImpact) {
            this.mAnimTimer += f;
            while (this.mAnimTimer > 0.1f) {
                this.mAnimTimer -= 0.1f;
                ++this.mAnimFrame;
            }
            this.mScale = 1.0f;
            if (!this.mHasImpact) {
                this.mHasImpact = true;
                this.applyDamageToEnemy(this.mTarget, f);
            }
        } else {
            this.mTimeToImpactTimer += f;
            float f3 = MathUtilities.SQUARE(f2 - 0.5f);
            float f4 = MathUtilities.SQUARE(-0.5f);
            this.mScale = 1.0f - this.mProjectileClass.mParabolicScale + (0.5f - MathUtilities.SQUARE(f2 - 0.5f) * 2.0f) * this.mProjectileClass.mParabolicScale * 2.0f;
            this.mVerticalOffset = (f3 - f4) * this.mProjectileClass.mParabolicHeight;
            this.mX = this.mTower.mX + vector2f.x;
            this.mY = this.mTower.mY + vector2f.y;
        }
        return this.mIsDead;
    }

    public boolean updateSprayProjectileWithElapsedTime(float f) {
        return this.mIsDead;
    }

    public boolean updateWithElapsedTime(float f) {
        boolean bl = false;
        if (this.mTower == null || this.mTower.mRemoveFromList) {
            return true;
        }
        if (this.mVisibleTimer > 0.001f) {
            if (this.mProjectileClass.mType == 3) {
                bl = this.updateSprayProjectileWithElapsedTime(f);
            } else {
                this.mVisibleTimer -= f;
                if (this.mProjectileClass.mType != 2 && this.mTarget == null) {
                    bl = true;
                }
            }
        } else {
            this.mIsVisible = true;
            if (this.mProjectileClass.mType == 1) {
                bl = this.updateBeamProjectileWithElapsedTime(f);
            } else if (this.mProjectileClass.mType == 0) {
                bl = this.updateBulletProjectileWithElapsedTime(f);
            } else if (this.mProjectileClass.mType == 2) {
                bl = this.updateParabolicProjectileWithElapsedTime(f);
            } else if (this.mProjectileClass.mType == 3) {
                bl = this.updateSprayProjectileWithElapsedTime(f);
            }
        }
        if (bl) {
            // empty if block
        }
        return bl;
    }

    public void serializeWithBinaryFile(GameState gameState) {
        super.serializeWithBinaryFile(gameState);
        this.mDisplayTimer = gameState.SERIALIZE(this.mDisplayTimer);
        this.mAnimTimer = gameState.SERIALIZE(this.mAnimTimer);
        this.mParticleTimer = gameState.SERIALIZE(this.mParticleTimer);
        this.mAnimFrame = gameState.SERIALIZE(this.mAnimFrame);
        this.mHasImpact = gameState.SERIALIZE(this.mHasImpact);
        this.mIsDead = gameState.SERIALIZE(this.mIsDead);
        if (gameState.isLoading() || this.mTargetLocation == null) {
            this.mTargetLocation = new Vector2f();
        }
        this.mTimeToImpactTimer = gameState.SERIALIZE(this.mTimeToImpactTimer);
        this.mVisibleTimer = gameState.SERIALIZE(this.mVisibleTimer);
        this.mRotationSpeed = gameState.SERIALIZE(this.mRotationSpeed);
        this.mTargetLocation.serializeWithBinaryFile(gameState);
        this.mVelocity.serializeWithBinaryFile(gameState);
        int n = this.mTarget != null ? this.mTarget.mUniqueID : 0;
        this.mTargetUniqueID = gameState.SERIALIZE(n);
        int n2 = this.mTower != null ? this.mTower.mUniqueID : 0;
        this.mTowerUniqueID = gameState.SERIALIZE(n2);
    }
}

