/*
 * Decompiled with CFR 0.152.
 */
public class mMath {
    static final double sq2p1 = 2.414213562373095;
    static final double sq2m1 = 0.41421356237309503;
    static final double p4 = 16.15364129822302;
    static final double p3 = 268.42548195503974;
    static final double p2 = 1153.029351540485;
    static final double p1 = 1780.406316433197;
    static final double p0 = 896.7859740366387;
    static final double q4 = 58.95697050844462;
    static final double q3 = 536.2653740312153;
    static final double q2 = 1666.7838148816338;
    static final double q1 = 2079.33497444541;
    static final double q0 = 896.7859740366387;
    static final double PIO2 = 1.5707963267948966;
    static final double nan = Double.NaN;

    private static double mxatan(double d) {
        double d2 = d * d;
        double d3 = (((16.15364129822302 * d2 + 268.42548195503974) * d2 + 1153.029351540485) * d2 + 1780.406316433197) * d2 + 896.7859740366387;
        return (d3 /= ((((d2 + 58.95697050844462) * d2 + 536.2653740312153) * d2 + 1666.7838148816338) * d2 + 2079.33497444541) * d2 + 896.7859740366387) * d;
    }

    private static double msatan(double d) {
        if (d < 0.41421356237309503) {
            return mMath.mxatan(d);
        }
        if (d > 2.414213562373095) {
            return 1.5707963267948966 - mMath.mxatan(1.0 / d);
        }
        return 0.7853981633974483 + mMath.mxatan((d - 1.0) / (d + 1.0));
    }

    public static double atan(double d) {
        if (d > 0.0) {
            return mMath.msatan(d);
        }
        return -mMath.msatan(-d);
    }

    public static double atan2(double d, double d2) {
        if (d + d2 == d) {
            if (d >= 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        d = mMath.atan(d / d2);
        if (d2 < 0.0) {
            if (d <= 0.0) {
                return d + Math.PI;
            }
            return d - Math.PI;
        }
        return d;
    }

    public static double asin(double d) {
        int n = 0;
        if (d < 0.0) {
            d = -d;
            ++n;
        }
        if (d > 1.0) {
            return Double.NaN;
        }
        double d2 = Math.sqrt(1.0 - d * d);
        d2 = d > 0.7 ? 1.5707963267948966 - mMath.atan(d2 / d) : mMath.atan(d / d2);
        if (n > 0) {
            d2 = -d2;
        }
        return d2;
    }

    public static double acos(double d) {
        if (d > 1.0 || d < -1.0) {
            return Double.NaN;
        }
        return 1.5707963267948966 - mMath.asin(d);
    }
}

