/*
 * Decompiled with CFR 0.152.
 */
package com.distinctive;

import com.distinctive.DDFile;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKUtils;

class DDImage {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 1;
    public static final int TRANS_ROT270 = 2;
    public static final int G_TOP = 16;
    public static final int G_BOTTOM = 32;
    public static final int G_LEFT = 4;
    public static final int G_HCENTER = 1;
    public static final int G_VCENTER = 2;
    public static final int G_RIGHT = 8;
    private static final int HD_CHUNK = 0;
    private static final int FR_CHUNK = 1;
    private static final int FM_CHUNK = 2;
    private static final int F_CHUNK = 3;
    private static final int S_CHUNK = 4;
    private static final int D_CHUNK = 5;
    private static final int O_CHUNK = 6;
    private static final int FH_CHUNK = 7;
    private static final int FA_CHUNK = 8;
    private static final int FU_CHUNK = 9;
    private static final int NUM_CHUNK = 10;
    private static final int BINFILE_HEADER_STRUCTLEN = 4;
    private static final int CHUNK_HEADER_STRUCTLEN = 4;
    private static final int HD_CHUNK_NUMFRAMES = 0;
    private static final int HD_CHUNK_NUMMAPFRAMES = 2;
    private static final int HD_CHUNK_NUMIMAGES = 4;
    private static final int HD_CHUNK_FLAGS = 5;
    private static final int HD_CHUNK_STRUCTLEN = 6;
    private static final int FM_CHUNK_ORIGINAL = 0;
    private static final int FM_CHUNK_ACTUAL = 2;
    private static final int FM_CHUNK_STRUCTLEN = 4;
    private static final int FR_CHUNK_NUMSUBFRAMES = 0;
    private static final int FR_CHUNK_STRUCTLEN = 1;
    private static final int FH_CHUNK_SPACEWIDTH = 0;
    private static final int FH_CHUNK_CHARSPACING = 1;
    private static final int FH_CHUNK_UNICODECHARCOUNT = 2;
    private static final int FH_CHUNK_FONTWIDTH = 4;
    private static final int FH_CHUNK_FONTHEIGHT = 5;
    private static final int FH_CHUNK_FONTBASELINE = 6;
    private static final int FH_CHUNK_STRUCTLEN = 7;
    private static final int PALETTE_FILE_HEADER_BYTES_LENGTH = 8;
    private static final int PALETTE_FILE_BYTES_PER_ENTRY = 3;
    private static final int UTF8_FONTFORMAT1_ASCIICOUNT = 96;
    private static final int UTF8_FONTFORMAT1_ASCIIRANGESTART = 32;
    private static final int UTF8_FONTFORMAT1_ASCIIRANGEEND = 128;
    private static final int SUBFRAME_SHORT0_LO = 0;
    private static final int SUBFRAME_SHORT0_HI = 1;
    private static final int SUBFRAME_SHORT1_LO = 2;
    private static final int SUBFRAME_SHORT1_HI = 3;
    private static final int SUBFRAME_BYTE0 = 0;
    private static final int SUBFRAME_BYTE1 = 1;
    private static final int SUBFRAME_HFLIP_SHIFT = 7;
    private static final int SUBFRAME_VFLIP_SHIFT = 6;
    private static final int SUBFRAME_NUM_MASK = 31;
    private static final int BYTES_SF_BYTEDATA = 2;
    private static final int BYTES_SF_SHORTDATA = 4;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VERBOSE = false;
    private static final char[][] m_chunkIDs = new char[][]{{'H', 'D'}, {'F', 'R'}, {'F', 'M'}, {'F', 'b'}, {'S', 'b'}, {'D', 'b'}, {'O', 'b'}, {'f', 'H'}, {'f', 'A'}, {'f', 'U'}};
    private static final int MAX_FILENAME = 32;
    private static StringBuffer m_filename = new StringBuffer(32);
    private SDKImage[][] m_images = null;
    private byte[] m_spriteData = null;
    private short[] m_frameOffsets = null;
    private int[] m_chunkOffsets = null;
    private byte[] m_chunkDataSize = null;
    private short[] m_frameWidths = null;
    private int m_numImages = 0;
    private int m_numFrames = 0;
    private int m_numPalettes = 0;
    private Object m_eaFont = null;

    public void dispose() {
        if (this.m_images != null) {
            for (int i = 0; i < this.m_numPalettes; ++i) {
                for (int j = 0; j < this.m_numImages; ++j) {
                    if (this.m_images[i][j] == null) continue;
                    this.m_images[i][j] = null;
                }
                this.m_images[i] = null;
            }
        }
        this.m_images = null;
        this.m_spriteData = null;
        this.m_frameOffsets = null;
        this.m_chunkOffsets = null;
        this.m_chunkDataSize = null;
        this.m_frameWidths = null;
        this.m_eaFont = null;
        this.m_eaFont = null;
    }

    public static DDImage createSprite(String string) {
        DDImage dDImage = new DDImage();
        if (!DDImage.loadSpriteData(string, dDImage, null, 0, 0, new boolean[]{true}, false)) {
            dDImage = null;
        }
        return dDImage;
    }

    public static DDImage createSprite(String string, byte[] byArray, int n, int n2, int n3, boolean bl) {
        DDImage dDImage = new DDImage();
        boolean[] blArray = new boolean[n3];
        for (int i = 0; i < n3; ++i) {
            blArray[i] = true;
        }
        if (!DDImage.loadSpriteData(string, dDImage, byArray, n, n2, blArray, bl)) {
            dDImage = null;
        }
        return dDImage;
    }

    public static DDImage createSprite(byte[] byArray, int n, String string) {
        DDImage dDImage = new DDImage();
        try {
            dDImage.m_numImages = 1;
            dDImage.m_numFrames = 1;
            dDImage.m_numPalettes = 1;
            dDImage.m_images = new SDKImage[1][1];
            dDImage.m_images[0][0] = SDKUtils.createImage(byArray, 0, n);
            if (string != null && DDImage.loadSpriteChunkData(string, dDImage)) {
                DDImage.calculateFrameOffsets(dDImage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dDImage;
    }

    public static DDImage createPalletizedSprite(String string, int n, int n2) {
        boolean[] blArray = new boolean[n2];
        blArray[n] = true;
        return DDImage.createPalletizedSprite(string, blArray);
    }

    public static DDImage createPalletizedSprite(String string, boolean[] blArray) {
        m_filename.setLength(0);
        m_filename.append(string);
        if (string.endsWith(".spr")) {
            m_filename.setLength(string.length() - 4);
        }
        byte[] byArray = DDFile.loadFileBytes(m_filename + "pal.bin");
        DDImage dDImage = new DDImage();
        if (byArray != null) {
            int n = DDFile.retrieveShort(byArray, 4, true) / 3;
            if (!DDImage.loadSpriteData(string, dDImage, byArray, 8, n, blArray, true)) {
                dDImage = null;
            }
        } else {
            dDImage = blArray.length == 1 ? DDImage.createSprite(m_filename + ".spr", null, 0, 0, 0, false) : null;
        }
        return dDImage;
    }

    public static SDKImage createPalletizedImage(String string, int n) {
        byte[] byArray = DDFile.loadFileBytes(string + ".png");
        byte[] byArray2 = DDFile.loadFileBytes(string + "pal.bin");
        return DDImage.createPalletizedImage(byArray, byArray2, n);
    }

    private static SDKImage createPalletizedImage(byte[] byArray, byte[] byArray2, int n) {
        SDKImage sDKImage = null;
        try {
            int n2 = byArray.length;
            int n3 = DDImage.pngFindPLTE(byArray, n2);
            int n4 = DDFile.retrieveShort(byArray2, 4, true);
            int n5 = 8 + n * n4;
            for (int i = 0; i < n4; ++i) {
                byArray[n3 + i] = byArray2[n5 + i];
            }
            DDImage.pngCalcCRC(byArray, n3);
            sDKImage = SDKUtils.createImage(byArray, 0, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sDKImage;
    }

    public int getFrameCount() {
        if (this.m_spriteData == null || this.m_eaFont != null) {
            return 1;
        }
        return this.m_numFrames;
    }

    public int getFrameWidth(int n) {
        int n2 = -1;
        if (n >= 0 && n <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n2 = this.m_images[0][0].getWidth();
            } else if (this.m_frameWidths != null) {
                n2 = this.m_frameWidths[n];
            } else {
                int n3 = this.m_spriteData[this.m_chunkOffsets[1] + n * 1 + 0] & 0x1F;
                int n4 = this.m_chunkOffsets[5] + this.m_frameOffsets[n] * this.m_chunkDataSize[5];
                int n5 = this.m_chunkOffsets[6] + this.m_frameOffsets[n] * this.m_chunkDataSize[6];
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                for (int i = 0; i < n3; ++i) {
                    int n9;
                    if (this.m_chunkDataSize[5] == 4) {
                        n9 = (this.m_spriteData[n4 + 0] & 0xFF | (this.m_spriteData[n4 + 1] & 0xFF) << 8) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n8 = this.m_spriteData[n5 + 0] & 0xFF | this.m_spriteData[n5 + 1] << 8;
                        }
                    } else {
                        n9 = (this.m_spriteData[n4 + 0] & 0xFF) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n8 = this.m_spriteData[n5 + 0];
                        }
                    }
                    if (i == 0 || n8 < n7) {
                        n7 = n8;
                    }
                    if (i == 0 || n8 + n9 > n6) {
                        n6 = n8 + n9;
                    }
                    n4 += this.m_chunkDataSize[5];
                    n5 += this.m_chunkDataSize[6];
                }
                n2 = n6 - n7;
            }
        }
        return n2;
    }

    public int getFrameHeight(int n) {
        int n2 = -1;
        if (n >= 0 && n <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n2 = this.m_images[0][0].getHeight();
            } else {
                int n3 = this.m_spriteData[this.m_chunkOffsets[1] + n * 1 + 0] & 0x1F;
                int n4 = this.m_chunkOffsets[5] + this.m_frameOffsets[n] * this.m_chunkDataSize[5];
                int n5 = this.m_chunkOffsets[6] + this.m_frameOffsets[n] * this.m_chunkDataSize[6];
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                for (int i = 0; i < n3; ++i) {
                    int n9;
                    if (this.m_chunkDataSize[4] == 4) {
                        n9 = (this.m_spriteData[n4 + 2] & 0xFF | (this.m_spriteData[n4 + 3] & 0xFF) << 8) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n8 = this.m_spriteData[n5 + 2] & 0xFF | this.m_spriteData[n5 + 3] << 8;
                        }
                    } else {
                        n9 = (this.m_spriteData[n4 + 1] & 0xFF) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n8 = this.m_spriteData[n5 + 1];
                        }
                    }
                    if (i == 0 || n8 < n7) {
                        n7 = n8;
                    }
                    if (i == 0 || n8 + n9 > n6) {
                        n6 = n8 + n9;
                    }
                    n4 += this.m_chunkDataSize[5];
                    n5 += this.m_chunkDataSize[6];
                }
                n2 = n6 - n7;
            }
        }
        return n2;
    }

    public int getFrameOriginX(int n) {
        int n2 = 0;
        if (n >= 0 && n <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n2 = 0;
            } else {
                int n3 = 0;
                if (this.m_chunkOffsets[3] > 0) {
                    int n4 = this.m_chunkOffsets[3] + n * this.m_chunkDataSize[3];
                    n3 = this.m_chunkDataSize[3] == 4 ? this.m_spriteData[n4 + 0] & 0xFF | (this.m_spriteData[n4 + 1] & 0xFF) << 8 : this.m_spriteData[n4 + 0] & 0xFF;
                }
                int n5 = this.m_spriteData[this.m_chunkOffsets[1] + n * 1 + 0] & 0x1F;
                int n6 = this.m_chunkOffsets[5] + this.m_frameOffsets[n] * this.m_chunkDataSize[5];
                int n7 = this.m_chunkOffsets[6] + this.m_frameOffsets[n] * this.m_chunkDataSize[6];
                int n8 = 0;
                int n9 = 0;
                n2 = 0;
                for (int i = 0; i < n5; ++i) {
                    if (this.m_chunkDataSize[4] == 4) {
                        if (this.m_chunkOffsets[6] > 0) {
                            n2 = this.m_spriteData[n7 + 0] & 0xFF | this.m_spriteData[n7 + 1] << 8;
                        }
                    } else if (this.m_chunkOffsets[6] > 0) {
                        n2 = this.m_spriteData[n7 + 0];
                    }
                    if (i == 0 || n2 < n9) {
                        n9 = n2;
                    }
                    n6 += this.m_chunkDataSize[5];
                    n7 += this.m_chunkDataSize[6];
                }
                n2 = n3 - n9;
            }
        }
        return n2;
    }

    public int getFrameOriginY(int n) {
        int n2 = 0;
        if (n >= 0 && n <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n2 = 0;
            } else {
                int n3 = 0;
                if (this.m_chunkOffsets[3] > 0) {
                    int n4 = this.m_chunkOffsets[3] + n * this.m_chunkDataSize[3];
                    n3 = this.m_chunkDataSize[3] == 4 ? this.m_spriteData[n4 + 2] & 0xFF | (this.m_spriteData[n4 + 3] & 0xFF) << 8 : this.m_spriteData[n4 + 1] & 0xFF;
                }
                int n5 = this.m_spriteData[this.m_chunkOffsets[1] + n * 1 + 0] & 0x1F;
                int n6 = this.m_chunkOffsets[5] + this.m_frameOffsets[n] * this.m_chunkDataSize[5];
                int n7 = this.m_chunkOffsets[6] + this.m_frameOffsets[n] * this.m_chunkDataSize[6];
                int n8 = 0;
                int n9 = 0;
                n2 = 0;
                for (int i = 0; i < n5; ++i) {
                    if (this.m_chunkDataSize[4] == 4) {
                        if (this.m_chunkOffsets[6] > 0) {
                            n2 = this.m_spriteData[n7 + 2] & 0xFF | this.m_spriteData[n7 + 3] << 8;
                        }
                    } else if (this.m_chunkOffsets[6] > 0) {
                        n2 = this.m_spriteData[n7 + 1];
                    }
                    if (i == 0 || n2 < n9) {
                        n9 = n2;
                    }
                    n6 += this.m_chunkDataSize[5];
                    n7 += this.m_chunkDataSize[6];
                }
                n2 = n3 - n9;
            }
        }
        return n2;
    }

    public void drawFrame(SDKGraphics sDKGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        block29: {
            int n7;
            boolean bl;
            int n8;
            block28: {
                n8 = 0;
                if (this.m_spriteData != null && this.m_eaFont == null) break block28;
                if (this.m_images == null || this.m_images[0] == null) break block29;
                if ((n5 & 1) != 0) {
                    n -= this.getFrameWidth(n3) >> 1;
                } else if ((n5 & 8) != 0) {
                    n -= this.getFrameWidth(n3);
                }
                if ((n5 & 2) != 0) {
                    n2 -= this.getFrameHeight(n3) >> 1;
                } else if ((n5 & 0x20) != 0) {
                    n2 -= this.getFrameHeight(n3);
                }
                if (n4 < 0 || n4 >= this.m_numPalettes) {
                    n4 = 0;
                }
                sDKGraphics.drawImage(this.m_images[n4][0], n, n2, 20);
                break block29;
            }
            if (n3 < 0 || n3 >= this.m_numFrames || n4 < 0 || n4 >= this.m_numPalettes) {
                return;
            }
            if ((n5 & 1) != 0) {
                n -= this.getFrameWidth(n3) >> 1;
            } else if ((n5 & 8) != 0) {
                n -= this.getFrameWidth(n3);
            }
            if ((n5 & 2) != 0) {
                n2 -= this.getFrameHeight(n3) >> 1;
            } else if ((n5 & 0x20) != 0) {
                n2 -= this.getFrameHeight(n3);
            }
            int n9 = this.m_spriteData[this.m_chunkOffsets[1] + n3 * 1 + 0];
            int n10 = n9 & 0x1F;
            boolean bl2 = (n9 >> 7 & 1) == 1;
            boolean bl3 = bl = (n9 >> 6 & 1) == 1;
            if (bl2) {
                n8 = 2;
            }
            int n11 = 0;
            int n12 = 0;
            if (this.m_chunkOffsets[3] > 0) {
                n7 = this.m_chunkOffsets[3] + n3 * this.m_chunkDataSize[3];
                if (this.m_chunkDataSize[3] == 4) {
                    n11 = this.m_spriteData[n7 + 0] & 0xFF | (this.m_spriteData[n7 + 1] & 0xFF) << 8;
                    n12 = this.m_spriteData[n7 + 2] & 0xFF | (this.m_spriteData[n7 + 3] & 0xFF) << 8;
                } else {
                    n11 = this.m_spriteData[n7 + 0] & 0xFF;
                    n12 = this.m_spriteData[n7 + 1] & 0xFF;
                }
            }
            n7 = this.m_frameOffsets[n3];
            int n13 = this.m_chunkOffsets[4] + n7 * this.m_chunkDataSize[4];
            int n14 = this.m_chunkOffsets[5] + n7 * this.m_chunkDataSize[5];
            int n15 = this.m_chunkOffsets[6] + n7 * this.m_chunkDataSize[6];
            int n16 = 0;
            int n17 = 0;
            if (this.m_chunkDataSize[4] == 4) {
                for (n9 = 0; n9 < n10; ++n9) {
                    int n18;
                    int n19;
                    int n20 = this.m_spriteData[n13 + 0] & 0xFF | (this.m_spriteData[n13 + 1] & 0xFF) << 8;
                    int n21 = this.m_spriteData[n13 + 2] & 0xFF | (this.m_spriteData[n13 + 3] & 0xFF) << 8;
                    int n22 = this.m_spriteData[n14 + 0] & 0xFF | (this.m_spriteData[n14 + 1] & 0xFF) << 8;
                    int n23 = this.m_spriteData[n14 + 2] & 0xFF | (this.m_spriteData[n14 + 3] & 0xFF) << 8;
                    if (this.m_chunkOffsets[6] > 0) {
                        n16 = this.m_spriteData[n15 + 0] & 0xFF | this.m_spriteData[n15 + 1] << 8;
                        n17 = this.m_spriteData[n15 + 2] & 0xFF | this.m_spriteData[n15 + 3] << 8;
                    }
                    int n24 = (n22 & 1) << 1 | n23 & 1;
                    n22 >>= 1;
                    n23 >>= 1;
                    if (bl2) {
                        n19 = n - n22 - n16 + n11;
                        n18 = n2 + n17;
                    } else {
                        n19 = n + n16 - n11;
                        n18 = n2 + n17 - n12;
                    }
                    sDKGraphics.drawRegion(this.m_images[n4][n24], n20, n21, n22, n23, n8, n19, n18, 20);
                    n13 += this.m_chunkDataSize[4];
                    n14 += this.m_chunkDataSize[5];
                    n15 += this.m_chunkDataSize[6];
                }
            } else {
                for (n9 = 0; n9 < n10; ++n9) {
                    int n25;
                    int n26;
                    int n27 = this.m_spriteData[n13 + 0] & 0xFF;
                    int n28 = this.m_spriteData[n13 + 1] & 0xFF;
                    int n29 = this.m_spriteData[n14 + 0] & 0xFF;
                    int n30 = this.m_spriteData[n14 + 1] & 0xFF;
                    if (this.m_chunkOffsets[6] > 0) {
                        n16 = this.m_spriteData[n15 + 0];
                        n17 = this.m_spriteData[n15 + 1];
                    }
                    int n31 = (n29 & 1) << 1 | n30 & 1;
                    n29 >>= 1;
                    n30 >>= 1;
                    if (bl2) {
                        n26 = n - n29 - n16 + n11;
                        n25 = n2 + n17;
                    } else {
                        n26 = n + n16 - n11;
                        n25 = n2 + n17 - n12;
                    }
                    sDKGraphics.drawRegion(this.m_images[n4][n31], n27, n28, n29, n30, n8, n26, n25, 20);
                    n13 += this.m_chunkDataSize[4];
                    n14 += this.m_chunkDataSize[5];
                    n15 += this.m_chunkDataSize[6];
                }
            }
        }
    }

    public Object setEAFont(int n) {
        if (n >= 0 && n < this.m_numPalettes && this.m_eaFont != null) {
            SDKUtils.setFont(this.m_eaFont);
            SDKUtils.setFontImage(this.m_images[n][0]);
            return SDKUtils.getFont();
        }
        return null;
    }

    public int getStringWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        if (this.m_chunkOffsets[7] > 0) {
            n3 = this.m_spriteData[this.m_chunkOffsets[7] + 0] & 0xFF;
            n4 = this.m_spriteData[this.m_chunkOffsets[7] + 1];
        }
        int n5 = 0;
        while (n2 > 0) {
            int n6 = this.fontGetCharFrame(cArray[n]);
            n5 = n6 > 0 ? (n5 += this.getFrameWidth(n6) + n4) : (n5 += n3);
            ++n;
            --n2;
        }
        return n5;
    }

    public void drawString(SDKGraphics sDKGraphics, char[] cArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        int n8 = 0;
        byte by = 0;
        if (this.m_chunkOffsets[7] > 0) {
            n7 = this.m_spriteData[this.m_chunkOffsets[7] + 0] & 0xFF;
            n8 = this.m_spriteData[this.m_chunkOffsets[7] + 6] & 0xFF;
            by = this.m_spriteData[this.m_chunkOffsets[7] + 1];
        }
        if ((n6 & 9) != 0) {
            int n9 = this.getStringWidth(cArray, n, n2);
            n3 = (n6 & 8) != 0 ? (n3 -= n9) : (n3 -= n9 >> 1);
        }
        if ((n6 & 0x20) == 0) {
            n4 += n8;
        }
        while (n2 > 0) {
            if (cArray[n] == '\u0015') {
                sDKGraphics.setClip(n3, n4 + 1, 4, 1);
                sDKGraphics.fillRect(n3, n4 + 1, 4, 1);
                n3 += 4;
            } else {
                int n10 = this.fontGetCharFrame(cArray[n]);
                if (n10 >= 0) {
                    this.drawFrame(sDKGraphics, n3, n4, n10, n5, 20, 0);
                    if (n2 > 1 && cArray[n + 1] == '\u0014') {
                        sDKGraphics.setClip(n3, n4, this.getFrameWidth(n10), 2);
                        sDKGraphics.fillRect(n3, n4 + 1, this.getFrameWidth(n10), 1);
                    }
                    n3 += this.getFrameWidth(n10) + by;
                } else {
                    n3 += n7;
                }
            }
            ++n;
            --n2;
        }
    }

    private int fontGetCharFrame(int n) {
        int n2 = -1;
        if (n > 32 && n < 128) {
            n2 = this.m_chunkOffsets[8] + (n - 32) * 2;
        } else {
            int n3 = this.m_chunkOffsets[9];
            int n4 = this.m_spriteData[this.m_chunkOffsets[7] + 2 + 0] & 0xFF | (this.m_spriteData[this.m_chunkOffsets[7] + 2 + 1] & 0xFF) << 8;
            while (n4 > 0) {
                if ((this.m_spriteData[n3 + 0] & 0xFF | (this.m_spriteData[n3 + 1] & 0xFF) << 8) == n) {
                    n2 = n3 + 2;
                    break;
                }
                --n4;
                n3 += 4;
            }
        }
        if (n2 > 0) {
            n2 = this.m_spriteData[n2 + 0] & 0xFF | (this.m_spriteData[n2 + 1] & 0xFF) << 8;
        }
        return n2;
    }

    private static int findChunk(byte[] byArray, char c, char c2) {
        for (int i = 4; i < byArray.length; i += (byArray[i + 2] & 0xFF | (byArray[i + 3] & 0xFF) << 8) + 4) {
            if (byArray[i] != (byte)c || byArray[i + 1] != (byte)c2) continue;
            return i + 4;
        }
        return -1;
    }

    private static int getShort(DDImage dDImage, int n) {
        return DDFile.retrieveShort(dDImage.m_spriteData, n, true);
    }

    private static boolean loadSpriteData(String string, DDImage dDImage, byte[] byArray, int n, int n2, boolean[] blArray, boolean bl) {
        boolean bl2 = false;
        if (string.endsWith("font.png")) {
            m_filename.setLength(0);
            m_filename.append(string);
            m_filename.setLength(string.length() - 4);
            m_filename.append(".rff");
            dDImage.m_spriteData = DDFile.loadFileBytes(m_filename.toString());
            dDImage.m_eaFont = SDKUtils.loadFont(null, dDImage.m_spriteData);
            dDImage.m_numImages = 1;
            dDImage.m_numFrames = 1;
            bl2 = true;
        } else if (string.endsWith(".spr")) {
            if (DDImage.loadSpriteChunkData(string, dDImage)) {
                DDImage.calculateFrameOffsets(dDImage);
                bl2 = true;
            }
        } else {
            dDImage.m_numImages = 1;
            dDImage.m_numFrames = 1;
            bl2 = true;
        }
        dDImage.m_numPalettes = 1;
        if (byArray != null) {
            dDImage.m_numPalettes = blArray.length;
        }
        if (bl2) {
            bl2 = DDImage.loadSpriteImages(string, dDImage, null, byArray, n, n2, blArray, bl);
        }
        return bl2;
    }

    public static int pngFindPLTE(byte[] byArray, int n) {
        for (int i = 8; i < n; i += ((byArray[i + 0] & 0xFF) << 24 | (byArray[i + 1] & 0xFF) << 16 | (byArray[i + 2] & 0xFF) << 8 | (byArray[i + 3] & 0xFF) << 0) + 8 + 4) {
            if (byArray[i + 4] != 80 || byArray[i + 5] != 76 || byArray[i + 6] != 84 || byArray[i + 7] != 69) continue;
            return i + 8;
        }
        return -1;
    }

    public static void pngCalcCRC(byte[] byArray, int n) {
        int n2 = ((byArray[(n -= 4) - 4] & 0xFF) << 24 | (byArray[n - 3] & 0xFF) << 16 | (byArray[n - 2] & 0xFF) << 8 | (byArray[n - 1] & 0xFF) << 0) + 4;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            int n4 = (n3 ^ (byte)(byArray[i + n] & 0xFF)) & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((n4 & 1) != 0) {
                    n4 = 0xEDB88320 ^ n4 >>> 1;
                    continue;
                }
                n4 >>>= 1;
            }
            n3 = n4 ^ n3 >>> 8;
        }
        byArray[n + n2 + 0] = (byte)((n3 ^= 0xFFFFFFFF) >> 24 & 0xFF);
        byArray[n + n2 + 1] = (byte)(n3 >> 16 & 0xFF);
        byArray[n + n2 + 2] = (byte)(n3 >> 8 & 0xFF);
        byArray[n + n2 + 3] = (byte)(n3 >> 0 & 0xFF);
    }

    private static boolean loadSpriteImages(String string, DDImage dDImage, byte[] byArray, byte[] byArray2, int n, int n2, boolean[] blArray, boolean bl) {
        int n3 = 0;
        boolean bl2 = true;
        if (byArray == null) {
            m_filename.setLength(0);
            m_filename.append(string);
            m_filename.setLength(string.length() - 4);
            if (dDImage.m_numImages > 1) {
                m_filename.append("_0");
                n3 = m_filename.length() - 1;
            }
            m_filename.append(".png");
        } else {
            m_filename.setLength(0);
            m_filename.append(string);
        }
        dDImage.m_images = new SDKImage[dDImage.m_numPalettes][dDImage.m_numImages];
        try {
            for (int i = 0; i < dDImage.m_numImages; ++i) {
                if (dDImage.m_numImages > 1 && byArray == null) {
                    m_filename.setCharAt(n3, (char)(48 + i));
                }
                if (byArray2 == null && byArray == null) {
                    dDImage.m_images[0][i] = DDFile.loadImage(m_filename.toString());
                    continue;
                }
                if (byArray != null && byArray2 == null) {
                    dDImage.m_images[0][i] = SDKUtils.createImage(byArray, 0, DDFile.getFileLength(string));
                    continue;
                }
                int n4 = DDFile.getFileLength(m_filename.toString());
                byte[] byArray3 = byArray == null ? DDFile.loadFileBytes(m_filename.toString()) : byArray;
                if (byArray3 == null) continue;
                int n5 = DDImage.pngFindPLTE(byArray3, n4);
                int n6 = !bl ? n2 * 3 : byArray2[4] & 0xFF | (byArray2[5] & 0xFF) << 8;
                int n7 = 0;
                int n8 = n;
                while (n7 < blArray.length) {
                    if (blArray[n7]) {
                        if (n5 > 0) {
                            for (int j = 0; j < n2 * 3; ++j) {
                                byArray3[n5 + j] = byArray2[n8 + j];
                            }
                            DDImage.pngCalcCRC(byArray3, n5);
                        }
                        dDImage.m_images[n7][i] = SDKUtils.createImage(byArray3, 0, n4);
                        dDImage.m_images[n7][i].getWidth();
                    }
                    ++n7;
                    n8 += n6;
                }
                byArray3 = null;
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        return bl2;
    }

    private static boolean loadSpriteChunkData(String string, DDImage dDImage) {
        boolean bl = false;
        dDImage.m_spriteData = DDFile.loadFileBytes(string);
        if (dDImage.m_spriteData != null) {
            dDImage.m_chunkOffsets = new int[10];
            dDImage.m_chunkDataSize = new byte[10];
            for (int i = 0; i < 10; ++i) {
                dDImage.m_chunkOffsets[i] = (short)DDImage.findChunk(dDImage.m_spriteData, m_chunkIDs[i][0], m_chunkIDs[i][1]);
                dDImage.m_chunkDataSize[i] = 2;
                if (m_chunkIDs[i][1] != 'b' || dDImage.m_chunkOffsets[i] != -1) continue;
                dDImage.m_chunkOffsets[i] = (short)DDImage.findChunk(dDImage.m_spriteData, m_chunkIDs[i][0], 's');
                dDImage.m_chunkDataSize[i] = 4;
            }
            bl = true;
            if (dDImage.m_chunkOffsets[0] > 0) {
                dDImage.m_numImages = dDImage.m_spriteData[dDImage.m_chunkOffsets[0] + 4] & 0xFF;
            }
        }
        return bl;
    }

    private static void calculateFrameOffsets(DDImage dDImage) {
        int n = DDImage.getShort(dDImage, dDImage.m_chunkOffsets[0] + 0);
        int n2 = DDImage.getShort(dDImage, dDImage.m_chunkOffsets[0] + 2);
        dDImage.m_numFrames = n;
        dDImage.m_frameOffsets = new short[n];
        int n3 = 0;
        int n4 = 0;
        int n5 = dDImage.m_chunkOffsets[1];
        int n6 = dDImage.m_chunkOffsets[2];
        while (n3 < n) {
            if (n2 > 0 && DDImage.getShort(dDImage, n6 + 0) == n3) {
                n6 += 4;
            } else {
                dDImage.m_frameOffsets[n3] = (short)n4;
                n4 += dDImage.m_spriteData[n5 + 0] & 0x1F;
            }
            ++n3;
            ++n5;
        }
        n3 = 0;
        n6 = dDImage.m_chunkOffsets[2];
        while (n3 < n2) {
            dDImage.m_frameOffsets[DDImage.getShort((DDImage)dDImage, (int)(n6 + 0))] = dDImage.m_frameOffsets[DDImage.getShort(dDImage, n6 + 2)];
            ++n3;
            n6 += 4;
        }
        if (dDImage.m_chunkOffsets[7] > 0) {
            short[] sArray = new short[n];
            for (n3 = 0; n3 < n; ++n3) {
                sArray[n3] = (short)dDImage.getFrameWidth(n3);
            }
            dDImage.m_frameWidths = sArray;
        }
    }

    private static void debugCheckChunkData(DDImage dDImage) {
    }
}

