/*
 * Decompiled with CFR 0.152.
 */
class GS60_ExternalText {
    private gs60cpd applet;
    private GS60_BitStreamReader bs = new GS60_BitStreamReader();
    private String[] file_res_id_base;
    public String loaded_language;
    public short[] file_num_strings;
    private short[][] string_len;
    private int[][] string_toc;
    private byte[][] string_data;
    private byte[][] decompression_data;
    private short[] decompressor_index;
    private String[] decompressor_res_id_base;

    GS60_ExternalText() {
    }

    public void Init(gs60cpd gs60cpd2) {
        this.applet = gs60cpd2;
        this.file_num_strings = new short[2];
        this.decompressor_index = new short[2];
        this.decompressor_res_id_base = new String[2];
        this.string_toc = new int[2][];
        this.string_len = new short[2][];
        this.string_data = new byte[2][];
        this.file_res_id_base = new String[2];
        this.decompression_data = new byte[2][];
        for (int i = 0; i < 2; ++i) {
            this.file_num_strings[i] = 0;
            this.string_toc[i] = null;
            this.string_len[i] = null;
            this.string_data[i] = null;
        }
    }

    public void Destroy() {
    }

    public void SetLanguage(String string) {
        int n;
        this.loaded_language = string;
        for (n = 0; n < 2; ++n) {
            if (this.decompression_data[n] == null) continue;
            this.applet.external_text_mgr.LoadDecompressor(n, this.decompressor_res_id_base[n]);
        }
        for (n = 0; n < 2; ++n) {
            if (this.string_data[n] == null) continue;
            this.applet.external_text_mgr.LoadFile(n, this.decompressor_index[n], this.decompressor_res_id_base[n]);
        }
    }

    public boolean LoadDecompressor(int n, String string) {
        this.UnloadDecompressor(n);
        if (!this.applet.CheckIfAssetExists_J2ME_DontCallMe_UseMacroInstead(string + this.loaded_language + ".dat")) {
            return false;
        }
        this.decompressor_res_id_base[n] = string;
        this.decompression_data[n] = this.applet.LoadBinaryDataIntoNewByteBuffer_J2ME_DontCallMe_UseMacroInstead(this.decompressor_res_id_base[n] + this.loaded_language + ".dat", 0);
        return true;
    }

    public boolean LoadFile(int n, int n2, String string) {
        this.UnloadFile(n);
        if (!this.applet.CheckIfAssetExists_J2ME_DontCallMe_UseMacroInstead(string + this.loaded_language + ".dat")) {
            return false;
        }
        this.file_res_id_base[n] = string;
        this.string_data[n] = this.applet.LoadBinaryDataIntoNewByteBuffer_J2ME_DontCallMe_UseMacroInstead(this.file_res_id_base[n] + this.loaded_language + ".dat", 0);
        this.decompressor_index[n] = (short)n2;
        this.bs.Init(this.string_data[n]);
        this.file_num_strings[n] = (short)this.bs.Read(16);
        this.string_toc[n] = new int[this.file_num_strings[n]];
        this.string_len[n] = new short[this.file_num_strings[n]];
        int n3 = this.bs.Read(16);
        int n4 = this.bs.Read(16);
        int n5 = this.bs.GetOffset() + (n3 + n4) * this.file_num_strings[n];
        for (int i = 0; i < this.file_num_strings[n]; ++i) {
            this.string_toc[n][i] = n5;
            this.string_len[n][i] = (short)this.bs.Read(n4);
            n5 += this.bs.Read(n3);
        }
        return true;
    }

    public void UnloadDecompressor(int n) {
        if (this.decompression_data[n] != null) {
            this.decompression_data[n] = null;
            this.decompression_data[n] = null;
        }
    }

    public void UnloadFile(int n) {
        this.file_num_strings[n] = 0;
        this.string_toc[n] = null;
        this.string_len[n] = null;
        this.string_data[n] = null;
        this.string_data[n] = null;
    }

    public String GetString(int n, int n2) {
        this.applet.huffman_table = this.decompression_data[this.decompressor_index[n]];
        this.bs.Init(this.string_data[n]);
        this.bs.SetOffset(this.string_toc[n][n2]);
        String string = this.applet.Huffman_ConstructString(this.bs, this.string_len[n][n2]);
        return string;
    }

    public int GetStringLen(int n, int n2) {
        return this.string_len[n][n2];
    }

    public void AppendStringBuffer(StringBuffer stringBuffer, int n, int n2) {
        this.applet.huffman_table = this.decompression_data[this.decompressor_index[n]];
        this.bs.Init(this.string_data[n]);
        this.bs.SetOffset(this.string_toc[n][n2]);
        this.applet.Huffman_AppendToStringBuffer(stringBuffer, this.bs);
    }
}

