/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.screen;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ng.games.pacman.Game;
import ng.games.pacman.io.ResourceManager;

public class GameScreen
extends Canvas {
    private Vector commands = new Vector();
    private CommandListener commandListener;
    private Game game;
    private static GameScreen instance = null;
    private Command positiveCommand;
    private Command negativeCommand;
    private Image confirmImage;
    private Image declineImage;
    private boolean buttonsVisible = false;

    protected void keyPressed(int n) {
        this.game.keyPressed(n);
    }

    public void addCommand(Command command) {
        super.addCommand(command);
        this.commands.addElement(command);
    }

    public void removeCommand(Command command) {
        super.removeCommand(command);
        this.commands.removeElement(command);
    }

    public void removeAllCommands() {
        for (int i = 0; i < this.commands.size(); ++i) {
            Command command = (Command)this.commands.elementAt(i);
            super.removeCommand(command);
        }
        this.commands.removeAllElements();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, 240, 266);
        if (this.game != null) {
            this.game.paint(graphics);
        }
    }

    public void setGame(Game game) {
        this.game = game;
    }

    public static GameScreen getInstance() {
        if (instance == null) {
            instance = new GameScreen();
        }
        return instance;
    }

    private GameScreen() {
    }

    public static int getGMAction(int n) {
        return GameScreen.getInstance().getGameAction(n);
    }

    public void showButtons() {
        if (this.confirmImage == null) {
            this.confirmImage = ResourceManager.getInstance().getImage("confirm_icon");
        }
        if (this.declineImage == null) {
            this.declineImage = ResourceManager.getInstance().getImage("decline_icon");
        }
        this.buttonsVisible = true;
    }

    public void hideButtons() {
        this.buttonsVisible = false;
    }

    protected void hideNotify() {
        this.game.pauseGame();
        super.hideNotify();
    }
}

