/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DashImage {
    private static final int METADATA_IMAGE_TRANSPARENCY = 0;
    private static final int METADATA_IMAGE_FRAMESIZE = 1;
    private static final int METADATA_IMAGE_NUMFRAMES = 2;
    private int m_resId = -1;
    private int m_frameSize = 0;
    private int m_numFrames = 0;
    private Animation m_anim = null;
    private ImageSlice m_slice = null;
    protected int width = 0;
    protected int height = 0;

    private void init(int id, int frameSize, int numFrames) {
        this.m_resId = id;
        this.m_frameSize = frameSize;
        this.m_numFrames = numFrames;
        Image tmp = FS.getImageRaw(id);
        if (tmp == null) {
            return;
        }
        this.width = tmp.getWidth();
        this.height = tmp.getHeight();
        if (numFrames > 0) {
            this.m_frameSize = this.width / numFrames;
        } else if (frameSize > 0) {
            this.m_numFrames = this.width / frameSize;
        } else {
            this.m_numFrames = 1;
            this.m_frameSize = this.width;
        }
        this.m_anim = FS.getAnimation(id);
        this.m_slice = FS.getImageSlice(id);
        if (this.m_slice != null) {
            this.height = this.m_slice.originalheight;
            this.m_frameSize = this.m_slice.originalwidth / this.m_numFrames;
        }
    }

    public DashImage(int fileID) {
        int frameSize = 0;
        int numFrames = 0;
        Integer tmp = (Integer)FS.getMeta(fileID, 1);
        if (tmp != null) {
            frameSize = tmp;
        }
        if ((tmp = (Integer)FS.getMeta(fileID, 2)) != null) {
            numFrames = tmp;
        }
        this.init(fileID, frameSize, numFrames);
    }

    public static void drawImage(Graphics g, Image img, int sx, int sy, int iox, int ioy, int w, int h, int align) {
        int clipx = g.getClipX();
        int clipy = g.getClipY();
        int clipw = g.getClipWidth();
        int cliph = g.getClipHeight();
        if ((align & 1) != 0) {
            sx -= w / 2;
        } else if ((align & 8) != 0) {
            sx -= w;
        }
        if ((align & 2) != 0) {
            sy -= h / 2;
        } else if ((align & 0x20) != 0) {
            sy -= h;
        }
        g.clipRect(sx, sy, w, h);
        g.drawImage(img, -iox + sx, -ioy + sy, 20);
        g.setClip(clipx, clipy, clipw, cliph);
    }

    public static void drawImageFlipped(Graphics g, Image img, int sx, int sy, int iox, int ioy, int w, int h, int align) {
        DashImage.drawRegion(g, img, iox, ioy, w, h, 2, sx, sy, align);
    }

    int getWidth(int frame) {
        if (this.m_slice != null) {
            return this.m_slice.m_smoosh_meta[frame][2];
        }
        return 0;
    }

    int getHeight(int frame) {
        if (this.m_slice != null) {
            return this.m_slice.m_smoosh_meta[frame][3];
        }
        return 0;
    }

    public void drawImage_faster(Graphics g, int sx, int sy, int iox, int ioy, int w, int h, int align) {
        Image img = FS.getImageRaw(this.m_resId);
        if ((align & 1) != 0) {
            sx -= w / 2;
        } else if ((align & 8) != 0) {
            sx -= w;
        }
        if ((align & 2) != 0) {
            sy -= h / 2;
        } else if ((align & 0x20) != 0) {
            sy -= h;
        }
        g.setClip(sx, sy, w, h);
        g.drawImage(img, -iox + sx, -ioy + sy, 20);
    }

    public void draw(Graphics g, int x, int y, int frame, int align) {
        if (frame < 0 || frame > this.m_numFrames) {
            return;
        }
        Image img = FS.getImageRaw(this.m_resId);
        if (img == null) {
            return;
        }
        if (this.m_numFrames == 1 && this.m_slice == null) {
            try {
                g.drawImage(img, x, y, align);
            }
            catch (Throwable skeet) {
                skeet.printStackTrace();
            }
        } else if (this.m_slice != null) {
            if ((align & 1) != 0) {
                x -= this.m_frameSize / 2;
            } else if ((align & 8) != 0) {
                x -= this.m_frameSize;
            }
            if ((align & 2) != 0) {
                y -= this.height / 2;
            } else if ((align & 0x20) != 0) {
                y -= this.height;
            }
            int[] smoosh = this.m_slice.m_smoosh_meta[frame];
            DashImage.drawImage(g, img, x + smoosh[0], y + smoosh[1], smoosh[4], smoosh[5], smoosh[2], smoosh[3], 0);
        } else {
            DashImage.drawImage(g, img, x, y, frame * this.m_frameSize, 0, this.m_frameSize, this.height, align);
        }
    }

    public void draw(Graphics g, int x, int y, int w, int h, int frame, int align) {
        Image img = FS.getImageRaw(this.m_resId);
        if (img == null) {
            return;
        }
        if (this.m_numFrames == 1 && this.m_slice == null) {
            try {
                DashImage.drawImage(g, img, x, y, this.width, this.height, w, h, align);
            }
            catch (Throwable skeet) {
                skeet.printStackTrace();
            }
        } else if (this.m_slice != null) {
            if ((align & 1) != 0) {
                x -= this.m_frameSize / 2;
            } else if ((align & 8) != 0) {
                x -= this.m_frameSize;
            }
            if ((align & 2) != 0) {
                y -= this.height / 2;
            } else if ((align & 0x20) != 0) {
                y -= this.height;
            }
            int[] smoosh = this.m_slice.m_smoosh_meta[frame];
            DashImage.drawImage(g, img, x + smoosh[0], y + smoosh[1], smoosh[4], smoosh[5], w, h, 0);
        }
    }

    public void draw(Graphics g, int x, int y, int align) {
        if (this.m_anim == null) {
            this.draw(g, x, y, 0, align);
        } else {
            this.draw(g, x, y, this.m_anim.getFrame(), align);
        }
    }

    public void drawFlipped(Graphics g, int x, int y, int frame, int align) {
        if (frame < 0 || frame > this.m_numFrames) {
            return;
        }
        Image img = FS.getImageRaw(this.m_resId);
        if (img == null) {
            return;
        }
        if (this.m_numFrames == 1 && this.m_slice == null) {
            try {
                DashImage.drawRegion(g, img, 0, 0, this.m_frameSize, this.height, 2, x, y, align);
            }
            catch (Throwable skeet) {
                skeet.printStackTrace();
            }
        } else if (this.m_slice != null) {
            if ((align & 1) != 0) {
                x -= this.m_frameSize / 2;
            } else if ((align & 8) != 0) {
                x -= this.m_frameSize;
            }
            if ((align & 2) != 0) {
                y -= this.height / 2;
            } else if ((align & 0x20) != 0) {
                y -= this.height;
            }
            int[] smoosh = this.m_slice.m_smoosh_meta[frame];
            DashImage.drawImageFlipped(g, img, x + smoosh[0], y + smoosh[1], smoosh[4], smoosh[5], smoosh[2], smoosh[3], 0);
        } else {
            DashImage.drawImageFlipped(g, img, x, y, frame * this.m_frameSize, 0, this.m_frameSize, this.height, align);
        }
    }

    public int getNumFrames() {
        return this.m_numFrames;
    }

    public int getWidth() {
        return this.m_frameSize;
    }

    public int getHeight() {
        return this.height;
    }

    public static void drawRegion(Graphics g, Image i, int srcX, int srcY, int w, int h, int trans, int destX, int destY, int anchor) {
        g.drawRegion(i, srcX, srcY, w, h, trans, destX, destY, anchor);
    }
}

