/*
 * Decompiled with CFR 0.152.
 */
import Actions.CActExtension;
import Conditions.CCndExtension;
import Expressions.CValue;
import Extensions.CRunExtension;
import Frame.CLayer;
import Objects.CObject;
import Params.PARAM_OBJECT;
import RunLoop.CCreateObjectInfo;
import RunLoop.CObjInfo;
import Services.CArrayList;
import Services.CBinaryFile;
import Services.CFontInfo;
import Services.CRect;
import Sprites.CMask;
import Sprites.CSprite;
import Sprites.CSpriteGen;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CRunLayer
extends CRunExtension {
    static final int X_UP = 0;
    static final int X_DOWN = 1;
    static final int Y_UP = 2;
    static final int Y_DOWN = 3;
    static final int ALT_UP = 4;
    static final int ALT_DOWN = 5;
    int holdFValue;
    int wCurrentLayer;

    public int getNumberOfConditions() {
        return 12;
    }

    public boolean createRunObject(CBinaryFile cBinaryFile, CCreateObjectInfo cCreateObjectInfo, int n) {
        this.wCurrentLayer = this.ho.hoLayer;
        return false;
    }

    public void destroyRunObject(boolean bl) {
    }

    public int handleRunObject() {
        return 2;
    }

    public void displayRunObject(Graphics graphics) {
    }

    public void pauseRunObject() {
    }

    public void continueRunObject() {
    }

    public void saveBackground(Image image) {
    }

    public void restoreBackground(Graphics graphics) {
    }

    public void killBackground() {
    }

    public CFontInfo getRunObjectFont() {
        return null;
    }

    public void setRunObjectFont(CFontInfo cFontInfo, CRect cRect) {
    }

    public int getRunObjectTextColor() {
        return 0;
    }

    public void setRunObjectTextColor(int n) {
    }

    public CMask getRunObjectCollisionMask(int n) {
        return null;
    }

    public Image getRunObjectSurface() {
        return null;
    }

    public void getZoneInfos() {
    }

    public boolean condition(int n, CCndExtension cCndExtension) {
        switch (n) {
            case 0: {
                return this.cndAtBack(cCndExtension);
            }
            case 1: {
                return this.cndAtFront(cCndExtension);
            }
            case 2: {
                return this.cndAbove(cCndExtension);
            }
            case 3: {
                return this.cndBelow(cCndExtension);
            }
            case 4: {
                return this.cndBetween(cCndExtension);
            }
            case 5: {
                return this.cndAtBackObj(cCndExtension);
            }
            case 6: {
                return this.cndAtFrontObj(cCndExtension);
            }
            case 7: {
                return this.cndAboveObj(cCndExtension);
            }
            case 8: {
                return this.cndBelowObj(cCndExtension);
            }
            case 9: {
                return this.cndBetweenObj(cCndExtension);
            }
            case 10: {
                return this.cndIsLayerVisible(cCndExtension);
            }
            case 11: {
                return this.cndIsLayerVisibleByName(cCndExtension);
            }
        }
        return false;
    }

    boolean cndAtBack(CCndExtension cCndExtension) {
        int n = cCndExtension.getParamExpression(this.rh, 0);
        return this.cndAtBackRout(n);
    }

    boolean cndAtBackRout(int n) {
        int n2 = this.wCurrentLayer;
        n2 = n2 * 2 + 1;
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        CSprite cSprite = cSpriteGen.firstSprite;
        while (cSprite != null && (cSprite.sprFlags & 0x20) != 0 && cSprite.sprLayer < n2) {
            cSprite = cSprite.objNext;
        }
        if (cSprite != null && cSprite.sprLayer == n2) {
            CObject cObject = cSprite.sprExtraInfo;
            int n3 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
            if (n == 0) {
                n = this.holdFValue;
            }
            if (n == n3) {
                return true;
            }
        }
        return false;
    }

    boolean cndAtFront(CCndExtension cCndExtension) {
        int n = cCndExtension.getParamExpression(this.rh, 0);
        return this.cndAtFrontRout(n);
    }

    boolean cndAtFrontRout(int n) {
        int n2 = this.wCurrentLayer;
        n2 = n2 * 2 + 1;
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        CSprite cSprite = cSpriteGen.lastSprite;
        while (cSprite != null && (cSprite.sprFlags & 0x20) != 0 && cSprite.sprLayer > n2) {
            cSprite = cSprite.objPrev;
        }
        if (cSprite != null && cSprite.sprLayer == n2) {
            CObject cObject = cSprite.sprExtraInfo;
            int n3 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
            if (n == 0) {
                n = this.holdFValue;
            }
            if (n == n3) {
                return true;
            }
        }
        return false;
    }

    boolean cndAbove(CCndExtension cCndExtension) {
        int n = cCndExtension.getParamExpression(this.rh, 0);
        int n2 = cCndExtension.getParamExpression(this.rh, 1);
        return this.cndAboveRout(n, n2);
    }

    boolean cndAboveRout(int n, int n2) {
        CObject cObject = null;
        CObject cObject2 = null;
        CSprite cSprite = null;
        CSprite cSprite2 = null;
        if (n == 0) {
            n = this.holdFValue;
        }
        if (n2 == 0) {
            n2 = this.holdFValue;
        }
        int n3 = 0;
        for (int i = 0; i < this.ho.hoAdRunHeader.rhNObjects; ++i) {
            while (this.ho.hoAdRunHeader.rhObjectList[n3] == null) {
                ++n3;
            }
            cObject = this.ho.hoAdRunHeader.rhObjectList[n3];
            ++n3;
            int n4 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
            if (n != n4) continue;
            int n5 = 0;
            cSprite = cObject.roc.rcSprite;
            for (int j = 0; j < this.ho.hoAdRunHeader.rhNObjects; ++j) {
                while (this.ho.hoAdRunHeader.rhObjectList[n5] == null) {
                    ++n5;
                }
                cObject2 = this.ho.hoAdRunHeader.rhObjectList[n5];
                ++n5;
                int n6 = (cObject2.hoCreationId << 16) + (cObject2.hoNumber & 0xFFFF);
                if (n2 != n6) continue;
                cSprite2 = cObject2.roc.rcSprite;
                break;
            }
            if (cSprite == null || cSprite2 == null) break;
            if (cSprite.sprLayer != cSprite2.sprLayer) {
                return cSprite.sprLayer > cSprite2.sprLayer;
            }
            if (cSprite.sprZOrder <= cSprite2.sprZOrder) break;
            return true;
        }
        return false;
    }

    boolean cndBelow(CCndExtension cCndExtension) {
        int n = cCndExtension.getParamExpression(this.rh, 0);
        int n2 = cCndExtension.getParamExpression(this.rh, 1);
        return this.cndBelowRout(n, n2);
    }

    boolean cndBelowRout(int n, int n2) {
        CObject cObject = null;
        CObject cObject2 = null;
        CSprite cSprite = null;
        CSprite cSprite2 = null;
        if (n == 0) {
            n = this.holdFValue;
        }
        if (n2 == 0) {
            n2 = this.holdFValue;
        }
        int n3 = 0;
        for (int i = 0; i < this.ho.hoAdRunHeader.rhNObjects; ++i) {
            while (this.ho.hoAdRunHeader.rhObjectList[n3] == null) {
                ++n3;
            }
            cObject = this.ho.hoAdRunHeader.rhObjectList[n3];
            ++n3;
            int n4 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
            if (n != n4) continue;
            int n5 = 0;
            cSprite = cObject.roc.rcSprite;
            for (int j = 0; j < this.ho.hoAdRunHeader.rhNObjects; ++j) {
                while (this.ho.hoAdRunHeader.rhObjectList[n5] == null) {
                    ++n5;
                }
                cObject2 = this.ho.hoAdRunHeader.rhObjectList[n5];
                ++n5;
                int n6 = (cObject2.hoCreationId << 16) + (cObject2.hoNumber & 0xFFFF);
                if (n2 != n6) continue;
                cSprite2 = cObject2.roc.rcSprite;
                break;
            }
            if (cSprite == null || cSprite2 == null) break;
            if (cSprite.sprLayer != cSprite2.sprLayer) {
                return cSprite.sprLayer < cSprite2.sprLayer;
            }
            if (cSprite.sprZOrder >= cSprite2.sprZOrder) break;
            return true;
        }
        return false;
    }

    boolean cndBetween(CCndExtension cCndExtension) {
        int n = cCndExtension.getParamExpression(this.rh, 0);
        int n2 = cCndExtension.getParamExpression(this.rh, 1);
        int n3 = cCndExtension.getParamExpression(this.rh, 2);
        CObject cObject = null;
        CObject cObject2 = null;
        CSprite cSprite = null;
        CSprite cSprite2 = null;
        CSprite cSprite3 = null;
        if (n == 0) {
            n = this.holdFValue;
        }
        if (n2 == 0) {
            n2 = this.holdFValue;
        }
        if (n3 == 0) {
            n3 = this.holdFValue;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        for (int i = 0; i < this.ho.hoAdRunHeader.rhNObjects; ++i) {
            while (this.ho.hoAdRunHeader.rhObjectList[n4] == null) {
                ++n4;
            }
            cObject = this.ho.hoAdRunHeader.rhObjectList[n4];
            ++n4;
            int n5 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
            if (n != n5) continue;
            int n6 = 0;
            cSprite = cObject.roc.rcSprite;
            for (int j = 0; j < this.ho.hoAdRunHeader.rhNObjects; ++j) {
                while (this.ho.hoAdRunHeader.rhObjectList[n6] == null) {
                    ++n6;
                }
                cObject2 = this.ho.hoAdRunHeader.rhObjectList[n6];
                ++n6;
                int n7 = (cObject2.hoCreationId << 16) + (cObject2.hoNumber & 0xFFFF);
                if (n2 == n7) {
                    cSprite2 = cObject2.roc.rcSprite;
                    bl = true;
                }
                if (n3 == n7) {
                    cSprite3 = cObject2.roc.rcSprite;
                    bl2 = true;
                }
                if (bl && bl2) break;
            }
            if (cSprite == null || cSprite2 == null || cSprite3 == null) break;
            int n8 = -1;
            int n9 = -1;
            int n10 = -1;
            CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
            int n11 = 0;
            CSprite cSprite4 = cSpriteGen.firstSprite;
            while (cSprite4 != null) {
                if (cSprite4 == cSprite) {
                    n10 = n11;
                    if (n9 != -1 && n8 != -1) {
                        break;
                    }
                } else if (cSprite4 == cSprite2) {
                    n9 = n11;
                    if (n10 != -1 && n8 != -1) {
                        break;
                    }
                } else if (cSprite4 == cSprite3) {
                    n8 = n11;
                    if (n10 != -1 && n9 != -1) break;
                }
                cSprite4 = cSprite4.objNext;
                ++n11;
            }
            if ((n8 <= n10 || n10 <= n9) && (n9 <= n10 || n10 <= n8)) break;
            return true;
        }
        return false;
    }

    boolean cndAtBackObj(CCndExtension cCndExtension) {
        PARAM_OBJECT pARAM_OBJECT = cCndExtension.getParamObject(this.rh, 0);
        return this.lyrProcessCondition(pARAM_OBJECT, null, 0);
    }

    boolean cndAtFrontObj(CCndExtension cCndExtension) {
        PARAM_OBJECT pARAM_OBJECT = cCndExtension.getParamObject(this.rh, 0);
        return this.lyrProcessCondition(pARAM_OBJECT, null, 1);
    }

    boolean cndAboveObj(CCndExtension cCndExtension) {
        PARAM_OBJECT pARAM_OBJECT = cCndExtension.getParamObject(this.rh, 0);
        PARAM_OBJECT pARAM_OBJECT2 = cCndExtension.getParamObject(this.rh, 1);
        return this.lyrProcessCondition(pARAM_OBJECT, pARAM_OBJECT2, 2);
    }

    boolean cndBelowObj(CCndExtension cCndExtension) {
        PARAM_OBJECT pARAM_OBJECT = cCndExtension.getParamObject(this.rh, 0);
        PARAM_OBJECT pARAM_OBJECT2 = cCndExtension.getParamObject(this.rh, 1);
        return this.lyrProcessCondition(pARAM_OBJECT, pARAM_OBJECT2, 3);
    }

    boolean cndBetweenObj(CCndExtension cCndExtension) {
        boolean bl = false;
        boolean bl2 = false;
        PARAM_OBJECT pARAM_OBJECT = cCndExtension.getParamObject(this.rh, 0);
        PARAM_OBJECT pARAM_OBJECT2 = cCndExtension.getParamObject(this.rh, 1);
        PARAM_OBJECT pARAM_OBJECT3 = cCndExtension.getParamObject(this.rh, 2);
        boolean bl3 = false;
        bl = this.lyrProcessCondition(pARAM_OBJECT, pARAM_OBJECT2, 2);
        if (bl && (bl2 = this.lyrProcessCondition(pARAM_OBJECT, pARAM_OBJECT3, 3))) {
            bl3 = true;
        }
        if (!bl3) {
            bl = false;
            this.lyrResetEventList(this.lyrGetOILfromEVP(pARAM_OBJECT));
            bl2 = this.lyrProcessCondition(pARAM_OBJECT, pARAM_OBJECT2, 3);
            if (bl2 && (bl = this.lyrProcessCondition(pARAM_OBJECT, pARAM_OBJECT3, 2))) {
                bl3 = true;
            }
        }
        return bl3;
    }

    boolean cndIsLayerVisible(CCndExtension cCndExtension) {
        int n = cCndExtension.getParamExpression(this.rh, 0);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return (cLayer.dwOptions & 0x10) != 0 && (cLayer.dwOptions & 0x20000) == 0 || (cLayer.dwOptions & 0x40000) != 0;
        }
        return false;
    }

    int FindLayerByName(String string) {
        if (string != null) {
            for (int i = 0; i < this.ho.hoAdRunHeader.rhFrame.nLayers; ++i) {
                CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[i];
                if (cLayer.pName == null || !string.equalsIgnoreCase(cLayer.pName)) continue;
                return i + 1;
            }
        }
        return 0;
    }

    boolean cndIsLayerVisibleByName(CCndExtension cCndExtension) {
        String string = cCndExtension.getParamExpString(this.rh, 0);
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return (cLayer.dwOptions & 0x10) != 0 && (cLayer.dwOptions & 0x20000) == 0 || (cLayer.dwOptions & 0x40000) != 0;
        }
        return false;
    }

    public void action(int n, CActExtension cActExtension) {
        switch (n) {
            case 0: {
                this.actBackOne(cActExtension);
                break;
            }
            case 1: {
                this.actForwardOne(cActExtension);
                break;
            }
            case 2: {
                this.actSwap(cActExtension);
                break;
            }
            case 3: {
                this.actSetObj(cActExtension);
                break;
            }
            case 4: {
                this.actBringFront(cActExtension);
                break;
            }
            case 5: {
                this.actSendBack(cActExtension);
                break;
            }
            case 6: {
                this.actBackN(cActExtension);
                break;
            }
            case 7: {
                this.actForwardN(cActExtension);
                break;
            }
            case 8: {
                this.actReverse(cActExtension);
                break;
            }
            case 9: {
                this.actMoveAbove(cActExtension);
                break;
            }
            case 10: {
                this.actMoveBelow(cActExtension);
                break;
            }
            case 11: {
                this.actMoveToN(cActExtension);
                break;
            }
            case 12: {
                this.actSortByXUP(cActExtension);
                break;
            }
            case 13: {
                this.actSortByYUP(cActExtension);
                break;
            }
            case 14: {
                this.actSortByXDOWN(cActExtension);
                break;
            }
            case 15: {
                this.actSortByYDOWN(cActExtension);
                break;
            }
            case 16: {
                this.actBackOneObj(cActExtension);
                break;
            }
            case 17: {
                this.actForwardOneObj(cActExtension);
                break;
            }
            case 18: {
                this.actSwapObj(cActExtension);
                break;
            }
            case 19: {
                this.actBringFrontObj(cActExtension);
                break;
            }
            case 20: {
                this.actSendBackObj(cActExtension);
                break;
            }
            case 21: {
                this.actBackNObj(cActExtension);
                break;
            }
            case 22: {
                this.actForwardNObj(cActExtension);
                break;
            }
            case 23: {
                this.actMoveAboveObj(cActExtension);
                break;
            }
            case 24: {
                this.actMoveBelowObj(cActExtension);
                break;
            }
            case 25: {
                this.actMoveToNObj(cActExtension);
                break;
            }
            case 26: {
                this.actSortByALTUP(cActExtension);
                break;
            }
            case 27: {
                this.actSortByALTDOWN(cActExtension);
                break;
            }
            case 28: {
                this.actSetLayerX(cActExtension);
                break;
            }
            case 29: {
                this.actSetLayerY(cActExtension);
                break;
            }
            case 30: {
                this.actSetLayerXY(cActExtension);
                break;
            }
            case 31: {
                this.actShowLayer(cActExtension);
                break;
            }
            case 32: {
                this.actHideLayer(cActExtension);
                break;
            }
            case 33: {
                this.actSetLayerXByName(cActExtension);
                break;
            }
            case 34: {
                this.actSetLayerYByName(cActExtension);
                break;
            }
            case 35: {
                this.actSetLayerXYByName(cActExtension);
                break;
            }
            case 36: {
                this.actShowLayerByName(cActExtension);
                break;
            }
            case 37: {
                this.actHideLayerByName(cActExtension);
                break;
            }
            case 38: {
                this.actSetCurrentLayer(cActExtension);
                break;
            }
            case 39: {
                this.actSetCurrentLayerByName(cActExtension);
                break;
            }
            case 40: {
                this.actSetLayerCoefX(cActExtension);
                break;
            }
            case 41: {
                this.actSetLayerCoefY(cActExtension);
                break;
            }
            case 42: {
                this.actSetLayerCoefXByName(cActExtension);
                break;
            }
            case 43: {
                this.actSetLayerCoefYByName(cActExtension);
                break;
            }
        }
    }

    void actBackOne(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        this.actBackOneRout(n);
    }

    void actBackOneRout(int n) {
        CSprite cSprite;
        CSprite cSprite2 = this.lyrGetSprite(n);
        if (cSprite2 != null && (cSprite = cSprite2.objPrev) != null && cSprite2.sprLayer == cSprite.sprLayer) {
            this.lyrSwapThem(cSprite2, cSprite, true);
        }
    }

    void actForwardOne(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        this.actForwardOneRout(n);
    }

    void actForwardOneRout(int n) {
        CSprite cSprite;
        CSprite cSprite2 = this.lyrGetSprite(n);
        if (cSprite2 != null && (cSprite = cSprite2.objNext) != null && cSprite2.sprLayer == cSprite.sprLayer) {
            this.lyrSwapThem(cSprite2, cSprite, true);
        }
    }

    void actSwap(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        this.actSwapRout(n, n2);
    }

    void actSwapRout(int n, int n2) {
        CSprite cSprite;
        CSprite cSprite2 = this.lyrGetSprite(n);
        if (cSprite2 != null && (cSprite = this.lyrGetSprite(n2)) != null && cSprite2.sprLayer == cSprite.sprLayer) {
            this.lyrSwapThem(cSprite2, cSprite, true);
        }
    }

    void actSetObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        if (cObject != null) {
            this.holdFValue = this.lyrGetFVfromOIL(cObject.hoOiList);
        }
    }

    void actBringFront(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        this.actBringFront(n);
    }

    void actBringFront(int n) {
        CSprite cSprite;
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        if (cSpriteGen.lastSprite != null && (cSprite = this.lyrGetSprite(n)) != null) {
            CSprite cSprite2;
            while (cSprite != cSpriteGen.lastSprite && (cSprite2 = cSprite.objNext) != null && cSprite.sprLayer == cSprite2.sprLayer) {
                this.lyrSwapSpr(cSprite, cSprite2);
            }
            if ((cSprite.sprFlags & 0x80) == 0) {
                cSpriteGen.activeSprite(cSprite, 1, null);
            }
        }
    }

    void actSendBack(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        this.actSendBackRout(n);
    }

    void actSendBackRout(int n) {
        CSprite cSprite;
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        if (cSpriteGen.firstSprite != null && (cSprite = this.lyrGetSprite(n)) != null) {
            CSprite cSprite2;
            while (cSprite != cSpriteGen.firstSprite && (cSprite2 = cSprite.objPrev) != null && cSprite.sprLayer == cSprite2.sprLayer) {
                this.lyrSwapSpr(cSprite2, cSprite);
            }
            if ((cSprite.sprFlags & 0x80) == 0) {
                cSpriteGen.activeSprite(cSprite, 1, null);
            }
        }
    }

    void actBackN(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        this.actBackNRout(n, n2);
    }

    void actBackNRout(int n, int n2) {
        CSprite cSprite = this.lyrGetSprite(n);
        if (cSprite != null) {
            CSprite cSprite2;
            for (int i = 0; i < n2 && (cSprite2 = cSprite.objPrev) != null && cSprite.sprLayer == cSprite2.sprLayer; ++i) {
                this.lyrSwapThem(cSprite, cSprite2, true);
            }
        }
    }

    void actForwardN(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        this.actForwardNRout(n, n2);
    }

    void actForwardNRout(int n, int n2) {
        CSprite cSprite = this.lyrGetSprite(n);
        if (cSprite != null) {
            CSprite cSprite2;
            for (int i = 0; i < n2 && (cSprite2 = cSprite.objNext) != null && cSprite.sprLayer == cSprite2.sprLayer; ++i) {
                this.lyrSwapThem(cSprite, cSprite2, true);
            }
        }
    }

    void actReverse(CActExtension cActExtension) {
        CSprite cSprite;
        CSprite cSprite2;
        int n = this.wCurrentLayer;
        n = n * 2 + 1;
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        CSprite cSprite3 = cSpriteGen.firstSprite;
        while (cSprite3 != null && (cSprite3.sprFlags & 0x20) != 0 && cSprite3.sprLayer < n) {
            cSprite3 = cSprite3.objNext;
        }
        if (cSprite3 == null || cSprite3.sprLayer != n) {
            return;
        }
        CSprite cSprite4 = cSpriteGen.lastSprite;
        while (cSprite4 != null && (cSprite4.sprFlags & 0x20) != 0 && cSprite4.sprLayer > n) {
            cSprite4 = cSprite4.objNext;
        }
        if (cSprite4 == null || cSprite4.sprLayer != n) {
            return;
        }
        if (cSprite4 == cSprite3) {
            return;
        }
        do {
            cSprite2 = cSprite3;
            cSprite = cSprite4;
            cSprite3 = cSprite2.objNext;
            cSprite4 = cSprite.objPrev;
            this.lyrSwapThem(cSprite2, cSprite, true);
        } while (cSprite3 != cSprite4 && cSprite3 != cSprite2 && cSprite3 != cSprite);
    }

    void actMoveAbove(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        this.actMoveAboveRout(n, n2);
    }

    void actMoveAboveRout(int n, int n2) {
        CSprite cSprite;
        CSprite cSprite2 = this.lyrGetSprite(n);
        if (cSprite2 != null && (cSprite = this.lyrGetSprite(n2)) != null && cSprite2.sprLayer == cSprite.sprLayer) {
            CSprite cSprite3 = cSprite2.objNext;
            while (cSprite3 != null && cSprite3 != cSprite) {
                cSprite3 = cSprite3.objNext;
            }
            if (cSprite3 != null) {
                CSprite cSprite4;
                while ((cSprite4 = cSprite2.objNext) != null) {
                    this.lyrSwapSpr(cSprite2, cSprite4);
                    if (cSprite4 != cSprite) continue;
                }
                if ((cSprite2.sprFlags & 0x80) == 0) {
                    this.ho.hoAdRunHeader.spriteGen.activeSprite(cSprite2, 1, null);
                }
            }
        }
    }

    void actMoveBelow(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        this.actMoveBelowRout(n, n2);
    }

    void actMoveBelowRout(int n, int n2) {
        CSprite cSprite;
        CSprite cSprite2 = this.lyrGetSprite(n);
        if (cSprite2 != null && (cSprite = this.lyrGetSprite(n2)) != null && cSprite2.sprLayer == cSprite.sprLayer) {
            CSprite cSprite3 = cSprite2.objPrev;
            while (cSprite3 != null && cSprite3 != cSprite) {
                cSprite3 = cSprite3.objPrev;
            }
            if (cSprite3 != null) {
                CSprite cSprite4 = cSprite2;
                while ((cSprite4 = cSprite2.objPrev) != null) {
                    this.lyrSwapSpr(cSprite2, cSprite4);
                    if (cSprite4 != cSprite) continue;
                }
                if ((cSprite2.sprFlags & 0x80) == 0) {
                    this.ho.hoAdRunHeader.spriteGen.activeSprite(cSprite2, 1, null);
                }
            }
        }
    }

    void actMoveToN(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        this.actMoveToNRout(n, n2);
    }

    void actMoveToNRout(int n, int n2) {
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        int n3 = 0;
        CSprite cSprite = this.lyrGetSprite(n);
        if (cSprite != null) {
            CSprite cSprite2 = cSpriteGen.firstSprite;
            while (cSprite2 != null && cSprite.sprLayer != cSprite2.sprLayer) {
                cSprite2 = cSprite2.objNext;
            }
            if (cSprite2 == null || cSprite.sprLayer != cSprite2.sprLayer) {
                return;
            }
            while (cSprite2 != null && ++n3 != n2) {
                cSprite2 = cSprite2.objNext;
                if (cSprite2 == null || cSprite.sprLayer == cSprite2.sprLayer) continue;
                cSprite2 = null;
                break;
            }
            if (cSprite2 != null && cSprite != cSprite2) {
                CSprite cSprite3 = cSprite.objPrev;
                while (cSprite3 != null && cSprite3 != cSprite2) {
                    cSprite3 = cSprite3.objPrev;
                }
                if (cSprite3 != null) {
                    CSprite cSprite4 = cSprite;
                    while ((cSprite4 = cSprite.objPrev) != null) {
                        this.lyrSwapSpr(cSprite, cSprite4);
                        if (cSprite4 != cSprite2) continue;
                    }
                    if ((cSprite.sprFlags & 0x80) == 0) {
                        cSpriteGen.activeSprite(cSprite, 1, null);
                    }
                } else {
                    CSprite cSprite5;
                    while ((cSprite5 = cSprite.objNext) != null) {
                        this.lyrSwapSpr(cSprite, cSprite5);
                        if (cSprite5 != cSprite2) continue;
                    }
                    if ((cSprite.sprFlags & 0x80) == 0) {
                        cSpriteGen.activeSprite(cSprite, 1, null);
                    }
                }
            }
        }
    }

    void actSortByXUP(CActExtension cActExtension) {
        this.lyrSortBy(0, 0, 0);
    }

    void actSortByYUP(CActExtension cActExtension) {
        this.lyrSortBy(2, 0, 0);
    }

    void actSortByXDOWN(CActExtension cActExtension) {
        this.lyrSortBy(1, 0, 0);
    }

    void actSortByYDOWN(CActExtension cActExtension) {
        this.lyrSortBy(3, 0, 0);
    }

    void actBackOneObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        CObjInfo cObjInfo = cObject.hoOiList;
        if (cObject != null) {
            this.actBackOneRout(this.lyrGetFVfromOIL(cObjInfo));
        }
    }

    void actForwardOneObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        if (cObject != null) {
            this.actForwardOneRout(this.lyrGetFVfromOIL(cObject.hoOiList));
        }
    }

    void actSwapObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        CObject cObject2 = cActExtension.getParamObject(this.rh, 1);
        if (cObject != null && cObject2 != null) {
            this.actSwapRout(this.lyrGetFVfromOIL(cObject.hoOiList), this.lyrGetFVfromOIL(cObject2.hoOiList));
        }
    }

    void actBringFrontObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        if (cObject != null) {
            this.actBringFront(this.lyrGetFVfromOIL(cObject.hoOiList));
        }
    }

    void actSendBackObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        if (cObject != null) {
            this.actSendBackRout(this.lyrGetFVfromOIL(cObject.hoOiList));
        }
    }

    void actBackNObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        int n = cActExtension.getParamExpression(this.rh, 1);
        if (cObject != null) {
            this.actBackNRout(this.lyrGetFVfromOIL(cObject.hoOiList), n);
        }
    }

    void actForwardNObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        int n = cActExtension.getParamExpression(this.rh, 1);
        if (cObject != null) {
            this.actForwardNRout(this.lyrGetFVfromOIL(cObject.hoOiList), n);
        }
    }

    void actMoveAboveObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        CObject cObject2 = cActExtension.getParamObject(this.rh, 1);
        if (cObject != null && cObject2 != null) {
            this.actMoveAboveRout(this.lyrGetFVfromOIL(cObject.hoOiList), this.lyrGetFVfromOIL(cObject2.hoOiList));
        }
    }

    void actMoveBelowObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        CObject cObject2 = cActExtension.getParamObject(this.rh, 1);
        if (cObject != null && cObject2 != null) {
            this.actMoveBelowRout(this.lyrGetFVfromOIL(cObject.hoOiList), this.lyrGetFVfromOIL(cObject2.hoOiList));
        }
    }

    void actMoveToNObj(CActExtension cActExtension) {
        CObject cObject = cActExtension.getParamObject(this.rh, 0);
        int n = cActExtension.getParamExpression(this.rh, 1);
        if (cObject != null) {
            this.actMoveToNRout(this.lyrGetFVfromOIL(cObject.hoOiList), n);
        }
    }

    void actSortByALTUP(CActExtension cActExtension) {
        short s = cActExtension.getParamAltValue(this.rh, 0);
        int n = cActExtension.getParamExpression(this.rh, 1);
        this.lyrSortBy(4, n, s);
    }

    void actSortByALTDOWN(CActExtension cActExtension) {
        short s = cActExtension.getParamAltValue(this.rh, 0);
        int n = cActExtension.getParamExpression(this.rh, 1);
        this.lyrSortBy(5, n, s);
    }

    void actSetLayerX(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            int n3 = -n2;
            if (cLayer.x != n3 || cLayer.dx != 0) {
                cLayer.dx = n3 - cLayer.x;
                cLayer.dwOptions |= 0x10000;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actSetLayerY(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            int n3 = -n2;
            if (cLayer.y != n3 || cLayer.dy != 0) {
                cLayer.dy = n3 - cLayer.y;
                cLayer.dwOptions |= 0x10000;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actSetLayerXY(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        int n2 = cActExtension.getParamExpression(this.rh, 1);
        int n3 = cActExtension.getParamExpression(this.rh, 2);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if (cLayer.x != n2 || cLayer.dx != 0 || cLayer.y != n3 || cLayer.dy != 0) {
                cLayer.dx = n2 - cLayer.x;
                cLayer.dy = n3 - cLayer.y;
                cLayer.dwOptions |= 0x10000;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actShowLayer(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if ((cLayer.dwOptions & 0x10) == 0) {
                cLayer.dwOptions |= 0x50000;
                cLayer.dwOptions &= 0xFFFDFFFF;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actHideLayer(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if ((cLayer.dwOptions & 0x10) != 0) {
                cLayer.dwOptions |= 0x30000;
                cLayer.dwOptions &= 0xFFFBFFFF;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actSetLayerXByName(CActExtension cActExtension) {
        String string = cActExtension.getParamExpString(this.rh, 0);
        int n = cActExtension.getParamExpression(this.rh, 1);
        int n2 = this.FindLayerByName(string);
        if (n2 > 0 && n2 <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n2 - 1];
            int n3 = -n;
            if (cLayer.x != n3 || cLayer.dx != 0) {
                cLayer.dx = n3 - cLayer.x;
                cLayer.dwOptions |= 0x10000;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actSetLayerYByName(CActExtension cActExtension) {
        String string = cActExtension.getParamExpString(this.rh, 0);
        int n = cActExtension.getParamExpression(this.rh, 1);
        int n2 = this.FindLayerByName(string);
        if (n2 > 0 && n2 <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n2 - 1];
            int n3 = -n;
            if (cLayer.y != n3 || cLayer.dy != 0) {
                cLayer.dy = n3 - cLayer.y;
                cLayer.dwOptions |= 0x10000;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actSetLayerXYByName(CActExtension cActExtension) {
        String string = cActExtension.getParamExpString(this.rh, 0);
        int n = cActExtension.getParamExpression(this.rh, 1);
        int n2 = cActExtension.getParamExpression(this.rh, 2);
        int n3 = this.FindLayerByName(string);
        if (n3 > 0 && n3 <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n3 - 1];
            if (cLayer.x != n || cLayer.dx != 0 || cLayer.y != n2 || cLayer.dy != 0) {
                cLayer.dx = n - cLayer.x;
                cLayer.dy = n2 - cLayer.y;
                cLayer.dwOptions |= 0x10000;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actShowLayerByName(CActExtension cActExtension) {
        String string = cActExtension.getParamExpString(this.rh, 0);
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if ((cLayer.dwOptions & 0x10) == 0) {
                cLayer.dwOptions |= 0x50000;
                cLayer.dwOptions &= 0xFFFDFFFF;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actHideLayerByName(CActExtension cActExtension) {
        String string = cActExtension.getParamExpString(this.rh, 0);
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if ((cLayer.dwOptions & 0x10) != 0) {
                cLayer.dwOptions |= 0x30000;
                cLayer.dwOptions &= 0xFFFBFFFF;
                this.ho.hoAdRunHeader.rh3Scrolling = (char)(this.ho.hoAdRunHeader.rh3Scrolling | 2);
            }
        }
    }

    void actSetCurrentLayer(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            this.wCurrentLayer = n - 1;
        }
    }

    void actSetCurrentLayerByName(CActExtension cActExtension) {
        String string = cActExtension.getParamExpString(this.rh, 0);
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            this.wCurrentLayer = n - 1;
        }
    }

    void actSetLayerCoefX(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        float f = (float)cActExtension.getParamExpDouble(this.rh, 1);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if (cLayer.xCoef != f) {
                cLayer.xCoef = f;
                cLayer.dwOptions &= 0xFFFFFFFE;
                if (f != 1.0f) {
                    cLayer.dwOptions |= 1;
                }
            }
        }
    }

    void actSetLayerCoefY(CActExtension cActExtension) {
        int n = cActExtension.getParamExpression(this.rh, 0);
        float f = (float)cActExtension.getParamExpDouble(this.rh, 1);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if (cLayer.yCoef != f) {
                cLayer.yCoef = f;
                cLayer.dwOptions &= 0xFFFFFFFD;
                if (f != 1.0f) {
                    cLayer.dwOptions |= 2;
                }
            }
        }
    }

    void actSetLayerCoefXByName(CActExtension cActExtension) {
        String string = cActExtension.getParamExpString(this.rh, 0);
        float f = (float)cActExtension.getParamExpDouble(this.rh, 1);
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if (cLayer.xCoef != f) {
                cLayer.xCoef = f;
                cLayer.dwOptions &= 0xFFFFFFFE;
                if (f != 1.0f) {
                    cLayer.dwOptions |= 1;
                }
            }
        }
    }

    void actSetLayerCoefYByName(CActExtension cActExtension) {
        String string = cActExtension.getParamExpString(this.rh, 0);
        float f = (float)cActExtension.getParamExpDouble(this.rh, 1);
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            if (cLayer.yCoef != f) {
                cLayer.yCoef = f;
                cLayer.dwOptions &= 0xFFFFFFFD;
                if (f != 1.0f) {
                    cLayer.dwOptions |= 2;
                }
            }
        }
    }

    public CValue expression(int n) {
        switch (n) {
            case 0: {
                return this.expGetFV();
            }
            case 1: {
                return this.expGetTopFV();
            }
            case 2: {
                return this.expGetBottomFV();
            }
            case 3: {
                return this.expGetDesc();
            }
            case 4: {
                return this.expGetDesc10();
            }
            case 5: {
                return this.expGetNumLevels();
            }
            case 6: {
                return this.expGetLevel();
            }
            case 7: {
                return this.expGetLevelFV();
            }
            case 8: {
                return this.expGetLayerX();
            }
            case 9: {
                return this.expGetLayerY();
            }
            case 10: {
                return this.expGetLayerXByName();
            }
            case 11: {
                return this.expGetLayerYByName();
            }
            case 12: {
                return this.expGetLayerCount();
            }
            case 13: {
                return this.expGetLayerName();
            }
            case 14: {
                return this.expGetLayerIndex();
            }
            case 15: {
                return this.expGetCurrentLayer();
            }
            case 16: {
                return this.expGetLayerCoefX();
            }
            case 17: {
                return this.expGetLayerCoefY();
            }
            case 18: {
                return this.expGetLayerCoefXByName();
            }
            case 19: {
                return this.expGetLayerCoefYByName();
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return this.expZeroOneParam();
            }
        }
        return null;
    }

    CValue expZeroOneParam() {
        this.ho.getExpParam();
        return new CValue(0);
    }

    CValue expGetFV() {
        int n = 0;
        String string = this.ho.getExpParam().getString();
        if (string.length() == 0) {
            return new CValue(this.holdFValue);
        }
        int n2 = 0;
        for (int i = 0; i < this.ho.hoAdRunHeader.rhNObjects; ++i) {
            while (this.ho.hoAdRunHeader.rhObjectList[n2] == null) {
                ++n2;
            }
            CObject cObject = this.ho.hoAdRunHeader.rhObjectList[n2];
            ++n2;
            CObjInfo cObjInfo = cObject.hoOiList;
            if (!string.equalsIgnoreCase(cObjInfo.oilName)) continue;
            n = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
            CSprite cSprite = this.lyrGetSprite(n);
            if ((cSprite.sprFlags & 0x20) == 0) break;
            n = 0;
        }
        return new CValue(n);
    }

    CValue expGetTopFV() {
        int n = this.wCurrentLayer;
        n = n * 2 + 1;
        CSprite cSprite = this.ho.hoAdRunHeader.spriteGen.lastSprite;
        while (cSprite != null && cSprite.sprLayer >= n) {
            if (cSprite.sprLayer == n && (cSprite.sprFlags & 0x20) == 0) {
                CObject cObject = cSprite.sprExtraInfo;
                return new CValue((cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF));
            }
            cSprite = cSprite.objPrev;
        }
        return new CValue(0);
    }

    CValue expGetBottomFV() {
        int n = this.wCurrentLayer;
        n = n * 2 + 1;
        CSprite cSprite = this.ho.hoAdRunHeader.spriteGen.firstSprite;
        while (cSprite != null && cSprite.sprLayer <= n) {
            if (cSprite.sprLayer == n && (cSprite.sprFlags & 0x20) == 0) {
                CObject cObject = cSprite.sprExtraInfo;
                return new CValue((cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF));
            }
            cSprite = cSprite.objNext;
        }
        return new CValue(0);
    }

    CValue expGetDesc() {
        int n = this.ho.getExpParam().getInt();
        String string = this.lyrGetList(n, 1);
        return new CValue(string);
    }

    CValue expGetDesc10() {
        int n = this.ho.getExpParam().getInt();
        String string = this.lyrGetList(n, 10);
        return new CValue(string);
    }

    CValue expGetNumLevels() {
        int n = this.wCurrentLayer;
        n = n * 2 + 1;
        int n2 = 0;
        CSprite cSprite = this.ho.hoAdRunHeader.spriteGen.firstSprite;
        while (cSprite != null && cSprite.sprLayer <= n) {
            if (cSprite.sprLayer == n && (cSprite.sprFlags & 0x20) == 0) {
                ++n2;
            }
            cSprite = cSprite.objNext;
        }
        return new CValue(n2);
    }

    CValue expGetLevel() {
        short s = -1;
        int n = 1;
        int n2 = 0;
        int n3 = this.ho.getExpParam().getInt();
        if (n3 == 0) {
            n3 = this.holdFValue;
        }
        CSprite cSprite = this.ho.hoAdRunHeader.spriteGen.firstSprite;
        while (cSprite != null) {
            if ((cSprite.sprLayer & 1) != 0) {
                if (s != cSprite.sprLayer) {
                    s = cSprite.sprLayer;
                    n = 1;
                }
                if ((cSprite.sprFlags & 0x20) == 0) {
                    CObject cObject = cSprite.sprExtraInfo;
                    CObjInfo cObjInfo = cObject.hoOiList;
                    n2 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
                    if (n3 == n2) {
                        return new CValue(n);
                    }
                    ++n;
                }
            }
            cSprite = cSprite.objNext;
        }
        return new CValue(0);
    }

    CValue expGetLevelFV() {
        int n = this.wCurrentLayer * 2 + 1;
        int n2 = 1;
        int n3 = 0;
        int n4 = this.ho.getExpParam().getInt();
        CSprite cSprite = this.ho.hoAdRunHeader.spriteGen.firstSprite;
        while (cSprite != null && cSprite.sprLayer <= n) {
            if (cSprite.sprLayer == n && n4 == n2++) {
                if ((cSprite.sprFlags & 0x20) == 0) {
                    CObject cObject = cSprite.sprExtraInfo;
                    CObjInfo cObjInfo = cObject.hoOiList;
                    n3 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
                    break;
                }
                --n2;
            }
            cSprite = cSprite.objNext;
        }
        return new CValue(n3);
    }

    CValue expGetLayerX() {
        int n = this.ho.getExpParam().getInt();
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(-(cLayer.x + cLayer.dx));
        }
        return new CValue(0);
    }

    CValue expGetLayerY() {
        int n = this.ho.getExpParam().getInt();
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(-(cLayer.y + cLayer.dy));
        }
        return new CValue(0);
    }

    CValue expGetLayerXByName() {
        String string = this.ho.getExpParam().getString();
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(-(cLayer.x + cLayer.dx));
        }
        return new CValue(0);
    }

    CValue expGetLayerYByName() {
        String string = this.ho.getExpParam().getString();
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(-(cLayer.y + cLayer.dy));
        }
        return new CValue(0);
    }

    CValue expGetLayerCount() {
        return new CValue(this.ho.hoAdRunHeader.rhFrame.nLayers);
    }

    CValue expGetLayerName() {
        int n = this.ho.getExpParam().getInt();
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(cLayer.pName);
        }
        return new CValue("");
    }

    CValue expGetLayerIndex() {
        String string = this.ho.getExpParam().getString();
        return new CValue(this.FindLayerByName(string));
    }

    CValue expGetCurrentLayer() {
        return new CValue(this.wCurrentLayer + 1);
    }

    CValue expGetLayerCoefX() {
        int n = this.ho.getExpParam().getInt();
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(cLayer.xCoef);
        }
        return new CValue(0);
    }

    CValue expGetLayerCoefY() {
        int n = this.ho.getExpParam().getInt();
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(cLayer.yCoef);
        }
        return new CValue(0);
    }

    CValue expGetLayerCoefXByName() {
        String string = this.ho.getExpParam().getString();
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(cLayer.xCoef);
        }
        return new CValue(0);
    }

    CValue expGetLayerCoefYByName() {
        String string = this.ho.getExpParam().getString();
        int n = this.FindLayerByName(string);
        if (n > 0 && n <= this.ho.hoAdRunHeader.rhFrame.nLayers) {
            CLayer cLayer = this.ho.hoAdRunHeader.rhFrame.layers[n - 1];
            return new CValue(cLayer.yCoef);
        }
        return new CValue(0);
    }

    void lyrSwapSpr(CSprite cSprite, CSprite cSprite2) {
        if (cSprite == cSprite2) {
            return;
        }
        if (cSprite.sprLayer != cSprite2.sprLayer) {
            return;
        }
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        CSprite cSprite3 = cSprite.objPrev;
        CSprite cSprite4 = cSprite.objNext;
        CSprite cSprite5 = cSprite2.objPrev;
        CSprite cSprite6 = cSprite2.objNext;
        int n = cSprite.sprZOrder;
        cSprite.sprZOrder = cSprite2.sprZOrder;
        cSprite2.sprZOrder = n;
        if (cSprite4 == cSprite2) {
            if (cSprite3 != null) {
                cSprite3.objNext = cSprite2;
            }
            cSprite2.objPrev = cSprite3;
            cSprite2.objNext = cSprite;
            cSprite.objPrev = cSprite2;
            cSprite.objNext = cSprite6;
            if (cSprite6 != null) {
                cSprite6.objPrev = cSprite;
            }
            if (cSprite3 == null) {
                cSpriteGen.firstSprite = cSprite2;
            }
            if (cSprite6 == null) {
                cSpriteGen.lastSprite = cSprite;
            }
        } else if (cSprite6 == cSprite) {
            if (cSprite5 != null) {
                cSprite5.objNext = cSprite;
            }
            cSprite.objPrev = cSprite5;
            cSprite.objNext = cSprite2;
            cSprite2.objPrev = cSprite;
            cSprite2.objNext = cSprite4;
            if (cSprite4 != null) {
                cSprite4.objPrev = cSprite2;
            }
            if (cSprite5 == null) {
                cSpriteGen.firstSprite = cSprite;
            }
            if (cSprite4 == null) {
                cSpriteGen.lastSprite = cSprite2;
            }
        } else {
            if (cSprite3 != null) {
                cSprite3.objNext = cSprite2;
            }
            if (cSprite4 != null) {
                cSprite4.objPrev = cSprite2;
            }
            cSprite.objPrev = cSprite5;
            cSprite.objNext = cSprite6;
            if (cSprite5 != null) {
                cSprite5.objNext = cSprite;
            }
            if (cSprite6 != null) {
                cSprite6.objPrev = cSprite;
            }
            cSprite2.objPrev = cSprite3;
            cSprite2.objNext = cSprite4;
            if (cSprite3 == null) {
                cSpriteGen.firstSprite = cSprite2;
            }
            if (cSprite5 == null) {
                cSpriteGen.firstSprite = cSprite;
            }
            if (cSprite4 == null) {
                cSpriteGen.lastSprite = cSprite2;
            }
            if (cSprite6 == null) {
                cSpriteGen.lastSprite = cSprite;
            }
        }
    }

    boolean lyrSwapThem(CSprite cSprite, CSprite cSprite2, boolean bl) {
        this.lyrSwapSpr(cSprite, cSprite2);
        if (bl) {
            if ((cSprite.sprFlags & 0x80) == 0) {
                this.ho.hoAdRunHeader.spriteGen.activeSprite(cSprite, 1, null);
            }
            if ((cSprite2.sprFlags & 0x80) == 0) {
                this.ho.hoAdRunHeader.spriteGen.activeSprite(cSprite2, 1, null);
            }
        }
        return true;
    }

    CSprite lyrGetSprite(int n) {
        if (n == 0) {
            n = this.holdFValue;
        }
        int n2 = 0;
        for (int i = 0; i < this.ho.hoAdRunHeader.rhNObjects; ++i) {
            while (this.ho.hoAdRunHeader.rhObjectList[n2] == null) {
                ++n2;
            }
            CObject cObject = this.ho.hoAdRunHeader.rhObjectList[n2];
            ++n2;
            int n3 = (cObject.hoCreationId << 16) + cObject.hoNumber;
            if (n != n3) continue;
            return cObject.roc.rcSprite;
        }
        return null;
    }

    CObject lyrGetROfromFV(long l) {
        if (l == 0L) {
            l = this.holdFValue;
        }
        int n = 0;
        for (int i = 0; i < this.ho.hoAdRunHeader.rhNObjects; ++i) {
            while (this.ho.hoAdRunHeader.rhObjectList[n] == null) {
                ++n;
            }
            CObject cObject = this.ho.hoAdRunHeader.rhObjectList[n];
            ++n;
            int n2 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
            if (l != (long)n2) continue;
            return cObject;
        }
        return null;
    }

    boolean lyrSortBy(int n, int n2, int n3) {
        int n4;
        CSortData cSortData;
        int n5 = this.wCurrentLayer;
        n5 = n5 * 2 + 1;
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        CSprite cSprite = cSpriteGen.firstSprite;
        while (cSprite != null && ((cSprite.sprFlags & 0x20) != 0 || cSprite.sprLayer < n5)) {
            cSprite = cSprite.objNext;
        }
        if (cSprite == null || cSprite.sprLayer != n5) {
            return false;
        }
        CSprite cSprite2 = cSpriteGen.lastSprite;
        while (cSprite2 != null && ((cSprite2.sprFlags & 0x20) != 0 || cSprite2.sprLayer > n5)) {
            cSprite2 = cSprite2.objPrev;
        }
        if (cSprite2 == null || cSprite2.sprLayer != n5) {
            return false;
        }
        if (cSprite == cSprite2) {
            return false;
        }
        CSprite cSprite3 = cSprite;
        CArrayList cArrayList = new CArrayList();
        int n6 = 0;
        while (cSprite3 != null) {
            cSortData = new CSortData();
            cSortData.indexSprite = cSprite3;
            cSortData.cmpFlag = n;
            if ((cSprite3.sprFlags & 0x20) == 0) {
                CObject cObject = cSprite3.sprExtraInfo;
                cSortData.sprX = cObject.hoX;
                cSortData.sprY = cObject.hoY;
                cSortData.sprAlt = n2;
                if (cObject.rov != null && cObject.rov.rvValues[n3] != null) {
                    cSortData.sprAlt = cObject.rov.rvValues[n3].type == 0 ? cObject.rov.rvValues[n3].intValue : (int)cObject.rov.rvValues[n3].doubleValue;
                }
            } else {
                cSortData.sprX = cSprite3.sprX;
                cSortData.sprY = cSprite3.sprY;
                cSortData.sprAlt = n2;
            }
            cArrayList.add(cSortData);
            if ((cSprite3.sprFlags & 0x90) == 0) {
                cSpriteGen.activeSprite(cSprite3, 1, null);
            }
            if (cSprite3 == cSprite2) break;
            cSprite3 = cSprite3.objNext;
            ++n6;
        }
        int n7 = 0;
        do {
            n7 = 0;
            for (n4 = 0; n4 < cArrayList.size() - 1; ++n4) {
                if (!this.isGreater((CSortData)cArrayList.get(n4), (CSortData)cArrayList.get(n4 + 1))) continue;
                cSortData = (CSortData)cArrayList.get(n4 + 1);
                cArrayList.set(n4 + 1, (CSortData)cArrayList.get(n4));
                cArrayList.set(n4, cSortData);
                ++n7;
            }
        } while (n7 != 0);
        CSprite cSprite4 = null;
        if (cSprite != cSpriteGen.firstSprite) {
            cSprite4 = cSprite.objPrev;
        }
        CSprite cSprite5 = null;
        if (cSprite2 != cSpriteGen.lastSprite) {
            cSprite5 = cSprite2.objNext;
        }
        for (n4 = 0; n4 < cArrayList.size(); ++n4) {
            CSprite cSprite6 = ((CSortData)cArrayList.get((int)n4)).indexSprite;
            cSpriteGen.activeSprite(cSprite6, 1, null);
            if (n4 == 0) {
                if (cSprite4 == null) {
                    cSpriteGen.firstSprite = cSprite6;
                    cSprite6.objPrev = null;
                    cSprite6.objNext = ((CSortData)cArrayList.get((int)(n4 + 1))).indexSprite;
                    continue;
                }
                cSprite6.objPrev = cSprite4;
                cSprite4.objNext = cSprite6;
                cSprite6.objNext = ((CSortData)cArrayList.get((int)(n4 + 1))).indexSprite;
                continue;
            }
            cSprite6.objPrev = ((CSortData)cArrayList.get((int)(n4 - 1))).indexSprite;
            if (n4 + 1 == cArrayList.size()) {
                if (cSprite5 == null) {
                    cSprite6.objNext = null;
                    cSpriteGen.lastSprite = ((CSortData)cArrayList.get((int)n4)).indexSprite;
                    continue;
                }
                cSprite6.objNext = cSprite5;
                cSprite5.objPrev = cSprite6;
                continue;
            }
            cSprite6.objNext = ((CSortData)cArrayList.get((int)(n4 + 1))).indexSprite;
        }
        return false;
    }

    boolean isGreater(CSortData cSortData, CSortData cSortData2) {
        CSprite cSprite = cSortData.indexSprite;
        CSprite cSprite2 = cSortData2.indexSprite;
        if (cSprite.sprLayer != cSprite2.sprLayer) {
            return cSprite.sprLayer > cSprite2.sprLayer;
        }
        switch (cSortData.cmpFlag) {
            case 0: {
                return cSortData.sprX < cSortData2.sprX;
            }
            case 1: {
                return cSortData.sprX > cSortData2.sprX;
            }
            case 2: {
                return cSortData.sprY < cSortData2.sprY;
            }
            case 3: {
                return cSortData.sprY > cSortData2.sprY;
            }
            case 4: {
                return cSortData.sprAlt < cSortData2.sprAlt;
            }
            case 5: {
                return cSortData.sprAlt > cSortData2.sprAlt;
            }
        }
        return false;
    }

    String lyrGetList(int n, int n2) {
        String string = new String("Lvl\tName\tFV\n\n");
        int n3 = this.wCurrentLayer;
        n3 = n3 * 2 + 1;
        CSpriteGen cSpriteGen = this.ho.hoAdRunHeader.spriteGen;
        int n4 = 0;
        int n5 = 0;
        CSprite cSprite = cSpriteGen.firstSprite;
        while (cSprite != null && (cSprite.sprFlags & 0x20) != 0 && cSprite.sprLayer < n3) {
            cSprite = cSprite.objNext;
        }
        if (cSprite != null && cSprite.sprLayer == n3) {
            while (cSprite != null && cSprite.sprLayer == n3 && ++n5 < n + n2) {
                if (n5 >= n) {
                    if ((cSprite.sprFlags & 0x20) == 0) {
                        CObject cObject = cSprite.sprExtraInfo;
                        CObjInfo cObjInfo = cObject.hoOiList;
                        n4 = (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
                        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n5));
                        stringBuffer.append("\t");
                        stringBuffer.append(cObjInfo.oilName);
                        stringBuffer.append("\t");
                        stringBuffer.append(Integer.toString(n4));
                        stringBuffer.append("\n");
                        string = string + stringBuffer;
                    } else {
                        --n5;
                    }
                }
                cSprite = cSprite.objNext;
            }
        }
        return string;
    }

    int lyrGetFVfromEVP(PARAM_OBJECT pARAM_OBJECT) {
        CObject cObject;
        CObjInfo cObjInfo = this.ho.hoAdRunHeader.rhOiList[pARAM_OBJECT.oiList];
        if (cObjInfo.oilCurrentOi != -1) {
            cObject = this.ho.hoAdRunHeader.rhObjectList[cObjInfo.oilCurrentOi];
        } else if (cObjInfo.oilObject >= 0) {
            cObject = this.ho.hoAdRunHeader.rhObjectList[cObjInfo.oilObject];
        } else {
            return 0;
        }
        return (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
    }

    CObject lyrGetROfromEVP(PARAM_OBJECT pARAM_OBJECT) {
        CObjInfo cObjInfo = this.ho.hoAdRunHeader.rhOiList[pARAM_OBJECT.oiList];
        if (cObjInfo.oilEventCount == this.ho.hoAdRunHeader.rhEvtProg.rh2EventCount) {
            return this.ho.hoAdRunHeader.rhObjectList[cObjInfo.oilListSelected];
        }
        if (cObjInfo.oilObject >= 0) {
            return this.ho.hoAdRunHeader.rhObjectList[cObjInfo.oilObject];
        }
        return null;
    }

    CObjInfo lyrGetOILfromEVP(PARAM_OBJECT pARAM_OBJECT) {
        if (pARAM_OBJECT.oiList < 0) {
            return null;
        }
        return this.ho.hoAdRunHeader.rhOiList[pARAM_OBJECT.oiList];
    }

    int lyrGetFVfromOIL(CObjInfo cObjInfo) {
        CObject cObject;
        if (cObjInfo.oilEventCount == this.ho.hoAdRunHeader.rhEvtProg.rh2EventCount) {
            cObject = this.ho.hoAdRunHeader.rhObjectList[cObjInfo.oilListSelected];
        } else if (cObjInfo.oilObject >= 0) {
            cObject = this.ho.hoAdRunHeader.rhObjectList[cObjInfo.oilObject];
        } else {
            return 0;
        }
        return (cObject.hoCreationId << 16) + (cObject.hoNumber & 0xFFFF);
    }

    void lyrResetEventList(CObjInfo cObjInfo) {
        if (cObjInfo.oilEventCount == this.ho.hoAdRunHeader.rhEvtProg.rh2EventCount) {
            cObjInfo.oilEventCount = -1;
        }
    }

    boolean lyrProcessCondition(PARAM_OBJECT pARAM_OBJECT, PARAM_OBJECT pARAM_OBJECT2, int n) {
        CObject cObject;
        CObjInfo cObjInfo = this.lyrGetOILfromEVP(pARAM_OBJECT);
        if (cObjInfo == null) {
            return false;
        }
        CObject cObject2 = this.lyrGetROfromEVP(pARAM_OBJECT);
        if (cObject2 == null) {
            return false;
        }
        CObjInfo cObjInfo2 = null;
        CObject cObject3 = null;
        if (pARAM_OBJECT2 != null) {
            cObjInfo2 = this.lyrGetOILfromEVP(pARAM_OBJECT2);
            cObject3 = this.lyrGetROfromEVP(pARAM_OBJECT2);
            if (cObject3 == null) {
                return false;
            }
        }
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        int n6 = 0;
        if (cObjInfo.oilEventCount == this.ho.hoAdRunHeader.rhEvtProg.rh2EventCount) {
            if (pARAM_OBJECT2 != null) {
                n4 = this.lyrGetFVfromOIL(this.lyrGetOILfromEVP(pARAM_OBJECT));
                for (int n7 = 1; n7 <= cObjInfo.oilNumOfSelected; n7 = (int)((short)(n7 + 1))) {
                    boolean bl2;
                    int n8;
                    boolean bl3 = false;
                    n5 = this.lyrGetFVfromOIL(this.lyrGetOILfromEVP(pARAM_OBJECT2));
                    if (cObjInfo2.oilEventCount == this.ho.hoAdRunHeader.rhEvtProg.rh2EventCount) {
                        n8 = cObjInfo2.oilNumOfSelected;
                        bl2 = true;
                    } else {
                        n8 = cObjInfo2.oilNObjects;
                        bl2 = false;
                    }
                    for (int n9 = 1; n9 <= n8; n9 = (int)((short)(n9 + 1))) {
                        boolean bl4 = this.doCondition(n, n4, n5);
                        if (bl4) {
                            bl3 = true;
                        }
                        if (bl2) {
                            if (cObject3.hoNextSelected <= -1) continue;
                            cObject3 = this.ho.hoAdRunHeader.rhObjectList[cObject3.hoNextSelected];
                            n5 = (cObject3.hoCreationId << 16) + (cObject3.hoNumber & 0xFFFF);
                            continue;
                        }
                        if (cObject3.hoNumNext <= -1) continue;
                        cObject3 = this.ho.hoAdRunHeader.rhObjectList[cObject3.hoNumNext];
                        n5 = (cObject3.hoCreationId << 16) + (cObject3.hoNumber & 0xFFFF);
                    }
                    if (bl3) {
                        bl = true;
                        n3 = (short)(n3 + 1);
                        if (n2 == -1) {
                            n2 = cObject2.hoNumber;
                        } else {
                            cObject = this.ho.hoAdRunHeader.rhObjectList[n6];
                            cObject.hoNextSelected = cObject2.hoNumber;
                        }
                        n6 = cObject2.hoNumber;
                    }
                    if (cObject2.hoNextSelected <= -1) continue;
                    cObject2 = this.ho.hoAdRunHeader.rhObjectList[cObject2.hoNextSelected];
                    n4 = (cObject2.hoCreationId << 16) + (cObject2.hoNumber & 0xFFFF);
                }
            } else {
                n4 = this.lyrGetFVfromOIL(this.lyrGetOILfromEVP(pARAM_OBJECT));
                for (int n10 = 1; n10 <= cObjInfo.oilNumOfSelected; n10 = (int)((short)(n10 + 1))) {
                    boolean bl5 = false;
                    boolean bl6 = this.doCondition(n, n4, n5);
                    if (bl6) {
                        bl = true;
                        n3 = (short)(n3 + 1);
                        if (n2 == -1) {
                            n2 = cObject2.hoNumber;
                        } else {
                            cObject = this.ho.hoAdRunHeader.rhObjectList[n6];
                            cObject.hoNextSelected = cObject2.hoNumber;
                        }
                        n6 = cObject2.hoNumber;
                    }
                    if (cObject2.hoNextSelected <= -1) continue;
                    cObject2 = this.ho.hoAdRunHeader.rhObjectList[cObject2.hoNextSelected];
                    n4 = (cObject2.hoCreationId << 16) + (cObject2.hoNumber & 0xFFFF);
                }
            }
        } else if (pARAM_OBJECT2 != null) {
            n4 = this.lyrGetFVfromOIL(this.lyrGetOILfromEVP(pARAM_OBJECT));
            for (int n11 = 1; n11 <= cObjInfo.oilNObjects; n11 = (int)((short)(n11 + 1))) {
                boolean bl7;
                int n12;
                boolean bl8 = false;
                n5 = this.lyrGetFVfromOIL(this.lyrGetOILfromEVP(pARAM_OBJECT2));
                if (cObjInfo2.oilEventCount == this.ho.hoAdRunHeader.rhEvtProg.rh2EventCount) {
                    n12 = cObjInfo2.oilNumOfSelected;
                    bl7 = true;
                } else {
                    n12 = cObjInfo2.oilNObjects;
                    bl7 = false;
                }
                for (int n13 = 1; n13 <= n12; n13 = (int)((short)(n13 + 1))) {
                    boolean bl9 = this.doCondition(n, n4, n5);
                    if (bl9) {
                        bl8 = true;
                    }
                    if (bl7) {
                        if (cObject3.hoNextSelected <= -1) continue;
                        cObject3 = this.ho.hoAdRunHeader.rhObjectList[cObject3.hoNextSelected];
                        n5 = (cObject3.hoCreationId << 16) + (cObject3.hoNumber & 0xFFFF);
                        continue;
                    }
                    if (cObject3.hoNumNext <= -1) continue;
                    cObject3 = this.ho.hoAdRunHeader.rhObjectList[cObject3.hoNumNext];
                    n5 = (cObject3.hoCreationId << 16) + (cObject3.hoNumber & 0xFFFF);
                }
                if (bl8) {
                    bl = true;
                    n3 = (short)(n3 + 1);
                    if (n2 == -1) {
                        n2 = cObject2.hoNumber;
                    } else {
                        cObject = this.ho.hoAdRunHeader.rhObjectList[n6];
                        cObject.hoNextSelected = cObject2.hoNumber;
                    }
                    n6 = cObject2.hoNumber;
                }
                if (cObject2.hoNumNext <= -1) continue;
                cObject2 = this.ho.hoAdRunHeader.rhObjectList[cObject2.hoNumNext];
                n4 = (cObject2.hoCreationId << 16) + cObject2.hoNumber;
            }
        } else {
            n4 = this.lyrGetFVfromOIL(this.lyrGetOILfromEVP(pARAM_OBJECT));
            for (int n14 = 1; n14 <= cObjInfo.oilNObjects; n14 = (int)((short)(n14 + 1))) {
                boolean bl10 = false;
                boolean bl11 = this.doCondition(n, n4, n5);
                if (bl11) {
                    bl = true;
                    n3 = (short)(n3 + 1);
                    if (n2 == -1) {
                        n2 = cObject2.hoNumber;
                    } else {
                        cObject = this.ho.hoAdRunHeader.rhObjectList[n6];
                        cObject.hoNextSelected = cObject2.hoNumber;
                    }
                    n6 = cObject2.hoNumber;
                }
                if (cObject2.hoNumNext <= -1) continue;
                cObject2 = this.ho.hoAdRunHeader.rhObjectList[cObject2.hoNumNext];
                n4 = (cObject2.hoCreationId << 16) + (cObject2.hoNumber & 0xFFFF);
            }
        }
        cObjInfo.oilListSelected = (short)n2;
        cObjInfo.oilNumOfSelected = n3;
        if (bl) {
            cObjInfo.oilEventCount = this.ho.hoAdRunHeader.rhEvtProg.rh2EventCount;
            cObject = this.ho.hoAdRunHeader.rhObjectList[n6];
            cObject.hoNextSelected = Short.MIN_VALUE;
        }
        return bl;
    }

    boolean doCondition(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                return this.cndAtBackRout(n2);
            }
            case 1: {
                return this.cndAtFrontRout(n2);
            }
            case 2: {
                return this.cndAboveRout(n2, n3);
            }
            case 3: {
                return this.cndBelowRout(n2, n3);
            }
        }
        return false;
    }
}

